<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$job_card_hs_list = new job_card_hs_list();

// Run the page
$job_card_hs_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$job_card_hs_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$job_card_hs->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fjob_card_hslist = currentForm = new ew.Form("fjob_card_hslist", "list");
fjob_card_hslist.formKeyCountName = '<?php echo $job_card_hs_list->FormKeyCountName ?>';

// Form_CustomValidate event
fjob_card_hslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjob_card_hslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjob_card_hslist.lists["x_works"] = <?php echo $job_card_hs_list->works->Lookup->toClientList() ?>;
fjob_card_hslist.lists["x_works"].options = <?php echo JsonEncode($job_card_hs_list->works->lookupOptions()) ?>;
fjob_card_hslist.lists["x_jc_no_fp"] = <?php echo $job_card_hs_list->jc_no_fp->Lookup->toClientList() ?>;
fjob_card_hslist.lists["x_jc_no_fp"].options = <?php echo JsonEncode($job_card_hs_list->jc_no_fp->lookupOptions()) ?>;
fjob_card_hslist.lists["x_batch_no"] = <?php echo $job_card_hs_list->batch_no->Lookup->toClientList() ?>;
fjob_card_hslist.lists["x_batch_no"].options = <?php echo JsonEncode($job_card_hs_list->batch_no->lookupOptions()) ?>;
fjob_card_hslist.lists["x_employee_id"] = <?php echo $job_card_hs_list->employee_id->Lookup->toClientList() ?>;
fjob_card_hslist.lists["x_employee_id"].options = <?php echo JsonEncode($job_card_hs_list->employee_id->lookupOptions()) ?>;
fjob_card_hslist.autoSuggests["x_employee_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var fjob_card_hslistsrch = currentSearchForm = new ew.Form("fjob_card_hslistsrch");

// Filters
fjob_card_hslistsrch.filterList = <?php echo $job_card_hs_list->getFilterList() ?>;

// Init search panel as collapsed
fjob_card_hslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$job_card_hs->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($job_card_hs_list->TotalRecs > 0 && $job_card_hs_list->ExportOptions->visible()) { ?>
<?php $job_card_hs_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($job_card_hs_list->ImportOptions->visible()) { ?>
<?php $job_card_hs_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($job_card_hs_list->SearchOptions->visible()) { ?>
<?php $job_card_hs_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($job_card_hs_list->FilterOptions->visible()) { ?>
<?php $job_card_hs_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$job_card_hs_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$job_card_hs->isExport() && !$job_card_hs->CurrentAction) { ?>
<form name="fjob_card_hslistsrch" id="fjob_card_hslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($job_card_hs_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fjob_card_hslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="job_card_hs">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($job_card_hs_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($job_card_hs_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $job_card_hs_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($job_card_hs_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($job_card_hs_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($job_card_hs_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($job_card_hs_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $job_card_hs_list->showPageHeader(); ?>
<?php
$job_card_hs_list->showMessage();
?>
<?php if ($job_card_hs_list->TotalRecs > 0 || $job_card_hs->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($job_card_hs_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> job_card_hs">
<?php if (!$job_card_hs->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$job_card_hs->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($job_card_hs_list->Pager)) $job_card_hs_list->Pager = new PrevNextPager($job_card_hs_list->StartRec, $job_card_hs_list->DisplayRecs, $job_card_hs_list->TotalRecs, $job_card_hs_list->AutoHidePager) ?>
<?php if ($job_card_hs_list->Pager->RecordCount > 0 && $job_card_hs_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($job_card_hs_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $job_card_hs_list->pageUrl() ?>start=<?php echo $job_card_hs_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($job_card_hs_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $job_card_hs_list->pageUrl() ?>start=<?php echo $job_card_hs_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $job_card_hs_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($job_card_hs_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $job_card_hs_list->pageUrl() ?>start=<?php echo $job_card_hs_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($job_card_hs_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $job_card_hs_list->pageUrl() ?>start=<?php echo $job_card_hs_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $job_card_hs_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($job_card_hs_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $job_card_hs_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $job_card_hs_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $job_card_hs_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($job_card_hs_list->TotalRecs > 0 && (!$job_card_hs_list->AutoHidePageSizeSelector || $job_card_hs_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="job_card_hs">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($job_card_hs_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($job_card_hs_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($job_card_hs_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($job_card_hs_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($job_card_hs_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($job_card_hs->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $job_card_hs_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fjob_card_hslist" id="fjob_card_hslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($job_card_hs_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $job_card_hs_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="job_card_hs">
<div id="gmp_job_card_hs" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($job_card_hs_list->TotalRecs > 0 || $job_card_hs->isGridEdit()) { ?>
<table id="tbl_job_card_hslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$job_card_hs_list->RowType = ROWTYPE_HEADER;

// Render list options
$job_card_hs_list->renderListOptions();

// Render list options (header, left)
$job_card_hs_list->ListOptions->render("header", "left");
?>
<?php if ($job_card_hs->id->Visible) { // id ?>
	<?php if ($job_card_hs->sortUrl($job_card_hs->id) == "") { ?>
		<th data-name="id" class="<?php echo $job_card_hs->id->headerCellClass() ?>"><div id="elh_job_card_hs_id" class="job_card_hs_id"><div class="ew-table-header-caption"><?php echo $job_card_hs->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $job_card_hs->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_hs->SortUrl($job_card_hs->id) ?>',2);"><div id="elh_job_card_hs_id" class="job_card_hs_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_hs->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_hs->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_hs->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_hs->works->Visible) { // works ?>
	<?php if ($job_card_hs->sortUrl($job_card_hs->works) == "") { ?>
		<th data-name="works" class="<?php echo $job_card_hs->works->headerCellClass() ?>"><div id="elh_job_card_hs_works" class="job_card_hs_works"><div class="ew-table-header-caption"><?php echo $job_card_hs->works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="works" class="<?php echo $job_card_hs->works->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_hs->SortUrl($job_card_hs->works) ?>',2);"><div id="elh_job_card_hs_works" class="job_card_hs_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_hs->works->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_hs->works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_hs->works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_hs->jc_no_fp->Visible) { // jc_no_fp ?>
	<?php if ($job_card_hs->sortUrl($job_card_hs->jc_no_fp) == "") { ?>
		<th data-name="jc_no_fp" class="<?php echo $job_card_hs->jc_no_fp->headerCellClass() ?>"><div id="elh_job_card_hs_jc_no_fp" class="job_card_hs_jc_no_fp"><div class="ew-table-header-caption"><?php echo $job_card_hs->jc_no_fp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_no_fp" class="<?php echo $job_card_hs->jc_no_fp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_hs->SortUrl($job_card_hs->jc_no_fp) ?>',2);"><div id="elh_job_card_hs_jc_no_fp" class="job_card_hs_jc_no_fp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_hs->jc_no_fp->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_hs->jc_no_fp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_hs->jc_no_fp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_hs->item->Visible) { // item ?>
	<?php if ($job_card_hs->sortUrl($job_card_hs->item) == "") { ?>
		<th data-name="item" class="<?php echo $job_card_hs->item->headerCellClass() ?>"><div id="elh_job_card_hs_item" class="job_card_hs_item"><div class="ew-table-header-caption"><?php echo $job_card_hs->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $job_card_hs->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_hs->SortUrl($job_card_hs->item) ?>',2);"><div id="elh_job_card_hs_item" class="job_card_hs_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_hs->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_hs->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_hs->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_hs->batch_no->Visible) { // batch_no ?>
	<?php if ($job_card_hs->sortUrl($job_card_hs->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $job_card_hs->batch_no->headerCellClass() ?>"><div id="elh_job_card_hs_batch_no" class="job_card_hs_batch_no"><div class="ew-table-header-caption"><?php echo $job_card_hs->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $job_card_hs->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_hs->SortUrl($job_card_hs->batch_no) ?>',2);"><div id="elh_job_card_hs_batch_no" class="job_card_hs_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_hs->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_hs->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_hs->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_hs->po->Visible) { // po ?>
	<?php if ($job_card_hs->sortUrl($job_card_hs->po) == "") { ?>
		<th data-name="po" class="<?php echo $job_card_hs->po->headerCellClass() ?>"><div id="elh_job_card_hs_po" class="job_card_hs_po"><div class="ew-table-header-caption"><?php echo $job_card_hs->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $job_card_hs->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_hs->SortUrl($job_card_hs->po) ?>',2);"><div id="elh_job_card_hs_po" class="job_card_hs_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_hs->po->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_hs->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_hs->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_hs->employee_id->Visible) { // employee_id ?>
	<?php if ($job_card_hs->sortUrl($job_card_hs->employee_id) == "") { ?>
		<th data-name="employee_id" class="<?php echo $job_card_hs->employee_id->headerCellClass() ?>"><div id="elh_job_card_hs_employee_id" class="job_card_hs_employee_id"><div class="ew-table-header-caption"><?php echo $job_card_hs->employee_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="employee_id" class="<?php echo $job_card_hs->employee_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_hs->SortUrl($job_card_hs->employee_id) ?>',2);"><div id="elh_job_card_hs_employee_id" class="job_card_hs_employee_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_hs->employee_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_hs->employee_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_hs->employee_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_hs->avl_qty->Visible) { // avl_qty ?>
	<?php if ($job_card_hs->sortUrl($job_card_hs->avl_qty) == "") { ?>
		<th data-name="avl_qty" class="<?php echo $job_card_hs->avl_qty->headerCellClass() ?>"><div id="elh_job_card_hs_avl_qty" class="job_card_hs_avl_qty"><div class="ew-table-header-caption"><?php echo $job_card_hs->avl_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="avl_qty" class="<?php echo $job_card_hs->avl_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_hs->SortUrl($job_card_hs->avl_qty) ?>',2);"><div id="elh_job_card_hs_avl_qty" class="job_card_hs_avl_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_hs->avl_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_hs->avl_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_hs->avl_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_hs->quantity->Visible) { // quantity ?>
	<?php if ($job_card_hs->sortUrl($job_card_hs->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $job_card_hs->quantity->headerCellClass() ?>"><div id="elh_job_card_hs_quantity" class="job_card_hs_quantity"><div class="ew-table-header-caption"><?php echo $job_card_hs->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $job_card_hs->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_hs->SortUrl($job_card_hs->quantity) ?>',2);"><div id="elh_job_card_hs_quantity" class="job_card_hs_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_hs->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_hs->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_hs->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_hs->_1->Visible) { // 1 ?>
	<?php if ($job_card_hs->sortUrl($job_card_hs->_1) == "") { ?>
		<th data-name="_1" class="<?php echo $job_card_hs->_1->headerCellClass() ?>"><div id="elh_job_card_hs__1" class="job_card_hs__1"><div class="ew-table-header-caption"><?php echo $job_card_hs->_1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_1" class="<?php echo $job_card_hs->_1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_hs->SortUrl($job_card_hs->_1) ?>',2);"><div id="elh_job_card_hs__1" class="job_card_hs__1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_hs->_1->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_hs->_1->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_hs->_1->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_hs->_2->Visible) { // 2 ?>
	<?php if ($job_card_hs->sortUrl($job_card_hs->_2) == "") { ?>
		<th data-name="_2" class="<?php echo $job_card_hs->_2->headerCellClass() ?>"><div id="elh_job_card_hs__2" class="job_card_hs__2"><div class="ew-table-header-caption"><?php echo $job_card_hs->_2->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_2" class="<?php echo $job_card_hs->_2->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_hs->SortUrl($job_card_hs->_2) ?>',2);"><div id="elh_job_card_hs__2" class="job_card_hs__2">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_hs->_2->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_hs->_2->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_hs->_2->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_hs->operator->Visible) { // operator ?>
	<?php if ($job_card_hs->sortUrl($job_card_hs->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $job_card_hs->operator->headerCellClass() ?>"><div id="elh_job_card_hs_operator" class="job_card_hs_operator"><div class="ew-table-header-caption"><?php echo $job_card_hs->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $job_card_hs->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_hs->SortUrl($job_card_hs->operator) ?>',2);"><div id="elh_job_card_hs_operator" class="job_card_hs_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_hs->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_hs->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_hs->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_hs->datetime->Visible) { // datetime ?>
	<?php if ($job_card_hs->sortUrl($job_card_hs->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $job_card_hs->datetime->headerCellClass() ?>"><div id="elh_job_card_hs_datetime" class="job_card_hs_datetime"><div class="ew-table-header-caption"><?php echo $job_card_hs->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $job_card_hs->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_hs->SortUrl($job_card_hs->datetime) ?>',2);"><div id="elh_job_card_hs_datetime" class="job_card_hs_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_hs->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_hs->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_hs->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$job_card_hs_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($job_card_hs->ExportAll && $job_card_hs->isExport()) {
	$job_card_hs_list->StopRec = $job_card_hs_list->TotalRecs;
} else {

	// Set the last record to display
	if ($job_card_hs_list->TotalRecs > $job_card_hs_list->StartRec + $job_card_hs_list->DisplayRecs - 1)
		$job_card_hs_list->StopRec = $job_card_hs_list->StartRec + $job_card_hs_list->DisplayRecs - 1;
	else
		$job_card_hs_list->StopRec = $job_card_hs_list->TotalRecs;
}
$job_card_hs_list->RecCnt = $job_card_hs_list->StartRec - 1;
if ($job_card_hs_list->Recordset && !$job_card_hs_list->Recordset->EOF) {
	$job_card_hs_list->Recordset->moveFirst();
	$selectLimit = $job_card_hs_list->UseSelectLimit;
	if (!$selectLimit && $job_card_hs_list->StartRec > 1)
		$job_card_hs_list->Recordset->move($job_card_hs_list->StartRec - 1);
} elseif (!$job_card_hs->AllowAddDeleteRow && $job_card_hs_list->StopRec == 0) {
	$job_card_hs_list->StopRec = $job_card_hs->GridAddRowCount;
}

// Initialize aggregate
$job_card_hs->RowType = ROWTYPE_AGGREGATEINIT;
$job_card_hs->resetAttributes();
$job_card_hs_list->renderRow();
while ($job_card_hs_list->RecCnt < $job_card_hs_list->StopRec) {
	$job_card_hs_list->RecCnt++;
	if ($job_card_hs_list->RecCnt >= $job_card_hs_list->StartRec) {
		$job_card_hs_list->RowCnt++;

		// Set up key count
		$job_card_hs_list->KeyCount = $job_card_hs_list->RowIndex;

		// Init row class and style
		$job_card_hs->resetAttributes();
		$job_card_hs->CssClass = "";
		if ($job_card_hs->isGridAdd()) {
		} else {
			$job_card_hs_list->loadRowValues($job_card_hs_list->Recordset); // Load row values
		}
		$job_card_hs->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$job_card_hs->RowAttrs = array_merge($job_card_hs->RowAttrs, array('data-rowindex'=>$job_card_hs_list->RowCnt, 'id'=>'r' . $job_card_hs_list->RowCnt . '_job_card_hs', 'data-rowtype'=>$job_card_hs->RowType));

		// Render row
		$job_card_hs_list->renderRow();

		// Render list options
		$job_card_hs_list->renderListOptions();
?>
	<tr<?php echo $job_card_hs->rowAttributes() ?>>
<?php

// Render list options (body, left)
$job_card_hs_list->ListOptions->render("body", "left", $job_card_hs_list->RowCnt);
?>
	<?php if ($job_card_hs->id->Visible) { // id ?>
		<td data-name="id"<?php echo $job_card_hs->id->cellAttributes() ?>>
<span id="el<?php echo $job_card_hs_list->RowCnt ?>_job_card_hs_id" class="job_card_hs_id">
<span<?php echo $job_card_hs->id->viewAttributes() ?>>
<?php echo $job_card_hs->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_hs->works->Visible) { // works ?>
		<td data-name="works"<?php echo $job_card_hs->works->cellAttributes() ?>>
<span id="el<?php echo $job_card_hs_list->RowCnt ?>_job_card_hs_works" class="job_card_hs_works">
<span<?php echo $job_card_hs->works->viewAttributes() ?>>
<?php echo $job_card_hs->works->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_hs->jc_no_fp->Visible) { // jc_no_fp ?>
		<td data-name="jc_no_fp"<?php echo $job_card_hs->jc_no_fp->cellAttributes() ?>>
<span id="el<?php echo $job_card_hs_list->RowCnt ?>_job_card_hs_jc_no_fp" class="job_card_hs_jc_no_fp">
<span<?php echo $job_card_hs->jc_no_fp->viewAttributes() ?>>
<?php echo $job_card_hs->jc_no_fp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_hs->item->Visible) { // item ?>
		<td data-name="item"<?php echo $job_card_hs->item->cellAttributes() ?>>
<span id="el<?php echo $job_card_hs_list->RowCnt ?>_job_card_hs_item" class="job_card_hs_item">
<span<?php echo $job_card_hs->item->viewAttributes() ?>>
<?php echo $job_card_hs->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_hs->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $job_card_hs->batch_no->cellAttributes() ?>>
<span id="el<?php echo $job_card_hs_list->RowCnt ?>_job_card_hs_batch_no" class="job_card_hs_batch_no">
<span<?php echo $job_card_hs->batch_no->viewAttributes() ?>>
<?php echo $job_card_hs->batch_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_hs->po->Visible) { // po ?>
		<td data-name="po"<?php echo $job_card_hs->po->cellAttributes() ?>>
<span id="el<?php echo $job_card_hs_list->RowCnt ?>_job_card_hs_po" class="job_card_hs_po">
<span<?php echo $job_card_hs->po->viewAttributes() ?>>
<?php echo $job_card_hs->po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_hs->employee_id->Visible) { // employee_id ?>
		<td data-name="employee_id"<?php echo $job_card_hs->employee_id->cellAttributes() ?>>
<span id="el<?php echo $job_card_hs_list->RowCnt ?>_job_card_hs_employee_id" class="job_card_hs_employee_id">
<span<?php echo $job_card_hs->employee_id->viewAttributes() ?>>
<?php echo $job_card_hs->employee_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_hs->avl_qty->Visible) { // avl_qty ?>
		<td data-name="avl_qty"<?php echo $job_card_hs->avl_qty->cellAttributes() ?>>
<span id="el<?php echo $job_card_hs_list->RowCnt ?>_job_card_hs_avl_qty" class="job_card_hs_avl_qty">
<span<?php echo $job_card_hs->avl_qty->viewAttributes() ?>>
<?php echo $job_card_hs->avl_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_hs->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $job_card_hs->quantity->cellAttributes() ?>>
<span id="el<?php echo $job_card_hs_list->RowCnt ?>_job_card_hs_quantity" class="job_card_hs_quantity">
<span<?php echo $job_card_hs->quantity->viewAttributes() ?>>
<?php echo $job_card_hs->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_hs->_1->Visible) { // 1 ?>
		<td data-name="_1"<?php echo $job_card_hs->_1->cellAttributes() ?>>
<span id="el<?php echo $job_card_hs_list->RowCnt ?>_job_card_hs__1" class="job_card_hs__1">
<span<?php echo $job_card_hs->_1->viewAttributes() ?>>
<?php echo $job_card_hs->_1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_hs->_2->Visible) { // 2 ?>
		<td data-name="_2"<?php echo $job_card_hs->_2->cellAttributes() ?>>
<span id="el<?php echo $job_card_hs_list->RowCnt ?>_job_card_hs__2" class="job_card_hs__2">
<span<?php echo $job_card_hs->_2->viewAttributes() ?>>
<?php echo $job_card_hs->_2->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_hs->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $job_card_hs->operator->cellAttributes() ?>>
<span id="el<?php echo $job_card_hs_list->RowCnt ?>_job_card_hs_operator" class="job_card_hs_operator">
<span<?php echo $job_card_hs->operator->viewAttributes() ?>>
<?php echo $job_card_hs->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_hs->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $job_card_hs->datetime->cellAttributes() ?>>
<span id="el<?php echo $job_card_hs_list->RowCnt ?>_job_card_hs_datetime" class="job_card_hs_datetime">
<span<?php echo $job_card_hs->datetime->viewAttributes() ?>>
<?php echo $job_card_hs->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$job_card_hs_list->ListOptions->render("body", "right", $job_card_hs_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$job_card_hs->isGridAdd())
		$job_card_hs_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$job_card_hs->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($job_card_hs_list->Recordset)
	$job_card_hs_list->Recordset->Close();
?>
<?php if (!$job_card_hs->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$job_card_hs->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($job_card_hs_list->Pager)) $job_card_hs_list->Pager = new PrevNextPager($job_card_hs_list->StartRec, $job_card_hs_list->DisplayRecs, $job_card_hs_list->TotalRecs, $job_card_hs_list->AutoHidePager) ?>
<?php if ($job_card_hs_list->Pager->RecordCount > 0 && $job_card_hs_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($job_card_hs_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $job_card_hs_list->pageUrl() ?>start=<?php echo $job_card_hs_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($job_card_hs_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $job_card_hs_list->pageUrl() ?>start=<?php echo $job_card_hs_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $job_card_hs_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($job_card_hs_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $job_card_hs_list->pageUrl() ?>start=<?php echo $job_card_hs_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($job_card_hs_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $job_card_hs_list->pageUrl() ?>start=<?php echo $job_card_hs_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $job_card_hs_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($job_card_hs_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $job_card_hs_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $job_card_hs_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $job_card_hs_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($job_card_hs_list->TotalRecs > 0 && (!$job_card_hs_list->AutoHidePageSizeSelector || $job_card_hs_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="job_card_hs">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($job_card_hs_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($job_card_hs_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($job_card_hs_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($job_card_hs_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($job_card_hs_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($job_card_hs->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $job_card_hs_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($job_card_hs_list->TotalRecs == 0 && !$job_card_hs->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $job_card_hs_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$job_card_hs_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$job_card_hs->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$job_card_hs->isExport()) { ?>
<script>
ew.scrollableTable("gmp_job_card_hs", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$job_card_hs_list->terminate();
?>