<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$job_card_hs_search = new job_card_hs_search();

// Run the page
$job_card_hs_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$job_card_hs_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($job_card_hs_search->IsModal) { ?>
var fjob_card_hssearch = currentAdvancedSearchForm = new ew.Form("fjob_card_hssearch", "search");
<?php } else { ?>
var fjob_card_hssearch = currentForm = new ew.Form("fjob_card_hssearch", "search");
<?php } ?>

// Form_CustomValidate event
fjob_card_hssearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjob_card_hssearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjob_card_hssearch.lists["x_works"] = <?php echo $job_card_hs_search->works->Lookup->toClientList() ?>;
fjob_card_hssearch.lists["x_works"].options = <?php echo JsonEncode($job_card_hs_search->works->lookupOptions()) ?>;
fjob_card_hssearch.lists["x_jc_no_fp"] = <?php echo $job_card_hs_search->jc_no_fp->Lookup->toClientList() ?>;
fjob_card_hssearch.lists["x_jc_no_fp"].options = <?php echo JsonEncode($job_card_hs_search->jc_no_fp->lookupOptions()) ?>;
fjob_card_hssearch.lists["x_batch_no"] = <?php echo $job_card_hs_search->batch_no->Lookup->toClientList() ?>;
fjob_card_hssearch.lists["x_batch_no"].options = <?php echo JsonEncode($job_card_hs_search->batch_no->lookupOptions()) ?>;
fjob_card_hssearch.lists["x_employee_id"] = <?php echo $job_card_hs_search->employee_id->Lookup->toClientList() ?>;
fjob_card_hssearch.lists["x_employee_id"].options = <?php echo JsonEncode($job_card_hs_search->employee_id->lookupOptions()) ?>;
fjob_card_hssearch.autoSuggests["x_employee_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
// Validate function for search

fjob_card_hssearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($job_card_hs->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_avl_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($job_card_hs->avl_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($job_card_hs->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($job_card_hs->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($job_card_hs->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_grp");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($job_card_hs->grp->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_s_grp");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($job_card_hs->s_grp->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_jc_no_hs");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($job_card_hs->jc_no_hs->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_updated");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($job_card_hs->updated->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $job_card_hs_search->showPageHeader(); ?>
<?php
$job_card_hs_search->showMessage();
?>
<form name="fjob_card_hssearch" id="fjob_card_hssearch" class="<?php echo $job_card_hs_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($job_card_hs_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $job_card_hs_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="job_card_hs">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$job_card_hs_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($job_card_hs->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $job_card_hs_search->LeftColumnClass ?>"><span id="elh_job_card_hs_id"><?php echo $job_card_hs->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $job_card_hs_search->RightColumnClass ?>"><div<?php echo $job_card_hs->id->cellAttributes() ?>>
			<span id="el_job_card_hs_id">
<input type="text" data-table="job_card_hs" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($job_card_hs->id->getPlaceHolder()) ?>" value="<?php echo $job_card_hs->id->EditValue ?>"<?php echo $job_card_hs->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_hs->works->Visible) { // works ?>
	<div id="r_works" class="form-group row">
		<label for="x_works" class="<?php echo $job_card_hs_search->LeftColumnClass ?>"><span id="elh_job_card_hs_works"><?php echo $job_card_hs->works->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_works" id="z_works" value="="></span>
		</label>
		<div class="<?php echo $job_card_hs_search->RightColumnClass ?>"><div<?php echo $job_card_hs->works->cellAttributes() ?>>
			<span id="el_job_card_hs_works">
<?php $job_card_hs->works->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$job_card_hs->works->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_hs" data-field="x_works" data-value-separator="<?php echo $job_card_hs->works->displayValueSeparatorAttribute() ?>" id="x_works" name="x_works"<?php echo $job_card_hs->works->editAttributes() ?>>
		<?php echo $job_card_hs->works->selectOptionListHtml("x_works") ?>
	</select>
</div>
<?php echo $job_card_hs->works->Lookup->getParamTag("p_x_works") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_hs->jc_no_fp->Visible) { // jc_no_fp ?>
	<div id="r_jc_no_fp" class="form-group row">
		<label for="x_jc_no_fp" class="<?php echo $job_card_hs_search->LeftColumnClass ?>"><span id="elh_job_card_hs_jc_no_fp"><?php echo $job_card_hs->jc_no_fp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_jc_no_fp" id="z_jc_no_fp" value="="></span>
		</label>
		<div class="<?php echo $job_card_hs_search->RightColumnClass ?>"><div<?php echo $job_card_hs->jc_no_fp->cellAttributes() ?>>
			<span id="el_job_card_hs_jc_no_fp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_hs" data-field="x_jc_no_fp" data-value-separator="<?php echo $job_card_hs->jc_no_fp->displayValueSeparatorAttribute() ?>" id="x_jc_no_fp" name="x_jc_no_fp"<?php echo $job_card_hs->jc_no_fp->editAttributes() ?>>
		<?php echo $job_card_hs->jc_no_fp->selectOptionListHtml("x_jc_no_fp") ?>
	</select>
</div>
<?php echo $job_card_hs->jc_no_fp->Lookup->getParamTag("p_x_jc_no_fp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_hs->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label for="x_item" class="<?php echo $job_card_hs_search->LeftColumnClass ?>"><span id="elh_job_card_hs_item"><?php echo $job_card_hs->item->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_item" id="z_item" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_hs_search->RightColumnClass ?>"><div<?php echo $job_card_hs->item->cellAttributes() ?>>
			<span id="el_job_card_hs_item">
<input type="text" data-table="job_card_hs" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_hs->item->getPlaceHolder()) ?>" value="<?php echo $job_card_hs->item->EditValue ?>"<?php echo $job_card_hs->item->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_hs->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label for="x_batch_no" class="<?php echo $job_card_hs_search->LeftColumnClass ?>"><span id="elh_job_card_hs_batch_no"><?php echo $job_card_hs->batch_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_batch_no" id="z_batch_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_hs_search->RightColumnClass ?>"><div<?php echo $job_card_hs->batch_no->cellAttributes() ?>>
			<span id="el_job_card_hs_batch_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_hs" data-field="x_batch_no" data-value-separator="<?php echo $job_card_hs->batch_no->displayValueSeparatorAttribute() ?>" id="x_batch_no" name="x_batch_no"<?php echo $job_card_hs->batch_no->editAttributes() ?>>
		<?php echo $job_card_hs->batch_no->selectOptionListHtml("x_batch_no") ?>
	</select>
</div>
<?php echo $job_card_hs->batch_no->Lookup->getParamTag("p_x_batch_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_hs->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label for="x_po" class="<?php echo $job_card_hs_search->LeftColumnClass ?>"><span id="elh_job_card_hs_po"><?php echo $job_card_hs->po->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_po" id="z_po" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_hs_search->RightColumnClass ?>"><div<?php echo $job_card_hs->po->cellAttributes() ?>>
			<span id="el_job_card_hs_po">
<input type="text" data-table="job_card_hs" data-field="x_po" name="x_po" id="x_po" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($job_card_hs->po->getPlaceHolder()) ?>" value="<?php echo $job_card_hs->po->EditValue ?>"<?php echo $job_card_hs->po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_hs->employee_id->Visible) { // employee_id ?>
	<div id="r_employee_id" class="form-group row">
		<label class="<?php echo $job_card_hs_search->LeftColumnClass ?>"><span id="elh_job_card_hs_employee_id"><?php echo $job_card_hs->employee_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_employee_id" id="z_employee_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_hs_search->RightColumnClass ?>"><div<?php echo $job_card_hs->employee_id->cellAttributes() ?>>
			<span id="el_job_card_hs_employee_id">
<?php
$wrkonchange = "" . trim(@$job_card_hs->employee_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$job_card_hs->employee_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_employee_id" class="text-nowrap" style="z-index: 8930">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_employee_id" id="sv_x_employee_id" value="<?php echo RemoveHtml($job_card_hs->employee_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($job_card_hs->employee_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($job_card_hs->employee_id->getPlaceHolder()) ?>"<?php echo $job_card_hs->employee_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($job_card_hs->employee_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_employee_id',m:0,n:3,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($job_card_hs->employee_id->ReadOnly || $job_card_hs->employee_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="job_card_hs" data-field="x_employee_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $job_card_hs->employee_id->displayValueSeparatorAttribute() ?>" name="x_employee_id" id="x_employee_id" value="<?php echo HtmlEncode($job_card_hs->employee_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fjob_card_hssearch.createAutoSuggest({"id":"x_employee_id","forceSelect":false});
</script>
<?php echo $job_card_hs->employee_id->Lookup->getParamTag("p_x_employee_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_hs->avl_qty->Visible) { // avl_qty ?>
	<div id="r_avl_qty" class="form-group row">
		<label for="x_avl_qty" class="<?php echo $job_card_hs_search->LeftColumnClass ?>"><span id="elh_job_card_hs_avl_qty"><?php echo $job_card_hs->avl_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_avl_qty" id="z_avl_qty" value="="></span>
		</label>
		<div class="<?php echo $job_card_hs_search->RightColumnClass ?>"><div<?php echo $job_card_hs->avl_qty->cellAttributes() ?>>
			<span id="el_job_card_hs_avl_qty">
<input type="text" data-table="job_card_hs" data-field="x_avl_qty" name="x_avl_qty" id="x_avl_qty" size="30" placeholder="<?php echo HtmlEncode($job_card_hs->avl_qty->getPlaceHolder()) ?>" value="<?php echo $job_card_hs->avl_qty->EditValue ?>"<?php echo $job_card_hs->avl_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_hs->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $job_card_hs_search->LeftColumnClass ?>"><span id="elh_job_card_hs_quantity"><?php echo $job_card_hs->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $job_card_hs_search->RightColumnClass ?>"><div<?php echo $job_card_hs->quantity->cellAttributes() ?>>
			<span id="el_job_card_hs_quantity">
<input type="text" data-table="job_card_hs" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($job_card_hs->quantity->getPlaceHolder()) ?>" value="<?php echo $job_card_hs->quantity->EditValue ?>"<?php echo $job_card_hs->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_hs->_1->Visible) { // 1 ?>
	<div id="r__1" class="form-group row">
		<label for="x__1" class="<?php echo $job_card_hs_search->LeftColumnClass ?>"><span id="elh_job_card_hs__1"><?php echo $job_card_hs->_1->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__1" id="z__1" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_hs_search->RightColumnClass ?>"><div<?php echo $job_card_hs->_1->cellAttributes() ?>>
			<span id="el_job_card_hs__1">
<input type="text" data-table="job_card_hs" data-field="x__1" name="x__1" id="x__1" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_hs->_1->getPlaceHolder()) ?>" value="<?php echo $job_card_hs->_1->EditValue ?>"<?php echo $job_card_hs->_1->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_hs->_2->Visible) { // 2 ?>
	<div id="r__2" class="form-group row">
		<label for="x__2" class="<?php echo $job_card_hs_search->LeftColumnClass ?>"><span id="elh_job_card_hs__2"><?php echo $job_card_hs->_2->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__2" id="z__2" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_hs_search->RightColumnClass ?>"><div<?php echo $job_card_hs->_2->cellAttributes() ?>>
			<span id="el_job_card_hs__2">
<input type="text" data-table="job_card_hs" data-field="x__2" name="x__2" id="x__2" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card_hs->_2->getPlaceHolder()) ?>" value="<?php echo $job_card_hs->_2->EditValue ?>"<?php echo $job_card_hs->_2->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_hs->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $job_card_hs_search->LeftColumnClass ?>"><span id="elh_job_card_hs_operator"><?php echo $job_card_hs->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $job_card_hs_search->RightColumnClass ?>"><div<?php echo $job_card_hs->operator->cellAttributes() ?>>
			<span id="el_job_card_hs_operator">
<input type="text" data-table="job_card_hs" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($job_card_hs->operator->getPlaceHolder()) ?>" value="<?php echo $job_card_hs->operator->EditValue ?>"<?php echo $job_card_hs->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_hs->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $job_card_hs_search->LeftColumnClass ?>"><span id="elh_job_card_hs_datetime"><?php echo $job_card_hs->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $job_card_hs_search->RightColumnClass ?>"><div<?php echo $job_card_hs->datetime->cellAttributes() ?>>
			<span id="el_job_card_hs_datetime">
<input type="text" data-table="job_card_hs" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($job_card_hs->datetime->getPlaceHolder()) ?>" value="<?php echo $job_card_hs->datetime->EditValue ?>"<?php echo $job_card_hs->datetime->editAttributes() ?>>
<?php if (!$job_card_hs->datetime->ReadOnly && !$job_card_hs->datetime->Disabled && !isset($job_card_hs->datetime->EditAttrs["readonly"]) && !isset($job_card_hs->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fjob_card_hssearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_hs->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $job_card_hs_search->LeftColumnClass ?>"><span id="elh_job_card_hs_grp"><?php echo $job_card_hs->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $job_card_hs_search->RightColumnClass ?>"><div<?php echo $job_card_hs->grp->cellAttributes() ?>>
			<span id="el_job_card_hs_grp">
<input type="text" data-table="job_card_hs" data-field="x_grp" name="x_grp" id="x_grp" size="30" placeholder="<?php echo HtmlEncode($job_card_hs->grp->getPlaceHolder()) ?>" value="<?php echo $job_card_hs->grp->EditValue ?>"<?php echo $job_card_hs->grp->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_hs->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $job_card_hs_search->LeftColumnClass ?>"><span id="elh_job_card_hs_s_grp"><?php echo $job_card_hs->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $job_card_hs_search->RightColumnClass ?>"><div<?php echo $job_card_hs->s_grp->cellAttributes() ?>>
			<span id="el_job_card_hs_s_grp">
<input type="text" data-table="job_card_hs" data-field="x_s_grp" name="x_s_grp" id="x_s_grp" size="30" placeholder="<?php echo HtmlEncode($job_card_hs->s_grp->getPlaceHolder()) ?>" value="<?php echo $job_card_hs->s_grp->EditValue ?>"<?php echo $job_card_hs->s_grp->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_hs->jc_no_hs->Visible) { // jc_no_hs ?>
	<div id="r_jc_no_hs" class="form-group row">
		<label for="x_jc_no_hs" class="<?php echo $job_card_hs_search->LeftColumnClass ?>"><span id="elh_job_card_hs_jc_no_hs"><?php echo $job_card_hs->jc_no_hs->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_jc_no_hs" id="z_jc_no_hs" value="="></span>
		</label>
		<div class="<?php echo $job_card_hs_search->RightColumnClass ?>"><div<?php echo $job_card_hs->jc_no_hs->cellAttributes() ?>>
			<span id="el_job_card_hs_jc_no_hs">
<input type="text" data-table="job_card_hs" data-field="x_jc_no_hs" name="x_jc_no_hs" id="x_jc_no_hs" size="30" placeholder="<?php echo HtmlEncode($job_card_hs->jc_no_hs->getPlaceHolder()) ?>" value="<?php echo $job_card_hs->jc_no_hs->EditValue ?>"<?php echo $job_card_hs->jc_no_hs->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card_hs->updated->Visible) { // updated ?>
	<div id="r_updated" class="form-group row">
		<label for="x_updated" class="<?php echo $job_card_hs_search->LeftColumnClass ?>"><span id="elh_job_card_hs_updated"><?php echo $job_card_hs->updated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_updated" id="z_updated" value="="></span>
		</label>
		<div class="<?php echo $job_card_hs_search->RightColumnClass ?>"><div<?php echo $job_card_hs->updated->cellAttributes() ?>>
			<span id="el_job_card_hs_updated">
<input type="text" data-table="job_card_hs" data-field="x_updated" name="x_updated" id="x_updated" size="30" placeholder="<?php echo HtmlEncode($job_card_hs->updated->getPlaceHolder()) ?>" value="<?php echo $job_card_hs->updated->EditValue ?>"<?php echo $job_card_hs->updated->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$job_card_hs_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $job_card_hs_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$job_card_hs_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$job_card_hs_search->terminate();
?>