<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$job_card_hs_view = new job_card_hs_view();

// Run the page
$job_card_hs_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$job_card_hs_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$job_card_hs->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fjob_card_hsview = currentForm = new ew.Form("fjob_card_hsview", "view");

// Form_CustomValidate event
fjob_card_hsview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjob_card_hsview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjob_card_hsview.lists["x_works"] = <?php echo $job_card_hs_view->works->Lookup->toClientList() ?>;
fjob_card_hsview.lists["x_works"].options = <?php echo JsonEncode($job_card_hs_view->works->lookupOptions()) ?>;
fjob_card_hsview.lists["x_jc_no_fp"] = <?php echo $job_card_hs_view->jc_no_fp->Lookup->toClientList() ?>;
fjob_card_hsview.lists["x_jc_no_fp"].options = <?php echo JsonEncode($job_card_hs_view->jc_no_fp->lookupOptions()) ?>;
fjob_card_hsview.lists["x_batch_no"] = <?php echo $job_card_hs_view->batch_no->Lookup->toClientList() ?>;
fjob_card_hsview.lists["x_batch_no"].options = <?php echo JsonEncode($job_card_hs_view->batch_no->lookupOptions()) ?>;
fjob_card_hsview.lists["x_employee_id"] = <?php echo $job_card_hs_view->employee_id->Lookup->toClientList() ?>;
fjob_card_hsview.lists["x_employee_id"].options = <?php echo JsonEncode($job_card_hs_view->employee_id->lookupOptions()) ?>;
fjob_card_hsview.autoSuggests["x_employee_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$job_card_hs->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $job_card_hs_view->ExportOptions->render("body") ?>
<?php $job_card_hs_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $job_card_hs_view->showPageHeader(); ?>
<?php
$job_card_hs_view->showMessage();
?>
<form name="fjob_card_hsview" id="fjob_card_hsview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($job_card_hs_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $job_card_hs_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="job_card_hs">
<input type="hidden" name="modal" value="<?php echo (int)$job_card_hs_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($job_card_hs->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $job_card_hs_view->TableLeftColumnClass ?>"><span id="elh_job_card_hs_id"><?php echo $job_card_hs->id->caption() ?></span></td>
		<td data-name="id"<?php echo $job_card_hs->id->cellAttributes() ?>>
<span id="el_job_card_hs_id">
<span<?php echo $job_card_hs->id->viewAttributes() ?>>
<?php echo $job_card_hs->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card_hs->works->Visible) { // works ?>
	<tr id="r_works">
		<td class="<?php echo $job_card_hs_view->TableLeftColumnClass ?>"><span id="elh_job_card_hs_works"><?php echo $job_card_hs->works->caption() ?></span></td>
		<td data-name="works"<?php echo $job_card_hs->works->cellAttributes() ?>>
<span id="el_job_card_hs_works">
<span<?php echo $job_card_hs->works->viewAttributes() ?>>
<?php echo $job_card_hs->works->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card_hs->jc_no_fp->Visible) { // jc_no_fp ?>
	<tr id="r_jc_no_fp">
		<td class="<?php echo $job_card_hs_view->TableLeftColumnClass ?>"><span id="elh_job_card_hs_jc_no_fp"><?php echo $job_card_hs->jc_no_fp->caption() ?></span></td>
		<td data-name="jc_no_fp"<?php echo $job_card_hs->jc_no_fp->cellAttributes() ?>>
<span id="el_job_card_hs_jc_no_fp">
<span<?php echo $job_card_hs->jc_no_fp->viewAttributes() ?>>
<?php echo $job_card_hs->jc_no_fp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card_hs->item->Visible) { // item ?>
	<tr id="r_item">
		<td class="<?php echo $job_card_hs_view->TableLeftColumnClass ?>"><span id="elh_job_card_hs_item"><?php echo $job_card_hs->item->caption() ?></span></td>
		<td data-name="item"<?php echo $job_card_hs->item->cellAttributes() ?>>
<span id="el_job_card_hs_item">
<span<?php echo $job_card_hs->item->viewAttributes() ?>>
<?php echo $job_card_hs->item->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card_hs->batch_no->Visible) { // batch_no ?>
	<tr id="r_batch_no">
		<td class="<?php echo $job_card_hs_view->TableLeftColumnClass ?>"><span id="elh_job_card_hs_batch_no"><?php echo $job_card_hs->batch_no->caption() ?></span></td>
		<td data-name="batch_no"<?php echo $job_card_hs->batch_no->cellAttributes() ?>>
<span id="el_job_card_hs_batch_no">
<span<?php echo $job_card_hs->batch_no->viewAttributes() ?>>
<?php echo $job_card_hs->batch_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card_hs->po->Visible) { // po ?>
	<tr id="r_po">
		<td class="<?php echo $job_card_hs_view->TableLeftColumnClass ?>"><span id="elh_job_card_hs_po"><?php echo $job_card_hs->po->caption() ?></span></td>
		<td data-name="po"<?php echo $job_card_hs->po->cellAttributes() ?>>
<span id="el_job_card_hs_po">
<span<?php echo $job_card_hs->po->viewAttributes() ?>>
<?php echo $job_card_hs->po->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card_hs->employee_id->Visible) { // employee_id ?>
	<tr id="r_employee_id">
		<td class="<?php echo $job_card_hs_view->TableLeftColumnClass ?>"><span id="elh_job_card_hs_employee_id"><?php echo $job_card_hs->employee_id->caption() ?></span></td>
		<td data-name="employee_id"<?php echo $job_card_hs->employee_id->cellAttributes() ?>>
<span id="el_job_card_hs_employee_id">
<span<?php echo $job_card_hs->employee_id->viewAttributes() ?>>
<?php echo $job_card_hs->employee_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card_hs->avl_qty->Visible) { // avl_qty ?>
	<tr id="r_avl_qty">
		<td class="<?php echo $job_card_hs_view->TableLeftColumnClass ?>"><span id="elh_job_card_hs_avl_qty"><?php echo $job_card_hs->avl_qty->caption() ?></span></td>
		<td data-name="avl_qty"<?php echo $job_card_hs->avl_qty->cellAttributes() ?>>
<span id="el_job_card_hs_avl_qty">
<span<?php echo $job_card_hs->avl_qty->viewAttributes() ?>>
<?php echo $job_card_hs->avl_qty->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card_hs->quantity->Visible) { // quantity ?>
	<tr id="r_quantity">
		<td class="<?php echo $job_card_hs_view->TableLeftColumnClass ?>"><span id="elh_job_card_hs_quantity"><?php echo $job_card_hs->quantity->caption() ?></span></td>
		<td data-name="quantity"<?php echo $job_card_hs->quantity->cellAttributes() ?>>
<span id="el_job_card_hs_quantity">
<span<?php echo $job_card_hs->quantity->viewAttributes() ?>>
<?php echo $job_card_hs->quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card_hs->_1->Visible) { // 1 ?>
	<tr id="r__1">
		<td class="<?php echo $job_card_hs_view->TableLeftColumnClass ?>"><span id="elh_job_card_hs__1"><?php echo $job_card_hs->_1->caption() ?></span></td>
		<td data-name="_1"<?php echo $job_card_hs->_1->cellAttributes() ?>>
<span id="el_job_card_hs__1">
<span<?php echo $job_card_hs->_1->viewAttributes() ?>>
<?php echo $job_card_hs->_1->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card_hs->_2->Visible) { // 2 ?>
	<tr id="r__2">
		<td class="<?php echo $job_card_hs_view->TableLeftColumnClass ?>"><span id="elh_job_card_hs__2"><?php echo $job_card_hs->_2->caption() ?></span></td>
		<td data-name="_2"<?php echo $job_card_hs->_2->cellAttributes() ?>>
<span id="el_job_card_hs__2">
<span<?php echo $job_card_hs->_2->viewAttributes() ?>>
<?php echo $job_card_hs->_2->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card_hs->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $job_card_hs_view->TableLeftColumnClass ?>"><span id="elh_job_card_hs_operator"><?php echo $job_card_hs->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $job_card_hs->operator->cellAttributes() ?>>
<span id="el_job_card_hs_operator">
<span<?php echo $job_card_hs->operator->viewAttributes() ?>>
<?php echo $job_card_hs->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card_hs->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $job_card_hs_view->TableLeftColumnClass ?>"><span id="elh_job_card_hs_datetime"><?php echo $job_card_hs->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $job_card_hs->datetime->cellAttributes() ?>>
<span id="el_job_card_hs_datetime">
<span<?php echo $job_card_hs->datetime->viewAttributes() ?>>
<?php echo $job_card_hs->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$job_card_hs_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$job_card_hs->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$job_card_hs_view->terminate();
?>