<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$job_card_pending_query_list = new job_card_pending_query_list();

// Run the page
$job_card_pending_query_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$job_card_pending_query_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$job_card_pending_query->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fjob_card_pending_querylist = currentForm = new ew.Form("fjob_card_pending_querylist", "list");
fjob_card_pending_querylist.formKeyCountName = '<?php echo $job_card_pending_query_list->FormKeyCountName ?>';

// Form_CustomValidate event
fjob_card_pending_querylist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjob_card_pending_querylist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjob_card_pending_querylist.lists["x_works"] = <?php echo $job_card_pending_query_list->works->Lookup->toClientList() ?>;
fjob_card_pending_querylist.lists["x_works"].options = <?php echo JsonEncode($job_card_pending_query_list->works->lookupOptions()) ?>;
fjob_card_pending_querylist.lists["x_emp_name[]"] = <?php echo $job_card_pending_query_list->emp_name->Lookup->toClientList() ?>;
fjob_card_pending_querylist.lists["x_emp_name[]"].options = <?php echo JsonEncode($job_card_pending_query_list->emp_name->lookupOptions()) ?>;
fjob_card_pending_querylist.lists["x__barcode[]"] = <?php echo $job_card_pending_query_list->_barcode->Lookup->toClientList() ?>;
fjob_card_pending_querylist.lists["x__barcode[]"].options = <?php echo JsonEncode($job_card_pending_query_list->_barcode->lookupOptions()) ?>;
fjob_card_pending_querylist.lists["x_dispatch_date"] = <?php echo $job_card_pending_query_list->dispatch_date->Lookup->toClientList() ?>;
fjob_card_pending_querylist.lists["x_dispatch_date"].options = <?php echo JsonEncode($job_card_pending_query_list->dispatch_date->lookupOptions()) ?>;
fjob_card_pending_querylist.lists["x_loom_no"] = <?php echo $job_card_pending_query_list->loom_no->Lookup->toClientList() ?>;
fjob_card_pending_querylist.lists["x_loom_no"].options = <?php echo JsonEncode($job_card_pending_query_list->loom_no->lookupOptions()) ?>;

// Form object for search
var fjob_card_pending_querylistsrch = currentSearchForm = new ew.Form("fjob_card_pending_querylistsrch");

// Validate function for search
fjob_card_pending_querylistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($job_card_pending_query->po->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fjob_card_pending_querylistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjob_card_pending_querylistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjob_card_pending_querylistsrch.lists["x_works"] = <?php echo $job_card_pending_query_list->works->Lookup->toClientList() ?>;
fjob_card_pending_querylistsrch.lists["x_works"].options = <?php echo JsonEncode($job_card_pending_query_list->works->lookupOptions()) ?>;
fjob_card_pending_querylistsrch.lists["x__barcode[]"] = <?php echo $job_card_pending_query_list->_barcode->Lookup->toClientList() ?>;
fjob_card_pending_querylistsrch.lists["x__barcode[]"].options = <?php echo JsonEncode($job_card_pending_query_list->_barcode->lookupOptions()) ?>;

// Filters
fjob_card_pending_querylistsrch.filterList = <?php echo $job_card_pending_query_list->getFilterList() ?>;

// Init search panel as collapsed
fjob_card_pending_querylistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$job_card_pending_query->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($job_card_pending_query_list->TotalRecs > 0 && $job_card_pending_query_list->ExportOptions->visible()) { ?>
<?php $job_card_pending_query_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($job_card_pending_query_list->ImportOptions->visible()) { ?>
<?php $job_card_pending_query_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($job_card_pending_query_list->SearchOptions->visible()) { ?>
<?php $job_card_pending_query_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($job_card_pending_query_list->FilterOptions->visible()) { ?>
<?php $job_card_pending_query_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$job_card_pending_query_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$job_card_pending_query->isExport() && !$job_card_pending_query->CurrentAction) { ?>
<form name="fjob_card_pending_querylistsrch" id="fjob_card_pending_querylistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($job_card_pending_query_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fjob_card_pending_querylistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="job_card_pending_query">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$job_card_pending_query_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$job_card_pending_query->RowType = ROWTYPE_SEARCH;

// Render row
$job_card_pending_query->resetAttributes();
$job_card_pending_query_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($job_card_pending_query->works->Visible) { // works ?>
	<div id="xsc_works" class="ew-cell form-group">
		<label for="x_works" class="ew-search-caption ew-label"><?php echo $job_card_pending_query->works->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_works" id="z_works" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_pending_query" data-field="x_works" data-value-separator="<?php echo $job_card_pending_query->works->displayValueSeparatorAttribute() ?>" id="x_works" name="x_works"<?php echo $job_card_pending_query->works->editAttributes() ?>>
		<?php echo $job_card_pending_query->works->selectOptionListHtml("x_works") ?>
	</select>
</div>
<?php echo $job_card_pending_query->works->Lookup->getParamTag("p_x_works") ?>
</span>
	</div>
<?php } ?>
<?php if ($job_card_pending_query->po->Visible) { // po ?>
	<div id="xsc_po" class="ew-cell form-group">
		<label for="x_po" class="ew-search-caption ew-label"><?php echo $job_card_pending_query->po->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po" id="z_po" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="job_card_pending_query" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($job_card_pending_query->po->getPlaceHolder()) ?>" value="<?php echo $job_card_pending_query->po->EditValue ?>"<?php echo $job_card_pending_query->po->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($job_card_pending_query->_barcode->Visible) { // barcode ?>
	<div id="xsc__barcode" class="ew-cell form-group">
		<label for="x__barcode" class="ew-search-caption ew-label"><?php echo $job_card_pending_query->_barcode->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__barcode" id="z__barcode" value="LIKE"></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card_pending_query" data-field="x__barcode" data-value-separator="<?php echo $job_card_pending_query->_barcode->displayValueSeparatorAttribute() ?>" id="x__barcode[]" name="x__barcode[]" multiple="multiple"<?php echo $job_card_pending_query->_barcode->editAttributes() ?>>
		<?php echo $job_card_pending_query->_barcode->selectOptionListHtml("x__barcode[]") ?>
	</select>
</div>
<?php echo $job_card_pending_query->_barcode->Lookup->getParamTag("p_x__barcode") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($job_card_pending_query_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($job_card_pending_query_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $job_card_pending_query_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($job_card_pending_query_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($job_card_pending_query_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($job_card_pending_query_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($job_card_pending_query_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $job_card_pending_query_list->showPageHeader(); ?>
<?php
$job_card_pending_query_list->showMessage();
?>
<?php if ($job_card_pending_query_list->TotalRecs > 0 || $job_card_pending_query->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($job_card_pending_query_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> job_card_pending_query">
<?php if (!$job_card_pending_query->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$job_card_pending_query->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($job_card_pending_query_list->Pager)) $job_card_pending_query_list->Pager = new PrevNextPager($job_card_pending_query_list->StartRec, $job_card_pending_query_list->DisplayRecs, $job_card_pending_query_list->TotalRecs, $job_card_pending_query_list->AutoHidePager) ?>
<?php if ($job_card_pending_query_list->Pager->RecordCount > 0 && $job_card_pending_query_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($job_card_pending_query_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $job_card_pending_query_list->pageUrl() ?>start=<?php echo $job_card_pending_query_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($job_card_pending_query_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $job_card_pending_query_list->pageUrl() ?>start=<?php echo $job_card_pending_query_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $job_card_pending_query_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($job_card_pending_query_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $job_card_pending_query_list->pageUrl() ?>start=<?php echo $job_card_pending_query_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($job_card_pending_query_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $job_card_pending_query_list->pageUrl() ?>start=<?php echo $job_card_pending_query_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $job_card_pending_query_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($job_card_pending_query_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $job_card_pending_query_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $job_card_pending_query_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $job_card_pending_query_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($job_card_pending_query_list->TotalRecs > 0 && (!$job_card_pending_query_list->AutoHidePageSizeSelector || $job_card_pending_query_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="job_card_pending_query">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($job_card_pending_query_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($job_card_pending_query_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($job_card_pending_query_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($job_card_pending_query_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($job_card_pending_query_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($job_card_pending_query->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $job_card_pending_query_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fjob_card_pending_querylist" id="fjob_card_pending_querylist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($job_card_pending_query_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $job_card_pending_query_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="job_card_pending_query">
<div id="gmp_job_card_pending_query" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($job_card_pending_query_list->TotalRecs > 0 || $job_card_pending_query->isGridEdit()) { ?>
<table id="tbl_job_card_pending_querylist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$job_card_pending_query_list->RowType = ROWTYPE_HEADER;

// Render list options
$job_card_pending_query_list->renderListOptions();

// Render list options (header, left)
$job_card_pending_query_list->ListOptions->render("header", "left");
?>
<?php if ($job_card_pending_query->works->Visible) { // works ?>
	<?php if ($job_card_pending_query->sortUrl($job_card_pending_query->works) == "") { ?>
		<th data-name="works" class="<?php echo $job_card_pending_query->works->headerCellClass() ?>"><div id="elh_job_card_pending_query_works" class="job_card_pending_query_works"><div class="ew-table-header-caption"><?php echo $job_card_pending_query->works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="works" class="<?php echo $job_card_pending_query->works->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_pending_query->SortUrl($job_card_pending_query->works) ?>',2);"><div id="elh_job_card_pending_query_works" class="job_card_pending_query_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_pending_query->works->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_pending_query->works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_pending_query->works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_pending_query->po->Visible) { // po ?>
	<?php if ($job_card_pending_query->sortUrl($job_card_pending_query->po) == "") { ?>
		<th data-name="po" class="<?php echo $job_card_pending_query->po->headerCellClass() ?>"><div id="elh_job_card_pending_query_po" class="job_card_pending_query_po"><div class="ew-table-header-caption"><?php echo $job_card_pending_query->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $job_card_pending_query->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_pending_query->SortUrl($job_card_pending_query->po) ?>',2);"><div id="elh_job_card_pending_query_po" class="job_card_pending_query_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_pending_query->po->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_pending_query->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_pending_query->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_pending_query->jc_no->Visible) { // jc_no ?>
	<?php if ($job_card_pending_query->sortUrl($job_card_pending_query->jc_no) == "") { ?>
		<th data-name="jc_no" class="<?php echo $job_card_pending_query->jc_no->headerCellClass() ?>"><div id="elh_job_card_pending_query_jc_no" class="job_card_pending_query_jc_no"><div class="ew-table-header-caption"><?php echo $job_card_pending_query->jc_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_no" class="<?php echo $job_card_pending_query->jc_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_pending_query->SortUrl($job_card_pending_query->jc_no) ?>',2);"><div id="elh_job_card_pending_query_jc_no" class="job_card_pending_query_jc_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_pending_query->jc_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_pending_query->jc_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_pending_query->jc_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_pending_query->datetime->Visible) { // datetime ?>
	<?php if ($job_card_pending_query->sortUrl($job_card_pending_query->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $job_card_pending_query->datetime->headerCellClass() ?>"><div id="elh_job_card_pending_query_datetime" class="job_card_pending_query_datetime"><div class="ew-table-header-caption"><?php echo $job_card_pending_query->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $job_card_pending_query->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_pending_query->SortUrl($job_card_pending_query->datetime) ?>',2);"><div id="elh_job_card_pending_query_datetime" class="job_card_pending_query_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_pending_query->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_pending_query->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_pending_query->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_pending_query->emp_name->Visible) { // emp_name ?>
	<?php if ($job_card_pending_query->sortUrl($job_card_pending_query->emp_name) == "") { ?>
		<th data-name="emp_name" class="<?php echo $job_card_pending_query->emp_name->headerCellClass() ?>"><div id="elh_job_card_pending_query_emp_name" class="job_card_pending_query_emp_name"><div class="ew-table-header-caption"><?php echo $job_card_pending_query->emp_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emp_name" class="<?php echo $job_card_pending_query->emp_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_pending_query->SortUrl($job_card_pending_query->emp_name) ?>',2);"><div id="elh_job_card_pending_query_emp_name" class="job_card_pending_query_emp_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_pending_query->emp_name->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_pending_query->emp_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_pending_query->emp_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_pending_query->tqty->Visible) { // tqty ?>
	<?php if ($job_card_pending_query->sortUrl($job_card_pending_query->tqty) == "") { ?>
		<th data-name="tqty" class="<?php echo $job_card_pending_query->tqty->headerCellClass() ?>"><div id="elh_job_card_pending_query_tqty" class="job_card_pending_query_tqty"><div class="ew-table-header-caption"><?php echo $job_card_pending_query->tqty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tqty" class="<?php echo $job_card_pending_query->tqty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_pending_query->SortUrl($job_card_pending_query->tqty) ?>',2);"><div id="elh_job_card_pending_query_tqty" class="job_card_pending_query_tqty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_pending_query->tqty->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_pending_query->tqty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_pending_query->tqty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_pending_query->count->Visible) { // count ?>
	<?php if ($job_card_pending_query->sortUrl($job_card_pending_query->count) == "") { ?>
		<th data-name="count" class="<?php echo $job_card_pending_query->count->headerCellClass() ?>"><div id="elh_job_card_pending_query_count" class="job_card_pending_query_count"><div class="ew-table-header-caption"><?php echo $job_card_pending_query->count->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="count" class="<?php echo $job_card_pending_query->count->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_pending_query->SortUrl($job_card_pending_query->count) ?>',2);"><div id="elh_job_card_pending_query_count" class="job_card_pending_query_count">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_pending_query->count->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_pending_query->count->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_pending_query->count->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_pending_query->tsqm->Visible) { // tsqm ?>
	<?php if ($job_card_pending_query->sortUrl($job_card_pending_query->tsqm) == "") { ?>
		<th data-name="tsqm" class="<?php echo $job_card_pending_query->tsqm->headerCellClass() ?>"><div id="elh_job_card_pending_query_tsqm" class="job_card_pending_query_tsqm"><div class="ew-table-header-caption"><?php echo $job_card_pending_query->tsqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tsqm" class="<?php echo $job_card_pending_query->tsqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_pending_query->SortUrl($job_card_pending_query->tsqm) ?>',2);"><div id="elh_job_card_pending_query_tsqm" class="job_card_pending_query_tsqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_pending_query->tsqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_pending_query->tsqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_pending_query->tsqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_pending_query->psqm->Visible) { // psqm ?>
	<?php if ($job_card_pending_query->sortUrl($job_card_pending_query->psqm) == "") { ?>
		<th data-name="psqm" class="<?php echo $job_card_pending_query->psqm->headerCellClass() ?>"><div id="elh_job_card_pending_query_psqm" class="job_card_pending_query_psqm"><div class="ew-table-header-caption"><?php echo $job_card_pending_query->psqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="psqm" class="<?php echo $job_card_pending_query->psqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_pending_query->SortUrl($job_card_pending_query->psqm) ?>',2);"><div id="elh_job_card_pending_query_psqm" class="job_card_pending_query_psqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_pending_query->psqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_pending_query->psqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_pending_query->psqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_pending_query->pending_days->Visible) { // pending_days ?>
	<?php if ($job_card_pending_query->sortUrl($job_card_pending_query->pending_days) == "") { ?>
		<th data-name="pending_days" class="<?php echo $job_card_pending_query->pending_days->headerCellClass() ?>"><div id="elh_job_card_pending_query_pending_days" class="job_card_pending_query_pending_days"><div class="ew-table-header-caption"><?php echo $job_card_pending_query->pending_days->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pending_days" class="<?php echo $job_card_pending_query->pending_days->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_pending_query->SortUrl($job_card_pending_query->pending_days) ?>',2);"><div id="elh_job_card_pending_query_pending_days" class="job_card_pending_query_pending_days">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_pending_query->pending_days->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_pending_query->pending_days->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_pending_query->pending_days->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_pending_query->_barcode->Visible) { // barcode ?>
	<?php if ($job_card_pending_query->sortUrl($job_card_pending_query->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $job_card_pending_query->_barcode->headerCellClass() ?>"><div id="elh_job_card_pending_query__barcode" class="job_card_pending_query__barcode"><div class="ew-table-header-caption"><?php echo $job_card_pending_query->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $job_card_pending_query->_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_pending_query->SortUrl($job_card_pending_query->_barcode) ?>',2);"><div id="elh_job_card_pending_query__barcode" class="job_card_pending_query__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_pending_query->_barcode->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_pending_query->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_pending_query->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_pending_query->plan_week->Visible) { // plan_week ?>
	<?php if ($job_card_pending_query->sortUrl($job_card_pending_query->plan_week) == "") { ?>
		<th data-name="plan_week" class="<?php echo $job_card_pending_query->plan_week->headerCellClass() ?>"><div id="elh_job_card_pending_query_plan_week" class="job_card_pending_query_plan_week"><div class="ew-table-header-caption"><?php echo $job_card_pending_query->plan_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="plan_week" class="<?php echo $job_card_pending_query->plan_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_pending_query->SortUrl($job_card_pending_query->plan_week) ?>',2);"><div id="elh_job_card_pending_query_plan_week" class="job_card_pending_query_plan_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_pending_query->plan_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_pending_query->plan_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_pending_query->plan_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_pending_query->dispatch_date->Visible) { // dispatch_date ?>
	<?php if ($job_card_pending_query->sortUrl($job_card_pending_query->dispatch_date) == "") { ?>
		<th data-name="dispatch_date" class="<?php echo $job_card_pending_query->dispatch_date->headerCellClass() ?>"><div id="elh_job_card_pending_query_dispatch_date" class="job_card_pending_query_dispatch_date"><div class="ew-table-header-caption"><?php echo $job_card_pending_query->dispatch_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dispatch_date" class="<?php echo $job_card_pending_query->dispatch_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_pending_query->SortUrl($job_card_pending_query->dispatch_date) ?>',2);"><div id="elh_job_card_pending_query_dispatch_date" class="job_card_pending_query_dispatch_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_pending_query->dispatch_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_pending_query->dispatch_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_pending_query->dispatch_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_pending_query->loom_no->Visible) { // loom_no ?>
	<?php if ($job_card_pending_query->sortUrl($job_card_pending_query->loom_no) == "") { ?>
		<th data-name="loom_no" class="<?php echo $job_card_pending_query->loom_no->headerCellClass() ?>"><div id="elh_job_card_pending_query_loom_no" class="job_card_pending_query_loom_no"><div class="ew-table-header-caption"><?php echo $job_card_pending_query->loom_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="loom_no" class="<?php echo $job_card_pending_query->loom_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_pending_query->SortUrl($job_card_pending_query->loom_no) ?>',2);"><div id="elh_job_card_pending_query_loom_no" class="job_card_pending_query_loom_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_pending_query->loom_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_pending_query->loom_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_pending_query->loom_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_pending_query->buyers_id->Visible) { // buyers_id ?>
	<?php if ($job_card_pending_query->sortUrl($job_card_pending_query->buyers_id) == "") { ?>
		<th data-name="buyers_id" class="<?php echo $job_card_pending_query->buyers_id->headerCellClass() ?>"><div id="elh_job_card_pending_query_buyers_id" class="job_card_pending_query_buyers_id"><div class="ew-table-header-caption"><?php echo $job_card_pending_query->buyers_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyers_id" class="<?php echo $job_card_pending_query->buyers_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_pending_query->SortUrl($job_card_pending_query->buyers_id) ?>',2);"><div id="elh_job_card_pending_query_buyers_id" class="job_card_pending_query_buyers_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_pending_query->buyers_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card_pending_query->buyers_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_pending_query->buyers_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card_pending_query->design_size->Visible) { // design_size ?>
	<?php if ($job_card_pending_query->sortUrl($job_card_pending_query->design_size) == "") { ?>
		<th data-name="design_size" class="<?php echo $job_card_pending_query->design_size->headerCellClass() ?>"><div id="elh_job_card_pending_query_design_size" class="job_card_pending_query_design_size"><div class="ew-table-header-caption"><?php echo $job_card_pending_query->design_size->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design_size" class="<?php echo $job_card_pending_query->design_size->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card_pending_query->SortUrl($job_card_pending_query->design_size) ?>',2);"><div id="elh_job_card_pending_query_design_size" class="job_card_pending_query_design_size">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card_pending_query->design_size->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($job_card_pending_query->design_size->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card_pending_query->design_size->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$job_card_pending_query_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($job_card_pending_query->ExportAll && $job_card_pending_query->isExport()) {
	$job_card_pending_query_list->StopRec = $job_card_pending_query_list->TotalRecs;
} else {

	// Set the last record to display
	if ($job_card_pending_query_list->TotalRecs > $job_card_pending_query_list->StartRec + $job_card_pending_query_list->DisplayRecs - 1)
		$job_card_pending_query_list->StopRec = $job_card_pending_query_list->StartRec + $job_card_pending_query_list->DisplayRecs - 1;
	else
		$job_card_pending_query_list->StopRec = $job_card_pending_query_list->TotalRecs;
}
$job_card_pending_query_list->RecCnt = $job_card_pending_query_list->StartRec - 1;
if ($job_card_pending_query_list->Recordset && !$job_card_pending_query_list->Recordset->EOF) {
	$job_card_pending_query_list->Recordset->moveFirst();
	$selectLimit = $job_card_pending_query_list->UseSelectLimit;
	if (!$selectLimit && $job_card_pending_query_list->StartRec > 1)
		$job_card_pending_query_list->Recordset->move($job_card_pending_query_list->StartRec - 1);
} elseif (!$job_card_pending_query->AllowAddDeleteRow && $job_card_pending_query_list->StopRec == 0) {
	$job_card_pending_query_list->StopRec = $job_card_pending_query->GridAddRowCount;
}

// Initialize aggregate
$job_card_pending_query->RowType = ROWTYPE_AGGREGATEINIT;
$job_card_pending_query->resetAttributes();
$job_card_pending_query_list->renderRow();
while ($job_card_pending_query_list->RecCnt < $job_card_pending_query_list->StopRec) {
	$job_card_pending_query_list->RecCnt++;
	if ($job_card_pending_query_list->RecCnt >= $job_card_pending_query_list->StartRec) {
		$job_card_pending_query_list->RowCnt++;

		// Set up key count
		$job_card_pending_query_list->KeyCount = $job_card_pending_query_list->RowIndex;

		// Init row class and style
		$job_card_pending_query->resetAttributes();
		$job_card_pending_query->CssClass = "";
		if ($job_card_pending_query->isGridAdd()) {
		} else {
			$job_card_pending_query_list->loadRowValues($job_card_pending_query_list->Recordset); // Load row values
		}
		$job_card_pending_query->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$job_card_pending_query->RowAttrs = array_merge($job_card_pending_query->RowAttrs, array('data-rowindex'=>$job_card_pending_query_list->RowCnt, 'id'=>'r' . $job_card_pending_query_list->RowCnt . '_job_card_pending_query', 'data-rowtype'=>$job_card_pending_query->RowType));

		// Render row
		$job_card_pending_query_list->renderRow();

		// Render list options
		$job_card_pending_query_list->renderListOptions();
?>
	<tr<?php echo $job_card_pending_query->rowAttributes() ?>>
<?php

// Render list options (body, left)
$job_card_pending_query_list->ListOptions->render("body", "left", $job_card_pending_query_list->RowCnt);
?>
	<?php if ($job_card_pending_query->works->Visible) { // works ?>
		<td data-name="works"<?php echo $job_card_pending_query->works->cellAttributes() ?>>
<span id="el<?php echo $job_card_pending_query_list->RowCnt ?>_job_card_pending_query_works" class="job_card_pending_query_works">
<span<?php echo $job_card_pending_query->works->viewAttributes() ?>>
<?php echo $job_card_pending_query->works->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_pending_query->po->Visible) { // po ?>
		<td data-name="po"<?php echo $job_card_pending_query->po->cellAttributes() ?>>
<span id="el<?php echo $job_card_pending_query_list->RowCnt ?>_job_card_pending_query_po" class="job_card_pending_query_po">
<span<?php echo $job_card_pending_query->po->viewAttributes() ?>>
<?php echo $job_card_pending_query->po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_pending_query->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no"<?php echo $job_card_pending_query->jc_no->cellAttributes() ?>>
<span id="el<?php echo $job_card_pending_query_list->RowCnt ?>_job_card_pending_query_jc_no" class="job_card_pending_query_jc_no">
<span<?php echo $job_card_pending_query->jc_no->viewAttributes() ?>>
<?php if ((!EmptyString($job_card_pending_query->jc_no->getViewValue())) && $job_card_pending_query->jc_no->linkAttributes() <> "") { ?>
<a<?php echo $job_card_pending_query->jc_no->linkAttributes() ?>><?php echo $job_card_pending_query->jc_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $job_card_pending_query->jc_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_pending_query->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $job_card_pending_query->datetime->cellAttributes() ?>>
<span id="el<?php echo $job_card_pending_query_list->RowCnt ?>_job_card_pending_query_datetime" class="job_card_pending_query_datetime">
<span<?php echo $job_card_pending_query->datetime->viewAttributes() ?>>
<?php echo $job_card_pending_query->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_pending_query->emp_name->Visible) { // emp_name ?>
		<td data-name="emp_name"<?php echo $job_card_pending_query->emp_name->cellAttributes() ?>>
<span id="el<?php echo $job_card_pending_query_list->RowCnt ?>_job_card_pending_query_emp_name" class="job_card_pending_query_emp_name">
<span<?php echo $job_card_pending_query->emp_name->viewAttributes() ?>>
<?php echo $job_card_pending_query->emp_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_pending_query->tqty->Visible) { // tqty ?>
		<td data-name="tqty"<?php echo $job_card_pending_query->tqty->cellAttributes() ?>>
<span id="el<?php echo $job_card_pending_query_list->RowCnt ?>_job_card_pending_query_tqty" class="job_card_pending_query_tqty">
<span<?php echo $job_card_pending_query->tqty->viewAttributes() ?>>
<?php echo $job_card_pending_query->tqty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_pending_query->count->Visible) { // count ?>
		<td data-name="count"<?php echo $job_card_pending_query->count->cellAttributes() ?>>
<span id="el<?php echo $job_card_pending_query_list->RowCnt ?>_job_card_pending_query_count" class="job_card_pending_query_count">
<span<?php echo $job_card_pending_query->count->viewAttributes() ?>>
<?php echo $job_card_pending_query->count->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_pending_query->tsqm->Visible) { // tsqm ?>
		<td data-name="tsqm"<?php echo $job_card_pending_query->tsqm->cellAttributes() ?>>
<span id="el<?php echo $job_card_pending_query_list->RowCnt ?>_job_card_pending_query_tsqm" class="job_card_pending_query_tsqm">
<span<?php echo $job_card_pending_query->tsqm->viewAttributes() ?>>
<?php echo $job_card_pending_query->tsqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_pending_query->psqm->Visible) { // psqm ?>
		<td data-name="psqm"<?php echo $job_card_pending_query->psqm->cellAttributes() ?>>
<span id="el<?php echo $job_card_pending_query_list->RowCnt ?>_job_card_pending_query_psqm" class="job_card_pending_query_psqm">
<span<?php echo $job_card_pending_query->psqm->viewAttributes() ?>>
<?php echo $job_card_pending_query->psqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_pending_query->pending_days->Visible) { // pending_days ?>
		<td data-name="pending_days"<?php echo $job_card_pending_query->pending_days->cellAttributes() ?>>
<span id="el<?php echo $job_card_pending_query_list->RowCnt ?>_job_card_pending_query_pending_days" class="job_card_pending_query_pending_days">
<span<?php echo $job_card_pending_query->pending_days->viewAttributes() ?>>
<?php echo $job_card_pending_query->pending_days->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_pending_query->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $job_card_pending_query->_barcode->cellAttributes() ?>>
<span id="el<?php echo $job_card_pending_query_list->RowCnt ?>_job_card_pending_query__barcode" class="job_card_pending_query__barcode">
<span<?php echo $job_card_pending_query->_barcode->viewAttributes() ?>>
<?php echo $job_card_pending_query->_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_pending_query->plan_week->Visible) { // plan_week ?>
		<td data-name="plan_week"<?php echo $job_card_pending_query->plan_week->cellAttributes() ?>>
<span id="el<?php echo $job_card_pending_query_list->RowCnt ?>_job_card_pending_query_plan_week" class="job_card_pending_query_plan_week">
<span<?php echo $job_card_pending_query->plan_week->viewAttributes() ?>>
<?php echo $job_card_pending_query->plan_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_pending_query->dispatch_date->Visible) { // dispatch_date ?>
		<td data-name="dispatch_date"<?php echo $job_card_pending_query->dispatch_date->cellAttributes() ?>>
<span id="el<?php echo $job_card_pending_query_list->RowCnt ?>_job_card_pending_query_dispatch_date" class="job_card_pending_query_dispatch_date">
<span<?php echo $job_card_pending_query->dispatch_date->viewAttributes() ?>>
<?php echo $job_card_pending_query->dispatch_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_pending_query->loom_no->Visible) { // loom_no ?>
		<td data-name="loom_no"<?php echo $job_card_pending_query->loom_no->cellAttributes() ?>>
<span id="el<?php echo $job_card_pending_query_list->RowCnt ?>_job_card_pending_query_loom_no" class="job_card_pending_query_loom_no">
<span<?php echo $job_card_pending_query->loom_no->viewAttributes() ?>>
<?php echo $job_card_pending_query->loom_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_pending_query->buyers_id->Visible) { // buyers_id ?>
		<td data-name="buyers_id"<?php echo $job_card_pending_query->buyers_id->cellAttributes() ?>>
<span id="el<?php echo $job_card_pending_query_list->RowCnt ?>_job_card_pending_query_buyers_id" class="job_card_pending_query_buyers_id">
<span<?php echo $job_card_pending_query->buyers_id->viewAttributes() ?>>
<?php echo $job_card_pending_query->buyers_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card_pending_query->design_size->Visible) { // design_size ?>
		<td data-name="design_size"<?php echo $job_card_pending_query->design_size->cellAttributes() ?>>
<span id="el<?php echo $job_card_pending_query_list->RowCnt ?>_job_card_pending_query_design_size" class="job_card_pending_query_design_size">
<span<?php echo $job_card_pending_query->design_size->viewAttributes() ?>>
<?php echo $job_card_pending_query->design_size->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$job_card_pending_query_list->ListOptions->render("body", "right", $job_card_pending_query_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$job_card_pending_query->isGridAdd())
		$job_card_pending_query_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$job_card_pending_query->RowType = ROWTYPE_AGGREGATE;
$job_card_pending_query->resetAttributes();
$job_card_pending_query_list->renderRow();
?>
<?php if ($job_card_pending_query_list->TotalRecs > 0 && !$job_card_pending_query->isGridAdd() && !$job_card_pending_query->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$job_card_pending_query_list->renderListOptions();

// Render list options (footer, left)
$job_card_pending_query_list->ListOptions->render("footer", "left");
?>
	<?php if ($job_card_pending_query->works->Visible) { // works ?>
		<td data-name="works" class="<?php echo $job_card_pending_query->works->footerCellClass() ?>"><span id="elf_job_card_pending_query_works" class="job_card_pending_query_works">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($job_card_pending_query->po->Visible) { // po ?>
		<td data-name="po" class="<?php echo $job_card_pending_query->po->footerCellClass() ?>"><span id="elf_job_card_pending_query_po" class="job_card_pending_query_po">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($job_card_pending_query->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no" class="<?php echo $job_card_pending_query->jc_no->footerCellClass() ?>"><span id="elf_job_card_pending_query_jc_no" class="job_card_pending_query_jc_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($job_card_pending_query->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $job_card_pending_query->datetime->footerCellClass() ?>"><span id="elf_job_card_pending_query_datetime" class="job_card_pending_query_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($job_card_pending_query->emp_name->Visible) { // emp_name ?>
		<td data-name="emp_name" class="<?php echo $job_card_pending_query->emp_name->footerCellClass() ?>"><span id="elf_job_card_pending_query_emp_name" class="job_card_pending_query_emp_name">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($job_card_pending_query->tqty->Visible) { // tqty ?>
		<td data-name="tqty" class="<?php echo $job_card_pending_query->tqty->footerCellClass() ?>"><span id="elf_job_card_pending_query_tqty" class="job_card_pending_query_tqty">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $job_card_pending_query->tqty->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($job_card_pending_query->count->Visible) { // count ?>
		<td data-name="count" class="<?php echo $job_card_pending_query->count->footerCellClass() ?>"><span id="elf_job_card_pending_query_count" class="job_card_pending_query_count">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $job_card_pending_query->count->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($job_card_pending_query->tsqm->Visible) { // tsqm ?>
		<td data-name="tsqm" class="<?php echo $job_card_pending_query->tsqm->footerCellClass() ?>"><span id="elf_job_card_pending_query_tsqm" class="job_card_pending_query_tsqm">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $job_card_pending_query->tsqm->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($job_card_pending_query->psqm->Visible) { // psqm ?>
		<td data-name="psqm" class="<?php echo $job_card_pending_query->psqm->footerCellClass() ?>"><span id="elf_job_card_pending_query_psqm" class="job_card_pending_query_psqm">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $job_card_pending_query->psqm->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($job_card_pending_query->pending_days->Visible) { // pending_days ?>
		<td data-name="pending_days" class="<?php echo $job_card_pending_query->pending_days->footerCellClass() ?>"><span id="elf_job_card_pending_query_pending_days" class="job_card_pending_query_pending_days">
		<span class="ew-aggregate"><?php echo $Language->phrase("AVERAGE") ?></span><span class="ew-aggregate-value">
		<?php echo $job_card_pending_query->pending_days->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($job_card_pending_query->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode" class="<?php echo $job_card_pending_query->_barcode->footerCellClass() ?>"><span id="elf_job_card_pending_query__barcode" class="job_card_pending_query__barcode">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($job_card_pending_query->plan_week->Visible) { // plan_week ?>
		<td data-name="plan_week" class="<?php echo $job_card_pending_query->plan_week->footerCellClass() ?>"><span id="elf_job_card_pending_query_plan_week" class="job_card_pending_query_plan_week">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($job_card_pending_query->dispatch_date->Visible) { // dispatch_date ?>
		<td data-name="dispatch_date" class="<?php echo $job_card_pending_query->dispatch_date->footerCellClass() ?>"><span id="elf_job_card_pending_query_dispatch_date" class="job_card_pending_query_dispatch_date">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($job_card_pending_query->loom_no->Visible) { // loom_no ?>
		<td data-name="loom_no" class="<?php echo $job_card_pending_query->loom_no->footerCellClass() ?>"><span id="elf_job_card_pending_query_loom_no" class="job_card_pending_query_loom_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($job_card_pending_query->buyers_id->Visible) { // buyers_id ?>
		<td data-name="buyers_id" class="<?php echo $job_card_pending_query->buyers_id->footerCellClass() ?>"><span id="elf_job_card_pending_query_buyers_id" class="job_card_pending_query_buyers_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($job_card_pending_query->design_size->Visible) { // design_size ?>
		<td data-name="design_size" class="<?php echo $job_card_pending_query->design_size->footerCellClass() ?>"><span id="elf_job_card_pending_query_design_size" class="job_card_pending_query_design_size">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$job_card_pending_query_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$job_card_pending_query->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($job_card_pending_query_list->Recordset)
	$job_card_pending_query_list->Recordset->Close();
?>
<?php if (!$job_card_pending_query->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$job_card_pending_query->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($job_card_pending_query_list->Pager)) $job_card_pending_query_list->Pager = new PrevNextPager($job_card_pending_query_list->StartRec, $job_card_pending_query_list->DisplayRecs, $job_card_pending_query_list->TotalRecs, $job_card_pending_query_list->AutoHidePager) ?>
<?php if ($job_card_pending_query_list->Pager->RecordCount > 0 && $job_card_pending_query_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($job_card_pending_query_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $job_card_pending_query_list->pageUrl() ?>start=<?php echo $job_card_pending_query_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($job_card_pending_query_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $job_card_pending_query_list->pageUrl() ?>start=<?php echo $job_card_pending_query_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $job_card_pending_query_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($job_card_pending_query_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $job_card_pending_query_list->pageUrl() ?>start=<?php echo $job_card_pending_query_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($job_card_pending_query_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $job_card_pending_query_list->pageUrl() ?>start=<?php echo $job_card_pending_query_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $job_card_pending_query_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($job_card_pending_query_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $job_card_pending_query_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $job_card_pending_query_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $job_card_pending_query_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($job_card_pending_query_list->TotalRecs > 0 && (!$job_card_pending_query_list->AutoHidePageSizeSelector || $job_card_pending_query_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="job_card_pending_query">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($job_card_pending_query_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($job_card_pending_query_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($job_card_pending_query_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($job_card_pending_query_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($job_card_pending_query_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($job_card_pending_query->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $job_card_pending_query_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($job_card_pending_query_list->TotalRecs == 0 && !$job_card_pending_query->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $job_card_pending_query_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$job_card_pending_query_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$job_card_pending_query->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$job_card_pending_query->isExport()) { ?>
<script>
ew.scrollableTable("gmp_job_card_pending_query", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$job_card_pending_query_list->terminate();
?>