<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$job_card_addopt = new job_card_addopt();

// Run the page
$job_card_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$job_card_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fjob_cardaddopt = currentForm = new ew.Form("fjob_cardaddopt", "addopt");

// Validate form
fjob_cardaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($job_card_addopt->jc_no->Required) { ?>
			elm = this.getElements("x" + infix + "_jc_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->jc_no->caption(), $job_card->jc_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_jc_no");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($job_card->jc_no->errorMessage()) ?>");
		<?php if ($job_card_addopt->works->Required) { ?>
			elm = this.getElements("x" + infix + "_works");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->works->caption(), $job_card->works->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_addopt->issue_to_internal->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_to_internal");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->issue_to_internal->caption(), $job_card->issue_to_internal->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_addopt->issue_to_external->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_to_external");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->issue_to_external->caption(), $job_card->issue_to_external->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_addopt->issue_to->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->issue_to->caption(), $job_card->issue_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_addopt->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->grp->caption(), $job_card->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_addopt->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->s_grp->caption(), $job_card->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_addopt->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->packing_type->caption(), $job_card->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_addopt->product_code->Required) { ?>
			elm = this.getElements("x" + infix + "_product_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->product_code->caption(), $job_card->product_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_addopt->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->item->caption(), $job_card->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_addopt->poid->Required) { ?>
			elm = this.getElements("x" + infix + "_poid[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->poid->caption(), $job_card->poid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_addopt->batch_no->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->batch_no->caption(), $job_card->batch_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_addopt->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->quantity->caption(), $job_card->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($job_card->quantity->errorMessage()) ?>");
		<?php if ($job_card_addopt->lot_no->Required) { ?>
			elm = this.getElements("x" + infix + "_lot_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->lot_no->caption(), $job_card->lot_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_addopt->pro_unit->Required) { ?>
			elm = this.getElements("x" + infix + "_pro_unit");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->pro_unit->caption(), $job_card->pro_unit->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_addopt->employee_id->Required) { ?>
			elm = this.getElements("x" + infix + "_employee_id[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->employee_id->caption(), $job_card->employee_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_addopt->_1->Required) { ?>
			elm = this.getElements("x" + infix + "__1");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->_1->caption(), $job_card->_1->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_addopt->_2->Required) { ?>
			elm = this.getElements("x" + infix + "__2");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->_2->caption(), $job_card->_2->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_addopt->_3->Required) { ?>
			elm = this.getElements("x" + infix + "__3");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->_3->caption(), $job_card->_3->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_addopt->_4->Required) { ?>
			elm = this.getElements("x" + infix + "__4");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->_4->caption(), $job_card->_4->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_addopt->_5->Required) { ?>
			elm = this.getElements("x" + infix + "__5");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->_5->caption(), $job_card->_5->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_addopt->_6->Required) { ?>
			elm = this.getElements("x" + infix + "__6");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->_6->caption(), $job_card->_6->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_addopt->_7->Required) { ?>
			elm = this.getElements("x" + infix + "__7");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->_7->caption(), $job_card->_7->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_addopt->_8->Required) { ?>
			elm = this.getElements("x" + infix + "__8");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->_8->caption(), $job_card->_8->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_addopt->other1->Required) { ?>
			elm = this.getElements("x" + infix + "_other1");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->other1->caption(), $job_card->other1->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_addopt->other2->Required) { ?>
			elm = this.getElements("x" + infix + "_other2");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->other2->caption(), $job_card->other2->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->operator->caption(), $job_card->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->datetime->caption(), $job_card->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_addopt->updated->Required) { ?>
			elm = this.getElements("x" + infix + "_updated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->updated->caption(), $job_card->updated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_updated");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($job_card->updated->errorMessage()) ?>");
		<?php if ($job_card_addopt->in_id->Required) { ?>
			elm = this.getElements("x" + infix + "_in_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->in_id->caption(), $job_card->in_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_addopt->balance_quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_balance_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->balance_quantity->caption(), $job_card->balance_quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_balance_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($job_card->balance_quantity->errorMessage()) ?>");
		<?php if ($job_card_addopt->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->product->caption(), $job_card->product->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($job_card->product->errorMessage()) ?>");
		<?php if ($job_card_addopt->buyer_id->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->buyer_id->caption(), $job_card->buyer_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_buyer_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($job_card->buyer_id->errorMessage()) ?>");
		<?php if ($job_card_addopt->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->company_id->caption(), $job_card->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($job_card->company_id->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fjob_cardaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjob_cardaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjob_cardaddopt.lists["x_works"] = <?php echo $job_card_addopt->works->Lookup->toClientList() ?>;
fjob_cardaddopt.lists["x_works"].options = <?php echo JsonEncode($job_card_addopt->works->lookupOptions()) ?>;
fjob_cardaddopt.lists["x_issue_to_internal"] = <?php echo $job_card_addopt->issue_to_internal->Lookup->toClientList() ?>;
fjob_cardaddopt.lists["x_issue_to_internal"].options = <?php echo JsonEncode($job_card_addopt->issue_to_internal->lookupOptions()) ?>;
fjob_cardaddopt.lists["x_issue_to_external"] = <?php echo $job_card_addopt->issue_to_external->Lookup->toClientList() ?>;
fjob_cardaddopt.lists["x_issue_to_external"].options = <?php echo JsonEncode($job_card_addopt->issue_to_external->lookupOptions()) ?>;
fjob_cardaddopt.lists["x_issue_to"] = <?php echo $job_card_addopt->issue_to->Lookup->toClientList() ?>;
fjob_cardaddopt.lists["x_issue_to"].options = <?php echo JsonEncode($job_card_addopt->issue_to->lookupOptions()) ?>;
fjob_cardaddopt.lists["x_grp"] = <?php echo $job_card_addopt->grp->Lookup->toClientList() ?>;
fjob_cardaddopt.lists["x_grp"].options = <?php echo JsonEncode($job_card_addopt->grp->lookupOptions()) ?>;
fjob_cardaddopt.lists["x_s_grp"] = <?php echo $job_card_addopt->s_grp->Lookup->toClientList() ?>;
fjob_cardaddopt.lists["x_s_grp"].options = <?php echo JsonEncode($job_card_addopt->s_grp->lookupOptions()) ?>;
fjob_cardaddopt.lists["x_packing_type"] = <?php echo $job_card_addopt->packing_type->Lookup->toClientList() ?>;
fjob_cardaddopt.lists["x_packing_type"].options = <?php echo JsonEncode($job_card_addopt->packing_type->lookupOptions()) ?>;
fjob_cardaddopt.lists["x_product_code"] = <?php echo $job_card_addopt->product_code->Lookup->toClientList() ?>;
fjob_cardaddopt.lists["x_product_code"].options = <?php echo JsonEncode($job_card_addopt->product_code->lookupOptions()) ?>;
fjob_cardaddopt.lists["x_item"] = <?php echo $job_card_addopt->item->Lookup->toClientList() ?>;
fjob_cardaddopt.lists["x_item"].options = <?php echo JsonEncode($job_card_addopt->item->lookupOptions()) ?>;
fjob_cardaddopt.autoSuggests["x_item"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fjob_cardaddopt.lists["x_poid[]"] = <?php echo $job_card_addopt->poid->Lookup->toClientList() ?>;
fjob_cardaddopt.lists["x_poid[]"].options = <?php echo JsonEncode($job_card_addopt->poid->lookupOptions()) ?>;
fjob_cardaddopt.lists["x_batch_no"] = <?php echo $job_card_addopt->batch_no->Lookup->toClientList() ?>;
fjob_cardaddopt.lists["x_batch_no"].options = <?php echo JsonEncode($job_card_addopt->batch_no->lookupOptions()) ?>;
fjob_cardaddopt.lists["x_pro_unit"] = <?php echo $job_card_addopt->pro_unit->Lookup->toClientList() ?>;
fjob_cardaddopt.lists["x_pro_unit"].options = <?php echo JsonEncode($job_card_addopt->pro_unit->lookupOptions()) ?>;
fjob_cardaddopt.lists["x_employee_id[]"] = <?php echo $job_card_addopt->employee_id->Lookup->toClientList() ?>;
fjob_cardaddopt.lists["x_employee_id[]"].options = <?php echo JsonEncode($job_card_addopt->employee_id->lookupOptions()) ?>;
fjob_cardaddopt.lists["x_operator"] = <?php echo $job_card_addopt->operator->Lookup->toClientList() ?>;
fjob_cardaddopt.lists["x_operator"].options = <?php echo JsonEncode($job_card_addopt->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $job_card_addopt->showPageHeader(); ?>
<?php
$job_card_addopt->showMessage();
?>
<form name="fjob_cardaddopt" id="fjob_cardaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($job_card_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $job_card_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $job_card_addopt->TableVar ?>">
<?php if ($job_card->jc_no->Visible) { // jc_no ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_jc_no"><?php echo $job_card->jc_no->caption() ?><?php echo ($job_card->jc_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="job_card" data-field="x_jc_no" name="x_jc_no" id="x_jc_no" size="30" placeholder="<?php echo HtmlEncode($job_card->jc_no->getPlaceHolder()) ?>" value="<?php echo $job_card->jc_no->EditValue ?>"<?php echo $job_card->jc_no->editAttributes() ?>>
<?php echo $job_card->jc_no->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->works->Visible) { // works ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_works"><?php echo $job_card->works->caption() ?><?php echo ($job_card->works->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card" data-field="x_works" data-value-separator="<?php echo $job_card->works->displayValueSeparatorAttribute() ?>" id="x_works" name="x_works"<?php echo $job_card->works->editAttributes() ?>>
		<?php echo $job_card->works->selectOptionListHtml("x_works") ?>
	</select>
</div>
<?php echo $job_card->works->Lookup->getParamTag("p_x_works") ?>
<?php echo $job_card->works->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->issue_to_internal->Visible) { // issue_to_internal ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_issue_to_internal"><?php echo $job_card->issue_to_internal->caption() ?><?php echo ($job_card->issue_to_internal->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card" data-field="x_issue_to_internal" data-value-separator="<?php echo $job_card->issue_to_internal->displayValueSeparatorAttribute() ?>" id="x_issue_to_internal" name="x_issue_to_internal"<?php echo $job_card->issue_to_internal->editAttributes() ?>>
		<?php echo $job_card->issue_to_internal->selectOptionListHtml("x_issue_to_internal") ?>
	</select>
</div>
<?php echo $job_card->issue_to_internal->Lookup->getParamTag("p_x_issue_to_internal") ?>
<?php echo $job_card->issue_to_internal->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->issue_to_external->Visible) { // issue_to_external ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_issue_to_external"><?php echo $job_card->issue_to_external->caption() ?><?php echo ($job_card->issue_to_external->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card" data-field="x_issue_to_external" data-value-separator="<?php echo $job_card->issue_to_external->displayValueSeparatorAttribute() ?>" id="x_issue_to_external" name="x_issue_to_external"<?php echo $job_card->issue_to_external->editAttributes() ?>>
		<?php echo $job_card->issue_to_external->selectOptionListHtml("x_issue_to_external") ?>
	</select>
</div>
<?php echo $job_card->issue_to_external->Lookup->getParamTag("p_x_issue_to_external") ?>
<?php echo $job_card->issue_to_external->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->issue_to->Visible) { // issue_to ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_issue_to"><?php echo $job_card->issue_to->caption() ?><?php echo ($job_card->issue_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card" data-field="x_issue_to" data-value-separator="<?php echo $job_card->issue_to->displayValueSeparatorAttribute() ?>" id="x_issue_to" name="x_issue_to"<?php echo $job_card->issue_to->editAttributes() ?>>
		<?php echo $job_card->issue_to->selectOptionListHtml("x_issue_to") ?>
	</select>
</div>
<?php echo $job_card->issue_to->Lookup->getParamTag("p_x_issue_to") ?>
<?php echo $job_card->issue_to->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->grp->Visible) { // grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_grp"><?php echo $job_card->grp->caption() ?><?php echo ($job_card->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $job_card->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$job_card->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card" data-field="x_grp" data-value-separator="<?php echo $job_card->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $job_card->grp->editAttributes() ?>>
		<?php echo $job_card->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $job_card->grp->Lookup->getParamTag("p_x_grp") ?>
<?php echo $job_card->grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->s_grp->Visible) { // s_grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_s_grp"><?php echo $job_card->s_grp->caption() ?><?php echo ($job_card->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $job_card->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$job_card->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card" data-field="x_s_grp" data-value-separator="<?php echo $job_card->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $job_card->s_grp->editAttributes() ?>>
		<?php echo $job_card->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $job_card->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
<?php echo $job_card->s_grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->packing_type->Visible) { // packing_type ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_packing_type"><?php echo $job_card->packing_type->caption() ?><?php echo ($job_card->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $job_card->packing_type->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$job_card->packing_type->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card" data-field="x_packing_type" data-value-separator="<?php echo $job_card->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $job_card->packing_type->editAttributes() ?>>
		<?php echo $job_card->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $job_card->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
<?php echo $job_card->packing_type->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->product_code->Visible) { // product_code ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_product_code"><?php echo $job_card->product_code->caption() ?><?php echo ($job_card->product_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $job_card->product_code->EditAttrs["onchange"] = "ew.autoFill(this);" . @$job_card->product_code->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card" data-field="x_product_code" data-value-separator="<?php echo $job_card->product_code->displayValueSeparatorAttribute() ?>" id="x_product_code" name="x_product_code"<?php echo $job_card->product_code->editAttributes() ?>>
		<?php echo $job_card->product_code->selectOptionListHtml("x_product_code") ?>
	</select>
</div>
<?php echo $job_card->product_code->Lookup->getParamTag("p_x_product_code") ?>
<?php echo $job_card->product_code->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->item->Visible) { // item ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $job_card->item->caption() ?><?php echo ($job_card->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$job_card->item->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$job_card->item->EditAttrs["onchange"] = "";
?>
<span id="as_x_item" class="text-nowrap" style="z-index: 8890">
	<input type="text" class="form-control" name="sv_x_item" id="sv_x_item" value="<?php echo RemoveHtml($job_card->item->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($job_card->item->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($job_card->item->getPlaceHolder()) ?>"<?php echo $job_card->item->editAttributes() ?>>
</span>
<input type="hidden" data-table="job_card" data-field="x_item" data-value-separator="<?php echo $job_card->item->displayValueSeparatorAttribute() ?>" name="x_item" id="x_item" value="<?php echo HtmlEncode($job_card->item->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fjob_cardaddopt.createAutoSuggest({"id":"x_item","forceSelect":true});
</script>
<?php echo $job_card->item->Lookup->getParamTag("p_x_item") ?>
<?php echo $job_card->item->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->poid->Visible) { // poid ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $job_card->poid->caption() ?><?php echo ($job_card->poid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_poid" class="ew-template"><input type="checkbox" class="form-check-input" data-table="job_card" data-field="x_poid" data-value-separator="<?php echo $job_card->poid->displayValueSeparatorAttribute() ?>" name="x_poid[]" id="x_poid[]" value="{value}"<?php echo $job_card->poid->editAttributes() ?>></div>
<div id="dsl_x_poid" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $job_card->poid->checkBoxListHtml(FALSE, "x_poid[]") ?>
</div></div>
<?php echo $job_card->poid->Lookup->getParamTag("p_x_poid") ?>
<?php echo $job_card->poid->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->batch_no->Visible) { // batch_no ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $job_card->batch_no->caption() ?><?php echo ($job_card->batch_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_batch_no" class="ew-template"><input type="radio" class="form-check-input" data-table="job_card" data-field="x_batch_no" data-value-separator="<?php echo $job_card->batch_no->displayValueSeparatorAttribute() ?>" name="x_batch_no" id="x_batch_no" value="{value}"<?php echo $job_card->batch_no->editAttributes() ?>></div>
<div id="dsl_x_batch_no" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $job_card->batch_no->radioButtonListHtml(FALSE, "x_batch_no") ?>
</div></div>
<?php echo $job_card->batch_no->Lookup->getParamTag("p_x_batch_no") ?>
<?php echo $job_card->batch_no->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->quantity->Visible) { // quantity ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_quantity"><?php echo $job_card->quantity->caption() ?><?php echo ($job_card->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="job_card" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($job_card->quantity->getPlaceHolder()) ?>" value="<?php echo $job_card->quantity->EditValue ?>"<?php echo $job_card->quantity->editAttributes() ?>>
<?php echo $job_card->quantity->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->lot_no->Visible) { // lot_no ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_lot_no"><?php echo $job_card->lot_no->caption() ?><?php echo ($job_card->lot_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="job_card" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($job_card->lot_no->getPlaceHolder()) ?>" value="<?php echo $job_card->lot_no->EditValue ?>"<?php echo $job_card->lot_no->editAttributes() ?>>
<?php echo $job_card->lot_no->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->pro_unit->Visible) { // pro_unit ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_pro_unit"><?php echo $job_card->pro_unit->caption() ?><?php echo ($job_card->pro_unit->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $job_card->pro_unit->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$job_card->pro_unit->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card" data-field="x_pro_unit" data-value-separator="<?php echo $job_card->pro_unit->displayValueSeparatorAttribute() ?>" id="x_pro_unit" name="x_pro_unit"<?php echo $job_card->pro_unit->editAttributes() ?>>
		<?php echo $job_card->pro_unit->selectOptionListHtml("x_pro_unit") ?>
	</select>
</div>
<?php echo $job_card->pro_unit->Lookup->getParamTag("p_x_pro_unit") ?>
<?php echo $job_card->pro_unit->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->employee_id->Visible) { // employee_id ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $job_card->employee_id->caption() ?><?php echo ($job_card->employee_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_employee_id"><?php echo strval($job_card->employee_id->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($job_card->employee_id->ViewValue) : $job_card->employee_id->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($job_card->employee_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($job_card->employee_id->ReadOnly || $job_card->employee_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_employee_id[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $job_card->employee_id->Lookup->getParamTag("p_x_employee_id") ?>
<input type="hidden" data-table="job_card" data-field="x_employee_id" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $job_card->employee_id->displayValueSeparatorAttribute() ?>" name="x_employee_id[]" id="x_employee_id[]" value="<?php echo $job_card->employee_id->CurrentValue ?>"<?php echo $job_card->employee_id->editAttributes() ?>>
<?php echo $job_card->employee_id->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->_1->Visible) { // 1 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x__1"><?php echo $job_card->_1->caption() ?><?php echo ($job_card->_1->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="job_card" data-field="x__1" name="x__1" id="x__1" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->_1->getPlaceHolder()) ?>" value="<?php echo $job_card->_1->EditValue ?>"<?php echo $job_card->_1->editAttributes() ?>>
<?php echo $job_card->_1->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->_2->Visible) { // 2 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x__2"><?php echo $job_card->_2->caption() ?><?php echo ($job_card->_2->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="job_card" data-field="x__2" name="x__2" id="x__2" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->_2->getPlaceHolder()) ?>" value="<?php echo $job_card->_2->EditValue ?>"<?php echo $job_card->_2->editAttributes() ?>>
<?php echo $job_card->_2->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->_3->Visible) { // 3 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x__3"><?php echo $job_card->_3->caption() ?><?php echo ($job_card->_3->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="job_card" data-field="x__3" name="x__3" id="x__3" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->_3->getPlaceHolder()) ?>" value="<?php echo $job_card->_3->EditValue ?>"<?php echo $job_card->_3->editAttributes() ?>>
<?php echo $job_card->_3->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->_4->Visible) { // 4 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x__4"><?php echo $job_card->_4->caption() ?><?php echo ($job_card->_4->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="job_card" data-field="x__4" name="x__4" id="x__4" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->_4->getPlaceHolder()) ?>" value="<?php echo $job_card->_4->EditValue ?>"<?php echo $job_card->_4->editAttributes() ?>>
<?php echo $job_card->_4->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->_5->Visible) { // 5 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x__5"><?php echo $job_card->_5->caption() ?><?php echo ($job_card->_5->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="job_card" data-field="x__5" name="x__5" id="x__5" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->_5->getPlaceHolder()) ?>" value="<?php echo $job_card->_5->EditValue ?>"<?php echo $job_card->_5->editAttributes() ?>>
<?php echo $job_card->_5->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->_6->Visible) { // 6 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x__6"><?php echo $job_card->_6->caption() ?><?php echo ($job_card->_6->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="job_card" data-field="x__6" name="x__6" id="x__6" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->_6->getPlaceHolder()) ?>" value="<?php echo $job_card->_6->EditValue ?>"<?php echo $job_card->_6->editAttributes() ?>>
<?php echo $job_card->_6->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->_7->Visible) { // 7 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x__7"><?php echo $job_card->_7->caption() ?><?php echo ($job_card->_7->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="job_card" data-field="x__7" name="x__7" id="x__7" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->_7->getPlaceHolder()) ?>" value="<?php echo $job_card->_7->EditValue ?>"<?php echo $job_card->_7->editAttributes() ?>>
<?php echo $job_card->_7->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->_8->Visible) { // 8 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x__8"><?php echo $job_card->_8->caption() ?><?php echo ($job_card->_8->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="job_card" data-field="x__8" name="x__8" id="x__8" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->_8->getPlaceHolder()) ?>" value="<?php echo $job_card->_8->EditValue ?>"<?php echo $job_card->_8->editAttributes() ?>>
<?php echo $job_card->_8->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->other1->Visible) { // other1 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_other1"><?php echo $job_card->other1->caption() ?><?php echo ($job_card->other1->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="job_card" data-field="x_other1" name="x_other1" id="x_other1" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->other1->getPlaceHolder()) ?>" value="<?php echo $job_card->other1->EditValue ?>"<?php echo $job_card->other1->editAttributes() ?>>
<?php echo $job_card->other1->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->other2->Visible) { // other2 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_other2"><?php echo $job_card->other2->caption() ?><?php echo ($job_card->other2->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="job_card" data-field="x_other2" name="x_other2" id="x_other2" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->other2->getPlaceHolder()) ?>" value="<?php echo $job_card->other2->EditValue ?>"<?php echo $job_card->other2->editAttributes() ?>>
<?php echo $job_card->other2->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->operator->Visible) { // operator ?>
	<input type="hidden" data-table="job_card" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($job_card->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($job_card->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="job_card" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($job_card->datetime->CurrentValue) ?>">
	<?php if (!$job_card->datetime->ReadOnly && !$job_card->datetime->Disabled && !isset($job_card->datetime->EditAttrs["readonly"]) && !isset($job_card->datetime->EditAttrs["disabled"])) { ?>
	<script>
	ew.createDateTimePicker("fjob_cardaddopt", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
	</script>
	<?php } ?>
<?php } ?>
<?php if ($job_card->updated->Visible) { // updated ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_updated"><?php echo $job_card->updated->caption() ?><?php echo ($job_card->updated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="job_card" data-field="x_updated" name="x_updated" id="x_updated" size="30" placeholder="<?php echo HtmlEncode($job_card->updated->getPlaceHolder()) ?>" value="<?php echo $job_card->updated->EditValue ?>"<?php echo $job_card->updated->editAttributes() ?>>
<?php echo $job_card->updated->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->in_id->Visible) { // in_id ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_in_id"><?php echo $job_card->in_id->caption() ?><?php echo ($job_card->in_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="job_card" data-field="x_in_id" name="x_in_id" id="x_in_id" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($job_card->in_id->getPlaceHolder()) ?>" value="<?php echo $job_card->in_id->EditValue ?>"<?php echo $job_card->in_id->editAttributes() ?>>
<?php echo $job_card->in_id->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->balance_quantity->Visible) { // balance_quantity ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_balance_quantity"><?php echo $job_card->balance_quantity->caption() ?><?php echo ($job_card->balance_quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="job_card" data-field="x_balance_quantity" name="x_balance_quantity" id="x_balance_quantity" size="30" placeholder="<?php echo HtmlEncode($job_card->balance_quantity->getPlaceHolder()) ?>" value="<?php echo $job_card->balance_quantity->EditValue ?>"<?php echo $job_card->balance_quantity->editAttributes() ?>>
<?php echo $job_card->balance_quantity->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->product->Visible) { // product ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_product"><?php echo $job_card->product->caption() ?><?php echo ($job_card->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="job_card" data-field="x_product" name="x_product" id="x_product" size="30" placeholder="<?php echo HtmlEncode($job_card->product->getPlaceHolder()) ?>" value="<?php echo $job_card->product->EditValue ?>"<?php echo $job_card->product->editAttributes() ?>>
<?php echo $job_card->product->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->buyer_id->Visible) { // buyer_id ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_buyer_id"><?php echo $job_card->buyer_id->caption() ?><?php echo ($job_card->buyer_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="job_card" data-field="x_buyer_id" name="x_buyer_id" id="x_buyer_id" size="30" placeholder="<?php echo HtmlEncode($job_card->buyer_id->getPlaceHolder()) ?>" value="<?php echo $job_card->buyer_id->EditValue ?>"<?php echo $job_card->buyer_id->editAttributes() ?>>
<?php echo $job_card->buyer_id->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($job_card->company_id->Visible) { // company_id ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_company_id"><?php echo $job_card->company_id->caption() ?><?php echo ($job_card->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="job_card" data-field="x_company_id" name="x_company_id" id="x_company_id" size="30" placeholder="<?php echo HtmlEncode($job_card->company_id->getPlaceHolder()) ?>" value="<?php echo $job_card->company_id->EditValue ?>"<?php echo $job_card->company_id->editAttributes() ?>>
<?php echo $job_card->company_id->CustomMsg ?></div>
	</div>
<?php } ?>
</form>
<?php
$job_card_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$job_card_addopt->terminate();
?>