<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$job_card_edit = new job_card_edit();

// Run the page
$job_card_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$job_card_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fjob_cardedit = currentForm = new ew.Form("fjob_cardedit", "edit");

// Validate form
fjob_cardedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($job_card_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->id->caption(), $job_card->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_edit->jc_no->Required) { ?>
			elm = this.getElements("x" + infix + "_jc_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->jc_no->caption(), $job_card->jc_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_jc_no");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($job_card->jc_no->errorMessage()) ?>");
		<?php if ($job_card_edit->works->Required) { ?>
			elm = this.getElements("x" + infix + "_works");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->works->caption(), $job_card->works->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_edit->issue_to_internal->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_to_internal");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->issue_to_internal->caption(), $job_card->issue_to_internal->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_edit->issue_to_external->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_to_external");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->issue_to_external->caption(), $job_card->issue_to_external->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_edit->issue_to->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->issue_to->caption(), $job_card->issue_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->grp->caption(), $job_card->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_edit->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->s_grp->caption(), $job_card->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_edit->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->packing_type->caption(), $job_card->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_edit->product_code->Required) { ?>
			elm = this.getElements("x" + infix + "_product_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->product_code->caption(), $job_card->product_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_edit->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->item->caption(), $job_card->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_edit->poid->Required) { ?>
			elm = this.getElements("x" + infix + "_poid[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->poid->caption(), $job_card->poid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_edit->batch_no->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->batch_no->caption(), $job_card->batch_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_edit->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->quantity->caption(), $job_card->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($job_card->quantity->errorMessage()) ?>");
		<?php if ($job_card_edit->pro_unit->Required) { ?>
			elm = this.getElements("x" + infix + "_pro_unit");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->pro_unit->caption(), $job_card->pro_unit->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_edit->employee_id->Required) { ?>
			elm = this.getElements("x" + infix + "_employee_id[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->employee_id->caption(), $job_card->employee_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_edit->_1->Required) { ?>
			elm = this.getElements("x" + infix + "__1");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->_1->caption(), $job_card->_1->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_edit->_2->Required) { ?>
			elm = this.getElements("x" + infix + "__2");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->_2->caption(), $job_card->_2->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_edit->_3->Required) { ?>
			elm = this.getElements("x" + infix + "__3");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->_3->caption(), $job_card->_3->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_edit->_4->Required) { ?>
			elm = this.getElements("x" + infix + "__4");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->_4->caption(), $job_card->_4->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_edit->_5->Required) { ?>
			elm = this.getElements("x" + infix + "__5");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->_5->caption(), $job_card->_5->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_edit->_6->Required) { ?>
			elm = this.getElements("x" + infix + "__6");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->_6->caption(), $job_card->_6->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_edit->_7->Required) { ?>
			elm = this.getElements("x" + infix + "__7");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->_7->caption(), $job_card->_7->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_edit->_8->Required) { ?>
			elm = this.getElements("x" + infix + "__8");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->_8->caption(), $job_card->_8->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_edit->other1->Required) { ?>
			elm = this.getElements("x" + infix + "_other1");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->other1->caption(), $job_card->other1->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_edit->other2->Required) { ?>
			elm = this.getElements("x" + infix + "_other2");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->other2->caption(), $job_card->other2->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->operator->caption(), $job_card->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->datetime->caption(), $job_card->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($job_card_edit->buyer_id->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->buyer_id->caption(), $job_card->buyer_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_buyer_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($job_card->buyer_id->errorMessage()) ?>");
		<?php if ($job_card_edit->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $job_card->company_id->caption(), $job_card->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($job_card->company_id->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fjob_cardedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjob_cardedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjob_cardedit.lists["x_works"] = <?php echo $job_card_edit->works->Lookup->toClientList() ?>;
fjob_cardedit.lists["x_works"].options = <?php echo JsonEncode($job_card_edit->works->lookupOptions()) ?>;
fjob_cardedit.lists["x_issue_to_internal"] = <?php echo $job_card_edit->issue_to_internal->Lookup->toClientList() ?>;
fjob_cardedit.lists["x_issue_to_internal"].options = <?php echo JsonEncode($job_card_edit->issue_to_internal->lookupOptions()) ?>;
fjob_cardedit.lists["x_issue_to_external"] = <?php echo $job_card_edit->issue_to_external->Lookup->toClientList() ?>;
fjob_cardedit.lists["x_issue_to_external"].options = <?php echo JsonEncode($job_card_edit->issue_to_external->lookupOptions()) ?>;
fjob_cardedit.lists["x_issue_to"] = <?php echo $job_card_edit->issue_to->Lookup->toClientList() ?>;
fjob_cardedit.lists["x_issue_to"].options = <?php echo JsonEncode($job_card_edit->issue_to->lookupOptions()) ?>;
fjob_cardedit.lists["x_grp"] = <?php echo $job_card_edit->grp->Lookup->toClientList() ?>;
fjob_cardedit.lists["x_grp"].options = <?php echo JsonEncode($job_card_edit->grp->lookupOptions()) ?>;
fjob_cardedit.lists["x_s_grp"] = <?php echo $job_card_edit->s_grp->Lookup->toClientList() ?>;
fjob_cardedit.lists["x_s_grp"].options = <?php echo JsonEncode($job_card_edit->s_grp->lookupOptions()) ?>;
fjob_cardedit.lists["x_packing_type"] = <?php echo $job_card_edit->packing_type->Lookup->toClientList() ?>;
fjob_cardedit.lists["x_packing_type"].options = <?php echo JsonEncode($job_card_edit->packing_type->lookupOptions()) ?>;
fjob_cardedit.lists["x_product_code"] = <?php echo $job_card_edit->product_code->Lookup->toClientList() ?>;
fjob_cardedit.lists["x_product_code"].options = <?php echo JsonEncode($job_card_edit->product_code->lookupOptions()) ?>;
fjob_cardedit.lists["x_item"] = <?php echo $job_card_edit->item->Lookup->toClientList() ?>;
fjob_cardedit.lists["x_item"].options = <?php echo JsonEncode($job_card_edit->item->lookupOptions()) ?>;
fjob_cardedit.autoSuggests["x_item"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fjob_cardedit.lists["x_poid[]"] = <?php echo $job_card_edit->poid->Lookup->toClientList() ?>;
fjob_cardedit.lists["x_poid[]"].options = <?php echo JsonEncode($job_card_edit->poid->lookupOptions()) ?>;
fjob_cardedit.lists["x_batch_no"] = <?php echo $job_card_edit->batch_no->Lookup->toClientList() ?>;
fjob_cardedit.lists["x_batch_no"].options = <?php echo JsonEncode($job_card_edit->batch_no->lookupOptions()) ?>;
fjob_cardedit.lists["x_pro_unit"] = <?php echo $job_card_edit->pro_unit->Lookup->toClientList() ?>;
fjob_cardedit.lists["x_pro_unit"].options = <?php echo JsonEncode($job_card_edit->pro_unit->lookupOptions()) ?>;
fjob_cardedit.lists["x_employee_id[]"] = <?php echo $job_card_edit->employee_id->Lookup->toClientList() ?>;
fjob_cardedit.lists["x_employee_id[]"].options = <?php echo JsonEncode($job_card_edit->employee_id->lookupOptions()) ?>;
fjob_cardedit.lists["x_operator"] = <?php echo $job_card_edit->operator->Lookup->toClientList() ?>;
fjob_cardedit.lists["x_operator"].options = <?php echo JsonEncode($job_card_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $job_card_edit->showPageHeader(); ?>
<?php
$job_card_edit->showMessage();
?>
<form name="fjob_cardedit" id="fjob_cardedit" class="<?php echo $job_card_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($job_card_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $job_card_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="job_card">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$job_card_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($job_card->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_job_card_id" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->id->caption() ?><?php echo ($job_card->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->id->cellAttributes() ?>>
<span id="el_job_card_id">
<span<?php echo $job_card->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($job_card->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="job_card" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($job_card->id->CurrentValue) ?>">
<?php echo $job_card->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card->jc_no->Visible) { // jc_no ?>
	<div id="r_jc_no" class="form-group row">
		<label id="elh_job_card_jc_no" for="x_jc_no" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->jc_no->caption() ?><?php echo ($job_card->jc_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->jc_no->cellAttributes() ?>>
<span id="el_job_card_jc_no">
<input type="text" data-table="job_card" data-field="x_jc_no" name="x_jc_no" id="x_jc_no" size="30" placeholder="<?php echo HtmlEncode($job_card->jc_no->getPlaceHolder()) ?>" value="<?php echo $job_card->jc_no->EditValue ?>"<?php echo $job_card->jc_no->editAttributes() ?>>
</span>
<?php echo $job_card->jc_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card->works->Visible) { // works ?>
	<div id="r_works" class="form-group row">
		<label id="elh_job_card_works" for="x_works" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->works->caption() ?><?php echo ($job_card->works->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->works->cellAttributes() ?>>
<span id="el_job_card_works">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card" data-field="x_works" data-value-separator="<?php echo $job_card->works->displayValueSeparatorAttribute() ?>" id="x_works" name="x_works"<?php echo $job_card->works->editAttributes() ?>>
		<?php echo $job_card->works->selectOptionListHtml("x_works") ?>
	</select>
</div>
<?php echo $job_card->works->Lookup->getParamTag("p_x_works") ?>
</span>
<?php echo $job_card->works->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card->issue_to_internal->Visible) { // issue_to_internal ?>
	<div id="r_issue_to_internal" class="form-group row">
		<label id="elh_job_card_issue_to_internal" for="x_issue_to_internal" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->issue_to_internal->caption() ?><?php echo ($job_card->issue_to_internal->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->issue_to_internal->cellAttributes() ?>>
<span id="el_job_card_issue_to_internal">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card" data-field="x_issue_to_internal" data-value-separator="<?php echo $job_card->issue_to_internal->displayValueSeparatorAttribute() ?>" id="x_issue_to_internal" name="x_issue_to_internal"<?php echo $job_card->issue_to_internal->editAttributes() ?>>
		<?php echo $job_card->issue_to_internal->selectOptionListHtml("x_issue_to_internal") ?>
	</select>
</div>
<?php echo $job_card->issue_to_internal->Lookup->getParamTag("p_x_issue_to_internal") ?>
</span>
<?php echo $job_card->issue_to_internal->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card->issue_to_external->Visible) { // issue_to_external ?>
	<div id="r_issue_to_external" class="form-group row">
		<label id="elh_job_card_issue_to_external" for="x_issue_to_external" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->issue_to_external->caption() ?><?php echo ($job_card->issue_to_external->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->issue_to_external->cellAttributes() ?>>
<span id="el_job_card_issue_to_external">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card" data-field="x_issue_to_external" data-value-separator="<?php echo $job_card->issue_to_external->displayValueSeparatorAttribute() ?>" id="x_issue_to_external" name="x_issue_to_external"<?php echo $job_card->issue_to_external->editAttributes() ?>>
		<?php echo $job_card->issue_to_external->selectOptionListHtml("x_issue_to_external") ?>
	</select>
</div>
<?php echo $job_card->issue_to_external->Lookup->getParamTag("p_x_issue_to_external") ?>
</span>
<?php echo $job_card->issue_to_external->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card->issue_to->Visible) { // issue_to ?>
	<div id="r_issue_to" class="form-group row">
		<label id="elh_job_card_issue_to" for="x_issue_to" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->issue_to->caption() ?><?php echo ($job_card->issue_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->issue_to->cellAttributes() ?>>
<span id="el_job_card_issue_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card" data-field="x_issue_to" data-value-separator="<?php echo $job_card->issue_to->displayValueSeparatorAttribute() ?>" id="x_issue_to" name="x_issue_to"<?php echo $job_card->issue_to->editAttributes() ?>>
		<?php echo $job_card->issue_to->selectOptionListHtml("x_issue_to") ?>
	</select>
</div>
<?php echo $job_card->issue_to->Lookup->getParamTag("p_x_issue_to") ?>
</span>
<?php echo $job_card->issue_to->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_job_card_grp" for="x_grp" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->grp->caption() ?><?php echo ($job_card->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->grp->cellAttributes() ?>>
<span id="el_job_card_grp">
<?php $job_card->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$job_card->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card" data-field="x_grp" data-value-separator="<?php echo $job_card->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $job_card->grp->editAttributes() ?>>
		<?php echo $job_card->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $job_card->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $job_card->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_job_card_s_grp" for="x_s_grp" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->s_grp->caption() ?><?php echo ($job_card->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->s_grp->cellAttributes() ?>>
<span id="el_job_card_s_grp">
<?php $job_card->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$job_card->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card" data-field="x_s_grp" data-value-separator="<?php echo $job_card->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $job_card->s_grp->editAttributes() ?>>
		<?php echo $job_card->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $job_card->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
<?php echo $job_card->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label id="elh_job_card_packing_type" for="x_packing_type" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->packing_type->caption() ?><?php echo ($job_card->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->packing_type->cellAttributes() ?>>
<span id="el_job_card_packing_type">
<?php $job_card->packing_type->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$job_card->packing_type->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card" data-field="x_packing_type" data-value-separator="<?php echo $job_card->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $job_card->packing_type->editAttributes() ?>>
		<?php echo $job_card->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $job_card->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
<?php echo $job_card->packing_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label id="elh_job_card_product_code" for="x_product_code" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->product_code->caption() ?><?php echo ($job_card->product_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->product_code->cellAttributes() ?>>
<span id="el_job_card_product_code">
<?php $job_card->product_code->EditAttrs["onchange"] = "ew.autoFill(this);" . @$job_card->product_code->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card" data-field="x_product_code" data-value-separator="<?php echo $job_card->product_code->displayValueSeparatorAttribute() ?>" id="x_product_code" name="x_product_code"<?php echo $job_card->product_code->editAttributes() ?>>
		<?php echo $job_card->product_code->selectOptionListHtml("x_product_code") ?>
	</select>
</div>
<?php echo $job_card->product_code->Lookup->getParamTag("p_x_product_code") ?>
</span>
<?php echo $job_card->product_code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label id="elh_job_card_item" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->item->caption() ?><?php echo ($job_card->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->item->cellAttributes() ?>>
<span id="el_job_card_item">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$job_card->item->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$job_card->item->EditAttrs["onchange"] = "";
?>
<span id="as_x_item" class="text-nowrap" style="z-index: 8890">
	<input type="text" class="form-control" name="sv_x_item" id="sv_x_item" value="<?php echo RemoveHtml($job_card->item->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($job_card->item->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($job_card->item->getPlaceHolder()) ?>"<?php echo $job_card->item->editAttributes() ?>>
</span>
<input type="hidden" data-table="job_card" data-field="x_item" data-value-separator="<?php echo $job_card->item->displayValueSeparatorAttribute() ?>" name="x_item" id="x_item" value="<?php echo HtmlEncode($job_card->item->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fjob_cardedit.createAutoSuggest({"id":"x_item","forceSelect":true});
</script>
<?php echo $job_card->item->Lookup->getParamTag("p_x_item") ?>
</span>
<?php echo $job_card->item->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card->poid->Visible) { // poid ?>
	<div id="r_poid" class="form-group row">
		<label id="elh_job_card_poid" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->poid->caption() ?><?php echo ($job_card->poid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->poid->cellAttributes() ?>>
<span id="el_job_card_poid">
<div id="tp_x_poid" class="ew-template"><input type="checkbox" class="form-check-input" data-table="job_card" data-field="x_poid" data-value-separator="<?php echo $job_card->poid->displayValueSeparatorAttribute() ?>" name="x_poid[]" id="x_poid[]" value="{value}"<?php echo $job_card->poid->editAttributes() ?>></div>
<div id="dsl_x_poid" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $job_card->poid->checkBoxListHtml(FALSE, "x_poid[]") ?>
</div></div>
<?php echo $job_card->poid->Lookup->getParamTag("p_x_poid") ?>
</span>
<?php echo $job_card->poid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label id="elh_job_card_batch_no" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->batch_no->caption() ?><?php echo ($job_card->batch_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->batch_no->cellAttributes() ?>>
<span id="el_job_card_batch_no">
<div id="tp_x_batch_no" class="ew-template"><input type="radio" class="form-check-input" data-table="job_card" data-field="x_batch_no" data-value-separator="<?php echo $job_card->batch_no->displayValueSeparatorAttribute() ?>" name="x_batch_no" id="x_batch_no" value="{value}"<?php echo $job_card->batch_no->editAttributes() ?>></div>
<div id="dsl_x_batch_no" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $job_card->batch_no->radioButtonListHtml(FALSE, "x_batch_no") ?>
</div></div>
<?php echo $job_card->batch_no->Lookup->getParamTag("p_x_batch_no") ?>
</span>
<?php echo $job_card->batch_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_job_card_quantity" for="x_quantity" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->quantity->caption() ?><?php echo ($job_card->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->quantity->cellAttributes() ?>>
<span id="el_job_card_quantity">
<input type="text" data-table="job_card" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($job_card->quantity->getPlaceHolder()) ?>" value="<?php echo $job_card->quantity->EditValue ?>"<?php echo $job_card->quantity->editAttributes() ?>>
</span>
<?php echo $job_card->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card->pro_unit->Visible) { // pro_unit ?>
	<div id="r_pro_unit" class="form-group row">
		<label id="elh_job_card_pro_unit" for="x_pro_unit" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->pro_unit->caption() ?><?php echo ($job_card->pro_unit->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->pro_unit->cellAttributes() ?>>
<span id="el_job_card_pro_unit">
<?php $job_card->pro_unit->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$job_card->pro_unit->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card" data-field="x_pro_unit" data-value-separator="<?php echo $job_card->pro_unit->displayValueSeparatorAttribute() ?>" id="x_pro_unit" name="x_pro_unit"<?php echo $job_card->pro_unit->editAttributes() ?>>
		<?php echo $job_card->pro_unit->selectOptionListHtml("x_pro_unit") ?>
	</select>
</div>
<?php echo $job_card->pro_unit->Lookup->getParamTag("p_x_pro_unit") ?>
</span>
<?php echo $job_card->pro_unit->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card->employee_id->Visible) { // employee_id ?>
	<div id="r_employee_id" class="form-group row">
		<label id="elh_job_card_employee_id" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->employee_id->caption() ?><?php echo ($job_card->employee_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->employee_id->cellAttributes() ?>>
<span id="el_job_card_employee_id">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_employee_id"><?php echo strval($job_card->employee_id->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($job_card->employee_id->ViewValue) : $job_card->employee_id->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($job_card->employee_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($job_card->employee_id->ReadOnly || $job_card->employee_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_employee_id[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $job_card->employee_id->Lookup->getParamTag("p_x_employee_id") ?>
<input type="hidden" data-table="job_card" data-field="x_employee_id" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $job_card->employee_id->displayValueSeparatorAttribute() ?>" name="x_employee_id[]" id="x_employee_id[]" value="<?php echo $job_card->employee_id->CurrentValue ?>"<?php echo $job_card->employee_id->editAttributes() ?>>
</span>
<?php echo $job_card->employee_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card->_1->Visible) { // 1 ?>
	<div id="r__1" class="form-group row">
		<label id="elh_job_card__1" for="x__1" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->_1->caption() ?><?php echo ($job_card->_1->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->_1->cellAttributes() ?>>
<span id="el_job_card__1">
<input type="text" data-table="job_card" data-field="x__1" name="x__1" id="x__1" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->_1->getPlaceHolder()) ?>" value="<?php echo $job_card->_1->EditValue ?>"<?php echo $job_card->_1->editAttributes() ?>>
</span>
<?php echo $job_card->_1->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card->_2->Visible) { // 2 ?>
	<div id="r__2" class="form-group row">
		<label id="elh_job_card__2" for="x__2" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->_2->caption() ?><?php echo ($job_card->_2->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->_2->cellAttributes() ?>>
<span id="el_job_card__2">
<input type="text" data-table="job_card" data-field="x__2" name="x__2" id="x__2" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->_2->getPlaceHolder()) ?>" value="<?php echo $job_card->_2->EditValue ?>"<?php echo $job_card->_2->editAttributes() ?>>
</span>
<?php echo $job_card->_2->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card->_3->Visible) { // 3 ?>
	<div id="r__3" class="form-group row">
		<label id="elh_job_card__3" for="x__3" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->_3->caption() ?><?php echo ($job_card->_3->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->_3->cellAttributes() ?>>
<span id="el_job_card__3">
<input type="text" data-table="job_card" data-field="x__3" name="x__3" id="x__3" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->_3->getPlaceHolder()) ?>" value="<?php echo $job_card->_3->EditValue ?>"<?php echo $job_card->_3->editAttributes() ?>>
</span>
<?php echo $job_card->_3->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card->_4->Visible) { // 4 ?>
	<div id="r__4" class="form-group row">
		<label id="elh_job_card__4" for="x__4" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->_4->caption() ?><?php echo ($job_card->_4->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->_4->cellAttributes() ?>>
<span id="el_job_card__4">
<input type="text" data-table="job_card" data-field="x__4" name="x__4" id="x__4" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->_4->getPlaceHolder()) ?>" value="<?php echo $job_card->_4->EditValue ?>"<?php echo $job_card->_4->editAttributes() ?>>
</span>
<?php echo $job_card->_4->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card->_5->Visible) { // 5 ?>
	<div id="r__5" class="form-group row">
		<label id="elh_job_card__5" for="x__5" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->_5->caption() ?><?php echo ($job_card->_5->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->_5->cellAttributes() ?>>
<span id="el_job_card__5">
<input type="text" data-table="job_card" data-field="x__5" name="x__5" id="x__5" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->_5->getPlaceHolder()) ?>" value="<?php echo $job_card->_5->EditValue ?>"<?php echo $job_card->_5->editAttributes() ?>>
</span>
<?php echo $job_card->_5->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card->_6->Visible) { // 6 ?>
	<div id="r__6" class="form-group row">
		<label id="elh_job_card__6" for="x__6" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->_6->caption() ?><?php echo ($job_card->_6->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->_6->cellAttributes() ?>>
<span id="el_job_card__6">
<input type="text" data-table="job_card" data-field="x__6" name="x__6" id="x__6" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->_6->getPlaceHolder()) ?>" value="<?php echo $job_card->_6->EditValue ?>"<?php echo $job_card->_6->editAttributes() ?>>
</span>
<?php echo $job_card->_6->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card->_7->Visible) { // 7 ?>
	<div id="r__7" class="form-group row">
		<label id="elh_job_card__7" for="x__7" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->_7->caption() ?><?php echo ($job_card->_7->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->_7->cellAttributes() ?>>
<span id="el_job_card__7">
<input type="text" data-table="job_card" data-field="x__7" name="x__7" id="x__7" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->_7->getPlaceHolder()) ?>" value="<?php echo $job_card->_7->EditValue ?>"<?php echo $job_card->_7->editAttributes() ?>>
</span>
<?php echo $job_card->_7->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card->_8->Visible) { // 8 ?>
	<div id="r__8" class="form-group row">
		<label id="elh_job_card__8" for="x__8" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->_8->caption() ?><?php echo ($job_card->_8->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->_8->cellAttributes() ?>>
<span id="el_job_card__8">
<input type="text" data-table="job_card" data-field="x__8" name="x__8" id="x__8" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->_8->getPlaceHolder()) ?>" value="<?php echo $job_card->_8->EditValue ?>"<?php echo $job_card->_8->editAttributes() ?>>
</span>
<?php echo $job_card->_8->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card->other1->Visible) { // other1 ?>
	<div id="r_other1" class="form-group row">
		<label id="elh_job_card_other1" for="x_other1" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->other1->caption() ?><?php echo ($job_card->other1->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->other1->cellAttributes() ?>>
<span id="el_job_card_other1">
<input type="text" data-table="job_card" data-field="x_other1" name="x_other1" id="x_other1" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->other1->getPlaceHolder()) ?>" value="<?php echo $job_card->other1->EditValue ?>"<?php echo $job_card->other1->editAttributes() ?>>
</span>
<?php echo $job_card->other1->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card->other2->Visible) { // other2 ?>
	<div id="r_other2" class="form-group row">
		<label id="elh_job_card_other2" for="x_other2" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->other2->caption() ?><?php echo ($job_card->other2->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->other2->cellAttributes() ?>>
<span id="el_job_card_other2">
<input type="text" data-table="job_card" data-field="x_other2" name="x_other2" id="x_other2" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->other2->getPlaceHolder()) ?>" value="<?php echo $job_card->other2->EditValue ?>"<?php echo $job_card->other2->editAttributes() ?>>
</span>
<?php echo $job_card->other2->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label id="elh_job_card_buyer_id" for="x_buyer_id" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->buyer_id->caption() ?><?php echo ($job_card->buyer_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->buyer_id->cellAttributes() ?>>
<span id="el_job_card_buyer_id">
<input type="text" data-table="job_card" data-field="x_buyer_id" name="x_buyer_id" id="x_buyer_id" size="30" placeholder="<?php echo HtmlEncode($job_card->buyer_id->getPlaceHolder()) ?>" value="<?php echo $job_card->buyer_id->EditValue ?>"<?php echo $job_card->buyer_id->editAttributes() ?>>
</span>
<?php echo $job_card->buyer_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($job_card->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label id="elh_job_card_company_id" for="x_company_id" class="<?php echo $job_card_edit->LeftColumnClass ?>"><?php echo $job_card->company_id->caption() ?><?php echo ($job_card->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $job_card_edit->RightColumnClass ?>"><div<?php echo $job_card->company_id->cellAttributes() ?>>
<span id="el_job_card_company_id">
<input type="text" data-table="job_card" data-field="x_company_id" name="x_company_id" id="x_company_id" size="30" placeholder="<?php echo HtmlEncode($job_card->company_id->getPlaceHolder()) ?>" value="<?php echo $job_card->company_id->EditValue ?>"<?php echo $job_card->company_id->editAttributes() ?>>
</span>
<?php echo $job_card->company_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$job_card_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $job_card_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $job_card_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$job_card_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

		var SGrp = $("#x_s_grp").val();
		document.cookie = "s_grp="+SGrp;
		if (SGrp.length > 0)
		{
		$.getJSON("apcajax.php?getHead="+SGrp,function(data){
					if (data.jc_01_head == '--NA--') {
					$("#r__1").hide(); } else {
					$("#r__1").show();					
					$("#elh_job_card__1").html(data.jc_01_head);}
					if (data.jc_02_head == '--NA--') {
					$("#r__2").hide(); } else {
					$("#r__2").show();					
					$("#elh_job_card__2").html(data.jc_02_head);}
					if (data.jc_03_head == '--NA--') {
					$("#r__3").hide(); } else {
					$("#r__3").show();					
					$("#elh_job_card__3").html(data.jc_03_head);}
					if (data.jc_04_head == '--NA--') {
					$("#r__4").hide(); } else {
					$("#r__4").show();					
					$("#elh_job_card__4").html(data.jc_04_head);}
					if (data.jc_05_head == '--NA--') {
					$("#r__5").hide(); } else {
					$("#r__5").show();					
					$("#elh_job_card__5").html(data.jc_05_head);}
					if (data.jc_06_head == '--NA--') {
					$("#r__6").hide(); } else {
					$("#r__6").show();					
					$("#elh_job_card__6").html(data.jc_06_head);}
					if (data.jc_07_head == '--NA--') {
					$("#r__7").hide(); } else {
					$("#r__7").show();					
					$("#elh_job_card__7").html(data.jc_07_head);}
					if (data.jc_08_head == '--NA--') {
					$("#r__8").hide(); } else {
					$("#r__8").show();					
					$("#elh_job_card__8").html(data.jc_08_head);}
					if (data.jc_09_head == '--NA--') {
					$("#r_other1").hide(); } else {
					$("#r_other1").show();					
					$("#elh_job_card_other1").html(data.jc_09_head);}
					if (data.jc_10_head == '--NA--') {
					$("#r_other2").hide(); } else {
					$("#r_other2").show();					
					$("#elh_job_card_other2").html(data.jc_10_head);}
					});
				}
				else
				{
					$("#r__1").hide();
					$("#r__2").hide();
					$("#r__3").hide();
					$("#r__4").hide();
					$("#r__5").hide();
					$("#r__6").hide();
					$("#r__7").hide();
					$("#r__8").hide();
					$("#r_other1").hide();
					$("#r_other2").hide();
				}
</script>
<?php include_once "footer.php" ?>
<?php
$job_card_edit->terminate();
?>