<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$job_card_list = new job_card_list();

// Run the page
$job_card_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$job_card_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$job_card->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fjob_cardlist = currentForm = new ew.Form("fjob_cardlist", "list");
fjob_cardlist.formKeyCountName = '<?php echo $job_card_list->FormKeyCountName ?>';

// Form_CustomValidate event
fjob_cardlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjob_cardlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjob_cardlist.lists["x_works"] = <?php echo $job_card_list->works->Lookup->toClientList() ?>;
fjob_cardlist.lists["x_works"].options = <?php echo JsonEncode($job_card_list->works->lookupOptions()) ?>;
fjob_cardlist.lists["x_issue_to_internal"] = <?php echo $job_card_list->issue_to_internal->Lookup->toClientList() ?>;
fjob_cardlist.lists["x_issue_to_internal"].options = <?php echo JsonEncode($job_card_list->issue_to_internal->lookupOptions()) ?>;
fjob_cardlist.lists["x_issue_to_external"] = <?php echo $job_card_list->issue_to_external->Lookup->toClientList() ?>;
fjob_cardlist.lists["x_issue_to_external"].options = <?php echo JsonEncode($job_card_list->issue_to_external->lookupOptions()) ?>;
fjob_cardlist.lists["x_issue_to"] = <?php echo $job_card_list->issue_to->Lookup->toClientList() ?>;
fjob_cardlist.lists["x_issue_to"].options = <?php echo JsonEncode($job_card_list->issue_to->lookupOptions()) ?>;
fjob_cardlist.lists["x_grp"] = <?php echo $job_card_list->grp->Lookup->toClientList() ?>;
fjob_cardlist.lists["x_grp"].options = <?php echo JsonEncode($job_card_list->grp->lookupOptions()) ?>;
fjob_cardlist.lists["x_s_grp"] = <?php echo $job_card_list->s_grp->Lookup->toClientList() ?>;
fjob_cardlist.lists["x_s_grp"].options = <?php echo JsonEncode($job_card_list->s_grp->lookupOptions()) ?>;
fjob_cardlist.lists["x_packing_type"] = <?php echo $job_card_list->packing_type->Lookup->toClientList() ?>;
fjob_cardlist.lists["x_packing_type"].options = <?php echo JsonEncode($job_card_list->packing_type->lookupOptions()) ?>;
fjob_cardlist.lists["x_item"] = <?php echo $job_card_list->item->Lookup->toClientList() ?>;
fjob_cardlist.lists["x_item"].options = <?php echo JsonEncode($job_card_list->item->lookupOptions()) ?>;
fjob_cardlist.autoSuggests["x_item"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fjob_cardlist.lists["x_po[]"] = <?php echo $job_card_list->po->Lookup->toClientList() ?>;
fjob_cardlist.lists["x_po[]"].options = <?php echo JsonEncode($job_card_list->po->lookupOptions()) ?>;
fjob_cardlist.lists["x_batch_no"] = <?php echo $job_card_list->batch_no->Lookup->toClientList() ?>;
fjob_cardlist.lists["x_batch_no"].options = <?php echo JsonEncode($job_card_list->batch_no->lookupOptions()) ?>;
fjob_cardlist.lists["x_pro_unit"] = <?php echo $job_card_list->pro_unit->Lookup->toClientList() ?>;
fjob_cardlist.lists["x_pro_unit"].options = <?php echo JsonEncode($job_card_list->pro_unit->lookupOptions()) ?>;
fjob_cardlist.lists["x_operator"] = <?php echo $job_card_list->operator->Lookup->toClientList() ?>;
fjob_cardlist.lists["x_operator"].options = <?php echo JsonEncode($job_card_list->operator->lookupOptions()) ?>;

// Form object for search
var fjob_cardlistsrch = currentSearchForm = new ew.Form("fjob_cardlistsrch");

// Validate function for search
fjob_cardlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fjob_cardlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjob_cardlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjob_cardlistsrch.lists["x_works"] = <?php echo $job_card_list->works->Lookup->toClientList() ?>;
fjob_cardlistsrch.lists["x_works"].options = <?php echo JsonEncode($job_card_list->works->lookupOptions()) ?>;
fjob_cardlistsrch.lists["x_item"] = <?php echo $job_card_list->item->Lookup->toClientList() ?>;
fjob_cardlistsrch.lists["x_item"].options = <?php echo JsonEncode($job_card_list->item->lookupOptions()) ?>;
fjob_cardlistsrch.autoSuggests["x_item"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
fjob_cardlistsrch.filterList = <?php echo $job_card_list->getFilterList() ?>;

// Init search panel as collapsed
fjob_cardlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$job_card->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($job_card_list->TotalRecs > 0 && $job_card_list->ExportOptions->visible()) { ?>
<?php $job_card_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($job_card_list->ImportOptions->visible()) { ?>
<?php $job_card_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($job_card_list->SearchOptions->visible()) { ?>
<?php $job_card_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($job_card_list->FilterOptions->visible()) { ?>
<?php $job_card_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$job_card_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$job_card->isExport() && !$job_card->CurrentAction) { ?>
<form name="fjob_cardlistsrch" id="fjob_cardlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($job_card_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fjob_cardlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="job_card">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$job_card_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$job_card->RowType = ROWTYPE_SEARCH;

// Render row
$job_card->resetAttributes();
$job_card_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($job_card->works->Visible) { // works ?>
	<div id="xsc_works" class="ew-cell form-group">
		<label for="x_works" class="ew-search-caption ew-label"><?php echo $job_card->works->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_works" id="z_works" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card" data-field="x_works" data-value-separator="<?php echo $job_card->works->displayValueSeparatorAttribute() ?>" id="x_works" name="x_works"<?php echo $job_card->works->editAttributes() ?>>
		<?php echo $job_card->works->selectOptionListHtml("x_works") ?>
	</select>
</div>
<?php echo $job_card->works->Lookup->getParamTag("p_x_works") ?>
</span>
	</div>
<?php } ?>
<?php if ($job_card->item->Visible) { // item ?>
	<div id="xsc_item" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $job_card->item->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_item" id="z_item" value="LIKE"></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$job_card->item->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$job_card->item->EditAttrs["onchange"] = "";
?>
<span id="as_x_item" class="text-nowrap" style="z-index: 8890">
	<input type="text" class="form-control" name="sv_x_item" id="sv_x_item" value="<?php echo RemoveHtml($job_card->item->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($job_card->item->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($job_card->item->getPlaceHolder()) ?>"<?php echo $job_card->item->editAttributes() ?>>
</span>
<input type="hidden" data-table="job_card" data-field="x_item" data-value-separator="<?php echo $job_card->item->displayValueSeparatorAttribute() ?>" name="x_item" id="x_item" value="<?php echo HtmlEncode($job_card->item->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fjob_cardlistsrch.createAutoSuggest({"id":"x_item","forceSelect":false});
</script>
<?php echo $job_card->item->Lookup->getParamTag("p_x_item") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($job_card_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($job_card_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $job_card_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($job_card_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($job_card_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($job_card_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($job_card_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $job_card_list->showPageHeader(); ?>
<?php
$job_card_list->showMessage();
?>
<?php if ($job_card_list->TotalRecs > 0 || $job_card->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($job_card_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> job_card">
<?php if (!$job_card->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$job_card->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($job_card_list->Pager)) $job_card_list->Pager = new PrevNextPager($job_card_list->StartRec, $job_card_list->DisplayRecs, $job_card_list->TotalRecs, $job_card_list->AutoHidePager) ?>
<?php if ($job_card_list->Pager->RecordCount > 0 && $job_card_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($job_card_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $job_card_list->pageUrl() ?>start=<?php echo $job_card_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($job_card_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $job_card_list->pageUrl() ?>start=<?php echo $job_card_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $job_card_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($job_card_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $job_card_list->pageUrl() ?>start=<?php echo $job_card_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($job_card_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $job_card_list->pageUrl() ?>start=<?php echo $job_card_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $job_card_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($job_card_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $job_card_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $job_card_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $job_card_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($job_card_list->TotalRecs > 0 && (!$job_card_list->AutoHidePageSizeSelector || $job_card_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="job_card">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($job_card_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($job_card_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($job_card_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($job_card_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($job_card_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($job_card->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $job_card_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fjob_cardlist" id="fjob_cardlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($job_card_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $job_card_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="job_card">
<div id="gmp_job_card" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($job_card_list->TotalRecs > 0 || $job_card->isGridEdit()) { ?>
<table id="tbl_job_cardlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$job_card_list->RowType = ROWTYPE_HEADER;

// Render list options
$job_card_list->renderListOptions();

// Render list options (header, left)
$job_card_list->ListOptions->render("header", "left");
?>
<?php if ($job_card->id->Visible) { // id ?>
	<?php if ($job_card->sortUrl($job_card->id) == "") { ?>
		<th data-name="id" class="<?php echo $job_card->id->headerCellClass() ?>"><div id="elh_job_card_id" class="job_card_id"><div class="ew-table-header-caption"><?php echo $job_card->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $job_card->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card->SortUrl($job_card->id) ?>',2);"><div id="elh_job_card_id" class="job_card_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card->jc_no->Visible) { // jc_no ?>
	<?php if ($job_card->sortUrl($job_card->jc_no) == "") { ?>
		<th data-name="jc_no" class="<?php echo $job_card->jc_no->headerCellClass() ?>"><div id="elh_job_card_jc_no" class="job_card_jc_no"><div class="ew-table-header-caption"><?php echo $job_card->jc_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_no" class="<?php echo $job_card->jc_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card->SortUrl($job_card->jc_no) ?>',2);"><div id="elh_job_card_jc_no" class="job_card_jc_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card->jc_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card->jc_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card->jc_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card->works->Visible) { // works ?>
	<?php if ($job_card->sortUrl($job_card->works) == "") { ?>
		<th data-name="works" class="<?php echo $job_card->works->headerCellClass() ?>"><div id="elh_job_card_works" class="job_card_works"><div class="ew-table-header-caption"><?php echo $job_card->works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="works" class="<?php echo $job_card->works->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card->SortUrl($job_card->works) ?>',2);"><div id="elh_job_card_works" class="job_card_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card->works->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card->works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card->works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card->issue_to_internal->Visible) { // issue_to_internal ?>
	<?php if ($job_card->sortUrl($job_card->issue_to_internal) == "") { ?>
		<th data-name="issue_to_internal" class="<?php echo $job_card->issue_to_internal->headerCellClass() ?>"><div id="elh_job_card_issue_to_internal" class="job_card_issue_to_internal"><div class="ew-table-header-caption"><?php echo $job_card->issue_to_internal->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issue_to_internal" class="<?php echo $job_card->issue_to_internal->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card->SortUrl($job_card->issue_to_internal) ?>',2);"><div id="elh_job_card_issue_to_internal" class="job_card_issue_to_internal">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card->issue_to_internal->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card->issue_to_internal->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card->issue_to_internal->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card->issue_to_external->Visible) { // issue_to_external ?>
	<?php if ($job_card->sortUrl($job_card->issue_to_external) == "") { ?>
		<th data-name="issue_to_external" class="<?php echo $job_card->issue_to_external->headerCellClass() ?>"><div id="elh_job_card_issue_to_external" class="job_card_issue_to_external"><div class="ew-table-header-caption"><?php echo $job_card->issue_to_external->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issue_to_external" class="<?php echo $job_card->issue_to_external->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card->SortUrl($job_card->issue_to_external) ?>',2);"><div id="elh_job_card_issue_to_external" class="job_card_issue_to_external">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card->issue_to_external->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card->issue_to_external->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card->issue_to_external->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card->issue_to->Visible) { // issue_to ?>
	<?php if ($job_card->sortUrl($job_card->issue_to) == "") { ?>
		<th data-name="issue_to" class="<?php echo $job_card->issue_to->headerCellClass() ?>"><div id="elh_job_card_issue_to" class="job_card_issue_to"><div class="ew-table-header-caption"><?php echo $job_card->issue_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issue_to" class="<?php echo $job_card->issue_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card->SortUrl($job_card->issue_to) ?>',2);"><div id="elh_job_card_issue_to" class="job_card_issue_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card->issue_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card->issue_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card->issue_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card->grp->Visible) { // grp ?>
	<?php if ($job_card->sortUrl($job_card->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $job_card->grp->headerCellClass() ?>"><div id="elh_job_card_grp" class="job_card_grp"><div class="ew-table-header-caption"><?php echo $job_card->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $job_card->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card->SortUrl($job_card->grp) ?>',2);"><div id="elh_job_card_grp" class="job_card_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card->s_grp->Visible) { // s_grp ?>
	<?php if ($job_card->sortUrl($job_card->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $job_card->s_grp->headerCellClass() ?>"><div id="elh_job_card_s_grp" class="job_card_s_grp"><div class="ew-table-header-caption"><?php echo $job_card->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $job_card->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card->SortUrl($job_card->s_grp) ?>',2);"><div id="elh_job_card_s_grp" class="job_card_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card->packing_type->Visible) { // packing_type ?>
	<?php if ($job_card->sortUrl($job_card->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $job_card->packing_type->headerCellClass() ?>"><div id="elh_job_card_packing_type" class="job_card_packing_type"><div class="ew-table-header-caption"><?php echo $job_card->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $job_card->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card->SortUrl($job_card->packing_type) ?>',2);"><div id="elh_job_card_packing_type" class="job_card_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card->item->Visible) { // item ?>
	<?php if ($job_card->sortUrl($job_card->item) == "") { ?>
		<th data-name="item" class="<?php echo $job_card->item->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_job_card_item" class="job_card_item"><div class="ew-table-header-caption"><?php echo $job_card->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $job_card->item->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card->SortUrl($job_card->item) ?>',2);"><div id="elh_job_card_item" class="job_card_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card->item->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card->po->Visible) { // po ?>
	<?php if ($job_card->sortUrl($job_card->po) == "") { ?>
		<th data-name="po" class="<?php echo $job_card->po->headerCellClass() ?>"><div id="elh_job_card_po" class="job_card_po"><div class="ew-table-header-caption"><?php echo $job_card->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $job_card->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card->SortUrl($job_card->po) ?>',2);"><div id="elh_job_card_po" class="job_card_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card->po->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card->batch_no->Visible) { // batch_no ?>
	<?php if ($job_card->sortUrl($job_card->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $job_card->batch_no->headerCellClass() ?>"><div id="elh_job_card_batch_no" class="job_card_batch_no"><div class="ew-table-header-caption"><?php echo $job_card->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $job_card->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card->SortUrl($job_card->batch_no) ?>',2);"><div id="elh_job_card_batch_no" class="job_card_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card->quantity->Visible) { // quantity ?>
	<?php if ($job_card->sortUrl($job_card->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $job_card->quantity->headerCellClass() ?>"><div id="elh_job_card_quantity" class="job_card_quantity"><div class="ew-table-header-caption"><?php echo $job_card->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $job_card->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card->SortUrl($job_card->quantity) ?>',2);"><div id="elh_job_card_quantity" class="job_card_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card->pro_unit->Visible) { // pro_unit ?>
	<?php if ($job_card->sortUrl($job_card->pro_unit) == "") { ?>
		<th data-name="pro_unit" class="<?php echo $job_card->pro_unit->headerCellClass() ?>"><div id="elh_job_card_pro_unit" class="job_card_pro_unit"><div class="ew-table-header-caption"><?php echo $job_card->pro_unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pro_unit" class="<?php echo $job_card->pro_unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card->SortUrl($job_card->pro_unit) ?>',2);"><div id="elh_job_card_pro_unit" class="job_card_pro_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card->pro_unit->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card->pro_unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card->pro_unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card->operator->Visible) { // operator ?>
	<?php if ($job_card->sortUrl($job_card->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $job_card->operator->headerCellClass() ?>"><div id="elh_job_card_operator" class="job_card_operator"><div class="ew-table-header-caption"><?php echo $job_card->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $job_card->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card->SortUrl($job_card->operator) ?>',2);"><div id="elh_job_card_operator" class="job_card_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card->datetime->Visible) { // datetime ?>
	<?php if ($job_card->sortUrl($job_card->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $job_card->datetime->headerCellClass() ?>"><div id="elh_job_card_datetime" class="job_card_datetime"><div class="ew-table-header-caption"><?php echo $job_card->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $job_card->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card->SortUrl($job_card->datetime) ?>',2);"><div id="elh_job_card_datetime" class="job_card_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card->buyer_id->Visible) { // buyer_id ?>
	<?php if ($job_card->sortUrl($job_card->buyer_id) == "") { ?>
		<th data-name="buyer_id" class="<?php echo $job_card->buyer_id->headerCellClass() ?>"><div id="elh_job_card_buyer_id" class="job_card_buyer_id"><div class="ew-table-header-caption"><?php echo $job_card->buyer_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_id" class="<?php echo $job_card->buyer_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card->SortUrl($job_card->buyer_id) ?>',2);"><div id="elh_job_card_buyer_id" class="job_card_buyer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card->buyer_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card->buyer_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card->buyer_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($job_card->company_id->Visible) { // company_id ?>
	<?php if ($job_card->sortUrl($job_card->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $job_card->company_id->headerCellClass() ?>"><div id="elh_job_card_company_id" class="job_card_company_id"><div class="ew-table-header-caption"><?php echo $job_card->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $job_card->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $job_card->SortUrl($job_card->company_id) ?>',2);"><div id="elh_job_card_company_id" class="job_card_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $job_card->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($job_card->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($job_card->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$job_card_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($job_card->ExportAll && $job_card->isExport()) {
	$job_card_list->StopRec = $job_card_list->TotalRecs;
} else {

	// Set the last record to display
	if ($job_card_list->TotalRecs > $job_card_list->StartRec + $job_card_list->DisplayRecs - 1)
		$job_card_list->StopRec = $job_card_list->StartRec + $job_card_list->DisplayRecs - 1;
	else
		$job_card_list->StopRec = $job_card_list->TotalRecs;
}
$job_card_list->RecCnt = $job_card_list->StartRec - 1;
if ($job_card_list->Recordset && !$job_card_list->Recordset->EOF) {
	$job_card_list->Recordset->moveFirst();
	$selectLimit = $job_card_list->UseSelectLimit;
	if (!$selectLimit && $job_card_list->StartRec > 1)
		$job_card_list->Recordset->move($job_card_list->StartRec - 1);
} elseif (!$job_card->AllowAddDeleteRow && $job_card_list->StopRec == 0) {
	$job_card_list->StopRec = $job_card->GridAddRowCount;
}

// Initialize aggregate
$job_card->RowType = ROWTYPE_AGGREGATEINIT;
$job_card->resetAttributes();
$job_card_list->renderRow();
while ($job_card_list->RecCnt < $job_card_list->StopRec) {
	$job_card_list->RecCnt++;
	if ($job_card_list->RecCnt >= $job_card_list->StartRec) {
		$job_card_list->RowCnt++;

		// Set up key count
		$job_card_list->KeyCount = $job_card_list->RowIndex;

		// Init row class and style
		$job_card->resetAttributes();
		$job_card->CssClass = "";
		if ($job_card->isGridAdd()) {
		} else {
			$job_card_list->loadRowValues($job_card_list->Recordset); // Load row values
		}
		$job_card->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$job_card->RowAttrs = array_merge($job_card->RowAttrs, array('data-rowindex'=>$job_card_list->RowCnt, 'id'=>'r' . $job_card_list->RowCnt . '_job_card', 'data-rowtype'=>$job_card->RowType));

		// Render row
		$job_card_list->renderRow();

		// Render list options
		$job_card_list->renderListOptions();
?>
	<tr<?php echo $job_card->rowAttributes() ?>>
<?php

// Render list options (body, left)
$job_card_list->ListOptions->render("body", "left", $job_card_list->RowCnt);
?>
	<?php if ($job_card->id->Visible) { // id ?>
		<td data-name="id"<?php echo $job_card->id->cellAttributes() ?>>
<span id="el<?php echo $job_card_list->RowCnt ?>_job_card_id" class="job_card_id">
<span<?php echo $job_card->id->viewAttributes() ?>>
<?php echo $job_card->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no"<?php echo $job_card->jc_no->cellAttributes() ?>>
<span id="el<?php echo $job_card_list->RowCnt ?>_job_card_jc_no" class="job_card_jc_no">
<span<?php echo $job_card->jc_no->viewAttributes() ?>>
<?php echo $job_card->jc_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card->works->Visible) { // works ?>
		<td data-name="works"<?php echo $job_card->works->cellAttributes() ?>>
<span id="el<?php echo $job_card_list->RowCnt ?>_job_card_works" class="job_card_works">
<span<?php echo $job_card->works->viewAttributes() ?>>
<?php if ((!EmptyString($job_card->works->getViewValue())) && $job_card->works->linkAttributes() <> "") { ?>
<a<?php echo $job_card->works->linkAttributes() ?>><?php echo $job_card->works->getViewValue() ?></a>
<?php } else { ?>
<?php echo $job_card->works->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card->issue_to_internal->Visible) { // issue_to_internal ?>
		<td data-name="issue_to_internal"<?php echo $job_card->issue_to_internal->cellAttributes() ?>>
<span id="el<?php echo $job_card_list->RowCnt ?>_job_card_issue_to_internal" class="job_card_issue_to_internal">
<span<?php echo $job_card->issue_to_internal->viewAttributes() ?>>
<?php echo $job_card->issue_to_internal->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card->issue_to_external->Visible) { // issue_to_external ?>
		<td data-name="issue_to_external"<?php echo $job_card->issue_to_external->cellAttributes() ?>>
<span id="el<?php echo $job_card_list->RowCnt ?>_job_card_issue_to_external" class="job_card_issue_to_external">
<span<?php echo $job_card->issue_to_external->viewAttributes() ?>>
<?php echo $job_card->issue_to_external->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card->issue_to->Visible) { // issue_to ?>
		<td data-name="issue_to"<?php echo $job_card->issue_to->cellAttributes() ?>>
<span id="el<?php echo $job_card_list->RowCnt ?>_job_card_issue_to" class="job_card_issue_to">
<span<?php echo $job_card->issue_to->viewAttributes() ?>>
<?php echo $job_card->issue_to->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $job_card->grp->cellAttributes() ?>>
<span id="el<?php echo $job_card_list->RowCnt ?>_job_card_grp" class="job_card_grp">
<span<?php echo $job_card->grp->viewAttributes() ?>>
<?php echo $job_card->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $job_card->s_grp->cellAttributes() ?>>
<span id="el<?php echo $job_card_list->RowCnt ?>_job_card_s_grp" class="job_card_s_grp">
<span<?php echo $job_card->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($job_card->s_grp->getViewValue())) && $job_card->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $job_card->s_grp->linkAttributes() ?>><?php echo $job_card->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $job_card->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $job_card->packing_type->cellAttributes() ?>>
<span id="el<?php echo $job_card_list->RowCnt ?>_job_card_packing_type" class="job_card_packing_type">
<span<?php echo $job_card->packing_type->viewAttributes() ?>>
<?php echo $job_card->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card->item->Visible) { // item ?>
		<td data-name="item"<?php echo $job_card->item->cellAttributes() ?>>
<span id="el<?php echo $job_card_list->RowCnt ?>_job_card_item" class="job_card_item">
<span<?php echo $job_card->item->viewAttributes() ?>>
<?php if ((!EmptyString($job_card->item->getViewValue())) && $job_card->item->linkAttributes() <> "") { ?>
<a<?php echo $job_card->item->linkAttributes() ?>><?php echo $job_card->item->getViewValue() ?></a>
<?php } else { ?>
<?php echo $job_card->item->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card->po->Visible) { // po ?>
		<td data-name="po"<?php echo $job_card->po->cellAttributes() ?>>
<span id="el<?php echo $job_card_list->RowCnt ?>_job_card_po" class="job_card_po">
<span<?php echo $job_card->po->viewAttributes() ?>>
<?php if ((!EmptyString($job_card->po->getViewValue())) && $job_card->po->linkAttributes() <> "") { ?>
<a<?php echo $job_card->po->linkAttributes() ?>><?php echo $job_card->po->getViewValue() ?></a>
<?php } else { ?>
<?php echo $job_card->po->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $job_card->batch_no->cellAttributes() ?>>
<span id="el<?php echo $job_card_list->RowCnt ?>_job_card_batch_no" class="job_card_batch_no">
<span<?php echo $job_card->batch_no->viewAttributes() ?>>
<?php if ((!EmptyString($job_card->batch_no->getViewValue())) && $job_card->batch_no->linkAttributes() <> "") { ?>
<a<?php echo $job_card->batch_no->linkAttributes() ?>><?php echo $job_card->batch_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $job_card->batch_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $job_card->quantity->cellAttributes() ?>>
<span id="el<?php echo $job_card_list->RowCnt ?>_job_card_quantity" class="job_card_quantity">
<span<?php echo $job_card->quantity->viewAttributes() ?>>
<?php if ((!EmptyString($job_card->quantity->getViewValue())) && $job_card->quantity->linkAttributes() <> "") { ?>
<a<?php echo $job_card->quantity->linkAttributes() ?>><?php echo $job_card->quantity->getViewValue() ?></a>
<?php } else { ?>
<?php echo $job_card->quantity->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card->pro_unit->Visible) { // pro_unit ?>
		<td data-name="pro_unit"<?php echo $job_card->pro_unit->cellAttributes() ?>>
<span id="el<?php echo $job_card_list->RowCnt ?>_job_card_pro_unit" class="job_card_pro_unit">
<span<?php echo $job_card->pro_unit->viewAttributes() ?>>
<?php echo $job_card->pro_unit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $job_card->operator->cellAttributes() ?>>
<span id="el<?php echo $job_card_list->RowCnt ?>_job_card_operator" class="job_card_operator">
<span<?php echo $job_card->operator->viewAttributes() ?>>
<?php echo $job_card->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $job_card->datetime->cellAttributes() ?>>
<span id="el<?php echo $job_card_list->RowCnt ?>_job_card_datetime" class="job_card_datetime">
<span<?php echo $job_card->datetime->viewAttributes() ?>>
<?php echo $job_card->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id"<?php echo $job_card->buyer_id->cellAttributes() ?>>
<span id="el<?php echo $job_card_list->RowCnt ?>_job_card_buyer_id" class="job_card_buyer_id">
<span<?php echo $job_card->buyer_id->viewAttributes() ?>>
<?php echo $job_card->buyer_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($job_card->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $job_card->company_id->cellAttributes() ?>>
<span id="el<?php echo $job_card_list->RowCnt ?>_job_card_company_id" class="job_card_company_id">
<span<?php echo $job_card->company_id->viewAttributes() ?>>
<?php echo $job_card->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$job_card_list->ListOptions->render("body", "right", $job_card_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$job_card->isGridAdd())
		$job_card_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$job_card->RowType = ROWTYPE_AGGREGATE;
$job_card->resetAttributes();
$job_card_list->renderRow();
?>
<?php if ($job_card_list->TotalRecs > 0 && !$job_card->isGridAdd() && !$job_card->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$job_card_list->renderListOptions();

// Render list options (footer, left)
$job_card_list->ListOptions->render("footer", "left");
?>
	<?php if ($job_card->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $job_card->id->footerCellClass() ?>"><span id="elf_job_card_id" class="job_card_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($job_card->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no" class="<?php echo $job_card->jc_no->footerCellClass() ?>"><span id="elf_job_card_jc_no" class="job_card_jc_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($job_card->works->Visible) { // works ?>
		<td data-name="works" class="<?php echo $job_card->works->footerCellClass() ?>"><span id="elf_job_card_works" class="job_card_works">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($job_card->issue_to_internal->Visible) { // issue_to_internal ?>
		<td data-name="issue_to_internal" class="<?php echo $job_card->issue_to_internal->footerCellClass() ?>"><span id="elf_job_card_issue_to_internal" class="job_card_issue_to_internal">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($job_card->issue_to_external->Visible) { // issue_to_external ?>
		<td data-name="issue_to_external" class="<?php echo $job_card->issue_to_external->footerCellClass() ?>"><span id="elf_job_card_issue_to_external" class="job_card_issue_to_external">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($job_card->issue_to->Visible) { // issue_to ?>
		<td data-name="issue_to" class="<?php echo $job_card->issue_to->footerCellClass() ?>"><span id="elf_job_card_issue_to" class="job_card_issue_to">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($job_card->grp->Visible) { // grp ?>
		<td data-name="grp" class="<?php echo $job_card->grp->footerCellClass() ?>"><span id="elf_job_card_grp" class="job_card_grp">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($job_card->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp" class="<?php echo $job_card->s_grp->footerCellClass() ?>"><span id="elf_job_card_s_grp" class="job_card_s_grp">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($job_card->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $job_card->packing_type->footerCellClass() ?>"><span id="elf_job_card_packing_type" class="job_card_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($job_card->item->Visible) { // item ?>
		<td data-name="item" class="<?php echo $job_card->item->footerCellClass() ?>"><span id="elf_job_card_item" class="job_card_item">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($job_card->po->Visible) { // po ?>
		<td data-name="po" class="<?php echo $job_card->po->footerCellClass() ?>"><span id="elf_job_card_po" class="job_card_po">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($job_card->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no" class="<?php echo $job_card->batch_no->footerCellClass() ?>"><span id="elf_job_card_batch_no" class="job_card_batch_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($job_card->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $job_card->quantity->footerCellClass() ?>"><span id="elf_job_card_quantity" class="job_card_quantity">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $job_card->quantity->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($job_card->pro_unit->Visible) { // pro_unit ?>
		<td data-name="pro_unit" class="<?php echo $job_card->pro_unit->footerCellClass() ?>"><span id="elf_job_card_pro_unit" class="job_card_pro_unit">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($job_card->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $job_card->operator->footerCellClass() ?>"><span id="elf_job_card_operator" class="job_card_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($job_card->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $job_card->datetime->footerCellClass() ?>"><span id="elf_job_card_datetime" class="job_card_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($job_card->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id" class="<?php echo $job_card->buyer_id->footerCellClass() ?>"><span id="elf_job_card_buyer_id" class="job_card_buyer_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($job_card->company_id->Visible) { // company_id ?>
		<td data-name="company_id" class="<?php echo $job_card->company_id->footerCellClass() ?>"><span id="elf_job_card_company_id" class="job_card_company_id">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$job_card_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$job_card->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($job_card_list->Recordset)
	$job_card_list->Recordset->Close();
?>
<?php if (!$job_card->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$job_card->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($job_card_list->Pager)) $job_card_list->Pager = new PrevNextPager($job_card_list->StartRec, $job_card_list->DisplayRecs, $job_card_list->TotalRecs, $job_card_list->AutoHidePager) ?>
<?php if ($job_card_list->Pager->RecordCount > 0 && $job_card_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($job_card_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $job_card_list->pageUrl() ?>start=<?php echo $job_card_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($job_card_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $job_card_list->pageUrl() ?>start=<?php echo $job_card_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $job_card_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($job_card_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $job_card_list->pageUrl() ?>start=<?php echo $job_card_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($job_card_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $job_card_list->pageUrl() ?>start=<?php echo $job_card_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $job_card_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($job_card_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $job_card_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $job_card_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $job_card_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($job_card_list->TotalRecs > 0 && (!$job_card_list->AutoHidePageSizeSelector || $job_card_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="job_card">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($job_card_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($job_card_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($job_card_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($job_card_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($job_card_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($job_card->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $job_card_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($job_card_list->TotalRecs == 0 && !$job_card->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $job_card_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$job_card_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$job_card->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$job_card->isExport()) { ?>
<script>
ew.scrollableTable("gmp_job_card", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$job_card_list->terminate();
?>