<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$job_card_search = new job_card_search();

// Run the page
$job_card_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$job_card_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($job_card_search->IsModal) { ?>
var fjob_cardsearch = currentAdvancedSearchForm = new ew.Form("fjob_cardsearch", "search");
<?php } else { ?>
var fjob_cardsearch = currentForm = new ew.Form("fjob_cardsearch", "search");
<?php } ?>

// Form_CustomValidate event
fjob_cardsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjob_cardsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjob_cardsearch.lists["x_issue_to_internal"] = <?php echo $job_card_search->issue_to_internal->Lookup->toClientList() ?>;
fjob_cardsearch.lists["x_issue_to_internal"].options = <?php echo JsonEncode($job_card_search->issue_to_internal->lookupOptions()) ?>;
fjob_cardsearch.lists["x_issue_to_external"] = <?php echo $job_card_search->issue_to_external->Lookup->toClientList() ?>;
fjob_cardsearch.lists["x_issue_to_external"].options = <?php echo JsonEncode($job_card_search->issue_to_external->lookupOptions()) ?>;
fjob_cardsearch.lists["x_issue_to"] = <?php echo $job_card_search->issue_to->Lookup->toClientList() ?>;
fjob_cardsearch.lists["x_issue_to"].options = <?php echo JsonEncode($job_card_search->issue_to->lookupOptions()) ?>;
fjob_cardsearch.lists["x_grp"] = <?php echo $job_card_search->grp->Lookup->toClientList() ?>;
fjob_cardsearch.lists["x_grp"].options = <?php echo JsonEncode($job_card_search->grp->lookupOptions()) ?>;
fjob_cardsearch.lists["x_s_grp"] = <?php echo $job_card_search->s_grp->Lookup->toClientList() ?>;
fjob_cardsearch.lists["x_s_grp"].options = <?php echo JsonEncode($job_card_search->s_grp->lookupOptions()) ?>;
fjob_cardsearch.lists["x_packing_type"] = <?php echo $job_card_search->packing_type->Lookup->toClientList() ?>;
fjob_cardsearch.lists["x_packing_type"].options = <?php echo JsonEncode($job_card_search->packing_type->lookupOptions()) ?>;
fjob_cardsearch.lists["x_product_code"] = <?php echo $job_card_search->product_code->Lookup->toClientList() ?>;
fjob_cardsearch.lists["x_product_code"].options = <?php echo JsonEncode($job_card_search->product_code->lookupOptions()) ?>;
fjob_cardsearch.lists["x_item"] = <?php echo $job_card_search->item->Lookup->toClientList() ?>;
fjob_cardsearch.lists["x_item"].options = <?php echo JsonEncode($job_card_search->item->lookupOptions()) ?>;
fjob_cardsearch.autoSuggests["x_item"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fjob_cardsearch.lists["x_poid[]"] = <?php echo $job_card_search->poid->Lookup->toClientList() ?>;
fjob_cardsearch.lists["x_poid[]"].options = <?php echo JsonEncode($job_card_search->poid->lookupOptions()) ?>;
fjob_cardsearch.lists["x_batch_no"] = <?php echo $job_card_search->batch_no->Lookup->toClientList() ?>;
fjob_cardsearch.lists["x_batch_no"].options = <?php echo JsonEncode($job_card_search->batch_no->lookupOptions()) ?>;
fjob_cardsearch.lists["x_pro_unit"] = <?php echo $job_card_search->pro_unit->Lookup->toClientList() ?>;
fjob_cardsearch.lists["x_pro_unit"].options = <?php echo JsonEncode($job_card_search->pro_unit->lookupOptions()) ?>;
fjob_cardsearch.lists["x_employee_id[]"] = <?php echo $job_card_search->employee_id->Lookup->toClientList() ?>;
fjob_cardsearch.lists["x_employee_id[]"].options = <?php echo JsonEncode($job_card_search->employee_id->lookupOptions()) ?>;
fjob_cardsearch.lists["x_operator"] = <?php echo $job_card_search->operator->Lookup->toClientList() ?>;
fjob_cardsearch.lists["x_operator"].options = <?php echo JsonEncode($job_card_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fjob_cardsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($job_card->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_jc_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($job_card->jc_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($job_card->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($job_card->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_buyer_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($job_card->buyer_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_company_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($job_card->company_id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $job_card_search->showPageHeader(); ?>
<?php
$job_card_search->showMessage();
?>
<form name="fjob_cardsearch" id="fjob_cardsearch" class="<?php echo $job_card_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($job_card_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $job_card_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="job_card">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$job_card_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($job_card->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card_id"><?php echo $job_card->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->id->cellAttributes() ?>>
			<span id="el_job_card_id">
<input type="text" data-table="job_card" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($job_card->id->getPlaceHolder()) ?>" value="<?php echo $job_card->id->EditValue ?>"<?php echo $job_card->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->jc_no->Visible) { // jc_no ?>
	<div id="r_jc_no" class="form-group row">
		<label for="x_jc_no" class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card_jc_no"><?php echo $job_card->jc_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_jc_no" id="z_jc_no" value="="></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->jc_no->cellAttributes() ?>>
			<span id="el_job_card_jc_no">
<input type="text" data-table="job_card" data-field="x_jc_no" name="x_jc_no" id="x_jc_no" size="30" placeholder="<?php echo HtmlEncode($job_card->jc_no->getPlaceHolder()) ?>" value="<?php echo $job_card->jc_no->EditValue ?>"<?php echo $job_card->jc_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->issue_to_internal->Visible) { // issue_to_internal ?>
	<div id="r_issue_to_internal" class="form-group row">
		<label for="x_issue_to_internal" class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card_issue_to_internal"><?php echo $job_card->issue_to_internal->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_to_internal" id="z_issue_to_internal" value="="></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->issue_to_internal->cellAttributes() ?>>
			<span id="el_job_card_issue_to_internal">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card" data-field="x_issue_to_internal" data-value-separator="<?php echo $job_card->issue_to_internal->displayValueSeparatorAttribute() ?>" id="x_issue_to_internal" name="x_issue_to_internal"<?php echo $job_card->issue_to_internal->editAttributes() ?>>
		<?php echo $job_card->issue_to_internal->selectOptionListHtml("x_issue_to_internal") ?>
	</select>
</div>
<?php echo $job_card->issue_to_internal->Lookup->getParamTag("p_x_issue_to_internal") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->issue_to_external->Visible) { // issue_to_external ?>
	<div id="r_issue_to_external" class="form-group row">
		<label for="x_issue_to_external" class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card_issue_to_external"><?php echo $job_card->issue_to_external->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_to_external" id="z_issue_to_external" value="="></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->issue_to_external->cellAttributes() ?>>
			<span id="el_job_card_issue_to_external">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card" data-field="x_issue_to_external" data-value-separator="<?php echo $job_card->issue_to_external->displayValueSeparatorAttribute() ?>" id="x_issue_to_external" name="x_issue_to_external"<?php echo $job_card->issue_to_external->editAttributes() ?>>
		<?php echo $job_card->issue_to_external->selectOptionListHtml("x_issue_to_external") ?>
	</select>
</div>
<?php echo $job_card->issue_to_external->Lookup->getParamTag("p_x_issue_to_external") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->issue_to->Visible) { // issue_to ?>
	<div id="r_issue_to" class="form-group row">
		<label for="x_issue_to" class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card_issue_to"><?php echo $job_card->issue_to->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_to" id="z_issue_to" value="="></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->issue_to->cellAttributes() ?>>
			<span id="el_job_card_issue_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card" data-field="x_issue_to" data-value-separator="<?php echo $job_card->issue_to->displayValueSeparatorAttribute() ?>" id="x_issue_to" name="x_issue_to"<?php echo $job_card->issue_to->editAttributes() ?>>
		<?php echo $job_card->issue_to->selectOptionListHtml("x_issue_to") ?>
	</select>
</div>
<?php echo $job_card->issue_to->Lookup->getParamTag("p_x_issue_to") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card_grp"><?php echo $job_card->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->grp->cellAttributes() ?>>
			<span id="el_job_card_grp">
<?php $job_card->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$job_card->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card" data-field="x_grp" data-value-separator="<?php echo $job_card->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $job_card->grp->editAttributes() ?>>
		<?php echo $job_card->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $job_card->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card_s_grp"><?php echo $job_card->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->s_grp->cellAttributes() ?>>
			<span id="el_job_card_s_grp">
<?php $job_card->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$job_card->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card" data-field="x_s_grp" data-value-separator="<?php echo $job_card->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $job_card->s_grp->editAttributes() ?>>
		<?php echo $job_card->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $job_card->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card_packing_type"><?php echo $job_card->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->packing_type->cellAttributes() ?>>
			<span id="el_job_card_packing_type">
<?php $job_card->packing_type->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$job_card->packing_type->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card" data-field="x_packing_type" data-value-separator="<?php echo $job_card->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $job_card->packing_type->editAttributes() ?>>
		<?php echo $job_card->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $job_card->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label for="x_product_code" class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card_product_code"><?php echo $job_card->product_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->product_code->cellAttributes() ?>>
			<span id="el_job_card_product_code">
<input type="text" data-table="job_card" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" placeholder="<?php echo HtmlEncode($job_card->product_code->getPlaceHolder()) ?>" value="<?php echo $job_card->product_code->EditValue ?>"<?php echo $job_card->product_code->editAttributes() ?>>
<?php echo $job_card->product_code->Lookup->getParamTag("p_x_product_code") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card_item"><?php echo $job_card->item->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_item" id="z_item" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->item->cellAttributes() ?>>
			<span id="el_job_card_item">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$job_card->item->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$job_card->item->EditAttrs["onchange"] = "";
?>
<span id="as_x_item" class="text-nowrap" style="z-index: 8890">
	<input type="text" class="form-control" name="sv_x_item" id="sv_x_item" value="<?php echo RemoveHtml($job_card->item->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($job_card->item->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($job_card->item->getPlaceHolder()) ?>"<?php echo $job_card->item->editAttributes() ?>>
</span>
<input type="hidden" data-table="job_card" data-field="x_item" data-value-separator="<?php echo $job_card->item->displayValueSeparatorAttribute() ?>" name="x_item" id="x_item" value="<?php echo HtmlEncode($job_card->item->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fjob_cardsearch.createAutoSuggest({"id":"x_item","forceSelect":false});
</script>
<?php echo $job_card->item->Lookup->getParamTag("p_x_item") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->poid->Visible) { // poid ?>
	<div id="r_poid" class="form-group row">
		<label class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card_poid"><?php echo $job_card->poid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_poid" id="z_poid" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->poid->cellAttributes() ?>>
			<span id="el_job_card_poid">
<div id="tp_x_poid" class="ew-template"><input type="checkbox" class="form-check-input" data-table="job_card" data-field="x_poid" data-value-separator="<?php echo $job_card->poid->displayValueSeparatorAttribute() ?>" name="x_poid[]" id="x_poid[]" value="{value}"<?php echo $job_card->poid->editAttributes() ?>></div>
<div id="dsl_x_poid" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $job_card->poid->checkBoxListHtml(FALSE, "x_poid[]") ?>
</div></div>
<?php echo $job_card->poid->Lookup->getParamTag("p_x_poid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card_batch_no"><?php echo $job_card->batch_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_batch_no" id="z_batch_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->batch_no->cellAttributes() ?>>
			<span id="el_job_card_batch_no">
<div id="tp_x_batch_no" class="ew-template"><input type="radio" class="form-check-input" data-table="job_card" data-field="x_batch_no" data-value-separator="<?php echo $job_card->batch_no->displayValueSeparatorAttribute() ?>" name="x_batch_no" id="x_batch_no" value="{value}"<?php echo $job_card->batch_no->editAttributes() ?>></div>
<div id="dsl_x_batch_no" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $job_card->batch_no->radioButtonListHtml(FALSE, "x_batch_no") ?>
</div></div>
<?php echo $job_card->batch_no->Lookup->getParamTag("p_x_batch_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card_quantity"><?php echo $job_card->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->quantity->cellAttributes() ?>>
			<span id="el_job_card_quantity">
<input type="text" data-table="job_card" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($job_card->quantity->getPlaceHolder()) ?>" value="<?php echo $job_card->quantity->EditValue ?>"<?php echo $job_card->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->pro_unit->Visible) { // pro_unit ?>
	<div id="r_pro_unit" class="form-group row">
		<label for="x_pro_unit" class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card_pro_unit"><?php echo $job_card->pro_unit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pro_unit" id="z_pro_unit" value="="></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->pro_unit->cellAttributes() ?>>
			<span id="el_job_card_pro_unit">
<?php $job_card->pro_unit->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$job_card->pro_unit->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card" data-field="x_pro_unit" data-value-separator="<?php echo $job_card->pro_unit->displayValueSeparatorAttribute() ?>" id="x_pro_unit" name="x_pro_unit"<?php echo $job_card->pro_unit->editAttributes() ?>>
		<?php echo $job_card->pro_unit->selectOptionListHtml("x_pro_unit") ?>
	</select>
</div>
<?php echo $job_card->pro_unit->Lookup->getParamTag("p_x_pro_unit") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->employee_id->Visible) { // employee_id ?>
	<div id="r_employee_id" class="form-group row">
		<label class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card_employee_id"><?php echo $job_card->employee_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_employee_id" id="z_employee_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->employee_id->cellAttributes() ?>>
			<span id="el_job_card_employee_id">
<input type="text" data-table="job_card" data-field="x_employee_id" name="x_employee_id" id="x_employee_id" size="30" placeholder="<?php echo HtmlEncode($job_card->employee_id->getPlaceHolder()) ?>" value="<?php echo $job_card->employee_id->EditValue ?>"<?php echo $job_card->employee_id->editAttributes() ?>>
<?php echo $job_card->employee_id->Lookup->getParamTag("p_x_employee_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->_1->Visible) { // 1 ?>
	<div id="r__1" class="form-group row">
		<label for="x__1" class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card__1"><?php echo $job_card->_1->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__1" id="z__1" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->_1->cellAttributes() ?>>
			<span id="el_job_card__1">
<input type="text" data-table="job_card" data-field="x__1" name="x__1" id="x__1" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->_1->getPlaceHolder()) ?>" value="<?php echo $job_card->_1->EditValue ?>"<?php echo $job_card->_1->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->_2->Visible) { // 2 ?>
	<div id="r__2" class="form-group row">
		<label for="x__2" class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card__2"><?php echo $job_card->_2->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__2" id="z__2" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->_2->cellAttributes() ?>>
			<span id="el_job_card__2">
<input type="text" data-table="job_card" data-field="x__2" name="x__2" id="x__2" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->_2->getPlaceHolder()) ?>" value="<?php echo $job_card->_2->EditValue ?>"<?php echo $job_card->_2->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->_3->Visible) { // 3 ?>
	<div id="r__3" class="form-group row">
		<label for="x__3" class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card__3"><?php echo $job_card->_3->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__3" id="z__3" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->_3->cellAttributes() ?>>
			<span id="el_job_card__3">
<input type="text" data-table="job_card" data-field="x__3" name="x__3" id="x__3" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->_3->getPlaceHolder()) ?>" value="<?php echo $job_card->_3->EditValue ?>"<?php echo $job_card->_3->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->_4->Visible) { // 4 ?>
	<div id="r__4" class="form-group row">
		<label for="x__4" class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card__4"><?php echo $job_card->_4->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__4" id="z__4" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->_4->cellAttributes() ?>>
			<span id="el_job_card__4">
<input type="text" data-table="job_card" data-field="x__4" name="x__4" id="x__4" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->_4->getPlaceHolder()) ?>" value="<?php echo $job_card->_4->EditValue ?>"<?php echo $job_card->_4->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->_5->Visible) { // 5 ?>
	<div id="r__5" class="form-group row">
		<label for="x__5" class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card__5"><?php echo $job_card->_5->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__5" id="z__5" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->_5->cellAttributes() ?>>
			<span id="el_job_card__5">
<input type="text" data-table="job_card" data-field="x__5" name="x__5" id="x__5" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->_5->getPlaceHolder()) ?>" value="<?php echo $job_card->_5->EditValue ?>"<?php echo $job_card->_5->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->_6->Visible) { // 6 ?>
	<div id="r__6" class="form-group row">
		<label for="x__6" class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card__6"><?php echo $job_card->_6->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__6" id="z__6" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->_6->cellAttributes() ?>>
			<span id="el_job_card__6">
<input type="text" data-table="job_card" data-field="x__6" name="x__6" id="x__6" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->_6->getPlaceHolder()) ?>" value="<?php echo $job_card->_6->EditValue ?>"<?php echo $job_card->_6->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->_7->Visible) { // 7 ?>
	<div id="r__7" class="form-group row">
		<label for="x__7" class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card__7"><?php echo $job_card->_7->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__7" id="z__7" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->_7->cellAttributes() ?>>
			<span id="el_job_card__7">
<input type="text" data-table="job_card" data-field="x__7" name="x__7" id="x__7" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->_7->getPlaceHolder()) ?>" value="<?php echo $job_card->_7->EditValue ?>"<?php echo $job_card->_7->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->_8->Visible) { // 8 ?>
	<div id="r__8" class="form-group row">
		<label for="x__8" class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card__8"><?php echo $job_card->_8->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__8" id="z__8" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->_8->cellAttributes() ?>>
			<span id="el_job_card__8">
<input type="text" data-table="job_card" data-field="x__8" name="x__8" id="x__8" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->_8->getPlaceHolder()) ?>" value="<?php echo $job_card->_8->EditValue ?>"<?php echo $job_card->_8->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->other1->Visible) { // other1 ?>
	<div id="r_other1" class="form-group row">
		<label for="x_other1" class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card_other1"><?php echo $job_card->other1->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_other1" id="z_other1" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->other1->cellAttributes() ?>>
			<span id="el_job_card_other1">
<input type="text" data-table="job_card" data-field="x_other1" name="x_other1" id="x_other1" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->other1->getPlaceHolder()) ?>" value="<?php echo $job_card->other1->EditValue ?>"<?php echo $job_card->other1->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->other2->Visible) { // other2 ?>
	<div id="r_other2" class="form-group row">
		<label for="x_other2" class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card_other2"><?php echo $job_card->other2->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_other2" id="z_other2" value="LIKE"></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->other2->cellAttributes() ?>>
			<span id="el_job_card_other2">
<input type="text" data-table="job_card" data-field="x_other2" name="x_other2" id="x_other2" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($job_card->other2->getPlaceHolder()) ?>" value="<?php echo $job_card->other2->EditValue ?>"<?php echo $job_card->other2->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card_operator"><?php echo $job_card->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->operator->cellAttributes() ?>>
			<span id="el_job_card_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="job_card" data-field="x_operator" data-value-separator="<?php echo $job_card->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $job_card->operator->editAttributes() ?>>
		<?php echo $job_card->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $job_card->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card_datetime"><?php echo $job_card->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->datetime->cellAttributes() ?>>
			<span id="el_job_card_datetime">
<input type="text" data-table="job_card" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($job_card->datetime->getPlaceHolder()) ?>" value="<?php echo $job_card->datetime->EditValue ?>"<?php echo $job_card->datetime->editAttributes() ?>>
<?php if (!$job_card->datetime->ReadOnly && !$job_card->datetime->Disabled && !isset($job_card->datetime->EditAttrs["readonly"]) && !isset($job_card->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fjob_cardsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label for="x_buyer_id" class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card_buyer_id"><?php echo $job_card->buyer_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_id" id="z_buyer_id" value="="></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->buyer_id->cellAttributes() ?>>
			<span id="el_job_card_buyer_id">
<input type="text" data-table="job_card" data-field="x_buyer_id" name="x_buyer_id" id="x_buyer_id" size="30" placeholder="<?php echo HtmlEncode($job_card->buyer_id->getPlaceHolder()) ?>" value="<?php echo $job_card->buyer_id->EditValue ?>"<?php echo $job_card->buyer_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($job_card->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label for="x_company_id" class="<?php echo $job_card_search->LeftColumnClass ?>"><span id="elh_job_card_company_id"><?php echo $job_card->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $job_card_search->RightColumnClass ?>"><div<?php echo $job_card->company_id->cellAttributes() ?>>
			<span id="el_job_card_company_id">
<input type="text" data-table="job_card" data-field="x_company_id" name="x_company_id" id="x_company_id" size="30" placeholder="<?php echo HtmlEncode($job_card->company_id->getPlaceHolder()) ?>" value="<?php echo $job_card->company_id->EditValue ?>"<?php echo $job_card->company_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$job_card_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $job_card_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$job_card_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$job_card_search->terminate();
?>