<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$job_card_view = new job_card_view();

// Run the page
$job_card_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$job_card_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$job_card->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fjob_cardview = currentForm = new ew.Form("fjob_cardview", "view");

// Form_CustomValidate event
fjob_cardview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjob_cardview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjob_cardview.lists["x_works"] = <?php echo $job_card_view->works->Lookup->toClientList() ?>;
fjob_cardview.lists["x_works"].options = <?php echo JsonEncode($job_card_view->works->lookupOptions()) ?>;
fjob_cardview.lists["x_issue_to_internal"] = <?php echo $job_card_view->issue_to_internal->Lookup->toClientList() ?>;
fjob_cardview.lists["x_issue_to_internal"].options = <?php echo JsonEncode($job_card_view->issue_to_internal->lookupOptions()) ?>;
fjob_cardview.lists["x_issue_to_external"] = <?php echo $job_card_view->issue_to_external->Lookup->toClientList() ?>;
fjob_cardview.lists["x_issue_to_external"].options = <?php echo JsonEncode($job_card_view->issue_to_external->lookupOptions()) ?>;
fjob_cardview.lists["x_issue_to"] = <?php echo $job_card_view->issue_to->Lookup->toClientList() ?>;
fjob_cardview.lists["x_issue_to"].options = <?php echo JsonEncode($job_card_view->issue_to->lookupOptions()) ?>;
fjob_cardview.lists["x_grp"] = <?php echo $job_card_view->grp->Lookup->toClientList() ?>;
fjob_cardview.lists["x_grp"].options = <?php echo JsonEncode($job_card_view->grp->lookupOptions()) ?>;
fjob_cardview.lists["x_s_grp"] = <?php echo $job_card_view->s_grp->Lookup->toClientList() ?>;
fjob_cardview.lists["x_s_grp"].options = <?php echo JsonEncode($job_card_view->s_grp->lookupOptions()) ?>;
fjob_cardview.lists["x_packing_type"] = <?php echo $job_card_view->packing_type->Lookup->toClientList() ?>;
fjob_cardview.lists["x_packing_type"].options = <?php echo JsonEncode($job_card_view->packing_type->lookupOptions()) ?>;
fjob_cardview.lists["x_product_code"] = <?php echo $job_card_view->product_code->Lookup->toClientList() ?>;
fjob_cardview.lists["x_product_code"].options = <?php echo JsonEncode($job_card_view->product_code->lookupOptions()) ?>;
fjob_cardview.lists["x_po[]"] = <?php echo $job_card_view->po->Lookup->toClientList() ?>;
fjob_cardview.lists["x_po[]"].options = <?php echo JsonEncode($job_card_view->po->lookupOptions()) ?>;
fjob_cardview.lists["x_pro_unit"] = <?php echo $job_card_view->pro_unit->Lookup->toClientList() ?>;
fjob_cardview.lists["x_pro_unit"].options = <?php echo JsonEncode($job_card_view->pro_unit->lookupOptions()) ?>;
fjob_cardview.lists["x_employee_id[]"] = <?php echo $job_card_view->employee_id->Lookup->toClientList() ?>;
fjob_cardview.lists["x_employee_id[]"].options = <?php echo JsonEncode($job_card_view->employee_id->lookupOptions()) ?>;
fjob_cardview.lists["x_operator"] = <?php echo $job_card_view->operator->Lookup->toClientList() ?>;
fjob_cardview.lists["x_operator"].options = <?php echo JsonEncode($job_card_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$job_card->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $job_card_view->ExportOptions->render("body") ?>
<?php $job_card_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $job_card_view->showPageHeader(); ?>
<?php
$job_card_view->showMessage();
?>
<form name="fjob_cardview" id="fjob_cardview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($job_card_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $job_card_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="job_card">
<input type="hidden" name="modal" value="<?php echo (int)$job_card_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($job_card->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card_id"><?php echo $job_card->id->caption() ?></span></td>
		<td data-name="id"<?php echo $job_card->id->cellAttributes() ?>>
<span id="el_job_card_id">
<span<?php echo $job_card->id->viewAttributes() ?>>
<?php echo $job_card->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card->jc_no->Visible) { // jc_no ?>
	<tr id="r_jc_no">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card_jc_no"><?php echo $job_card->jc_no->caption() ?></span></td>
		<td data-name="jc_no"<?php echo $job_card->jc_no->cellAttributes() ?>>
<span id="el_job_card_jc_no">
<span<?php echo $job_card->jc_no->viewAttributes() ?>>
<?php echo $job_card->jc_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card->works->Visible) { // works ?>
	<tr id="r_works">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card_works"><?php echo $job_card->works->caption() ?></span></td>
		<td data-name="works"<?php echo $job_card->works->cellAttributes() ?>>
<span id="el_job_card_works">
<span<?php echo $job_card->works->viewAttributes() ?>>
<?php if ((!EmptyString($job_card->works->getViewValue())) && $job_card->works->linkAttributes() <> "") { ?>
<a<?php echo $job_card->works->linkAttributes() ?>><?php echo $job_card->works->getViewValue() ?></a>
<?php } else { ?>
<?php echo $job_card->works->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card->issue_to_internal->Visible) { // issue_to_internal ?>
	<tr id="r_issue_to_internal">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card_issue_to_internal"><?php echo $job_card->issue_to_internal->caption() ?></span></td>
		<td data-name="issue_to_internal"<?php echo $job_card->issue_to_internal->cellAttributes() ?>>
<span id="el_job_card_issue_to_internal">
<span<?php echo $job_card->issue_to_internal->viewAttributes() ?>>
<?php echo $job_card->issue_to_internal->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card->issue_to_external->Visible) { // issue_to_external ?>
	<tr id="r_issue_to_external">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card_issue_to_external"><?php echo $job_card->issue_to_external->caption() ?></span></td>
		<td data-name="issue_to_external"<?php echo $job_card->issue_to_external->cellAttributes() ?>>
<span id="el_job_card_issue_to_external">
<span<?php echo $job_card->issue_to_external->viewAttributes() ?>>
<?php echo $job_card->issue_to_external->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card->issue_to->Visible) { // issue_to ?>
	<tr id="r_issue_to">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card_issue_to"><?php echo $job_card->issue_to->caption() ?></span></td>
		<td data-name="issue_to"<?php echo $job_card->issue_to->cellAttributes() ?>>
<span id="el_job_card_issue_to">
<span<?php echo $job_card->issue_to->viewAttributes() ?>>
<?php echo $job_card->issue_to->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card_grp"><?php echo $job_card->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $job_card->grp->cellAttributes() ?>>
<span id="el_job_card_grp">
<span<?php echo $job_card->grp->viewAttributes() ?>>
<?php echo $job_card->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card->s_grp->Visible) { // s_grp ?>
	<tr id="r_s_grp">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card_s_grp"><?php echo $job_card->s_grp->caption() ?></span></td>
		<td data-name="s_grp"<?php echo $job_card->s_grp->cellAttributes() ?>>
<span id="el_job_card_s_grp">
<span<?php echo $job_card->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($job_card->s_grp->getViewValue())) && $job_card->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $job_card->s_grp->linkAttributes() ?>><?php echo $job_card->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $job_card->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card->packing_type->Visible) { // packing_type ?>
	<tr id="r_packing_type">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card_packing_type"><?php echo $job_card->packing_type->caption() ?></span></td>
		<td data-name="packing_type"<?php echo $job_card->packing_type->cellAttributes() ?>>
<span id="el_job_card_packing_type">
<span<?php echo $job_card->packing_type->viewAttributes() ?>>
<?php echo $job_card->packing_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card->product_code->Visible) { // product_code ?>
	<tr id="r_product_code">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card_product_code"><?php echo $job_card->product_code->caption() ?></span></td>
		<td data-name="product_code"<?php echo $job_card->product_code->cellAttributes() ?>>
<span id="el_job_card_product_code">
<span<?php echo $job_card->product_code->viewAttributes() ?>>
<?php echo $job_card->product_code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card->po->Visible) { // po ?>
	<tr id="r_po">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card_po"><?php echo $job_card->po->caption() ?></span></td>
		<td data-name="po"<?php echo $job_card->po->cellAttributes() ?>>
<span id="el_job_card_po">
<span<?php echo $job_card->po->viewAttributes() ?>>
<?php if ((!EmptyString($job_card->po->getViewValue())) && $job_card->po->linkAttributes() <> "") { ?>
<a<?php echo $job_card->po->linkAttributes() ?>><?php echo $job_card->po->getViewValue() ?></a>
<?php } else { ?>
<?php echo $job_card->po->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card->quantity->Visible) { // quantity ?>
	<tr id="r_quantity">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card_quantity"><?php echo $job_card->quantity->caption() ?></span></td>
		<td data-name="quantity"<?php echo $job_card->quantity->cellAttributes() ?>>
<span id="el_job_card_quantity">
<span<?php echo $job_card->quantity->viewAttributes() ?>>
<?php if ((!EmptyString($job_card->quantity->getViewValue())) && $job_card->quantity->linkAttributes() <> "") { ?>
<a<?php echo $job_card->quantity->linkAttributes() ?>><?php echo $job_card->quantity->getViewValue() ?></a>
<?php } else { ?>
<?php echo $job_card->quantity->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card->pro_unit->Visible) { // pro_unit ?>
	<tr id="r_pro_unit">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card_pro_unit"><?php echo $job_card->pro_unit->caption() ?></span></td>
		<td data-name="pro_unit"<?php echo $job_card->pro_unit->cellAttributes() ?>>
<span id="el_job_card_pro_unit">
<span<?php echo $job_card->pro_unit->viewAttributes() ?>>
<?php echo $job_card->pro_unit->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card->employee_id->Visible) { // employee_id ?>
	<tr id="r_employee_id">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card_employee_id"><?php echo $job_card->employee_id->caption() ?></span></td>
		<td data-name="employee_id"<?php echo $job_card->employee_id->cellAttributes() ?>>
<span id="el_job_card_employee_id">
<span<?php echo $job_card->employee_id->viewAttributes() ?>>
<?php if ((!EmptyString($job_card->employee_id->getViewValue())) && $job_card->employee_id->linkAttributes() <> "") { ?>
<a<?php echo $job_card->employee_id->linkAttributes() ?>><?php echo $job_card->employee_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $job_card->employee_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card->_1->Visible) { // 1 ?>
	<tr id="r__1">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card__1"><?php echo $job_card->_1->caption() ?></span></td>
		<td data-name="_1"<?php echo $job_card->_1->cellAttributes() ?>>
<span id="el_job_card__1">
<span<?php echo $job_card->_1->viewAttributes() ?>>
<?php echo $job_card->_1->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card->_2->Visible) { // 2 ?>
	<tr id="r__2">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card__2"><?php echo $job_card->_2->caption() ?></span></td>
		<td data-name="_2"<?php echo $job_card->_2->cellAttributes() ?>>
<span id="el_job_card__2">
<span<?php echo $job_card->_2->viewAttributes() ?>>
<?php echo $job_card->_2->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card->_3->Visible) { // 3 ?>
	<tr id="r__3">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card__3"><?php echo $job_card->_3->caption() ?></span></td>
		<td data-name="_3"<?php echo $job_card->_3->cellAttributes() ?>>
<span id="el_job_card__3">
<span<?php echo $job_card->_3->viewAttributes() ?>>
<?php echo $job_card->_3->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card->_4->Visible) { // 4 ?>
	<tr id="r__4">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card__4"><?php echo $job_card->_4->caption() ?></span></td>
		<td data-name="_4"<?php echo $job_card->_4->cellAttributes() ?>>
<span id="el_job_card__4">
<span<?php echo $job_card->_4->viewAttributes() ?>>
<?php echo $job_card->_4->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card->_5->Visible) { // 5 ?>
	<tr id="r__5">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card__5"><?php echo $job_card->_5->caption() ?></span></td>
		<td data-name="_5"<?php echo $job_card->_5->cellAttributes() ?>>
<span id="el_job_card__5">
<span<?php echo $job_card->_5->viewAttributes() ?>>
<?php echo $job_card->_5->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card->_6->Visible) { // 6 ?>
	<tr id="r__6">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card__6"><?php echo $job_card->_6->caption() ?></span></td>
		<td data-name="_6"<?php echo $job_card->_6->cellAttributes() ?>>
<span id="el_job_card__6">
<span<?php echo $job_card->_6->viewAttributes() ?>>
<?php echo $job_card->_6->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card->_7->Visible) { // 7 ?>
	<tr id="r__7">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card__7"><?php echo $job_card->_7->caption() ?></span></td>
		<td data-name="_7"<?php echo $job_card->_7->cellAttributes() ?>>
<span id="el_job_card__7">
<span<?php echo $job_card->_7->viewAttributes() ?>>
<?php echo $job_card->_7->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card->_8->Visible) { // 8 ?>
	<tr id="r__8">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card__8"><?php echo $job_card->_8->caption() ?></span></td>
		<td data-name="_8"<?php echo $job_card->_8->cellAttributes() ?>>
<span id="el_job_card__8">
<span<?php echo $job_card->_8->viewAttributes() ?>>
<?php echo $job_card->_8->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card->other1->Visible) { // other1 ?>
	<tr id="r_other1">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card_other1"><?php echo $job_card->other1->caption() ?></span></td>
		<td data-name="other1"<?php echo $job_card->other1->cellAttributes() ?>>
<span id="el_job_card_other1">
<span<?php echo $job_card->other1->viewAttributes() ?>>
<?php echo $job_card->other1->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card->other2->Visible) { // other2 ?>
	<tr id="r_other2">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card_other2"><?php echo $job_card->other2->caption() ?></span></td>
		<td data-name="other2"<?php echo $job_card->other2->cellAttributes() ?>>
<span id="el_job_card_other2">
<span<?php echo $job_card->other2->viewAttributes() ?>>
<?php echo $job_card->other2->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card_operator"><?php echo $job_card->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $job_card->operator->cellAttributes() ?>>
<span id="el_job_card_operator">
<span<?php echo $job_card->operator->viewAttributes() ?>>
<?php echo $job_card->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card_datetime"><?php echo $job_card->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $job_card->datetime->cellAttributes() ?>>
<span id="el_job_card_datetime">
<span<?php echo $job_card->datetime->viewAttributes() ?>>
<?php echo $job_card->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card->buyer_id->Visible) { // buyer_id ?>
	<tr id="r_buyer_id">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card_buyer_id"><?php echo $job_card->buyer_id->caption() ?></span></td>
		<td data-name="buyer_id"<?php echo $job_card->buyer_id->cellAttributes() ?>>
<span id="el_job_card_buyer_id">
<span<?php echo $job_card->buyer_id->viewAttributes() ?>>
<?php echo $job_card->buyer_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($job_card->company_id->Visible) { // company_id ?>
	<tr id="r_company_id">
		<td class="<?php echo $job_card_view->TableLeftColumnClass ?>"><span id="elh_job_card_company_id"><?php echo $job_card->company_id->caption() ?></span></td>
		<td data-name="company_id"<?php echo $job_card->company_id->cellAttributes() ?>>
<span id="el_job_card_company_id">
<span<?php echo $job_card->company_id->viewAttributes() ?>>
<?php echo $job_card->company_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$job_card_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$job_card->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$job_card_view->terminate();
?>