<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$journal_delete = new journal_delete();

// Run the page
$journal_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$journal_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fjournaldelete = currentForm = new ew.Form("fjournaldelete", "delete");

// Form_CustomValidate event
fjournaldelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjournaldelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjournaldelete.lists["x_to_account"] = <?php echo $journal_delete->to_account->Lookup->toClientList() ?>;
fjournaldelete.lists["x_to_account"].options = <?php echo JsonEncode($journal_delete->to_account->lookupOptions()) ?>;
fjournaldelete.autoSuggests["x_to_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fjournaldelete.lists["x_from_account"] = <?php echo $journal_delete->from_account->Lookup->toClientList() ?>;
fjournaldelete.lists["x_from_account"].options = <?php echo JsonEncode($journal_delete->from_account->lookupOptions()) ?>;
fjournaldelete.autoSuggests["x_from_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fjournaldelete.lists["x_operator"] = <?php echo $journal_delete->operator->Lookup->toClientList() ?>;
fjournaldelete.lists["x_operator"].options = <?php echo JsonEncode($journal_delete->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $journal_delete->showPageHeader(); ?>
<?php
$journal_delete->showMessage();
?>
<form name="fjournaldelete" id="fjournaldelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($journal_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $journal_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="journal">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($journal_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($journal->to_account->Visible) { // to_account ?>
		<th class="<?php echo $journal->to_account->headerCellClass() ?>"><span id="elh_journal_to_account" class="journal_to_account"><?php echo $journal->to_account->caption() ?></span></th>
<?php } ?>
<?php if ($journal->from_account->Visible) { // from_account ?>
		<th class="<?php echo $journal->from_account->headerCellClass() ?>"><span id="elh_journal_from_account" class="journal_from_account"><?php echo $journal->from_account->caption() ?></span></th>
<?php } ?>
<?php if ($journal->reference->Visible) { // reference ?>
		<th class="<?php echo $journal->reference->headerCellClass() ?>"><span id="elh_journal_reference" class="journal_reference"><?php echo $journal->reference->caption() ?></span></th>
<?php } ?>
<?php if ($journal->dated->Visible) { // dated ?>
		<th class="<?php echo $journal->dated->headerCellClass() ?>"><span id="elh_journal_dated" class="journal_dated"><?php echo $journal->dated->caption() ?></span></th>
<?php } ?>
<?php if ($journal->amount->Visible) { // amount ?>
		<th class="<?php echo $journal->amount->headerCellClass() ?>"><span id="elh_journal_amount" class="journal_amount"><?php echo $journal->amount->caption() ?></span></th>
<?php } ?>
<?php if ($journal->remarks->Visible) { // remarks ?>
		<th class="<?php echo $journal->remarks->headerCellClass() ?>"><span id="elh_journal_remarks" class="journal_remarks"><?php echo $journal->remarks->caption() ?></span></th>
<?php } ?>
<?php if ($journal->uploads->Visible) { // uploads ?>
		<th class="<?php echo $journal->uploads->headerCellClass() ?>"><span id="elh_journal_uploads" class="journal_uploads"><?php echo $journal->uploads->caption() ?></span></th>
<?php } ?>
<?php if ($journal->operator->Visible) { // operator ?>
		<th class="<?php echo $journal->operator->headerCellClass() ?>"><span id="elh_journal_operator" class="journal_operator"><?php echo $journal->operator->caption() ?></span></th>
<?php } ?>
<?php if ($journal->datetime->Visible) { // datetime ?>
		<th class="<?php echo $journal->datetime->headerCellClass() ?>"><span id="elh_journal_datetime" class="journal_datetime"><?php echo $journal->datetime->caption() ?></span></th>
<?php } ?>
<?php if ($journal->id->Visible) { // id ?>
		<th class="<?php echo $journal->id->headerCellClass() ?>"><span id="elh_journal_id" class="journal_id"><?php echo $journal->id->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$journal_delete->RecCnt = 0;
$i = 0;
while (!$journal_delete->Recordset->EOF) {
	$journal_delete->RecCnt++;
	$journal_delete->RowCnt++;

	// Set row properties
	$journal->resetAttributes();
	$journal->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$journal_delete->loadRowValues($journal_delete->Recordset);

	// Render row
	$journal_delete->renderRow();
?>
	<tr<?php echo $journal->rowAttributes() ?>>
<?php if ($journal->to_account->Visible) { // to_account ?>
		<td<?php echo $journal->to_account->cellAttributes() ?>>
<span id="el<?php echo $journal_delete->RowCnt ?>_journal_to_account" class="journal_to_account">
<span<?php echo $journal->to_account->viewAttributes() ?>>
<?php echo $journal->to_account->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($journal->from_account->Visible) { // from_account ?>
		<td<?php echo $journal->from_account->cellAttributes() ?>>
<span id="el<?php echo $journal_delete->RowCnt ?>_journal_from_account" class="journal_from_account">
<span<?php echo $journal->from_account->viewAttributes() ?>>
<?php echo $journal->from_account->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($journal->reference->Visible) { // reference ?>
		<td<?php echo $journal->reference->cellAttributes() ?>>
<span id="el<?php echo $journal_delete->RowCnt ?>_journal_reference" class="journal_reference">
<span<?php echo $journal->reference->viewAttributes() ?>>
<?php echo $journal->reference->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($journal->dated->Visible) { // dated ?>
		<td<?php echo $journal->dated->cellAttributes() ?>>
<span id="el<?php echo $journal_delete->RowCnt ?>_journal_dated" class="journal_dated">
<span<?php echo $journal->dated->viewAttributes() ?>>
<?php echo $journal->dated->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($journal->amount->Visible) { // amount ?>
		<td<?php echo $journal->amount->cellAttributes() ?>>
<span id="el<?php echo $journal_delete->RowCnt ?>_journal_amount" class="journal_amount">
<span<?php echo $journal->amount->viewAttributes() ?>>
<?php echo $journal->amount->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($journal->remarks->Visible) { // remarks ?>
		<td<?php echo $journal->remarks->cellAttributes() ?>>
<span id="el<?php echo $journal_delete->RowCnt ?>_journal_remarks" class="journal_remarks">
<span<?php echo $journal->remarks->viewAttributes() ?>>
<?php echo $journal->remarks->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($journal->uploads->Visible) { // uploads ?>
		<td<?php echo $journal->uploads->cellAttributes() ?>>
<span id="el<?php echo $journal_delete->RowCnt ?>_journal_uploads" class="journal_uploads">
<span>
<?php echo GetFileViewTag($journal->uploads, $journal->uploads->getViewValue()) ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($journal->operator->Visible) { // operator ?>
		<td<?php echo $journal->operator->cellAttributes() ?>>
<span id="el<?php echo $journal_delete->RowCnt ?>_journal_operator" class="journal_operator">
<span<?php echo $journal->operator->viewAttributes() ?>>
<?php echo $journal->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($journal->datetime->Visible) { // datetime ?>
		<td<?php echo $journal->datetime->cellAttributes() ?>>
<span id="el<?php echo $journal_delete->RowCnt ?>_journal_datetime" class="journal_datetime">
<span<?php echo $journal->datetime->viewAttributes() ?>>
<?php echo $journal->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($journal->id->Visible) { // id ?>
		<td<?php echo $journal->id->cellAttributes() ?>>
<span id="el<?php echo $journal_delete->RowCnt ?>_journal_id" class="journal_id">
<span<?php echo $journal->id->viewAttributes() ?>>
<?php echo $journal->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$journal_delete->Recordset->moveNext();
}
$journal_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $journal_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$journal_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$journal_delete->terminate();
?>