<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$journal_edit = new journal_edit();

// Run the page
$journal_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$journal_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fjournaledit = currentForm = new ew.Form("fjournaledit", "edit");

// Validate form
fjournaledit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($journal_edit->to_account->Required) { ?>
			elm = this.getElements("x" + infix + "_to_account");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $journal->to_account->caption(), $journal->to_account->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($journal_edit->from_account->Required) { ?>
			elm = this.getElements("x" + infix + "_from_account");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $journal->from_account->caption(), $journal->from_account->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($journal_edit->reference->Required) { ?>
			elm = this.getElements("x" + infix + "_reference");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $journal->reference->caption(), $journal->reference->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($journal_edit->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $journal->dated->caption(), $journal->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($journal->dated->errorMessage()) ?>");
		<?php if ($journal_edit->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $journal->amount->caption(), $journal->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($journal->amount->errorMessage()) ?>");
		<?php if ($journal_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $journal->remarks->caption(), $journal->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($journal_edit->uploads->Required) { ?>
			felm = this.getElements("x" + infix + "_uploads");
			elm = this.getElements("fn_x" + infix + "_uploads");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $journal->uploads->caption(), $journal->uploads->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($journal_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $journal->operator->caption(), $journal->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($journal_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $journal->datetime->caption(), $journal->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($journal_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $journal->id->caption(), $journal->id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($journal->id->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fjournaledit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjournaledit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjournaledit.lists["x_to_account"] = <?php echo $journal_edit->to_account->Lookup->toClientList() ?>;
fjournaledit.lists["x_to_account"].options = <?php echo JsonEncode($journal_edit->to_account->lookupOptions()) ?>;
fjournaledit.autoSuggests["x_to_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fjournaledit.lists["x_from_account"] = <?php echo $journal_edit->from_account->Lookup->toClientList() ?>;
fjournaledit.lists["x_from_account"].options = <?php echo JsonEncode($journal_edit->from_account->lookupOptions()) ?>;
fjournaledit.autoSuggests["x_from_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fjournaledit.lists["x_operator"] = <?php echo $journal_edit->operator->Lookup->toClientList() ?>;
fjournaledit.lists["x_operator"].options = <?php echo JsonEncode($journal_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $journal_edit->showPageHeader(); ?>
<?php
$journal_edit->showMessage();
?>
<form name="fjournaledit" id="fjournaledit" class="<?php echo $journal_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($journal_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $journal_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="journal">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$journal_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($journal->to_account->Visible) { // to_account ?>
	<div id="r_to_account" class="form-group row">
		<label id="elh_journal_to_account" class="<?php echo $journal_edit->LeftColumnClass ?>"><?php echo $journal->to_account->caption() ?><?php echo ($journal->to_account->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $journal_edit->RightColumnClass ?>"><div<?php echo $journal->to_account->cellAttributes() ?>>
<span id="el_journal_to_account">
<?php
$wrkonchange = "" . trim(@$journal->to_account->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$journal->to_account->EditAttrs["onchange"] = "";
?>
<span id="as_x_to_account" class="text-nowrap" style="z-index: 8990">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_to_account" id="sv_x_to_account" value="<?php echo RemoveHtml($journal->to_account->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($journal->to_account->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($journal->to_account->getPlaceHolder()) ?>"<?php echo $journal->to_account->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($journal->to_account->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_to_account',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($journal->to_account->ReadOnly || $journal->to_account->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="journal" data-field="x_to_account" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $journal->to_account->displayValueSeparatorAttribute() ?>" name="x_to_account" id="x_to_account" value="<?php echo HtmlEncode($journal->to_account->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fjournaledit.createAutoSuggest({"id":"x_to_account","forceSelect":true});
</script>
<?php echo $journal->to_account->Lookup->getParamTag("p_x_to_account") ?>
</span>
<?php echo $journal->to_account->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($journal->from_account->Visible) { // from_account ?>
	<div id="r_from_account" class="form-group row">
		<label id="elh_journal_from_account" class="<?php echo $journal_edit->LeftColumnClass ?>"><?php echo $journal->from_account->caption() ?><?php echo ($journal->from_account->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $journal_edit->RightColumnClass ?>"><div<?php echo $journal->from_account->cellAttributes() ?>>
<span id="el_journal_from_account">
<?php
$wrkonchange = "" . trim(@$journal->from_account->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$journal->from_account->EditAttrs["onchange"] = "";
?>
<span id="as_x_from_account" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_from_account" id="sv_x_from_account" value="<?php echo RemoveHtml($journal->from_account->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($journal->from_account->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($journal->from_account->getPlaceHolder()) ?>"<?php echo $journal->from_account->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($journal->from_account->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_from_account',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($journal->from_account->ReadOnly || $journal->from_account->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="journal" data-field="x_from_account" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $journal->from_account->displayValueSeparatorAttribute() ?>" name="x_from_account" id="x_from_account" value="<?php echo HtmlEncode($journal->from_account->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fjournaledit.createAutoSuggest({"id":"x_from_account","forceSelect":true});
</script>
<?php echo $journal->from_account->Lookup->getParamTag("p_x_from_account") ?>
</span>
<?php echo $journal->from_account->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($journal->reference->Visible) { // reference ?>
	<div id="r_reference" class="form-group row">
		<label id="elh_journal_reference" for="x_reference" class="<?php echo $journal_edit->LeftColumnClass ?>"><?php echo $journal->reference->caption() ?><?php echo ($journal->reference->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $journal_edit->RightColumnClass ?>"><div<?php echo $journal->reference->cellAttributes() ?>>
<span id="el_journal_reference">
<input type="text" data-table="journal" data-field="x_reference" name="x_reference" id="x_reference" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($journal->reference->getPlaceHolder()) ?>" value="<?php echo $journal->reference->EditValue ?>"<?php echo $journal->reference->editAttributes() ?>>
</span>
<?php echo $journal->reference->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($journal->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_journal_dated" for="x_dated" class="<?php echo $journal_edit->LeftColumnClass ?>"><?php echo $journal->dated->caption() ?><?php echo ($journal->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $journal_edit->RightColumnClass ?>"><div<?php echo $journal->dated->cellAttributes() ?>>
<span id="el_journal_dated">
<input type="text" data-table="journal" data-field="x_dated" data-format="2" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($journal->dated->getPlaceHolder()) ?>" value="<?php echo $journal->dated->EditValue ?>"<?php echo $journal->dated->editAttributes() ?>>
<?php if (!$journal->dated->ReadOnly && !$journal->dated->Disabled && !isset($journal->dated->EditAttrs["readonly"]) && !isset($journal->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fjournaledit", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
<?php echo $journal->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($journal->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_journal_amount" for="x_amount" class="<?php echo $journal_edit->LeftColumnClass ?>"><?php echo $journal->amount->caption() ?><?php echo ($journal->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $journal_edit->RightColumnClass ?>"><div<?php echo $journal->amount->cellAttributes() ?>>
<span id="el_journal_amount">
<input type="text" data-table="journal" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($journal->amount->getPlaceHolder()) ?>" value="<?php echo $journal->amount->EditValue ?>"<?php echo $journal->amount->editAttributes() ?>>
</span>
<?php echo $journal->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($journal->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_journal_remarks" for="x_remarks" class="<?php echo $journal_edit->LeftColumnClass ?>"><?php echo $journal->remarks->caption() ?><?php echo ($journal->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $journal_edit->RightColumnClass ?>"><div<?php echo $journal->remarks->cellAttributes() ?>>
<span id="el_journal_remarks">
<input type="text" data-table="journal" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($journal->remarks->getPlaceHolder()) ?>" value="<?php echo $journal->remarks->EditValue ?>"<?php echo $journal->remarks->editAttributes() ?>>
</span>
<?php echo $journal->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($journal->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label id="elh_journal_uploads" class="<?php echo $journal_edit->LeftColumnClass ?>"><?php echo $journal->uploads->caption() ?><?php echo ($journal->uploads->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $journal_edit->RightColumnClass ?>"><div<?php echo $journal->uploads->cellAttributes() ?>>
<span id="el_journal_uploads">
<div id="fd_x_uploads">
<span title="<?php echo $journal->uploads->title() ? $journal->uploads->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($journal->uploads->ReadOnly || $journal->uploads->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="journal" data-field="x_uploads" name="x_uploads" id="x_uploads" multiple="multiple"<?php echo $journal->uploads->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?php echo $journal->uploads->Upload->FileName ?>">
<?php if (Post("fa_x_uploads") == "0") { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="1">
<?php } ?>
<input type="hidden" name="fs_x_uploads" id= "fs_x_uploads" value="255">
<input type="hidden" name="fx_x_uploads" id= "fx_x_uploads" value="<?php echo $journal->uploads->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_uploads" id= "fm_x_uploads" value="<?php echo $journal->uploads->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_uploads" id= "fc_x_uploads" value="<?php echo $journal->uploads->UploadMaxFileCount ?>">
</div>
<table id="ft_x_uploads" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $journal->uploads->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($journal->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_journal_id" for="x_id" class="<?php echo $journal_edit->LeftColumnClass ?>"><?php echo $journal->id->caption() ?><?php echo ($journal->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $journal_edit->RightColumnClass ?>"><div<?php echo $journal->id->cellAttributes() ?>>
<span id="el_journal_id">
<span<?php echo $journal->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($journal->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="journal" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($journal->id->CurrentValue) ?>">
<?php echo $journal->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$journal_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $journal_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $journal_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$journal_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$journal_edit->terminate();
?>