<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$journal_list = new journal_list();

// Run the page
$journal_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$journal_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$journal->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fjournallist = currentForm = new ew.Form("fjournallist", "list");
fjournallist.formKeyCountName = '<?php echo $journal_list->FormKeyCountName ?>';

// Form_CustomValidate event
fjournallist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjournallist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjournallist.lists["x_to_account"] = <?php echo $journal_list->to_account->Lookup->toClientList() ?>;
fjournallist.lists["x_to_account"].options = <?php echo JsonEncode($journal_list->to_account->lookupOptions()) ?>;
fjournallist.autoSuggests["x_to_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fjournallist.lists["x_from_account"] = <?php echo $journal_list->from_account->Lookup->toClientList() ?>;
fjournallist.lists["x_from_account"].options = <?php echo JsonEncode($journal_list->from_account->lookupOptions()) ?>;
fjournallist.autoSuggests["x_from_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fjournallist.lists["x_operator"] = <?php echo $journal_list->operator->Lookup->toClientList() ?>;
fjournallist.lists["x_operator"].options = <?php echo JsonEncode($journal_list->operator->lookupOptions()) ?>;

// Form object for search
var fjournallistsrch = currentSearchForm = new ew.Form("fjournallistsrch");

// Validate function for search
fjournallistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($journal->dated->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fjournallistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjournallistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjournallistsrch.lists["x_to_account"] = <?php echo $journal_list->to_account->Lookup->toClientList() ?>;
fjournallistsrch.lists["x_to_account"].options = <?php echo JsonEncode($journal_list->to_account->lookupOptions()) ?>;
fjournallistsrch.autoSuggests["x_to_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fjournallistsrch.lists["x_from_account"] = <?php echo $journal_list->from_account->Lookup->toClientList() ?>;
fjournallistsrch.lists["x_from_account"].options = <?php echo JsonEncode($journal_list->from_account->lookupOptions()) ?>;
fjournallistsrch.autoSuggests["x_from_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
fjournallistsrch.filterList = <?php echo $journal_list->getFilterList() ?>;

// Init search panel as collapsed
fjournallistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$journal->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($journal_list->TotalRecs > 0 && $journal_list->ExportOptions->visible()) { ?>
<?php $journal_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($journal_list->ImportOptions->visible()) { ?>
<?php $journal_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($journal_list->SearchOptions->visible()) { ?>
<?php $journal_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($journal_list->FilterOptions->visible()) { ?>
<?php $journal_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$journal_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$journal->isExport() && !$journal->CurrentAction) { ?>
<form name="fjournallistsrch" id="fjournallistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($journal_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fjournallistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="journal">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$journal_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$journal->RowType = ROWTYPE_SEARCH;

// Render row
$journal->resetAttributes();
$journal_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($journal->to_account->Visible) { // to_account ?>
	<div id="xsc_to_account" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $journal->to_account->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_to_account" id="z_to_account" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$journal->to_account->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$journal->to_account->EditAttrs["onchange"] = "";
?>
<span id="as_x_to_account" class="text-nowrap" style="z-index: 8990">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_to_account" id="sv_x_to_account" value="<?php echo RemoveHtml($journal->to_account->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($journal->to_account->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($journal->to_account->getPlaceHolder()) ?>"<?php echo $journal->to_account->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($journal->to_account->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_to_account',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($journal->to_account->ReadOnly || $journal->to_account->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="journal" data-field="x_to_account" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $journal->to_account->displayValueSeparatorAttribute() ?>" name="x_to_account" id="x_to_account" value="<?php echo HtmlEncode($journal->to_account->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fjournallistsrch.createAutoSuggest({"id":"x_to_account","forceSelect":false});
</script>
<?php echo $journal->to_account->Lookup->getParamTag("p_x_to_account") ?>
</span>
	</div>
<?php } ?>
<?php if ($journal->from_account->Visible) { // from_account ?>
	<div id="xsc_from_account" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $journal->from_account->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_from_account" id="z_from_account" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$journal->from_account->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$journal->from_account->EditAttrs["onchange"] = "";
?>
<span id="as_x_from_account" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_from_account" id="sv_x_from_account" value="<?php echo RemoveHtml($journal->from_account->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($journal->from_account->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($journal->from_account->getPlaceHolder()) ?>"<?php echo $journal->from_account->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($journal->from_account->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_from_account',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($journal->from_account->ReadOnly || $journal->from_account->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="journal" data-field="x_from_account" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $journal->from_account->displayValueSeparatorAttribute() ?>" name="x_from_account" id="x_from_account" value="<?php echo HtmlEncode($journal->from_account->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fjournallistsrch.createAutoSuggest({"id":"x_from_account","forceSelect":false});
</script>
<?php echo $journal->from_account->Lookup->getParamTag("p_x_from_account") ?>
</span>
	</div>
<?php } ?>
<?php if ($journal->dated->Visible) { // dated ?>
	<div id="xsc_dated" class="ew-cell form-group">
		<label for="x_dated" class="ew-search-caption ew-label"><?php echo $journal->dated->caption() ?></label>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($journal->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($journal->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($journal->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($journal->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($journal->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($journal->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($journal->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="journal" data-field="x_dated" data-format="2" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($journal->dated->getPlaceHolder()) ?>" value="<?php echo $journal->dated->EditValue ?>"<?php echo $journal->dated->editAttributes() ?>>
<?php if (!$journal->dated->ReadOnly && !$journal->dated->Disabled && !isset($journal->dated->EditAttrs["readonly"]) && !isset($journal->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fjournallistsrch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
		<span class="ew-search-cond btw1_dated style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_dated style="d-none"">
<input type="text" data-table="journal" data-field="x_dated" data-format="2" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($journal->dated->getPlaceHolder()) ?>" value="<?php echo $journal->dated->EditValue2 ?>"<?php echo $journal->dated->editAttributes() ?>>
<?php if (!$journal->dated->ReadOnly && !$journal->dated->Disabled && !isset($journal->dated->EditAttrs["readonly"]) && !isset($journal->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fjournallistsrch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($journal_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($journal_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $journal_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($journal_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($journal_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($journal_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($journal_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $journal_list->showPageHeader(); ?>
<?php
$journal_list->showMessage();
?>
<?php if ($journal_list->TotalRecs > 0 || $journal->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($journal_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> journal">
<?php if (!$journal->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$journal->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($journal_list->Pager)) $journal_list->Pager = new PrevNextPager($journal_list->StartRec, $journal_list->DisplayRecs, $journal_list->TotalRecs, $journal_list->AutoHidePager) ?>
<?php if ($journal_list->Pager->RecordCount > 0 && $journal_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($journal_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $journal_list->pageUrl() ?>start=<?php echo $journal_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($journal_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $journal_list->pageUrl() ?>start=<?php echo $journal_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $journal_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($journal_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $journal_list->pageUrl() ?>start=<?php echo $journal_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($journal_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $journal_list->pageUrl() ?>start=<?php echo $journal_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $journal_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($journal_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $journal_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $journal_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $journal_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($journal_list->TotalRecs > 0 && (!$journal_list->AutoHidePageSizeSelector || $journal_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="journal">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($journal_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($journal_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($journal_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($journal_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($journal_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($journal->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $journal_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fjournallist" id="fjournallist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($journal_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $journal_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="journal">
<div id="gmp_journal" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($journal_list->TotalRecs > 0 || $journal->isGridEdit()) { ?>
<table id="tbl_journallist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$journal_list->RowType = ROWTYPE_HEADER;

// Render list options
$journal_list->renderListOptions();

// Render list options (header, left)
$journal_list->ListOptions->render("header", "left");
?>
<?php if ($journal->to_account->Visible) { // to_account ?>
	<?php if ($journal->sortUrl($journal->to_account) == "") { ?>
		<th data-name="to_account" class="<?php echo $journal->to_account->headerCellClass() ?>"><div id="elh_journal_to_account" class="journal_to_account"><div class="ew-table-header-caption"><?php echo $journal->to_account->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="to_account" class="<?php echo $journal->to_account->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $journal->SortUrl($journal->to_account) ?>',2);"><div id="elh_journal_to_account" class="journal_to_account">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $journal->to_account->caption() ?></span><span class="ew-table-header-sort"><?php if ($journal->to_account->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($journal->to_account->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($journal->from_account->Visible) { // from_account ?>
	<?php if ($journal->sortUrl($journal->from_account) == "") { ?>
		<th data-name="from_account" class="<?php echo $journal->from_account->headerCellClass() ?>"><div id="elh_journal_from_account" class="journal_from_account"><div class="ew-table-header-caption"><?php echo $journal->from_account->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="from_account" class="<?php echo $journal->from_account->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $journal->SortUrl($journal->from_account) ?>',2);"><div id="elh_journal_from_account" class="journal_from_account">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $journal->from_account->caption() ?></span><span class="ew-table-header-sort"><?php if ($journal->from_account->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($journal->from_account->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($journal->reference->Visible) { // reference ?>
	<?php if ($journal->sortUrl($journal->reference) == "") { ?>
		<th data-name="reference" class="<?php echo $journal->reference->headerCellClass() ?>"><div id="elh_journal_reference" class="journal_reference"><div class="ew-table-header-caption"><?php echo $journal->reference->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="reference" class="<?php echo $journal->reference->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $journal->SortUrl($journal->reference) ?>',2);"><div id="elh_journal_reference" class="journal_reference">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $journal->reference->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($journal->reference->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($journal->reference->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($journal->dated->Visible) { // dated ?>
	<?php if ($journal->sortUrl($journal->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $journal->dated->headerCellClass() ?>"><div id="elh_journal_dated" class="journal_dated"><div class="ew-table-header-caption"><?php echo $journal->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $journal->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $journal->SortUrl($journal->dated) ?>',2);"><div id="elh_journal_dated" class="journal_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $journal->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($journal->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($journal->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($journal->amount->Visible) { // amount ?>
	<?php if ($journal->sortUrl($journal->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $journal->amount->headerCellClass() ?>"><div id="elh_journal_amount" class="journal_amount"><div class="ew-table-header-caption"><?php echo $journal->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $journal->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $journal->SortUrl($journal->amount) ?>',2);"><div id="elh_journal_amount" class="journal_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $journal->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($journal->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($journal->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($journal->remarks->Visible) { // remarks ?>
	<?php if ($journal->sortUrl($journal->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $journal->remarks->headerCellClass() ?>"><div id="elh_journal_remarks" class="journal_remarks"><div class="ew-table-header-caption"><?php echo $journal->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $journal->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $journal->SortUrl($journal->remarks) ?>',2);"><div id="elh_journal_remarks" class="journal_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $journal->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($journal->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($journal->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($journal->uploads->Visible) { // uploads ?>
	<?php if ($journal->sortUrl($journal->uploads) == "") { ?>
		<th data-name="uploads" class="<?php echo $journal->uploads->headerCellClass() ?>"><div id="elh_journal_uploads" class="journal_uploads"><div class="ew-table-header-caption"><?php echo $journal->uploads->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="uploads" class="<?php echo $journal->uploads->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $journal->SortUrl($journal->uploads) ?>',2);"><div id="elh_journal_uploads" class="journal_uploads">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $journal->uploads->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($journal->uploads->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($journal->uploads->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($journal->operator->Visible) { // operator ?>
	<?php if ($journal->sortUrl($journal->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $journal->operator->headerCellClass() ?>"><div id="elh_journal_operator" class="journal_operator"><div class="ew-table-header-caption"><?php echo $journal->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $journal->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $journal->SortUrl($journal->operator) ?>',2);"><div id="elh_journal_operator" class="journal_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $journal->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($journal->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($journal->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($journal->datetime->Visible) { // datetime ?>
	<?php if ($journal->sortUrl($journal->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $journal->datetime->headerCellClass() ?>"><div id="elh_journal_datetime" class="journal_datetime"><div class="ew-table-header-caption"><?php echo $journal->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $journal->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $journal->SortUrl($journal->datetime) ?>',2);"><div id="elh_journal_datetime" class="journal_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $journal->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($journal->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($journal->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($journal->id->Visible) { // id ?>
	<?php if ($journal->sortUrl($journal->id) == "") { ?>
		<th data-name="id" class="<?php echo $journal->id->headerCellClass() ?>"><div id="elh_journal_id" class="journal_id"><div class="ew-table-header-caption"><?php echo $journal->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $journal->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $journal->SortUrl($journal->id) ?>',2);"><div id="elh_journal_id" class="journal_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $journal->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($journal->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($journal->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$journal_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($journal->ExportAll && $journal->isExport()) {
	$journal_list->StopRec = $journal_list->TotalRecs;
} else {

	// Set the last record to display
	if ($journal_list->TotalRecs > $journal_list->StartRec + $journal_list->DisplayRecs - 1)
		$journal_list->StopRec = $journal_list->StartRec + $journal_list->DisplayRecs - 1;
	else
		$journal_list->StopRec = $journal_list->TotalRecs;
}
$journal_list->RecCnt = $journal_list->StartRec - 1;
if ($journal_list->Recordset && !$journal_list->Recordset->EOF) {
	$journal_list->Recordset->moveFirst();
	$selectLimit = $journal_list->UseSelectLimit;
	if (!$selectLimit && $journal_list->StartRec > 1)
		$journal_list->Recordset->move($journal_list->StartRec - 1);
} elseif (!$journal->AllowAddDeleteRow && $journal_list->StopRec == 0) {
	$journal_list->StopRec = $journal->GridAddRowCount;
}

// Initialize aggregate
$journal->RowType = ROWTYPE_AGGREGATEINIT;
$journal->resetAttributes();
$journal_list->renderRow();
while ($journal_list->RecCnt < $journal_list->StopRec) {
	$journal_list->RecCnt++;
	if ($journal_list->RecCnt >= $journal_list->StartRec) {
		$journal_list->RowCnt++;

		// Set up key count
		$journal_list->KeyCount = $journal_list->RowIndex;

		// Init row class and style
		$journal->resetAttributes();
		$journal->CssClass = "";
		if ($journal->isGridAdd()) {
		} else {
			$journal_list->loadRowValues($journal_list->Recordset); // Load row values
		}
		$journal->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$journal->RowAttrs = array_merge($journal->RowAttrs, array('data-rowindex'=>$journal_list->RowCnt, 'id'=>'r' . $journal_list->RowCnt . '_journal', 'data-rowtype'=>$journal->RowType));

		// Render row
		$journal_list->renderRow();

		// Render list options
		$journal_list->renderListOptions();
?>
	<tr<?php echo $journal->rowAttributes() ?>>
<?php

// Render list options (body, left)
$journal_list->ListOptions->render("body", "left", $journal_list->RowCnt);
?>
	<?php if ($journal->to_account->Visible) { // to_account ?>
		<td data-name="to_account"<?php echo $journal->to_account->cellAttributes() ?>>
<span id="el<?php echo $journal_list->RowCnt ?>_journal_to_account" class="journal_to_account">
<span<?php echo $journal->to_account->viewAttributes() ?>>
<?php echo $journal->to_account->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($journal->from_account->Visible) { // from_account ?>
		<td data-name="from_account"<?php echo $journal->from_account->cellAttributes() ?>>
<span id="el<?php echo $journal_list->RowCnt ?>_journal_from_account" class="journal_from_account">
<span<?php echo $journal->from_account->viewAttributes() ?>>
<?php echo $journal->from_account->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($journal->reference->Visible) { // reference ?>
		<td data-name="reference"<?php echo $journal->reference->cellAttributes() ?>>
<span id="el<?php echo $journal_list->RowCnt ?>_journal_reference" class="journal_reference">
<span<?php echo $journal->reference->viewAttributes() ?>>
<?php echo $journal->reference->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($journal->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $journal->dated->cellAttributes() ?>>
<span id="el<?php echo $journal_list->RowCnt ?>_journal_dated" class="journal_dated">
<span<?php echo $journal->dated->viewAttributes() ?>>
<?php echo $journal->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($journal->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $journal->amount->cellAttributes() ?>>
<span id="el<?php echo $journal_list->RowCnt ?>_journal_amount" class="journal_amount">
<span<?php echo $journal->amount->viewAttributes() ?>>
<?php echo $journal->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($journal->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $journal->remarks->cellAttributes() ?>>
<span id="el<?php echo $journal_list->RowCnt ?>_journal_remarks" class="journal_remarks">
<span<?php echo $journal->remarks->viewAttributes() ?>>
<?php echo $journal->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($journal->uploads->Visible) { // uploads ?>
		<td data-name="uploads"<?php echo $journal->uploads->cellAttributes() ?>>
<span id="el<?php echo $journal_list->RowCnt ?>_journal_uploads" class="journal_uploads">
<span>
<?php echo GetFileViewTag($journal->uploads, $journal->uploads->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($journal->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $journal->operator->cellAttributes() ?>>
<span id="el<?php echo $journal_list->RowCnt ?>_journal_operator" class="journal_operator">
<span<?php echo $journal->operator->viewAttributes() ?>>
<?php echo $journal->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($journal->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $journal->datetime->cellAttributes() ?>>
<span id="el<?php echo $journal_list->RowCnt ?>_journal_datetime" class="journal_datetime">
<span<?php echo $journal->datetime->viewAttributes() ?>>
<?php echo $journal->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($journal->id->Visible) { // id ?>
		<td data-name="id"<?php echo $journal->id->cellAttributes() ?>>
<span id="el<?php echo $journal_list->RowCnt ?>_journal_id" class="journal_id">
<span<?php echo $journal->id->viewAttributes() ?>>
<?php echo $journal->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$journal_list->ListOptions->render("body", "right", $journal_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$journal->isGridAdd())
		$journal_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$journal->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($journal_list->Recordset)
	$journal_list->Recordset->Close();
?>
<?php if (!$journal->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$journal->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($journal_list->Pager)) $journal_list->Pager = new PrevNextPager($journal_list->StartRec, $journal_list->DisplayRecs, $journal_list->TotalRecs, $journal_list->AutoHidePager) ?>
<?php if ($journal_list->Pager->RecordCount > 0 && $journal_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($journal_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $journal_list->pageUrl() ?>start=<?php echo $journal_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($journal_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $journal_list->pageUrl() ?>start=<?php echo $journal_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $journal_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($journal_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $journal_list->pageUrl() ?>start=<?php echo $journal_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($journal_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $journal_list->pageUrl() ?>start=<?php echo $journal_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $journal_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($journal_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $journal_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $journal_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $journal_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($journal_list->TotalRecs > 0 && (!$journal_list->AutoHidePageSizeSelector || $journal_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="journal">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($journal_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($journal_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($journal_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($journal_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($journal_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($journal->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $journal_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($journal_list->TotalRecs == 0 && !$journal->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $journal_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$journal_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$journal->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$journal->isExport()) { ?>
<script>
ew.scrollableTable("gmp_journal", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$journal_list->terminate();
?>