<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$journal_search = new journal_search();

// Run the page
$journal_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$journal_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($journal_search->IsModal) { ?>
var fjournalsearch = currentAdvancedSearchForm = new ew.Form("fjournalsearch", "search");
<?php } else { ?>
var fjournalsearch = currentForm = new ew.Form("fjournalsearch", "search");
<?php } ?>

// Form_CustomValidate event
fjournalsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjournalsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjournalsearch.lists["x_to_account"] = <?php echo $journal_search->to_account->Lookup->toClientList() ?>;
fjournalsearch.lists["x_to_account"].options = <?php echo JsonEncode($journal_search->to_account->lookupOptions()) ?>;
fjournalsearch.autoSuggests["x_to_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fjournalsearch.lists["x_from_account"] = <?php echo $journal_search->from_account->Lookup->toClientList() ?>;
fjournalsearch.lists["x_from_account"].options = <?php echo JsonEncode($journal_search->from_account->lookupOptions()) ?>;
fjournalsearch.autoSuggests["x_from_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fjournalsearch.lists["x_operator"] = <?php echo $journal_search->operator->Lookup->toClientList() ?>;
fjournalsearch.lists["x_operator"].options = <?php echo JsonEncode($journal_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fjournalsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($journal->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($journal->amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($journal->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($journal->id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $journal_search->showPageHeader(); ?>
<?php
$journal_search->showMessage();
?>
<form name="fjournalsearch" id="fjournalsearch" class="<?php echo $journal_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($journal_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $journal_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="journal">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$journal_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($journal->to_account->Visible) { // to_account ?>
	<div id="r_to_account" class="form-group row">
		<label class="<?php echo $journal_search->LeftColumnClass ?>"><span id="elh_journal_to_account"><?php echo $journal->to_account->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_to_account" id="z_to_account" value="="></span>
		</label>
		<div class="<?php echo $journal_search->RightColumnClass ?>"><div<?php echo $journal->to_account->cellAttributes() ?>>
			<span id="el_journal_to_account">
<?php
$wrkonchange = "" . trim(@$journal->to_account->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$journal->to_account->EditAttrs["onchange"] = "";
?>
<span id="as_x_to_account" class="text-nowrap" style="z-index: 8990">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_to_account" id="sv_x_to_account" value="<?php echo RemoveHtml($journal->to_account->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($journal->to_account->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($journal->to_account->getPlaceHolder()) ?>"<?php echo $journal->to_account->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($journal->to_account->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_to_account',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($journal->to_account->ReadOnly || $journal->to_account->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="journal" data-field="x_to_account" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $journal->to_account->displayValueSeparatorAttribute() ?>" name="x_to_account" id="x_to_account" value="<?php echo HtmlEncode($journal->to_account->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fjournalsearch.createAutoSuggest({"id":"x_to_account","forceSelect":false});
</script>
<?php echo $journal->to_account->Lookup->getParamTag("p_x_to_account") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($journal->from_account->Visible) { // from_account ?>
	<div id="r_from_account" class="form-group row">
		<label class="<?php echo $journal_search->LeftColumnClass ?>"><span id="elh_journal_from_account"><?php echo $journal->from_account->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_from_account" id="z_from_account" value="="></span>
		</label>
		<div class="<?php echo $journal_search->RightColumnClass ?>"><div<?php echo $journal->from_account->cellAttributes() ?>>
			<span id="el_journal_from_account">
<?php
$wrkonchange = "" . trim(@$journal->from_account->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$journal->from_account->EditAttrs["onchange"] = "";
?>
<span id="as_x_from_account" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_from_account" id="sv_x_from_account" value="<?php echo RemoveHtml($journal->from_account->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($journal->from_account->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($journal->from_account->getPlaceHolder()) ?>"<?php echo $journal->from_account->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($journal->from_account->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_from_account',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($journal->from_account->ReadOnly || $journal->from_account->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="journal" data-field="x_from_account" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $journal->from_account->displayValueSeparatorAttribute() ?>" name="x_from_account" id="x_from_account" value="<?php echo HtmlEncode($journal->from_account->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fjournalsearch.createAutoSuggest({"id":"x_from_account","forceSelect":false});
</script>
<?php echo $journal->from_account->Lookup->getParamTag("p_x_from_account") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($journal->reference->Visible) { // reference ?>
	<div id="r_reference" class="form-group row">
		<label for="x_reference" class="<?php echo $journal_search->LeftColumnClass ?>"><span id="elh_journal_reference"><?php echo $journal->reference->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_reference" id="z_reference" value="LIKE"></span>
		</label>
		<div class="<?php echo $journal_search->RightColumnClass ?>"><div<?php echo $journal->reference->cellAttributes() ?>>
			<span id="el_journal_reference">
<input type="text" data-table="journal" data-field="x_reference" name="x_reference" id="x_reference" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($journal->reference->getPlaceHolder()) ?>" value="<?php echo $journal->reference->EditValue ?>"<?php echo $journal->reference->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($journal->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $journal_search->LeftColumnClass ?>"><span id="elh_journal_dated"><?php echo $journal->dated->caption() ?></span>
		</label>
		<div class="<?php echo $journal_search->RightColumnClass ?>"><div<?php echo $journal->dated->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($journal->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($journal->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($journal->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($journal->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($journal->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($journal->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($journal->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_journal_dated">
<input type="text" data-table="journal" data-field="x_dated" data-format="2" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($journal->dated->getPlaceHolder()) ?>" value="<?php echo $journal->dated->EditValue ?>"<?php echo $journal->dated->editAttributes() ?>>
<?php if (!$journal->dated->ReadOnly && !$journal->dated->Disabled && !isset($journal->dated->EditAttrs["readonly"]) && !isset($journal->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fjournalsearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_dated d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_journal_dated" class="btw1_dated d-none">
<input type="text" data-table="journal" data-field="x_dated" data-format="2" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($journal->dated->getPlaceHolder()) ?>" value="<?php echo $journal->dated->EditValue2 ?>"<?php echo $journal->dated->editAttributes() ?>>
<?php if (!$journal->dated->ReadOnly && !$journal->dated->Disabled && !isset($journal->dated->EditAttrs["readonly"]) && !isset($journal->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fjournalsearch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($journal->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $journal_search->LeftColumnClass ?>"><span id="elh_journal_amount"><?php echo $journal->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $journal_search->RightColumnClass ?>"><div<?php echo $journal->amount->cellAttributes() ?>>
			<span id="el_journal_amount">
<input type="text" data-table="journal" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($journal->amount->getPlaceHolder()) ?>" value="<?php echo $journal->amount->EditValue ?>"<?php echo $journal->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($journal->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $journal_search->LeftColumnClass ?>"><span id="elh_journal_remarks"><?php echo $journal->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $journal_search->RightColumnClass ?>"><div<?php echo $journal->remarks->cellAttributes() ?>>
			<span id="el_journal_remarks">
<input type="text" data-table="journal" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($journal->remarks->getPlaceHolder()) ?>" value="<?php echo $journal->remarks->EditValue ?>"<?php echo $journal->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($journal->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label class="<?php echo $journal_search->LeftColumnClass ?>"><span id="elh_journal_uploads"><?php echo $journal->uploads->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_uploads" id="z_uploads" value="LIKE"></span>
		</label>
		<div class="<?php echo $journal_search->RightColumnClass ?>"><div<?php echo $journal->uploads->cellAttributes() ?>>
			<span id="el_journal_uploads">
<input type="text" data-table="journal" data-field="x_uploads" name="x_uploads" id="x_uploads" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($journal->uploads->getPlaceHolder()) ?>" value="<?php echo $journal->uploads->EditValue ?>"<?php echo $journal->uploads->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($journal->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $journal_search->LeftColumnClass ?>"><span id="elh_journal_operator"><?php echo $journal->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $journal_search->RightColumnClass ?>"><div<?php echo $journal->operator->cellAttributes() ?>>
			<span id="el_journal_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="journal" data-field="x_operator" data-value-separator="<?php echo $journal->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $journal->operator->editAttributes() ?>>
		<?php echo $journal->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $journal->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($journal->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $journal_search->LeftColumnClass ?>"><span id="elh_journal_datetime"><?php echo $journal->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $journal_search->RightColumnClass ?>"><div<?php echo $journal->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($journal->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($journal->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($journal->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($journal->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($journal->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($journal->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($journal->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_journal_datetime">
<input type="text" data-table="journal" data-field="x_datetime" data-format="2" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($journal->datetime->getPlaceHolder()) ?>" value="<?php echo $journal->datetime->EditValue ?>"<?php echo $journal->datetime->editAttributes() ?>>
<?php if (!$journal->datetime->ReadOnly && !$journal->datetime->Disabled && !isset($journal->datetime->EditAttrs["readonly"]) && !isset($journal->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fjournalsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_journal_datetime" class="btw1_datetime d-none">
<input type="text" data-table="journal" data-field="x_datetime" data-format="2" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($journal->datetime->getPlaceHolder()) ?>" value="<?php echo $journal->datetime->EditValue2 ?>"<?php echo $journal->datetime->editAttributes() ?>>
<?php if (!$journal->datetime->ReadOnly && !$journal->datetime->Disabled && !isset($journal->datetime->EditAttrs["readonly"]) && !isset($journal->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fjournalsearch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($journal->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $journal_search->LeftColumnClass ?>"><span id="elh_journal_id"><?php echo $journal->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $journal_search->RightColumnClass ?>"><div<?php echo $journal->id->cellAttributes() ?>>
			<span id="el_journal_id">
<input type="text" data-table="journal" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($journal->id->getPlaceHolder()) ?>" value="<?php echo $journal->id->EditValue ?>"<?php echo $journal->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$journal_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $journal_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$journal_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$journal_search->terminate();
?>