<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$journal_view = new journal_view();

// Run the page
$journal_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$journal_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$journal->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fjournalview = currentForm = new ew.Form("fjournalview", "view");

// Form_CustomValidate event
fjournalview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjournalview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjournalview.lists["x_to_account"] = <?php echo $journal_view->to_account->Lookup->toClientList() ?>;
fjournalview.lists["x_to_account"].options = <?php echo JsonEncode($journal_view->to_account->lookupOptions()) ?>;
fjournalview.autoSuggests["x_to_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fjournalview.lists["x_from_account"] = <?php echo $journal_view->from_account->Lookup->toClientList() ?>;
fjournalview.lists["x_from_account"].options = <?php echo JsonEncode($journal_view->from_account->lookupOptions()) ?>;
fjournalview.autoSuggests["x_from_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fjournalview.lists["x_operator"] = <?php echo $journal_view->operator->Lookup->toClientList() ?>;
fjournalview.lists["x_operator"].options = <?php echo JsonEncode($journal_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$journal->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $journal_view->ExportOptions->render("body") ?>
<?php $journal_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $journal_view->showPageHeader(); ?>
<?php
$journal_view->showMessage();
?>
<form name="fjournalview" id="fjournalview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($journal_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $journal_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="journal">
<input type="hidden" name="modal" value="<?php echo (int)$journal_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($journal->to_account->Visible) { // to_account ?>
	<tr id="r_to_account">
		<td class="<?php echo $journal_view->TableLeftColumnClass ?>"><span id="elh_journal_to_account"><?php echo $journal->to_account->caption() ?></span></td>
		<td data-name="to_account"<?php echo $journal->to_account->cellAttributes() ?>>
<span id="el_journal_to_account">
<span<?php echo $journal->to_account->viewAttributes() ?>>
<?php echo $journal->to_account->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($journal->from_account->Visible) { // from_account ?>
	<tr id="r_from_account">
		<td class="<?php echo $journal_view->TableLeftColumnClass ?>"><span id="elh_journal_from_account"><?php echo $journal->from_account->caption() ?></span></td>
		<td data-name="from_account"<?php echo $journal->from_account->cellAttributes() ?>>
<span id="el_journal_from_account">
<span<?php echo $journal->from_account->viewAttributes() ?>>
<?php echo $journal->from_account->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($journal->reference->Visible) { // reference ?>
	<tr id="r_reference">
		<td class="<?php echo $journal_view->TableLeftColumnClass ?>"><span id="elh_journal_reference"><?php echo $journal->reference->caption() ?></span></td>
		<td data-name="reference"<?php echo $journal->reference->cellAttributes() ?>>
<span id="el_journal_reference">
<span<?php echo $journal->reference->viewAttributes() ?>>
<?php echo $journal->reference->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($journal->dated->Visible) { // dated ?>
	<tr id="r_dated">
		<td class="<?php echo $journal_view->TableLeftColumnClass ?>"><span id="elh_journal_dated"><?php echo $journal->dated->caption() ?></span></td>
		<td data-name="dated"<?php echo $journal->dated->cellAttributes() ?>>
<span id="el_journal_dated">
<span<?php echo $journal->dated->viewAttributes() ?>>
<?php echo $journal->dated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($journal->amount->Visible) { // amount ?>
	<tr id="r_amount">
		<td class="<?php echo $journal_view->TableLeftColumnClass ?>"><span id="elh_journal_amount"><?php echo $journal->amount->caption() ?></span></td>
		<td data-name="amount"<?php echo $journal->amount->cellAttributes() ?>>
<span id="el_journal_amount">
<span<?php echo $journal->amount->viewAttributes() ?>>
<?php echo $journal->amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($journal->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $journal_view->TableLeftColumnClass ?>"><span id="elh_journal_remarks"><?php echo $journal->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $journal->remarks->cellAttributes() ?>>
<span id="el_journal_remarks">
<span<?php echo $journal->remarks->viewAttributes() ?>>
<?php echo $journal->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($journal->uploads->Visible) { // uploads ?>
	<tr id="r_uploads">
		<td class="<?php echo $journal_view->TableLeftColumnClass ?>"><span id="elh_journal_uploads"><?php echo $journal->uploads->caption() ?></span></td>
		<td data-name="uploads"<?php echo $journal->uploads->cellAttributes() ?>>
<span id="el_journal_uploads">
<span>
<?php echo GetFileViewTag($journal->uploads, $journal->uploads->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($journal->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $journal_view->TableLeftColumnClass ?>"><span id="elh_journal_operator"><?php echo $journal->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $journal->operator->cellAttributes() ?>>
<span id="el_journal_operator">
<span<?php echo $journal->operator->viewAttributes() ?>>
<?php echo $journal->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($journal->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $journal_view->TableLeftColumnClass ?>"><span id="elh_journal_datetime"><?php echo $journal->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $journal->datetime->cellAttributes() ?>>
<span id="el_journal_datetime">
<span<?php echo $journal->datetime->viewAttributes() ?>>
<?php echo $journal->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($journal->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $journal_view->TableLeftColumnClass ?>"><span id="elh_journal_id"><?php echo $journal->id->caption() ?></span></td>
		<td data-name="id"<?php echo $journal->id->cellAttributes() ?>>
<span id="el_journal_id">
<span<?php echo $journal->id->viewAttributes() ?>>
<?php echo $journal->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$journal_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$journal->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$journal_view->terminate();
?>