<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$l_examination_type_list = new l_examination_type_list();

// Run the page
$l_examination_type_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$l_examination_type_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$l_examination_type->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fl_examination_typelist = currentForm = new ew.Form("fl_examination_typelist", "list");
fl_examination_typelist.formKeyCountName = '<?php echo $l_examination_type_list->FormKeyCountName ?>';

// Form_CustomValidate event
fl_examination_typelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fl_examination_typelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fl_examination_typelist.lists["x_grp"] = <?php echo $l_examination_type_list->grp->Lookup->toClientList() ?>;
fl_examination_typelist.lists["x_grp"].options = <?php echo JsonEncode($l_examination_type_list->grp->lookupOptions()) ?>;
fl_examination_typelist.lists["x_report_grp"] = <?php echo $l_examination_type_list->report_grp->Lookup->toClientList() ?>;
fl_examination_typelist.lists["x_report_grp"].options = <?php echo JsonEncode($l_examination_type_list->report_grp->lookupOptions()) ?>;
fl_examination_typelist.lists["x_status"] = <?php echo $l_examination_type_list->status->Lookup->toClientList() ?>;
fl_examination_typelist.lists["x_status"].options = <?php echo JsonEncode($l_examination_type_list->status->options(FALSE, TRUE)) ?>;

// Form object for search
var fl_examination_typelistsrch = currentSearchForm = new ew.Form("fl_examination_typelistsrch");

// Filters
fl_examination_typelistsrch.filterList = <?php echo $l_examination_type_list->getFilterList() ?>;

// Init search panel as collapsed
fl_examination_typelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$l_examination_type->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($l_examination_type_list->TotalRecs > 0 && $l_examination_type_list->ExportOptions->visible()) { ?>
<?php $l_examination_type_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($l_examination_type_list->ImportOptions->visible()) { ?>
<?php $l_examination_type_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($l_examination_type_list->SearchOptions->visible()) { ?>
<?php $l_examination_type_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($l_examination_type_list->FilterOptions->visible()) { ?>
<?php $l_examination_type_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$l_examination_type_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$l_examination_type->isExport() && !$l_examination_type->CurrentAction) { ?>
<form name="fl_examination_typelistsrch" id="fl_examination_typelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($l_examination_type_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fl_examination_typelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="l_examination_type">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($l_examination_type_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($l_examination_type_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $l_examination_type_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($l_examination_type_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($l_examination_type_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($l_examination_type_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($l_examination_type_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $l_examination_type_list->showPageHeader(); ?>
<?php
$l_examination_type_list->showMessage();
?>
<?php if ($l_examination_type_list->TotalRecs > 0 || $l_examination_type->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($l_examination_type_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> l_examination_type">
<?php if (!$l_examination_type->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$l_examination_type->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($l_examination_type_list->Pager)) $l_examination_type_list->Pager = new PrevNextPager($l_examination_type_list->StartRec, $l_examination_type_list->DisplayRecs, $l_examination_type_list->TotalRecs, $l_examination_type_list->AutoHidePager) ?>
<?php if ($l_examination_type_list->Pager->RecordCount > 0 && $l_examination_type_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($l_examination_type_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $l_examination_type_list->pageUrl() ?>start=<?php echo $l_examination_type_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($l_examination_type_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $l_examination_type_list->pageUrl() ?>start=<?php echo $l_examination_type_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $l_examination_type_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($l_examination_type_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $l_examination_type_list->pageUrl() ?>start=<?php echo $l_examination_type_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($l_examination_type_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $l_examination_type_list->pageUrl() ?>start=<?php echo $l_examination_type_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $l_examination_type_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($l_examination_type_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $l_examination_type_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $l_examination_type_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $l_examination_type_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($l_examination_type_list->TotalRecs > 0 && (!$l_examination_type_list->AutoHidePageSizeSelector || $l_examination_type_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="l_examination_type">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($l_examination_type_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($l_examination_type_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($l_examination_type_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($l_examination_type_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($l_examination_type_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($l_examination_type->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $l_examination_type_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fl_examination_typelist" id="fl_examination_typelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($l_examination_type_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $l_examination_type_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="l_examination_type">
<div id="gmp_l_examination_type" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($l_examination_type_list->TotalRecs > 0 || $l_examination_type->isGridEdit()) { ?>
<table id="tbl_l_examination_typelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$l_examination_type_list->RowType = ROWTYPE_HEADER;

// Render list options
$l_examination_type_list->renderListOptions();

// Render list options (header, left)
$l_examination_type_list->ListOptions->render("header", "left");
?>
<?php if ($l_examination_type->id->Visible) { // id ?>
	<?php if ($l_examination_type->sortUrl($l_examination_type->id) == "") { ?>
		<th data-name="id" class="<?php echo $l_examination_type->id->headerCellClass() ?>"><div id="elh_l_examination_type_id" class="l_examination_type_id"><div class="ew-table-header-caption"><?php echo $l_examination_type->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $l_examination_type->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination_type->SortUrl($l_examination_type->id) ?>',2);"><div id="elh_l_examination_type_id" class="l_examination_type_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination_type->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_examination_type->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination_type->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination_type->grp->Visible) { // grp ?>
	<?php if ($l_examination_type->sortUrl($l_examination_type->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $l_examination_type->grp->headerCellClass() ?>"><div id="elh_l_examination_type_grp" class="l_examination_type_grp"><div class="ew-table-header-caption"><?php echo $l_examination_type->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $l_examination_type->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination_type->SortUrl($l_examination_type->grp) ?>',2);"><div id="elh_l_examination_type_grp" class="l_examination_type_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination_type->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_examination_type->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination_type->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination_type->report_grp->Visible) { // report_grp ?>
	<?php if ($l_examination_type->sortUrl($l_examination_type->report_grp) == "") { ?>
		<th data-name="report_grp" class="<?php echo $l_examination_type->report_grp->headerCellClass() ?>"><div id="elh_l_examination_type_report_grp" class="l_examination_type_report_grp"><div class="ew-table-header-caption"><?php echo $l_examination_type->report_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="report_grp" class="<?php echo $l_examination_type->report_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination_type->SortUrl($l_examination_type->report_grp) ?>',2);"><div id="elh_l_examination_type_report_grp" class="l_examination_type_report_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination_type->report_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_examination_type->report_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination_type->report_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination_type->name->Visible) { // name ?>
	<?php if ($l_examination_type->sortUrl($l_examination_type->name) == "") { ?>
		<th data-name="name" class="<?php echo $l_examination_type->name->headerCellClass() ?>"><div id="elh_l_examination_type_name" class="l_examination_type_name"><div class="ew-table-header-caption"><?php echo $l_examination_type->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $l_examination_type->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination_type->SortUrl($l_examination_type->name) ?>',2);"><div id="elh_l_examination_type_name" class="l_examination_type_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination_type->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($l_examination_type->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination_type->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination_type->price->Visible) { // price ?>
	<?php if ($l_examination_type->sortUrl($l_examination_type->price) == "") { ?>
		<th data-name="price" class="<?php echo $l_examination_type->price->headerCellClass() ?>"><div id="elh_l_examination_type_price" class="l_examination_type_price"><div class="ew-table-header-caption"><?php echo $l_examination_type->price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price" class="<?php echo $l_examination_type->price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination_type->SortUrl($l_examination_type->price) ?>',2);"><div id="elh_l_examination_type_price" class="l_examination_type_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination_type->price->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_examination_type->price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination_type->price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination_type->max_discount->Visible) { // max_discount ?>
	<?php if ($l_examination_type->sortUrl($l_examination_type->max_discount) == "") { ?>
		<th data-name="max_discount" class="<?php echo $l_examination_type->max_discount->headerCellClass() ?>"><div id="elh_l_examination_type_max_discount" class="l_examination_type_max_discount"><div class="ew-table-header-caption"><?php echo $l_examination_type->max_discount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="max_discount" class="<?php echo $l_examination_type->max_discount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination_type->SortUrl($l_examination_type->max_discount) ?>',2);"><div id="elh_l_examination_type_max_discount" class="l_examination_type_max_discount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination_type->max_discount->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_examination_type->max_discount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination_type->max_discount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination_type->code->Visible) { // code ?>
	<?php if ($l_examination_type->sortUrl($l_examination_type->code) == "") { ?>
		<th data-name="code" class="<?php echo $l_examination_type->code->headerCellClass() ?>"><div id="elh_l_examination_type_code" class="l_examination_type_code"><div class="ew-table-header-caption"><?php echo $l_examination_type->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $l_examination_type->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination_type->SortUrl($l_examination_type->code) ?>',2);"><div id="elh_l_examination_type_code" class="l_examination_type_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination_type->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($l_examination_type->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination_type->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination_type->standard_min->Visible) { // standard_min ?>
	<?php if ($l_examination_type->sortUrl($l_examination_type->standard_min) == "") { ?>
		<th data-name="standard_min" class="<?php echo $l_examination_type->standard_min->headerCellClass() ?>"><div id="elh_l_examination_type_standard_min" class="l_examination_type_standard_min"><div class="ew-table-header-caption"><?php echo $l_examination_type->standard_min->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="standard_min" class="<?php echo $l_examination_type->standard_min->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination_type->SortUrl($l_examination_type->standard_min) ?>',2);"><div id="elh_l_examination_type_standard_min" class="l_examination_type_standard_min">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination_type->standard_min->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($l_examination_type->standard_min->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination_type->standard_min->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination_type->standard_max->Visible) { // standard_max ?>
	<?php if ($l_examination_type->sortUrl($l_examination_type->standard_max) == "") { ?>
		<th data-name="standard_max" class="<?php echo $l_examination_type->standard_max->headerCellClass() ?>"><div id="elh_l_examination_type_standard_max" class="l_examination_type_standard_max"><div class="ew-table-header-caption"><?php echo $l_examination_type->standard_max->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="standard_max" class="<?php echo $l_examination_type->standard_max->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination_type->SortUrl($l_examination_type->standard_max) ?>',2);"><div id="elh_l_examination_type_standard_max" class="l_examination_type_standard_max">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination_type->standard_max->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_examination_type->standard_max->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination_type->standard_max->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination_type->standard_unit->Visible) { // standard_unit ?>
	<?php if ($l_examination_type->sortUrl($l_examination_type->standard_unit) == "") { ?>
		<th data-name="standard_unit" class="<?php echo $l_examination_type->standard_unit->headerCellClass() ?>"><div id="elh_l_examination_type_standard_unit" class="l_examination_type_standard_unit"><div class="ew-table-header-caption"><?php echo $l_examination_type->standard_unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="standard_unit" class="<?php echo $l_examination_type->standard_unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination_type->SortUrl($l_examination_type->standard_unit) ?>',2);"><div id="elh_l_examination_type_standard_unit" class="l_examination_type_standard_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination_type->standard_unit->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($l_examination_type->standard_unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination_type->standard_unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination_type->process_time_hours->Visible) { // process_time_hours ?>
	<?php if ($l_examination_type->sortUrl($l_examination_type->process_time_hours) == "") { ?>
		<th data-name="process_time_hours" class="<?php echo $l_examination_type->process_time_hours->headerCellClass() ?>"><div id="elh_l_examination_type_process_time_hours" class="l_examination_type_process_time_hours"><div class="ew-table-header-caption"><?php echo $l_examination_type->process_time_hours->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_time_hours" class="<?php echo $l_examination_type->process_time_hours->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination_type->SortUrl($l_examination_type->process_time_hours) ?>',2);"><div id="elh_l_examination_type_process_time_hours" class="l_examination_type_process_time_hours">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination_type->process_time_hours->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_examination_type->process_time_hours->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination_type->process_time_hours->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination_type->status->Visible) { // status ?>
	<?php if ($l_examination_type->sortUrl($l_examination_type->status) == "") { ?>
		<th data-name="status" class="<?php echo $l_examination_type->status->headerCellClass() ?>"><div id="elh_l_examination_type_status" class="l_examination_type_status"><div class="ew-table-header-caption"><?php echo $l_examination_type->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $l_examination_type->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination_type->SortUrl($l_examination_type->status) ?>',2);"><div id="elh_l_examination_type_status" class="l_examination_type_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination_type->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_examination_type->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination_type->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination_type->operator->Visible) { // operator ?>
	<?php if ($l_examination_type->sortUrl($l_examination_type->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $l_examination_type->operator->headerCellClass() ?>"><div id="elh_l_examination_type_operator" class="l_examination_type_operator"><div class="ew-table-header-caption"><?php echo $l_examination_type->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $l_examination_type->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination_type->SortUrl($l_examination_type->operator) ?>',2);"><div id="elh_l_examination_type_operator" class="l_examination_type_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination_type->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_examination_type->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination_type->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination_type->datetime->Visible) { // datetime ?>
	<?php if ($l_examination_type->sortUrl($l_examination_type->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $l_examination_type->datetime->headerCellClass() ?>"><div id="elh_l_examination_type_datetime" class="l_examination_type_datetime"><div class="ew-table-header-caption"><?php echo $l_examination_type->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $l_examination_type->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination_type->SortUrl($l_examination_type->datetime) ?>',2);"><div id="elh_l_examination_type_datetime" class="l_examination_type_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination_type->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_examination_type->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination_type->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$l_examination_type_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($l_examination_type->ExportAll && $l_examination_type->isExport()) {
	$l_examination_type_list->StopRec = $l_examination_type_list->TotalRecs;
} else {

	// Set the last record to display
	if ($l_examination_type_list->TotalRecs > $l_examination_type_list->StartRec + $l_examination_type_list->DisplayRecs - 1)
		$l_examination_type_list->StopRec = $l_examination_type_list->StartRec + $l_examination_type_list->DisplayRecs - 1;
	else
		$l_examination_type_list->StopRec = $l_examination_type_list->TotalRecs;
}
$l_examination_type_list->RecCnt = $l_examination_type_list->StartRec - 1;
if ($l_examination_type_list->Recordset && !$l_examination_type_list->Recordset->EOF) {
	$l_examination_type_list->Recordset->moveFirst();
	$selectLimit = $l_examination_type_list->UseSelectLimit;
	if (!$selectLimit && $l_examination_type_list->StartRec > 1)
		$l_examination_type_list->Recordset->move($l_examination_type_list->StartRec - 1);
} elseif (!$l_examination_type->AllowAddDeleteRow && $l_examination_type_list->StopRec == 0) {
	$l_examination_type_list->StopRec = $l_examination_type->GridAddRowCount;
}

// Initialize aggregate
$l_examination_type->RowType = ROWTYPE_AGGREGATEINIT;
$l_examination_type->resetAttributes();
$l_examination_type_list->renderRow();
while ($l_examination_type_list->RecCnt < $l_examination_type_list->StopRec) {
	$l_examination_type_list->RecCnt++;
	if ($l_examination_type_list->RecCnt >= $l_examination_type_list->StartRec) {
		$l_examination_type_list->RowCnt++;

		// Set up key count
		$l_examination_type_list->KeyCount = $l_examination_type_list->RowIndex;

		// Init row class and style
		$l_examination_type->resetAttributes();
		$l_examination_type->CssClass = "";
		if ($l_examination_type->isGridAdd()) {
		} else {
			$l_examination_type_list->loadRowValues($l_examination_type_list->Recordset); // Load row values
		}
		$l_examination_type->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$l_examination_type->RowAttrs = array_merge($l_examination_type->RowAttrs, array('data-rowindex'=>$l_examination_type_list->RowCnt, 'id'=>'r' . $l_examination_type_list->RowCnt . '_l_examination_type', 'data-rowtype'=>$l_examination_type->RowType));

		// Render row
		$l_examination_type_list->renderRow();

		// Render list options
		$l_examination_type_list->renderListOptions();
?>
	<tr<?php echo $l_examination_type->rowAttributes() ?>>
<?php

// Render list options (body, left)
$l_examination_type_list->ListOptions->render("body", "left", $l_examination_type_list->RowCnt);
?>
	<?php if ($l_examination_type->id->Visible) { // id ?>
		<td data-name="id"<?php echo $l_examination_type->id->cellAttributes() ?>>
<span id="el<?php echo $l_examination_type_list->RowCnt ?>_l_examination_type_id" class="l_examination_type_id">
<span<?php echo $l_examination_type->id->viewAttributes() ?>>
<?php echo $l_examination_type->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination_type->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $l_examination_type->grp->cellAttributes() ?>>
<span id="el<?php echo $l_examination_type_list->RowCnt ?>_l_examination_type_grp" class="l_examination_type_grp">
<span<?php echo $l_examination_type->grp->viewAttributes() ?>>
<?php echo $l_examination_type->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination_type->report_grp->Visible) { // report_grp ?>
		<td data-name="report_grp"<?php echo $l_examination_type->report_grp->cellAttributes() ?>>
<span id="el<?php echo $l_examination_type_list->RowCnt ?>_l_examination_type_report_grp" class="l_examination_type_report_grp">
<span<?php echo $l_examination_type->report_grp->viewAttributes() ?>>
<?php echo $l_examination_type->report_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination_type->name->Visible) { // name ?>
		<td data-name="name"<?php echo $l_examination_type->name->cellAttributes() ?>>
<span id="el<?php echo $l_examination_type_list->RowCnt ?>_l_examination_type_name" class="l_examination_type_name">
<span<?php echo $l_examination_type->name->viewAttributes() ?>>
<?php echo $l_examination_type->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination_type->price->Visible) { // price ?>
		<td data-name="price"<?php echo $l_examination_type->price->cellAttributes() ?>>
<span id="el<?php echo $l_examination_type_list->RowCnt ?>_l_examination_type_price" class="l_examination_type_price">
<span<?php echo $l_examination_type->price->viewAttributes() ?>>
<?php echo $l_examination_type->price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination_type->max_discount->Visible) { // max_discount ?>
		<td data-name="max_discount"<?php echo $l_examination_type->max_discount->cellAttributes() ?>>
<span id="el<?php echo $l_examination_type_list->RowCnt ?>_l_examination_type_max_discount" class="l_examination_type_max_discount">
<span<?php echo $l_examination_type->max_discount->viewAttributes() ?>>
<?php echo $l_examination_type->max_discount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination_type->code->Visible) { // code ?>
		<td data-name="code"<?php echo $l_examination_type->code->cellAttributes() ?>>
<span id="el<?php echo $l_examination_type_list->RowCnt ?>_l_examination_type_code" class="l_examination_type_code">
<span<?php echo $l_examination_type->code->viewAttributes() ?>>
<?php echo $l_examination_type->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination_type->standard_min->Visible) { // standard_min ?>
		<td data-name="standard_min"<?php echo $l_examination_type->standard_min->cellAttributes() ?>>
<span id="el<?php echo $l_examination_type_list->RowCnt ?>_l_examination_type_standard_min" class="l_examination_type_standard_min">
<span<?php echo $l_examination_type->standard_min->viewAttributes() ?>>
<?php echo $l_examination_type->standard_min->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination_type->standard_max->Visible) { // standard_max ?>
		<td data-name="standard_max"<?php echo $l_examination_type->standard_max->cellAttributes() ?>>
<span id="el<?php echo $l_examination_type_list->RowCnt ?>_l_examination_type_standard_max" class="l_examination_type_standard_max">
<span<?php echo $l_examination_type->standard_max->viewAttributes() ?>>
<?php echo $l_examination_type->standard_max->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination_type->standard_unit->Visible) { // standard_unit ?>
		<td data-name="standard_unit"<?php echo $l_examination_type->standard_unit->cellAttributes() ?>>
<span id="el<?php echo $l_examination_type_list->RowCnt ?>_l_examination_type_standard_unit" class="l_examination_type_standard_unit">
<span<?php echo $l_examination_type->standard_unit->viewAttributes() ?>>
<?php echo $l_examination_type->standard_unit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination_type->process_time_hours->Visible) { // process_time_hours ?>
		<td data-name="process_time_hours"<?php echo $l_examination_type->process_time_hours->cellAttributes() ?>>
<span id="el<?php echo $l_examination_type_list->RowCnt ?>_l_examination_type_process_time_hours" class="l_examination_type_process_time_hours">
<span<?php echo $l_examination_type->process_time_hours->viewAttributes() ?>>
<?php echo $l_examination_type->process_time_hours->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination_type->status->Visible) { // status ?>
		<td data-name="status"<?php echo $l_examination_type->status->cellAttributes() ?>>
<span id="el<?php echo $l_examination_type_list->RowCnt ?>_l_examination_type_status" class="l_examination_type_status">
<span<?php echo $l_examination_type->status->viewAttributes() ?>>
<?php echo $l_examination_type->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination_type->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $l_examination_type->operator->cellAttributes() ?>>
<span id="el<?php echo $l_examination_type_list->RowCnt ?>_l_examination_type_operator" class="l_examination_type_operator">
<span<?php echo $l_examination_type->operator->viewAttributes() ?>>
<?php echo $l_examination_type->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination_type->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $l_examination_type->datetime->cellAttributes() ?>>
<span id="el<?php echo $l_examination_type_list->RowCnt ?>_l_examination_type_datetime" class="l_examination_type_datetime">
<span<?php echo $l_examination_type->datetime->viewAttributes() ?>>
<?php echo $l_examination_type->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$l_examination_type_list->ListOptions->render("body", "right", $l_examination_type_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$l_examination_type->isGridAdd())
		$l_examination_type_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$l_examination_type->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($l_examination_type_list->Recordset)
	$l_examination_type_list->Recordset->Close();
?>
<?php if (!$l_examination_type->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$l_examination_type->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($l_examination_type_list->Pager)) $l_examination_type_list->Pager = new PrevNextPager($l_examination_type_list->StartRec, $l_examination_type_list->DisplayRecs, $l_examination_type_list->TotalRecs, $l_examination_type_list->AutoHidePager) ?>
<?php if ($l_examination_type_list->Pager->RecordCount > 0 && $l_examination_type_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($l_examination_type_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $l_examination_type_list->pageUrl() ?>start=<?php echo $l_examination_type_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($l_examination_type_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $l_examination_type_list->pageUrl() ?>start=<?php echo $l_examination_type_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $l_examination_type_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($l_examination_type_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $l_examination_type_list->pageUrl() ?>start=<?php echo $l_examination_type_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($l_examination_type_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $l_examination_type_list->pageUrl() ?>start=<?php echo $l_examination_type_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $l_examination_type_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($l_examination_type_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $l_examination_type_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $l_examination_type_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $l_examination_type_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($l_examination_type_list->TotalRecs > 0 && (!$l_examination_type_list->AutoHidePageSizeSelector || $l_examination_type_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="l_examination_type">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($l_examination_type_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($l_examination_type_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($l_examination_type_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($l_examination_type_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($l_examination_type_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($l_examination_type->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $l_examination_type_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($l_examination_type_list->TotalRecs == 0 && !$l_examination_type->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $l_examination_type_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$l_examination_type_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$l_examination_type->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$l_examination_type->isExport()) { ?>
<script>
ew.scrollableTable("gmp_l_examination_type", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$l_examination_type_list->terminate();
?>