<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$l_examination_type_search = new l_examination_type_search();

// Run the page
$l_examination_type_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$l_examination_type_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($l_examination_type_search->IsModal) { ?>
var fl_examination_typesearch = currentAdvancedSearchForm = new ew.Form("fl_examination_typesearch", "search");
<?php } else { ?>
var fl_examination_typesearch = currentForm = new ew.Form("fl_examination_typesearch", "search");
<?php } ?>

// Form_CustomValidate event
fl_examination_typesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fl_examination_typesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fl_examination_typesearch.lists["x_grp"] = <?php echo $l_examination_type_search->grp->Lookup->toClientList() ?>;
fl_examination_typesearch.lists["x_grp"].options = <?php echo JsonEncode($l_examination_type_search->grp->lookupOptions()) ?>;
fl_examination_typesearch.lists["x_report_grp"] = <?php echo $l_examination_type_search->report_grp->Lookup->toClientList() ?>;
fl_examination_typesearch.lists["x_report_grp"].options = <?php echo JsonEncode($l_examination_type_search->report_grp->lookupOptions()) ?>;
fl_examination_typesearch.lists["x_ex_grp[]"] = <?php echo $l_examination_type_search->ex_grp->Lookup->toClientList() ?>;
fl_examination_typesearch.lists["x_ex_grp[]"].options = <?php echo JsonEncode($l_examination_type_search->ex_grp->lookupOptions()) ?>;
fl_examination_typesearch.lists["x_status"] = <?php echo $l_examination_type_search->status->Lookup->toClientList() ?>;
fl_examination_typesearch.lists["x_status"].options = <?php echo JsonEncode($l_examination_type_search->status->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fl_examination_typesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($l_examination_type->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_price");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($l_examination_type->price->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_max_discount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($l_examination_type->max_discount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_standard_max");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($l_examination_type->standard_max->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_process_time_hours");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($l_examination_type->process_time_hours->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($l_examination_type->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($l_examination_type->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $l_examination_type_search->showPageHeader(); ?>
<?php
$l_examination_type_search->showMessage();
?>
<form name="fl_examination_typesearch" id="fl_examination_typesearch" class="<?php echo $l_examination_type_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($l_examination_type_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $l_examination_type_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="l_examination_type">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$l_examination_type_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($l_examination_type->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $l_examination_type_search->LeftColumnClass ?>"><span id="elh_l_examination_type_id"><?php echo $l_examination_type->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $l_examination_type_search->RightColumnClass ?>"><div<?php echo $l_examination_type->id->cellAttributes() ?>>
			<span id="el_l_examination_type_id">
<input type="text" data-table="l_examination_type" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($l_examination_type->id->getPlaceHolder()) ?>" value="<?php echo $l_examination_type->id->EditValue ?>"<?php echo $l_examination_type->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination_type->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $l_examination_type_search->LeftColumnClass ?>"><span id="elh_l_examination_type_grp"><?php echo $l_examination_type->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $l_examination_type_search->RightColumnClass ?>"><div<?php echo $l_examination_type->grp->cellAttributes() ?>>
			<span id="el_l_examination_type_grp">
<?php $l_examination_type->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$l_examination_type->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="l_examination_type" data-field="x_grp" data-value-separator="<?php echo $l_examination_type->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $l_examination_type->grp->editAttributes() ?>>
		<?php echo $l_examination_type->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $l_examination_type->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination_type->report_grp->Visible) { // report_grp ?>
	<div id="r_report_grp" class="form-group row">
		<label for="x_report_grp" class="<?php echo $l_examination_type_search->LeftColumnClass ?>"><span id="elh_l_examination_type_report_grp"><?php echo $l_examination_type->report_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_report_grp" id="z_report_grp" value="="></span>
		</label>
		<div class="<?php echo $l_examination_type_search->RightColumnClass ?>"><div<?php echo $l_examination_type->report_grp->cellAttributes() ?>>
			<span id="el_l_examination_type_report_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="l_examination_type" data-field="x_report_grp" data-value-separator="<?php echo $l_examination_type->report_grp->displayValueSeparatorAttribute() ?>" id="x_report_grp" name="x_report_grp"<?php echo $l_examination_type->report_grp->editAttributes() ?>>
		<?php echo $l_examination_type->report_grp->selectOptionListHtml("x_report_grp") ?>
	</select>
</div>
<?php echo $l_examination_type->report_grp->Lookup->getParamTag("p_x_report_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination_type->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label for="x_name" class="<?php echo $l_examination_type_search->LeftColumnClass ?>"><span id="elh_l_examination_type_name"><?php echo $l_examination_type->name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $l_examination_type_search->RightColumnClass ?>"><div<?php echo $l_examination_type->name->cellAttributes() ?>>
			<span id="el_l_examination_type_name">
<input type="text" data-table="l_examination_type" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($l_examination_type->name->getPlaceHolder()) ?>" value="<?php echo $l_examination_type->name->EditValue ?>"<?php echo $l_examination_type->name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination_type->ex_grp->Visible) { // ex_grp ?>
	<div id="r_ex_grp" class="form-group row">
		<label class="<?php echo $l_examination_type_search->LeftColumnClass ?>"><span id="elh_l_examination_type_ex_grp"><?php echo $l_examination_type->ex_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_ex_grp" id="z_ex_grp" value="LIKE"></span>
		</label>
		<div class="<?php echo $l_examination_type_search->RightColumnClass ?>"><div<?php echo $l_examination_type->ex_grp->cellAttributes() ?>>
			<span id="el_l_examination_type_ex_grp">
<div id="tp_x_ex_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="l_examination_type" data-field="x_ex_grp" data-value-separator="<?php echo $l_examination_type->ex_grp->displayValueSeparatorAttribute() ?>" name="x_ex_grp[]" id="x_ex_grp[]" value="{value}"<?php echo $l_examination_type->ex_grp->editAttributes() ?>></div>
<div id="dsl_x_ex_grp" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $l_examination_type->ex_grp->checkBoxListHtml(FALSE, "x_ex_grp[]") ?>
</div></div>
<?php echo $l_examination_type->ex_grp->Lookup->getParamTag("p_x_ex_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination_type->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label for="x_price" class="<?php echo $l_examination_type_search->LeftColumnClass ?>"><span id="elh_l_examination_type_price"><?php echo $l_examination_type->price->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_price" id="z_price" value="="></span>
		</label>
		<div class="<?php echo $l_examination_type_search->RightColumnClass ?>"><div<?php echo $l_examination_type->price->cellAttributes() ?>>
			<span id="el_l_examination_type_price">
<input type="text" data-table="l_examination_type" data-field="x_price" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($l_examination_type->price->getPlaceHolder()) ?>" value="<?php echo $l_examination_type->price->EditValue ?>"<?php echo $l_examination_type->price->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination_type->max_discount->Visible) { // max_discount ?>
	<div id="r_max_discount" class="form-group row">
		<label for="x_max_discount" class="<?php echo $l_examination_type_search->LeftColumnClass ?>"><span id="elh_l_examination_type_max_discount"><?php echo $l_examination_type->max_discount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_max_discount" id="z_max_discount" value="="></span>
		</label>
		<div class="<?php echo $l_examination_type_search->RightColumnClass ?>"><div<?php echo $l_examination_type->max_discount->cellAttributes() ?>>
			<span id="el_l_examination_type_max_discount">
<input type="text" data-table="l_examination_type" data-field="x_max_discount" name="x_max_discount" id="x_max_discount" size="30" placeholder="<?php echo HtmlEncode($l_examination_type->max_discount->getPlaceHolder()) ?>" value="<?php echo $l_examination_type->max_discount->EditValue ?>"<?php echo $l_examination_type->max_discount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination_type->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label for="x_code" class="<?php echo $l_examination_type_search->LeftColumnClass ?>"><span id="elh_l_examination_type_code"><?php echo $l_examination_type->code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_code" id="z_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $l_examination_type_search->RightColumnClass ?>"><div<?php echo $l_examination_type->code->cellAttributes() ?>>
			<span id="el_l_examination_type_code">
<input type="text" data-table="l_examination_type" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($l_examination_type->code->getPlaceHolder()) ?>" value="<?php echo $l_examination_type->code->EditValue ?>"<?php echo $l_examination_type->code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination_type->standard_min->Visible) { // standard_min ?>
	<div id="r_standard_min" class="form-group row">
		<label for="x_standard_min" class="<?php echo $l_examination_type_search->LeftColumnClass ?>"><span id="elh_l_examination_type_standard_min"><?php echo $l_examination_type->standard_min->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_standard_min" id="z_standard_min" value="LIKE"></span>
		</label>
		<div class="<?php echo $l_examination_type_search->RightColumnClass ?>"><div<?php echo $l_examination_type->standard_min->cellAttributes() ?>>
			<span id="el_l_examination_type_standard_min">
<input type="text" data-table="l_examination_type" data-field="x_standard_min" name="x_standard_min" id="x_standard_min" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($l_examination_type->standard_min->getPlaceHolder()) ?>" value="<?php echo $l_examination_type->standard_min->EditValue ?>"<?php echo $l_examination_type->standard_min->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination_type->standard_max->Visible) { // standard_max ?>
	<div id="r_standard_max" class="form-group row">
		<label for="x_standard_max" class="<?php echo $l_examination_type_search->LeftColumnClass ?>"><span id="elh_l_examination_type_standard_max"><?php echo $l_examination_type->standard_max->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_standard_max" id="z_standard_max" value="="></span>
		</label>
		<div class="<?php echo $l_examination_type_search->RightColumnClass ?>"><div<?php echo $l_examination_type->standard_max->cellAttributes() ?>>
			<span id="el_l_examination_type_standard_max">
<input type="text" data-table="l_examination_type" data-field="x_standard_max" name="x_standard_max" id="x_standard_max" size="30" placeholder="<?php echo HtmlEncode($l_examination_type->standard_max->getPlaceHolder()) ?>" value="<?php echo $l_examination_type->standard_max->EditValue ?>"<?php echo $l_examination_type->standard_max->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination_type->standard_unit->Visible) { // standard_unit ?>
	<div id="r_standard_unit" class="form-group row">
		<label for="x_standard_unit" class="<?php echo $l_examination_type_search->LeftColumnClass ?>"><span id="elh_l_examination_type_standard_unit"><?php echo $l_examination_type->standard_unit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_standard_unit" id="z_standard_unit" value="LIKE"></span>
		</label>
		<div class="<?php echo $l_examination_type_search->RightColumnClass ?>"><div<?php echo $l_examination_type->standard_unit->cellAttributes() ?>>
			<span id="el_l_examination_type_standard_unit">
<input type="text" data-table="l_examination_type" data-field="x_standard_unit" name="x_standard_unit" id="x_standard_unit" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($l_examination_type->standard_unit->getPlaceHolder()) ?>" value="<?php echo $l_examination_type->standard_unit->EditValue ?>"<?php echo $l_examination_type->standard_unit->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination_type->header->Visible) { // header ?>
	<div id="r_header" class="form-group row">
		<label class="<?php echo $l_examination_type_search->LeftColumnClass ?>"><span id="elh_l_examination_type_header"><?php echo $l_examination_type->header->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_header" id="z_header" value="LIKE"></span>
		</label>
		<div class="<?php echo $l_examination_type_search->RightColumnClass ?>"><div<?php echo $l_examination_type->header->cellAttributes() ?>>
			<span id="el_l_examination_type_header">
<input type="text" data-table="l_examination_type" data-field="x_header" name="x_header" id="x_header" size="35" placeholder="<?php echo HtmlEncode($l_examination_type->header->getPlaceHolder()) ?>" value="<?php echo $l_examination_type->header->EditValue ?>"<?php echo $l_examination_type->header->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination_type->footer->Visible) { // footer ?>
	<div id="r_footer" class="form-group row">
		<label class="<?php echo $l_examination_type_search->LeftColumnClass ?>"><span id="elh_l_examination_type_footer"><?php echo $l_examination_type->footer->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_footer" id="z_footer" value="LIKE"></span>
		</label>
		<div class="<?php echo $l_examination_type_search->RightColumnClass ?>"><div<?php echo $l_examination_type->footer->cellAttributes() ?>>
			<span id="el_l_examination_type_footer">
<input type="text" data-table="l_examination_type" data-field="x_footer" name="x_footer" id="x_footer" size="35" placeholder="<?php echo HtmlEncode($l_examination_type->footer->getPlaceHolder()) ?>" value="<?php echo $l_examination_type->footer->EditValue ?>"<?php echo $l_examination_type->footer->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination_type->process_time_hours->Visible) { // process_time_hours ?>
	<div id="r_process_time_hours" class="form-group row">
		<label for="x_process_time_hours" class="<?php echo $l_examination_type_search->LeftColumnClass ?>"><span id="elh_l_examination_type_process_time_hours"><?php echo $l_examination_type->process_time_hours->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process_time_hours" id="z_process_time_hours" value="="></span>
		</label>
		<div class="<?php echo $l_examination_type_search->RightColumnClass ?>"><div<?php echo $l_examination_type->process_time_hours->cellAttributes() ?>>
			<span id="el_l_examination_type_process_time_hours">
<input type="text" data-table="l_examination_type" data-field="x_process_time_hours" name="x_process_time_hours" id="x_process_time_hours" size="30" placeholder="<?php echo HtmlEncode($l_examination_type->process_time_hours->getPlaceHolder()) ?>" value="<?php echo $l_examination_type->process_time_hours->EditValue ?>"<?php echo $l_examination_type->process_time_hours->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination_type->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $l_examination_type_search->LeftColumnClass ?>"><span id="elh_l_examination_type_status"><?php echo $l_examination_type->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $l_examination_type_search->RightColumnClass ?>"><div<?php echo $l_examination_type->status->cellAttributes() ?>>
			<span id="el_l_examination_type_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="l_examination_type" data-field="x_status" data-value-separator="<?php echo $l_examination_type->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $l_examination_type->status->editAttributes() ?>>
		<?php echo $l_examination_type->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination_type->diagnosis_code->Visible) { // diagnosis_code ?>
	<div id="r_diagnosis_code" class="form-group row">
		<label for="x_diagnosis_code" class="<?php echo $l_examination_type_search->LeftColumnClass ?>"><span id="elh_l_examination_type_diagnosis_code"><?php echo $l_examination_type->diagnosis_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_diagnosis_code" id="z_diagnosis_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $l_examination_type_search->RightColumnClass ?>"><div<?php echo $l_examination_type->diagnosis_code->cellAttributes() ?>>
			<span id="el_l_examination_type_diagnosis_code">
<input type="text" data-table="l_examination_type" data-field="x_diagnosis_code" name="x_diagnosis_code" id="x_diagnosis_code" size="35" placeholder="<?php echo HtmlEncode($l_examination_type->diagnosis_code->getPlaceHolder()) ?>" value="<?php echo $l_examination_type->diagnosis_code->EditValue ?>"<?php echo $l_examination_type->diagnosis_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination_type->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $l_examination_type_search->LeftColumnClass ?>"><span id="elh_l_examination_type_operator"><?php echo $l_examination_type->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $l_examination_type_search->RightColumnClass ?>"><div<?php echo $l_examination_type->operator->cellAttributes() ?>>
			<span id="el_l_examination_type_operator">
<input type="text" data-table="l_examination_type" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($l_examination_type->operator->getPlaceHolder()) ?>" value="<?php echo $l_examination_type->operator->EditValue ?>"<?php echo $l_examination_type->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination_type->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $l_examination_type_search->LeftColumnClass ?>"><span id="elh_l_examination_type_datetime"><?php echo $l_examination_type->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $l_examination_type_search->RightColumnClass ?>"><div<?php echo $l_examination_type->datetime->cellAttributes() ?>>
			<span id="el_l_examination_type_datetime">
<input type="text" data-table="l_examination_type" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($l_examination_type->datetime->getPlaceHolder()) ?>" value="<?php echo $l_examination_type->datetime->EditValue ?>"<?php echo $l_examination_type->datetime->editAttributes() ?>>
<?php if (!$l_examination_type->datetime->ReadOnly && !$l_examination_type->datetime->Disabled && !isset($l_examination_type->datetime->EditAttrs["readonly"]) && !isset($l_examination_type->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fl_examination_typesearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$l_examination_type_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $l_examination_type_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$l_examination_type_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$l_examination_type_search->terminate();
?>