<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$l_examination_add = new l_examination_add();

// Run the page
$l_examination_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$l_examination_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fl_examinationadd = currentForm = new ew.Form("fl_examinationadd", "add");

// Validate form
fl_examinationadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($l_examination_add->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_examination->mobile->caption(), $l_examination->mobile->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($l_examination_add->category->Required) { ?>
			elm = this.getElements("x" + infix + "_category");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_examination->category->caption(), $l_examination->category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($l_examination_add->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_examination->name->caption(), $l_examination->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($l_examination_add->age->Required) { ?>
			elm = this.getElements("x" + infix + "_age");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_examination->age->caption(), $l_examination->age->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_age");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($l_examination->age->errorMessage()) ?>");
		<?php if ($l_examination_add->sex->Required) { ?>
			elm = this.getElements("x" + infix + "_sex");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_examination->sex->caption(), $l_examination->sex->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($l_examination_add->referral->Required) { ?>
			elm = this.getElements("x" + infix + "_referral");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_examination->referral->caption(), $l_examination->referral->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_referral");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($l_examination->referral->errorMessage()) ?>");
		<?php if ($l_examination_add->examination_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_examination_grp[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_examination->examination_grp->caption(), $l_examination->examination_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($l_examination_add->examination_type->Required) { ?>
			elm = this.getElements("x" + infix + "_examination_type[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_examination->examination_type->caption(), $l_examination->examination_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($l_examination_add->total_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_total_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_examination->total_amount->caption(), $l_examination->total_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_total_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($l_examination->total_amount->errorMessage()) ?>");
		<?php if ($l_examination_add->discount_percent->Required) { ?>
			elm = this.getElements("x" + infix + "_discount_percent");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_examination->discount_percent->caption(), $l_examination->discount_percent->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_discount_percent");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($l_examination->discount_percent->errorMessage()) ?>");
		<?php if ($l_examination_add->final_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_final_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_examination->final_amount->caption(), $l_examination->final_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_final_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($l_examination->final_amount->errorMessage()) ?>");
		<?php if ($l_examination_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_examination->remarks->caption(), $l_examination->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($l_examination_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_examination->operator->caption(), $l_examination->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($l_examination_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_examination->datetime->caption(), $l_examination->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($l_examination_add->receipt->Required) { ?>
			elm = this.getElements("x" + infix + "_receipt");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_examination->receipt->caption(), $l_examination->receipt->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_receipt");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($l_examination->receipt->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fl_examinationadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fl_examinationadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fl_examinationadd.lists["x_mobile"] = <?php echo $l_examination_add->mobile->Lookup->toClientList() ?>;
fl_examinationadd.lists["x_mobile"].options = <?php echo JsonEncode($l_examination_add->mobile->lookupOptions()) ?>;
fl_examinationadd.autoSuggests["x_mobile"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fl_examinationadd.lists["x_category"] = <?php echo $l_examination_add->category->Lookup->toClientList() ?>;
fl_examinationadd.lists["x_category"].options = <?php echo JsonEncode($l_examination_add->category->options(FALSE, TRUE)) ?>;
fl_examinationadd.lists["x_name"] = <?php echo $l_examination_add->name->Lookup->toClientList() ?>;
fl_examinationadd.lists["x_name"].options = <?php echo JsonEncode($l_examination_add->name->lookupOptions()) ?>;
fl_examinationadd.autoSuggests["x_name"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fl_examinationadd.lists["x_sex"] = <?php echo $l_examination_add->sex->Lookup->toClientList() ?>;
fl_examinationadd.lists["x_sex"].options = <?php echo JsonEncode($l_examination_add->sex->options(FALSE, TRUE)) ?>;
fl_examinationadd.lists["x_referral"] = <?php echo $l_examination_add->referral->Lookup->toClientList() ?>;
fl_examinationadd.lists["x_referral"].options = <?php echo JsonEncode($l_examination_add->referral->lookupOptions()) ?>;
fl_examinationadd.autoSuggests["x_referral"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fl_examinationadd.lists["x_examination_grp[]"] = <?php echo $l_examination_add->examination_grp->Lookup->toClientList() ?>;
fl_examinationadd.lists["x_examination_grp[]"].options = <?php echo JsonEncode($l_examination_add->examination_grp->lookupOptions()) ?>;
fl_examinationadd.lists["x_examination_type[]"] = <?php echo $l_examination_add->examination_type->Lookup->toClientList() ?>;
fl_examinationadd.lists["x_examination_type[]"].options = <?php echo JsonEncode($l_examination_add->examination_type->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $l_examination_add->showPageHeader(); ?>
<?php
$l_examination_add->showMessage();
?>
<form name="fl_examinationadd" id="fl_examinationadd" class="<?php echo $l_examination_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($l_examination_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $l_examination_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="l_examination">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$l_examination_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($l_examination->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label id="elh_l_examination_mobile" class="<?php echo $l_examination_add->LeftColumnClass ?>"><?php echo $l_examination->mobile->caption() ?><?php echo ($l_examination->mobile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $l_examination_add->RightColumnClass ?>"><div<?php echo $l_examination->mobile->cellAttributes() ?>>
<span id="el_l_examination_mobile">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$l_examination->mobile->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$l_examination->mobile->EditAttrs["onchange"] = "";
?>
<span id="as_x_mobile" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_mobile" id="sv_x_mobile" value="<?php echo RemoveHtml($l_examination->mobile->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($l_examination->mobile->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($l_examination->mobile->getPlaceHolder()) ?>"<?php echo $l_examination->mobile->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($l_examination->mobile->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_mobile',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($l_examination->mobile->ReadOnly || $l_examination->mobile->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="l_examination" data-field="x_mobile" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $l_examination->mobile->displayValueSeparatorAttribute() ?>" name="x_mobile" id="x_mobile" value="<?php echo HtmlEncode($l_examination->mobile->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fl_examinationadd.createAutoSuggest({"id":"x_mobile","forceSelect":false});
</script>
<?php echo $l_examination->mobile->Lookup->getParamTag("p_x_mobile") ?>
</span>
<?php echo $l_examination->mobile->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($l_examination->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label id="elh_l_examination_category" for="x_category" class="<?php echo $l_examination_add->LeftColumnClass ?>"><?php echo $l_examination->category->caption() ?><?php echo ($l_examination->category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $l_examination_add->RightColumnClass ?>"><div<?php echo $l_examination->category->cellAttributes() ?>>
<span id="el_l_examination_category">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="l_examination" data-field="x_category" data-value-separator="<?php echo $l_examination->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $l_examination->category->editAttributes() ?>>
		<?php echo $l_examination->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
</span>
<?php echo $l_examination->category->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($l_examination->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label id="elh_l_examination_name" class="<?php echo $l_examination_add->LeftColumnClass ?>"><?php echo $l_examination->name->caption() ?><?php echo ($l_examination->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $l_examination_add->RightColumnClass ?>"><div<?php echo $l_examination->name->cellAttributes() ?>>
<span id="el_l_examination_name">
<?php
$wrkonchange = "" . trim(@$l_examination->name->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$l_examination->name->EditAttrs["onchange"] = "";
?>
<span id="as_x_name" class="text-nowrap" style="z-index: 8950">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_name" id="sv_x_name" value="<?php echo RemoveHtml($l_examination->name->EditValue) ?>" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($l_examination->name->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($l_examination->name->getPlaceHolder()) ?>"<?php echo $l_examination->name->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($l_examination->name->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_name',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($l_examination->name->ReadOnly || $l_examination->name->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="l_examination" data-field="x_name" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $l_examination->name->displayValueSeparatorAttribute() ?>" name="x_name" id="x_name" value="<?php echo HtmlEncode($l_examination->name->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fl_examinationadd.createAutoSuggest({"id":"x_name","forceSelect":false});
</script>
<?php echo $l_examination->name->Lookup->getParamTag("p_x_name") ?>
</span>
<?php echo $l_examination->name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($l_examination->age->Visible) { // age ?>
	<div id="r_age" class="form-group row">
		<label id="elh_l_examination_age" for="x_age" class="<?php echo $l_examination_add->LeftColumnClass ?>"><?php echo $l_examination->age->caption() ?><?php echo ($l_examination->age->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $l_examination_add->RightColumnClass ?>"><div<?php echo $l_examination->age->cellAttributes() ?>>
<span id="el_l_examination_age">
<input type="text" data-table="l_examination" data-field="x_age" name="x_age" id="x_age" size="30" placeholder="<?php echo HtmlEncode($l_examination->age->getPlaceHolder()) ?>" value="<?php echo $l_examination->age->EditValue ?>"<?php echo $l_examination->age->editAttributes() ?>>
</span>
<?php echo $l_examination->age->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($l_examination->sex->Visible) { // sex ?>
	<div id="r_sex" class="form-group row">
		<label id="elh_l_examination_sex" class="<?php echo $l_examination_add->LeftColumnClass ?>"><?php echo $l_examination->sex->caption() ?><?php echo ($l_examination->sex->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $l_examination_add->RightColumnClass ?>"><div<?php echo $l_examination->sex->cellAttributes() ?>>
<span id="el_l_examination_sex">
<div id="tp_x_sex" class="ew-template"><input type="radio" class="form-check-input" data-table="l_examination" data-field="x_sex" data-value-separator="<?php echo $l_examination->sex->displayValueSeparatorAttribute() ?>" name="x_sex" id="x_sex" value="{value}"<?php echo $l_examination->sex->editAttributes() ?>></div>
<div id="dsl_x_sex" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $l_examination->sex->radioButtonListHtml(FALSE, "x_sex") ?>
</div></div>
</span>
<?php echo $l_examination->sex->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($l_examination->referral->Visible) { // referral ?>
	<div id="r_referral" class="form-group row">
		<label id="elh_l_examination_referral" class="<?php echo $l_examination_add->LeftColumnClass ?>"><?php echo $l_examination->referral->caption() ?><?php echo ($l_examination->referral->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $l_examination_add->RightColumnClass ?>"><div<?php echo $l_examination->referral->cellAttributes() ?>>
<span id="el_l_examination_referral">
<?php
$wrkonchange = "" . trim(@$l_examination->referral->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$l_examination->referral->EditAttrs["onchange"] = "";
?>
<span id="as_x_referral" class="text-nowrap" style="z-index: 8920">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_referral" id="sv_x_referral" value="<?php echo RemoveHtml($l_examination->referral->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($l_examination->referral->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($l_examination->referral->getPlaceHolder()) ?>"<?php echo $l_examination->referral->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($l_examination->referral->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_referral',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($l_examination->referral->ReadOnly || $l_examination->referral->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="l_examination" data-field="x_referral" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $l_examination->referral->displayValueSeparatorAttribute() ?>" name="x_referral" id="x_referral" value="<?php echo HtmlEncode($l_examination->referral->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fl_examinationadd.createAutoSuggest({"id":"x_referral","forceSelect":true});
</script>
<?php echo $l_examination->referral->Lookup->getParamTag("p_x_referral") ?>
</span>
<?php echo $l_examination->referral->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($l_examination->examination_grp->Visible) { // examination_grp ?>
	<div id="r_examination_grp" class="form-group row">
		<label id="elh_l_examination_examination_grp" class="<?php echo $l_examination_add->LeftColumnClass ?>"><?php echo $l_examination->examination_grp->caption() ?><?php echo ($l_examination->examination_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $l_examination_add->RightColumnClass ?>"><div<?php echo $l_examination->examination_grp->cellAttributes() ?>>
<span id="el_l_examination_examination_grp">
<?php $l_examination->examination_grp->EditAttrs["onclick"] = "ew.updateOptions.call(this); " . @$l_examination->examination_grp->EditAttrs["onclick"]; ?>
<div id="tp_x_examination_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="l_examination" data-field="x_examination_grp" data-value-separator="<?php echo $l_examination->examination_grp->displayValueSeparatorAttribute() ?>" name="x_examination_grp[]" id="x_examination_grp[]" value="{value}"<?php echo $l_examination->examination_grp->editAttributes() ?>></div>
<div id="dsl_x_examination_grp" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $l_examination->examination_grp->checkBoxListHtml(FALSE, "x_examination_grp[]") ?>
</div></div>
<?php echo $l_examination->examination_grp->Lookup->getParamTag("p_x_examination_grp") ?>
</span>
<?php echo $l_examination->examination_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($l_examination->examination_type->Visible) { // examination_type ?>
	<div id="r_examination_type" class="form-group row">
		<label id="elh_l_examination_examination_type" class="<?php echo $l_examination_add->LeftColumnClass ?>"><?php echo $l_examination->examination_type->caption() ?><?php echo ($l_examination->examination_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $l_examination_add->RightColumnClass ?>"><div<?php echo $l_examination->examination_type->cellAttributes() ?>>
<span id="el_l_examination_examination_type">
<div id="tp_x_examination_type" class="ew-template"><input type="checkbox" class="form-check-input" data-table="l_examination" data-field="x_examination_type" data-value-separator="<?php echo $l_examination->examination_type->displayValueSeparatorAttribute() ?>" name="x_examination_type[]" id="x_examination_type[]" value="{value}"<?php echo $l_examination->examination_type->editAttributes() ?>></div>
<div id="dsl_x_examination_type" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $l_examination->examination_type->checkBoxListHtml(FALSE, "x_examination_type[]") ?>
</div></div>
<?php echo $l_examination->examination_type->Lookup->getParamTag("p_x_examination_type") ?>
</span>
<?php echo $l_examination->examination_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($l_examination->total_amount->Visible) { // total_amount ?>
	<div id="r_total_amount" class="form-group row">
		<label id="elh_l_examination_total_amount" for="x_total_amount" class="<?php echo $l_examination_add->LeftColumnClass ?>"><?php echo $l_examination->total_amount->caption() ?><?php echo ($l_examination->total_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $l_examination_add->RightColumnClass ?>"><div<?php echo $l_examination->total_amount->cellAttributes() ?>>
<span id="el_l_examination_total_amount">
<input type="text" data-table="l_examination" data-field="x_total_amount" name="x_total_amount" id="x_total_amount" size="30" placeholder="<?php echo HtmlEncode($l_examination->total_amount->getPlaceHolder()) ?>" value="<?php echo $l_examination->total_amount->EditValue ?>"<?php echo $l_examination->total_amount->editAttributes() ?>>
</span>
<?php echo $l_examination->total_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($l_examination->discount_percent->Visible) { // discount_percent ?>
	<div id="r_discount_percent" class="form-group row">
		<label id="elh_l_examination_discount_percent" for="x_discount_percent" class="<?php echo $l_examination_add->LeftColumnClass ?>"><?php echo $l_examination->discount_percent->caption() ?><?php echo ($l_examination->discount_percent->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $l_examination_add->RightColumnClass ?>"><div<?php echo $l_examination->discount_percent->cellAttributes() ?>>
<span id="el_l_examination_discount_percent">
<input type="text" data-table="l_examination" data-field="x_discount_percent" name="x_discount_percent" id="x_discount_percent" size="30" placeholder="<?php echo HtmlEncode($l_examination->discount_percent->getPlaceHolder()) ?>" value="<?php echo $l_examination->discount_percent->EditValue ?>"<?php echo $l_examination->discount_percent->editAttributes() ?>>
</span>
<?php echo $l_examination->discount_percent->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($l_examination->final_amount->Visible) { // final_amount ?>
	<div id="r_final_amount" class="form-group row">
		<label id="elh_l_examination_final_amount" for="x_final_amount" class="<?php echo $l_examination_add->LeftColumnClass ?>"><?php echo $l_examination->final_amount->caption() ?><?php echo ($l_examination->final_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $l_examination_add->RightColumnClass ?>"><div<?php echo $l_examination->final_amount->cellAttributes() ?>>
<span id="el_l_examination_final_amount">
<input type="text" data-table="l_examination" data-field="x_final_amount" name="x_final_amount" id="x_final_amount" size="30" placeholder="<?php echo HtmlEncode($l_examination->final_amount->getPlaceHolder()) ?>" value="<?php echo $l_examination->final_amount->EditValue ?>"<?php echo $l_examination->final_amount->editAttributes() ?>>
</span>
<?php echo $l_examination->final_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($l_examination->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_l_examination_remarks" for="x_remarks" class="<?php echo $l_examination_add->LeftColumnClass ?>"><?php echo $l_examination->remarks->caption() ?><?php echo ($l_examination->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $l_examination_add->RightColumnClass ?>"><div<?php echo $l_examination->remarks->cellAttributes() ?>>
<span id="el_l_examination_remarks">
<input type="text" data-table="l_examination" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($l_examination->remarks->getPlaceHolder()) ?>" value="<?php echo $l_examination->remarks->EditValue ?>"<?php echo $l_examination->remarks->editAttributes() ?>>
</span>
<?php echo $l_examination->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($l_examination->receipt->Visible) { // receipt ?>
	<div id="r_receipt" class="form-group row">
		<label id="elh_l_examination_receipt" for="x_receipt" class="<?php echo $l_examination_add->LeftColumnClass ?>"><?php echo $l_examination->receipt->caption() ?><?php echo ($l_examination->receipt->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $l_examination_add->RightColumnClass ?>"><div<?php echo $l_examination->receipt->cellAttributes() ?>>
<span id="el_l_examination_receipt">
<input type="text" data-table="l_examination" data-field="x_receipt" name="x_receipt" id="x_receipt" size="30" placeholder="<?php echo HtmlEncode($l_examination->receipt->getPlaceHolder()) ?>" value="<?php echo $l_examination->receipt->EditValue ?>"<?php echo $l_examination->receipt->editAttributes() ?>>
</span>
<?php echo $l_examination->receipt->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$l_examination_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $l_examination_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $l_examination_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$l_examination_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$l_examination_add->terminate();
?>