<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$l_examination_list = new l_examination_list();

// Run the page
$l_examination_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$l_examination_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$l_examination->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fl_examinationlist = currentForm = new ew.Form("fl_examinationlist", "list");
fl_examinationlist.formKeyCountName = '<?php echo $l_examination_list->FormKeyCountName ?>';

// Form_CustomValidate event
fl_examinationlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fl_examinationlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fl_examinationlist.lists["x_mobile"] = <?php echo $l_examination_list->mobile->Lookup->toClientList() ?>;
fl_examinationlist.lists["x_mobile"].options = <?php echo JsonEncode($l_examination_list->mobile->lookupOptions()) ?>;
fl_examinationlist.autoSuggests["x_mobile"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fl_examinationlist.lists["x_user"] = <?php echo $l_examination_list->user->Lookup->toClientList() ?>;
fl_examinationlist.lists["x_user"].options = <?php echo JsonEncode($l_examination_list->user->lookupOptions()) ?>;
fl_examinationlist.autoSuggests["x_user"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fl_examinationlist.lists["x_category"] = <?php echo $l_examination_list->category->Lookup->toClientList() ?>;
fl_examinationlist.lists["x_category"].options = <?php echo JsonEncode($l_examination_list->category->options(FALSE, TRUE)) ?>;
fl_examinationlist.lists["x_name"] = <?php echo $l_examination_list->name->Lookup->toClientList() ?>;
fl_examinationlist.lists["x_name"].options = <?php echo JsonEncode($l_examination_list->name->lookupOptions()) ?>;
fl_examinationlist.autoSuggests["x_name"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fl_examinationlist.lists["x_sex"] = <?php echo $l_examination_list->sex->Lookup->toClientList() ?>;
fl_examinationlist.lists["x_sex"].options = <?php echo JsonEncode($l_examination_list->sex->options(FALSE, TRUE)) ?>;
fl_examinationlist.lists["x_referral"] = <?php echo $l_examination_list->referral->Lookup->toClientList() ?>;
fl_examinationlist.lists["x_referral"].options = <?php echo JsonEncode($l_examination_list->referral->lookupOptions()) ?>;
fl_examinationlist.autoSuggests["x_referral"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fl_examinationlist.lists["x_examination_grp[]"] = <?php echo $l_examination_list->examination_grp->Lookup->toClientList() ?>;
fl_examinationlist.lists["x_examination_grp[]"].options = <?php echo JsonEncode($l_examination_list->examination_grp->lookupOptions()) ?>;
fl_examinationlist.lists["x_examination_type[]"] = <?php echo $l_examination_list->examination_type->Lookup->toClientList() ?>;
fl_examinationlist.lists["x_examination_type[]"].options = <?php echo JsonEncode($l_examination_list->examination_type->lookupOptions()) ?>;

// Form object for search
var fl_examinationlistsrch = currentSearchForm = new ew.Form("fl_examinationlistsrch");

// Filters
fl_examinationlistsrch.filterList = <?php echo $l_examination_list->getFilterList() ?>;

// Init search panel as collapsed
fl_examinationlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$l_examination->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($l_examination_list->TotalRecs > 0 && $l_examination_list->ExportOptions->visible()) { ?>
<?php $l_examination_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($l_examination_list->ImportOptions->visible()) { ?>
<?php $l_examination_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($l_examination_list->SearchOptions->visible()) { ?>
<?php $l_examination_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($l_examination_list->FilterOptions->visible()) { ?>
<?php $l_examination_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$l_examination_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$l_examination->isExport() && !$l_examination->CurrentAction) { ?>
<form name="fl_examinationlistsrch" id="fl_examinationlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($l_examination_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fl_examinationlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="l_examination">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($l_examination_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($l_examination_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $l_examination_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($l_examination_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($l_examination_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($l_examination_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($l_examination_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $l_examination_list->showPageHeader(); ?>
<?php
$l_examination_list->showMessage();
?>
<?php if ($l_examination_list->TotalRecs > 0 || $l_examination->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($l_examination_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> l_examination">
<?php if (!$l_examination->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$l_examination->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($l_examination_list->Pager)) $l_examination_list->Pager = new PrevNextPager($l_examination_list->StartRec, $l_examination_list->DisplayRecs, $l_examination_list->TotalRecs, $l_examination_list->AutoHidePager) ?>
<?php if ($l_examination_list->Pager->RecordCount > 0 && $l_examination_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($l_examination_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $l_examination_list->pageUrl() ?>start=<?php echo $l_examination_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($l_examination_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $l_examination_list->pageUrl() ?>start=<?php echo $l_examination_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $l_examination_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($l_examination_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $l_examination_list->pageUrl() ?>start=<?php echo $l_examination_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($l_examination_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $l_examination_list->pageUrl() ?>start=<?php echo $l_examination_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $l_examination_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($l_examination_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $l_examination_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $l_examination_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $l_examination_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($l_examination_list->TotalRecs > 0 && (!$l_examination_list->AutoHidePageSizeSelector || $l_examination_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="l_examination">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($l_examination_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($l_examination_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($l_examination_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($l_examination_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($l_examination_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($l_examination->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $l_examination_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fl_examinationlist" id="fl_examinationlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($l_examination_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $l_examination_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="l_examination">
<div id="gmp_l_examination" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($l_examination_list->TotalRecs > 0 || $l_examination->isGridEdit()) { ?>
<table id="tbl_l_examinationlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$l_examination_list->RowType = ROWTYPE_HEADER;

// Render list options
$l_examination_list->renderListOptions();

// Render list options (header, left)
$l_examination_list->ListOptions->render("header", "left");
?>
<?php if ($l_examination->id->Visible) { // id ?>
	<?php if ($l_examination->sortUrl($l_examination->id) == "") { ?>
		<th data-name="id" class="<?php echo $l_examination->id->headerCellClass() ?>"><div id="elh_l_examination_id" class="l_examination_id"><div class="ew-table-header-caption"><?php echo $l_examination->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $l_examination->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination->SortUrl($l_examination->id) ?>',2);"><div id="elh_l_examination_id" class="l_examination_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_examination->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination->mobile->Visible) { // mobile ?>
	<?php if ($l_examination->sortUrl($l_examination->mobile) == "") { ?>
		<th data-name="mobile" class="<?php echo $l_examination->mobile->headerCellClass() ?>"><div id="elh_l_examination_mobile" class="l_examination_mobile"><div class="ew-table-header-caption"><?php echo $l_examination->mobile->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile" class="<?php echo $l_examination->mobile->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination->SortUrl($l_examination->mobile) ?>',2);"><div id="elh_l_examination_mobile" class="l_examination_mobile">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination->mobile->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_examination->mobile->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination->mobile->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination->user->Visible) { // user ?>
	<?php if ($l_examination->sortUrl($l_examination->user) == "") { ?>
		<th data-name="user" class="<?php echo $l_examination->user->headerCellClass() ?>"><div id="elh_l_examination_user" class="l_examination_user"><div class="ew-table-header-caption"><?php echo $l_examination->user->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="user" class="<?php echo $l_examination->user->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination->SortUrl($l_examination->user) ?>',2);"><div id="elh_l_examination_user" class="l_examination_user">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination->user->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_examination->user->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination->user->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination->category->Visible) { // category ?>
	<?php if ($l_examination->sortUrl($l_examination->category) == "") { ?>
		<th data-name="category" class="<?php echo $l_examination->category->headerCellClass() ?>"><div id="elh_l_examination_category" class="l_examination_category"><div class="ew-table-header-caption"><?php echo $l_examination->category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category" class="<?php echo $l_examination->category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination->SortUrl($l_examination->category) ?>',2);"><div id="elh_l_examination_category" class="l_examination_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination->category->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_examination->category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination->category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination->name->Visible) { // name ?>
	<?php if ($l_examination->sortUrl($l_examination->name) == "") { ?>
		<th data-name="name" class="<?php echo $l_examination->name->headerCellClass() ?>"><div id="elh_l_examination_name" class="l_examination_name"><div class="ew-table-header-caption"><?php echo $l_examination->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $l_examination->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination->SortUrl($l_examination->name) ?>',2);"><div id="elh_l_examination_name" class="l_examination_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($l_examination->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination->age->Visible) { // age ?>
	<?php if ($l_examination->sortUrl($l_examination->age) == "") { ?>
		<th data-name="age" class="<?php echo $l_examination->age->headerCellClass() ?>"><div id="elh_l_examination_age" class="l_examination_age"><div class="ew-table-header-caption"><?php echo $l_examination->age->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="age" class="<?php echo $l_examination->age->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination->SortUrl($l_examination->age) ?>',2);"><div id="elh_l_examination_age" class="l_examination_age">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination->age->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_examination->age->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination->age->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination->sex->Visible) { // sex ?>
	<?php if ($l_examination->sortUrl($l_examination->sex) == "") { ?>
		<th data-name="sex" class="<?php echo $l_examination->sex->headerCellClass() ?>"><div id="elh_l_examination_sex" class="l_examination_sex"><div class="ew-table-header-caption"><?php echo $l_examination->sex->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sex" class="<?php echo $l_examination->sex->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination->SortUrl($l_examination->sex) ?>',2);"><div id="elh_l_examination_sex" class="l_examination_sex">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination->sex->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_examination->sex->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination->sex->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination->referral->Visible) { // referral ?>
	<?php if ($l_examination->sortUrl($l_examination->referral) == "") { ?>
		<th data-name="referral" class="<?php echo $l_examination->referral->headerCellClass() ?>"><div id="elh_l_examination_referral" class="l_examination_referral"><div class="ew-table-header-caption"><?php echo $l_examination->referral->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="referral" class="<?php echo $l_examination->referral->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination->SortUrl($l_examination->referral) ?>',2);"><div id="elh_l_examination_referral" class="l_examination_referral">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination->referral->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_examination->referral->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination->referral->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination->examination_grp->Visible) { // examination_grp ?>
	<?php if ($l_examination->sortUrl($l_examination->examination_grp) == "") { ?>
		<th data-name="examination_grp" class="<?php echo $l_examination->examination_grp->headerCellClass() ?>"><div id="elh_l_examination_examination_grp" class="l_examination_examination_grp"><div class="ew-table-header-caption"><?php echo $l_examination->examination_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="examination_grp" class="<?php echo $l_examination->examination_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination->SortUrl($l_examination->examination_grp) ?>',2);"><div id="elh_l_examination_examination_grp" class="l_examination_examination_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination->examination_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_examination->examination_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination->examination_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination->examination_type->Visible) { // examination_type ?>
	<?php if ($l_examination->sortUrl($l_examination->examination_type) == "") { ?>
		<th data-name="examination_type" class="<?php echo $l_examination->examination_type->headerCellClass() ?>"><div id="elh_l_examination_examination_type" class="l_examination_examination_type"><div class="ew-table-header-caption"><?php echo $l_examination->examination_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="examination_type" class="<?php echo $l_examination->examination_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination->SortUrl($l_examination->examination_type) ?>',2);"><div id="elh_l_examination_examination_type" class="l_examination_examination_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination->examination_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_examination->examination_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination->examination_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination->total_amount->Visible) { // total_amount ?>
	<?php if ($l_examination->sortUrl($l_examination->total_amount) == "") { ?>
		<th data-name="total_amount" class="<?php echo $l_examination->total_amount->headerCellClass() ?>"><div id="elh_l_examination_total_amount" class="l_examination_total_amount"><div class="ew-table-header-caption"><?php echo $l_examination->total_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="total_amount" class="<?php echo $l_examination->total_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination->SortUrl($l_examination->total_amount) ?>',2);"><div id="elh_l_examination_total_amount" class="l_examination_total_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination->total_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_examination->total_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination->total_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination->discount_percent->Visible) { // discount_percent ?>
	<?php if ($l_examination->sortUrl($l_examination->discount_percent) == "") { ?>
		<th data-name="discount_percent" class="<?php echo $l_examination->discount_percent->headerCellClass() ?>"><div id="elh_l_examination_discount_percent" class="l_examination_discount_percent"><div class="ew-table-header-caption"><?php echo $l_examination->discount_percent->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="discount_percent" class="<?php echo $l_examination->discount_percent->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination->SortUrl($l_examination->discount_percent) ?>',2);"><div id="elh_l_examination_discount_percent" class="l_examination_discount_percent">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination->discount_percent->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_examination->discount_percent->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination->discount_percent->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination->discount_amount->Visible) { // discount_amount ?>
	<?php if ($l_examination->sortUrl($l_examination->discount_amount) == "") { ?>
		<th data-name="discount_amount" class="<?php echo $l_examination->discount_amount->headerCellClass() ?>"><div id="elh_l_examination_discount_amount" class="l_examination_discount_amount"><div class="ew-table-header-caption"><?php echo $l_examination->discount_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="discount_amount" class="<?php echo $l_examination->discount_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination->SortUrl($l_examination->discount_amount) ?>',2);"><div id="elh_l_examination_discount_amount" class="l_examination_discount_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination->discount_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_examination->discount_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination->discount_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination->final_amount->Visible) { // final_amount ?>
	<?php if ($l_examination->sortUrl($l_examination->final_amount) == "") { ?>
		<th data-name="final_amount" class="<?php echo $l_examination->final_amount->headerCellClass() ?>"><div id="elh_l_examination_final_amount" class="l_examination_final_amount"><div class="ew-table-header-caption"><?php echo $l_examination->final_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="final_amount" class="<?php echo $l_examination->final_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination->SortUrl($l_examination->final_amount) ?>',2);"><div id="elh_l_examination_final_amount" class="l_examination_final_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination->final_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_examination->final_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination->final_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination->remarks->Visible) { // remarks ?>
	<?php if ($l_examination->sortUrl($l_examination->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $l_examination->remarks->headerCellClass() ?>"><div id="elh_l_examination_remarks" class="l_examination_remarks"><div class="ew-table-header-caption"><?php echo $l_examination->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $l_examination->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination->SortUrl($l_examination->remarks) ?>',2);"><div id="elh_l_examination_remarks" class="l_examination_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($l_examination->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination->operator->Visible) { // operator ?>
	<?php if ($l_examination->sortUrl($l_examination->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $l_examination->operator->headerCellClass() ?>"><div id="elh_l_examination_operator" class="l_examination_operator"><div class="ew-table-header-caption"><?php echo $l_examination->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $l_examination->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination->SortUrl($l_examination->operator) ?>',2);"><div id="elh_l_examination_operator" class="l_examination_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_examination->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination->datetime->Visible) { // datetime ?>
	<?php if ($l_examination->sortUrl($l_examination->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $l_examination->datetime->headerCellClass() ?>"><div id="elh_l_examination_datetime" class="l_examination_datetime"><div class="ew-table-header-caption"><?php echo $l_examination->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $l_examination->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination->SortUrl($l_examination->datetime) ?>',2);"><div id="elh_l_examination_datetime" class="l_examination_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_examination->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_examination->receipt->Visible) { // receipt ?>
	<?php if ($l_examination->sortUrl($l_examination->receipt) == "") { ?>
		<th data-name="receipt" class="<?php echo $l_examination->receipt->headerCellClass() ?>"><div id="elh_l_examination_receipt" class="l_examination_receipt"><div class="ew-table-header-caption"><?php echo $l_examination->receipt->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="receipt" class="<?php echo $l_examination->receipt->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_examination->SortUrl($l_examination->receipt) ?>',2);"><div id="elh_l_examination_receipt" class="l_examination_receipt">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_examination->receipt->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_examination->receipt->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_examination->receipt->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$l_examination_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($l_examination->ExportAll && $l_examination->isExport()) {
	$l_examination_list->StopRec = $l_examination_list->TotalRecs;
} else {

	// Set the last record to display
	if ($l_examination_list->TotalRecs > $l_examination_list->StartRec + $l_examination_list->DisplayRecs - 1)
		$l_examination_list->StopRec = $l_examination_list->StartRec + $l_examination_list->DisplayRecs - 1;
	else
		$l_examination_list->StopRec = $l_examination_list->TotalRecs;
}
$l_examination_list->RecCnt = $l_examination_list->StartRec - 1;
if ($l_examination_list->Recordset && !$l_examination_list->Recordset->EOF) {
	$l_examination_list->Recordset->moveFirst();
	$selectLimit = $l_examination_list->UseSelectLimit;
	if (!$selectLimit && $l_examination_list->StartRec > 1)
		$l_examination_list->Recordset->move($l_examination_list->StartRec - 1);
} elseif (!$l_examination->AllowAddDeleteRow && $l_examination_list->StopRec == 0) {
	$l_examination_list->StopRec = $l_examination->GridAddRowCount;
}

// Initialize aggregate
$l_examination->RowType = ROWTYPE_AGGREGATEINIT;
$l_examination->resetAttributes();
$l_examination_list->renderRow();
while ($l_examination_list->RecCnt < $l_examination_list->StopRec) {
	$l_examination_list->RecCnt++;
	if ($l_examination_list->RecCnt >= $l_examination_list->StartRec) {
		$l_examination_list->RowCnt++;

		// Set up key count
		$l_examination_list->KeyCount = $l_examination_list->RowIndex;

		// Init row class and style
		$l_examination->resetAttributes();
		$l_examination->CssClass = "";
		if ($l_examination->isGridAdd()) {
		} else {
			$l_examination_list->loadRowValues($l_examination_list->Recordset); // Load row values
		}
		$l_examination->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$l_examination->RowAttrs = array_merge($l_examination->RowAttrs, array('data-rowindex'=>$l_examination_list->RowCnt, 'id'=>'r' . $l_examination_list->RowCnt . '_l_examination', 'data-rowtype'=>$l_examination->RowType));

		// Render row
		$l_examination_list->renderRow();

		// Render list options
		$l_examination_list->renderListOptions();
?>
	<tr<?php echo $l_examination->rowAttributes() ?>>
<?php

// Render list options (body, left)
$l_examination_list->ListOptions->render("body", "left", $l_examination_list->RowCnt);
?>
	<?php if ($l_examination->id->Visible) { // id ?>
		<td data-name="id"<?php echo $l_examination->id->cellAttributes() ?>>
<span id="el<?php echo $l_examination_list->RowCnt ?>_l_examination_id" class="l_examination_id">
<span<?php echo $l_examination->id->viewAttributes() ?>>
<?php echo $l_examination->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination->mobile->Visible) { // mobile ?>
		<td data-name="mobile"<?php echo $l_examination->mobile->cellAttributes() ?>>
<span id="el<?php echo $l_examination_list->RowCnt ?>_l_examination_mobile" class="l_examination_mobile">
<span<?php echo $l_examination->mobile->viewAttributes() ?>>
<?php echo $l_examination->mobile->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination->user->Visible) { // user ?>
		<td data-name="user"<?php echo $l_examination->user->cellAttributes() ?>>
<span id="el<?php echo $l_examination_list->RowCnt ?>_l_examination_user" class="l_examination_user">
<span<?php echo $l_examination->user->viewAttributes() ?>>
<?php echo $l_examination->user->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination->category->Visible) { // category ?>
		<td data-name="category"<?php echo $l_examination->category->cellAttributes() ?>>
<span id="el<?php echo $l_examination_list->RowCnt ?>_l_examination_category" class="l_examination_category">
<span<?php echo $l_examination->category->viewAttributes() ?>>
<?php echo $l_examination->category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination->name->Visible) { // name ?>
		<td data-name="name"<?php echo $l_examination->name->cellAttributes() ?>>
<span id="el<?php echo $l_examination_list->RowCnt ?>_l_examination_name" class="l_examination_name">
<span<?php echo $l_examination->name->viewAttributes() ?>>
<?php echo $l_examination->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination->age->Visible) { // age ?>
		<td data-name="age"<?php echo $l_examination->age->cellAttributes() ?>>
<span id="el<?php echo $l_examination_list->RowCnt ?>_l_examination_age" class="l_examination_age">
<span<?php echo $l_examination->age->viewAttributes() ?>>
<?php echo $l_examination->age->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination->sex->Visible) { // sex ?>
		<td data-name="sex"<?php echo $l_examination->sex->cellAttributes() ?>>
<span id="el<?php echo $l_examination_list->RowCnt ?>_l_examination_sex" class="l_examination_sex">
<span<?php echo $l_examination->sex->viewAttributes() ?>>
<?php echo $l_examination->sex->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination->referral->Visible) { // referral ?>
		<td data-name="referral"<?php echo $l_examination->referral->cellAttributes() ?>>
<span id="el<?php echo $l_examination_list->RowCnt ?>_l_examination_referral" class="l_examination_referral">
<span<?php echo $l_examination->referral->viewAttributes() ?>>
<?php echo $l_examination->referral->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination->examination_grp->Visible) { // examination_grp ?>
		<td data-name="examination_grp"<?php echo $l_examination->examination_grp->cellAttributes() ?>>
<span id="el<?php echo $l_examination_list->RowCnt ?>_l_examination_examination_grp" class="l_examination_examination_grp">
<span<?php echo $l_examination->examination_grp->viewAttributes() ?>>
<?php echo $l_examination->examination_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination->examination_type->Visible) { // examination_type ?>
		<td data-name="examination_type"<?php echo $l_examination->examination_type->cellAttributes() ?>>
<span id="el<?php echo $l_examination_list->RowCnt ?>_l_examination_examination_type" class="l_examination_examination_type">
<span<?php echo $l_examination->examination_type->viewAttributes() ?>>
<?php echo $l_examination->examination_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination->total_amount->Visible) { // total_amount ?>
		<td data-name="total_amount"<?php echo $l_examination->total_amount->cellAttributes() ?>>
<span id="el<?php echo $l_examination_list->RowCnt ?>_l_examination_total_amount" class="l_examination_total_amount">
<span<?php echo $l_examination->total_amount->viewAttributes() ?>>
<?php echo $l_examination->total_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination->discount_percent->Visible) { // discount_percent ?>
		<td data-name="discount_percent"<?php echo $l_examination->discount_percent->cellAttributes() ?>>
<span id="el<?php echo $l_examination_list->RowCnt ?>_l_examination_discount_percent" class="l_examination_discount_percent">
<span<?php echo $l_examination->discount_percent->viewAttributes() ?>>
<?php echo $l_examination->discount_percent->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination->discount_amount->Visible) { // discount_amount ?>
		<td data-name="discount_amount"<?php echo $l_examination->discount_amount->cellAttributes() ?>>
<span id="el<?php echo $l_examination_list->RowCnt ?>_l_examination_discount_amount" class="l_examination_discount_amount">
<span<?php echo $l_examination->discount_amount->viewAttributes() ?>>
<?php echo $l_examination->discount_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination->final_amount->Visible) { // final_amount ?>
		<td data-name="final_amount"<?php echo $l_examination->final_amount->cellAttributes() ?>>
<span id="el<?php echo $l_examination_list->RowCnt ?>_l_examination_final_amount" class="l_examination_final_amount">
<span<?php echo $l_examination->final_amount->viewAttributes() ?>>
<?php echo $l_examination->final_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $l_examination->remarks->cellAttributes() ?>>
<span id="el<?php echo $l_examination_list->RowCnt ?>_l_examination_remarks" class="l_examination_remarks">
<span<?php echo $l_examination->remarks->viewAttributes() ?>>
<?php echo $l_examination->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $l_examination->operator->cellAttributes() ?>>
<span id="el<?php echo $l_examination_list->RowCnt ?>_l_examination_operator" class="l_examination_operator">
<span<?php echo $l_examination->operator->viewAttributes() ?>>
<?php echo $l_examination->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $l_examination->datetime->cellAttributes() ?>>
<span id="el<?php echo $l_examination_list->RowCnt ?>_l_examination_datetime" class="l_examination_datetime">
<span<?php echo $l_examination->datetime->viewAttributes() ?>>
<?php echo $l_examination->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_examination->receipt->Visible) { // receipt ?>
		<td data-name="receipt"<?php echo $l_examination->receipt->cellAttributes() ?>>
<span id="el<?php echo $l_examination_list->RowCnt ?>_l_examination_receipt" class="l_examination_receipt">
<span<?php echo $l_examination->receipt->viewAttributes() ?>>
<?php echo $l_examination->receipt->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$l_examination_list->ListOptions->render("body", "right", $l_examination_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$l_examination->isGridAdd())
		$l_examination_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$l_examination->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($l_examination_list->Recordset)
	$l_examination_list->Recordset->Close();
?>
<?php if (!$l_examination->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$l_examination->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($l_examination_list->Pager)) $l_examination_list->Pager = new PrevNextPager($l_examination_list->StartRec, $l_examination_list->DisplayRecs, $l_examination_list->TotalRecs, $l_examination_list->AutoHidePager) ?>
<?php if ($l_examination_list->Pager->RecordCount > 0 && $l_examination_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($l_examination_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $l_examination_list->pageUrl() ?>start=<?php echo $l_examination_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($l_examination_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $l_examination_list->pageUrl() ?>start=<?php echo $l_examination_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $l_examination_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($l_examination_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $l_examination_list->pageUrl() ?>start=<?php echo $l_examination_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($l_examination_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $l_examination_list->pageUrl() ?>start=<?php echo $l_examination_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $l_examination_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($l_examination_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $l_examination_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $l_examination_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $l_examination_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($l_examination_list->TotalRecs > 0 && (!$l_examination_list->AutoHidePageSizeSelector || $l_examination_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="l_examination">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($l_examination_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($l_examination_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($l_examination_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($l_examination_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($l_examination_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($l_examination->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $l_examination_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($l_examination_list->TotalRecs == 0 && !$l_examination->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $l_examination_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$l_examination_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$l_examination->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$l_examination->isExport()) { ?>
<script>
ew.scrollableTable("gmp_l_examination", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$l_examination_list->terminate();
?>