<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$l_examination_search = new l_examination_search();

// Run the page
$l_examination_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$l_examination_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($l_examination_search->IsModal) { ?>
var fl_examinationsearch = currentAdvancedSearchForm = new ew.Form("fl_examinationsearch", "search");
<?php } else { ?>
var fl_examinationsearch = currentForm = new ew.Form("fl_examinationsearch", "search");
<?php } ?>

// Form_CustomValidate event
fl_examinationsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fl_examinationsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fl_examinationsearch.lists["x_mobile"] = <?php echo $l_examination_search->mobile->Lookup->toClientList() ?>;
fl_examinationsearch.lists["x_mobile"].options = <?php echo JsonEncode($l_examination_search->mobile->lookupOptions()) ?>;
fl_examinationsearch.autoSuggests["x_mobile"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fl_examinationsearch.lists["x_user"] = <?php echo $l_examination_search->user->Lookup->toClientList() ?>;
fl_examinationsearch.lists["x_user"].options = <?php echo JsonEncode($l_examination_search->user->lookupOptions()) ?>;
fl_examinationsearch.autoSuggests["x_user"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fl_examinationsearch.lists["x_category"] = <?php echo $l_examination_search->category->Lookup->toClientList() ?>;
fl_examinationsearch.lists["x_category"].options = <?php echo JsonEncode($l_examination_search->category->options(FALSE, TRUE)) ?>;
fl_examinationsearch.lists["x_name"] = <?php echo $l_examination_search->name->Lookup->toClientList() ?>;
fl_examinationsearch.lists["x_name"].options = <?php echo JsonEncode($l_examination_search->name->lookupOptions()) ?>;
fl_examinationsearch.autoSuggests["x_name"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fl_examinationsearch.lists["x_sex"] = <?php echo $l_examination_search->sex->Lookup->toClientList() ?>;
fl_examinationsearch.lists["x_sex"].options = <?php echo JsonEncode($l_examination_search->sex->options(FALSE, TRUE)) ?>;
fl_examinationsearch.lists["x_referral"] = <?php echo $l_examination_search->referral->Lookup->toClientList() ?>;
fl_examinationsearch.lists["x_referral"].options = <?php echo JsonEncode($l_examination_search->referral->lookupOptions()) ?>;
fl_examinationsearch.autoSuggests["x_referral"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fl_examinationsearch.lists["x_examination_grp[]"] = <?php echo $l_examination_search->examination_grp->Lookup->toClientList() ?>;
fl_examinationsearch.lists["x_examination_grp[]"].options = <?php echo JsonEncode($l_examination_search->examination_grp->lookupOptions()) ?>;
fl_examinationsearch.lists["x_examination_type[]"] = <?php echo $l_examination_search->examination_type->Lookup->toClientList() ?>;
fl_examinationsearch.lists["x_examination_type[]"].options = <?php echo JsonEncode($l_examination_search->examination_type->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fl_examinationsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($l_examination->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_user");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($l_examination->user->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_age");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($l_examination->age->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_referral");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($l_examination->referral->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_total_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($l_examination->total_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_discount_percent");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($l_examination->discount_percent->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_discount_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($l_examination->discount_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_final_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($l_examination->final_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($l_examination->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($l_examination->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_receipt");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($l_examination->receipt->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $l_examination_search->showPageHeader(); ?>
<?php
$l_examination_search->showMessage();
?>
<form name="fl_examinationsearch" id="fl_examinationsearch" class="<?php echo $l_examination_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($l_examination_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $l_examination_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="l_examination">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$l_examination_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($l_examination->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $l_examination_search->LeftColumnClass ?>"><span id="elh_l_examination_id"><?php echo $l_examination->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $l_examination_search->RightColumnClass ?>"><div<?php echo $l_examination->id->cellAttributes() ?>>
			<span id="el_l_examination_id">
<input type="text" data-table="l_examination" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($l_examination->id->getPlaceHolder()) ?>" value="<?php echo $l_examination->id->EditValue ?>"<?php echo $l_examination->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label class="<?php echo $l_examination_search->LeftColumnClass ?>"><span id="elh_l_examination_mobile"><?php echo $l_examination->mobile->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_mobile" id="z_mobile" value="="></span>
		</label>
		<div class="<?php echo $l_examination_search->RightColumnClass ?>"><div<?php echo $l_examination->mobile->cellAttributes() ?>>
			<span id="el_l_examination_mobile">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$l_examination->mobile->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$l_examination->mobile->EditAttrs["onchange"] = "";
?>
<span id="as_x_mobile" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_mobile" id="sv_x_mobile" value="<?php echo RemoveHtml($l_examination->mobile->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($l_examination->mobile->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($l_examination->mobile->getPlaceHolder()) ?>"<?php echo $l_examination->mobile->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($l_examination->mobile->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_mobile',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($l_examination->mobile->ReadOnly || $l_examination->mobile->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="l_examination" data-field="x_mobile" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $l_examination->mobile->displayValueSeparatorAttribute() ?>" name="x_mobile" id="x_mobile" value="<?php echo HtmlEncode($l_examination->mobile->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fl_examinationsearch.createAutoSuggest({"id":"x_mobile","forceSelect":false});
</script>
<?php echo $l_examination->mobile->Lookup->getParamTag("p_x_mobile") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination->user->Visible) { // user ?>
	<div id="r_user" class="form-group row">
		<label class="<?php echo $l_examination_search->LeftColumnClass ?>"><span id="elh_l_examination_user"><?php echo $l_examination->user->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_user" id="z_user" value="="></span>
		</label>
		<div class="<?php echo $l_examination_search->RightColumnClass ?>"><div<?php echo $l_examination->user->cellAttributes() ?>>
			<span id="el_l_examination_user">
<?php
$wrkonchange = "" . trim(@$l_examination->user->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$l_examination->user->EditAttrs["onchange"] = "";
?>
<span id="as_x_user" class="text-nowrap" style="z-index: 8970">
	<input type="text" class="form-control" name="sv_x_user" id="sv_x_user" value="<?php echo RemoveHtml($l_examination->user->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($l_examination->user->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($l_examination->user->getPlaceHolder()) ?>"<?php echo $l_examination->user->editAttributes() ?>>
</span>
<input type="hidden" data-table="l_examination" data-field="x_user" data-value-separator="<?php echo $l_examination->user->displayValueSeparatorAttribute() ?>" name="x_user" id="x_user" value="<?php echo HtmlEncode($l_examination->user->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fl_examinationsearch.createAutoSuggest({"id":"x_user","forceSelect":false});
</script>
<?php echo $l_examination->user->Lookup->getParamTag("p_x_user") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label for="x_category" class="<?php echo $l_examination_search->LeftColumnClass ?>"><span id="elh_l_examination_category"><?php echo $l_examination->category->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_category" id="z_category" value="="></span>
		</label>
		<div class="<?php echo $l_examination_search->RightColumnClass ?>"><div<?php echo $l_examination->category->cellAttributes() ?>>
			<span id="el_l_examination_category">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="l_examination" data-field="x_category" data-value-separator="<?php echo $l_examination->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $l_examination->category->editAttributes() ?>>
		<?php echo $l_examination->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label class="<?php echo $l_examination_search->LeftColumnClass ?>"><span id="elh_l_examination_name"><?php echo $l_examination->name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $l_examination_search->RightColumnClass ?>"><div<?php echo $l_examination->name->cellAttributes() ?>>
			<span id="el_l_examination_name">
<?php
$wrkonchange = "" . trim(@$l_examination->name->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$l_examination->name->EditAttrs["onchange"] = "";
?>
<span id="as_x_name" class="text-nowrap" style="z-index: 8950">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_name" id="sv_x_name" value="<?php echo RemoveHtml($l_examination->name->EditValue) ?>" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($l_examination->name->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($l_examination->name->getPlaceHolder()) ?>"<?php echo $l_examination->name->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($l_examination->name->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_name',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($l_examination->name->ReadOnly || $l_examination->name->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="l_examination" data-field="x_name" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $l_examination->name->displayValueSeparatorAttribute() ?>" name="x_name" id="x_name" value="<?php echo HtmlEncode($l_examination->name->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fl_examinationsearch.createAutoSuggest({"id":"x_name","forceSelect":false});
</script>
<?php echo $l_examination->name->Lookup->getParamTag("p_x_name") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination->age->Visible) { // age ?>
	<div id="r_age" class="form-group row">
		<label for="x_age" class="<?php echo $l_examination_search->LeftColumnClass ?>"><span id="elh_l_examination_age"><?php echo $l_examination->age->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_age" id="z_age" value="="></span>
		</label>
		<div class="<?php echo $l_examination_search->RightColumnClass ?>"><div<?php echo $l_examination->age->cellAttributes() ?>>
			<span id="el_l_examination_age">
<input type="text" data-table="l_examination" data-field="x_age" name="x_age" id="x_age" size="30" placeholder="<?php echo HtmlEncode($l_examination->age->getPlaceHolder()) ?>" value="<?php echo $l_examination->age->EditValue ?>"<?php echo $l_examination->age->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination->sex->Visible) { // sex ?>
	<div id="r_sex" class="form-group row">
		<label class="<?php echo $l_examination_search->LeftColumnClass ?>"><span id="elh_l_examination_sex"><?php echo $l_examination->sex->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sex" id="z_sex" value="="></span>
		</label>
		<div class="<?php echo $l_examination_search->RightColumnClass ?>"><div<?php echo $l_examination->sex->cellAttributes() ?>>
			<span id="el_l_examination_sex">
<div id="tp_x_sex" class="ew-template"><input type="radio" class="form-check-input" data-table="l_examination" data-field="x_sex" data-value-separator="<?php echo $l_examination->sex->displayValueSeparatorAttribute() ?>" name="x_sex" id="x_sex" value="{value}"<?php echo $l_examination->sex->editAttributes() ?>></div>
<div id="dsl_x_sex" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $l_examination->sex->radioButtonListHtml(FALSE, "x_sex") ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination->referral->Visible) { // referral ?>
	<div id="r_referral" class="form-group row">
		<label class="<?php echo $l_examination_search->LeftColumnClass ?>"><span id="elh_l_examination_referral"><?php echo $l_examination->referral->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_referral" id="z_referral" value="="></span>
		</label>
		<div class="<?php echo $l_examination_search->RightColumnClass ?>"><div<?php echo $l_examination->referral->cellAttributes() ?>>
			<span id="el_l_examination_referral">
<?php
$wrkonchange = "" . trim(@$l_examination->referral->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$l_examination->referral->EditAttrs["onchange"] = "";
?>
<span id="as_x_referral" class="text-nowrap" style="z-index: 8920">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_referral" id="sv_x_referral" value="<?php echo RemoveHtml($l_examination->referral->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($l_examination->referral->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($l_examination->referral->getPlaceHolder()) ?>"<?php echo $l_examination->referral->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($l_examination->referral->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_referral',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($l_examination->referral->ReadOnly || $l_examination->referral->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="l_examination" data-field="x_referral" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $l_examination->referral->displayValueSeparatorAttribute() ?>" name="x_referral" id="x_referral" value="<?php echo HtmlEncode($l_examination->referral->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fl_examinationsearch.createAutoSuggest({"id":"x_referral","forceSelect":true});
</script>
<?php echo $l_examination->referral->Lookup->getParamTag("p_x_referral") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination->examination_grp->Visible) { // examination_grp ?>
	<div id="r_examination_grp" class="form-group row">
		<label class="<?php echo $l_examination_search->LeftColumnClass ?>"><span id="elh_l_examination_examination_grp"><?php echo $l_examination->examination_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_examination_grp" id="z_examination_grp" value="="></span>
		</label>
		<div class="<?php echo $l_examination_search->RightColumnClass ?>"><div<?php echo $l_examination->examination_grp->cellAttributes() ?>>
			<span id="el_l_examination_examination_grp">
<?php $l_examination->examination_grp->EditAttrs["onclick"] = "ew.updateOptions.call(this); " . @$l_examination->examination_grp->EditAttrs["onclick"]; ?>
<div id="tp_x_examination_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="l_examination" data-field="x_examination_grp" data-value-separator="<?php echo $l_examination->examination_grp->displayValueSeparatorAttribute() ?>" name="x_examination_grp[]" id="x_examination_grp[]" value="{value}"<?php echo $l_examination->examination_grp->editAttributes() ?>></div>
<div id="dsl_x_examination_grp" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $l_examination->examination_grp->checkBoxListHtml(FALSE, "x_examination_grp[]") ?>
</div></div>
<?php echo $l_examination->examination_grp->Lookup->getParamTag("p_x_examination_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination->examination_type->Visible) { // examination_type ?>
	<div id="r_examination_type" class="form-group row">
		<label class="<?php echo $l_examination_search->LeftColumnClass ?>"><span id="elh_l_examination_examination_type"><?php echo $l_examination->examination_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_examination_type" id="z_examination_type" value="LIKE"></span>
		</label>
		<div class="<?php echo $l_examination_search->RightColumnClass ?>"><div<?php echo $l_examination->examination_type->cellAttributes() ?>>
			<span id="el_l_examination_examination_type">
<div id="tp_x_examination_type" class="ew-template"><input type="checkbox" class="form-check-input" data-table="l_examination" data-field="x_examination_type" data-value-separator="<?php echo $l_examination->examination_type->displayValueSeparatorAttribute() ?>" name="x_examination_type[]" id="x_examination_type[]" value="{value}"<?php echo $l_examination->examination_type->editAttributes() ?>></div>
<div id="dsl_x_examination_type" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $l_examination->examination_type->checkBoxListHtml(FALSE, "x_examination_type[]") ?>
</div></div>
<?php echo $l_examination->examination_type->Lookup->getParamTag("p_x_examination_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination->total_amount->Visible) { // total_amount ?>
	<div id="r_total_amount" class="form-group row">
		<label for="x_total_amount" class="<?php echo $l_examination_search->LeftColumnClass ?>"><span id="elh_l_examination_total_amount"><?php echo $l_examination->total_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_total_amount" id="z_total_amount" value="="></span>
		</label>
		<div class="<?php echo $l_examination_search->RightColumnClass ?>"><div<?php echo $l_examination->total_amount->cellAttributes() ?>>
			<span id="el_l_examination_total_amount">
<input type="text" data-table="l_examination" data-field="x_total_amount" name="x_total_amount" id="x_total_amount" size="30" placeholder="<?php echo HtmlEncode($l_examination->total_amount->getPlaceHolder()) ?>" value="<?php echo $l_examination->total_amount->EditValue ?>"<?php echo $l_examination->total_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination->discount_percent->Visible) { // discount_percent ?>
	<div id="r_discount_percent" class="form-group row">
		<label for="x_discount_percent" class="<?php echo $l_examination_search->LeftColumnClass ?>"><span id="elh_l_examination_discount_percent"><?php echo $l_examination->discount_percent->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_discount_percent" id="z_discount_percent" value="="></span>
		</label>
		<div class="<?php echo $l_examination_search->RightColumnClass ?>"><div<?php echo $l_examination->discount_percent->cellAttributes() ?>>
			<span id="el_l_examination_discount_percent">
<input type="text" data-table="l_examination" data-field="x_discount_percent" name="x_discount_percent" id="x_discount_percent" size="30" placeholder="<?php echo HtmlEncode($l_examination->discount_percent->getPlaceHolder()) ?>" value="<?php echo $l_examination->discount_percent->EditValue ?>"<?php echo $l_examination->discount_percent->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination->discount_amount->Visible) { // discount_amount ?>
	<div id="r_discount_amount" class="form-group row">
		<label for="x_discount_amount" class="<?php echo $l_examination_search->LeftColumnClass ?>"><span id="elh_l_examination_discount_amount"><?php echo $l_examination->discount_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_discount_amount" id="z_discount_amount" value="="></span>
		</label>
		<div class="<?php echo $l_examination_search->RightColumnClass ?>"><div<?php echo $l_examination->discount_amount->cellAttributes() ?>>
			<span id="el_l_examination_discount_amount">
<input type="text" data-table="l_examination" data-field="x_discount_amount" name="x_discount_amount" id="x_discount_amount" size="30" placeholder="<?php echo HtmlEncode($l_examination->discount_amount->getPlaceHolder()) ?>" value="<?php echo $l_examination->discount_amount->EditValue ?>"<?php echo $l_examination->discount_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination->final_amount->Visible) { // final_amount ?>
	<div id="r_final_amount" class="form-group row">
		<label for="x_final_amount" class="<?php echo $l_examination_search->LeftColumnClass ?>"><span id="elh_l_examination_final_amount"><?php echo $l_examination->final_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_final_amount" id="z_final_amount" value="="></span>
		</label>
		<div class="<?php echo $l_examination_search->RightColumnClass ?>"><div<?php echo $l_examination->final_amount->cellAttributes() ?>>
			<span id="el_l_examination_final_amount">
<input type="text" data-table="l_examination" data-field="x_final_amount" name="x_final_amount" id="x_final_amount" size="30" placeholder="<?php echo HtmlEncode($l_examination->final_amount->getPlaceHolder()) ?>" value="<?php echo $l_examination->final_amount->EditValue ?>"<?php echo $l_examination->final_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $l_examination_search->LeftColumnClass ?>"><span id="elh_l_examination_remarks"><?php echo $l_examination->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $l_examination_search->RightColumnClass ?>"><div<?php echo $l_examination->remarks->cellAttributes() ?>>
			<span id="el_l_examination_remarks">
<input type="text" data-table="l_examination" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($l_examination->remarks->getPlaceHolder()) ?>" value="<?php echo $l_examination->remarks->EditValue ?>"<?php echo $l_examination->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $l_examination_search->LeftColumnClass ?>"><span id="elh_l_examination_operator"><?php echo $l_examination->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $l_examination_search->RightColumnClass ?>"><div<?php echo $l_examination->operator->cellAttributes() ?>>
			<span id="el_l_examination_operator">
<input type="text" data-table="l_examination" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($l_examination->operator->getPlaceHolder()) ?>" value="<?php echo $l_examination->operator->EditValue ?>"<?php echo $l_examination->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $l_examination_search->LeftColumnClass ?>"><span id="elh_l_examination_datetime"><?php echo $l_examination->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $l_examination_search->RightColumnClass ?>"><div<?php echo $l_examination->datetime->cellAttributes() ?>>
			<span id="el_l_examination_datetime">
<input type="text" data-table="l_examination" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($l_examination->datetime->getPlaceHolder()) ?>" value="<?php echo $l_examination->datetime->EditValue ?>"<?php echo $l_examination->datetime->editAttributes() ?>>
<?php if (!$l_examination->datetime->ReadOnly && !$l_examination->datetime->Disabled && !isset($l_examination->datetime->EditAttrs["readonly"]) && !isset($l_examination->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fl_examinationsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_examination->receipt->Visible) { // receipt ?>
	<div id="r_receipt" class="form-group row">
		<label for="x_receipt" class="<?php echo $l_examination_search->LeftColumnClass ?>"><span id="elh_l_examination_receipt"><?php echo $l_examination->receipt->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_receipt" id="z_receipt" value="="></span>
		</label>
		<div class="<?php echo $l_examination_search->RightColumnClass ?>"><div<?php echo $l_examination->receipt->cellAttributes() ?>>
			<span id="el_l_examination_receipt">
<input type="text" data-table="l_examination" data-field="x_receipt" name="x_receipt" id="x_receipt" size="30" placeholder="<?php echo HtmlEncode($l_examination->receipt->getPlaceHolder()) ?>" value="<?php echo $l_examination->receipt->EditValue ?>"<?php echo $l_examination->receipt->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$l_examination_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $l_examination_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$l_examination_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$l_examination_search->terminate();
?>