<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$l_examination_view = new l_examination_view();

// Run the page
$l_examination_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$l_examination_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$l_examination->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fl_examinationview = currentForm = new ew.Form("fl_examinationview", "view");

// Form_CustomValidate event
fl_examinationview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fl_examinationview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fl_examinationview.lists["x_mobile"] = <?php echo $l_examination_view->mobile->Lookup->toClientList() ?>;
fl_examinationview.lists["x_mobile"].options = <?php echo JsonEncode($l_examination_view->mobile->lookupOptions()) ?>;
fl_examinationview.autoSuggests["x_mobile"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fl_examinationview.lists["x_user"] = <?php echo $l_examination_view->user->Lookup->toClientList() ?>;
fl_examinationview.lists["x_user"].options = <?php echo JsonEncode($l_examination_view->user->lookupOptions()) ?>;
fl_examinationview.autoSuggests["x_user"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fl_examinationview.lists["x_category"] = <?php echo $l_examination_view->category->Lookup->toClientList() ?>;
fl_examinationview.lists["x_category"].options = <?php echo JsonEncode($l_examination_view->category->options(FALSE, TRUE)) ?>;
fl_examinationview.lists["x_name"] = <?php echo $l_examination_view->name->Lookup->toClientList() ?>;
fl_examinationview.lists["x_name"].options = <?php echo JsonEncode($l_examination_view->name->lookupOptions()) ?>;
fl_examinationview.autoSuggests["x_name"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fl_examinationview.lists["x_sex"] = <?php echo $l_examination_view->sex->Lookup->toClientList() ?>;
fl_examinationview.lists["x_sex"].options = <?php echo JsonEncode($l_examination_view->sex->options(FALSE, TRUE)) ?>;
fl_examinationview.lists["x_referral"] = <?php echo $l_examination_view->referral->Lookup->toClientList() ?>;
fl_examinationview.lists["x_referral"].options = <?php echo JsonEncode($l_examination_view->referral->lookupOptions()) ?>;
fl_examinationview.autoSuggests["x_referral"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fl_examinationview.lists["x_examination_grp[]"] = <?php echo $l_examination_view->examination_grp->Lookup->toClientList() ?>;
fl_examinationview.lists["x_examination_grp[]"].options = <?php echo JsonEncode($l_examination_view->examination_grp->lookupOptions()) ?>;
fl_examinationview.lists["x_examination_type[]"] = <?php echo $l_examination_view->examination_type->Lookup->toClientList() ?>;
fl_examinationview.lists["x_examination_type[]"].options = <?php echo JsonEncode($l_examination_view->examination_type->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$l_examination->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $l_examination_view->ExportOptions->render("body") ?>
<?php $l_examination_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $l_examination_view->showPageHeader(); ?>
<?php
$l_examination_view->showMessage();
?>
<form name="fl_examinationview" id="fl_examinationview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($l_examination_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $l_examination_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="l_examination">
<input type="hidden" name="modal" value="<?php echo (int)$l_examination_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($l_examination->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $l_examination_view->TableLeftColumnClass ?>"><span id="elh_l_examination_id"><?php echo $l_examination->id->caption() ?></span></td>
		<td data-name="id"<?php echo $l_examination->id->cellAttributes() ?>>
<span id="el_l_examination_id">
<span<?php echo $l_examination->id->viewAttributes() ?>>
<?php echo $l_examination->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_examination->mobile->Visible) { // mobile ?>
	<tr id="r_mobile">
		<td class="<?php echo $l_examination_view->TableLeftColumnClass ?>"><span id="elh_l_examination_mobile"><?php echo $l_examination->mobile->caption() ?></span></td>
		<td data-name="mobile"<?php echo $l_examination->mobile->cellAttributes() ?>>
<span id="el_l_examination_mobile">
<span<?php echo $l_examination->mobile->viewAttributes() ?>>
<?php echo $l_examination->mobile->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_examination->user->Visible) { // user ?>
	<tr id="r_user">
		<td class="<?php echo $l_examination_view->TableLeftColumnClass ?>"><span id="elh_l_examination_user"><?php echo $l_examination->user->caption() ?></span></td>
		<td data-name="user"<?php echo $l_examination->user->cellAttributes() ?>>
<span id="el_l_examination_user">
<span<?php echo $l_examination->user->viewAttributes() ?>>
<?php echo $l_examination->user->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_examination->category->Visible) { // category ?>
	<tr id="r_category">
		<td class="<?php echo $l_examination_view->TableLeftColumnClass ?>"><span id="elh_l_examination_category"><?php echo $l_examination->category->caption() ?></span></td>
		<td data-name="category"<?php echo $l_examination->category->cellAttributes() ?>>
<span id="el_l_examination_category">
<span<?php echo $l_examination->category->viewAttributes() ?>>
<?php echo $l_examination->category->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_examination->name->Visible) { // name ?>
	<tr id="r_name">
		<td class="<?php echo $l_examination_view->TableLeftColumnClass ?>"><span id="elh_l_examination_name"><?php echo $l_examination->name->caption() ?></span></td>
		<td data-name="name"<?php echo $l_examination->name->cellAttributes() ?>>
<span id="el_l_examination_name">
<span<?php echo $l_examination->name->viewAttributes() ?>>
<?php echo $l_examination->name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_examination->age->Visible) { // age ?>
	<tr id="r_age">
		<td class="<?php echo $l_examination_view->TableLeftColumnClass ?>"><span id="elh_l_examination_age"><?php echo $l_examination->age->caption() ?></span></td>
		<td data-name="age"<?php echo $l_examination->age->cellAttributes() ?>>
<span id="el_l_examination_age">
<span<?php echo $l_examination->age->viewAttributes() ?>>
<?php echo $l_examination->age->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_examination->sex->Visible) { // sex ?>
	<tr id="r_sex">
		<td class="<?php echo $l_examination_view->TableLeftColumnClass ?>"><span id="elh_l_examination_sex"><?php echo $l_examination->sex->caption() ?></span></td>
		<td data-name="sex"<?php echo $l_examination->sex->cellAttributes() ?>>
<span id="el_l_examination_sex">
<span<?php echo $l_examination->sex->viewAttributes() ?>>
<?php echo $l_examination->sex->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_examination->referral->Visible) { // referral ?>
	<tr id="r_referral">
		<td class="<?php echo $l_examination_view->TableLeftColumnClass ?>"><span id="elh_l_examination_referral"><?php echo $l_examination->referral->caption() ?></span></td>
		<td data-name="referral"<?php echo $l_examination->referral->cellAttributes() ?>>
<span id="el_l_examination_referral">
<span<?php echo $l_examination->referral->viewAttributes() ?>>
<?php echo $l_examination->referral->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_examination->examination_grp->Visible) { // examination_grp ?>
	<tr id="r_examination_grp">
		<td class="<?php echo $l_examination_view->TableLeftColumnClass ?>"><span id="elh_l_examination_examination_grp"><?php echo $l_examination->examination_grp->caption() ?></span></td>
		<td data-name="examination_grp"<?php echo $l_examination->examination_grp->cellAttributes() ?>>
<span id="el_l_examination_examination_grp">
<span<?php echo $l_examination->examination_grp->viewAttributes() ?>>
<?php echo $l_examination->examination_grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_examination->examination_type->Visible) { // examination_type ?>
	<tr id="r_examination_type">
		<td class="<?php echo $l_examination_view->TableLeftColumnClass ?>"><span id="elh_l_examination_examination_type"><?php echo $l_examination->examination_type->caption() ?></span></td>
		<td data-name="examination_type"<?php echo $l_examination->examination_type->cellAttributes() ?>>
<span id="el_l_examination_examination_type">
<span<?php echo $l_examination->examination_type->viewAttributes() ?>>
<?php echo $l_examination->examination_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_examination->total_amount->Visible) { // total_amount ?>
	<tr id="r_total_amount">
		<td class="<?php echo $l_examination_view->TableLeftColumnClass ?>"><span id="elh_l_examination_total_amount"><?php echo $l_examination->total_amount->caption() ?></span></td>
		<td data-name="total_amount"<?php echo $l_examination->total_amount->cellAttributes() ?>>
<span id="el_l_examination_total_amount">
<span<?php echo $l_examination->total_amount->viewAttributes() ?>>
<?php echo $l_examination->total_amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_examination->discount_percent->Visible) { // discount_percent ?>
	<tr id="r_discount_percent">
		<td class="<?php echo $l_examination_view->TableLeftColumnClass ?>"><span id="elh_l_examination_discount_percent"><?php echo $l_examination->discount_percent->caption() ?></span></td>
		<td data-name="discount_percent"<?php echo $l_examination->discount_percent->cellAttributes() ?>>
<span id="el_l_examination_discount_percent">
<span<?php echo $l_examination->discount_percent->viewAttributes() ?>>
<?php echo $l_examination->discount_percent->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_examination->discount_amount->Visible) { // discount_amount ?>
	<tr id="r_discount_amount">
		<td class="<?php echo $l_examination_view->TableLeftColumnClass ?>"><span id="elh_l_examination_discount_amount"><?php echo $l_examination->discount_amount->caption() ?></span></td>
		<td data-name="discount_amount"<?php echo $l_examination->discount_amount->cellAttributes() ?>>
<span id="el_l_examination_discount_amount">
<span<?php echo $l_examination->discount_amount->viewAttributes() ?>>
<?php echo $l_examination->discount_amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_examination->final_amount->Visible) { // final_amount ?>
	<tr id="r_final_amount">
		<td class="<?php echo $l_examination_view->TableLeftColumnClass ?>"><span id="elh_l_examination_final_amount"><?php echo $l_examination->final_amount->caption() ?></span></td>
		<td data-name="final_amount"<?php echo $l_examination->final_amount->cellAttributes() ?>>
<span id="el_l_examination_final_amount">
<span<?php echo $l_examination->final_amount->viewAttributes() ?>>
<?php echo $l_examination->final_amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_examination->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $l_examination_view->TableLeftColumnClass ?>"><span id="elh_l_examination_remarks"><?php echo $l_examination->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $l_examination->remarks->cellAttributes() ?>>
<span id="el_l_examination_remarks">
<span<?php echo $l_examination->remarks->viewAttributes() ?>>
<?php echo $l_examination->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_examination->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $l_examination_view->TableLeftColumnClass ?>"><span id="elh_l_examination_operator"><?php echo $l_examination->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $l_examination->operator->cellAttributes() ?>>
<span id="el_l_examination_operator">
<span<?php echo $l_examination->operator->viewAttributes() ?>>
<?php echo $l_examination->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_examination->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $l_examination_view->TableLeftColumnClass ?>"><span id="elh_l_examination_datetime"><?php echo $l_examination->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $l_examination->datetime->cellAttributes() ?>>
<span id="el_l_examination_datetime">
<span<?php echo $l_examination->datetime->viewAttributes() ?>>
<?php echo $l_examination->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_examination->receipt->Visible) { // receipt ?>
	<tr id="r_receipt">
		<td class="<?php echo $l_examination_view->TableLeftColumnClass ?>"><span id="elh_l_examination_receipt"><?php echo $l_examination->receipt->caption() ?></span></td>
		<td data-name="receipt"<?php echo $l_examination->receipt->cellAttributes() ?>>
<span id="el_l_examination_receipt">
<span<?php echo $l_examination->receipt->viewAttributes() ?>>
<?php echo $l_examination->receipt->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$l_examination_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$l_examination->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$l_examination_view->terminate();
?>