<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$l_receipt_delete = new l_receipt_delete();

// Run the page
$l_receipt_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$l_receipt_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fl_receiptdelete = currentForm = new ew.Form("fl_receiptdelete", "delete");

// Form_CustomValidate event
fl_receiptdelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fl_receiptdelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fl_receiptdelete.lists["x_r_from"] = <?php echo $l_receipt_delete->r_from->Lookup->toClientList() ?>;
fl_receiptdelete.lists["x_r_from"].options = <?php echo JsonEncode($l_receipt_delete->r_from->lookupOptions()) ?>;
fl_receiptdelete.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fl_receiptdelete.lists["x_r_to"] = <?php echo $l_receipt_delete->r_to->Lookup->toClientList() ?>;
fl_receiptdelete.lists["x_r_to"].options = <?php echo JsonEncode($l_receipt_delete->r_to->lookupOptions()) ?>;
fl_receiptdelete.lists["x_d_id"] = <?php echo $l_receipt_delete->d_id->Lookup->toClientList() ?>;
fl_receiptdelete.lists["x_d_id"].options = <?php echo JsonEncode($l_receipt_delete->d_id->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $l_receipt_delete->showPageHeader(); ?>
<?php
$l_receipt_delete->showMessage();
?>
<form name="fl_receiptdelete" id="fl_receiptdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($l_receipt_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $l_receipt_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="l_receipt">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($l_receipt_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($l_receipt->id->Visible) { // id ?>
		<th class="<?php echo $l_receipt->id->headerCellClass() ?>"><span id="elh_l_receipt_id" class="l_receipt_id"><?php echo $l_receipt->id->caption() ?></span></th>
<?php } ?>
<?php if ($l_receipt->r_from->Visible) { // r_from ?>
		<th class="<?php echo $l_receipt->r_from->headerCellClass() ?>"><span id="elh_l_receipt_r_from" class="l_receipt_r_from"><?php echo $l_receipt->r_from->caption() ?></span></th>
<?php } ?>
<?php if ($l_receipt->r_to->Visible) { // r_to ?>
		<th class="<?php echo $l_receipt->r_to->headerCellClass() ?>"><span id="elh_l_receipt_r_to" class="l_receipt_r_to"><?php echo $l_receipt->r_to->caption() ?></span></th>
<?php } ?>
<?php if ($l_receipt->d_id->Visible) { // d_id ?>
		<th class="<?php echo $l_receipt->d_id->headerCellClass() ?>"><span id="elh_l_receipt_d_id" class="l_receipt_d_id"><?php echo $l_receipt->d_id->caption() ?></span></th>
<?php } ?>
<?php if ($l_receipt->total_amount->Visible) { // total_amount ?>
		<th class="<?php echo $l_receipt->total_amount->headerCellClass() ?>"><span id="elh_l_receipt_total_amount" class="l_receipt_total_amount"><?php echo $l_receipt->total_amount->caption() ?></span></th>
<?php } ?>
<?php if ($l_receipt->discount_amount->Visible) { // discount_amount ?>
		<th class="<?php echo $l_receipt->discount_amount->headerCellClass() ?>"><span id="elh_l_receipt_discount_amount" class="l_receipt_discount_amount"><?php echo $l_receipt->discount_amount->caption() ?></span></th>
<?php } ?>
<?php if ($l_receipt->receipt_amount->Visible) { // receipt_amount ?>
		<th class="<?php echo $l_receipt->receipt_amount->headerCellClass() ?>"><span id="elh_l_receipt_receipt_amount" class="l_receipt_receipt_amount"><?php echo $l_receipt->receipt_amount->caption() ?></span></th>
<?php } ?>
<?php if ($l_receipt->dated->Visible) { // dated ?>
		<th class="<?php echo $l_receipt->dated->headerCellClass() ?>"><span id="elh_l_receipt_dated" class="l_receipt_dated"><?php echo $l_receipt->dated->caption() ?></span></th>
<?php } ?>
<?php if ($l_receipt->remarks->Visible) { // remarks ?>
		<th class="<?php echo $l_receipt->remarks->headerCellClass() ?>"><span id="elh_l_receipt_remarks" class="l_receipt_remarks"><?php echo $l_receipt->remarks->caption() ?></span></th>
<?php } ?>
<?php if ($l_receipt->uploads->Visible) { // uploads ?>
		<th class="<?php echo $l_receipt->uploads->headerCellClass() ?>"><span id="elh_l_receipt_uploads" class="l_receipt_uploads"><?php echo $l_receipt->uploads->caption() ?></span></th>
<?php } ?>
<?php if ($l_receipt->operator->Visible) { // operator ?>
		<th class="<?php echo $l_receipt->operator->headerCellClass() ?>"><span id="elh_l_receipt_operator" class="l_receipt_operator"><?php echo $l_receipt->operator->caption() ?></span></th>
<?php } ?>
<?php if ($l_receipt->datetime->Visible) { // datetime ?>
		<th class="<?php echo $l_receipt->datetime->headerCellClass() ?>"><span id="elh_l_receipt_datetime" class="l_receipt_datetime"><?php echo $l_receipt->datetime->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$l_receipt_delete->RecCnt = 0;
$i = 0;
while (!$l_receipt_delete->Recordset->EOF) {
	$l_receipt_delete->RecCnt++;
	$l_receipt_delete->RowCnt++;

	// Set row properties
	$l_receipt->resetAttributes();
	$l_receipt->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$l_receipt_delete->loadRowValues($l_receipt_delete->Recordset);

	// Render row
	$l_receipt_delete->renderRow();
?>
	<tr<?php echo $l_receipt->rowAttributes() ?>>
<?php if ($l_receipt->id->Visible) { // id ?>
		<td<?php echo $l_receipt->id->cellAttributes() ?>>
<span id="el<?php echo $l_receipt_delete->RowCnt ?>_l_receipt_id" class="l_receipt_id">
<span<?php echo $l_receipt->id->viewAttributes() ?>>
<?php echo $l_receipt->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($l_receipt->r_from->Visible) { // r_from ?>
		<td<?php echo $l_receipt->r_from->cellAttributes() ?>>
<span id="el<?php echo $l_receipt_delete->RowCnt ?>_l_receipt_r_from" class="l_receipt_r_from">
<span<?php echo $l_receipt->r_from->viewAttributes() ?>>
<?php echo $l_receipt->r_from->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($l_receipt->r_to->Visible) { // r_to ?>
		<td<?php echo $l_receipt->r_to->cellAttributes() ?>>
<span id="el<?php echo $l_receipt_delete->RowCnt ?>_l_receipt_r_to" class="l_receipt_r_to">
<span<?php echo $l_receipt->r_to->viewAttributes() ?>>
<?php echo $l_receipt->r_to->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($l_receipt->d_id->Visible) { // d_id ?>
		<td<?php echo $l_receipt->d_id->cellAttributes() ?>>
<span id="el<?php echo $l_receipt_delete->RowCnt ?>_l_receipt_d_id" class="l_receipt_d_id">
<span<?php echo $l_receipt->d_id->viewAttributes() ?>>
<?php echo $l_receipt->d_id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($l_receipt->total_amount->Visible) { // total_amount ?>
		<td<?php echo $l_receipt->total_amount->cellAttributes() ?>>
<span id="el<?php echo $l_receipt_delete->RowCnt ?>_l_receipt_total_amount" class="l_receipt_total_amount">
<span<?php echo $l_receipt->total_amount->viewAttributes() ?>>
<?php echo $l_receipt->total_amount->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($l_receipt->discount_amount->Visible) { // discount_amount ?>
		<td<?php echo $l_receipt->discount_amount->cellAttributes() ?>>
<span id="el<?php echo $l_receipt_delete->RowCnt ?>_l_receipt_discount_amount" class="l_receipt_discount_amount">
<span<?php echo $l_receipt->discount_amount->viewAttributes() ?>>
<?php echo $l_receipt->discount_amount->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($l_receipt->receipt_amount->Visible) { // receipt_amount ?>
		<td<?php echo $l_receipt->receipt_amount->cellAttributes() ?>>
<span id="el<?php echo $l_receipt_delete->RowCnt ?>_l_receipt_receipt_amount" class="l_receipt_receipt_amount">
<span<?php echo $l_receipt->receipt_amount->viewAttributes() ?>>
<?php echo $l_receipt->receipt_amount->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($l_receipt->dated->Visible) { // dated ?>
		<td<?php echo $l_receipt->dated->cellAttributes() ?>>
<span id="el<?php echo $l_receipt_delete->RowCnt ?>_l_receipt_dated" class="l_receipt_dated">
<span<?php echo $l_receipt->dated->viewAttributes() ?>>
<?php echo $l_receipt->dated->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($l_receipt->remarks->Visible) { // remarks ?>
		<td<?php echo $l_receipt->remarks->cellAttributes() ?>>
<span id="el<?php echo $l_receipt_delete->RowCnt ?>_l_receipt_remarks" class="l_receipt_remarks">
<span<?php echo $l_receipt->remarks->viewAttributes() ?>>
<?php echo $l_receipt->remarks->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($l_receipt->uploads->Visible) { // uploads ?>
		<td<?php echo $l_receipt->uploads->cellAttributes() ?>>
<span id="el<?php echo $l_receipt_delete->RowCnt ?>_l_receipt_uploads" class="l_receipt_uploads">
<span>
<?php echo GetFileViewTag($l_receipt->uploads, $l_receipt->uploads->getViewValue()) ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($l_receipt->operator->Visible) { // operator ?>
		<td<?php echo $l_receipt->operator->cellAttributes() ?>>
<span id="el<?php echo $l_receipt_delete->RowCnt ?>_l_receipt_operator" class="l_receipt_operator">
<span<?php echo $l_receipt->operator->viewAttributes() ?>>
<?php echo $l_receipt->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($l_receipt->datetime->Visible) { // datetime ?>
		<td<?php echo $l_receipt->datetime->cellAttributes() ?>>
<span id="el<?php echo $l_receipt_delete->RowCnt ?>_l_receipt_datetime" class="l_receipt_datetime">
<span<?php echo $l_receipt->datetime->viewAttributes() ?>>
<?php echo $l_receipt->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$l_receipt_delete->Recordset->moveNext();
}
$l_receipt_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $l_receipt_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$l_receipt_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$l_receipt_delete->terminate();
?>