<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$l_receipt_edit = new l_receipt_edit();

// Run the page
$l_receipt_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$l_receipt_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fl_receiptedit = currentForm = new ew.Form("fl_receiptedit", "edit");

// Validate form
fl_receiptedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($l_receipt_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_receipt->id->caption(), $l_receipt->id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($l_receipt->id->errorMessage()) ?>");
		<?php if ($l_receipt_edit->r_from->Required) { ?>
			elm = this.getElements("x" + infix + "_r_from");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_receipt->r_from->caption(), $l_receipt->r_from->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($l_receipt_edit->r_to->Required) { ?>
			elm = this.getElements("x" + infix + "_r_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_receipt->r_to->caption(), $l_receipt->r_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($l_receipt_edit->d_id->Required) { ?>
			elm = this.getElements("x" + infix + "_d_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_receipt->d_id->caption(), $l_receipt->d_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($l_receipt_edit->total_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_total_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_receipt->total_amount->caption(), $l_receipt->total_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_total_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($l_receipt->total_amount->errorMessage()) ?>");
		<?php if ($l_receipt_edit->discount_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_discount_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_receipt->discount_amount->caption(), $l_receipt->discount_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_discount_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($l_receipt->discount_amount->errorMessage()) ?>");
		<?php if ($l_receipt_edit->receipt_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_receipt_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_receipt->receipt_amount->caption(), $l_receipt->receipt_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_receipt_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($l_receipt->receipt_amount->errorMessage()) ?>");
		<?php if ($l_receipt_edit->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_receipt->dated->caption(), $l_receipt->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($l_receipt->dated->errorMessage()) ?>");
		<?php if ($l_receipt_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_receipt->remarks->caption(), $l_receipt->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($l_receipt_edit->uploads->Required) { ?>
			felm = this.getElements("x" + infix + "_uploads");
			elm = this.getElements("fn_x" + infix + "_uploads");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $l_receipt->uploads->caption(), $l_receipt->uploads->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($l_receipt_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_receipt->operator->caption(), $l_receipt->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($l_receipt_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_receipt->datetime->caption(), $l_receipt->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fl_receiptedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fl_receiptedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fl_receiptedit.lists["x_r_from"] = <?php echo $l_receipt_edit->r_from->Lookup->toClientList() ?>;
fl_receiptedit.lists["x_r_from"].options = <?php echo JsonEncode($l_receipt_edit->r_from->lookupOptions()) ?>;
fl_receiptedit.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fl_receiptedit.lists["x_r_to"] = <?php echo $l_receipt_edit->r_to->Lookup->toClientList() ?>;
fl_receiptedit.lists["x_r_to"].options = <?php echo JsonEncode($l_receipt_edit->r_to->lookupOptions()) ?>;
fl_receiptedit.lists["x_d_id"] = <?php echo $l_receipt_edit->d_id->Lookup->toClientList() ?>;
fl_receiptedit.lists["x_d_id"].options = <?php echo JsonEncode($l_receipt_edit->d_id->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $l_receipt_edit->showPageHeader(); ?>
<?php
$l_receipt_edit->showMessage();
?>
<form name="fl_receiptedit" id="fl_receiptedit" class="<?php echo $l_receipt_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($l_receipt_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $l_receipt_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="l_receipt">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$l_receipt_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($l_receipt->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_l_receipt_id" for="x_id" class="<?php echo $l_receipt_edit->LeftColumnClass ?>"><?php echo $l_receipt->id->caption() ?><?php echo ($l_receipt->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $l_receipt_edit->RightColumnClass ?>"><div<?php echo $l_receipt->id->cellAttributes() ?>>
<span id="el_l_receipt_id">
<span<?php echo $l_receipt->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($l_receipt->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="l_receipt" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($l_receipt->id->CurrentValue) ?>">
<?php echo $l_receipt->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($l_receipt->r_from->Visible) { // r_from ?>
	<div id="r_r_from" class="form-group row">
		<label id="elh_l_receipt_r_from" class="<?php echo $l_receipt_edit->LeftColumnClass ?>"><?php echo $l_receipt->r_from->caption() ?><?php echo ($l_receipt->r_from->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $l_receipt_edit->RightColumnClass ?>"><div<?php echo $l_receipt->r_from->cellAttributes() ?>>
<span id="el_l_receipt_r_from">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$l_receipt->r_from->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$l_receipt->r_from->EditAttrs["onchange"] = "";
?>
<span id="as_x_r_from" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_r_from" id="sv_x_r_from" value="<?php echo RemoveHtml($l_receipt->r_from->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($l_receipt->r_from->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($l_receipt->r_from->getPlaceHolder()) ?>"<?php echo $l_receipt->r_from->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($l_receipt->r_from->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_r_from',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($l_receipt->r_from->ReadOnly || $l_receipt->r_from->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="l_receipt" data-field="x_r_from" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $l_receipt->r_from->displayValueSeparatorAttribute() ?>" name="x_r_from" id="x_r_from" value="<?php echo HtmlEncode($l_receipt->r_from->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fl_receiptedit.createAutoSuggest({"id":"x_r_from","forceSelect":true});
</script>
<?php echo $l_receipt->r_from->Lookup->getParamTag("p_x_r_from") ?>
</span>
<?php echo $l_receipt->r_from->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($l_receipt->r_to->Visible) { // r_to ?>
	<div id="r_r_to" class="form-group row">
		<label id="elh_l_receipt_r_to" class="<?php echo $l_receipt_edit->LeftColumnClass ?>"><?php echo $l_receipt->r_to->caption() ?><?php echo ($l_receipt->r_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $l_receipt_edit->RightColumnClass ?>"><div<?php echo $l_receipt->r_to->cellAttributes() ?>>
<span id="el_l_receipt_r_to">
<div id="tp_x_r_to" class="ew-template"><input type="radio" class="form-check-input" data-table="l_receipt" data-field="x_r_to" data-value-separator="<?php echo $l_receipt->r_to->displayValueSeparatorAttribute() ?>" name="x_r_to" id="x_r_to" value="{value}"<?php echo $l_receipt->r_to->editAttributes() ?>></div>
<div id="dsl_x_r_to" data-repeatcolumn="2" class="ew-item-list d-none"><div>
<?php echo $l_receipt->r_to->radioButtonListHtml(FALSE, "x_r_to") ?>
</div></div>
<?php echo $l_receipt->r_to->Lookup->getParamTag("p_x_r_to") ?>
</span>
<?php echo $l_receipt->r_to->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($l_receipt->d_id->Visible) { // d_id ?>
	<div id="r_d_id" class="form-group row">
		<label id="elh_l_receipt_d_id" class="<?php echo $l_receipt_edit->LeftColumnClass ?>"><?php echo $l_receipt->d_id->caption() ?><?php echo ($l_receipt->d_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $l_receipt_edit->RightColumnClass ?>"><div<?php echo $l_receipt->d_id->cellAttributes() ?>>
<span id="el_l_receipt_d_id">
<div id="tp_x_d_id" class="ew-template"><input type="radio" class="form-check-input" data-table="l_receipt" data-field="x_d_id" data-value-separator="<?php echo $l_receipt->d_id->displayValueSeparatorAttribute() ?>" name="x_d_id" id="x_d_id" value="{value}"<?php echo $l_receipt->d_id->editAttributes() ?>></div>
<div id="dsl_x_d_id" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $l_receipt->d_id->radioButtonListHtml(FALSE, "x_d_id") ?>
</div></div>
<?php echo $l_receipt->d_id->Lookup->getParamTag("p_x_d_id") ?>
</span>
<?php echo $l_receipt->d_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($l_receipt->total_amount->Visible) { // total_amount ?>
	<div id="r_total_amount" class="form-group row">
		<label id="elh_l_receipt_total_amount" for="x_total_amount" class="<?php echo $l_receipt_edit->LeftColumnClass ?>"><?php echo $l_receipt->total_amount->caption() ?><?php echo ($l_receipt->total_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $l_receipt_edit->RightColumnClass ?>"><div<?php echo $l_receipt->total_amount->cellAttributes() ?>>
<span id="el_l_receipt_total_amount">
<input type="text" data-table="l_receipt" data-field="x_total_amount" name="x_total_amount" id="x_total_amount" size="30" placeholder="<?php echo HtmlEncode($l_receipt->total_amount->getPlaceHolder()) ?>" value="<?php echo $l_receipt->total_amount->EditValue ?>"<?php echo $l_receipt->total_amount->editAttributes() ?>>
</span>
<?php echo $l_receipt->total_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($l_receipt->discount_amount->Visible) { // discount_amount ?>
	<div id="r_discount_amount" class="form-group row">
		<label id="elh_l_receipt_discount_amount" for="x_discount_amount" class="<?php echo $l_receipt_edit->LeftColumnClass ?>"><?php echo $l_receipt->discount_amount->caption() ?><?php echo ($l_receipt->discount_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $l_receipt_edit->RightColumnClass ?>"><div<?php echo $l_receipt->discount_amount->cellAttributes() ?>>
<span id="el_l_receipt_discount_amount">
<input type="text" data-table="l_receipt" data-field="x_discount_amount" name="x_discount_amount" id="x_discount_amount" size="30" placeholder="<?php echo HtmlEncode($l_receipt->discount_amount->getPlaceHolder()) ?>" value="<?php echo $l_receipt->discount_amount->EditValue ?>"<?php echo $l_receipt->discount_amount->editAttributes() ?>>
</span>
<?php echo $l_receipt->discount_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($l_receipt->receipt_amount->Visible) { // receipt_amount ?>
	<div id="r_receipt_amount" class="form-group row">
		<label id="elh_l_receipt_receipt_amount" for="x_receipt_amount" class="<?php echo $l_receipt_edit->LeftColumnClass ?>"><?php echo $l_receipt->receipt_amount->caption() ?><?php echo ($l_receipt->receipt_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $l_receipt_edit->RightColumnClass ?>"><div<?php echo $l_receipt->receipt_amount->cellAttributes() ?>>
<span id="el_l_receipt_receipt_amount">
<input type="text" data-table="l_receipt" data-field="x_receipt_amount" name="x_receipt_amount" id="x_receipt_amount" size="30" placeholder="<?php echo HtmlEncode($l_receipt->receipt_amount->getPlaceHolder()) ?>" value="<?php echo $l_receipt->receipt_amount->EditValue ?>"<?php echo $l_receipt->receipt_amount->editAttributes() ?>>
</span>
<?php echo $l_receipt->receipt_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($l_receipt->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_l_receipt_dated" for="x_dated" class="<?php echo $l_receipt_edit->LeftColumnClass ?>"><?php echo $l_receipt->dated->caption() ?><?php echo ($l_receipt->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $l_receipt_edit->RightColumnClass ?>"><div<?php echo $l_receipt->dated->cellAttributes() ?>>
<span id="el_l_receipt_dated">
<input type="text" data-table="l_receipt" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($l_receipt->dated->getPlaceHolder()) ?>" value="<?php echo $l_receipt->dated->EditValue ?>"<?php echo $l_receipt->dated->editAttributes() ?>>
<?php if (!$l_receipt->dated->ReadOnly && !$l_receipt->dated->Disabled && !isset($l_receipt->dated->EditAttrs["readonly"]) && !isset($l_receipt->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fl_receiptedit", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $l_receipt->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($l_receipt->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_l_receipt_remarks" for="x_remarks" class="<?php echo $l_receipt_edit->LeftColumnClass ?>"><?php echo $l_receipt->remarks->caption() ?><?php echo ($l_receipt->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $l_receipt_edit->RightColumnClass ?>"><div<?php echo $l_receipt->remarks->cellAttributes() ?>>
<span id="el_l_receipt_remarks">
<input type="text" data-table="l_receipt" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($l_receipt->remarks->getPlaceHolder()) ?>" value="<?php echo $l_receipt->remarks->EditValue ?>"<?php echo $l_receipt->remarks->editAttributes() ?>>
</span>
<?php echo $l_receipt->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($l_receipt->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label id="elh_l_receipt_uploads" class="<?php echo $l_receipt_edit->LeftColumnClass ?>"><?php echo $l_receipt->uploads->caption() ?><?php echo ($l_receipt->uploads->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $l_receipt_edit->RightColumnClass ?>"><div<?php echo $l_receipt->uploads->cellAttributes() ?>>
<span id="el_l_receipt_uploads">
<div id="fd_x_uploads">
<span title="<?php echo $l_receipt->uploads->title() ? $l_receipt->uploads->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($l_receipt->uploads->ReadOnly || $l_receipt->uploads->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="l_receipt" data-field="x_uploads" name="x_uploads" id="x_uploads"<?php echo $l_receipt->uploads->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?php echo $l_receipt->uploads->Upload->FileName ?>">
<?php if (Post("fa_x_uploads") == "0") { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="1">
<?php } ?>
<input type="hidden" name="fs_x_uploads" id= "fs_x_uploads" value="255">
<input type="hidden" name="fx_x_uploads" id= "fx_x_uploads" value="<?php echo $l_receipt->uploads->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_uploads" id= "fm_x_uploads" value="<?php echo $l_receipt->uploads->UploadMaxFileSize ?>">
</div>
<table id="ft_x_uploads" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $l_receipt->uploads->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$l_receipt_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $l_receipt_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $l_receipt_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$l_receipt_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$l_receipt_edit->terminate();
?>