<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$l_receipt_list = new l_receipt_list();

// Run the page
$l_receipt_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$l_receipt_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$l_receipt->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fl_receiptlist = currentForm = new ew.Form("fl_receiptlist", "list");
fl_receiptlist.formKeyCountName = '<?php echo $l_receipt_list->FormKeyCountName ?>';

// Form_CustomValidate event
fl_receiptlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fl_receiptlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fl_receiptlist.lists["x_r_from"] = <?php echo $l_receipt_list->r_from->Lookup->toClientList() ?>;
fl_receiptlist.lists["x_r_from"].options = <?php echo JsonEncode($l_receipt_list->r_from->lookupOptions()) ?>;
fl_receiptlist.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fl_receiptlist.lists["x_r_to"] = <?php echo $l_receipt_list->r_to->Lookup->toClientList() ?>;
fl_receiptlist.lists["x_r_to"].options = <?php echo JsonEncode($l_receipt_list->r_to->lookupOptions()) ?>;
fl_receiptlist.lists["x_d_id"] = <?php echo $l_receipt_list->d_id->Lookup->toClientList() ?>;
fl_receiptlist.lists["x_d_id"].options = <?php echo JsonEncode($l_receipt_list->d_id->lookupOptions()) ?>;

// Form object for search
var fl_receiptlistsrch = currentSearchForm = new ew.Form("fl_receiptlistsrch");

// Filters
fl_receiptlistsrch.filterList = <?php echo $l_receipt_list->getFilterList() ?>;

// Init search panel as collapsed
fl_receiptlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$l_receipt->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($l_receipt_list->TotalRecs > 0 && $l_receipt_list->ExportOptions->visible()) { ?>
<?php $l_receipt_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($l_receipt_list->ImportOptions->visible()) { ?>
<?php $l_receipt_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($l_receipt_list->SearchOptions->visible()) { ?>
<?php $l_receipt_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($l_receipt_list->FilterOptions->visible()) { ?>
<?php $l_receipt_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$l_receipt_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$l_receipt->isExport() && !$l_receipt->CurrentAction) { ?>
<form name="fl_receiptlistsrch" id="fl_receiptlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($l_receipt_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fl_receiptlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="l_receipt">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($l_receipt_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($l_receipt_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $l_receipt_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($l_receipt_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($l_receipt_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($l_receipt_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($l_receipt_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $l_receipt_list->showPageHeader(); ?>
<?php
$l_receipt_list->showMessage();
?>
<?php if ($l_receipt_list->TotalRecs > 0 || $l_receipt->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($l_receipt_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> l_receipt">
<?php if (!$l_receipt->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$l_receipt->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($l_receipt_list->Pager)) $l_receipt_list->Pager = new PrevNextPager($l_receipt_list->StartRec, $l_receipt_list->DisplayRecs, $l_receipt_list->TotalRecs, $l_receipt_list->AutoHidePager) ?>
<?php if ($l_receipt_list->Pager->RecordCount > 0 && $l_receipt_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($l_receipt_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $l_receipt_list->pageUrl() ?>start=<?php echo $l_receipt_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($l_receipt_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $l_receipt_list->pageUrl() ?>start=<?php echo $l_receipt_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $l_receipt_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($l_receipt_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $l_receipt_list->pageUrl() ?>start=<?php echo $l_receipt_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($l_receipt_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $l_receipt_list->pageUrl() ?>start=<?php echo $l_receipt_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $l_receipt_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($l_receipt_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $l_receipt_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $l_receipt_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $l_receipt_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($l_receipt_list->TotalRecs > 0 && (!$l_receipt_list->AutoHidePageSizeSelector || $l_receipt_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="l_receipt">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($l_receipt_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($l_receipt_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($l_receipt_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($l_receipt_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($l_receipt_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($l_receipt->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $l_receipt_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fl_receiptlist" id="fl_receiptlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($l_receipt_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $l_receipt_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="l_receipt">
<div id="gmp_l_receipt" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($l_receipt_list->TotalRecs > 0 || $l_receipt->isGridEdit()) { ?>
<table id="tbl_l_receiptlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$l_receipt_list->RowType = ROWTYPE_HEADER;

// Render list options
$l_receipt_list->renderListOptions();

// Render list options (header, left)
$l_receipt_list->ListOptions->render("header", "left");
?>
<?php if ($l_receipt->id->Visible) { // id ?>
	<?php if ($l_receipt->sortUrl($l_receipt->id) == "") { ?>
		<th data-name="id" class="<?php echo $l_receipt->id->headerCellClass() ?>"><div id="elh_l_receipt_id" class="l_receipt_id"><div class="ew-table-header-caption"><?php echo $l_receipt->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $l_receipt->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_receipt->SortUrl($l_receipt->id) ?>',2);"><div id="elh_l_receipt_id" class="l_receipt_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_receipt->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_receipt->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_receipt->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_receipt->r_from->Visible) { // r_from ?>
	<?php if ($l_receipt->sortUrl($l_receipt->r_from) == "") { ?>
		<th data-name="r_from" class="<?php echo $l_receipt->r_from->headerCellClass() ?>"><div id="elh_l_receipt_r_from" class="l_receipt_r_from"><div class="ew-table-header-caption"><?php echo $l_receipt->r_from->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="r_from" class="<?php echo $l_receipt->r_from->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_receipt->SortUrl($l_receipt->r_from) ?>',2);"><div id="elh_l_receipt_r_from" class="l_receipt_r_from">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_receipt->r_from->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_receipt->r_from->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_receipt->r_from->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_receipt->r_to->Visible) { // r_to ?>
	<?php if ($l_receipt->sortUrl($l_receipt->r_to) == "") { ?>
		<th data-name="r_to" class="<?php echo $l_receipt->r_to->headerCellClass() ?>"><div id="elh_l_receipt_r_to" class="l_receipt_r_to"><div class="ew-table-header-caption"><?php echo $l_receipt->r_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="r_to" class="<?php echo $l_receipt->r_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_receipt->SortUrl($l_receipt->r_to) ?>',2);"><div id="elh_l_receipt_r_to" class="l_receipt_r_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_receipt->r_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_receipt->r_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_receipt->r_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_receipt->d_id->Visible) { // d_id ?>
	<?php if ($l_receipt->sortUrl($l_receipt->d_id) == "") { ?>
		<th data-name="d_id" class="<?php echo $l_receipt->d_id->headerCellClass() ?>"><div id="elh_l_receipt_d_id" class="l_receipt_d_id"><div class="ew-table-header-caption"><?php echo $l_receipt->d_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_id" class="<?php echo $l_receipt->d_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_receipt->SortUrl($l_receipt->d_id) ?>',2);"><div id="elh_l_receipt_d_id" class="l_receipt_d_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_receipt->d_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_receipt->d_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_receipt->d_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_receipt->total_amount->Visible) { // total_amount ?>
	<?php if ($l_receipt->sortUrl($l_receipt->total_amount) == "") { ?>
		<th data-name="total_amount" class="<?php echo $l_receipt->total_amount->headerCellClass() ?>"><div id="elh_l_receipt_total_amount" class="l_receipt_total_amount"><div class="ew-table-header-caption"><?php echo $l_receipt->total_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="total_amount" class="<?php echo $l_receipt->total_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_receipt->SortUrl($l_receipt->total_amount) ?>',2);"><div id="elh_l_receipt_total_amount" class="l_receipt_total_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_receipt->total_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_receipt->total_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_receipt->total_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_receipt->discount_amount->Visible) { // discount_amount ?>
	<?php if ($l_receipt->sortUrl($l_receipt->discount_amount) == "") { ?>
		<th data-name="discount_amount" class="<?php echo $l_receipt->discount_amount->headerCellClass() ?>"><div id="elh_l_receipt_discount_amount" class="l_receipt_discount_amount"><div class="ew-table-header-caption"><?php echo $l_receipt->discount_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="discount_amount" class="<?php echo $l_receipt->discount_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_receipt->SortUrl($l_receipt->discount_amount) ?>',2);"><div id="elh_l_receipt_discount_amount" class="l_receipt_discount_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_receipt->discount_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_receipt->discount_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_receipt->discount_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_receipt->receipt_amount->Visible) { // receipt_amount ?>
	<?php if ($l_receipt->sortUrl($l_receipt->receipt_amount) == "") { ?>
		<th data-name="receipt_amount" class="<?php echo $l_receipt->receipt_amount->headerCellClass() ?>"><div id="elh_l_receipt_receipt_amount" class="l_receipt_receipt_amount"><div class="ew-table-header-caption"><?php echo $l_receipt->receipt_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="receipt_amount" class="<?php echo $l_receipt->receipt_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_receipt->SortUrl($l_receipt->receipt_amount) ?>',2);"><div id="elh_l_receipt_receipt_amount" class="l_receipt_receipt_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_receipt->receipt_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_receipt->receipt_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_receipt->receipt_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_receipt->dated->Visible) { // dated ?>
	<?php if ($l_receipt->sortUrl($l_receipt->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $l_receipt->dated->headerCellClass() ?>"><div id="elh_l_receipt_dated" class="l_receipt_dated"><div class="ew-table-header-caption"><?php echo $l_receipt->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $l_receipt->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_receipt->SortUrl($l_receipt->dated) ?>',2);"><div id="elh_l_receipt_dated" class="l_receipt_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_receipt->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_receipt->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_receipt->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_receipt->remarks->Visible) { // remarks ?>
	<?php if ($l_receipt->sortUrl($l_receipt->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $l_receipt->remarks->headerCellClass() ?>"><div id="elh_l_receipt_remarks" class="l_receipt_remarks"><div class="ew-table-header-caption"><?php echo $l_receipt->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $l_receipt->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_receipt->SortUrl($l_receipt->remarks) ?>',2);"><div id="elh_l_receipt_remarks" class="l_receipt_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_receipt->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($l_receipt->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_receipt->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_receipt->uploads->Visible) { // uploads ?>
	<?php if ($l_receipt->sortUrl($l_receipt->uploads) == "") { ?>
		<th data-name="uploads" class="<?php echo $l_receipt->uploads->headerCellClass() ?>"><div id="elh_l_receipt_uploads" class="l_receipt_uploads"><div class="ew-table-header-caption"><?php echo $l_receipt->uploads->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="uploads" class="<?php echo $l_receipt->uploads->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_receipt->SortUrl($l_receipt->uploads) ?>',2);"><div id="elh_l_receipt_uploads" class="l_receipt_uploads">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_receipt->uploads->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($l_receipt->uploads->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_receipt->uploads->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_receipt->operator->Visible) { // operator ?>
	<?php if ($l_receipt->sortUrl($l_receipt->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $l_receipt->operator->headerCellClass() ?>"><div id="elh_l_receipt_operator" class="l_receipt_operator"><div class="ew-table-header-caption"><?php echo $l_receipt->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $l_receipt->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_receipt->SortUrl($l_receipt->operator) ?>',2);"><div id="elh_l_receipt_operator" class="l_receipt_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_receipt->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_receipt->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_receipt->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_receipt->datetime->Visible) { // datetime ?>
	<?php if ($l_receipt->sortUrl($l_receipt->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $l_receipt->datetime->headerCellClass() ?>"><div id="elh_l_receipt_datetime" class="l_receipt_datetime"><div class="ew-table-header-caption"><?php echo $l_receipt->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $l_receipt->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_receipt->SortUrl($l_receipt->datetime) ?>',2);"><div id="elh_l_receipt_datetime" class="l_receipt_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_receipt->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_receipt->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_receipt->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$l_receipt_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($l_receipt->ExportAll && $l_receipt->isExport()) {
	$l_receipt_list->StopRec = $l_receipt_list->TotalRecs;
} else {

	// Set the last record to display
	if ($l_receipt_list->TotalRecs > $l_receipt_list->StartRec + $l_receipt_list->DisplayRecs - 1)
		$l_receipt_list->StopRec = $l_receipt_list->StartRec + $l_receipt_list->DisplayRecs - 1;
	else
		$l_receipt_list->StopRec = $l_receipt_list->TotalRecs;
}
$l_receipt_list->RecCnt = $l_receipt_list->StartRec - 1;
if ($l_receipt_list->Recordset && !$l_receipt_list->Recordset->EOF) {
	$l_receipt_list->Recordset->moveFirst();
	$selectLimit = $l_receipt_list->UseSelectLimit;
	if (!$selectLimit && $l_receipt_list->StartRec > 1)
		$l_receipt_list->Recordset->move($l_receipt_list->StartRec - 1);
} elseif (!$l_receipt->AllowAddDeleteRow && $l_receipt_list->StopRec == 0) {
	$l_receipt_list->StopRec = $l_receipt->GridAddRowCount;
}

// Initialize aggregate
$l_receipt->RowType = ROWTYPE_AGGREGATEINIT;
$l_receipt->resetAttributes();
$l_receipt_list->renderRow();
while ($l_receipt_list->RecCnt < $l_receipt_list->StopRec) {
	$l_receipt_list->RecCnt++;
	if ($l_receipt_list->RecCnt >= $l_receipt_list->StartRec) {
		$l_receipt_list->RowCnt++;

		// Set up key count
		$l_receipt_list->KeyCount = $l_receipt_list->RowIndex;

		// Init row class and style
		$l_receipt->resetAttributes();
		$l_receipt->CssClass = "";
		if ($l_receipt->isGridAdd()) {
		} else {
			$l_receipt_list->loadRowValues($l_receipt_list->Recordset); // Load row values
		}
		$l_receipt->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$l_receipt->RowAttrs = array_merge($l_receipt->RowAttrs, array('data-rowindex'=>$l_receipt_list->RowCnt, 'id'=>'r' . $l_receipt_list->RowCnt . '_l_receipt', 'data-rowtype'=>$l_receipt->RowType));

		// Render row
		$l_receipt_list->renderRow();

		// Render list options
		$l_receipt_list->renderListOptions();
?>
	<tr<?php echo $l_receipt->rowAttributes() ?>>
<?php

// Render list options (body, left)
$l_receipt_list->ListOptions->render("body", "left", $l_receipt_list->RowCnt);
?>
	<?php if ($l_receipt->id->Visible) { // id ?>
		<td data-name="id"<?php echo $l_receipt->id->cellAttributes() ?>>
<span id="el<?php echo $l_receipt_list->RowCnt ?>_l_receipt_id" class="l_receipt_id">
<span<?php echo $l_receipt->id->viewAttributes() ?>>
<?php echo $l_receipt->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_receipt->r_from->Visible) { // r_from ?>
		<td data-name="r_from"<?php echo $l_receipt->r_from->cellAttributes() ?>>
<span id="el<?php echo $l_receipt_list->RowCnt ?>_l_receipt_r_from" class="l_receipt_r_from">
<span<?php echo $l_receipt->r_from->viewAttributes() ?>>
<?php echo $l_receipt->r_from->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_receipt->r_to->Visible) { // r_to ?>
		<td data-name="r_to"<?php echo $l_receipt->r_to->cellAttributes() ?>>
<span id="el<?php echo $l_receipt_list->RowCnt ?>_l_receipt_r_to" class="l_receipt_r_to">
<span<?php echo $l_receipt->r_to->viewAttributes() ?>>
<?php echo $l_receipt->r_to->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_receipt->d_id->Visible) { // d_id ?>
		<td data-name="d_id"<?php echo $l_receipt->d_id->cellAttributes() ?>>
<span id="el<?php echo $l_receipt_list->RowCnt ?>_l_receipt_d_id" class="l_receipt_d_id">
<span<?php echo $l_receipt->d_id->viewAttributes() ?>>
<?php echo $l_receipt->d_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_receipt->total_amount->Visible) { // total_amount ?>
		<td data-name="total_amount"<?php echo $l_receipt->total_amount->cellAttributes() ?>>
<span id="el<?php echo $l_receipt_list->RowCnt ?>_l_receipt_total_amount" class="l_receipt_total_amount">
<span<?php echo $l_receipt->total_amount->viewAttributes() ?>>
<?php echo $l_receipt->total_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_receipt->discount_amount->Visible) { // discount_amount ?>
		<td data-name="discount_amount"<?php echo $l_receipt->discount_amount->cellAttributes() ?>>
<span id="el<?php echo $l_receipt_list->RowCnt ?>_l_receipt_discount_amount" class="l_receipt_discount_amount">
<span<?php echo $l_receipt->discount_amount->viewAttributes() ?>>
<?php echo $l_receipt->discount_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_receipt->receipt_amount->Visible) { // receipt_amount ?>
		<td data-name="receipt_amount"<?php echo $l_receipt->receipt_amount->cellAttributes() ?>>
<span id="el<?php echo $l_receipt_list->RowCnt ?>_l_receipt_receipt_amount" class="l_receipt_receipt_amount">
<span<?php echo $l_receipt->receipt_amount->viewAttributes() ?>>
<?php echo $l_receipt->receipt_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_receipt->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $l_receipt->dated->cellAttributes() ?>>
<span id="el<?php echo $l_receipt_list->RowCnt ?>_l_receipt_dated" class="l_receipt_dated">
<span<?php echo $l_receipt->dated->viewAttributes() ?>>
<?php echo $l_receipt->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_receipt->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $l_receipt->remarks->cellAttributes() ?>>
<span id="el<?php echo $l_receipt_list->RowCnt ?>_l_receipt_remarks" class="l_receipt_remarks">
<span<?php echo $l_receipt->remarks->viewAttributes() ?>>
<?php echo $l_receipt->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_receipt->uploads->Visible) { // uploads ?>
		<td data-name="uploads"<?php echo $l_receipt->uploads->cellAttributes() ?>>
<span id="el<?php echo $l_receipt_list->RowCnt ?>_l_receipt_uploads" class="l_receipt_uploads">
<span>
<?php echo GetFileViewTag($l_receipt->uploads, $l_receipt->uploads->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($l_receipt->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $l_receipt->operator->cellAttributes() ?>>
<span id="el<?php echo $l_receipt_list->RowCnt ?>_l_receipt_operator" class="l_receipt_operator">
<span<?php echo $l_receipt->operator->viewAttributes() ?>>
<?php echo $l_receipt->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_receipt->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $l_receipt->datetime->cellAttributes() ?>>
<span id="el<?php echo $l_receipt_list->RowCnt ?>_l_receipt_datetime" class="l_receipt_datetime">
<span<?php echo $l_receipt->datetime->viewAttributes() ?>>
<?php echo $l_receipt->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$l_receipt_list->ListOptions->render("body", "right", $l_receipt_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$l_receipt->isGridAdd())
		$l_receipt_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$l_receipt->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($l_receipt_list->Recordset)
	$l_receipt_list->Recordset->Close();
?>
<?php if (!$l_receipt->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$l_receipt->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($l_receipt_list->Pager)) $l_receipt_list->Pager = new PrevNextPager($l_receipt_list->StartRec, $l_receipt_list->DisplayRecs, $l_receipt_list->TotalRecs, $l_receipt_list->AutoHidePager) ?>
<?php if ($l_receipt_list->Pager->RecordCount > 0 && $l_receipt_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($l_receipt_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $l_receipt_list->pageUrl() ?>start=<?php echo $l_receipt_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($l_receipt_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $l_receipt_list->pageUrl() ?>start=<?php echo $l_receipt_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $l_receipt_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($l_receipt_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $l_receipt_list->pageUrl() ?>start=<?php echo $l_receipt_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($l_receipt_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $l_receipt_list->pageUrl() ?>start=<?php echo $l_receipt_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $l_receipt_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($l_receipt_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $l_receipt_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $l_receipt_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $l_receipt_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($l_receipt_list->TotalRecs > 0 && (!$l_receipt_list->AutoHidePageSizeSelector || $l_receipt_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="l_receipt">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($l_receipt_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($l_receipt_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($l_receipt_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($l_receipt_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($l_receipt_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($l_receipt->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $l_receipt_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($l_receipt_list->TotalRecs == 0 && !$l_receipt->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $l_receipt_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$l_receipt_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$l_receipt->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$l_receipt->isExport()) { ?>
<script>
ew.scrollableTable("gmp_l_receipt", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$l_receipt_list->terminate();
?>