<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$l_receipt_search = new l_receipt_search();

// Run the page
$l_receipt_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$l_receipt_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($l_receipt_search->IsModal) { ?>
var fl_receiptsearch = currentAdvancedSearchForm = new ew.Form("fl_receiptsearch", "search");
<?php } else { ?>
var fl_receiptsearch = currentForm = new ew.Form("fl_receiptsearch", "search");
<?php } ?>

// Form_CustomValidate event
fl_receiptsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fl_receiptsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fl_receiptsearch.lists["x_r_from"] = <?php echo $l_receipt_search->r_from->Lookup->toClientList() ?>;
fl_receiptsearch.lists["x_r_from"].options = <?php echo JsonEncode($l_receipt_search->r_from->lookupOptions()) ?>;
fl_receiptsearch.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fl_receiptsearch.lists["x_d_id"] = <?php echo $l_receipt_search->d_id->Lookup->toClientList() ?>;
fl_receiptsearch.lists["x_d_id"].options = <?php echo JsonEncode($l_receipt_search->d_id->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fl_receiptsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($l_receipt->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_total_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($l_receipt->total_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_discount_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($l_receipt->discount_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_receipt_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($l_receipt->receipt_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($l_receipt->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($l_receipt->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($l_receipt->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $l_receipt_search->showPageHeader(); ?>
<?php
$l_receipt_search->showMessage();
?>
<form name="fl_receiptsearch" id="fl_receiptsearch" class="<?php echo $l_receipt_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($l_receipt_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $l_receipt_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="l_receipt">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$l_receipt_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($l_receipt->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $l_receipt_search->LeftColumnClass ?>"><span id="elh_l_receipt_id"><?php echo $l_receipt->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $l_receipt_search->RightColumnClass ?>"><div<?php echo $l_receipt->id->cellAttributes() ?>>
			<span id="el_l_receipt_id">
<input type="text" data-table="l_receipt" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($l_receipt->id->getPlaceHolder()) ?>" value="<?php echo $l_receipt->id->EditValue ?>"<?php echo $l_receipt->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_receipt->r_from->Visible) { // r_from ?>
	<div id="r_r_from" class="form-group row">
		<label class="<?php echo $l_receipt_search->LeftColumnClass ?>"><span id="elh_l_receipt_r_from"><?php echo $l_receipt->r_from->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_r_from" id="z_r_from" value="="></span>
		</label>
		<div class="<?php echo $l_receipt_search->RightColumnClass ?>"><div<?php echo $l_receipt->r_from->cellAttributes() ?>>
			<span id="el_l_receipt_r_from">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$l_receipt->r_from->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$l_receipt->r_from->EditAttrs["onchange"] = "";
?>
<span id="as_x_r_from" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_r_from" id="sv_x_r_from" value="<?php echo RemoveHtml($l_receipt->r_from->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($l_receipt->r_from->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($l_receipt->r_from->getPlaceHolder()) ?>"<?php echo $l_receipt->r_from->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($l_receipt->r_from->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_r_from',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($l_receipt->r_from->ReadOnly || $l_receipt->r_from->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="l_receipt" data-field="x_r_from" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $l_receipt->r_from->displayValueSeparatorAttribute() ?>" name="x_r_from" id="x_r_from" value="<?php echo HtmlEncode($l_receipt->r_from->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fl_receiptsearch.createAutoSuggest({"id":"x_r_from","forceSelect":true});
</script>
<?php echo $l_receipt->r_from->Lookup->getParamTag("p_x_r_from") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_receipt->d_id->Visible) { // d_id ?>
	<div id="r_d_id" class="form-group row">
		<label class="<?php echo $l_receipt_search->LeftColumnClass ?>"><span id="elh_l_receipt_d_id"><?php echo $l_receipt->d_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_id" id="z_d_id" value="="></span>
		</label>
		<div class="<?php echo $l_receipt_search->RightColumnClass ?>"><div<?php echo $l_receipt->d_id->cellAttributes() ?>>
			<span id="el_l_receipt_d_id">
<div id="tp_x_d_id" class="ew-template"><input type="radio" class="form-check-input" data-table="l_receipt" data-field="x_d_id" data-value-separator="<?php echo $l_receipt->d_id->displayValueSeparatorAttribute() ?>" name="x_d_id" id="x_d_id" value="{value}"<?php echo $l_receipt->d_id->editAttributes() ?>></div>
<div id="dsl_x_d_id" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $l_receipt->d_id->radioButtonListHtml(FALSE, "x_d_id") ?>
</div></div>
<?php echo $l_receipt->d_id->Lookup->getParamTag("p_x_d_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_receipt->total_amount->Visible) { // total_amount ?>
	<div id="r_total_amount" class="form-group row">
		<label for="x_total_amount" class="<?php echo $l_receipt_search->LeftColumnClass ?>"><span id="elh_l_receipt_total_amount"><?php echo $l_receipt->total_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_total_amount" id="z_total_amount" value="="></span>
		</label>
		<div class="<?php echo $l_receipt_search->RightColumnClass ?>"><div<?php echo $l_receipt->total_amount->cellAttributes() ?>>
			<span id="el_l_receipt_total_amount">
<input type="text" data-table="l_receipt" data-field="x_total_amount" name="x_total_amount" id="x_total_amount" size="30" placeholder="<?php echo HtmlEncode($l_receipt->total_amount->getPlaceHolder()) ?>" value="<?php echo $l_receipt->total_amount->EditValue ?>"<?php echo $l_receipt->total_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_receipt->discount_amount->Visible) { // discount_amount ?>
	<div id="r_discount_amount" class="form-group row">
		<label for="x_discount_amount" class="<?php echo $l_receipt_search->LeftColumnClass ?>"><span id="elh_l_receipt_discount_amount"><?php echo $l_receipt->discount_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_discount_amount" id="z_discount_amount" value="="></span>
		</label>
		<div class="<?php echo $l_receipt_search->RightColumnClass ?>"><div<?php echo $l_receipt->discount_amount->cellAttributes() ?>>
			<span id="el_l_receipt_discount_amount">
<input type="text" data-table="l_receipt" data-field="x_discount_amount" name="x_discount_amount" id="x_discount_amount" size="30" placeholder="<?php echo HtmlEncode($l_receipt->discount_amount->getPlaceHolder()) ?>" value="<?php echo $l_receipt->discount_amount->EditValue ?>"<?php echo $l_receipt->discount_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_receipt->receipt_amount->Visible) { // receipt_amount ?>
	<div id="r_receipt_amount" class="form-group row">
		<label for="x_receipt_amount" class="<?php echo $l_receipt_search->LeftColumnClass ?>"><span id="elh_l_receipt_receipt_amount"><?php echo $l_receipt->receipt_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_receipt_amount" id="z_receipt_amount" value="="></span>
		</label>
		<div class="<?php echo $l_receipt_search->RightColumnClass ?>"><div<?php echo $l_receipt->receipt_amount->cellAttributes() ?>>
			<span id="el_l_receipt_receipt_amount">
<input type="text" data-table="l_receipt" data-field="x_receipt_amount" name="x_receipt_amount" id="x_receipt_amount" size="30" placeholder="<?php echo HtmlEncode($l_receipt->receipt_amount->getPlaceHolder()) ?>" value="<?php echo $l_receipt->receipt_amount->EditValue ?>"<?php echo $l_receipt->receipt_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_receipt->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $l_receipt_search->LeftColumnClass ?>"><span id="elh_l_receipt_dated"><?php echo $l_receipt->dated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_dated" id="z_dated" value="="></span>
		</label>
		<div class="<?php echo $l_receipt_search->RightColumnClass ?>"><div<?php echo $l_receipt->dated->cellAttributes() ?>>
			<span id="el_l_receipt_dated">
<input type="text" data-table="l_receipt" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($l_receipt->dated->getPlaceHolder()) ?>" value="<?php echo $l_receipt->dated->EditValue ?>"<?php echo $l_receipt->dated->editAttributes() ?>>
<?php if (!$l_receipt->dated->ReadOnly && !$l_receipt->dated->Disabled && !isset($l_receipt->dated->EditAttrs["readonly"]) && !isset($l_receipt->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fl_receiptsearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_receipt->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $l_receipt_search->LeftColumnClass ?>"><span id="elh_l_receipt_remarks"><?php echo $l_receipt->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $l_receipt_search->RightColumnClass ?>"><div<?php echo $l_receipt->remarks->cellAttributes() ?>>
			<span id="el_l_receipt_remarks">
<input type="text" data-table="l_receipt" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($l_receipt->remarks->getPlaceHolder()) ?>" value="<?php echo $l_receipt->remarks->EditValue ?>"<?php echo $l_receipt->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_receipt->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label class="<?php echo $l_receipt_search->LeftColumnClass ?>"><span id="elh_l_receipt_uploads"><?php echo $l_receipt->uploads->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_uploads" id="z_uploads" value="LIKE"></span>
		</label>
		<div class="<?php echo $l_receipt_search->RightColumnClass ?>"><div<?php echo $l_receipt->uploads->cellAttributes() ?>>
			<span id="el_l_receipt_uploads">
<input type="text" data-table="l_receipt" data-field="x_uploads" name="x_uploads" id="x_uploads" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($l_receipt->uploads->getPlaceHolder()) ?>" value="<?php echo $l_receipt->uploads->EditValue ?>"<?php echo $l_receipt->uploads->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_receipt->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $l_receipt_search->LeftColumnClass ?>"><span id="elh_l_receipt_operator"><?php echo $l_receipt->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $l_receipt_search->RightColumnClass ?>"><div<?php echo $l_receipt->operator->cellAttributes() ?>>
			<span id="el_l_receipt_operator">
<input type="text" data-table="l_receipt" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($l_receipt->operator->getPlaceHolder()) ?>" value="<?php echo $l_receipt->operator->EditValue ?>"<?php echo $l_receipt->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($l_receipt->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $l_receipt_search->LeftColumnClass ?>"><span id="elh_l_receipt_datetime"><?php echo $l_receipt->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $l_receipt_search->RightColumnClass ?>"><div<?php echo $l_receipt->datetime->cellAttributes() ?>>
			<span id="el_l_receipt_datetime">
<input type="text" data-table="l_receipt" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($l_receipt->datetime->getPlaceHolder()) ?>" value="<?php echo $l_receipt->datetime->EditValue ?>"<?php echo $l_receipt->datetime->editAttributes() ?>>
<?php if (!$l_receipt->datetime->ReadOnly && !$l_receipt->datetime->Disabled && !isset($l_receipt->datetime->EditAttrs["readonly"]) && !isset($l_receipt->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fl_receiptsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$l_receipt_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $l_receipt_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$l_receipt_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$l_receipt_search->terminate();
?>