<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$l_receipt_view = new l_receipt_view();

// Run the page
$l_receipt_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$l_receipt_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$l_receipt->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fl_receiptview = currentForm = new ew.Form("fl_receiptview", "view");

// Form_CustomValidate event
fl_receiptview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fl_receiptview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fl_receiptview.lists["x_r_from"] = <?php echo $l_receipt_view->r_from->Lookup->toClientList() ?>;
fl_receiptview.lists["x_r_from"].options = <?php echo JsonEncode($l_receipt_view->r_from->lookupOptions()) ?>;
fl_receiptview.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fl_receiptview.lists["x_r_to"] = <?php echo $l_receipt_view->r_to->Lookup->toClientList() ?>;
fl_receiptview.lists["x_r_to"].options = <?php echo JsonEncode($l_receipt_view->r_to->lookupOptions()) ?>;
fl_receiptview.lists["x_d_id"] = <?php echo $l_receipt_view->d_id->Lookup->toClientList() ?>;
fl_receiptview.lists["x_d_id"].options = <?php echo JsonEncode($l_receipt_view->d_id->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$l_receipt->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $l_receipt_view->ExportOptions->render("body") ?>
<?php $l_receipt_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $l_receipt_view->showPageHeader(); ?>
<?php
$l_receipt_view->showMessage();
?>
<form name="fl_receiptview" id="fl_receiptview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($l_receipt_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $l_receipt_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="l_receipt">
<input type="hidden" name="modal" value="<?php echo (int)$l_receipt_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($l_receipt->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $l_receipt_view->TableLeftColumnClass ?>"><span id="elh_l_receipt_id"><?php echo $l_receipt->id->caption() ?></span></td>
		<td data-name="id"<?php echo $l_receipt->id->cellAttributes() ?>>
<span id="el_l_receipt_id">
<span<?php echo $l_receipt->id->viewAttributes() ?>>
<?php echo $l_receipt->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_receipt->r_from->Visible) { // r_from ?>
	<tr id="r_r_from">
		<td class="<?php echo $l_receipt_view->TableLeftColumnClass ?>"><span id="elh_l_receipt_r_from"><?php echo $l_receipt->r_from->caption() ?></span></td>
		<td data-name="r_from"<?php echo $l_receipt->r_from->cellAttributes() ?>>
<span id="el_l_receipt_r_from">
<span<?php echo $l_receipt->r_from->viewAttributes() ?>>
<?php echo $l_receipt->r_from->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_receipt->r_to->Visible) { // r_to ?>
	<tr id="r_r_to">
		<td class="<?php echo $l_receipt_view->TableLeftColumnClass ?>"><span id="elh_l_receipt_r_to"><?php echo $l_receipt->r_to->caption() ?></span></td>
		<td data-name="r_to"<?php echo $l_receipt->r_to->cellAttributes() ?>>
<span id="el_l_receipt_r_to">
<span<?php echo $l_receipt->r_to->viewAttributes() ?>>
<?php echo $l_receipt->r_to->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_receipt->d_id->Visible) { // d_id ?>
	<tr id="r_d_id">
		<td class="<?php echo $l_receipt_view->TableLeftColumnClass ?>"><span id="elh_l_receipt_d_id"><?php echo $l_receipt->d_id->caption() ?></span></td>
		<td data-name="d_id"<?php echo $l_receipt->d_id->cellAttributes() ?>>
<span id="el_l_receipt_d_id">
<span<?php echo $l_receipt->d_id->viewAttributes() ?>>
<?php echo $l_receipt->d_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_receipt->total_amount->Visible) { // total_amount ?>
	<tr id="r_total_amount">
		<td class="<?php echo $l_receipt_view->TableLeftColumnClass ?>"><span id="elh_l_receipt_total_amount"><?php echo $l_receipt->total_amount->caption() ?></span></td>
		<td data-name="total_amount"<?php echo $l_receipt->total_amount->cellAttributes() ?>>
<span id="el_l_receipt_total_amount">
<span<?php echo $l_receipt->total_amount->viewAttributes() ?>>
<?php echo $l_receipt->total_amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_receipt->discount_amount->Visible) { // discount_amount ?>
	<tr id="r_discount_amount">
		<td class="<?php echo $l_receipt_view->TableLeftColumnClass ?>"><span id="elh_l_receipt_discount_amount"><?php echo $l_receipt->discount_amount->caption() ?></span></td>
		<td data-name="discount_amount"<?php echo $l_receipt->discount_amount->cellAttributes() ?>>
<span id="el_l_receipt_discount_amount">
<span<?php echo $l_receipt->discount_amount->viewAttributes() ?>>
<?php echo $l_receipt->discount_amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_receipt->receipt_amount->Visible) { // receipt_amount ?>
	<tr id="r_receipt_amount">
		<td class="<?php echo $l_receipt_view->TableLeftColumnClass ?>"><span id="elh_l_receipt_receipt_amount"><?php echo $l_receipt->receipt_amount->caption() ?></span></td>
		<td data-name="receipt_amount"<?php echo $l_receipt->receipt_amount->cellAttributes() ?>>
<span id="el_l_receipt_receipt_amount">
<span<?php echo $l_receipt->receipt_amount->viewAttributes() ?>>
<?php echo $l_receipt->receipt_amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_receipt->dated->Visible) { // dated ?>
	<tr id="r_dated">
		<td class="<?php echo $l_receipt_view->TableLeftColumnClass ?>"><span id="elh_l_receipt_dated"><?php echo $l_receipt->dated->caption() ?></span></td>
		<td data-name="dated"<?php echo $l_receipt->dated->cellAttributes() ?>>
<span id="el_l_receipt_dated">
<span<?php echo $l_receipt->dated->viewAttributes() ?>>
<?php echo $l_receipt->dated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_receipt->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $l_receipt_view->TableLeftColumnClass ?>"><span id="elh_l_receipt_remarks"><?php echo $l_receipt->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $l_receipt->remarks->cellAttributes() ?>>
<span id="el_l_receipt_remarks">
<span<?php echo $l_receipt->remarks->viewAttributes() ?>>
<?php echo $l_receipt->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_receipt->uploads->Visible) { // uploads ?>
	<tr id="r_uploads">
		<td class="<?php echo $l_receipt_view->TableLeftColumnClass ?>"><span id="elh_l_receipt_uploads"><?php echo $l_receipt->uploads->caption() ?></span></td>
		<td data-name="uploads"<?php echo $l_receipt->uploads->cellAttributes() ?>>
<span id="el_l_receipt_uploads">
<span>
<?php echo GetFileViewTag($l_receipt->uploads, $l_receipt->uploads->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_receipt->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $l_receipt_view->TableLeftColumnClass ?>"><span id="elh_l_receipt_operator"><?php echo $l_receipt->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $l_receipt->operator->cellAttributes() ?>>
<span id="el_l_receipt_operator">
<span<?php echo $l_receipt->operator->viewAttributes() ?>>
<?php echo $l_receipt->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($l_receipt->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $l_receipt_view->TableLeftColumnClass ?>"><span id="elh_l_receipt_datetime"><?php echo $l_receipt->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $l_receipt->datetime->cellAttributes() ?>>
<span id="el_l_receipt_datetime">
<span<?php echo $l_receipt->datetime->viewAttributes() ?>>
<?php echo $l_receipt->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$l_receipt_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$l_receipt->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$l_receipt_view->terminate();
?>