<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$l_referral_add = new l_referral_add();

// Run the page
$l_referral_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$l_referral_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fl_referraladd = currentForm = new ew.Form("fl_referraladd", "add");

// Validate form
fl_referraladd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($l_referral_add->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_referral->name->caption(), $l_referral->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($l_referral_add->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_referral->mobile->caption(), $l_referral->mobile->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($l_referral->mobile->errorMessage()) ?>");
		<?php if ($l_referral_add->max_discount->Required) { ?>
			elm = this.getElements("x" + infix + "_max_discount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_referral->max_discount->caption(), $l_referral->max_discount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_max_discount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($l_referral->max_discount->errorMessage()) ?>");
		<?php if ($l_referral_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_referral->remarks->caption(), $l_referral->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($l_referral_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_referral->operator->caption(), $l_referral->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($l_referral_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $l_referral->datetime->caption(), $l_referral->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fl_referraladd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fl_referraladd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $l_referral_add->showPageHeader(); ?>
<?php
$l_referral_add->showMessage();
?>
<form name="fl_referraladd" id="fl_referraladd" class="<?php echo $l_referral_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($l_referral_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $l_referral_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="l_referral">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$l_referral_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($l_referral->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label id="elh_l_referral_name" for="x_name" class="<?php echo $l_referral_add->LeftColumnClass ?>"><?php echo $l_referral->name->caption() ?><?php echo ($l_referral->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $l_referral_add->RightColumnClass ?>"><div<?php echo $l_referral->name->cellAttributes() ?>>
<span id="el_l_referral_name">
<input type="text" data-table="l_referral" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($l_referral->name->getPlaceHolder()) ?>" value="<?php echo $l_referral->name->EditValue ?>"<?php echo $l_referral->name->editAttributes() ?>>
</span>
<?php echo $l_referral->name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($l_referral->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label id="elh_l_referral_mobile" for="x_mobile" class="<?php echo $l_referral_add->LeftColumnClass ?>"><?php echo $l_referral->mobile->caption() ?><?php echo ($l_referral->mobile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $l_referral_add->RightColumnClass ?>"><div<?php echo $l_referral->mobile->cellAttributes() ?>>
<span id="el_l_referral_mobile">
<input type="text" data-table="l_referral" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" placeholder="<?php echo HtmlEncode($l_referral->mobile->getPlaceHolder()) ?>" value="<?php echo $l_referral->mobile->EditValue ?>"<?php echo $l_referral->mobile->editAttributes() ?>>
</span>
<?php echo $l_referral->mobile->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($l_referral->max_discount->Visible) { // max_discount ?>
	<div id="r_max_discount" class="form-group row">
		<label id="elh_l_referral_max_discount" for="x_max_discount" class="<?php echo $l_referral_add->LeftColumnClass ?>"><?php echo $l_referral->max_discount->caption() ?><?php echo ($l_referral->max_discount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $l_referral_add->RightColumnClass ?>"><div<?php echo $l_referral->max_discount->cellAttributes() ?>>
<span id="el_l_referral_max_discount">
<input type="text" data-table="l_referral" data-field="x_max_discount" name="x_max_discount" id="x_max_discount" size="30" placeholder="<?php echo HtmlEncode($l_referral->max_discount->getPlaceHolder()) ?>" value="<?php echo $l_referral->max_discount->EditValue ?>"<?php echo $l_referral->max_discount->editAttributes() ?>>
</span>
<?php echo $l_referral->max_discount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($l_referral->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_l_referral_remarks" for="x_remarks" class="<?php echo $l_referral_add->LeftColumnClass ?>"><?php echo $l_referral->remarks->caption() ?><?php echo ($l_referral->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $l_referral_add->RightColumnClass ?>"><div<?php echo $l_referral->remarks->cellAttributes() ?>>
<span id="el_l_referral_remarks">
<input type="text" data-table="l_referral" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($l_referral->remarks->getPlaceHolder()) ?>" value="<?php echo $l_referral->remarks->EditValue ?>"<?php echo $l_referral->remarks->editAttributes() ?>>
</span>
<?php echo $l_referral->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$l_referral_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $l_referral_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $l_referral_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$l_referral_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$l_referral_add->terminate();
?>