<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$l_referral_list = new l_referral_list();

// Run the page
$l_referral_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$l_referral_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$l_referral->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fl_referrallist = currentForm = new ew.Form("fl_referrallist", "list");
fl_referrallist.formKeyCountName = '<?php echo $l_referral_list->FormKeyCountName ?>';

// Form_CustomValidate event
fl_referrallist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fl_referrallist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fl_referrallistsrch = currentSearchForm = new ew.Form("fl_referrallistsrch");

// Filters
fl_referrallistsrch.filterList = <?php echo $l_referral_list->getFilterList() ?>;

// Init search panel as collapsed
fl_referrallistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$l_referral->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($l_referral_list->TotalRecs > 0 && $l_referral_list->ExportOptions->visible()) { ?>
<?php $l_referral_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($l_referral_list->ImportOptions->visible()) { ?>
<?php $l_referral_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($l_referral_list->SearchOptions->visible()) { ?>
<?php $l_referral_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($l_referral_list->FilterOptions->visible()) { ?>
<?php $l_referral_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$l_referral_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$l_referral->isExport() && !$l_referral->CurrentAction) { ?>
<form name="fl_referrallistsrch" id="fl_referrallistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($l_referral_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fl_referrallistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="l_referral">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($l_referral_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($l_referral_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $l_referral_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($l_referral_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($l_referral_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($l_referral_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($l_referral_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $l_referral_list->showPageHeader(); ?>
<?php
$l_referral_list->showMessage();
?>
<?php if ($l_referral_list->TotalRecs > 0 || $l_referral->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($l_referral_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> l_referral">
<?php if (!$l_referral->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$l_referral->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($l_referral_list->Pager)) $l_referral_list->Pager = new PrevNextPager($l_referral_list->StartRec, $l_referral_list->DisplayRecs, $l_referral_list->TotalRecs, $l_referral_list->AutoHidePager) ?>
<?php if ($l_referral_list->Pager->RecordCount > 0 && $l_referral_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($l_referral_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $l_referral_list->pageUrl() ?>start=<?php echo $l_referral_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($l_referral_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $l_referral_list->pageUrl() ?>start=<?php echo $l_referral_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $l_referral_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($l_referral_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $l_referral_list->pageUrl() ?>start=<?php echo $l_referral_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($l_referral_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $l_referral_list->pageUrl() ?>start=<?php echo $l_referral_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $l_referral_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($l_referral_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $l_referral_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $l_referral_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $l_referral_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($l_referral_list->TotalRecs > 0 && (!$l_referral_list->AutoHidePageSizeSelector || $l_referral_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="l_referral">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($l_referral_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($l_referral_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($l_referral_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($l_referral_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($l_referral_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($l_referral->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $l_referral_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fl_referrallist" id="fl_referrallist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($l_referral_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $l_referral_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="l_referral">
<div id="gmp_l_referral" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($l_referral_list->TotalRecs > 0 || $l_referral->isGridEdit()) { ?>
<table id="tbl_l_referrallist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$l_referral_list->RowType = ROWTYPE_HEADER;

// Render list options
$l_referral_list->renderListOptions();

// Render list options (header, left)
$l_referral_list->ListOptions->render("header", "left");
?>
<?php if ($l_referral->id->Visible) { // id ?>
	<?php if ($l_referral->sortUrl($l_referral->id) == "") { ?>
		<th data-name="id" class="<?php echo $l_referral->id->headerCellClass() ?>"><div id="elh_l_referral_id" class="l_referral_id"><div class="ew-table-header-caption"><?php echo $l_referral->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $l_referral->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_referral->SortUrl($l_referral->id) ?>',2);"><div id="elh_l_referral_id" class="l_referral_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_referral->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_referral->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_referral->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_referral->name->Visible) { // name ?>
	<?php if ($l_referral->sortUrl($l_referral->name) == "") { ?>
		<th data-name="name" class="<?php echo $l_referral->name->headerCellClass() ?>"><div id="elh_l_referral_name" class="l_referral_name"><div class="ew-table-header-caption"><?php echo $l_referral->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $l_referral->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_referral->SortUrl($l_referral->name) ?>',2);"><div id="elh_l_referral_name" class="l_referral_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_referral->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($l_referral->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_referral->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_referral->mobile->Visible) { // mobile ?>
	<?php if ($l_referral->sortUrl($l_referral->mobile) == "") { ?>
		<th data-name="mobile" class="<?php echo $l_referral->mobile->headerCellClass() ?>"><div id="elh_l_referral_mobile" class="l_referral_mobile"><div class="ew-table-header-caption"><?php echo $l_referral->mobile->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile" class="<?php echo $l_referral->mobile->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_referral->SortUrl($l_referral->mobile) ?>',2);"><div id="elh_l_referral_mobile" class="l_referral_mobile">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_referral->mobile->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($l_referral->mobile->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_referral->mobile->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_referral->max_discount->Visible) { // max_discount ?>
	<?php if ($l_referral->sortUrl($l_referral->max_discount) == "") { ?>
		<th data-name="max_discount" class="<?php echo $l_referral->max_discount->headerCellClass() ?>"><div id="elh_l_referral_max_discount" class="l_referral_max_discount"><div class="ew-table-header-caption"><?php echo $l_referral->max_discount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="max_discount" class="<?php echo $l_referral->max_discount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_referral->SortUrl($l_referral->max_discount) ?>',2);"><div id="elh_l_referral_max_discount" class="l_referral_max_discount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_referral->max_discount->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($l_referral->max_discount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_referral->max_discount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_referral->remarks->Visible) { // remarks ?>
	<?php if ($l_referral->sortUrl($l_referral->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $l_referral->remarks->headerCellClass() ?>"><div id="elh_l_referral_remarks" class="l_referral_remarks"><div class="ew-table-header-caption"><?php echo $l_referral->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $l_referral->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_referral->SortUrl($l_referral->remarks) ?>',2);"><div id="elh_l_referral_remarks" class="l_referral_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_referral->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($l_referral->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_referral->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_referral->operator->Visible) { // operator ?>
	<?php if ($l_referral->sortUrl($l_referral->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $l_referral->operator->headerCellClass() ?>"><div id="elh_l_referral_operator" class="l_referral_operator"><div class="ew-table-header-caption"><?php echo $l_referral->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $l_referral->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_referral->SortUrl($l_referral->operator) ?>',2);"><div id="elh_l_referral_operator" class="l_referral_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_referral->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_referral->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_referral->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($l_referral->datetime->Visible) { // datetime ?>
	<?php if ($l_referral->sortUrl($l_referral->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $l_referral->datetime->headerCellClass() ?>"><div id="elh_l_referral_datetime" class="l_referral_datetime"><div class="ew-table-header-caption"><?php echo $l_referral->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $l_referral->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $l_referral->SortUrl($l_referral->datetime) ?>',2);"><div id="elh_l_referral_datetime" class="l_referral_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $l_referral->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($l_referral->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($l_referral->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$l_referral_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($l_referral->ExportAll && $l_referral->isExport()) {
	$l_referral_list->StopRec = $l_referral_list->TotalRecs;
} else {

	// Set the last record to display
	if ($l_referral_list->TotalRecs > $l_referral_list->StartRec + $l_referral_list->DisplayRecs - 1)
		$l_referral_list->StopRec = $l_referral_list->StartRec + $l_referral_list->DisplayRecs - 1;
	else
		$l_referral_list->StopRec = $l_referral_list->TotalRecs;
}
$l_referral_list->RecCnt = $l_referral_list->StartRec - 1;
if ($l_referral_list->Recordset && !$l_referral_list->Recordset->EOF) {
	$l_referral_list->Recordset->moveFirst();
	$selectLimit = $l_referral_list->UseSelectLimit;
	if (!$selectLimit && $l_referral_list->StartRec > 1)
		$l_referral_list->Recordset->move($l_referral_list->StartRec - 1);
} elseif (!$l_referral->AllowAddDeleteRow && $l_referral_list->StopRec == 0) {
	$l_referral_list->StopRec = $l_referral->GridAddRowCount;
}

// Initialize aggregate
$l_referral->RowType = ROWTYPE_AGGREGATEINIT;
$l_referral->resetAttributes();
$l_referral_list->renderRow();
while ($l_referral_list->RecCnt < $l_referral_list->StopRec) {
	$l_referral_list->RecCnt++;
	if ($l_referral_list->RecCnt >= $l_referral_list->StartRec) {
		$l_referral_list->RowCnt++;

		// Set up key count
		$l_referral_list->KeyCount = $l_referral_list->RowIndex;

		// Init row class and style
		$l_referral->resetAttributes();
		$l_referral->CssClass = "";
		if ($l_referral->isGridAdd()) {
		} else {
			$l_referral_list->loadRowValues($l_referral_list->Recordset); // Load row values
		}
		$l_referral->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$l_referral->RowAttrs = array_merge($l_referral->RowAttrs, array('data-rowindex'=>$l_referral_list->RowCnt, 'id'=>'r' . $l_referral_list->RowCnt . '_l_referral', 'data-rowtype'=>$l_referral->RowType));

		// Render row
		$l_referral_list->renderRow();

		// Render list options
		$l_referral_list->renderListOptions();
?>
	<tr<?php echo $l_referral->rowAttributes() ?>>
<?php

// Render list options (body, left)
$l_referral_list->ListOptions->render("body", "left", $l_referral_list->RowCnt);
?>
	<?php if ($l_referral->id->Visible) { // id ?>
		<td data-name="id"<?php echo $l_referral->id->cellAttributes() ?>>
<span id="el<?php echo $l_referral_list->RowCnt ?>_l_referral_id" class="l_referral_id">
<span<?php echo $l_referral->id->viewAttributes() ?>>
<?php echo $l_referral->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_referral->name->Visible) { // name ?>
		<td data-name="name"<?php echo $l_referral->name->cellAttributes() ?>>
<span id="el<?php echo $l_referral_list->RowCnt ?>_l_referral_name" class="l_referral_name">
<span<?php echo $l_referral->name->viewAttributes() ?>>
<?php echo $l_referral->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_referral->mobile->Visible) { // mobile ?>
		<td data-name="mobile"<?php echo $l_referral->mobile->cellAttributes() ?>>
<span id="el<?php echo $l_referral_list->RowCnt ?>_l_referral_mobile" class="l_referral_mobile">
<span<?php echo $l_referral->mobile->viewAttributes() ?>>
<?php echo $l_referral->mobile->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_referral->max_discount->Visible) { // max_discount ?>
		<td data-name="max_discount"<?php echo $l_referral->max_discount->cellAttributes() ?>>
<span id="el<?php echo $l_referral_list->RowCnt ?>_l_referral_max_discount" class="l_referral_max_discount">
<span<?php echo $l_referral->max_discount->viewAttributes() ?>>
<?php echo $l_referral->max_discount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_referral->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $l_referral->remarks->cellAttributes() ?>>
<span id="el<?php echo $l_referral_list->RowCnt ?>_l_referral_remarks" class="l_referral_remarks">
<span<?php echo $l_referral->remarks->viewAttributes() ?>>
<?php echo $l_referral->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_referral->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $l_referral->operator->cellAttributes() ?>>
<span id="el<?php echo $l_referral_list->RowCnt ?>_l_referral_operator" class="l_referral_operator">
<span<?php echo $l_referral->operator->viewAttributes() ?>>
<?php echo $l_referral->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($l_referral->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $l_referral->datetime->cellAttributes() ?>>
<span id="el<?php echo $l_referral_list->RowCnt ?>_l_referral_datetime" class="l_referral_datetime">
<span<?php echo $l_referral->datetime->viewAttributes() ?>>
<?php echo $l_referral->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$l_referral_list->ListOptions->render("body", "right", $l_referral_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$l_referral->isGridAdd())
		$l_referral_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$l_referral->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($l_referral_list->Recordset)
	$l_referral_list->Recordset->Close();
?>
<?php if (!$l_referral->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$l_referral->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($l_referral_list->Pager)) $l_referral_list->Pager = new PrevNextPager($l_referral_list->StartRec, $l_referral_list->DisplayRecs, $l_referral_list->TotalRecs, $l_referral_list->AutoHidePager) ?>
<?php if ($l_referral_list->Pager->RecordCount > 0 && $l_referral_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($l_referral_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $l_referral_list->pageUrl() ?>start=<?php echo $l_referral_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($l_referral_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $l_referral_list->pageUrl() ?>start=<?php echo $l_referral_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $l_referral_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($l_referral_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $l_referral_list->pageUrl() ?>start=<?php echo $l_referral_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($l_referral_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $l_referral_list->pageUrl() ?>start=<?php echo $l_referral_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $l_referral_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($l_referral_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $l_referral_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $l_referral_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $l_referral_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($l_referral_list->TotalRecs > 0 && (!$l_referral_list->AutoHidePageSizeSelector || $l_referral_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="l_referral">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($l_referral_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($l_referral_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($l_referral_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($l_referral_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($l_referral_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($l_referral->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $l_referral_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($l_referral_list->TotalRecs == 0 && !$l_referral->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $l_referral_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$l_referral_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$l_referral->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$l_referral->isExport()) { ?>
<script>
ew.scrollableTable("gmp_l_referral", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$l_referral_list->terminate();
?>