<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ledger_list = new ledger_list();

// Run the page
$ledger_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ledger_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$ledger->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fledgerlist = currentForm = new ew.Form("fledgerlist", "list");
fledgerlist.formKeyCountName = '<?php echo $ledger_list->FormKeyCountName ?>';

// Form_CustomValidate event
fledgerlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fledgerlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fledgerlist.lists["x_ref_account"] = <?php echo $ledger_list->ref_account->Lookup->toClientList() ?>;
fledgerlist.lists["x_ref_account"].options = <?php echo JsonEncode($ledger_list->ref_account->lookupOptions()) ?>;
fledgerlist.lists["x_ref"] = <?php echo $ledger_list->ref->Lookup->toClientList() ?>;
fledgerlist.lists["x_ref"].options = <?php echo JsonEncode($ledger_list->ref->lookupOptions()) ?>;

// Form object for search
var fledgerlistsrch = currentSearchForm = new ew.Form("fledgerlistsrch");

// Validate function for search
fledgerlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkEuroDate(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ledger->dated->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fledgerlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fledgerlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fledgerlistsrch.lists["x_ref"] = <?php echo $ledger_list->ref->Lookup->toClientList() ?>;
fledgerlistsrch.lists["x_ref"].options = <?php echo JsonEncode($ledger_list->ref->lookupOptions()) ?>;

// Filters
fledgerlistsrch.filterList = <?php echo $ledger_list->getFilterList() ?>;

// Init search panel as collapsed
fledgerlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$ledger->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($ledger_list->TotalRecs > 0 && $ledger_list->ExportOptions->visible()) { ?>
<?php $ledger_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($ledger_list->ImportOptions->visible()) { ?>
<?php $ledger_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($ledger_list->SearchOptions->visible()) { ?>
<?php $ledger_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($ledger_list->FilterOptions->visible()) { ?>
<?php $ledger_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$ledger_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$ledger->isExport() && !$ledger->CurrentAction) { ?>
<form name="fledgerlistsrch" id="fledgerlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($ledger_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fledgerlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="ledger">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$ledger_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$ledger->RowType = ROWTYPE_SEARCH;

// Render row
$ledger->resetAttributes();
$ledger_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($ledger->dated->Visible) { // dated ?>
	<div id="xsc_dated" class="ew-cell form-group">
		<label for="x_dated" class="ew-search-caption ew-label"><?php echo $ledger->dated->caption() ?></label>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($ledger->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($ledger->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($ledger->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($ledger->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($ledger->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($ledger->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($ledger->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="ledger" data-field="x_dated" data-format="7" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($ledger->dated->getPlaceHolder()) ?>" value="<?php echo $ledger->dated->EditValue ?>"<?php echo $ledger->dated->editAttributes() ?>>
<?php if (!$ledger->dated->ReadOnly && !$ledger->dated->Disabled && !isset($ledger->dated->EditAttrs["readonly"]) && !isset($ledger->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fledgerlistsrch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
		<span class="ew-search-cond btw1_dated style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_dated style="d-none"">
<input type="text" data-table="ledger" data-field="x_dated" data-format="7" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($ledger->dated->getPlaceHolder()) ?>" value="<?php echo $ledger->dated->EditValue2 ?>"<?php echo $ledger->dated->editAttributes() ?>>
<?php if (!$ledger->dated->ReadOnly && !$ledger->dated->Disabled && !isset($ledger->dated->EditAttrs["readonly"]) && !isset($ledger->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fledgerlistsrch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
<?php if ($ledger->type->Visible) { // type ?>
	<div id="xsc_type" class="ew-cell form-group">
		<label for="x_type" class="ew-search-caption ew-label"><?php echo $ledger->type->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_type" id="z_type" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="ledger" data-field="x_type" name="x_type" id="x_type" size="30" placeholder="<?php echo HtmlEncode($ledger->type->getPlaceHolder()) ?>" value="<?php echo $ledger->type->EditValue ?>"<?php echo $ledger->type->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($ledger->name->Visible) { // name ?>
	<div id="xsc_name" class="ew-cell form-group">
		<label for="x_name" class="ew-search-caption ew-label"><?php echo $ledger->name->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="ledger" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="105" placeholder="<?php echo HtmlEncode($ledger->name->getPlaceHolder()) ?>" value="<?php echo $ledger->name->EditValue ?>"<?php echo $ledger->name->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($ledger->ref->Visible) { // ref ?>
	<div id="xsc_ref" class="ew-cell form-group">
		<label for="x_ref" class="ew-search-caption ew-label"><?php echo $ledger->ref->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_ref" id="z_ref" value="LIKE"></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ledger" data-field="x_ref" data-value-separator="<?php echo $ledger->ref->displayValueSeparatorAttribute() ?>" id="x_ref" name="x_ref"<?php echo $ledger->ref->editAttributes() ?>>
		<?php echo $ledger->ref->selectOptionListHtml("x_ref") ?>
	</select>
</div>
<?php echo $ledger->ref->Lookup->getParamTag("p_x_ref") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($ledger_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($ledger_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $ledger_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($ledger_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($ledger_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($ledger_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($ledger_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $ledger_list->showPageHeader(); ?>
<?php
$ledger_list->showMessage();
?>
<?php if ($ledger_list->TotalRecs > 0 || $ledger->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($ledger_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> ledger">
<?php if (!$ledger->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$ledger->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($ledger_list->Pager)) $ledger_list->Pager = new PrevNextPager($ledger_list->StartRec, $ledger_list->DisplayRecs, $ledger_list->TotalRecs, $ledger_list->AutoHidePager) ?>
<?php if ($ledger_list->Pager->RecordCount > 0 && $ledger_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($ledger_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $ledger_list->pageUrl() ?>start=<?php echo $ledger_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($ledger_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $ledger_list->pageUrl() ?>start=<?php echo $ledger_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $ledger_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($ledger_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $ledger_list->pageUrl() ?>start=<?php echo $ledger_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($ledger_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $ledger_list->pageUrl() ?>start=<?php echo $ledger_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $ledger_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($ledger_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $ledger_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $ledger_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $ledger_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($ledger_list->TotalRecs > 0 && (!$ledger_list->AutoHidePageSizeSelector || $ledger_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="ledger">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($ledger_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($ledger_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($ledger_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($ledger_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($ledger_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($ledger->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $ledger_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fledgerlist" id="fledgerlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ledger_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ledger_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ledger">
<div id="gmp_ledger" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($ledger_list->TotalRecs > 0 || $ledger->isGridEdit()) { ?>
<table id="tbl_ledgerlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$ledger_list->RowType = ROWTYPE_HEADER;

// Render list options
$ledger_list->renderListOptions();

// Render list options (header, left)
$ledger_list->ListOptions->render("header", "left");
?>
<?php if ($ledger->uid->Visible) { // uid ?>
	<?php if ($ledger->sortUrl($ledger->uid) == "") { ?>
		<th data-name="uid" class="<?php echo $ledger->uid->headerCellClass() ?>"><div id="elh_ledger_uid" class="ledger_uid"><div class="ew-table-header-caption"><?php echo $ledger->uid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="uid" class="<?php echo $ledger->uid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ledger->SortUrl($ledger->uid) ?>',2);"><div id="elh_ledger_uid" class="ledger_uid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ledger->uid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ledger->uid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ledger->uid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ledger->dated->Visible) { // dated ?>
	<?php if ($ledger->sortUrl($ledger->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $ledger->dated->headerCellClass() ?>"><div id="elh_ledger_dated" class="ledger_dated"><div class="ew-table-header-caption"><?php echo $ledger->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $ledger->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ledger->SortUrl($ledger->dated) ?>',2);"><div id="elh_ledger_dated" class="ledger_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ledger->dated->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ledger->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ledger->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ledger->ref_account->Visible) { // ref_account ?>
	<?php if ($ledger->sortUrl($ledger->ref_account) == "") { ?>
		<th data-name="ref_account" class="<?php echo $ledger->ref_account->headerCellClass() ?>"><div id="elh_ledger_ref_account" class="ledger_ref_account"><div class="ew-table-header-caption"><?php echo $ledger->ref_account->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref_account" class="<?php echo $ledger->ref_account->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ledger->SortUrl($ledger->ref_account) ?>',2);"><div id="elh_ledger_ref_account" class="ledger_ref_account">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ledger->ref_account->caption() ?></span><span class="ew-table-header-sort"><?php if ($ledger->ref_account->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ledger->ref_account->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ledger->Balance->Visible) { // Balance ?>
	<?php if ($ledger->sortUrl($ledger->Balance) == "") { ?>
		<th data-name="Balance" class="<?php echo $ledger->Balance->headerCellClass() ?>"><div id="elh_ledger_Balance" class="ledger_Balance"><div class="ew-table-header-caption"><?php echo $ledger->Balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Balance" class="<?php echo $ledger->Balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ledger->SortUrl($ledger->Balance) ?>',2);"><div id="elh_ledger_Balance" class="ledger_Balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ledger->Balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($ledger->Balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ledger->Balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ledger->cumulative_sum->Visible) { // cumulative_sum ?>
	<?php if ($ledger->sortUrl($ledger->cumulative_sum) == "") { ?>
		<th data-name="cumulative_sum" class="<?php echo $ledger->cumulative_sum->headerCellClass() ?>"><div id="elh_ledger_cumulative_sum" class="ledger_cumulative_sum"><div class="ew-table-header-caption"><?php echo $ledger->cumulative_sum->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cumulative_sum" class="<?php echo $ledger->cumulative_sum->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ledger->SortUrl($ledger->cumulative_sum) ?>',2);"><div id="elh_ledger_cumulative_sum" class="ledger_cumulative_sum">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ledger->cumulative_sum->caption() ?></span><span class="ew-table-header-sort"><?php if ($ledger->cumulative_sum->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ledger->cumulative_sum->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ledger->type->Visible) { // type ?>
	<?php if ($ledger->sortUrl($ledger->type) == "") { ?>
		<th data-name="type" class="<?php echo $ledger->type->headerCellClass() ?>"><div id="elh_ledger_type" class="ledger_type"><div class="ew-table-header-caption"><?php echo $ledger->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $ledger->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ledger->SortUrl($ledger->type) ?>',2);"><div id="elh_ledger_type" class="ledger_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ledger->type->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ledger->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ledger->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ledger->remarks->Visible) { // remarks ?>
	<?php if ($ledger->sortUrl($ledger->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $ledger->remarks->headerCellClass() ?>"><div id="elh_ledger_remarks" class="ledger_remarks"><div class="ew-table-header-caption"><?php echo $ledger->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $ledger->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ledger->SortUrl($ledger->remarks) ?>',2);"><div id="elh_ledger_remarks" class="ledger_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ledger->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ledger->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ledger->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ledger->name->Visible) { // name ?>
	<?php if ($ledger->sortUrl($ledger->name) == "") { ?>
		<th data-name="name" class="<?php echo $ledger->name->headerCellClass() ?>"><div id="elh_ledger_name" class="ledger_name"><div class="ew-table-header-caption"><?php echo $ledger->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $ledger->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ledger->SortUrl($ledger->name) ?>',2);"><div id="elh_ledger_name" class="ledger_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ledger->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ledger->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ledger->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ledger->ref->Visible) { // ref ?>
	<?php if ($ledger->sortUrl($ledger->ref) == "") { ?>
		<th data-name="ref" class="<?php echo $ledger->ref->headerCellClass() ?>"><div id="elh_ledger_ref" class="ledger_ref"><div class="ew-table-header-caption"><?php echo $ledger->ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref" class="<?php echo $ledger->ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ledger->SortUrl($ledger->ref) ?>',2);"><div id="elh_ledger_ref" class="ledger_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ledger->ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($ledger->ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ledger->ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ledger->uploads->Visible) { // uploads ?>
	<?php if ($ledger->sortUrl($ledger->uploads) == "") { ?>
		<th data-name="uploads" class="<?php echo $ledger->uploads->headerCellClass() ?>"><div id="elh_ledger_uploads" class="ledger_uploads"><div class="ew-table-header-caption"><?php echo $ledger->uploads->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="uploads" class="<?php echo $ledger->uploads->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ledger->SortUrl($ledger->uploads) ?>',2);"><div id="elh_ledger_uploads" class="ledger_uploads">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ledger->uploads->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ledger->uploads->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ledger->uploads->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ledger->id->Visible) { // id ?>
	<?php if ($ledger->sortUrl($ledger->id) == "") { ?>
		<th data-name="id" class="<?php echo $ledger->id->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_ledger_id" class="ledger_id"><div class="ew-table-header-caption"><?php echo $ledger->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $ledger->id->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ledger->SortUrl($ledger->id) ?>',2);"><div id="elh_ledger_id" class="ledger_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ledger->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($ledger->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ledger->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$ledger_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($ledger->ExportAll && $ledger->isExport()) {
	$ledger_list->StopRec = $ledger_list->TotalRecs;
} else {

	// Set the last record to display
	if ($ledger_list->TotalRecs > $ledger_list->StartRec + $ledger_list->DisplayRecs - 1)
		$ledger_list->StopRec = $ledger_list->StartRec + $ledger_list->DisplayRecs - 1;
	else
		$ledger_list->StopRec = $ledger_list->TotalRecs;
}
$ledger_list->RecCnt = $ledger_list->StartRec - 1;
if ($ledger_list->Recordset && !$ledger_list->Recordset->EOF) {
	$ledger_list->Recordset->moveFirst();
	$selectLimit = $ledger_list->UseSelectLimit;
	if (!$selectLimit && $ledger_list->StartRec > 1)
		$ledger_list->Recordset->move($ledger_list->StartRec - 1);
} elseif (!$ledger->AllowAddDeleteRow && $ledger_list->StopRec == 0) {
	$ledger_list->StopRec = $ledger->GridAddRowCount;
}

// Initialize aggregate
$ledger->RowType = ROWTYPE_AGGREGATEINIT;
$ledger->resetAttributes();
$ledger_list->renderRow();
while ($ledger_list->RecCnt < $ledger_list->StopRec) {
	$ledger_list->RecCnt++;
	if ($ledger_list->RecCnt >= $ledger_list->StartRec) {
		$ledger_list->RowCnt++;

		// Set up key count
		$ledger_list->KeyCount = $ledger_list->RowIndex;

		// Init row class and style
		$ledger->resetAttributes();
		$ledger->CssClass = "";
		if ($ledger->isGridAdd()) {
		} else {
			$ledger_list->loadRowValues($ledger_list->Recordset); // Load row values
		}
		$ledger->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$ledger->RowAttrs = array_merge($ledger->RowAttrs, array('data-rowindex'=>$ledger_list->RowCnt, 'id'=>'r' . $ledger_list->RowCnt . '_ledger', 'data-rowtype'=>$ledger->RowType));

		// Render row
		$ledger_list->renderRow();

		// Render list options
		$ledger_list->renderListOptions();
?>
	<tr<?php echo $ledger->rowAttributes() ?>>
<?php

// Render list options (body, left)
$ledger_list->ListOptions->render("body", "left", $ledger_list->RowCnt);
?>
	<?php if ($ledger->uid->Visible) { // uid ?>
		<td data-name="uid"<?php echo $ledger->uid->cellAttributes() ?>>
<span id="el<?php echo $ledger_list->RowCnt ?>_ledger_uid" class="ledger_uid">
<span>
<?php echo GetImageViewTag($ledger->uid, $ledger->uid->getViewValue()) ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ledger->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $ledger->dated->cellAttributes() ?>>
<span id="el<?php echo $ledger_list->RowCnt ?>_ledger_dated" class="ledger_dated">
<span<?php echo $ledger->dated->viewAttributes() ?>>
<?php if ((!EmptyString($ledger->dated->getViewValue())) && $ledger->dated->linkAttributes() <> "") { ?>
<a<?php echo $ledger->dated->linkAttributes() ?>><?php echo $ledger->dated->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ledger->dated->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($ledger->ref_account->Visible) { // ref_account ?>
		<td data-name="ref_account"<?php echo $ledger->ref_account->cellAttributes() ?>>
<span id="el<?php echo $ledger_list->RowCnt ?>_ledger_ref_account" class="ledger_ref_account">
<span<?php echo $ledger->ref_account->viewAttributes() ?>>
<?php if ((!EmptyString($ledger->ref_account->getViewValue())) && $ledger->ref_account->linkAttributes() <> "") { ?>
<a<?php echo $ledger->ref_account->linkAttributes() ?>><?php echo $ledger->ref_account->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ledger->ref_account->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($ledger->Balance->Visible) { // Balance ?>
		<td data-name="Balance"<?php echo $ledger->Balance->cellAttributes() ?>>
<span id="el<?php echo $ledger_list->RowCnt ?>_ledger_Balance" class="ledger_Balance">
<span<?php echo $ledger->Balance->viewAttributes() ?>>
<?php echo $ledger->Balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ledger->cumulative_sum->Visible) { // cumulative_sum ?>
		<td data-name="cumulative_sum"<?php echo $ledger->cumulative_sum->cellAttributes() ?>>
<span id="el<?php echo $ledger_list->RowCnt ?>_ledger_cumulative_sum" class="ledger_cumulative_sum">
<span<?php echo $ledger->cumulative_sum->viewAttributes() ?>>
<?php echo $ledger->cumulative_sum->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ledger->type->Visible) { // type ?>
		<td data-name="type"<?php echo $ledger->type->cellAttributes() ?>>
<span id="el<?php echo $ledger_list->RowCnt ?>_ledger_type" class="ledger_type">
<span<?php echo $ledger->type->viewAttributes() ?>>
<?php if ((!EmptyString($ledger->type->getViewValue())) && $ledger->type->linkAttributes() <> "") { ?>
<a<?php echo $ledger->type->linkAttributes() ?>><?php echo $ledger->type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ledger->type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($ledger->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $ledger->remarks->cellAttributes() ?>>
<span id="el<?php echo $ledger_list->RowCnt ?>_ledger_remarks" class="ledger_remarks">
<span<?php echo $ledger->remarks->viewAttributes() ?>>
<?php echo $ledger->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ledger->name->Visible) { // name ?>
		<td data-name="name"<?php echo $ledger->name->cellAttributes() ?>>
<span id="el<?php echo $ledger_list->RowCnt ?>_ledger_name" class="ledger_name">
<span<?php echo $ledger->name->viewAttributes() ?>>
<?php if ((!EmptyString($ledger->name->getViewValue())) && $ledger->name->linkAttributes() <> "") { ?>
<a<?php echo $ledger->name->linkAttributes() ?>><?php echo $ledger->name->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ledger->name->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($ledger->ref->Visible) { // ref ?>
		<td data-name="ref"<?php echo $ledger->ref->cellAttributes() ?>>
<span id="el<?php echo $ledger_list->RowCnt ?>_ledger_ref" class="ledger_ref">
<span<?php echo $ledger->ref->viewAttributes() ?>>
<?php if ((!EmptyString($ledger->ref->getViewValue())) && $ledger->ref->linkAttributes() <> "") { ?>
<a<?php echo $ledger->ref->linkAttributes() ?>><?php echo $ledger->ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ledger->ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($ledger->uploads->Visible) { // uploads ?>
		<td data-name="uploads"<?php echo $ledger->uploads->cellAttributes() ?>>
<span id="el<?php echo $ledger_list->RowCnt ?>_ledger_uploads" class="ledger_uploads">
<span>
<?php echo GetFileViewTag($ledger->uploads, $ledger->uploads->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($ledger->id->Visible) { // id ?>
		<td data-name="id"<?php echo $ledger->id->cellAttributes() ?>>
<span id="el<?php echo $ledger_list->RowCnt ?>_ledger_id" class="ledger_id">
<span<?php echo $ledger->id->viewAttributes() ?>>
<?php echo $ledger->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$ledger_list->ListOptions->render("body", "right", $ledger_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$ledger->isGridAdd())
		$ledger_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$ledger->RowType = ROWTYPE_AGGREGATE;
$ledger->resetAttributes();
$ledger_list->renderRow();
?>
<?php if ($ledger_list->TotalRecs > 0 && !$ledger->isGridAdd() && !$ledger->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$ledger_list->renderListOptions();

// Render list options (footer, left)
$ledger_list->ListOptions->render("footer", "left");
?>
	<?php if ($ledger->uid->Visible) { // uid ?>
		<td data-name="uid" class="<?php echo $ledger->uid->footerCellClass() ?>"><span id="elf_ledger_uid" class="ledger_uid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($ledger->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $ledger->dated->footerCellClass() ?>"><span id="elf_ledger_dated" class="ledger_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($ledger->ref_account->Visible) { // ref_account ?>
		<td data-name="ref_account" class="<?php echo $ledger->ref_account->footerCellClass() ?>"><span id="elf_ledger_ref_account" class="ledger_ref_account">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($ledger->Balance->Visible) { // Balance ?>
		<td data-name="Balance" class="<?php echo $ledger->Balance->footerCellClass() ?>"><span id="elf_ledger_Balance" class="ledger_Balance">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $ledger->Balance->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($ledger->cumulative_sum->Visible) { // cumulative_sum ?>
		<td data-name="cumulative_sum" class="<?php echo $ledger->cumulative_sum->footerCellClass() ?>"><span id="elf_ledger_cumulative_sum" class="ledger_cumulative_sum">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($ledger->type->Visible) { // type ?>
		<td data-name="type" class="<?php echo $ledger->type->footerCellClass() ?>"><span id="elf_ledger_type" class="ledger_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($ledger->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $ledger->remarks->footerCellClass() ?>"><span id="elf_ledger_remarks" class="ledger_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($ledger->name->Visible) { // name ?>
		<td data-name="name" class="<?php echo $ledger->name->footerCellClass() ?>"><span id="elf_ledger_name" class="ledger_name">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($ledger->ref->Visible) { // ref ?>
		<td data-name="ref" class="<?php echo $ledger->ref->footerCellClass() ?>"><span id="elf_ledger_ref" class="ledger_ref">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($ledger->uploads->Visible) { // uploads ?>
		<td data-name="uploads" class="<?php echo $ledger->uploads->footerCellClass() ?>"><span id="elf_ledger_uploads" class="ledger_uploads">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($ledger->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $ledger->id->footerCellClass() ?>"><span id="elf_ledger_id" class="ledger_id">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$ledger_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$ledger->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($ledger_list->Recordset)
	$ledger_list->Recordset->Close();
?>
<?php if (!$ledger->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$ledger->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($ledger_list->Pager)) $ledger_list->Pager = new PrevNextPager($ledger_list->StartRec, $ledger_list->DisplayRecs, $ledger_list->TotalRecs, $ledger_list->AutoHidePager) ?>
<?php if ($ledger_list->Pager->RecordCount > 0 && $ledger_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($ledger_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $ledger_list->pageUrl() ?>start=<?php echo $ledger_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($ledger_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $ledger_list->pageUrl() ?>start=<?php echo $ledger_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $ledger_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($ledger_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $ledger_list->pageUrl() ?>start=<?php echo $ledger_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($ledger_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $ledger_list->pageUrl() ?>start=<?php echo $ledger_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $ledger_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($ledger_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $ledger_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $ledger_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $ledger_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($ledger_list->TotalRecs > 0 && (!$ledger_list->AutoHidePageSizeSelector || $ledger_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="ledger">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($ledger_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($ledger_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($ledger_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($ledger_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($ledger_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($ledger->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $ledger_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($ledger_list->TotalRecs == 0 && !$ledger->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $ledger_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$ledger_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$ledger->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$ledger->isExport()) { ?>
<script>
ew.scrollableTable("gmp_ledger", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$ledger_list->terminate();
?>