<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ledger_search = new ledger_search();

// Run the page
$ledger_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ledger_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($ledger_search->IsModal) { ?>
var fledgersearch = currentAdvancedSearchForm = new ew.Form("fledgersearch", "search");
<?php } else { ?>
var fledgersearch = currentForm = new ew.Form("fledgersearch", "search");
<?php } ?>

// Form_CustomValidate event
fledgersearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fledgersearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fledgersearch.lists["x_ref_account"] = <?php echo $ledger_search->ref_account->Lookup->toClientList() ?>;
fledgersearch.lists["x_ref_account"].options = <?php echo JsonEncode($ledger_search->ref_account->lookupOptions()) ?>;
fledgersearch.lists["x_ref"] = <?php echo $ledger_search->ref->Lookup->toClientList() ?>;
fledgersearch.lists["x_ref"].options = <?php echo JsonEncode($ledger_search->ref->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fledgersearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_uid");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ledger->uid->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkEuroDate(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ledger->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_Balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ledger->Balance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_cumulative_sum");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ledger->cumulative_sum->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_r_from");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ledger->r_from->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ledger->id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $ledger_search->showPageHeader(); ?>
<?php
$ledger_search->showMessage();
?>
<form name="fledgersearch" id="fledgersearch" class="<?php echo $ledger_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ledger_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ledger_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ledger">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$ledger_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($ledger->uid->Visible) { // uid ?>
	<div id="r_uid" class="form-group row">
		<label for="x_uid" class="<?php echo $ledger_search->LeftColumnClass ?>"><span id="elh_ledger_uid"><?php echo $ledger->uid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_uid" id="z_uid" value="="></span>
		</label>
		<div class="<?php echo $ledger_search->RightColumnClass ?>"><div<?php echo $ledger->uid->cellAttributes() ?>>
			<span id="el_ledger_uid">
<input type="text" data-table="ledger" data-field="x_uid" name="x_uid" id="x_uid" placeholder="<?php echo HtmlEncode($ledger->uid->getPlaceHolder()) ?>" value="<?php echo $ledger->uid->EditValue ?>"<?php echo $ledger->uid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ledger->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $ledger_search->LeftColumnClass ?>"><span id="elh_ledger_dated"><?php echo $ledger->dated->caption() ?></span>
		</label>
		<div class="<?php echo $ledger_search->RightColumnClass ?>"><div<?php echo $ledger->dated->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($ledger->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($ledger->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($ledger->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($ledger->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($ledger->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($ledger->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($ledger->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_ledger_dated">
<input type="text" data-table="ledger" data-field="x_dated" data-format="7" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($ledger->dated->getPlaceHolder()) ?>" value="<?php echo $ledger->dated->EditValue ?>"<?php echo $ledger->dated->editAttributes() ?>>
<?php if (!$ledger->dated->ReadOnly && !$ledger->dated->Disabled && !isset($ledger->dated->EditAttrs["readonly"]) && !isset($ledger->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fledgersearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_dated d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_ledger_dated" class="btw1_dated d-none">
<input type="text" data-table="ledger" data-field="x_dated" data-format="7" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($ledger->dated->getPlaceHolder()) ?>" value="<?php echo $ledger->dated->EditValue2 ?>"<?php echo $ledger->dated->editAttributes() ?>>
<?php if (!$ledger->dated->ReadOnly && !$ledger->dated->Disabled && !isset($ledger->dated->EditAttrs["readonly"]) && !isset($ledger->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fledgersearch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ledger->ref_account->Visible) { // ref_account ?>
	<div id="r_ref_account" class="form-group row">
		<label for="x_ref_account" class="<?php echo $ledger_search->LeftColumnClass ?>"><span id="elh_ledger_ref_account"><?php echo $ledger->ref_account->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ref_account" id="z_ref_account" value="="></span>
		</label>
		<div class="<?php echo $ledger_search->RightColumnClass ?>"><div<?php echo $ledger->ref_account->cellAttributes() ?>>
			<span id="el_ledger_ref_account">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ledger" data-field="x_ref_account" data-value-separator="<?php echo $ledger->ref_account->displayValueSeparatorAttribute() ?>" id="x_ref_account" name="x_ref_account"<?php echo $ledger->ref_account->editAttributes() ?>>
		<?php echo $ledger->ref_account->selectOptionListHtml("x_ref_account") ?>
	</select>
</div>
<?php echo $ledger->ref_account->Lookup->getParamTag("p_x_ref_account") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ledger->Balance->Visible) { // Balance ?>
	<div id="r_Balance" class="form-group row">
		<label for="x_Balance" class="<?php echo $ledger_search->LeftColumnClass ?>"><span id="elh_ledger_Balance"><?php echo $ledger->Balance->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Balance" id="z_Balance" value="="></span>
		</label>
		<div class="<?php echo $ledger_search->RightColumnClass ?>"><div<?php echo $ledger->Balance->cellAttributes() ?>>
			<span id="el_ledger_Balance">
<input type="text" data-table="ledger" data-field="x_Balance" name="x_Balance" id="x_Balance" size="30" placeholder="<?php echo HtmlEncode($ledger->Balance->getPlaceHolder()) ?>" value="<?php echo $ledger->Balance->EditValue ?>"<?php echo $ledger->Balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ledger->cumulative_sum->Visible) { // cumulative_sum ?>
	<div id="r_cumulative_sum" class="form-group row">
		<label for="x_cumulative_sum" class="<?php echo $ledger_search->LeftColumnClass ?>"><span id="elh_ledger_cumulative_sum"><?php echo $ledger->cumulative_sum->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cumulative_sum" id="z_cumulative_sum" value="="></span>
		</label>
		<div class="<?php echo $ledger_search->RightColumnClass ?>"><div<?php echo $ledger->cumulative_sum->cellAttributes() ?>>
			<span id="el_ledger_cumulative_sum">
<input type="text" data-table="ledger" data-field="x_cumulative_sum" name="x_cumulative_sum" id="x_cumulative_sum" size="30" placeholder="<?php echo HtmlEncode($ledger->cumulative_sum->getPlaceHolder()) ?>" value="<?php echo $ledger->cumulative_sum->EditValue ?>"<?php echo $ledger->cumulative_sum->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ledger->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label for="x_type" class="<?php echo $ledger_search->LeftColumnClass ?>"><span id="elh_ledger_type"><?php echo $ledger->type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_type" id="z_type" value="LIKE"></span>
		</label>
		<div class="<?php echo $ledger_search->RightColumnClass ?>"><div<?php echo $ledger->type->cellAttributes() ?>>
			<span id="el_ledger_type">
<input type="text" data-table="ledger" data-field="x_type" name="x_type" id="x_type" size="30" placeholder="<?php echo HtmlEncode($ledger->type->getPlaceHolder()) ?>" value="<?php echo $ledger->type->EditValue ?>"<?php echo $ledger->type->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ledger->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $ledger_search->LeftColumnClass ?>"><span id="elh_ledger_remarks"><?php echo $ledger->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $ledger_search->RightColumnClass ?>"><div<?php echo $ledger->remarks->cellAttributes() ?>>
			<span id="el_ledger_remarks">
<input type="text" data-table="ledger" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ledger->remarks->getPlaceHolder()) ?>" value="<?php echo $ledger->remarks->EditValue ?>"<?php echo $ledger->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ledger->r_from->Visible) { // r_from ?>
	<div id="r_r_from" class="form-group row">
		<label for="x_r_from" class="<?php echo $ledger_search->LeftColumnClass ?>"><span id="elh_ledger_r_from"><?php echo $ledger->r_from->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_r_from" id="z_r_from" value="="></span>
		</label>
		<div class="<?php echo $ledger_search->RightColumnClass ?>"><div<?php echo $ledger->r_from->cellAttributes() ?>>
			<span id="el_ledger_r_from">
<input type="text" data-table="ledger" data-field="x_r_from" name="x_r_from" id="x_r_from" size="30" placeholder="<?php echo HtmlEncode($ledger->r_from->getPlaceHolder()) ?>" value="<?php echo $ledger->r_from->EditValue ?>"<?php echo $ledger->r_from->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ledger->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label for="x_name" class="<?php echo $ledger_search->LeftColumnClass ?>"><span id="elh_ledger_name"><?php echo $ledger->name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $ledger_search->RightColumnClass ?>"><div<?php echo $ledger->name->cellAttributes() ?>>
			<span id="el_ledger_name">
<input type="text" data-table="ledger" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="105" placeholder="<?php echo HtmlEncode($ledger->name->getPlaceHolder()) ?>" value="<?php echo $ledger->name->EditValue ?>"<?php echo $ledger->name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ledger->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label for="x_ref" class="<?php echo $ledger_search->LeftColumnClass ?>"><span id="elh_ledger_ref"><?php echo $ledger->ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_ref" id="z_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $ledger_search->RightColumnClass ?>"><div<?php echo $ledger->ref->cellAttributes() ?>>
			<span id="el_ledger_ref">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ledger" data-field="x_ref" data-value-separator="<?php echo $ledger->ref->displayValueSeparatorAttribute() ?>" id="x_ref" name="x_ref"<?php echo $ledger->ref->editAttributes() ?>>
		<?php echo $ledger->ref->selectOptionListHtml("x_ref") ?>
	</select>
</div>
<?php echo $ledger->ref->Lookup->getParamTag("p_x_ref") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ledger->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label class="<?php echo $ledger_search->LeftColumnClass ?>"><span id="elh_ledger_uploads"><?php echo $ledger->uploads->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_uploads" id="z_uploads" value="LIKE"></span>
		</label>
		<div class="<?php echo $ledger_search->RightColumnClass ?>"><div<?php echo $ledger->uploads->cellAttributes() ?>>
			<span id="el_ledger_uploads">
<input type="text" data-table="ledger" data-field="x_uploads" name="x_uploads" id="x_uploads" placeholder="<?php echo HtmlEncode($ledger->uploads->getPlaceHolder()) ?>" value="<?php echo $ledger->uploads->EditValue ?>"<?php echo $ledger->uploads->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ledger->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $ledger_search->LeftColumnClass ?>"><span id="elh_ledger_id"><?php echo $ledger->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $ledger_search->RightColumnClass ?>"><div<?php echo $ledger->id->cellAttributes() ?>>
			<span id="el_ledger_id">
<input type="text" data-table="ledger" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($ledger->id->getPlaceHolder()) ?>" value="<?php echo $ledger->id->EditValue ?>"<?php echo $ledger->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$ledger_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $ledger_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$ledger_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$ledger_search->terminate();
?>