<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ledger_view = new ledger_view();

// Run the page
$ledger_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ledger_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$ledger->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fledgerview = currentForm = new ew.Form("fledgerview", "view");

// Form_CustomValidate event
fledgerview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fledgerview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fledgerview.lists["x_ref_account"] = <?php echo $ledger_view->ref_account->Lookup->toClientList() ?>;
fledgerview.lists["x_ref_account"].options = <?php echo JsonEncode($ledger_view->ref_account->lookupOptions()) ?>;
fledgerview.lists["x_ref"] = <?php echo $ledger_view->ref->Lookup->toClientList() ?>;
fledgerview.lists["x_ref"].options = <?php echo JsonEncode($ledger_view->ref->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$ledger->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $ledger_view->ExportOptions->render("body") ?>
<?php $ledger_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $ledger_view->showPageHeader(); ?>
<?php
$ledger_view->showMessage();
?>
<form name="fledgerview" id="fledgerview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ledger_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ledger_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ledger">
<input type="hidden" name="modal" value="<?php echo (int)$ledger_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($ledger->uid->Visible) { // uid ?>
	<tr id="r_uid">
		<td class="<?php echo $ledger_view->TableLeftColumnClass ?>"><span id="elh_ledger_uid"><?php echo $ledger->uid->caption() ?></span></td>
		<td data-name="uid"<?php echo $ledger->uid->cellAttributes() ?>>
<span id="el_ledger_uid">
<span>
<?php echo GetImageViewTag($ledger->uid, $ledger->uid->getViewValue()) ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ledger->dated->Visible) { // dated ?>
	<tr id="r_dated">
		<td class="<?php echo $ledger_view->TableLeftColumnClass ?>"><span id="elh_ledger_dated"><?php echo $ledger->dated->caption() ?></span></td>
		<td data-name="dated"<?php echo $ledger->dated->cellAttributes() ?>>
<span id="el_ledger_dated">
<span<?php echo $ledger->dated->viewAttributes() ?>>
<?php if ((!EmptyString($ledger->dated->getViewValue())) && $ledger->dated->linkAttributes() <> "") { ?>
<a<?php echo $ledger->dated->linkAttributes() ?>><?php echo $ledger->dated->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ledger->dated->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ledger->ref_account->Visible) { // ref_account ?>
	<tr id="r_ref_account">
		<td class="<?php echo $ledger_view->TableLeftColumnClass ?>"><span id="elh_ledger_ref_account"><?php echo $ledger->ref_account->caption() ?></span></td>
		<td data-name="ref_account"<?php echo $ledger->ref_account->cellAttributes() ?>>
<span id="el_ledger_ref_account">
<span<?php echo $ledger->ref_account->viewAttributes() ?>>
<?php if ((!EmptyString($ledger->ref_account->getViewValue())) && $ledger->ref_account->linkAttributes() <> "") { ?>
<a<?php echo $ledger->ref_account->linkAttributes() ?>><?php echo $ledger->ref_account->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ledger->ref_account->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ledger->Balance->Visible) { // Balance ?>
	<tr id="r_Balance">
		<td class="<?php echo $ledger_view->TableLeftColumnClass ?>"><span id="elh_ledger_Balance"><?php echo $ledger->Balance->caption() ?></span></td>
		<td data-name="Balance"<?php echo $ledger->Balance->cellAttributes() ?>>
<span id="el_ledger_Balance">
<span<?php echo $ledger->Balance->viewAttributes() ?>>
<?php echo $ledger->Balance->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ledger->cumulative_sum->Visible) { // cumulative_sum ?>
	<tr id="r_cumulative_sum">
		<td class="<?php echo $ledger_view->TableLeftColumnClass ?>"><span id="elh_ledger_cumulative_sum"><?php echo $ledger->cumulative_sum->caption() ?></span></td>
		<td data-name="cumulative_sum"<?php echo $ledger->cumulative_sum->cellAttributes() ?>>
<span id="el_ledger_cumulative_sum">
<span<?php echo $ledger->cumulative_sum->viewAttributes() ?>>
<?php echo $ledger->cumulative_sum->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ledger->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $ledger_view->TableLeftColumnClass ?>"><span id="elh_ledger_remarks"><?php echo $ledger->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $ledger->remarks->cellAttributes() ?>>
<span id="el_ledger_remarks">
<span<?php echo $ledger->remarks->viewAttributes() ?>>
<?php echo $ledger->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ledger->name->Visible) { // name ?>
	<tr id="r_name">
		<td class="<?php echo $ledger_view->TableLeftColumnClass ?>"><span id="elh_ledger_name"><?php echo $ledger->name->caption() ?></span></td>
		<td data-name="name"<?php echo $ledger->name->cellAttributes() ?>>
<span id="el_ledger_name">
<span<?php echo $ledger->name->viewAttributes() ?>>
<?php if ((!EmptyString($ledger->name->getViewValue())) && $ledger->name->linkAttributes() <> "") { ?>
<a<?php echo $ledger->name->linkAttributes() ?>><?php echo $ledger->name->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ledger->name->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ledger->ref->Visible) { // ref ?>
	<tr id="r_ref">
		<td class="<?php echo $ledger_view->TableLeftColumnClass ?>"><span id="elh_ledger_ref"><?php echo $ledger->ref->caption() ?></span></td>
		<td data-name="ref"<?php echo $ledger->ref->cellAttributes() ?>>
<span id="el_ledger_ref">
<span<?php echo $ledger->ref->viewAttributes() ?>>
<?php if ((!EmptyString($ledger->ref->getViewValue())) && $ledger->ref->linkAttributes() <> "") { ?>
<a<?php echo $ledger->ref->linkAttributes() ?>><?php echo $ledger->ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ledger->ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ledger->uploads->Visible) { // uploads ?>
	<tr id="r_uploads">
		<td class="<?php echo $ledger_view->TableLeftColumnClass ?>"><span id="elh_ledger_uploads"><?php echo $ledger->uploads->caption() ?></span></td>
		<td data-name="uploads"<?php echo $ledger->uploads->cellAttributes() ?>>
<span id="el_ledger_uploads">
<span>
<?php echo GetFileViewTag($ledger->uploads, $ledger->uploads->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ledger->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $ledger_view->TableLeftColumnClass ?>"><span id="elh_ledger_id"><?php echo $ledger->id->caption() ?></span></td>
		<td data-name="id"<?php echo $ledger->id->cellAttributes() ?>>
<span id="el_ledger_id">
<span<?php echo $ledger->id->viewAttributes() ?>>
<?php echo $ledger->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$ledger_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$ledger->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$ledger_view->terminate();
?>