<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$loginip_add = new loginip_add();

// Run the page
$loginip_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$loginip_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var floginipadd = currentForm = new ew.Form("floginipadd", "add");

// Validate form
floginipadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($loginip_add->user->Required) { ?>
			elm = this.getElements("x" + infix + "_user");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $loginip->user->caption(), $loginip->user->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($loginip_add->ip->Required) { ?>
			elm = this.getElements("x" + infix + "_ip");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $loginip->ip->caption(), $loginip->ip->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($loginip_add->time_limit->Required) { ?>
			elm = this.getElements("x" + infix + "_time_limit");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $loginip->time_limit->caption(), $loginip->time_limit->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_time_limit");
			if (elm && !ew.checkEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($loginip->time_limit->errorMessage()) ?>");
		<?php if ($loginip_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $loginip->operator->caption(), $loginip->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($loginip_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $loginip->datetime->caption(), $loginip->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
floginipadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
floginipadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
floginipadd.lists["x_user"] = <?php echo $loginip_add->user->Lookup->toClientList() ?>;
floginipadd.lists["x_user"].options = <?php echo JsonEncode($loginip_add->user->lookupOptions()) ?>;
floginipadd.lists["x_ip"] = <?php echo $loginip_add->ip->Lookup->toClientList() ?>;
floginipadd.lists["x_ip"].options = <?php echo JsonEncode($loginip_add->ip->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $loginip_add->showPageHeader(); ?>
<?php
$loginip_add->showMessage();
?>
<form name="floginipadd" id="floginipadd" class="<?php echo $loginip_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($loginip_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $loginip_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="loginip">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$loginip_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($loginip->user->Visible) { // user ?>
	<div id="r_user" class="form-group row">
		<label id="elh_loginip_user" for="x_user" class="<?php echo $loginip_add->LeftColumnClass ?>"><?php echo $loginip->user->caption() ?><?php echo ($loginip->user->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $loginip_add->RightColumnClass ?>"><div<?php echo $loginip->user->cellAttributes() ?>>
<?php if (!$Security->isAdmin() && $Security->isLoggedIn() && !$loginip->userIDAllow("add")) { // Non system admin ?>
<span id="el_loginip_user">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="loginip" data-field="x_user" data-value-separator="<?php echo $loginip->user->displayValueSeparatorAttribute() ?>" id="x_user" name="x_user"<?php echo $loginip->user->editAttributes() ?>>
		<?php echo $loginip->user->selectOptionListHtml("x_user") ?>
	</select>
</div>
<?php echo $loginip->user->Lookup->getParamTag("p_x_user") ?>
</span>
<?php } else { ?>
<span id="el_loginip_user">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="loginip" data-field="x_user" data-value-separator="<?php echo $loginip->user->displayValueSeparatorAttribute() ?>" id="x_user" name="x_user"<?php echo $loginip->user->editAttributes() ?>>
		<?php echo $loginip->user->selectOptionListHtml("x_user") ?>
	</select>
</div>
<?php echo $loginip->user->Lookup->getParamTag("p_x_user") ?>
</span>
<?php } ?>
<?php echo $loginip->user->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($loginip->ip->Visible) { // ip ?>
	<div id="r_ip" class="form-group row">
		<label id="elh_loginip_ip" for="x_ip" class="<?php echo $loginip_add->LeftColumnClass ?>"><?php echo $loginip->ip->caption() ?><?php echo ($loginip->ip->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $loginip_add->RightColumnClass ?>"><div<?php echo $loginip->ip->cellAttributes() ?>>
<span id="el_loginip_ip">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="loginip" data-field="x_ip" data-value-separator="<?php echo $loginip->ip->displayValueSeparatorAttribute() ?>" id="x_ip" name="x_ip"<?php echo $loginip->ip->editAttributes() ?>>
		<?php echo $loginip->ip->selectOptionListHtml("x_ip") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "misc") && !$loginip->ip->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_ip" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $loginip->ip->caption() ?>" data-title="<?php echo $loginip->ip->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_ip',url:'miscaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $loginip->ip->Lookup->getParamTag("p_x_ip") ?>
</span>
<?php echo $loginip->ip->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($loginip->time_limit->Visible) { // time_limit ?>
	<div id="r_time_limit" class="form-group row">
		<label id="elh_loginip_time_limit" for="x_time_limit" class="<?php echo $loginip_add->LeftColumnClass ?>"><?php echo $loginip->time_limit->caption() ?><?php echo ($loginip->time_limit->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $loginip_add->RightColumnClass ?>"><div<?php echo $loginip->time_limit->cellAttributes() ?>>
<span id="el_loginip_time_limit">
<input type="text" data-table="loginip" data-field="x_time_limit" data-format="11" name="x_time_limit" id="x_time_limit" placeholder="<?php echo HtmlEncode($loginip->time_limit->getPlaceHolder()) ?>" value="<?php echo $loginip->time_limit->EditValue ?>"<?php echo $loginip->time_limit->editAttributes() ?>>
<?php if (!$loginip->time_limit->ReadOnly && !$loginip->time_limit->Disabled && !isset($loginip->time_limit->EditAttrs["readonly"]) && !isset($loginip->time_limit->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("floginipadd", "x_time_limit", {"ignoreReadonly":true,"useCurrent":false,"format":11});
</script>
<?php } ?>
</span>
<?php echo $loginip->time_limit->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$loginip_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $loginip_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $loginip_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$loginip_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$loginip_add->terminate();
?>