<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$loginip_list = new loginip_list();

// Run the page
$loginip_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$loginip_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$loginip->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var floginiplist = currentForm = new ew.Form("floginiplist", "list");
floginiplist.formKeyCountName = '<?php echo $loginip_list->FormKeyCountName ?>';

// Form_CustomValidate event
floginiplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
floginiplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
floginiplist.lists["x_user"] = <?php echo $loginip_list->user->Lookup->toClientList() ?>;
floginiplist.lists["x_user"].options = <?php echo JsonEncode($loginip_list->user->lookupOptions()) ?>;
floginiplist.lists["x_ip"] = <?php echo $loginip_list->ip->Lookup->toClientList() ?>;
floginiplist.lists["x_ip"].options = <?php echo JsonEncode($loginip_list->ip->lookupOptions()) ?>;

// Form object for search
var floginiplistsrch = currentSearchForm = new ew.Form("floginiplistsrch");

// Filters
floginiplistsrch.filterList = <?php echo $loginip_list->getFilterList() ?>;

// Init search panel as collapsed
floginiplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$loginip->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($loginip_list->TotalRecs > 0 && $loginip_list->ExportOptions->visible()) { ?>
<?php $loginip_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($loginip_list->ImportOptions->visible()) { ?>
<?php $loginip_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($loginip_list->SearchOptions->visible()) { ?>
<?php $loginip_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($loginip_list->FilterOptions->visible()) { ?>
<?php $loginip_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$loginip_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$loginip->isExport() && !$loginip->CurrentAction) { ?>
<form name="floginiplistsrch" id="floginiplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($loginip_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="floginiplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="loginip">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($loginip_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($loginip_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $loginip_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($loginip_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($loginip_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($loginip_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($loginip_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $loginip_list->showPageHeader(); ?>
<?php
$loginip_list->showMessage();
?>
<?php if ($loginip_list->TotalRecs > 0 || $loginip->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($loginip_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> loginip">
<?php if (!$loginip->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$loginip->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($loginip_list->Pager)) $loginip_list->Pager = new PrevNextPager($loginip_list->StartRec, $loginip_list->DisplayRecs, $loginip_list->TotalRecs, $loginip_list->AutoHidePager) ?>
<?php if ($loginip_list->Pager->RecordCount > 0 && $loginip_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($loginip_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $loginip_list->pageUrl() ?>start=<?php echo $loginip_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($loginip_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $loginip_list->pageUrl() ?>start=<?php echo $loginip_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $loginip_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($loginip_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $loginip_list->pageUrl() ?>start=<?php echo $loginip_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($loginip_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $loginip_list->pageUrl() ?>start=<?php echo $loginip_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $loginip_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($loginip_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $loginip_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $loginip_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $loginip_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($loginip_list->TotalRecs > 0 && (!$loginip_list->AutoHidePageSizeSelector || $loginip_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="loginip">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($loginip_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($loginip_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($loginip_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($loginip_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($loginip_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($loginip->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $loginip_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="floginiplist" id="floginiplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($loginip_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $loginip_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="loginip">
<div id="gmp_loginip" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($loginip_list->TotalRecs > 0 || $loginip->isGridEdit()) { ?>
<table id="tbl_loginiplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$loginip_list->RowType = ROWTYPE_HEADER;

// Render list options
$loginip_list->renderListOptions();

// Render list options (header, left)
$loginip_list->ListOptions->render("header", "left");
?>
<?php if ($loginip->id->Visible) { // id ?>
	<?php if ($loginip->sortUrl($loginip->id) == "") { ?>
		<th data-name="id" class="<?php echo $loginip->id->headerCellClass() ?>"><div id="elh_loginip_id" class="loginip_id"><div class="ew-table-header-caption"><?php echo $loginip->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $loginip->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $loginip->SortUrl($loginip->id) ?>',2);"><div id="elh_loginip_id" class="loginip_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $loginip->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($loginip->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($loginip->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($loginip->user->Visible) { // user ?>
	<?php if ($loginip->sortUrl($loginip->user) == "") { ?>
		<th data-name="user" class="<?php echo $loginip->user->headerCellClass() ?>"><div id="elh_loginip_user" class="loginip_user"><div class="ew-table-header-caption"><?php echo $loginip->user->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="user" class="<?php echo $loginip->user->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $loginip->SortUrl($loginip->user) ?>',2);"><div id="elh_loginip_user" class="loginip_user">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $loginip->user->caption() ?></span><span class="ew-table-header-sort"><?php if ($loginip->user->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($loginip->user->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($loginip->ip->Visible) { // ip ?>
	<?php if ($loginip->sortUrl($loginip->ip) == "") { ?>
		<th data-name="ip" class="<?php echo $loginip->ip->headerCellClass() ?>"><div id="elh_loginip_ip" class="loginip_ip"><div class="ew-table-header-caption"><?php echo $loginip->ip->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ip" class="<?php echo $loginip->ip->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $loginip->SortUrl($loginip->ip) ?>',2);"><div id="elh_loginip_ip" class="loginip_ip">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $loginip->ip->caption() ?></span><span class="ew-table-header-sort"><?php if ($loginip->ip->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($loginip->ip->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($loginip->time_limit->Visible) { // time_limit ?>
	<?php if ($loginip->sortUrl($loginip->time_limit) == "") { ?>
		<th data-name="time_limit" class="<?php echo $loginip->time_limit->headerCellClass() ?>"><div id="elh_loginip_time_limit" class="loginip_time_limit"><div class="ew-table-header-caption"><?php echo $loginip->time_limit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="time_limit" class="<?php echo $loginip->time_limit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $loginip->SortUrl($loginip->time_limit) ?>',2);"><div id="elh_loginip_time_limit" class="loginip_time_limit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $loginip->time_limit->caption() ?></span><span class="ew-table-header-sort"><?php if ($loginip->time_limit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($loginip->time_limit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($loginip->operator->Visible) { // operator ?>
	<?php if ($loginip->sortUrl($loginip->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $loginip->operator->headerCellClass() ?>"><div id="elh_loginip_operator" class="loginip_operator"><div class="ew-table-header-caption"><?php echo $loginip->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $loginip->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $loginip->SortUrl($loginip->operator) ?>',2);"><div id="elh_loginip_operator" class="loginip_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $loginip->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($loginip->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($loginip->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($loginip->datetime->Visible) { // datetime ?>
	<?php if ($loginip->sortUrl($loginip->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $loginip->datetime->headerCellClass() ?>"><div id="elh_loginip_datetime" class="loginip_datetime"><div class="ew-table-header-caption"><?php echo $loginip->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $loginip->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $loginip->SortUrl($loginip->datetime) ?>',2);"><div id="elh_loginip_datetime" class="loginip_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $loginip->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($loginip->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($loginip->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$loginip_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($loginip->ExportAll && $loginip->isExport()) {
	$loginip_list->StopRec = $loginip_list->TotalRecs;
} else {

	// Set the last record to display
	if ($loginip_list->TotalRecs > $loginip_list->StartRec + $loginip_list->DisplayRecs - 1)
		$loginip_list->StopRec = $loginip_list->StartRec + $loginip_list->DisplayRecs - 1;
	else
		$loginip_list->StopRec = $loginip_list->TotalRecs;
}
$loginip_list->RecCnt = $loginip_list->StartRec - 1;
if ($loginip_list->Recordset && !$loginip_list->Recordset->EOF) {
	$loginip_list->Recordset->moveFirst();
	$selectLimit = $loginip_list->UseSelectLimit;
	if (!$selectLimit && $loginip_list->StartRec > 1)
		$loginip_list->Recordset->move($loginip_list->StartRec - 1);
} elseif (!$loginip->AllowAddDeleteRow && $loginip_list->StopRec == 0) {
	$loginip_list->StopRec = $loginip->GridAddRowCount;
}

// Initialize aggregate
$loginip->RowType = ROWTYPE_AGGREGATEINIT;
$loginip->resetAttributes();
$loginip_list->renderRow();
while ($loginip_list->RecCnt < $loginip_list->StopRec) {
	$loginip_list->RecCnt++;
	if ($loginip_list->RecCnt >= $loginip_list->StartRec) {
		$loginip_list->RowCnt++;

		// Set up key count
		$loginip_list->KeyCount = $loginip_list->RowIndex;

		// Init row class and style
		$loginip->resetAttributes();
		$loginip->CssClass = "";
		if ($loginip->isGridAdd()) {
		} else {
			$loginip_list->loadRowValues($loginip_list->Recordset); // Load row values
		}
		$loginip->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$loginip->RowAttrs = array_merge($loginip->RowAttrs, array('data-rowindex'=>$loginip_list->RowCnt, 'id'=>'r' . $loginip_list->RowCnt . '_loginip', 'data-rowtype'=>$loginip->RowType));

		// Render row
		$loginip_list->renderRow();

		// Render list options
		$loginip_list->renderListOptions();
?>
	<tr<?php echo $loginip->rowAttributes() ?>>
<?php

// Render list options (body, left)
$loginip_list->ListOptions->render("body", "left", $loginip_list->RowCnt);
?>
	<?php if ($loginip->id->Visible) { // id ?>
		<td data-name="id"<?php echo $loginip->id->cellAttributes() ?>>
<span id="el<?php echo $loginip_list->RowCnt ?>_loginip_id" class="loginip_id">
<span<?php echo $loginip->id->viewAttributes() ?>>
<?php echo $loginip->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($loginip->user->Visible) { // user ?>
		<td data-name="user"<?php echo $loginip->user->cellAttributes() ?>>
<span id="el<?php echo $loginip_list->RowCnt ?>_loginip_user" class="loginip_user">
<span<?php echo $loginip->user->viewAttributes() ?>>
<?php echo $loginip->user->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($loginip->ip->Visible) { // ip ?>
		<td data-name="ip"<?php echo $loginip->ip->cellAttributes() ?>>
<span id="el<?php echo $loginip_list->RowCnt ?>_loginip_ip" class="loginip_ip">
<span<?php echo $loginip->ip->viewAttributes() ?>>
<?php echo $loginip->ip->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($loginip->time_limit->Visible) { // time_limit ?>
		<td data-name="time_limit"<?php echo $loginip->time_limit->cellAttributes() ?>>
<span id="el<?php echo $loginip_list->RowCnt ?>_loginip_time_limit" class="loginip_time_limit">
<span<?php echo $loginip->time_limit->viewAttributes() ?>>
<?php echo $loginip->time_limit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($loginip->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $loginip->operator->cellAttributes() ?>>
<span id="el<?php echo $loginip_list->RowCnt ?>_loginip_operator" class="loginip_operator">
<span<?php echo $loginip->operator->viewAttributes() ?>>
<?php echo $loginip->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($loginip->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $loginip->datetime->cellAttributes() ?>>
<span id="el<?php echo $loginip_list->RowCnt ?>_loginip_datetime" class="loginip_datetime">
<span<?php echo $loginip->datetime->viewAttributes() ?>>
<?php echo $loginip->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$loginip_list->ListOptions->render("body", "right", $loginip_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$loginip->isGridAdd())
		$loginip_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$loginip->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($loginip_list->Recordset)
	$loginip_list->Recordset->Close();
?>
<?php if (!$loginip->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$loginip->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($loginip_list->Pager)) $loginip_list->Pager = new PrevNextPager($loginip_list->StartRec, $loginip_list->DisplayRecs, $loginip_list->TotalRecs, $loginip_list->AutoHidePager) ?>
<?php if ($loginip_list->Pager->RecordCount > 0 && $loginip_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($loginip_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $loginip_list->pageUrl() ?>start=<?php echo $loginip_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($loginip_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $loginip_list->pageUrl() ?>start=<?php echo $loginip_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $loginip_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($loginip_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $loginip_list->pageUrl() ?>start=<?php echo $loginip_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($loginip_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $loginip_list->pageUrl() ?>start=<?php echo $loginip_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $loginip_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($loginip_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $loginip_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $loginip_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $loginip_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($loginip_list->TotalRecs > 0 && (!$loginip_list->AutoHidePageSizeSelector || $loginip_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="loginip">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($loginip_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($loginip_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($loginip_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($loginip_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($loginip_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($loginip->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $loginip_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($loginip_list->TotalRecs == 0 && !$loginip->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $loginip_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$loginip_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$loginip->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$loginip->isExport()) { ?>
<script>
ew.scrollableTable("gmp_loginip", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$loginip_list->terminate();
?>