<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$loginip_view = new loginip_view();

// Run the page
$loginip_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$loginip_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$loginip->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var floginipview = currentForm = new ew.Form("floginipview", "view");

// Form_CustomValidate event
floginipview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
floginipview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
floginipview.lists["x_user"] = <?php echo $loginip_view->user->Lookup->toClientList() ?>;
floginipview.lists["x_user"].options = <?php echo JsonEncode($loginip_view->user->lookupOptions()) ?>;
floginipview.lists["x_ip"] = <?php echo $loginip_view->ip->Lookup->toClientList() ?>;
floginipview.lists["x_ip"].options = <?php echo JsonEncode($loginip_view->ip->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$loginip->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $loginip_view->ExportOptions->render("body") ?>
<?php $loginip_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $loginip_view->showPageHeader(); ?>
<?php
$loginip_view->showMessage();
?>
<form name="floginipview" id="floginipview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($loginip_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $loginip_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="loginip">
<input type="hidden" name="modal" value="<?php echo (int)$loginip_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($loginip->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $loginip_view->TableLeftColumnClass ?>"><span id="elh_loginip_id"><?php echo $loginip->id->caption() ?></span></td>
		<td data-name="id"<?php echo $loginip->id->cellAttributes() ?>>
<span id="el_loginip_id">
<span<?php echo $loginip->id->viewAttributes() ?>>
<?php echo $loginip->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($loginip->user->Visible) { // user ?>
	<tr id="r_user">
		<td class="<?php echo $loginip_view->TableLeftColumnClass ?>"><span id="elh_loginip_user"><?php echo $loginip->user->caption() ?></span></td>
		<td data-name="user"<?php echo $loginip->user->cellAttributes() ?>>
<span id="el_loginip_user">
<span<?php echo $loginip->user->viewAttributes() ?>>
<?php echo $loginip->user->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($loginip->ip->Visible) { // ip ?>
	<tr id="r_ip">
		<td class="<?php echo $loginip_view->TableLeftColumnClass ?>"><span id="elh_loginip_ip"><?php echo $loginip->ip->caption() ?></span></td>
		<td data-name="ip"<?php echo $loginip->ip->cellAttributes() ?>>
<span id="el_loginip_ip">
<span<?php echo $loginip->ip->viewAttributes() ?>>
<?php echo $loginip->ip->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($loginip->time_limit->Visible) { // time_limit ?>
	<tr id="r_time_limit">
		<td class="<?php echo $loginip_view->TableLeftColumnClass ?>"><span id="elh_loginip_time_limit"><?php echo $loginip->time_limit->caption() ?></span></td>
		<td data-name="time_limit"<?php echo $loginip->time_limit->cellAttributes() ?>>
<span id="el_loginip_time_limit">
<span<?php echo $loginip->time_limit->viewAttributes() ?>>
<?php echo $loginip->time_limit->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($loginip->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $loginip_view->TableLeftColumnClass ?>"><span id="elh_loginip_operator"><?php echo $loginip->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $loginip->operator->cellAttributes() ?>>
<span id="el_loginip_operator">
<span<?php echo $loginip->operator->viewAttributes() ?>>
<?php echo $loginip->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($loginip->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $loginip_view->TableLeftColumnClass ?>"><span id="elh_loginip_datetime"><?php echo $loginip->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $loginip->datetime->cellAttributes() ?>>
<span id="el_loginip_datetime">
<span<?php echo $loginip->datetime->viewAttributes() ?>>
<?php echo $loginip->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$loginip_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$loginip->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$loginip_view->terminate();
?>