<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$loom_info_list = new loom_info_list();

// Run the page
$loom_info_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$loom_info_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$loom_info->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var floom_infolist = currentForm = new ew.Form("floom_infolist", "list");
floom_infolist.formKeyCountName = '<?php echo $loom_info_list->FormKeyCountName ?>';

// Form_CustomValidate event
floom_infolist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
floom_infolist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
floom_infolist.lists["x_grp"] = <?php echo $loom_info_list->grp->Lookup->toClientList() ?>;
floom_infolist.lists["x_grp"].options = <?php echo JsonEncode($loom_info_list->grp->lookupOptions()) ?>;
floom_infolist.lists["x_works"] = <?php echo $loom_info_list->works->Lookup->toClientList() ?>;
floom_infolist.lists["x_works"].options = <?php echo JsonEncode($loom_info_list->works->lookupOptions()) ?>;
floom_infolist.lists["x_status"] = <?php echo $loom_info_list->status->Lookup->toClientList() ?>;
floom_infolist.lists["x_status"].options = <?php echo JsonEncode($loom_info_list->status->options(FALSE, TRUE)) ?>;
floom_infolist.lists["x_operator"] = <?php echo $loom_info_list->operator->Lookup->toClientList() ?>;
floom_infolist.lists["x_operator"].options = <?php echo JsonEncode($loom_info_list->operator->lookupOptions()) ?>;
floom_infolist.lists["x_process"] = <?php echo $loom_info_list->process->Lookup->toClientList() ?>;
floom_infolist.lists["x_process"].options = <?php echo JsonEncode($loom_info_list->process->lookupOptions()) ?>;
floom_infolist.lists["x_category"] = <?php echo $loom_info_list->category->Lookup->toClientList() ?>;
floom_infolist.lists["x_category"].options = <?php echo JsonEncode($loom_info_list->category->lookupOptions()) ?>;

// Form object for search
var floom_infolistsrch = currentSearchForm = new ew.Form("floom_infolistsrch");

// Validate function for search
floom_infolistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
floom_infolistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
floom_infolistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
floom_infolistsrch.lists["x_works"] = <?php echo $loom_info_list->works->Lookup->toClientList() ?>;
floom_infolistsrch.lists["x_works"].options = <?php echo JsonEncode($loom_info_list->works->lookupOptions()) ?>;
floom_infolistsrch.lists["x_status"] = <?php echo $loom_info_list->status->Lookup->toClientList() ?>;
floom_infolistsrch.lists["x_status"].options = <?php echo JsonEncode($loom_info_list->status->options(FALSE, TRUE)) ?>;

// Filters
floom_infolistsrch.filterList = <?php echo $loom_info_list->getFilterList() ?>;

// Init search panel as collapsed
floom_infolistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$loom_info->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($loom_info_list->TotalRecs > 0 && $loom_info_list->ExportOptions->visible()) { ?>
<?php $loom_info_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($loom_info_list->ImportOptions->visible()) { ?>
<?php $loom_info_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($loom_info_list->SearchOptions->visible()) { ?>
<?php $loom_info_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($loom_info_list->FilterOptions->visible()) { ?>
<?php $loom_info_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$loom_info_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$loom_info->isExport() && !$loom_info->CurrentAction) { ?>
<form name="floom_infolistsrch" id="floom_infolistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($loom_info_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="floom_infolistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="loom_info">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$loom_info_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$loom_info->RowType = ROWTYPE_SEARCH;

// Render row
$loom_info->resetAttributes();
$loom_info_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($loom_info->works->Visible) { // works ?>
	<div id="xsc_works" class="ew-cell form-group">
		<label for="x_works" class="ew-search-caption ew-label"><?php echo $loom_info->works->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_works" id="z_works" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="loom_info" data-field="x_works" data-value-separator="<?php echo $loom_info->works->displayValueSeparatorAttribute() ?>" id="x_works" name="x_works"<?php echo $loom_info->works->editAttributes() ?>>
		<?php echo $loom_info->works->selectOptionListHtml("x_works") ?>
	</select>
</div>
<?php echo $loom_info->works->Lookup->getParamTag("p_x_works") ?>
</span>
	</div>
<?php } ?>
<?php if ($loom_info->status->Visible) { // status ?>
	<div id="xsc_status" class="ew-cell form-group">
		<label for="x_status" class="ew-search-caption ew-label"><?php echo $loom_info->status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="loom_info" data-field="x_status" data-value-separator="<?php echo $loom_info->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $loom_info->status->editAttributes() ?>>
		<?php echo $loom_info->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($loom_info_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($loom_info_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $loom_info_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($loom_info_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($loom_info_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($loom_info_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($loom_info_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $loom_info_list->showPageHeader(); ?>
<?php
$loom_info_list->showMessage();
?>
<?php if ($loom_info_list->TotalRecs > 0 || $loom_info->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($loom_info_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> loom_info">
<?php if (!$loom_info->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$loom_info->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($loom_info_list->Pager)) $loom_info_list->Pager = new PrevNextPager($loom_info_list->StartRec, $loom_info_list->DisplayRecs, $loom_info_list->TotalRecs, $loom_info_list->AutoHidePager) ?>
<?php if ($loom_info_list->Pager->RecordCount > 0 && $loom_info_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($loom_info_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $loom_info_list->pageUrl() ?>start=<?php echo $loom_info_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($loom_info_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $loom_info_list->pageUrl() ?>start=<?php echo $loom_info_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $loom_info_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($loom_info_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $loom_info_list->pageUrl() ?>start=<?php echo $loom_info_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($loom_info_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $loom_info_list->pageUrl() ?>start=<?php echo $loom_info_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $loom_info_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($loom_info_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $loom_info_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $loom_info_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $loom_info_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($loom_info_list->TotalRecs > 0 && (!$loom_info_list->AutoHidePageSizeSelector || $loom_info_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="loom_info">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($loom_info_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($loom_info_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($loom_info_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($loom_info_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($loom_info_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($loom_info->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $loom_info_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="floom_infolist" id="floom_infolist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($loom_info_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $loom_info_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="loom_info">
<div id="gmp_loom_info" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($loom_info_list->TotalRecs > 0 || $loom_info->isGridEdit()) { ?>
<table id="tbl_loom_infolist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$loom_info_list->RowType = ROWTYPE_HEADER;

// Render list options
$loom_info_list->renderListOptions();

// Render list options (header, left)
$loom_info_list->ListOptions->render("header", "left");
?>
<?php if ($loom_info->id->Visible) { // id ?>
	<?php if ($loom_info->sortUrl($loom_info->id) == "") { ?>
		<th data-name="id" class="<?php echo $loom_info->id->headerCellClass() ?>"><div id="elh_loom_info_id" class="loom_info_id"><div class="ew-table-header-caption"><?php echo $loom_info->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $loom_info->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $loom_info->SortUrl($loom_info->id) ?>',2);"><div id="elh_loom_info_id" class="loom_info_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $loom_info->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($loom_info->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($loom_info->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($loom_info->grp->Visible) { // grp ?>
	<?php if ($loom_info->sortUrl($loom_info->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $loom_info->grp->headerCellClass() ?>"><div id="elh_loom_info_grp" class="loom_info_grp"><div class="ew-table-header-caption"><?php echo $loom_info->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $loom_info->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $loom_info->SortUrl($loom_info->grp) ?>',2);"><div id="elh_loom_info_grp" class="loom_info_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $loom_info->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($loom_info->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($loom_info->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($loom_info->works->Visible) { // works ?>
	<?php if ($loom_info->sortUrl($loom_info->works) == "") { ?>
		<th data-name="works" class="<?php echo $loom_info->works->headerCellClass() ?>"><div id="elh_loom_info_works" class="loom_info_works"><div class="ew-table-header-caption"><?php echo $loom_info->works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="works" class="<?php echo $loom_info->works->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $loom_info->SortUrl($loom_info->works) ?>',2);"><div id="elh_loom_info_works" class="loom_info_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $loom_info->works->caption() ?></span><span class="ew-table-header-sort"><?php if ($loom_info->works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($loom_info->works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($loom_info->item->Visible) { // item ?>
	<?php if ($loom_info->sortUrl($loom_info->item) == "") { ?>
		<th data-name="item" class="<?php echo $loom_info->item->headerCellClass() ?>"><div id="elh_loom_info_item" class="loom_info_item"><div class="ew-table-header-caption"><?php echo $loom_info->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $loom_info->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $loom_info->SortUrl($loom_info->item) ?>',2);"><div id="elh_loom_info_item" class="loom_info_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $loom_info->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($loom_info->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($loom_info->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($loom_info->size_width->Visible) { // size_width ?>
	<?php if ($loom_info->sortUrl($loom_info->size_width) == "") { ?>
		<th data-name="size_width" class="<?php echo $loom_info->size_width->headerCellClass() ?>"><div id="elh_loom_info_size_width" class="loom_info_size_width"><div class="ew-table-header-caption"><?php echo $loom_info->size_width->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_width" class="<?php echo $loom_info->size_width->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $loom_info->SortUrl($loom_info->size_width) ?>',2);"><div id="elh_loom_info_size_width" class="loom_info_size_width">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $loom_info->size_width->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($loom_info->size_width->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($loom_info->size_width->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($loom_info->prod_sqm_daily->Visible) { // prod_sqm_daily ?>
	<?php if ($loom_info->sortUrl($loom_info->prod_sqm_daily) == "") { ?>
		<th data-name="prod_sqm_daily" class="<?php echo $loom_info->prod_sqm_daily->headerCellClass() ?>"><div id="elh_loom_info_prod_sqm_daily" class="loom_info_prod_sqm_daily"><div class="ew-table-header-caption"><?php echo $loom_info->prod_sqm_daily->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="prod_sqm_daily" class="<?php echo $loom_info->prod_sqm_daily->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $loom_info->SortUrl($loom_info->prod_sqm_daily) ?>',2);"><div id="elh_loom_info_prod_sqm_daily" class="loom_info_prod_sqm_daily">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $loom_info->prod_sqm_daily->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($loom_info->prod_sqm_daily->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($loom_info->prod_sqm_daily->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($loom_info->status->Visible) { // status ?>
	<?php if ($loom_info->sortUrl($loom_info->status) == "") { ?>
		<th data-name="status" class="<?php echo $loom_info->status->headerCellClass() ?>"><div id="elh_loom_info_status" class="loom_info_status"><div class="ew-table-header-caption"><?php echo $loom_info->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $loom_info->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $loom_info->SortUrl($loom_info->status) ?>',2);"><div id="elh_loom_info_status" class="loom_info_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $loom_info->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($loom_info->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($loom_info->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($loom_info->a_barcode->Visible) { // a_barcode ?>
	<?php if ($loom_info->sortUrl($loom_info->a_barcode) == "") { ?>
		<th data-name="a_barcode" class="<?php echo $loom_info->a_barcode->headerCellClass() ?>"><div id="elh_loom_info_a_barcode" class="loom_info_a_barcode"><div class="ew-table-header-caption"><?php echo $loom_info->a_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_barcode" class="<?php echo $loom_info->a_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $loom_info->SortUrl($loom_info->a_barcode) ?>',2);"><div id="elh_loom_info_a_barcode" class="loom_info_a_barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $loom_info->a_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($loom_info->a_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($loom_info->a_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($loom_info->p_sqm->Visible) { // p_sqm ?>
	<?php if ($loom_info->sortUrl($loom_info->p_sqm) == "") { ?>
		<th data-name="p_sqm" class="<?php echo $loom_info->p_sqm->headerCellClass() ?>"><div id="elh_loom_info_p_sqm" class="loom_info_p_sqm"><div class="ew-table-header-caption"><?php echo $loom_info->p_sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="p_sqm" class="<?php echo $loom_info->p_sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $loom_info->SortUrl($loom_info->p_sqm) ?>',2);"><div id="elh_loom_info_p_sqm" class="loom_info_p_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $loom_info->p_sqm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($loom_info->p_sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($loom_info->p_sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($loom_info->operator->Visible) { // operator ?>
	<?php if ($loom_info->sortUrl($loom_info->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $loom_info->operator->headerCellClass() ?>"><div id="elh_loom_info_operator" class="loom_info_operator"><div class="ew-table-header-caption"><?php echo $loom_info->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $loom_info->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $loom_info->SortUrl($loom_info->operator) ?>',2);"><div id="elh_loom_info_operator" class="loom_info_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $loom_info->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($loom_info->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($loom_info->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($loom_info->datetime->Visible) { // datetime ?>
	<?php if ($loom_info->sortUrl($loom_info->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $loom_info->datetime->headerCellClass() ?>"><div id="elh_loom_info_datetime" class="loom_info_datetime"><div class="ew-table-header-caption"><?php echo $loom_info->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $loom_info->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $loom_info->SortUrl($loom_info->datetime) ?>',2);"><div id="elh_loom_info_datetime" class="loom_info_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $loom_info->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($loom_info->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($loom_info->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($loom_info->process->Visible) { // process ?>
	<?php if ($loom_info->sortUrl($loom_info->process) == "") { ?>
		<th data-name="process" class="<?php echo $loom_info->process->headerCellClass() ?>"><div id="elh_loom_info_process" class="loom_info_process"><div class="ew-table-header-caption"><?php echo $loom_info->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $loom_info->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $loom_info->SortUrl($loom_info->process) ?>',2);"><div id="elh_loom_info_process" class="loom_info_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $loom_info->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($loom_info->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($loom_info->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($loom_info->category->Visible) { // category ?>
	<?php if ($loom_info->sortUrl($loom_info->category) == "") { ?>
		<th data-name="category" class="<?php echo $loom_info->category->headerCellClass() ?>"><div id="elh_loom_info_category" class="loom_info_category"><div class="ew-table-header-caption"><?php echo $loom_info->category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category" class="<?php echo $loom_info->category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $loom_info->SortUrl($loom_info->category) ?>',2);"><div id="elh_loom_info_category" class="loom_info_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $loom_info->category->caption() ?></span><span class="ew-table-header-sort"><?php if ($loom_info->category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($loom_info->category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($loom_info->s_prod->Visible) { // s_prod ?>
	<?php if ($loom_info->sortUrl($loom_info->s_prod) == "") { ?>
		<th data-name="s_prod" class="<?php echo $loom_info->s_prod->headerCellClass() ?>"><div id="elh_loom_info_s_prod" class="loom_info_s_prod"><div class="ew-table-header-caption"><?php echo $loom_info->s_prod->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_prod" class="<?php echo $loom_info->s_prod->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $loom_info->SortUrl($loom_info->s_prod) ?>',2);"><div id="elh_loom_info_s_prod" class="loom_info_s_prod">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $loom_info->s_prod->caption() ?></span><span class="ew-table-header-sort"><?php if ($loom_info->s_prod->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($loom_info->s_prod->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$loom_info_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($loom_info->ExportAll && $loom_info->isExport()) {
	$loom_info_list->StopRec = $loom_info_list->TotalRecs;
} else {

	// Set the last record to display
	if ($loom_info_list->TotalRecs > $loom_info_list->StartRec + $loom_info_list->DisplayRecs - 1)
		$loom_info_list->StopRec = $loom_info_list->StartRec + $loom_info_list->DisplayRecs - 1;
	else
		$loom_info_list->StopRec = $loom_info_list->TotalRecs;
}
$loom_info_list->RecCnt = $loom_info_list->StartRec - 1;
if ($loom_info_list->Recordset && !$loom_info_list->Recordset->EOF) {
	$loom_info_list->Recordset->moveFirst();
	$selectLimit = $loom_info_list->UseSelectLimit;
	if (!$selectLimit && $loom_info_list->StartRec > 1)
		$loom_info_list->Recordset->move($loom_info_list->StartRec - 1);
} elseif (!$loom_info->AllowAddDeleteRow && $loom_info_list->StopRec == 0) {
	$loom_info_list->StopRec = $loom_info->GridAddRowCount;
}

// Initialize aggregate
$loom_info->RowType = ROWTYPE_AGGREGATEINIT;
$loom_info->resetAttributes();
$loom_info_list->renderRow();
while ($loom_info_list->RecCnt < $loom_info_list->StopRec) {
	$loom_info_list->RecCnt++;
	if ($loom_info_list->RecCnt >= $loom_info_list->StartRec) {
		$loom_info_list->RowCnt++;

		// Set up key count
		$loom_info_list->KeyCount = $loom_info_list->RowIndex;

		// Init row class and style
		$loom_info->resetAttributes();
		$loom_info->CssClass = "";
		if ($loom_info->isGridAdd()) {
		} else {
			$loom_info_list->loadRowValues($loom_info_list->Recordset); // Load row values
		}
		$loom_info->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$loom_info->RowAttrs = array_merge($loom_info->RowAttrs, array('data-rowindex'=>$loom_info_list->RowCnt, 'id'=>'r' . $loom_info_list->RowCnt . '_loom_info', 'data-rowtype'=>$loom_info->RowType));

		// Render row
		$loom_info_list->renderRow();

		// Render list options
		$loom_info_list->renderListOptions();
?>
	<tr<?php echo $loom_info->rowAttributes() ?>>
<?php

// Render list options (body, left)
$loom_info_list->ListOptions->render("body", "left", $loom_info_list->RowCnt);
?>
	<?php if ($loom_info->id->Visible) { // id ?>
		<td data-name="id"<?php echo $loom_info->id->cellAttributes() ?>>
<span id="el<?php echo $loom_info_list->RowCnt ?>_loom_info_id" class="loom_info_id">
<span<?php echo $loom_info->id->viewAttributes() ?>>
<?php echo $loom_info->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($loom_info->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $loom_info->grp->cellAttributes() ?>>
<span id="el<?php echo $loom_info_list->RowCnt ?>_loom_info_grp" class="loom_info_grp">
<span<?php echo $loom_info->grp->viewAttributes() ?>>
<?php echo $loom_info->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($loom_info->works->Visible) { // works ?>
		<td data-name="works"<?php echo $loom_info->works->cellAttributes() ?>>
<span id="el<?php echo $loom_info_list->RowCnt ?>_loom_info_works" class="loom_info_works">
<span<?php echo $loom_info->works->viewAttributes() ?>>
<?php echo $loom_info->works->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($loom_info->item->Visible) { // item ?>
		<td data-name="item"<?php echo $loom_info->item->cellAttributes() ?>>
<span id="el<?php echo $loom_info_list->RowCnt ?>_loom_info_item" class="loom_info_item">
<span<?php echo $loom_info->item->viewAttributes() ?>>
<?php echo $loom_info->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($loom_info->size_width->Visible) { // size_width ?>
		<td data-name="size_width"<?php echo $loom_info->size_width->cellAttributes() ?>>
<span id="el<?php echo $loom_info_list->RowCnt ?>_loom_info_size_width" class="loom_info_size_width">
<span<?php echo $loom_info->size_width->viewAttributes() ?>>
<?php echo $loom_info->size_width->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($loom_info->prod_sqm_daily->Visible) { // prod_sqm_daily ?>
		<td data-name="prod_sqm_daily"<?php echo $loom_info->prod_sqm_daily->cellAttributes() ?>>
<span id="el<?php echo $loom_info_list->RowCnt ?>_loom_info_prod_sqm_daily" class="loom_info_prod_sqm_daily">
<span<?php echo $loom_info->prod_sqm_daily->viewAttributes() ?>>
<?php echo $loom_info->prod_sqm_daily->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($loom_info->status->Visible) { // status ?>
		<td data-name="status"<?php echo $loom_info->status->cellAttributes() ?>>
<span id="el<?php echo $loom_info_list->RowCnt ?>_loom_info_status" class="loom_info_status">
<span<?php echo $loom_info->status->viewAttributes() ?>>
<?php echo $loom_info->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($loom_info->a_barcode->Visible) { // a_barcode ?>
		<td data-name="a_barcode"<?php echo $loom_info->a_barcode->cellAttributes() ?>>
<span id="el<?php echo $loom_info_list->RowCnt ?>_loom_info_a_barcode" class="loom_info_a_barcode">
<span<?php echo $loom_info->a_barcode->viewAttributes() ?>>
<?php echo $loom_info->a_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($loom_info->p_sqm->Visible) { // p_sqm ?>
		<td data-name="p_sqm"<?php echo $loom_info->p_sqm->cellAttributes() ?>>
<span id="el<?php echo $loom_info_list->RowCnt ?>_loom_info_p_sqm" class="loom_info_p_sqm">
<span<?php echo $loom_info->p_sqm->viewAttributes() ?>>
<?php echo $loom_info->p_sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($loom_info->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $loom_info->operator->cellAttributes() ?>>
<span id="el<?php echo $loom_info_list->RowCnt ?>_loom_info_operator" class="loom_info_operator">
<span<?php echo $loom_info->operator->viewAttributes() ?>>
<?php echo $loom_info->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($loom_info->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $loom_info->datetime->cellAttributes() ?>>
<span id="el<?php echo $loom_info_list->RowCnt ?>_loom_info_datetime" class="loom_info_datetime">
<span<?php echo $loom_info->datetime->viewAttributes() ?>>
<?php echo $loom_info->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($loom_info->process->Visible) { // process ?>
		<td data-name="process"<?php echo $loom_info->process->cellAttributes() ?>>
<span id="el<?php echo $loom_info_list->RowCnt ?>_loom_info_process" class="loom_info_process">
<span<?php echo $loom_info->process->viewAttributes() ?>>
<?php echo $loom_info->process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($loom_info->category->Visible) { // category ?>
		<td data-name="category"<?php echo $loom_info->category->cellAttributes() ?>>
<span id="el<?php echo $loom_info_list->RowCnt ?>_loom_info_category" class="loom_info_category">
<span<?php echo $loom_info->category->viewAttributes() ?>>
<?php echo $loom_info->category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($loom_info->s_prod->Visible) { // s_prod ?>
		<td data-name="s_prod"<?php echo $loom_info->s_prod->cellAttributes() ?>>
<span id="el<?php echo $loom_info_list->RowCnt ?>_loom_info_s_prod" class="loom_info_s_prod">
<span<?php echo $loom_info->s_prod->viewAttributes() ?>>
<?php echo $loom_info->s_prod->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$loom_info_list->ListOptions->render("body", "right", $loom_info_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$loom_info->isGridAdd())
		$loom_info_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$loom_info->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($loom_info_list->Recordset)
	$loom_info_list->Recordset->Close();
?>
<?php if (!$loom_info->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$loom_info->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($loom_info_list->Pager)) $loom_info_list->Pager = new PrevNextPager($loom_info_list->StartRec, $loom_info_list->DisplayRecs, $loom_info_list->TotalRecs, $loom_info_list->AutoHidePager) ?>
<?php if ($loom_info_list->Pager->RecordCount > 0 && $loom_info_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($loom_info_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $loom_info_list->pageUrl() ?>start=<?php echo $loom_info_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($loom_info_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $loom_info_list->pageUrl() ?>start=<?php echo $loom_info_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $loom_info_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($loom_info_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $loom_info_list->pageUrl() ?>start=<?php echo $loom_info_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($loom_info_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $loom_info_list->pageUrl() ?>start=<?php echo $loom_info_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $loom_info_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($loom_info_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $loom_info_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $loom_info_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $loom_info_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($loom_info_list->TotalRecs > 0 && (!$loom_info_list->AutoHidePageSizeSelector || $loom_info_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="loom_info">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($loom_info_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($loom_info_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($loom_info_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($loom_info_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($loom_info_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($loom_info->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $loom_info_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($loom_info_list->TotalRecs == 0 && !$loom_info->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $loom_info_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$loom_info_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$loom_info->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$loom_info->isExport()) { ?>
<script>
ew.scrollableTable("gmp_loom_info", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$loom_info_list->terminate();
?>