<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$loom_info_search = new loom_info_search();

// Run the page
$loom_info_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$loom_info_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($loom_info_search->IsModal) { ?>
var floom_infosearch = currentAdvancedSearchForm = new ew.Form("floom_infosearch", "search");
<?php } else { ?>
var floom_infosearch = currentForm = new ew.Form("floom_infosearch", "search");
<?php } ?>

// Form_CustomValidate event
floom_infosearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
floom_infosearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
floom_infosearch.lists["x_grp"] = <?php echo $loom_info_search->grp->Lookup->toClientList() ?>;
floom_infosearch.lists["x_grp"].options = <?php echo JsonEncode($loom_info_search->grp->lookupOptions()) ?>;
floom_infosearch.lists["x_works"] = <?php echo $loom_info_search->works->Lookup->toClientList() ?>;
floom_infosearch.lists["x_works"].options = <?php echo JsonEncode($loom_info_search->works->lookupOptions()) ?>;
floom_infosearch.lists["x_status"] = <?php echo $loom_info_search->status->Lookup->toClientList() ?>;
floom_infosearch.lists["x_status"].options = <?php echo JsonEncode($loom_info_search->status->options(FALSE, TRUE)) ?>;
floom_infosearch.lists["x_operator"] = <?php echo $loom_info_search->operator->Lookup->toClientList() ?>;
floom_infosearch.lists["x_operator"].options = <?php echo JsonEncode($loom_info_search->operator->lookupOptions()) ?>;
floom_infosearch.lists["x_process"] = <?php echo $loom_info_search->process->Lookup->toClientList() ?>;
floom_infosearch.lists["x_process"].options = <?php echo JsonEncode($loom_info_search->process->lookupOptions()) ?>;
floom_infosearch.lists["x_category"] = <?php echo $loom_info_search->category->Lookup->toClientList() ?>;
floom_infosearch.lists["x_category"].options = <?php echo JsonEncode($loom_info_search->category->lookupOptions()) ?>;

// Form object for search
// Validate function for search

floom_infosearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($loom_info->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_prod_sqm_daily");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($loom_info->prod_sqm_daily->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_p_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($loom_info->p_sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($loom_info->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_s_prod");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($loom_info->s_prod->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $loom_info_search->showPageHeader(); ?>
<?php
$loom_info_search->showMessage();
?>
<form name="floom_infosearch" id="floom_infosearch" class="<?php echo $loom_info_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($loom_info_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $loom_info_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="loom_info">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$loom_info_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($loom_info->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $loom_info_search->LeftColumnClass ?>"><span id="elh_loom_info_id"><?php echo $loom_info->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $loom_info_search->RightColumnClass ?>"><div<?php echo $loom_info->id->cellAttributes() ?>>
			<span id="el_loom_info_id">
<input type="text" data-table="loom_info" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($loom_info->id->getPlaceHolder()) ?>" value="<?php echo $loom_info->id->EditValue ?>"<?php echo $loom_info->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($loom_info->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $loom_info_search->LeftColumnClass ?>"><span id="elh_loom_info_grp"><?php echo $loom_info->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $loom_info_search->RightColumnClass ?>"><div<?php echo $loom_info->grp->cellAttributes() ?>>
			<span id="el_loom_info_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="loom_info" data-field="x_grp" data-value-separator="<?php echo $loom_info->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $loom_info->grp->editAttributes() ?>>
		<?php echo $loom_info->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $loom_info->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($loom_info->works->Visible) { // works ?>
	<div id="r_works" class="form-group row">
		<label for="x_works" class="<?php echo $loom_info_search->LeftColumnClass ?>"><span id="elh_loom_info_works"><?php echo $loom_info->works->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_works" id="z_works" value="="></span>
		</label>
		<div class="<?php echo $loom_info_search->RightColumnClass ?>"><div<?php echo $loom_info->works->cellAttributes() ?>>
			<span id="el_loom_info_works">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="loom_info" data-field="x_works" data-value-separator="<?php echo $loom_info->works->displayValueSeparatorAttribute() ?>" id="x_works" name="x_works"<?php echo $loom_info->works->editAttributes() ?>>
		<?php echo $loom_info->works->selectOptionListHtml("x_works") ?>
	</select>
</div>
<?php echo $loom_info->works->Lookup->getParamTag("p_x_works") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($loom_info->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label for="x_item" class="<?php echo $loom_info_search->LeftColumnClass ?>"><span id="elh_loom_info_item"><?php echo $loom_info->item->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_item" id="z_item" value="LIKE"></span>
		</label>
		<div class="<?php echo $loom_info_search->RightColumnClass ?>"><div<?php echo $loom_info->item->cellAttributes() ?>>
			<span id="el_loom_info_item">
<input type="text" data-table="loom_info" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($loom_info->item->getPlaceHolder()) ?>" value="<?php echo $loom_info->item->EditValue ?>"<?php echo $loom_info->item->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($loom_info->size_width->Visible) { // size_width ?>
	<div id="r_size_width" class="form-group row">
		<label for="x_size_width" class="<?php echo $loom_info_search->LeftColumnClass ?>"><span id="elh_loom_info_size_width"><?php echo $loom_info->size_width->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size_width" id="z_size_width" value="LIKE"></span>
		</label>
		<div class="<?php echo $loom_info_search->RightColumnClass ?>"><div<?php echo $loom_info->size_width->cellAttributes() ?>>
			<span id="el_loom_info_size_width">
<input type="text" data-table="loom_info" data-field="x_size_width" name="x_size_width" id="x_size_width" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($loom_info->size_width->getPlaceHolder()) ?>" value="<?php echo $loom_info->size_width->EditValue ?>"<?php echo $loom_info->size_width->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($loom_info->prod_sqm_daily->Visible) { // prod_sqm_daily ?>
	<div id="r_prod_sqm_daily" class="form-group row">
		<label for="x_prod_sqm_daily" class="<?php echo $loom_info_search->LeftColumnClass ?>"><span id="elh_loom_info_prod_sqm_daily"><?php echo $loom_info->prod_sqm_daily->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_prod_sqm_daily" id="z_prod_sqm_daily" value="="></span>
		</label>
		<div class="<?php echo $loom_info_search->RightColumnClass ?>"><div<?php echo $loom_info->prod_sqm_daily->cellAttributes() ?>>
			<span id="el_loom_info_prod_sqm_daily">
<input type="text" data-table="loom_info" data-field="x_prod_sqm_daily" name="x_prod_sqm_daily" id="x_prod_sqm_daily" size="30" placeholder="<?php echo HtmlEncode($loom_info->prod_sqm_daily->getPlaceHolder()) ?>" value="<?php echo $loom_info->prod_sqm_daily->EditValue ?>"<?php echo $loom_info->prod_sqm_daily->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($loom_info->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $loom_info_search->LeftColumnClass ?>"><span id="elh_loom_info_status"><?php echo $loom_info->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $loom_info_search->RightColumnClass ?>"><div<?php echo $loom_info->status->cellAttributes() ?>>
			<span id="el_loom_info_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="loom_info" data-field="x_status" data-value-separator="<?php echo $loom_info->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $loom_info->status->editAttributes() ?>>
		<?php echo $loom_info->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($loom_info->a_barcode->Visible) { // a_barcode ?>
	<div id="r_a_barcode" class="form-group row">
		<label for="x_a_barcode" class="<?php echo $loom_info_search->LeftColumnClass ?>"><span id="elh_loom_info_a_barcode"><?php echo $loom_info->a_barcode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_a_barcode" id="z_a_barcode" value="LIKE"></span>
		</label>
		<div class="<?php echo $loom_info_search->RightColumnClass ?>"><div<?php echo $loom_info->a_barcode->cellAttributes() ?>>
			<span id="el_loom_info_a_barcode">
<input type="text" data-table="loom_info" data-field="x_a_barcode" name="x_a_barcode" id="x_a_barcode" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($loom_info->a_barcode->getPlaceHolder()) ?>" value="<?php echo $loom_info->a_barcode->EditValue ?>"<?php echo $loom_info->a_barcode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($loom_info->p_sqm->Visible) { // p_sqm ?>
	<div id="r_p_sqm" class="form-group row">
		<label for="x_p_sqm" class="<?php echo $loom_info_search->LeftColumnClass ?>"><span id="elh_loom_info_p_sqm"><?php echo $loom_info->p_sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_p_sqm" id="z_p_sqm" value="="></span>
		</label>
		<div class="<?php echo $loom_info_search->RightColumnClass ?>"><div<?php echo $loom_info->p_sqm->cellAttributes() ?>>
			<span id="el_loom_info_p_sqm">
<input type="text" data-table="loom_info" data-field="x_p_sqm" name="x_p_sqm" id="x_p_sqm" size="30" placeholder="<?php echo HtmlEncode($loom_info->p_sqm->getPlaceHolder()) ?>" value="<?php echo $loom_info->p_sqm->EditValue ?>"<?php echo $loom_info->p_sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($loom_info->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $loom_info_search->LeftColumnClass ?>"><span id="elh_loom_info_operator"><?php echo $loom_info->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $loom_info_search->RightColumnClass ?>"><div<?php echo $loom_info->operator->cellAttributes() ?>>
			<span id="el_loom_info_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="loom_info" data-field="x_operator" data-value-separator="<?php echo $loom_info->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $loom_info->operator->editAttributes() ?>>
		<?php echo $loom_info->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $loom_info->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($loom_info->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $loom_info_search->LeftColumnClass ?>"><span id="elh_loom_info_datetime"><?php echo $loom_info->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $loom_info_search->RightColumnClass ?>"><div<?php echo $loom_info->datetime->cellAttributes() ?>>
			<span id="el_loom_info_datetime">
<input type="text" data-table="loom_info" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($loom_info->datetime->getPlaceHolder()) ?>" value="<?php echo $loom_info->datetime->EditValue ?>"<?php echo $loom_info->datetime->editAttributes() ?>>
<?php if (!$loom_info->datetime->ReadOnly && !$loom_info->datetime->Disabled && !isset($loom_info->datetime->EditAttrs["readonly"]) && !isset($loom_info->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("floom_infosearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($loom_info->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label for="x_process" class="<?php echo $loom_info_search->LeftColumnClass ?>"><span id="elh_loom_info_process"><?php echo $loom_info->process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		</label>
		<div class="<?php echo $loom_info_search->RightColumnClass ?>"><div<?php echo $loom_info->process->cellAttributes() ?>>
			<span id="el_loom_info_process">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="loom_info" data-field="x_process" data-value-separator="<?php echo $loom_info->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $loom_info->process->editAttributes() ?>>
		<?php echo $loom_info->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $loom_info->process->Lookup->getParamTag("p_x_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($loom_info->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label for="x_category" class="<?php echo $loom_info_search->LeftColumnClass ?>"><span id="elh_loom_info_category"><?php echo $loom_info->category->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_category" id="z_category" value="="></span>
		</label>
		<div class="<?php echo $loom_info_search->RightColumnClass ?>"><div<?php echo $loom_info->category->cellAttributes() ?>>
			<span id="el_loom_info_category">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="loom_info" data-field="x_category" data-value-separator="<?php echo $loom_info->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $loom_info->category->editAttributes() ?>>
		<?php echo $loom_info->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
<?php echo $loom_info->category->Lookup->getParamTag("p_x_category") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($loom_info->s_prod->Visible) { // s_prod ?>
	<div id="r_s_prod" class="form-group row">
		<label for="x_s_prod" class="<?php echo $loom_info_search->LeftColumnClass ?>"><span id="elh_loom_info_s_prod"><?php echo $loom_info->s_prod->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_prod" id="z_s_prod" value="="></span>
		</label>
		<div class="<?php echo $loom_info_search->RightColumnClass ?>"><div<?php echo $loom_info->s_prod->cellAttributes() ?>>
			<span id="el_loom_info_s_prod">
<input type="text" data-table="loom_info" data-field="x_s_prod" name="x_s_prod" id="x_s_prod" size="30" placeholder="<?php echo HtmlEncode($loom_info->s_prod->getPlaceHolder()) ?>" value="<?php echo $loom_info->s_prod->EditValue ?>"<?php echo $loom_info->s_prod->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$loom_info_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $loom_info_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$loom_info_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$loom_info_search->terminate();
?>