<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$loom_info_view = new loom_info_view();

// Run the page
$loom_info_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$loom_info_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$loom_info->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var floom_infoview = currentForm = new ew.Form("floom_infoview", "view");

// Form_CustomValidate event
floom_infoview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
floom_infoview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
floom_infoview.lists["x_grp"] = <?php echo $loom_info_view->grp->Lookup->toClientList() ?>;
floom_infoview.lists["x_grp"].options = <?php echo JsonEncode($loom_info_view->grp->lookupOptions()) ?>;
floom_infoview.lists["x_works"] = <?php echo $loom_info_view->works->Lookup->toClientList() ?>;
floom_infoview.lists["x_works"].options = <?php echo JsonEncode($loom_info_view->works->lookupOptions()) ?>;
floom_infoview.lists["x_status"] = <?php echo $loom_info_view->status->Lookup->toClientList() ?>;
floom_infoview.lists["x_status"].options = <?php echo JsonEncode($loom_info_view->status->options(FALSE, TRUE)) ?>;
floom_infoview.lists["x_operator"] = <?php echo $loom_info_view->operator->Lookup->toClientList() ?>;
floom_infoview.lists["x_operator"].options = <?php echo JsonEncode($loom_info_view->operator->lookupOptions()) ?>;
floom_infoview.lists["x_process"] = <?php echo $loom_info_view->process->Lookup->toClientList() ?>;
floom_infoview.lists["x_process"].options = <?php echo JsonEncode($loom_info_view->process->lookupOptions()) ?>;
floom_infoview.lists["x_category"] = <?php echo $loom_info_view->category->Lookup->toClientList() ?>;
floom_infoview.lists["x_category"].options = <?php echo JsonEncode($loom_info_view->category->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$loom_info->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $loom_info_view->ExportOptions->render("body") ?>
<?php $loom_info_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $loom_info_view->showPageHeader(); ?>
<?php
$loom_info_view->showMessage();
?>
<form name="floom_infoview" id="floom_infoview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($loom_info_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $loom_info_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="loom_info">
<input type="hidden" name="modal" value="<?php echo (int)$loom_info_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($loom_info->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $loom_info_view->TableLeftColumnClass ?>"><span id="elh_loom_info_id"><?php echo $loom_info->id->caption() ?></span></td>
		<td data-name="id"<?php echo $loom_info->id->cellAttributes() ?>>
<span id="el_loom_info_id">
<span<?php echo $loom_info->id->viewAttributes() ?>>
<?php echo $loom_info->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($loom_info->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $loom_info_view->TableLeftColumnClass ?>"><span id="elh_loom_info_grp"><?php echo $loom_info->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $loom_info->grp->cellAttributes() ?>>
<span id="el_loom_info_grp">
<span<?php echo $loom_info->grp->viewAttributes() ?>>
<?php echo $loom_info->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($loom_info->works->Visible) { // works ?>
	<tr id="r_works">
		<td class="<?php echo $loom_info_view->TableLeftColumnClass ?>"><span id="elh_loom_info_works"><?php echo $loom_info->works->caption() ?></span></td>
		<td data-name="works"<?php echo $loom_info->works->cellAttributes() ?>>
<span id="el_loom_info_works">
<span<?php echo $loom_info->works->viewAttributes() ?>>
<?php echo $loom_info->works->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($loom_info->item->Visible) { // item ?>
	<tr id="r_item">
		<td class="<?php echo $loom_info_view->TableLeftColumnClass ?>"><span id="elh_loom_info_item"><?php echo $loom_info->item->caption() ?></span></td>
		<td data-name="item"<?php echo $loom_info->item->cellAttributes() ?>>
<span id="el_loom_info_item">
<span<?php echo $loom_info->item->viewAttributes() ?>>
<?php echo $loom_info->item->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($loom_info->size_width->Visible) { // size_width ?>
	<tr id="r_size_width">
		<td class="<?php echo $loom_info_view->TableLeftColumnClass ?>"><span id="elh_loom_info_size_width"><?php echo $loom_info->size_width->caption() ?></span></td>
		<td data-name="size_width"<?php echo $loom_info->size_width->cellAttributes() ?>>
<span id="el_loom_info_size_width">
<span<?php echo $loom_info->size_width->viewAttributes() ?>>
<?php echo $loom_info->size_width->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($loom_info->prod_sqm_daily->Visible) { // prod_sqm_daily ?>
	<tr id="r_prod_sqm_daily">
		<td class="<?php echo $loom_info_view->TableLeftColumnClass ?>"><span id="elh_loom_info_prod_sqm_daily"><?php echo $loom_info->prod_sqm_daily->caption() ?></span></td>
		<td data-name="prod_sqm_daily"<?php echo $loom_info->prod_sqm_daily->cellAttributes() ?>>
<span id="el_loom_info_prod_sqm_daily">
<span<?php echo $loom_info->prod_sqm_daily->viewAttributes() ?>>
<?php echo $loom_info->prod_sqm_daily->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($loom_info->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $loom_info_view->TableLeftColumnClass ?>"><span id="elh_loom_info_status"><?php echo $loom_info->status->caption() ?></span></td>
		<td data-name="status"<?php echo $loom_info->status->cellAttributes() ?>>
<span id="el_loom_info_status">
<span<?php echo $loom_info->status->viewAttributes() ?>>
<?php echo $loom_info->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($loom_info->a_barcode->Visible) { // a_barcode ?>
	<tr id="r_a_barcode">
		<td class="<?php echo $loom_info_view->TableLeftColumnClass ?>"><span id="elh_loom_info_a_barcode"><?php echo $loom_info->a_barcode->caption() ?></span></td>
		<td data-name="a_barcode"<?php echo $loom_info->a_barcode->cellAttributes() ?>>
<span id="el_loom_info_a_barcode">
<span<?php echo $loom_info->a_barcode->viewAttributes() ?>>
<?php echo $loom_info->a_barcode->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($loom_info->p_sqm->Visible) { // p_sqm ?>
	<tr id="r_p_sqm">
		<td class="<?php echo $loom_info_view->TableLeftColumnClass ?>"><span id="elh_loom_info_p_sqm"><?php echo $loom_info->p_sqm->caption() ?></span></td>
		<td data-name="p_sqm"<?php echo $loom_info->p_sqm->cellAttributes() ?>>
<span id="el_loom_info_p_sqm">
<span<?php echo $loom_info->p_sqm->viewAttributes() ?>>
<?php echo $loom_info->p_sqm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($loom_info->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $loom_info_view->TableLeftColumnClass ?>"><span id="elh_loom_info_operator"><?php echo $loom_info->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $loom_info->operator->cellAttributes() ?>>
<span id="el_loom_info_operator">
<span<?php echo $loom_info->operator->viewAttributes() ?>>
<?php echo $loom_info->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($loom_info->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $loom_info_view->TableLeftColumnClass ?>"><span id="elh_loom_info_datetime"><?php echo $loom_info->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $loom_info->datetime->cellAttributes() ?>>
<span id="el_loom_info_datetime">
<span<?php echo $loom_info->datetime->viewAttributes() ?>>
<?php echo $loom_info->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($loom_info->process->Visible) { // process ?>
	<tr id="r_process">
		<td class="<?php echo $loom_info_view->TableLeftColumnClass ?>"><span id="elh_loom_info_process"><?php echo $loom_info->process->caption() ?></span></td>
		<td data-name="process"<?php echo $loom_info->process->cellAttributes() ?>>
<span id="el_loom_info_process">
<span<?php echo $loom_info->process->viewAttributes() ?>>
<?php echo $loom_info->process->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($loom_info->category->Visible) { // category ?>
	<tr id="r_category">
		<td class="<?php echo $loom_info_view->TableLeftColumnClass ?>"><span id="elh_loom_info_category"><?php echo $loom_info->category->caption() ?></span></td>
		<td data-name="category"<?php echo $loom_info->category->cellAttributes() ?>>
<span id="el_loom_info_category">
<span<?php echo $loom_info->category->viewAttributes() ?>>
<?php echo $loom_info->category->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($loom_info->s_prod->Visible) { // s_prod ?>
	<tr id="r_s_prod">
		<td class="<?php echo $loom_info_view->TableLeftColumnClass ?>"><span id="elh_loom_info_s_prod"><?php echo $loom_info->s_prod->caption() ?></span></td>
		<td data-name="s_prod"<?php echo $loom_info->s_prod->cellAttributes() ?>>
<span id="el_loom_info_s_prod">
<span<?php echo $loom_info->s_prod->viewAttributes() ?>>
<?php echo $loom_info->s_prod->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$loom_info_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$loom_info->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$loom_info_view->terminate();
?>