<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$mail_record_list = new mail_record_list();

// Run the page
$mail_record_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$mail_record_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$mail_record->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmail_recordlist = currentForm = new ew.Form("fmail_recordlist", "list");
fmail_recordlist.formKeyCountName = '<?php echo $mail_record_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmail_recordlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmail_recordlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fmail_recordlistsrch = currentSearchForm = new ew.Form("fmail_recordlistsrch");

// Filters
fmail_recordlistsrch.filterList = <?php echo $mail_record_list->getFilterList() ?>;

// Init search panel as collapsed
fmail_recordlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$mail_record->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($mail_record_list->TotalRecs > 0 && $mail_record_list->ExportOptions->visible()) { ?>
<?php $mail_record_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($mail_record_list->ImportOptions->visible()) { ?>
<?php $mail_record_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($mail_record_list->SearchOptions->visible()) { ?>
<?php $mail_record_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($mail_record_list->FilterOptions->visible()) { ?>
<?php $mail_record_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$mail_record_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$mail_record->isExport() && !$mail_record->CurrentAction) { ?>
<form name="fmail_recordlistsrch" id="fmail_recordlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($mail_record_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmail_recordlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="mail_record">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($mail_record_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($mail_record_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $mail_record_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($mail_record_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($mail_record_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($mail_record_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($mail_record_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $mail_record_list->showPageHeader(); ?>
<?php
$mail_record_list->showMessage();
?>
<?php if ($mail_record_list->TotalRecs > 0 || $mail_record->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($mail_record_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> mail_record">
<?php if (!$mail_record->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$mail_record->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($mail_record_list->Pager)) $mail_record_list->Pager = new PrevNextPager($mail_record_list->StartRec, $mail_record_list->DisplayRecs, $mail_record_list->TotalRecs, $mail_record_list->AutoHidePager) ?>
<?php if ($mail_record_list->Pager->RecordCount > 0 && $mail_record_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($mail_record_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $mail_record_list->pageUrl() ?>start=<?php echo $mail_record_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($mail_record_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $mail_record_list->pageUrl() ?>start=<?php echo $mail_record_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $mail_record_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($mail_record_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $mail_record_list->pageUrl() ?>start=<?php echo $mail_record_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($mail_record_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $mail_record_list->pageUrl() ?>start=<?php echo $mail_record_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $mail_record_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($mail_record_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $mail_record_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $mail_record_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $mail_record_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($mail_record_list->TotalRecs > 0 && (!$mail_record_list->AutoHidePageSizeSelector || $mail_record_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="mail_record">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($mail_record_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($mail_record_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($mail_record_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($mail_record_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($mail_record_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($mail_record->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $mail_record_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmail_recordlist" id="fmail_recordlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($mail_record_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $mail_record_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="mail_record">
<div id="gmp_mail_record" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($mail_record_list->TotalRecs > 0 || $mail_record->isGridEdit()) { ?>
<table id="tbl_mail_recordlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$mail_record_list->RowType = ROWTYPE_HEADER;

// Render list options
$mail_record_list->renderListOptions();

// Render list options (header, left)
$mail_record_list->ListOptions->render("header", "left");
?>
<?php if ($mail_record->id->Visible) { // id ?>
	<?php if ($mail_record->sortUrl($mail_record->id) == "") { ?>
		<th data-name="id" class="<?php echo $mail_record->id->headerCellClass() ?>"><div id="elh_mail_record_id" class="mail_record_id"><div class="ew-table-header-caption"><?php echo $mail_record->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $mail_record->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mail_record->SortUrl($mail_record->id) ?>',2);"><div id="elh_mail_record_id" class="mail_record_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mail_record->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($mail_record->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mail_record->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mail_record->subject->Visible) { // subject ?>
	<?php if ($mail_record->sortUrl($mail_record->subject) == "") { ?>
		<th data-name="subject" class="<?php echo $mail_record->subject->headerCellClass() ?>"><div id="elh_mail_record_subject" class="mail_record_subject"><div class="ew-table-header-caption"><?php echo $mail_record->subject->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="subject" class="<?php echo $mail_record->subject->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mail_record->SortUrl($mail_record->subject) ?>',2);"><div id="elh_mail_record_subject" class="mail_record_subject">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mail_record->subject->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($mail_record->subject->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mail_record->subject->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mail_record->status->Visible) { // status ?>
	<?php if ($mail_record->sortUrl($mail_record->status) == "") { ?>
		<th data-name="status" class="<?php echo $mail_record->status->headerCellClass() ?>"><div id="elh_mail_record_status" class="mail_record_status"><div class="ew-table-header-caption"><?php echo $mail_record->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $mail_record->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mail_record->SortUrl($mail_record->status) ?>',2);"><div id="elh_mail_record_status" class="mail_record_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mail_record->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($mail_record->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mail_record->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mail_record->operator->Visible) { // operator ?>
	<?php if ($mail_record->sortUrl($mail_record->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $mail_record->operator->headerCellClass() ?>"><div id="elh_mail_record_operator" class="mail_record_operator"><div class="ew-table-header-caption"><?php echo $mail_record->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $mail_record->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mail_record->SortUrl($mail_record->operator) ?>',2);"><div id="elh_mail_record_operator" class="mail_record_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mail_record->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($mail_record->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mail_record->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mail_record->datetime->Visible) { // datetime ?>
	<?php if ($mail_record->sortUrl($mail_record->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $mail_record->datetime->headerCellClass() ?>"><div id="elh_mail_record_datetime" class="mail_record_datetime"><div class="ew-table-header-caption"><?php echo $mail_record->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $mail_record->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mail_record->SortUrl($mail_record->datetime) ?>',2);"><div id="elh_mail_record_datetime" class="mail_record_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mail_record->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($mail_record->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mail_record->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mail_record->company_id->Visible) { // company_id ?>
	<?php if ($mail_record->sortUrl($mail_record->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $mail_record->company_id->headerCellClass() ?>"><div id="elh_mail_record_company_id" class="mail_record_company_id"><div class="ew-table-header-caption"><?php echo $mail_record->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $mail_record->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mail_record->SortUrl($mail_record->company_id) ?>',2);"><div id="elh_mail_record_company_id" class="mail_record_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mail_record->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($mail_record->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mail_record->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mail_record->sender_id->Visible) { // sender_id ?>
	<?php if ($mail_record->sortUrl($mail_record->sender_id) == "") { ?>
		<th data-name="sender_id" class="<?php echo $mail_record->sender_id->headerCellClass() ?>"><div id="elh_mail_record_sender_id" class="mail_record_sender_id"><div class="ew-table-header-caption"><?php echo $mail_record->sender_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sender_id" class="<?php echo $mail_record->sender_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mail_record->SortUrl($mail_record->sender_id) ?>',2);"><div id="elh_mail_record_sender_id" class="mail_record_sender_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mail_record->sender_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($mail_record->sender_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mail_record->sender_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mail_record->user_id->Visible) { // user_id ?>
	<?php if ($mail_record->sortUrl($mail_record->user_id) == "") { ?>
		<th data-name="user_id" class="<?php echo $mail_record->user_id->headerCellClass() ?>"><div id="elh_mail_record_user_id" class="mail_record_user_id"><div class="ew-table-header-caption"><?php echo $mail_record->user_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="user_id" class="<?php echo $mail_record->user_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mail_record->SortUrl($mail_record->user_id) ?>',2);"><div id="elh_mail_record_user_id" class="mail_record_user_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mail_record->user_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($mail_record->user_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mail_record->user_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$mail_record_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($mail_record->ExportAll && $mail_record->isExport()) {
	$mail_record_list->StopRec = $mail_record_list->TotalRecs;
} else {

	// Set the last record to display
	if ($mail_record_list->TotalRecs > $mail_record_list->StartRec + $mail_record_list->DisplayRecs - 1)
		$mail_record_list->StopRec = $mail_record_list->StartRec + $mail_record_list->DisplayRecs - 1;
	else
		$mail_record_list->StopRec = $mail_record_list->TotalRecs;
}
$mail_record_list->RecCnt = $mail_record_list->StartRec - 1;
if ($mail_record_list->Recordset && !$mail_record_list->Recordset->EOF) {
	$mail_record_list->Recordset->moveFirst();
	$selectLimit = $mail_record_list->UseSelectLimit;
	if (!$selectLimit && $mail_record_list->StartRec > 1)
		$mail_record_list->Recordset->move($mail_record_list->StartRec - 1);
} elseif (!$mail_record->AllowAddDeleteRow && $mail_record_list->StopRec == 0) {
	$mail_record_list->StopRec = $mail_record->GridAddRowCount;
}

// Initialize aggregate
$mail_record->RowType = ROWTYPE_AGGREGATEINIT;
$mail_record->resetAttributes();
$mail_record_list->renderRow();
while ($mail_record_list->RecCnt < $mail_record_list->StopRec) {
	$mail_record_list->RecCnt++;
	if ($mail_record_list->RecCnt >= $mail_record_list->StartRec) {
		$mail_record_list->RowCnt++;

		// Set up key count
		$mail_record_list->KeyCount = $mail_record_list->RowIndex;

		// Init row class and style
		$mail_record->resetAttributes();
		$mail_record->CssClass = "";
		if ($mail_record->isGridAdd()) {
		} else {
			$mail_record_list->loadRowValues($mail_record_list->Recordset); // Load row values
		}
		$mail_record->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$mail_record->RowAttrs = array_merge($mail_record->RowAttrs, array('data-rowindex'=>$mail_record_list->RowCnt, 'id'=>'r' . $mail_record_list->RowCnt . '_mail_record', 'data-rowtype'=>$mail_record->RowType));

		// Render row
		$mail_record_list->renderRow();

		// Render list options
		$mail_record_list->renderListOptions();
?>
	<tr<?php echo $mail_record->rowAttributes() ?>>
<?php

// Render list options (body, left)
$mail_record_list->ListOptions->render("body", "left", $mail_record_list->RowCnt);
?>
	<?php if ($mail_record->id->Visible) { // id ?>
		<td data-name="id"<?php echo $mail_record->id->cellAttributes() ?>>
<span id="el<?php echo $mail_record_list->RowCnt ?>_mail_record_id" class="mail_record_id">
<span<?php echo $mail_record->id->viewAttributes() ?>>
<?php echo $mail_record->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mail_record->subject->Visible) { // subject ?>
		<td data-name="subject"<?php echo $mail_record->subject->cellAttributes() ?>>
<span id="el<?php echo $mail_record_list->RowCnt ?>_mail_record_subject" class="mail_record_subject">
<span<?php echo $mail_record->subject->viewAttributes() ?>>
<?php echo $mail_record->subject->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mail_record->status->Visible) { // status ?>
		<td data-name="status"<?php echo $mail_record->status->cellAttributes() ?>>
<span id="el<?php echo $mail_record_list->RowCnt ?>_mail_record_status" class="mail_record_status">
<span<?php echo $mail_record->status->viewAttributes() ?>>
<?php echo $mail_record->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mail_record->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $mail_record->operator->cellAttributes() ?>>
<span id="el<?php echo $mail_record_list->RowCnt ?>_mail_record_operator" class="mail_record_operator">
<span<?php echo $mail_record->operator->viewAttributes() ?>>
<?php echo $mail_record->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mail_record->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $mail_record->datetime->cellAttributes() ?>>
<span id="el<?php echo $mail_record_list->RowCnt ?>_mail_record_datetime" class="mail_record_datetime">
<span<?php echo $mail_record->datetime->viewAttributes() ?>>
<?php echo $mail_record->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mail_record->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $mail_record->company_id->cellAttributes() ?>>
<span id="el<?php echo $mail_record_list->RowCnt ?>_mail_record_company_id" class="mail_record_company_id">
<span<?php echo $mail_record->company_id->viewAttributes() ?>>
<?php echo $mail_record->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mail_record->sender_id->Visible) { // sender_id ?>
		<td data-name="sender_id"<?php echo $mail_record->sender_id->cellAttributes() ?>>
<span id="el<?php echo $mail_record_list->RowCnt ?>_mail_record_sender_id" class="mail_record_sender_id">
<span<?php echo $mail_record->sender_id->viewAttributes() ?>>
<?php echo $mail_record->sender_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mail_record->user_id->Visible) { // user_id ?>
		<td data-name="user_id"<?php echo $mail_record->user_id->cellAttributes() ?>>
<span id="el<?php echo $mail_record_list->RowCnt ?>_mail_record_user_id" class="mail_record_user_id">
<span<?php echo $mail_record->user_id->viewAttributes() ?>>
<?php echo $mail_record->user_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$mail_record_list->ListOptions->render("body", "right", $mail_record_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$mail_record->isGridAdd())
		$mail_record_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$mail_record->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($mail_record_list->Recordset)
	$mail_record_list->Recordset->Close();
?>
<?php if (!$mail_record->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$mail_record->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($mail_record_list->Pager)) $mail_record_list->Pager = new PrevNextPager($mail_record_list->StartRec, $mail_record_list->DisplayRecs, $mail_record_list->TotalRecs, $mail_record_list->AutoHidePager) ?>
<?php if ($mail_record_list->Pager->RecordCount > 0 && $mail_record_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($mail_record_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $mail_record_list->pageUrl() ?>start=<?php echo $mail_record_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($mail_record_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $mail_record_list->pageUrl() ?>start=<?php echo $mail_record_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $mail_record_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($mail_record_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $mail_record_list->pageUrl() ?>start=<?php echo $mail_record_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($mail_record_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $mail_record_list->pageUrl() ?>start=<?php echo $mail_record_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $mail_record_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($mail_record_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $mail_record_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $mail_record_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $mail_record_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($mail_record_list->TotalRecs > 0 && (!$mail_record_list->AutoHidePageSizeSelector || $mail_record_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="mail_record">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($mail_record_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($mail_record_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($mail_record_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($mail_record_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($mail_record_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($mail_record->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $mail_record_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($mail_record_list->TotalRecs == 0 && !$mail_record->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $mail_record_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$mail_record_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$mail_record->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$mail_record->isExport()) { ?>
<script>
ew.scrollableTable("gmp_mail_record", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$mail_record_list->terminate();
?>