<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$mail_setup_edit = new mail_setup_edit();

// Run the page
$mail_setup_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$mail_setup_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fmail_setupedit = currentForm = new ew.Form("fmail_setupedit", "edit");

// Validate form
fmail_setupedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($mail_setup_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $mail_setup->id->caption(), $mail_setup->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($mail_setup_edit->user_name->Required) { ?>
			elm = this.getElements("x" + infix + "_user_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $mail_setup->user_name->caption(), $mail_setup->user_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($mail_setup_edit->password->Required) { ?>
			elm = this.getElements("x" + infix + "_password");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $mail_setup->password->caption(), $mail_setup->password->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($mail_setup_edit->smtp_server->Required) { ?>
			elm = this.getElements("x" + infix + "_smtp_server");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $mail_setup->smtp_server->caption(), $mail_setup->smtp_server->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($mail_setup_edit->port->Required) { ?>
			elm = this.getElements("x" + infix + "_port");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $mail_setup->port->caption(), $mail_setup->port->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($mail_setup_edit->ssl->Required) { ?>
			elm = this.getElements("x" + infix + "_ssl");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $mail_setup->ssl->caption(), $mail_setup->ssl->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($mail_setup_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $mail_setup->operator->caption(), $mail_setup->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($mail_setup->operator->errorMessage()) ?>");
		<?php if ($mail_setup_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $mail_setup->datetime->caption(), $mail_setup->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($mail_setup->datetime->errorMessage()) ?>");
		<?php if ($mail_setup_edit->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $mail_setup->company_id->caption(), $mail_setup->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($mail_setup->company_id->errorMessage()) ?>");
		<?php if ($mail_setup_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $mail_setup->status->caption(), $mail_setup->status->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($mail_setup->status->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fmail_setupedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmail_setupedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $mail_setup_edit->showPageHeader(); ?>
<?php
$mail_setup_edit->showMessage();
?>
<form name="fmail_setupedit" id="fmail_setupedit" class="<?php echo $mail_setup_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($mail_setup_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $mail_setup_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="mail_setup">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$mail_setup_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($mail_setup->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_mail_setup_id" class="<?php echo $mail_setup_edit->LeftColumnClass ?>"><?php echo $mail_setup->id->caption() ?><?php echo ($mail_setup->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $mail_setup_edit->RightColumnClass ?>"><div<?php echo $mail_setup->id->cellAttributes() ?>>
<span id="el_mail_setup_id">
<span<?php echo $mail_setup->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($mail_setup->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="mail_setup" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($mail_setup->id->CurrentValue) ?>">
<?php echo $mail_setup->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($mail_setup->user_name->Visible) { // user_name ?>
	<div id="r_user_name" class="form-group row">
		<label id="elh_mail_setup_user_name" for="x_user_name" class="<?php echo $mail_setup_edit->LeftColumnClass ?>"><?php echo $mail_setup->user_name->caption() ?><?php echo ($mail_setup->user_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $mail_setup_edit->RightColumnClass ?>"><div<?php echo $mail_setup->user_name->cellAttributes() ?>>
<span id="el_mail_setup_user_name">
<input type="text" data-table="mail_setup" data-field="x_user_name" name="x_user_name" id="x_user_name" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($mail_setup->user_name->getPlaceHolder()) ?>" value="<?php echo $mail_setup->user_name->EditValue ?>"<?php echo $mail_setup->user_name->editAttributes() ?>>
</span>
<?php echo $mail_setup->user_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($mail_setup->password->Visible) { // password ?>
	<div id="r_password" class="form-group row">
		<label id="elh_mail_setup_password" for="x_password" class="<?php echo $mail_setup_edit->LeftColumnClass ?>"><?php echo $mail_setup->password->caption() ?><?php echo ($mail_setup->password->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $mail_setup_edit->RightColumnClass ?>"><div<?php echo $mail_setup->password->cellAttributes() ?>>
<span id="el_mail_setup_password">
<input type="text" data-table="mail_setup" data-field="x_password" name="x_password" id="x_password" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($mail_setup->password->getPlaceHolder()) ?>" value="<?php echo $mail_setup->password->EditValue ?>"<?php echo $mail_setup->password->editAttributes() ?>>
</span>
<?php echo $mail_setup->password->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($mail_setup->smtp_server->Visible) { // smtp_server ?>
	<div id="r_smtp_server" class="form-group row">
		<label id="elh_mail_setup_smtp_server" for="x_smtp_server" class="<?php echo $mail_setup_edit->LeftColumnClass ?>"><?php echo $mail_setup->smtp_server->caption() ?><?php echo ($mail_setup->smtp_server->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $mail_setup_edit->RightColumnClass ?>"><div<?php echo $mail_setup->smtp_server->cellAttributes() ?>>
<span id="el_mail_setup_smtp_server">
<input type="text" data-table="mail_setup" data-field="x_smtp_server" name="x_smtp_server" id="x_smtp_server" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($mail_setup->smtp_server->getPlaceHolder()) ?>" value="<?php echo $mail_setup->smtp_server->EditValue ?>"<?php echo $mail_setup->smtp_server->editAttributes() ?>>
</span>
<?php echo $mail_setup->smtp_server->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($mail_setup->port->Visible) { // port ?>
	<div id="r_port" class="form-group row">
		<label id="elh_mail_setup_port" for="x_port" class="<?php echo $mail_setup_edit->LeftColumnClass ?>"><?php echo $mail_setup->port->caption() ?><?php echo ($mail_setup->port->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $mail_setup_edit->RightColumnClass ?>"><div<?php echo $mail_setup->port->cellAttributes() ?>>
<span id="el_mail_setup_port">
<input type="text" data-table="mail_setup" data-field="x_port" name="x_port" id="x_port" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($mail_setup->port->getPlaceHolder()) ?>" value="<?php echo $mail_setup->port->EditValue ?>"<?php echo $mail_setup->port->editAttributes() ?>>
</span>
<?php echo $mail_setup->port->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($mail_setup->ssl->Visible) { // ssl ?>
	<div id="r_ssl" class="form-group row">
		<label id="elh_mail_setup_ssl" for="x_ssl" class="<?php echo $mail_setup_edit->LeftColumnClass ?>"><?php echo $mail_setup->ssl->caption() ?><?php echo ($mail_setup->ssl->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $mail_setup_edit->RightColumnClass ?>"><div<?php echo $mail_setup->ssl->cellAttributes() ?>>
<span id="el_mail_setup_ssl">
<input type="text" data-table="mail_setup" data-field="x_ssl" name="x_ssl" id="x_ssl" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($mail_setup->ssl->getPlaceHolder()) ?>" value="<?php echo $mail_setup->ssl->EditValue ?>"<?php echo $mail_setup->ssl->editAttributes() ?>>
</span>
<?php echo $mail_setup->ssl->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($mail_setup->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label id="elh_mail_setup_operator" for="x_operator" class="<?php echo $mail_setup_edit->LeftColumnClass ?>"><?php echo $mail_setup->operator->caption() ?><?php echo ($mail_setup->operator->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $mail_setup_edit->RightColumnClass ?>"><div<?php echo $mail_setup->operator->cellAttributes() ?>>
<span id="el_mail_setup_operator">
<input type="text" data-table="mail_setup" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($mail_setup->operator->getPlaceHolder()) ?>" value="<?php echo $mail_setup->operator->EditValue ?>"<?php echo $mail_setup->operator->editAttributes() ?>>
</span>
<?php echo $mail_setup->operator->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($mail_setup->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label id="elh_mail_setup_datetime" for="x_datetime" class="<?php echo $mail_setup_edit->LeftColumnClass ?>"><?php echo $mail_setup->datetime->caption() ?><?php echo ($mail_setup->datetime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $mail_setup_edit->RightColumnClass ?>"><div<?php echo $mail_setup->datetime->cellAttributes() ?>>
<span id="el_mail_setup_datetime">
<input type="text" data-table="mail_setup" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($mail_setup->datetime->getPlaceHolder()) ?>" value="<?php echo $mail_setup->datetime->EditValue ?>"<?php echo $mail_setup->datetime->editAttributes() ?>>
<?php if (!$mail_setup->datetime->ReadOnly && !$mail_setup->datetime->Disabled && !isset($mail_setup->datetime->EditAttrs["readonly"]) && !isset($mail_setup->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmail_setupedit", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $mail_setup->datetime->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($mail_setup->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label id="elh_mail_setup_company_id" for="x_company_id" class="<?php echo $mail_setup_edit->LeftColumnClass ?>"><?php echo $mail_setup->company_id->caption() ?><?php echo ($mail_setup->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $mail_setup_edit->RightColumnClass ?>"><div<?php echo $mail_setup->company_id->cellAttributes() ?>>
<span id="el_mail_setup_company_id">
<input type="text" data-table="mail_setup" data-field="x_company_id" name="x_company_id" id="x_company_id" size="30" placeholder="<?php echo HtmlEncode($mail_setup->company_id->getPlaceHolder()) ?>" value="<?php echo $mail_setup->company_id->EditValue ?>"<?php echo $mail_setup->company_id->editAttributes() ?>>
</span>
<?php echo $mail_setup->company_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($mail_setup->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_mail_setup_status" for="x_status" class="<?php echo $mail_setup_edit->LeftColumnClass ?>"><?php echo $mail_setup->status->caption() ?><?php echo ($mail_setup->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $mail_setup_edit->RightColumnClass ?>"><div<?php echo $mail_setup->status->cellAttributes() ?>>
<span id="el_mail_setup_status">
<input type="text" data-table="mail_setup" data-field="x_status" name="x_status" id="x_status" size="30" placeholder="<?php echo HtmlEncode($mail_setup->status->getPlaceHolder()) ?>" value="<?php echo $mail_setup->status->EditValue ?>"<?php echo $mail_setup->status->editAttributes() ?>>
</span>
<?php echo $mail_setup->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$mail_setup_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $mail_setup_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $mail_setup_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$mail_setup_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$mail_setup_edit->terminate();
?>