<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$mailer_cron_list = new mailer_cron_list();

// Run the page
$mailer_cron_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$mailer_cron_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$mailer_cron->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmailer_cronlist = currentForm = new ew.Form("fmailer_cronlist", "list");
fmailer_cronlist.formKeyCountName = '<?php echo $mailer_cron_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmailer_cronlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmailer_cronlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmailer_cronlist.lists["x_status"] = <?php echo $mailer_cron_list->status->Lookup->toClientList() ?>;
fmailer_cronlist.lists["x_status"].options = <?php echo JsonEncode($mailer_cron_list->status->options(FALSE, TRUE)) ?>;

// Form object for search
var fmailer_cronlistsrch = currentSearchForm = new ew.Form("fmailer_cronlistsrch");

// Filters
fmailer_cronlistsrch.filterList = <?php echo $mailer_cron_list->getFilterList() ?>;

// Init search panel as collapsed
fmailer_cronlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$mailer_cron->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($mailer_cron_list->TotalRecs > 0 && $mailer_cron_list->ExportOptions->visible()) { ?>
<?php $mailer_cron_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($mailer_cron_list->ImportOptions->visible()) { ?>
<?php $mailer_cron_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($mailer_cron_list->SearchOptions->visible()) { ?>
<?php $mailer_cron_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($mailer_cron_list->FilterOptions->visible()) { ?>
<?php $mailer_cron_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$mailer_cron_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$mailer_cron->isExport() && !$mailer_cron->CurrentAction) { ?>
<form name="fmailer_cronlistsrch" id="fmailer_cronlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($mailer_cron_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmailer_cronlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="mailer_cron">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($mailer_cron_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($mailer_cron_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $mailer_cron_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($mailer_cron_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($mailer_cron_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($mailer_cron_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($mailer_cron_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $mailer_cron_list->showPageHeader(); ?>
<?php
$mailer_cron_list->showMessage();
?>
<?php if ($mailer_cron_list->TotalRecs > 0 || $mailer_cron->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($mailer_cron_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> mailer_cron">
<?php if (!$mailer_cron->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$mailer_cron->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($mailer_cron_list->Pager)) $mailer_cron_list->Pager = new PrevNextPager($mailer_cron_list->StartRec, $mailer_cron_list->DisplayRecs, $mailer_cron_list->TotalRecs, $mailer_cron_list->AutoHidePager) ?>
<?php if ($mailer_cron_list->Pager->RecordCount > 0 && $mailer_cron_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($mailer_cron_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $mailer_cron_list->pageUrl() ?>start=<?php echo $mailer_cron_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($mailer_cron_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $mailer_cron_list->pageUrl() ?>start=<?php echo $mailer_cron_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $mailer_cron_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($mailer_cron_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $mailer_cron_list->pageUrl() ?>start=<?php echo $mailer_cron_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($mailer_cron_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $mailer_cron_list->pageUrl() ?>start=<?php echo $mailer_cron_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $mailer_cron_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($mailer_cron_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $mailer_cron_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $mailer_cron_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $mailer_cron_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($mailer_cron_list->TotalRecs > 0 && (!$mailer_cron_list->AutoHidePageSizeSelector || $mailer_cron_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="mailer_cron">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($mailer_cron_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($mailer_cron_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($mailer_cron_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($mailer_cron_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($mailer_cron_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($mailer_cron->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $mailer_cron_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmailer_cronlist" id="fmailer_cronlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($mailer_cron_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $mailer_cron_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="mailer_cron">
<div id="gmp_mailer_cron" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($mailer_cron_list->TotalRecs > 0 || $mailer_cron->isGridEdit()) { ?>
<table id="tbl_mailer_cronlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$mailer_cron_list->RowType = ROWTYPE_HEADER;

// Render list options
$mailer_cron_list->renderListOptions();

// Render list options (header, left)
$mailer_cron_list->ListOptions->render("header", "left");
?>
<?php if ($mailer_cron->id->Visible) { // id ?>
	<?php if ($mailer_cron->sortUrl($mailer_cron->id) == "") { ?>
		<th data-name="id" class="<?php echo $mailer_cron->id->headerCellClass() ?>"><div id="elh_mailer_cron_id" class="mailer_cron_id"><div class="ew-table-header-caption"><?php echo $mailer_cron->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $mailer_cron->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mailer_cron->SortUrl($mailer_cron->id) ?>',2);"><div id="elh_mailer_cron_id" class="mailer_cron_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mailer_cron->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($mailer_cron->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mailer_cron->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mailer_cron->url->Visible) { // url ?>
	<?php if ($mailer_cron->sortUrl($mailer_cron->url) == "") { ?>
		<th data-name="url" class="<?php echo $mailer_cron->url->headerCellClass() ?>"><div id="elh_mailer_cron_url" class="mailer_cron_url"><div class="ew-table-header-caption"><?php echo $mailer_cron->url->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="url" class="<?php echo $mailer_cron->url->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mailer_cron->SortUrl($mailer_cron->url) ?>',2);"><div id="elh_mailer_cron_url" class="mailer_cron_url">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mailer_cron->url->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($mailer_cron->url->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mailer_cron->url->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mailer_cron->company_id->Visible) { // company_id ?>
	<?php if ($mailer_cron->sortUrl($mailer_cron->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $mailer_cron->company_id->headerCellClass() ?>"><div id="elh_mailer_cron_company_id" class="mailer_cron_company_id"><div class="ew-table-header-caption"><?php echo $mailer_cron->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $mailer_cron->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mailer_cron->SortUrl($mailer_cron->company_id) ?>',2);"><div id="elh_mailer_cron_company_id" class="mailer_cron_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mailer_cron->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($mailer_cron->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mailer_cron->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mailer_cron->status->Visible) { // status ?>
	<?php if ($mailer_cron->sortUrl($mailer_cron->status) == "") { ?>
		<th data-name="status" class="<?php echo $mailer_cron->status->headerCellClass() ?>"><div id="elh_mailer_cron_status" class="mailer_cron_status"><div class="ew-table-header-caption"><?php echo $mailer_cron->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $mailer_cron->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mailer_cron->SortUrl($mailer_cron->status) ?>',2);"><div id="elh_mailer_cron_status" class="mailer_cron_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mailer_cron->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($mailer_cron->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mailer_cron->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mailer_cron->datetime->Visible) { // datetime ?>
	<?php if ($mailer_cron->sortUrl($mailer_cron->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $mailer_cron->datetime->headerCellClass() ?>"><div id="elh_mailer_cron_datetime" class="mailer_cron_datetime"><div class="ew-table-header-caption"><?php echo $mailer_cron->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $mailer_cron->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mailer_cron->SortUrl($mailer_cron->datetime) ?>',2);"><div id="elh_mailer_cron_datetime" class="mailer_cron_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mailer_cron->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($mailer_cron->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mailer_cron->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mailer_cron->e_datetime->Visible) { // e_datetime ?>
	<?php if ($mailer_cron->sortUrl($mailer_cron->e_datetime) == "") { ?>
		<th data-name="e_datetime" class="<?php echo $mailer_cron->e_datetime->headerCellClass() ?>"><div id="elh_mailer_cron_e_datetime" class="mailer_cron_e_datetime"><div class="ew-table-header-caption"><?php echo $mailer_cron->e_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="e_datetime" class="<?php echo $mailer_cron->e_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $mailer_cron->SortUrl($mailer_cron->e_datetime) ?>',2);"><div id="elh_mailer_cron_e_datetime" class="mailer_cron_e_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mailer_cron->e_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($mailer_cron->e_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($mailer_cron->e_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$mailer_cron_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($mailer_cron->ExportAll && $mailer_cron->isExport()) {
	$mailer_cron_list->StopRec = $mailer_cron_list->TotalRecs;
} else {

	// Set the last record to display
	if ($mailer_cron_list->TotalRecs > $mailer_cron_list->StartRec + $mailer_cron_list->DisplayRecs - 1)
		$mailer_cron_list->StopRec = $mailer_cron_list->StartRec + $mailer_cron_list->DisplayRecs - 1;
	else
		$mailer_cron_list->StopRec = $mailer_cron_list->TotalRecs;
}
$mailer_cron_list->RecCnt = $mailer_cron_list->StartRec - 1;
if ($mailer_cron_list->Recordset && !$mailer_cron_list->Recordset->EOF) {
	$mailer_cron_list->Recordset->moveFirst();
	$selectLimit = $mailer_cron_list->UseSelectLimit;
	if (!$selectLimit && $mailer_cron_list->StartRec > 1)
		$mailer_cron_list->Recordset->move($mailer_cron_list->StartRec - 1);
} elseif (!$mailer_cron->AllowAddDeleteRow && $mailer_cron_list->StopRec == 0) {
	$mailer_cron_list->StopRec = $mailer_cron->GridAddRowCount;
}

// Initialize aggregate
$mailer_cron->RowType = ROWTYPE_AGGREGATEINIT;
$mailer_cron->resetAttributes();
$mailer_cron_list->renderRow();
while ($mailer_cron_list->RecCnt < $mailer_cron_list->StopRec) {
	$mailer_cron_list->RecCnt++;
	if ($mailer_cron_list->RecCnt >= $mailer_cron_list->StartRec) {
		$mailer_cron_list->RowCnt++;

		// Set up key count
		$mailer_cron_list->KeyCount = $mailer_cron_list->RowIndex;

		// Init row class and style
		$mailer_cron->resetAttributes();
		$mailer_cron->CssClass = "";
		if ($mailer_cron->isGridAdd()) {
		} else {
			$mailer_cron_list->loadRowValues($mailer_cron_list->Recordset); // Load row values
		}
		$mailer_cron->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$mailer_cron->RowAttrs = array_merge($mailer_cron->RowAttrs, array('data-rowindex'=>$mailer_cron_list->RowCnt, 'id'=>'r' . $mailer_cron_list->RowCnt . '_mailer_cron', 'data-rowtype'=>$mailer_cron->RowType));

		// Render row
		$mailer_cron_list->renderRow();

		// Render list options
		$mailer_cron_list->renderListOptions();
?>
	<tr<?php echo $mailer_cron->rowAttributes() ?>>
<?php

// Render list options (body, left)
$mailer_cron_list->ListOptions->render("body", "left", $mailer_cron_list->RowCnt);
?>
	<?php if ($mailer_cron->id->Visible) { // id ?>
		<td data-name="id"<?php echo $mailer_cron->id->cellAttributes() ?>>
<span id="el<?php echo $mailer_cron_list->RowCnt ?>_mailer_cron_id" class="mailer_cron_id">
<span<?php echo $mailer_cron->id->viewAttributes() ?>>
<?php echo $mailer_cron->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mailer_cron->url->Visible) { // url ?>
		<td data-name="url"<?php echo $mailer_cron->url->cellAttributes() ?>>
<span id="el<?php echo $mailer_cron_list->RowCnt ?>_mailer_cron_url" class="mailer_cron_url">
<span<?php echo $mailer_cron->url->viewAttributes() ?>>
<?php if ((!EmptyString($mailer_cron->url->getViewValue())) && $mailer_cron->url->linkAttributes() <> "") { ?>
<a<?php echo $mailer_cron->url->linkAttributes() ?>><?php echo $mailer_cron->url->getViewValue() ?></a>
<?php } else { ?>
<?php echo $mailer_cron->url->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($mailer_cron->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $mailer_cron->company_id->cellAttributes() ?>>
<span id="el<?php echo $mailer_cron_list->RowCnt ?>_mailer_cron_company_id" class="mailer_cron_company_id">
<span<?php echo $mailer_cron->company_id->viewAttributes() ?>>
<?php echo $mailer_cron->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mailer_cron->status->Visible) { // status ?>
		<td data-name="status"<?php echo $mailer_cron->status->cellAttributes() ?>>
<span id="el<?php echo $mailer_cron_list->RowCnt ?>_mailer_cron_status" class="mailer_cron_status">
<span<?php echo $mailer_cron->status->viewAttributes() ?>>
<?php echo $mailer_cron->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mailer_cron->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $mailer_cron->datetime->cellAttributes() ?>>
<span id="el<?php echo $mailer_cron_list->RowCnt ?>_mailer_cron_datetime" class="mailer_cron_datetime">
<span<?php echo $mailer_cron->datetime->viewAttributes() ?>>
<?php echo $mailer_cron->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mailer_cron->e_datetime->Visible) { // e_datetime ?>
		<td data-name="e_datetime"<?php echo $mailer_cron->e_datetime->cellAttributes() ?>>
<span id="el<?php echo $mailer_cron_list->RowCnt ?>_mailer_cron_e_datetime" class="mailer_cron_e_datetime">
<span<?php echo $mailer_cron->e_datetime->viewAttributes() ?>>
<?php echo $mailer_cron->e_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$mailer_cron_list->ListOptions->render("body", "right", $mailer_cron_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$mailer_cron->isGridAdd())
		$mailer_cron_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$mailer_cron->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($mailer_cron_list->Recordset)
	$mailer_cron_list->Recordset->Close();
?>
<?php if (!$mailer_cron->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$mailer_cron->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($mailer_cron_list->Pager)) $mailer_cron_list->Pager = new PrevNextPager($mailer_cron_list->StartRec, $mailer_cron_list->DisplayRecs, $mailer_cron_list->TotalRecs, $mailer_cron_list->AutoHidePager) ?>
<?php if ($mailer_cron_list->Pager->RecordCount > 0 && $mailer_cron_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($mailer_cron_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $mailer_cron_list->pageUrl() ?>start=<?php echo $mailer_cron_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($mailer_cron_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $mailer_cron_list->pageUrl() ?>start=<?php echo $mailer_cron_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $mailer_cron_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($mailer_cron_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $mailer_cron_list->pageUrl() ?>start=<?php echo $mailer_cron_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($mailer_cron_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $mailer_cron_list->pageUrl() ?>start=<?php echo $mailer_cron_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $mailer_cron_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($mailer_cron_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $mailer_cron_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $mailer_cron_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $mailer_cron_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($mailer_cron_list->TotalRecs > 0 && (!$mailer_cron_list->AutoHidePageSizeSelector || $mailer_cron_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="mailer_cron">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($mailer_cron_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($mailer_cron_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($mailer_cron_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($mailer_cron_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($mailer_cron_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($mailer_cron->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $mailer_cron_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($mailer_cron_list->TotalRecs == 0 && !$mailer_cron->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $mailer_cron_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$mailer_cron_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$mailer_cron->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$mailer_cron->isExport()) { ?>
<script>
ew.scrollableTable("gmp_mailer_cron", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$mailer_cron_list->terminate();
?>