<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$mailer_cron_search = new mailer_cron_search();

// Run the page
$mailer_cron_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$mailer_cron_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($mailer_cron_search->IsModal) { ?>
var fmailer_cronsearch = currentAdvancedSearchForm = new ew.Form("fmailer_cronsearch", "search");
<?php } else { ?>
var fmailer_cronsearch = currentForm = new ew.Form("fmailer_cronsearch", "search");
<?php } ?>

// Form_CustomValidate event
fmailer_cronsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmailer_cronsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmailer_cronsearch.lists["x_status"] = <?php echo $mailer_cron_search->status->Lookup->toClientList() ?>;
fmailer_cronsearch.lists["x_status"].options = <?php echo JsonEncode($mailer_cron_search->status->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fmailer_cronsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($mailer_cron->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_company_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($mailer_cron->company_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($mailer_cron->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_e_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($mailer_cron->e_datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $mailer_cron_search->showPageHeader(); ?>
<?php
$mailer_cron_search->showMessage();
?>
<form name="fmailer_cronsearch" id="fmailer_cronsearch" class="<?php echo $mailer_cron_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($mailer_cron_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $mailer_cron_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="mailer_cron">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$mailer_cron_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($mailer_cron->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $mailer_cron_search->LeftColumnClass ?>"><span id="elh_mailer_cron_id"><?php echo $mailer_cron->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $mailer_cron_search->RightColumnClass ?>"><div<?php echo $mailer_cron->id->cellAttributes() ?>>
			<span id="el_mailer_cron_id">
<input type="text" data-table="mailer_cron" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($mailer_cron->id->getPlaceHolder()) ?>" value="<?php echo $mailer_cron->id->EditValue ?>"<?php echo $mailer_cron->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($mailer_cron->url->Visible) { // url ?>
	<div id="r_url" class="form-group row">
		<label for="x_url" class="<?php echo $mailer_cron_search->LeftColumnClass ?>"><span id="elh_mailer_cron_url"><?php echo $mailer_cron->url->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_url" id="z_url" value="LIKE"></span>
		</label>
		<div class="<?php echo $mailer_cron_search->RightColumnClass ?>"><div<?php echo $mailer_cron->url->cellAttributes() ?>>
			<span id="el_mailer_cron_url">
<input type="text" data-table="mailer_cron" data-field="x_url" name="x_url" id="x_url" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($mailer_cron->url->getPlaceHolder()) ?>" value="<?php echo $mailer_cron->url->EditValue ?>"<?php echo $mailer_cron->url->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($mailer_cron->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label for="x_company_id" class="<?php echo $mailer_cron_search->LeftColumnClass ?>"><span id="elh_mailer_cron_company_id"><?php echo $mailer_cron->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $mailer_cron_search->RightColumnClass ?>"><div<?php echo $mailer_cron->company_id->cellAttributes() ?>>
			<span id="el_mailer_cron_company_id">
<input type="text" data-table="mailer_cron" data-field="x_company_id" name="x_company_id" id="x_company_id" size="30" placeholder="<?php echo HtmlEncode($mailer_cron->company_id->getPlaceHolder()) ?>" value="<?php echo $mailer_cron->company_id->EditValue ?>"<?php echo $mailer_cron->company_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($mailer_cron->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $mailer_cron_search->LeftColumnClass ?>"><span id="elh_mailer_cron_status"><?php echo $mailer_cron->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $mailer_cron_search->RightColumnClass ?>"><div<?php echo $mailer_cron->status->cellAttributes() ?>>
			<span id="el_mailer_cron_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="mailer_cron" data-field="x_status" data-value-separator="<?php echo $mailer_cron->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $mailer_cron->status->editAttributes() ?>>
		<?php echo $mailer_cron->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($mailer_cron->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $mailer_cron_search->LeftColumnClass ?>"><span id="elh_mailer_cron_datetime"><?php echo $mailer_cron->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $mailer_cron_search->RightColumnClass ?>"><div<?php echo $mailer_cron->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($mailer_cron->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($mailer_cron->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($mailer_cron->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($mailer_cron->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($mailer_cron->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($mailer_cron->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($mailer_cron->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_mailer_cron_datetime">
<input type="text" data-table="mailer_cron" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($mailer_cron->datetime->getPlaceHolder()) ?>" value="<?php echo $mailer_cron->datetime->EditValue ?>"<?php echo $mailer_cron->datetime->editAttributes() ?>>
<?php if (!$mailer_cron->datetime->ReadOnly && !$mailer_cron->datetime->Disabled && !isset($mailer_cron->datetime->EditAttrs["readonly"]) && !isset($mailer_cron->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmailer_cronsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_mailer_cron_datetime" class="btw1_datetime d-none">
<input type="text" data-table="mailer_cron" data-field="x_datetime" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($mailer_cron->datetime->getPlaceHolder()) ?>" value="<?php echo $mailer_cron->datetime->EditValue2 ?>"<?php echo $mailer_cron->datetime->editAttributes() ?>>
<?php if (!$mailer_cron->datetime->ReadOnly && !$mailer_cron->datetime->Disabled && !isset($mailer_cron->datetime->EditAttrs["readonly"]) && !isset($mailer_cron->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmailer_cronsearch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($mailer_cron->e_datetime->Visible) { // e_datetime ?>
	<div id="r_e_datetime" class="form-group row">
		<label for="x_e_datetime" class="<?php echo $mailer_cron_search->LeftColumnClass ?>"><span id="elh_mailer_cron_e_datetime"><?php echo $mailer_cron->e_datetime->caption() ?></span>
		</label>
		<div class="<?php echo $mailer_cron_search->RightColumnClass ?>"><div<?php echo $mailer_cron->e_datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_e_datetime" id="z_e_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($mailer_cron->e_datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($mailer_cron->e_datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($mailer_cron->e_datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($mailer_cron->e_datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($mailer_cron->e_datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($mailer_cron->e_datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($mailer_cron->e_datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_mailer_cron_e_datetime">
<input type="text" data-table="mailer_cron" data-field="x_e_datetime" name="x_e_datetime" id="x_e_datetime" placeholder="<?php echo HtmlEncode($mailer_cron->e_datetime->getPlaceHolder()) ?>" value="<?php echo $mailer_cron->e_datetime->EditValue ?>"<?php echo $mailer_cron->e_datetime->editAttributes() ?>>
<?php if (!$mailer_cron->e_datetime->ReadOnly && !$mailer_cron->e_datetime->Disabled && !isset($mailer_cron->e_datetime->EditAttrs["readonly"]) && !isset($mailer_cron->e_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmailer_cronsearch", "x_e_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_e_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_mailer_cron_e_datetime" class="btw1_e_datetime d-none">
<input type="text" data-table="mailer_cron" data-field="x_e_datetime" name="y_e_datetime" id="y_e_datetime" placeholder="<?php echo HtmlEncode($mailer_cron->e_datetime->getPlaceHolder()) ?>" value="<?php echo $mailer_cron->e_datetime->EditValue2 ?>"<?php echo $mailer_cron->e_datetime->editAttributes() ?>>
<?php if (!$mailer_cron->e_datetime->ReadOnly && !$mailer_cron->e_datetime->Disabled && !isset($mailer_cron->e_datetime->EditAttrs["readonly"]) && !isset($mailer_cron->e_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmailer_cronsearch", "y_e_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$mailer_cron_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $mailer_cron_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$mailer_cron_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$mailer_cron_search->terminate();
?>