<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$mailer_cron_view = new mailer_cron_view();

// Run the page
$mailer_cron_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$mailer_cron_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$mailer_cron->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fmailer_cronview = currentForm = new ew.Form("fmailer_cronview", "view");

// Form_CustomValidate event
fmailer_cronview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmailer_cronview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmailer_cronview.lists["x_status"] = <?php echo $mailer_cron_view->status->Lookup->toClientList() ?>;
fmailer_cronview.lists["x_status"].options = <?php echo JsonEncode($mailer_cron_view->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$mailer_cron->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $mailer_cron_view->ExportOptions->render("body") ?>
<?php $mailer_cron_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $mailer_cron_view->showPageHeader(); ?>
<?php
$mailer_cron_view->showMessage();
?>
<form name="fmailer_cronview" id="fmailer_cronview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($mailer_cron_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $mailer_cron_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="mailer_cron">
<input type="hidden" name="modal" value="<?php echo (int)$mailer_cron_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($mailer_cron->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $mailer_cron_view->TableLeftColumnClass ?>"><span id="elh_mailer_cron_id"><?php echo $mailer_cron->id->caption() ?></span></td>
		<td data-name="id"<?php echo $mailer_cron->id->cellAttributes() ?>>
<span id="el_mailer_cron_id">
<span<?php echo $mailer_cron->id->viewAttributes() ?>>
<?php echo $mailer_cron->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($mailer_cron->url->Visible) { // url ?>
	<tr id="r_url">
		<td class="<?php echo $mailer_cron_view->TableLeftColumnClass ?>"><span id="elh_mailer_cron_url"><?php echo $mailer_cron->url->caption() ?></span></td>
		<td data-name="url"<?php echo $mailer_cron->url->cellAttributes() ?>>
<span id="el_mailer_cron_url">
<span<?php echo $mailer_cron->url->viewAttributes() ?>>
<?php if ((!EmptyString($mailer_cron->url->getViewValue())) && $mailer_cron->url->linkAttributes() <> "") { ?>
<a<?php echo $mailer_cron->url->linkAttributes() ?>><?php echo $mailer_cron->url->getViewValue() ?></a>
<?php } else { ?>
<?php echo $mailer_cron->url->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($mailer_cron->company_id->Visible) { // company_id ?>
	<tr id="r_company_id">
		<td class="<?php echo $mailer_cron_view->TableLeftColumnClass ?>"><span id="elh_mailer_cron_company_id"><?php echo $mailer_cron->company_id->caption() ?></span></td>
		<td data-name="company_id"<?php echo $mailer_cron->company_id->cellAttributes() ?>>
<span id="el_mailer_cron_company_id">
<span<?php echo $mailer_cron->company_id->viewAttributes() ?>>
<?php echo $mailer_cron->company_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($mailer_cron->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $mailer_cron_view->TableLeftColumnClass ?>"><span id="elh_mailer_cron_status"><?php echo $mailer_cron->status->caption() ?></span></td>
		<td data-name="status"<?php echo $mailer_cron->status->cellAttributes() ?>>
<span id="el_mailer_cron_status">
<span<?php echo $mailer_cron->status->viewAttributes() ?>>
<?php echo $mailer_cron->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($mailer_cron->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $mailer_cron_view->TableLeftColumnClass ?>"><span id="elh_mailer_cron_datetime"><?php echo $mailer_cron->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $mailer_cron->datetime->cellAttributes() ?>>
<span id="el_mailer_cron_datetime">
<span<?php echo $mailer_cron->datetime->viewAttributes() ?>>
<?php echo $mailer_cron->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($mailer_cron->e_datetime->Visible) { // e_datetime ?>
	<tr id="r_e_datetime">
		<td class="<?php echo $mailer_cron_view->TableLeftColumnClass ?>"><span id="elh_mailer_cron_e_datetime"><?php echo $mailer_cron->e_datetime->caption() ?></span></td>
		<td data-name="e_datetime"<?php echo $mailer_cron->e_datetime->cellAttributes() ?>>
<span id="el_mailer_cron_e_datetime">
<span<?php echo $mailer_cron->e_datetime->viewAttributes() ?>>
<?php echo $mailer_cron->e_datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$mailer_cron_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$mailer_cron->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$mailer_cron_view->terminate();
?>