<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$margin_list_list = new margin_list_list();

// Run the page
$margin_list_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$margin_list_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$margin_list->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmargin_listlist = currentForm = new ew.Form("fmargin_listlist", "list");
fmargin_listlist.formKeyCountName = '<?php echo $margin_list_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmargin_listlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmargin_listlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmargin_listlist.lists["x_grp"] = <?php echo $margin_list_list->grp->Lookup->toClientList() ?>;
fmargin_listlist.lists["x_grp"].options = <?php echo JsonEncode($margin_list_list->grp->lookupOptions()) ?>;
fmargin_listlist.lists["x_s_grp"] = <?php echo $margin_list_list->s_grp->Lookup->toClientList() ?>;
fmargin_listlist.lists["x_s_grp"].options = <?php echo JsonEncode($margin_list_list->s_grp->lookupOptions()) ?>;
fmargin_listlist.lists["x_product"] = <?php echo $margin_list_list->product->Lookup->toClientList() ?>;
fmargin_listlist.lists["x_product"].options = <?php echo JsonEncode($margin_list_list->product->lookupOptions()) ?>;
fmargin_listlist.lists["x_rid"] = <?php echo $margin_list_list->rid->Lookup->toClientList() ?>;
fmargin_listlist.lists["x_rid"].options = <?php echo JsonEncode($margin_list_list->rid->lookupOptions()) ?>;
fmargin_listlist.lists["x_godown"] = <?php echo $margin_list_list->godown->Lookup->toClientList() ?>;
fmargin_listlist.lists["x_godown"].options = <?php echo JsonEncode($margin_list_list->godown->lookupOptions()) ?>;

// Form object for search
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$margin_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($margin_list_list->TotalRecs > 0 && $margin_list_list->ExportOptions->visible()) { ?>
<?php $margin_list_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($margin_list_list->ImportOptions->visible()) { ?>
<?php $margin_list_list->ImportOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$margin_list_list->renderOtherOptions();
?>
<?php $margin_list_list->showPageHeader(); ?>
<?php
$margin_list_list->showMessage();
?>
<?php if ($margin_list_list->TotalRecs > 0 || $margin_list->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($margin_list_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> margin_list">
<?php if (!$margin_list->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$margin_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($margin_list_list->Pager)) $margin_list_list->Pager = new PrevNextPager($margin_list_list->StartRec, $margin_list_list->DisplayRecs, $margin_list_list->TotalRecs, $margin_list_list->AutoHidePager) ?>
<?php if ($margin_list_list->Pager->RecordCount > 0 && $margin_list_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($margin_list_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $margin_list_list->pageUrl() ?>start=<?php echo $margin_list_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($margin_list_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $margin_list_list->pageUrl() ?>start=<?php echo $margin_list_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $margin_list_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($margin_list_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $margin_list_list->pageUrl() ?>start=<?php echo $margin_list_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($margin_list_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $margin_list_list->pageUrl() ?>start=<?php echo $margin_list_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $margin_list_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($margin_list_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $margin_list_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $margin_list_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $margin_list_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($margin_list_list->TotalRecs > 0 && (!$margin_list_list->AutoHidePageSizeSelector || $margin_list_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="margin_list">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($margin_list_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($margin_list_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($margin_list_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($margin_list_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($margin_list_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($margin_list->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $margin_list_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmargin_listlist" id="fmargin_listlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($margin_list_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $margin_list_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="margin_list">
<div id="gmp_margin_list" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($margin_list_list->TotalRecs > 0 || $margin_list->isGridEdit()) { ?>
<table id="tbl_margin_listlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$margin_list_list->RowType = ROWTYPE_HEADER;

// Render list options
$margin_list_list->renderListOptions();

// Render list options (header, left)
$margin_list_list->ListOptions->render("header", "left");
?>
<?php if ($margin_list->grp->Visible) { // grp ?>
	<?php if ($margin_list->sortUrl($margin_list->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $margin_list->grp->headerCellClass() ?>"><div id="elh_margin_list_grp" class="margin_list_grp"><div class="ew-table-header-caption"><?php echo $margin_list->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $margin_list->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $margin_list->SortUrl($margin_list->grp) ?>',2);"><div id="elh_margin_list_grp" class="margin_list_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $margin_list->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($margin_list->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($margin_list->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($margin_list->s_grp->Visible) { // s_grp ?>
	<?php if ($margin_list->sortUrl($margin_list->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $margin_list->s_grp->headerCellClass() ?>"><div id="elh_margin_list_s_grp" class="margin_list_s_grp"><div class="ew-table-header-caption"><?php echo $margin_list->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $margin_list->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $margin_list->SortUrl($margin_list->s_grp) ?>',2);"><div id="elh_margin_list_s_grp" class="margin_list_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $margin_list->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($margin_list->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($margin_list->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($margin_list->product->Visible) { // product ?>
	<?php if ($margin_list->sortUrl($margin_list->product) == "") { ?>
		<th data-name="product" class="<?php echo $margin_list->product->headerCellClass() ?>"><div id="elh_margin_list_product" class="margin_list_product"><div class="ew-table-header-caption"><?php echo $margin_list->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $margin_list->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $margin_list->SortUrl($margin_list->product) ?>',2);"><div id="elh_margin_list_product" class="margin_list_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $margin_list->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($margin_list->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($margin_list->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($margin_list->rid->Visible) { // rid ?>
	<?php if ($margin_list->sortUrl($margin_list->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $margin_list->rid->headerCellClass() ?>"><div id="elh_margin_list_rid" class="margin_list_rid"><div class="ew-table-header-caption"><?php echo $margin_list->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $margin_list->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $margin_list->SortUrl($margin_list->rid) ?>',2);"><div id="elh_margin_list_rid" class="margin_list_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $margin_list->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($margin_list->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($margin_list->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($margin_list->godown->Visible) { // godown ?>
	<?php if ($margin_list->sortUrl($margin_list->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $margin_list->godown->headerCellClass() ?>"><div id="elh_margin_list_godown" class="margin_list_godown"><div class="ew-table-header-caption"><?php echo $margin_list->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $margin_list->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $margin_list->SortUrl($margin_list->godown) ?>',2);"><div id="elh_margin_list_godown" class="margin_list_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $margin_list->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($margin_list->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($margin_list->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($margin_list->margin_monthly->Visible) { // margin_monthly ?>
	<?php if ($margin_list->sortUrl($margin_list->margin_monthly) == "") { ?>
		<th data-name="margin_monthly" class="<?php echo $margin_list->margin_monthly->headerCellClass() ?>"><div id="elh_margin_list_margin_monthly" class="margin_list_margin_monthly"><div class="ew-table-header-caption"><?php echo $margin_list->margin_monthly->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="margin_monthly" class="<?php echo $margin_list->margin_monthly->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $margin_list->SortUrl($margin_list->margin_monthly) ?>',2);"><div id="elh_margin_list_margin_monthly" class="margin_list_margin_monthly">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $margin_list->margin_monthly->caption() ?></span><span class="ew-table-header-sort"><?php if ($margin_list->margin_monthly->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($margin_list->margin_monthly->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($margin_list->margin_25->Visible) { // margin_% ?>
	<?php if ($margin_list->sortUrl($margin_list->margin_25) == "") { ?>
		<th data-name="margin_25" class="<?php echo $margin_list->margin_25->headerCellClass() ?>"><div id="elh_margin_list_margin_25" class="margin_list_margin_25"><div class="ew-table-header-caption"><?php echo $margin_list->margin_25->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="margin_25" class="<?php echo $margin_list->margin_25->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $margin_list->SortUrl($margin_list->margin_25) ?>',2);"><div id="elh_margin_list_margin_25" class="margin_list_margin_25">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $margin_list->margin_25->caption() ?></span><span class="ew-table-header-sort"><?php if ($margin_list->margin_25->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($margin_list->margin_25->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($margin_list->packets_s->Visible) { // packets_s ?>
	<?php if ($margin_list->sortUrl($margin_list->packets_s) == "") { ?>
		<th data-name="packets_s" class="<?php echo $margin_list->packets_s->headerCellClass() ?>"><div id="elh_margin_list_packets_s" class="margin_list_packets_s"><div class="ew-table-header-caption"><?php echo $margin_list->packets_s->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets_s" class="<?php echo $margin_list->packets_s->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $margin_list->SortUrl($margin_list->packets_s) ?>',2);"><div id="elh_margin_list_packets_s" class="margin_list_packets_s">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $margin_list->packets_s->caption() ?></span><span class="ew-table-header-sort"><?php if ($margin_list->packets_s->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($margin_list->packets_s->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($margin_list->quantity_s->Visible) { // quantity_s ?>
	<?php if ($margin_list->sortUrl($margin_list->quantity_s) == "") { ?>
		<th data-name="quantity_s" class="<?php echo $margin_list->quantity_s->headerCellClass() ?>"><div id="elh_margin_list_quantity_s" class="margin_list_quantity_s"><div class="ew-table-header-caption"><?php echo $margin_list->quantity_s->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity_s" class="<?php echo $margin_list->quantity_s->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $margin_list->SortUrl($margin_list->quantity_s) ?>',2);"><div id="elh_margin_list_quantity_s" class="margin_list_quantity_s">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $margin_list->quantity_s->caption() ?></span><span class="ew-table-header-sort"><?php if ($margin_list->quantity_s->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($margin_list->quantity_s->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($margin_list->_40_s->Visible) { // @_s ?>
	<?php if ($margin_list->sortUrl($margin_list->_40_s) == "") { ?>
		<th data-name="_40_s" class="<?php echo $margin_list->_40_s->headerCellClass() ?>"><div id="elh_margin_list__40_s" class="margin_list__40_s"><div class="ew-table-header-caption"><?php echo $margin_list->_40_s->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_40_s" class="<?php echo $margin_list->_40_s->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $margin_list->SortUrl($margin_list->_40_s) ?>',2);"><div id="elh_margin_list__40_s" class="margin_list__40_s">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $margin_list->_40_s->caption() ?></span><span class="ew-table-header-sort"><?php if ($margin_list->_40_s->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($margin_list->_40_s->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($margin_list->amount_s->Visible) { // amount_s ?>
	<?php if ($margin_list->sortUrl($margin_list->amount_s) == "") { ?>
		<th data-name="amount_s" class="<?php echo $margin_list->amount_s->headerCellClass() ?>"><div id="elh_margin_list_amount_s" class="margin_list_amount_s"><div class="ew-table-header-caption"><?php echo $margin_list->amount_s->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount_s" class="<?php echo $margin_list->amount_s->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $margin_list->SortUrl($margin_list->amount_s) ?>',2);"><div id="elh_margin_list_amount_s" class="margin_list_amount_s">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $margin_list->amount_s->caption() ?></span><span class="ew-table-header-sort"><?php if ($margin_list->amount_s->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($margin_list->amount_s->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$margin_list_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($margin_list->ExportAll && $margin_list->isExport()) {
	$margin_list_list->StopRec = $margin_list_list->TotalRecs;
} else {

	// Set the last record to display
	if ($margin_list_list->TotalRecs > $margin_list_list->StartRec + $margin_list_list->DisplayRecs - 1)
		$margin_list_list->StopRec = $margin_list_list->StartRec + $margin_list_list->DisplayRecs - 1;
	else
		$margin_list_list->StopRec = $margin_list_list->TotalRecs;
}
$margin_list_list->RecCnt = $margin_list_list->StartRec - 1;
if ($margin_list_list->Recordset && !$margin_list_list->Recordset->EOF) {
	$margin_list_list->Recordset->moveFirst();
	$selectLimit = $margin_list_list->UseSelectLimit;
	if (!$selectLimit && $margin_list_list->StartRec > 1)
		$margin_list_list->Recordset->move($margin_list_list->StartRec - 1);
} elseif (!$margin_list->AllowAddDeleteRow && $margin_list_list->StopRec == 0) {
	$margin_list_list->StopRec = $margin_list->GridAddRowCount;
}

// Initialize aggregate
$margin_list->RowType = ROWTYPE_AGGREGATEINIT;
$margin_list->resetAttributes();
$margin_list_list->renderRow();
while ($margin_list_list->RecCnt < $margin_list_list->StopRec) {
	$margin_list_list->RecCnt++;
	if ($margin_list_list->RecCnt >= $margin_list_list->StartRec) {
		$margin_list_list->RowCnt++;

		// Set up key count
		$margin_list_list->KeyCount = $margin_list_list->RowIndex;

		// Init row class and style
		$margin_list->resetAttributes();
		$margin_list->CssClass = "";
		if ($margin_list->isGridAdd()) {
		} else {
			$margin_list_list->loadRowValues($margin_list_list->Recordset); // Load row values
		}
		$margin_list->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$margin_list->RowAttrs = array_merge($margin_list->RowAttrs, array('data-rowindex'=>$margin_list_list->RowCnt, 'id'=>'r' . $margin_list_list->RowCnt . '_margin_list', 'data-rowtype'=>$margin_list->RowType));

		// Render row
		$margin_list_list->renderRow();

		// Render list options
		$margin_list_list->renderListOptions();
?>
	<tr<?php echo $margin_list->rowAttributes() ?>>
<?php

// Render list options (body, left)
$margin_list_list->ListOptions->render("body", "left", $margin_list_list->RowCnt);
?>
	<?php if ($margin_list->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $margin_list->grp->cellAttributes() ?>>
<span id="el<?php echo $margin_list_list->RowCnt ?>_margin_list_grp" class="margin_list_grp">
<span<?php echo $margin_list->grp->viewAttributes() ?>>
<?php if ((!EmptyString($margin_list->grp->getViewValue())) && $margin_list->grp->linkAttributes() <> "") { ?>
<a<?php echo $margin_list->grp->linkAttributes() ?>><?php echo $margin_list->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $margin_list->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($margin_list->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $margin_list->s_grp->cellAttributes() ?>>
<span id="el<?php echo $margin_list_list->RowCnt ?>_margin_list_s_grp" class="margin_list_s_grp">
<span<?php echo $margin_list->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($margin_list->s_grp->getViewValue())) && $margin_list->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $margin_list->s_grp->linkAttributes() ?>><?php echo $margin_list->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $margin_list->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($margin_list->product->Visible) { // product ?>
		<td data-name="product"<?php echo $margin_list->product->cellAttributes() ?>>
<span id="el<?php echo $margin_list_list->RowCnt ?>_margin_list_product" class="margin_list_product">
<span<?php echo $margin_list->product->viewAttributes() ?>>
<?php if ((!EmptyString($margin_list->product->getViewValue())) && $margin_list->product->linkAttributes() <> "") { ?>
<a<?php echo $margin_list->product->linkAttributes() ?>><?php echo $margin_list->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $margin_list->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($margin_list->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $margin_list->rid->cellAttributes() ?>>
<span id="el<?php echo $margin_list_list->RowCnt ?>_margin_list_rid" class="margin_list_rid">
<span<?php echo $margin_list->rid->viewAttributes() ?>>
<?php echo $margin_list->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($margin_list->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $margin_list->godown->cellAttributes() ?>>
<span id="el<?php echo $margin_list_list->RowCnt ?>_margin_list_godown" class="margin_list_godown">
<span<?php echo $margin_list->godown->viewAttributes() ?>>
<?php if ((!EmptyString($margin_list->godown->getViewValue())) && $margin_list->godown->linkAttributes() <> "") { ?>
<a<?php echo $margin_list->godown->linkAttributes() ?>><?php echo $margin_list->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $margin_list->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($margin_list->margin_monthly->Visible) { // margin_monthly ?>
		<td data-name="margin_monthly"<?php echo $margin_list->margin_monthly->cellAttributes() ?>>
<span id="el<?php echo $margin_list_list->RowCnt ?>_margin_list_margin_monthly" class="margin_list_margin_monthly">
<span<?php echo $margin_list->margin_monthly->viewAttributes() ?>>
<?php echo $margin_list->margin_monthly->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($margin_list->margin_25->Visible) { // margin_% ?>
		<td data-name="margin_25"<?php echo $margin_list->margin_25->cellAttributes() ?>>
<span id="el<?php echo $margin_list_list->RowCnt ?>_margin_list_margin_25" class="margin_list_margin_25">
<span<?php echo $margin_list->margin_25->viewAttributes() ?>>
<?php echo $margin_list->margin_25->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($margin_list->packets_s->Visible) { // packets_s ?>
		<td data-name="packets_s"<?php echo $margin_list->packets_s->cellAttributes() ?>>
<span id="el<?php echo $margin_list_list->RowCnt ?>_margin_list_packets_s" class="margin_list_packets_s">
<span<?php echo $margin_list->packets_s->viewAttributes() ?>>
<?php echo $margin_list->packets_s->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($margin_list->quantity_s->Visible) { // quantity_s ?>
		<td data-name="quantity_s"<?php echo $margin_list->quantity_s->cellAttributes() ?>>
<span id="el<?php echo $margin_list_list->RowCnt ?>_margin_list_quantity_s" class="margin_list_quantity_s">
<span<?php echo $margin_list->quantity_s->viewAttributes() ?>>
<?php echo $margin_list->quantity_s->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($margin_list->_40_s->Visible) { // @_s ?>
		<td data-name="_40_s"<?php echo $margin_list->_40_s->cellAttributes() ?>>
<span id="el<?php echo $margin_list_list->RowCnt ?>_margin_list__40_s" class="margin_list__40_s">
<span<?php echo $margin_list->_40_s->viewAttributes() ?>>
<?php echo $margin_list->_40_s->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($margin_list->amount_s->Visible) { // amount_s ?>
		<td data-name="amount_s"<?php echo $margin_list->amount_s->cellAttributes() ?>>
<span id="el<?php echo $margin_list_list->RowCnt ?>_margin_list_amount_s" class="margin_list_amount_s">
<span<?php echo $margin_list->amount_s->viewAttributes() ?>>
<?php echo $margin_list->amount_s->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$margin_list_list->ListOptions->render("body", "right", $margin_list_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$margin_list->isGridAdd())
		$margin_list_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$margin_list->RowType = ROWTYPE_AGGREGATE;
$margin_list->resetAttributes();
$margin_list_list->renderRow();
?>
<?php if ($margin_list_list->TotalRecs > 0 && !$margin_list->isGridAdd() && !$margin_list->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$margin_list_list->renderListOptions();

// Render list options (footer, left)
$margin_list_list->ListOptions->render("footer", "left");
?>
	<?php if ($margin_list->grp->Visible) { // grp ?>
		<td data-name="grp" class="<?php echo $margin_list->grp->footerCellClass() ?>"><span id="elf_margin_list_grp" class="margin_list_grp">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($margin_list->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp" class="<?php echo $margin_list->s_grp->footerCellClass() ?>"><span id="elf_margin_list_s_grp" class="margin_list_s_grp">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($margin_list->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $margin_list->product->footerCellClass() ?>"><span id="elf_margin_list_product" class="margin_list_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($margin_list->rid->Visible) { // rid ?>
		<td data-name="rid" class="<?php echo $margin_list->rid->footerCellClass() ?>"><span id="elf_margin_list_rid" class="margin_list_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($margin_list->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $margin_list->godown->footerCellClass() ?>"><span id="elf_margin_list_godown" class="margin_list_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($margin_list->margin_monthly->Visible) { // margin_monthly ?>
		<td data-name="margin_monthly" class="<?php echo $margin_list->margin_monthly->footerCellClass() ?>"><span id="elf_margin_list_margin_monthly" class="margin_list_margin_monthly">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $margin_list->margin_monthly->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($margin_list->margin_25->Visible) { // margin_% ?>
		<td data-name="margin_25" class="<?php echo $margin_list->margin_25->footerCellClass() ?>"><span id="elf_margin_list_margin_25" class="margin_list_margin_25">
		<span class="ew-aggregate"><?php echo $Language->phrase("AVERAGE") ?></span><span class="ew-aggregate-value">
		<?php echo $margin_list->margin_25->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($margin_list->packets_s->Visible) { // packets_s ?>
		<td data-name="packets_s" class="<?php echo $margin_list->packets_s->footerCellClass() ?>"><span id="elf_margin_list_packets_s" class="margin_list_packets_s">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $margin_list->packets_s->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($margin_list->quantity_s->Visible) { // quantity_s ?>
		<td data-name="quantity_s" class="<?php echo $margin_list->quantity_s->footerCellClass() ?>"><span id="elf_margin_list_quantity_s" class="margin_list_quantity_s">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $margin_list->quantity_s->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($margin_list->_40_s->Visible) { // @_s ?>
		<td data-name="_40_s" class="<?php echo $margin_list->_40_s->footerCellClass() ?>"><span id="elf_margin_list__40_s" class="margin_list__40_s">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($margin_list->amount_s->Visible) { // amount_s ?>
		<td data-name="amount_s" class="<?php echo $margin_list->amount_s->footerCellClass() ?>"><span id="elf_margin_list_amount_s" class="margin_list_amount_s">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $margin_list->amount_s->ViewValue ?></span>
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$margin_list_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$margin_list->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($margin_list_list->Recordset)
	$margin_list_list->Recordset->Close();
?>
<?php if (!$margin_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$margin_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($margin_list_list->Pager)) $margin_list_list->Pager = new PrevNextPager($margin_list_list->StartRec, $margin_list_list->DisplayRecs, $margin_list_list->TotalRecs, $margin_list_list->AutoHidePager) ?>
<?php if ($margin_list_list->Pager->RecordCount > 0 && $margin_list_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($margin_list_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $margin_list_list->pageUrl() ?>start=<?php echo $margin_list_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($margin_list_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $margin_list_list->pageUrl() ?>start=<?php echo $margin_list_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $margin_list_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($margin_list_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $margin_list_list->pageUrl() ?>start=<?php echo $margin_list_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($margin_list_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $margin_list_list->pageUrl() ?>start=<?php echo $margin_list_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $margin_list_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($margin_list_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $margin_list_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $margin_list_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $margin_list_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($margin_list_list->TotalRecs > 0 && (!$margin_list_list->AutoHidePageSizeSelector || $margin_list_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="margin_list">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($margin_list_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($margin_list_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($margin_list_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($margin_list_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($margin_list_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($margin_list->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $margin_list_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($margin_list_list->TotalRecs == 0 && !$margin_list->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $margin_list_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$margin_list_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$margin_list->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$margin_list->isExport()) { ?>
<script>
ew.scrollableTable("gmp_margin_list", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$margin_list_list->terminate();
?>