<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_order_list = new material_order_list();

// Run the page
$material_order_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_order_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$material_order->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmaterial_orderlist = currentForm = new ew.Form("fmaterial_orderlist", "list");
fmaterial_orderlist.formKeyCountName = '<?php echo $material_order_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmaterial_orderlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_orderlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fmaterial_orderlistsrch = currentSearchForm = new ew.Form("fmaterial_orderlistsrch");

// Filters
fmaterial_orderlistsrch.filterList = <?php echo $material_order_list->getFilterList() ?>;

// Init search panel as collapsed
fmaterial_orderlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$material_order->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($material_order_list->TotalRecs > 0 && $material_order_list->ExportOptions->visible()) { ?>
<?php $material_order_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($material_order_list->ImportOptions->visible()) { ?>
<?php $material_order_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($material_order_list->SearchOptions->visible()) { ?>
<?php $material_order_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($material_order_list->FilterOptions->visible()) { ?>
<?php $material_order_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$material_order_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$material_order->isExport() && !$material_order->CurrentAction) { ?>
<form name="fmaterial_orderlistsrch" id="fmaterial_orderlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($material_order_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmaterial_orderlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="material_order">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($material_order_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($material_order_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $material_order_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($material_order_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($material_order_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($material_order_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($material_order_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $material_order_list->showPageHeader(); ?>
<?php
$material_order_list->showMessage();
?>
<?php if ($material_order_list->TotalRecs > 0 || $material_order->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($material_order_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> material_order">
<?php if (!$material_order->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$material_order->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_order_list->Pager)) $material_order_list->Pager = new PrevNextPager($material_order_list->StartRec, $material_order_list->DisplayRecs, $material_order_list->TotalRecs, $material_order_list->AutoHidePager) ?>
<?php if ($material_order_list->Pager->RecordCount > 0 && $material_order_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_order_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_order_list->pageUrl() ?>start=<?php echo $material_order_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_order_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_order_list->pageUrl() ?>start=<?php echo $material_order_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_order_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_order_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_order_list->pageUrl() ?>start=<?php echo $material_order_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_order_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_order_list->pageUrl() ?>start=<?php echo $material_order_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_order_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_order_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_order_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_order_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_order_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_order_list->TotalRecs > 0 && (!$material_order_list->AutoHidePageSizeSelector || $material_order_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_order">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_order_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_order_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_order_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_order_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_order_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_order->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_order_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmaterial_orderlist" id="fmaterial_orderlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_order_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_order_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_order">
<div id="gmp_material_order" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($material_order_list->TotalRecs > 0 || $material_order->isGridEdit()) { ?>
<table id="tbl_material_orderlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$material_order_list->RowType = ROWTYPE_HEADER;

// Render list options
$material_order_list->renderListOptions();

// Render list options (header, left)
$material_order_list->ListOptions->render("header", "left");
?>
<?php if ($material_order->id->Visible) { // id ?>
	<?php if ($material_order->sortUrl($material_order->id) == "") { ?>
		<th data-name="id" class="<?php echo $material_order->id->headerCellClass() ?>"><div id="elh_material_order_id" class="material_order_id"><div class="ew-table-header-caption"><?php echo $material_order->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $material_order->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_order->SortUrl($material_order->id) ?>',2);"><div id="elh_material_order_id" class="material_order_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_order->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_order->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_order->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_order->order_no->Visible) { // order_no ?>
	<?php if ($material_order->sortUrl($material_order->order_no) == "") { ?>
		<th data-name="order_no" class="<?php echo $material_order->order_no->headerCellClass() ?>"><div id="elh_material_order_order_no" class="material_order_order_no"><div class="ew-table-header-caption"><?php echo $material_order->order_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="order_no" class="<?php echo $material_order->order_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_order->SortUrl($material_order->order_no) ?>',2);"><div id="elh_material_order_order_no" class="material_order_order_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_order->order_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_order->order_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_order->order_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_order->date->Visible) { // date ?>
	<?php if ($material_order->sortUrl($material_order->date) == "") { ?>
		<th data-name="date" class="<?php echo $material_order->date->headerCellClass() ?>"><div id="elh_material_order_date" class="material_order_date"><div class="ew-table-header-caption"><?php echo $material_order->date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="date" class="<?php echo $material_order->date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_order->SortUrl($material_order->date) ?>',2);"><div id="elh_material_order_date" class="material_order_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_order->date->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_order->date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_order->date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_order->name->Visible) { // name ?>
	<?php if ($material_order->sortUrl($material_order->name) == "") { ?>
		<th data-name="name" class="<?php echo $material_order->name->headerCellClass() ?>"><div id="elh_material_order_name" class="material_order_name"><div class="ew-table-header-caption"><?php echo $material_order->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $material_order->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_order->SortUrl($material_order->name) ?>',2);"><div id="elh_material_order_name" class="material_order_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_order->name->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_order->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_order->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_order->delivery->Visible) { // delivery ?>
	<?php if ($material_order->sortUrl($material_order->delivery) == "") { ?>
		<th data-name="delivery" class="<?php echo $material_order->delivery->headerCellClass() ?>"><div id="elh_material_order_delivery" class="material_order_delivery"><div class="ew-table-header-caption"><?php echo $material_order->delivery->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="delivery" class="<?php echo $material_order->delivery->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_order->SortUrl($material_order->delivery) ?>',2);"><div id="elh_material_order_delivery" class="material_order_delivery">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_order->delivery->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_order->delivery->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_order->delivery->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_order->ref->Visible) { // ref ?>
	<?php if ($material_order->sortUrl($material_order->ref) == "") { ?>
		<th data-name="ref" class="<?php echo $material_order->ref->headerCellClass() ?>"><div id="elh_material_order_ref" class="material_order_ref"><div class="ew-table-header-caption"><?php echo $material_order->ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref" class="<?php echo $material_order->ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_order->SortUrl($material_order->ref) ?>',2);"><div id="elh_material_order_ref" class="material_order_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_order->ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_order->ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_order->ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_order->quantity->Visible) { // quantity ?>
	<?php if ($material_order->sortUrl($material_order->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $material_order->quantity->headerCellClass() ?>"><div id="elh_material_order_quantity" class="material_order_quantity"><div class="ew-table-header-caption"><?php echo $material_order->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $material_order->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_order->SortUrl($material_order->quantity) ?>',2);"><div id="elh_material_order_quantity" class="material_order_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_order->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_order->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_order->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_order->unit->Visible) { // unit ?>
	<?php if ($material_order->sortUrl($material_order->unit) == "") { ?>
		<th data-name="unit" class="<?php echo $material_order->unit->headerCellClass() ?>"><div id="elh_material_order_unit" class="material_order_unit"><div class="ew-table-header-caption"><?php echo $material_order->unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unit" class="<?php echo $material_order->unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_order->SortUrl($material_order->unit) ?>',2);"><div id="elh_material_order_unit" class="material_order_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_order->unit->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_order->unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_order->unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_order->price->Visible) { // price ?>
	<?php if ($material_order->sortUrl($material_order->price) == "") { ?>
		<th data-name="price" class="<?php echo $material_order->price->headerCellClass() ?>"><div id="elh_material_order_price" class="material_order_price"><div class="ew-table-header-caption"><?php echo $material_order->price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price" class="<?php echo $material_order->price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_order->SortUrl($material_order->price) ?>',2);"><div id="elh_material_order_price" class="material_order_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_order->price->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_order->price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_order->price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_order->taxes->Visible) { // taxes ?>
	<?php if ($material_order->sortUrl($material_order->taxes) == "") { ?>
		<th data-name="taxes" class="<?php echo $material_order->taxes->headerCellClass() ?>"><div id="elh_material_order_taxes" class="material_order_taxes"><div class="ew-table-header-caption"><?php echo $material_order->taxes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="taxes" class="<?php echo $material_order->taxes->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_order->SortUrl($material_order->taxes) ?>',2);"><div id="elh_material_order_taxes" class="material_order_taxes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_order->taxes->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_order->taxes->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_order->taxes->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_order->delivery_terms->Visible) { // delivery_terms ?>
	<?php if ($material_order->sortUrl($material_order->delivery_terms) == "") { ?>
		<th data-name="delivery_terms" class="<?php echo $material_order->delivery_terms->headerCellClass() ?>"><div id="elh_material_order_delivery_terms" class="material_order_delivery_terms"><div class="ew-table-header-caption"><?php echo $material_order->delivery_terms->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="delivery_terms" class="<?php echo $material_order->delivery_terms->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_order->SortUrl($material_order->delivery_terms) ?>',2);"><div id="elh_material_order_delivery_terms" class="material_order_delivery_terms">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_order->delivery_terms->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_order->delivery_terms->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_order->delivery_terms->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_order->delivery_address->Visible) { // delivery_address ?>
	<?php if ($material_order->sortUrl($material_order->delivery_address) == "") { ?>
		<th data-name="delivery_address" class="<?php echo $material_order->delivery_address->headerCellClass() ?>"><div id="elh_material_order_delivery_address" class="material_order_delivery_address"><div class="ew-table-header-caption"><?php echo $material_order->delivery_address->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="delivery_address" class="<?php echo $material_order->delivery_address->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_order->SortUrl($material_order->delivery_address) ?>',2);"><div id="elh_material_order_delivery_address" class="material_order_delivery_address">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_order->delivery_address->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_order->delivery_address->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_order->delivery_address->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_order->payments_terms->Visible) { // payments_terms ?>
	<?php if ($material_order->sortUrl($material_order->payments_terms) == "") { ?>
		<th data-name="payments_terms" class="<?php echo $material_order->payments_terms->headerCellClass() ?>"><div id="elh_material_order_payments_terms" class="material_order_payments_terms"><div class="ew-table-header-caption"><?php echo $material_order->payments_terms->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payments_terms" class="<?php echo $material_order->payments_terms->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_order->SortUrl($material_order->payments_terms) ?>',2);"><div id="elh_material_order_payments_terms" class="material_order_payments_terms">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_order->payments_terms->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_order->payments_terms->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_order->payments_terms->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_order->reference->Visible) { // reference ?>
	<?php if ($material_order->sortUrl($material_order->reference) == "") { ?>
		<th data-name="reference" class="<?php echo $material_order->reference->headerCellClass() ?>"><div id="elh_material_order_reference" class="material_order_reference"><div class="ew-table-header-caption"><?php echo $material_order->reference->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="reference" class="<?php echo $material_order->reference->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_order->SortUrl($material_order->reference) ?>',2);"><div id="elh_material_order_reference" class="material_order_reference">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_order->reference->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_order->reference->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_order->reference->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_order->remarks->Visible) { // remarks ?>
	<?php if ($material_order->sortUrl($material_order->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $material_order->remarks->headerCellClass() ?>"><div id="elh_material_order_remarks" class="material_order_remarks"><div class="ew-table-header-caption"><?php echo $material_order->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $material_order->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_order->SortUrl($material_order->remarks) ?>',2);"><div id="elh_material_order_remarks" class="material_order_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_order->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_order->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_order->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_order->receving_remarks->Visible) { // receving_remarks ?>
	<?php if ($material_order->sortUrl($material_order->receving_remarks) == "") { ?>
		<th data-name="receving_remarks" class="<?php echo $material_order->receving_remarks->headerCellClass() ?>"><div id="elh_material_order_receving_remarks" class="material_order_receving_remarks"><div class="ew-table-header-caption"><?php echo $material_order->receving_remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="receving_remarks" class="<?php echo $material_order->receving_remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_order->SortUrl($material_order->receving_remarks) ?>',2);"><div id="elh_material_order_receving_remarks" class="material_order_receving_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_order->receving_remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_order->receving_remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_order->receving_remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_order->authorised->Visible) { // authorised ?>
	<?php if ($material_order->sortUrl($material_order->authorised) == "") { ?>
		<th data-name="authorised" class="<?php echo $material_order->authorised->headerCellClass() ?>"><div id="elh_material_order_authorised" class="material_order_authorised"><div class="ew-table-header-caption"><?php echo $material_order->authorised->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="authorised" class="<?php echo $material_order->authorised->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_order->SortUrl($material_order->authorised) ?>',2);"><div id="elh_material_order_authorised" class="material_order_authorised">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_order->authorised->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_order->authorised->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_order->authorised->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_order->_print->Visible) { // print ?>
	<?php if ($material_order->sortUrl($material_order->_print) == "") { ?>
		<th data-name="_print" class="<?php echo $material_order->_print->headerCellClass() ?>"><div id="elh_material_order__print" class="material_order__print"><div class="ew-table-header-caption"><?php echo $material_order->_print->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_print" class="<?php echo $material_order->_print->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_order->SortUrl($material_order->_print) ?>',2);"><div id="elh_material_order__print" class="material_order__print">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_order->_print->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_order->_print->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_order->_print->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_order->updated->Visible) { // updated ?>
	<?php if ($material_order->sortUrl($material_order->updated) == "") { ?>
		<th data-name="updated" class="<?php echo $material_order->updated->headerCellClass() ?>"><div id="elh_material_order_updated" class="material_order_updated"><div class="ew-table-header-caption"><?php echo $material_order->updated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="updated" class="<?php echo $material_order->updated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_order->SortUrl($material_order->updated) ?>',2);"><div id="elh_material_order_updated" class="material_order_updated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_order->updated->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_order->updated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_order->updated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_order->operator->Visible) { // operator ?>
	<?php if ($material_order->sortUrl($material_order->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $material_order->operator->headerCellClass() ?>"><div id="elh_material_order_operator" class="material_order_operator"><div class="ew-table-header-caption"><?php echo $material_order->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $material_order->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_order->SortUrl($material_order->operator) ?>',2);"><div id="elh_material_order_operator" class="material_order_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_order->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_order->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_order->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_order->datetime->Visible) { // datetime ?>
	<?php if ($material_order->sortUrl($material_order->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $material_order->datetime->headerCellClass() ?>"><div id="elh_material_order_datetime" class="material_order_datetime"><div class="ew-table-header-caption"><?php echo $material_order->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $material_order->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_order->SortUrl($material_order->datetime) ?>',2);"><div id="elh_material_order_datetime" class="material_order_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_order->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_order->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_order->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_order->a_operator->Visible) { // a_operator ?>
	<?php if ($material_order->sortUrl($material_order->a_operator) == "") { ?>
		<th data-name="a_operator" class="<?php echo $material_order->a_operator->headerCellClass() ?>"><div id="elh_material_order_a_operator" class="material_order_a_operator"><div class="ew-table-header-caption"><?php echo $material_order->a_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_operator" class="<?php echo $material_order->a_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_order->SortUrl($material_order->a_operator) ?>',2);"><div id="elh_material_order_a_operator" class="material_order_a_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_order->a_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_order->a_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_order->a_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_order->a_datetime->Visible) { // a_datetime ?>
	<?php if ($material_order->sortUrl($material_order->a_datetime) == "") { ?>
		<th data-name="a_datetime" class="<?php echo $material_order->a_datetime->headerCellClass() ?>"><div id="elh_material_order_a_datetime" class="material_order_a_datetime"><div class="ew-table-header-caption"><?php echo $material_order->a_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_datetime" class="<?php echo $material_order->a_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_order->SortUrl($material_order->a_datetime) ?>',2);"><div id="elh_material_order_a_datetime" class="material_order_a_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_order->a_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_order->a_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_order->a_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$material_order_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($material_order->ExportAll && $material_order->isExport()) {
	$material_order_list->StopRec = $material_order_list->TotalRecs;
} else {

	// Set the last record to display
	if ($material_order_list->TotalRecs > $material_order_list->StartRec + $material_order_list->DisplayRecs - 1)
		$material_order_list->StopRec = $material_order_list->StartRec + $material_order_list->DisplayRecs - 1;
	else
		$material_order_list->StopRec = $material_order_list->TotalRecs;
}
$material_order_list->RecCnt = $material_order_list->StartRec - 1;
if ($material_order_list->Recordset && !$material_order_list->Recordset->EOF) {
	$material_order_list->Recordset->moveFirst();
	$selectLimit = $material_order_list->UseSelectLimit;
	if (!$selectLimit && $material_order_list->StartRec > 1)
		$material_order_list->Recordset->move($material_order_list->StartRec - 1);
} elseif (!$material_order->AllowAddDeleteRow && $material_order_list->StopRec == 0) {
	$material_order_list->StopRec = $material_order->GridAddRowCount;
}

// Initialize aggregate
$material_order->RowType = ROWTYPE_AGGREGATEINIT;
$material_order->resetAttributes();
$material_order_list->renderRow();
while ($material_order_list->RecCnt < $material_order_list->StopRec) {
	$material_order_list->RecCnt++;
	if ($material_order_list->RecCnt >= $material_order_list->StartRec) {
		$material_order_list->RowCnt++;

		// Set up key count
		$material_order_list->KeyCount = $material_order_list->RowIndex;

		// Init row class and style
		$material_order->resetAttributes();
		$material_order->CssClass = "";
		if ($material_order->isGridAdd()) {
		} else {
			$material_order_list->loadRowValues($material_order_list->Recordset); // Load row values
		}
		$material_order->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$material_order->RowAttrs = array_merge($material_order->RowAttrs, array('data-rowindex'=>$material_order_list->RowCnt, 'id'=>'r' . $material_order_list->RowCnt . '_material_order', 'data-rowtype'=>$material_order->RowType));

		// Render row
		$material_order_list->renderRow();

		// Render list options
		$material_order_list->renderListOptions();
?>
	<tr<?php echo $material_order->rowAttributes() ?>>
<?php

// Render list options (body, left)
$material_order_list->ListOptions->render("body", "left", $material_order_list->RowCnt);
?>
	<?php if ($material_order->id->Visible) { // id ?>
		<td data-name="id"<?php echo $material_order->id->cellAttributes() ?>>
<span id="el<?php echo $material_order_list->RowCnt ?>_material_order_id" class="material_order_id">
<span<?php echo $material_order->id->viewAttributes() ?>>
<?php echo $material_order->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_order->order_no->Visible) { // order_no ?>
		<td data-name="order_no"<?php echo $material_order->order_no->cellAttributes() ?>>
<span id="el<?php echo $material_order_list->RowCnt ?>_material_order_order_no" class="material_order_order_no">
<span<?php echo $material_order->order_no->viewAttributes() ?>>
<?php echo $material_order->order_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_order->date->Visible) { // date ?>
		<td data-name="date"<?php echo $material_order->date->cellAttributes() ?>>
<span id="el<?php echo $material_order_list->RowCnt ?>_material_order_date" class="material_order_date">
<span<?php echo $material_order->date->viewAttributes() ?>>
<?php echo $material_order->date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_order->name->Visible) { // name ?>
		<td data-name="name"<?php echo $material_order->name->cellAttributes() ?>>
<span id="el<?php echo $material_order_list->RowCnt ?>_material_order_name" class="material_order_name">
<span<?php echo $material_order->name->viewAttributes() ?>>
<?php echo $material_order->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_order->delivery->Visible) { // delivery ?>
		<td data-name="delivery"<?php echo $material_order->delivery->cellAttributes() ?>>
<span id="el<?php echo $material_order_list->RowCnt ?>_material_order_delivery" class="material_order_delivery">
<span<?php echo $material_order->delivery->viewAttributes() ?>>
<?php echo $material_order->delivery->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_order->ref->Visible) { // ref ?>
		<td data-name="ref"<?php echo $material_order->ref->cellAttributes() ?>>
<span id="el<?php echo $material_order_list->RowCnt ?>_material_order_ref" class="material_order_ref">
<span<?php echo $material_order->ref->viewAttributes() ?>>
<?php echo $material_order->ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_order->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $material_order->quantity->cellAttributes() ?>>
<span id="el<?php echo $material_order_list->RowCnt ?>_material_order_quantity" class="material_order_quantity">
<span<?php echo $material_order->quantity->viewAttributes() ?>>
<?php echo $material_order->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_order->unit->Visible) { // unit ?>
		<td data-name="unit"<?php echo $material_order->unit->cellAttributes() ?>>
<span id="el<?php echo $material_order_list->RowCnt ?>_material_order_unit" class="material_order_unit">
<span<?php echo $material_order->unit->viewAttributes() ?>>
<?php echo $material_order->unit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_order->price->Visible) { // price ?>
		<td data-name="price"<?php echo $material_order->price->cellAttributes() ?>>
<span id="el<?php echo $material_order_list->RowCnt ?>_material_order_price" class="material_order_price">
<span<?php echo $material_order->price->viewAttributes() ?>>
<?php echo $material_order->price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_order->taxes->Visible) { // taxes ?>
		<td data-name="taxes"<?php echo $material_order->taxes->cellAttributes() ?>>
<span id="el<?php echo $material_order_list->RowCnt ?>_material_order_taxes" class="material_order_taxes">
<span<?php echo $material_order->taxes->viewAttributes() ?>>
<?php echo $material_order->taxes->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_order->delivery_terms->Visible) { // delivery_terms ?>
		<td data-name="delivery_terms"<?php echo $material_order->delivery_terms->cellAttributes() ?>>
<span id="el<?php echo $material_order_list->RowCnt ?>_material_order_delivery_terms" class="material_order_delivery_terms">
<span<?php echo $material_order->delivery_terms->viewAttributes() ?>>
<?php echo $material_order->delivery_terms->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_order->delivery_address->Visible) { // delivery_address ?>
		<td data-name="delivery_address"<?php echo $material_order->delivery_address->cellAttributes() ?>>
<span id="el<?php echo $material_order_list->RowCnt ?>_material_order_delivery_address" class="material_order_delivery_address">
<span<?php echo $material_order->delivery_address->viewAttributes() ?>>
<?php echo $material_order->delivery_address->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_order->payments_terms->Visible) { // payments_terms ?>
		<td data-name="payments_terms"<?php echo $material_order->payments_terms->cellAttributes() ?>>
<span id="el<?php echo $material_order_list->RowCnt ?>_material_order_payments_terms" class="material_order_payments_terms">
<span<?php echo $material_order->payments_terms->viewAttributes() ?>>
<?php echo $material_order->payments_terms->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_order->reference->Visible) { // reference ?>
		<td data-name="reference"<?php echo $material_order->reference->cellAttributes() ?>>
<span id="el<?php echo $material_order_list->RowCnt ?>_material_order_reference" class="material_order_reference">
<span<?php echo $material_order->reference->viewAttributes() ?>>
<?php echo $material_order->reference->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_order->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $material_order->remarks->cellAttributes() ?>>
<span id="el<?php echo $material_order_list->RowCnt ?>_material_order_remarks" class="material_order_remarks">
<span<?php echo $material_order->remarks->viewAttributes() ?>>
<?php echo $material_order->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_order->receving_remarks->Visible) { // receving_remarks ?>
		<td data-name="receving_remarks"<?php echo $material_order->receving_remarks->cellAttributes() ?>>
<span id="el<?php echo $material_order_list->RowCnt ?>_material_order_receving_remarks" class="material_order_receving_remarks">
<span<?php echo $material_order->receving_remarks->viewAttributes() ?>>
<?php echo $material_order->receving_remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_order->authorised->Visible) { // authorised ?>
		<td data-name="authorised"<?php echo $material_order->authorised->cellAttributes() ?>>
<span id="el<?php echo $material_order_list->RowCnt ?>_material_order_authorised" class="material_order_authorised">
<span<?php echo $material_order->authorised->viewAttributes() ?>>
<?php echo $material_order->authorised->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_order->_print->Visible) { // print ?>
		<td data-name="_print"<?php echo $material_order->_print->cellAttributes() ?>>
<span id="el<?php echo $material_order_list->RowCnt ?>_material_order__print" class="material_order__print">
<span<?php echo $material_order->_print->viewAttributes() ?>>
<?php echo $material_order->_print->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_order->updated->Visible) { // updated ?>
		<td data-name="updated"<?php echo $material_order->updated->cellAttributes() ?>>
<span id="el<?php echo $material_order_list->RowCnt ?>_material_order_updated" class="material_order_updated">
<span<?php echo $material_order->updated->viewAttributes() ?>>
<?php echo $material_order->updated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_order->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $material_order->operator->cellAttributes() ?>>
<span id="el<?php echo $material_order_list->RowCnt ?>_material_order_operator" class="material_order_operator">
<span<?php echo $material_order->operator->viewAttributes() ?>>
<?php echo $material_order->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_order->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $material_order->datetime->cellAttributes() ?>>
<span id="el<?php echo $material_order_list->RowCnt ?>_material_order_datetime" class="material_order_datetime">
<span<?php echo $material_order->datetime->viewAttributes() ?>>
<?php echo $material_order->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_order->a_operator->Visible) { // a_operator ?>
		<td data-name="a_operator"<?php echo $material_order->a_operator->cellAttributes() ?>>
<span id="el<?php echo $material_order_list->RowCnt ?>_material_order_a_operator" class="material_order_a_operator">
<span<?php echo $material_order->a_operator->viewAttributes() ?>>
<?php echo $material_order->a_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_order->a_datetime->Visible) { // a_datetime ?>
		<td data-name="a_datetime"<?php echo $material_order->a_datetime->cellAttributes() ?>>
<span id="el<?php echo $material_order_list->RowCnt ?>_material_order_a_datetime" class="material_order_a_datetime">
<span<?php echo $material_order->a_datetime->viewAttributes() ?>>
<?php echo $material_order->a_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$material_order_list->ListOptions->render("body", "right", $material_order_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$material_order->isGridAdd())
		$material_order_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$material_order->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($material_order_list->Recordset)
	$material_order_list->Recordset->Close();
?>
<?php if (!$material_order->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$material_order->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_order_list->Pager)) $material_order_list->Pager = new PrevNextPager($material_order_list->StartRec, $material_order_list->DisplayRecs, $material_order_list->TotalRecs, $material_order_list->AutoHidePager) ?>
<?php if ($material_order_list->Pager->RecordCount > 0 && $material_order_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_order_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_order_list->pageUrl() ?>start=<?php echo $material_order_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_order_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_order_list->pageUrl() ?>start=<?php echo $material_order_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_order_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_order_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_order_list->pageUrl() ?>start=<?php echo $material_order_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_order_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_order_list->pageUrl() ?>start=<?php echo $material_order_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_order_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_order_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_order_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_order_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_order_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_order_list->TotalRecs > 0 && (!$material_order_list->AutoHidePageSizeSelector || $material_order_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_order">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_order_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_order_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_order_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_order_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_order_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_order->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_order_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($material_order_list->TotalRecs == 0 && !$material_order->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $material_order_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$material_order_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$material_order->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$material_order->isExport()) { ?>
<script>
ew.scrollableTable("gmp_material_order", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$material_order_list->terminate();
?>