<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_out_bc_add = new material_out_bc_add();

// Run the page
$material_out_bc_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_out_bc_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fmaterial_out_bcadd = currentForm = new ew.Form("fmaterial_out_bcadd", "add");

// Validate form
fmaterial_out_bcadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($material_out_bc_add->process->Required) { ?>
			elm = this.getElements("x" + infix + "_process");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_bc->process->caption(), $material_out_bc->process->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_bc_add->issue_to->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_bc->issue_to->caption(), $material_out_bc->issue_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_bc_add->godown->Required) { ?>
			elm = this.getElements("x" + infix + "_godown[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_bc->godown->caption(), $material_out_bc->godown->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_bc_add->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_bc->dated->caption(), $material_out_bc->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out_bc->dated->errorMessage()) ?>");
		<?php if ($material_out_bc_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_bc->remarks->caption(), $material_out_bc->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_bc_add->_barcode->Required) { ?>
			elm = this.getElements("x" + infix + "__barcode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_bc->_barcode->caption(), $material_out_bc->_barcode->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "__barcode");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out_bc->_barcode->errorMessage()) ?>");
		<?php if ($material_out_bc_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_bc->operator->caption(), $material_out_bc->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_bc_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_bc->datetime->caption(), $material_out_bc->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fmaterial_out_bcadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_out_bcadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_out_bcadd.lists["x_process"] = <?php echo $material_out_bc_add->process->Lookup->toClientList() ?>;
fmaterial_out_bcadd.lists["x_process"].options = <?php echo JsonEncode($material_out_bc_add->process->lookupOptions()) ?>;
fmaterial_out_bcadd.lists["x_issue_to"] = <?php echo $material_out_bc_add->issue_to->Lookup->toClientList() ?>;
fmaterial_out_bcadd.lists["x_issue_to"].options = <?php echo JsonEncode($material_out_bc_add->issue_to->lookupOptions()) ?>;
fmaterial_out_bcadd.autoSuggests["x_issue_to"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_bcadd.lists["x_godown[]"] = <?php echo $material_out_bc_add->godown->Lookup->toClientList() ?>;
fmaterial_out_bcadd.lists["x_godown[]"].options = <?php echo JsonEncode($material_out_bc_add->godown->lookupOptions()) ?>;
fmaterial_out_bcadd.lists["x_operator"] = <?php echo $material_out_bc_add->operator->Lookup->toClientList() ?>;
fmaterial_out_bcadd.lists["x_operator"].options = <?php echo JsonEncode($material_out_bc_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $material_out_bc_add->showPageHeader(); ?>
<?php
$material_out_bc_add->showMessage();
?>
<form name="fmaterial_out_bcadd" id="fmaterial_out_bcadd" class="<?php echo $material_out_bc_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_out_bc_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_out_bc_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_out_bc">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$material_out_bc_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($material_out_bc->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label id="elh_material_out_bc_process" for="x_process" class="<?php echo $material_out_bc_add->LeftColumnClass ?>"><?php echo $material_out_bc->process->caption() ?><?php echo ($material_out_bc->process->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_bc_add->RightColumnClass ?>"><div<?php echo $material_out_bc->process->cellAttributes() ?>>
<span id="el_material_out_bc_process">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_bc" data-field="x_process" data-value-separator="<?php echo $material_out_bc->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $material_out_bc->process->editAttributes() ?>>
		<?php echo $material_out_bc->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $material_out_bc->process->Lookup->getParamTag("p_x_process") ?>
</span>
<?php echo $material_out_bc->process->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_bc->issue_to->Visible) { // issue_to ?>
	<div id="r_issue_to" class="form-group row">
		<label id="elh_material_out_bc_issue_to" class="<?php echo $material_out_bc_add->LeftColumnClass ?>"><?php echo $material_out_bc->issue_to->caption() ?><?php echo ($material_out_bc->issue_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_bc_add->RightColumnClass ?>"><div<?php echo $material_out_bc->issue_to->cellAttributes() ?>>
<span id="el_material_out_bc_issue_to">
<?php
$wrkonchange = "" . trim(@$material_out_bc->issue_to->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_out_bc->issue_to->EditAttrs["onchange"] = "";
?>
<span id="as_x_issue_to" class="text-nowrap" style="z-index: 8980">
	<div class="input-group">
		<input type="text" class="form-control" name="sv_x_issue_to" id="sv_x_issue_to" value="<?php echo RemoveHtml($material_out_bc->issue_to->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($material_out_bc->issue_to->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_out_bc->issue_to->getPlaceHolder()) ?>"<?php echo $material_out_bc->issue_to->editAttributes() ?>>
<?php if (AllowAdd(CurrentProjectID() . "buyer") && !$material_out_bc->issue_to->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_issue_to" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $material_out_bc->issue_to->caption() ?>" data-title="<?php echo $material_out_bc->issue_to->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_issue_to',url:'buyeraddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
	</div>
</span>
<input type="hidden" data-table="material_out_bc" data-field="x_issue_to" data-value-separator="<?php echo $material_out_bc->issue_to->displayValueSeparatorAttribute() ?>" name="x_issue_to" id="x_issue_to" value="<?php echo HtmlEncode($material_out_bc->issue_to->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_out_bcadd.createAutoSuggest({"id":"x_issue_to","forceSelect":true});
</script>
<?php echo $material_out_bc->issue_to->Lookup->getParamTag("p_x_issue_to") ?>
</span>
<?php echo $material_out_bc->issue_to->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_bc->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label id="elh_material_out_bc_godown" class="<?php echo $material_out_bc_add->LeftColumnClass ?>"><?php echo $material_out_bc->godown->caption() ?><?php echo ($material_out_bc->godown->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_bc_add->RightColumnClass ?>"><div<?php echo $material_out_bc->godown->cellAttributes() ?>>
<span id="el_material_out_bc_godown">
<div id="tp_x_godown" class="ew-template"><input type="checkbox" class="form-check-input" data-table="material_out_bc" data-field="x_godown" data-value-separator="<?php echo $material_out_bc->godown->displayValueSeparatorAttribute() ?>" name="x_godown[]" id="x_godown[]" value="{value}"<?php echo $material_out_bc->godown->editAttributes() ?>></div>
<div id="dsl_x_godown" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $material_out_bc->godown->checkBoxListHtml(FALSE, "x_godown[]") ?>
</div></div>
<?php echo $material_out_bc->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
<?php echo $material_out_bc->godown->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_bc->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_material_out_bc_dated" for="x_dated" class="<?php echo $material_out_bc_add->LeftColumnClass ?>"><?php echo $material_out_bc->dated->caption() ?><?php echo ($material_out_bc->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_bc_add->RightColumnClass ?>"><div<?php echo $material_out_bc->dated->cellAttributes() ?>>
<span id="el_material_out_bc_dated">
<input type="text" data-table="material_out_bc" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($material_out_bc->dated->getPlaceHolder()) ?>" value="<?php echo $material_out_bc->dated->EditValue ?>"<?php echo $material_out_bc->dated->editAttributes() ?>>
<?php if (!$material_out_bc->dated->ReadOnly && !$material_out_bc->dated->Disabled && !isset($material_out_bc->dated->EditAttrs["readonly"]) && !isset($material_out_bc->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_out_bcadd", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $material_out_bc->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_bc->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_material_out_bc_remarks" for="x_remarks" class="<?php echo $material_out_bc_add->LeftColumnClass ?>"><?php echo $material_out_bc->remarks->caption() ?><?php echo ($material_out_bc->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_bc_add->RightColumnClass ?>"><div<?php echo $material_out_bc->remarks->cellAttributes() ?>>
<span id="el_material_out_bc_remarks">
<input type="text" data-table="material_out_bc" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($material_out_bc->remarks->getPlaceHolder()) ?>" value="<?php echo $material_out_bc->remarks->EditValue ?>"<?php echo $material_out_bc->remarks->editAttributes() ?>>
</span>
<?php echo $material_out_bc->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_bc->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label id="elh_material_out_bc__barcode" for="x__barcode" class="<?php echo $material_out_bc_add->LeftColumnClass ?>"><?php echo $material_out_bc->_barcode->caption() ?><?php echo ($material_out_bc->_barcode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_bc_add->RightColumnClass ?>"><div<?php echo $material_out_bc->_barcode->cellAttributes() ?>>
<span id="el_material_out_bc__barcode">
<input type="text" data-table="material_out_bc" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($material_out_bc->_barcode->getPlaceHolder()) ?>" value="<?php echo $material_out_bc->_barcode->EditValue ?>"<?php echo $material_out_bc->_barcode->editAttributes() ?>>
</span>
<?php echo $material_out_bc->_barcode->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$material_out_bc_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $material_out_bc_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $material_out_bc_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$material_out_bc_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$material_out_bc_add->terminate();
?>