<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_out_bc_list = new material_out_bc_list();

// Run the page
$material_out_bc_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_out_bc_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$material_out_bc->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmaterial_out_bclist = currentForm = new ew.Form("fmaterial_out_bclist", "list");
fmaterial_out_bclist.formKeyCountName = '<?php echo $material_out_bc_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmaterial_out_bclist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_out_bclist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_out_bclist.lists["x_process"] = <?php echo $material_out_bc_list->process->Lookup->toClientList() ?>;
fmaterial_out_bclist.lists["x_process"].options = <?php echo JsonEncode($material_out_bc_list->process->lookupOptions()) ?>;
fmaterial_out_bclist.lists["x_issue_to"] = <?php echo $material_out_bc_list->issue_to->Lookup->toClientList() ?>;
fmaterial_out_bclist.lists["x_issue_to"].options = <?php echo JsonEncode($material_out_bc_list->issue_to->lookupOptions()) ?>;
fmaterial_out_bclist.autoSuggests["x_issue_to"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_bclist.lists["x_godown[]"] = <?php echo $material_out_bc_list->godown->Lookup->toClientList() ?>;
fmaterial_out_bclist.lists["x_godown[]"].options = <?php echo JsonEncode($material_out_bc_list->godown->lookupOptions()) ?>;

// Form object for search
var fmaterial_out_bclistsrch = currentSearchForm = new ew.Form("fmaterial_out_bclistsrch");

// Validate function for search
fmaterial_out_bclistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "__barcode");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_bc->_barcode->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fmaterial_out_bclistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_out_bclistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_out_bclistsrch.lists["x_issue_to"] = <?php echo $material_out_bc_list->issue_to->Lookup->toClientList() ?>;
fmaterial_out_bclistsrch.lists["x_issue_to"].options = <?php echo JsonEncode($material_out_bc_list->issue_to->lookupOptions()) ?>;
fmaterial_out_bclistsrch.autoSuggests["x_issue_to"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_bclistsrch.lists["x_godown[]"] = <?php echo $material_out_bc_list->godown->Lookup->toClientList() ?>;
fmaterial_out_bclistsrch.lists["x_godown[]"].options = <?php echo JsonEncode($material_out_bc_list->godown->lookupOptions()) ?>;

// Filters
fmaterial_out_bclistsrch.filterList = <?php echo $material_out_bc_list->getFilterList() ?>;

// Init search panel as collapsed
fmaterial_out_bclistsrch.initSearchPanel = true;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$material_out_bc->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($material_out_bc_list->TotalRecs > 0 && $material_out_bc_list->ExportOptions->visible()) { ?>
<?php $material_out_bc_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($material_out_bc_list->ImportOptions->visible()) { ?>
<?php $material_out_bc_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($material_out_bc_list->SearchOptions->visible()) { ?>
<?php $material_out_bc_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($material_out_bc_list->FilterOptions->visible()) { ?>
<?php $material_out_bc_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$material_out_bc_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$material_out_bc->isExport() && !$material_out_bc->CurrentAction) { ?>
<form name="fmaterial_out_bclistsrch" id="fmaterial_out_bclistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($material_out_bc_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmaterial_out_bclistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="material_out_bc">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$material_out_bc_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$material_out_bc->RowType = ROWTYPE_SEARCH;

// Render row
$material_out_bc->resetAttributes();
$material_out_bc_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($material_out_bc->issue_to->Visible) { // issue_to ?>
	<div id="xsc_issue_to" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $material_out_bc->issue_to->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_to" id="z_issue_to" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$material_out_bc->issue_to->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_out_bc->issue_to->EditAttrs["onchange"] = "";
?>
<span id="as_x_issue_to" class="text-nowrap" style="z-index: 8980">
	<input type="text" class="form-control" name="sv_x_issue_to" id="sv_x_issue_to" value="<?php echo RemoveHtml($material_out_bc->issue_to->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($material_out_bc->issue_to->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_out_bc->issue_to->getPlaceHolder()) ?>"<?php echo $material_out_bc->issue_to->editAttributes() ?>>
</span>
<input type="hidden" data-table="material_out_bc" data-field="x_issue_to" data-value-separator="<?php echo $material_out_bc->issue_to->displayValueSeparatorAttribute() ?>" name="x_issue_to" id="x_issue_to" value="<?php echo HtmlEncode($material_out_bc->issue_to->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_out_bclistsrch.createAutoSuggest({"id":"x_issue_to","forceSelect":false});
</script>
<?php echo $material_out_bc->issue_to->Lookup->getParamTag("p_x_issue_to") ?>
</span>
	</div>
<?php } ?>
<?php if ($material_out_bc->godown->Visible) { // godown ?>
	<div id="xsc_godown" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $material_out_bc->godown->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="material_out_bc" data-field="x_godown" name="x_godown" id="x_godown" size="30" placeholder="<?php echo HtmlEncode($material_out_bc->godown->getPlaceHolder()) ?>" value="<?php echo $material_out_bc->godown->EditValue ?>"<?php echo $material_out_bc->godown->editAttributes() ?>>
<?php echo $material_out_bc->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
	</div>
<?php } ?>
<?php if ($material_out_bc->_barcode->Visible) { // barcode ?>
	<div id="xsc__barcode" class="ew-cell form-group">
		<label for="x__barcode" class="ew-search-caption ew-label"><?php echo $material_out_bc->_barcode->caption() ?></label>
		<span class="ew-search-operator"><select name="z__barcode" id="z__barcode" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($material_out_bc->_barcode->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($material_out_bc->_barcode->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($material_out_bc->_barcode->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($material_out_bc->_barcode->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($material_out_bc->_barcode->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($material_out_bc->_barcode->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($material_out_bc->_barcode->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($material_out_bc->_barcode->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($material_out_bc->_barcode->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="material_out_bc" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($material_out_bc->_barcode->getPlaceHolder()) ?>" value="<?php echo $material_out_bc->_barcode->EditValue ?>"<?php echo $material_out_bc->_barcode->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1__barcode style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1__barcode style="d-none"">
<input type="text" data-table="material_out_bc" data-field="x__barcode" name="y__barcode" id="y__barcode" size="30" placeholder="<?php echo HtmlEncode($material_out_bc->_barcode->getPlaceHolder()) ?>" value="<?php echo $material_out_bc->_barcode->EditValue2 ?>"<?php echo $material_out_bc->_barcode->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($material_out_bc_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($material_out_bc_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $material_out_bc_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($material_out_bc_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($material_out_bc_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($material_out_bc_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($material_out_bc_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $material_out_bc_list->showPageHeader(); ?>
<?php
$material_out_bc_list->showMessage();
?>
<?php if ($material_out_bc_list->TotalRecs > 0 || $material_out_bc->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($material_out_bc_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> material_out_bc">
<?php if (!$material_out_bc->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$material_out_bc->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_out_bc_list->Pager)) $material_out_bc_list->Pager = new PrevNextPager($material_out_bc_list->StartRec, $material_out_bc_list->DisplayRecs, $material_out_bc_list->TotalRecs, $material_out_bc_list->AutoHidePager) ?>
<?php if ($material_out_bc_list->Pager->RecordCount > 0 && $material_out_bc_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_out_bc_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_out_bc_list->pageUrl() ?>start=<?php echo $material_out_bc_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_out_bc_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_out_bc_list->pageUrl() ?>start=<?php echo $material_out_bc_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_out_bc_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_out_bc_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_out_bc_list->pageUrl() ?>start=<?php echo $material_out_bc_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_out_bc_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_out_bc_list->pageUrl() ?>start=<?php echo $material_out_bc_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_out_bc_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_out_bc_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_out_bc_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_out_bc_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_out_bc_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_out_bc_list->TotalRecs > 0 && (!$material_out_bc_list->AutoHidePageSizeSelector || $material_out_bc_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_out_bc">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($material_out_bc_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_out_bc_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_out_bc_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($material_out_bc->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_out_bc_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmaterial_out_bclist" id="fmaterial_out_bclist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_out_bc_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_out_bc_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_out_bc">
<div id="gmp_material_out_bc" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($material_out_bc_list->TotalRecs > 0 || $material_out_bc->isGridEdit()) { ?>
<table id="tbl_material_out_bclist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$material_out_bc_list->RowType = ROWTYPE_HEADER;

// Render list options
$material_out_bc_list->renderListOptions();

// Render list options (header, left)
$material_out_bc_list->ListOptions->render("header", "left");
?>
<?php if ($material_out_bc->process->Visible) { // process ?>
	<?php if ($material_out_bc->sortUrl($material_out_bc->process) == "") { ?>
		<th data-name="process" class="<?php echo $material_out_bc->process->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_material_out_bc_process" class="material_out_bc_process"><div class="ew-table-header-caption"><?php echo $material_out_bc->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $material_out_bc->process->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_bc->SortUrl($material_out_bc->process) ?>',1);"><div id="elh_material_out_bc_process" class="material_out_bc_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_bc->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_bc->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_bc->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_bc->issue_to->Visible) { // issue_to ?>
	<?php if ($material_out_bc->sortUrl($material_out_bc->issue_to) == "") { ?>
		<th data-name="issue_to" class="<?php echo $material_out_bc->issue_to->headerCellClass() ?>"><div id="elh_material_out_bc_issue_to" class="material_out_bc_issue_to"><div class="ew-table-header-caption"><?php echo $material_out_bc->issue_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issue_to" class="<?php echo $material_out_bc->issue_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_bc->SortUrl($material_out_bc->issue_to) ?>',1);"><div id="elh_material_out_bc_issue_to" class="material_out_bc_issue_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_bc->issue_to->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out_bc->issue_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_bc->issue_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_bc->godown->Visible) { // godown ?>
	<?php if ($material_out_bc->sortUrl($material_out_bc->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $material_out_bc->godown->headerCellClass() ?>"><div id="elh_material_out_bc_godown" class="material_out_bc_godown"><div class="ew-table-header-caption"><?php echo $material_out_bc->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $material_out_bc->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_bc->SortUrl($material_out_bc->godown) ?>',1);"><div id="elh_material_out_bc_godown" class="material_out_bc_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_bc->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_bc->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_bc->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_bc->dated->Visible) { // dated ?>
	<?php if ($material_out_bc->sortUrl($material_out_bc->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $material_out_bc->dated->headerCellClass() ?>"><div id="elh_material_out_bc_dated" class="material_out_bc_dated"><div class="ew-table-header-caption"><?php echo $material_out_bc->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $material_out_bc->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_bc->SortUrl($material_out_bc->dated) ?>',1);"><div id="elh_material_out_bc_dated" class="material_out_bc_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_bc->dated->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out_bc->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_bc->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_bc->_barcode->Visible) { // barcode ?>
	<?php if ($material_out_bc->sortUrl($material_out_bc->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $material_out_bc->_barcode->headerCellClass() ?>"><div id="elh_material_out_bc__barcode" class="material_out_bc__barcode"><div class="ew-table-header-caption"><?php echo $material_out_bc->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $material_out_bc->_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_bc->SortUrl($material_out_bc->_barcode) ?>',1);"><div id="elh_material_out_bc__barcode" class="material_out_bc__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_bc->_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out_bc->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_bc->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$material_out_bc_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($material_out_bc->ExportAll && $material_out_bc->isExport()) {
	$material_out_bc_list->StopRec = $material_out_bc_list->TotalRecs;
} else {

	// Set the last record to display
	if ($material_out_bc_list->TotalRecs > $material_out_bc_list->StartRec + $material_out_bc_list->DisplayRecs - 1)
		$material_out_bc_list->StopRec = $material_out_bc_list->StartRec + $material_out_bc_list->DisplayRecs - 1;
	else
		$material_out_bc_list->StopRec = $material_out_bc_list->TotalRecs;
}
$material_out_bc_list->RecCnt = $material_out_bc_list->StartRec - 1;
if ($material_out_bc_list->Recordset && !$material_out_bc_list->Recordset->EOF) {
	$material_out_bc_list->Recordset->moveFirst();
	$selectLimit = $material_out_bc_list->UseSelectLimit;
	if (!$selectLimit && $material_out_bc_list->StartRec > 1)
		$material_out_bc_list->Recordset->move($material_out_bc_list->StartRec - 1);
} elseif (!$material_out_bc->AllowAddDeleteRow && $material_out_bc_list->StopRec == 0) {
	$material_out_bc_list->StopRec = $material_out_bc->GridAddRowCount;
}

// Initialize aggregate
$material_out_bc->RowType = ROWTYPE_AGGREGATEINIT;
$material_out_bc->resetAttributes();
$material_out_bc_list->renderRow();
while ($material_out_bc_list->RecCnt < $material_out_bc_list->StopRec) {
	$material_out_bc_list->RecCnt++;
	if ($material_out_bc_list->RecCnt >= $material_out_bc_list->StartRec) {
		$material_out_bc_list->RowCnt++;

		// Set up key count
		$material_out_bc_list->KeyCount = $material_out_bc_list->RowIndex;

		// Init row class and style
		$material_out_bc->resetAttributes();
		$material_out_bc->CssClass = "";
		if ($material_out_bc->isGridAdd()) {
		} else {
			$material_out_bc_list->loadRowValues($material_out_bc_list->Recordset); // Load row values
		}
		$material_out_bc->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$material_out_bc->RowAttrs = array_merge($material_out_bc->RowAttrs, array('data-rowindex'=>$material_out_bc_list->RowCnt, 'id'=>'r' . $material_out_bc_list->RowCnt . '_material_out_bc', 'data-rowtype'=>$material_out_bc->RowType));

		// Render row
		$material_out_bc_list->renderRow();

		// Render list options
		$material_out_bc_list->renderListOptions();
?>
	<tr<?php echo $material_out_bc->rowAttributes() ?>>
<?php

// Render list options (body, left)
$material_out_bc_list->ListOptions->render("body", "left", $material_out_bc_list->RowCnt);
?>
	<?php if ($material_out_bc->process->Visible) { // process ?>
		<td data-name="process"<?php echo $material_out_bc->process->cellAttributes() ?>>
<span id="el<?php echo $material_out_bc_list->RowCnt ?>_material_out_bc_process" class="material_out_bc_process">
<span<?php echo $material_out_bc->process->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_bc->process->getViewValue())) && $material_out_bc->process->linkAttributes() <> "") { ?>
<a<?php echo $material_out_bc->process->linkAttributes() ?>><?php echo $material_out_bc->process->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_bc->process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_bc->issue_to->Visible) { // issue_to ?>
		<td data-name="issue_to"<?php echo $material_out_bc->issue_to->cellAttributes() ?>>
<span id="el<?php echo $material_out_bc_list->RowCnt ?>_material_out_bc_issue_to" class="material_out_bc_issue_to">
<span<?php echo $material_out_bc->issue_to->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_bc->issue_to->getViewValue())) && $material_out_bc->issue_to->linkAttributes() <> "") { ?>
<a<?php echo $material_out_bc->issue_to->linkAttributes() ?>><?php echo $material_out_bc->issue_to->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_bc->issue_to->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_bc->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $material_out_bc->godown->cellAttributes() ?>>
<span id="el<?php echo $material_out_bc_list->RowCnt ?>_material_out_bc_godown" class="material_out_bc_godown">
<span<?php echo $material_out_bc->godown->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_bc->godown->getViewValue())) && $material_out_bc->godown->linkAttributes() <> "") { ?>
<a<?php echo $material_out_bc->godown->linkAttributes() ?>><?php echo $material_out_bc->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_bc->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_bc->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $material_out_bc->dated->cellAttributes() ?>>
<span id="el<?php echo $material_out_bc_list->RowCnt ?>_material_out_bc_dated" class="material_out_bc_dated">
<span<?php echo $material_out_bc->dated->viewAttributes() ?>>
<?php echo $material_out_bc->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_bc->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $material_out_bc->_barcode->cellAttributes() ?>>
<span id="el<?php echo $material_out_bc_list->RowCnt ?>_material_out_bc__barcode" class="material_out_bc__barcode">
<span<?php echo $material_out_bc->_barcode->viewAttributes() ?>>
<?php echo $material_out_bc->_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$material_out_bc_list->ListOptions->render("body", "right", $material_out_bc_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$material_out_bc->isGridAdd())
		$material_out_bc_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$material_out_bc->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($material_out_bc_list->Recordset)
	$material_out_bc_list->Recordset->Close();
?>
<?php if (!$material_out_bc->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$material_out_bc->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_out_bc_list->Pager)) $material_out_bc_list->Pager = new PrevNextPager($material_out_bc_list->StartRec, $material_out_bc_list->DisplayRecs, $material_out_bc_list->TotalRecs, $material_out_bc_list->AutoHidePager) ?>
<?php if ($material_out_bc_list->Pager->RecordCount > 0 && $material_out_bc_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_out_bc_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_out_bc_list->pageUrl() ?>start=<?php echo $material_out_bc_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_out_bc_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_out_bc_list->pageUrl() ?>start=<?php echo $material_out_bc_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_out_bc_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_out_bc_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_out_bc_list->pageUrl() ?>start=<?php echo $material_out_bc_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_out_bc_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_out_bc_list->pageUrl() ?>start=<?php echo $material_out_bc_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_out_bc_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_out_bc_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_out_bc_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_out_bc_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_out_bc_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_out_bc_list->TotalRecs > 0 && (!$material_out_bc_list->AutoHidePageSizeSelector || $material_out_bc_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_out_bc">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($material_out_bc_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_out_bc_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_out_bc_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($material_out_bc->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_out_bc_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($material_out_bc_list->TotalRecs == 0 && !$material_out_bc->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $material_out_bc_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$material_out_bc_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$material_out_bc->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$material_out_bc->isExport()) { ?>
<script>
ew.scrollableTable("gmp_material_out_bc", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$material_out_bc_list->terminate();
?>