<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_out_f_add = new material_out_f_add();

// Run the page
$material_out_f_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_out_f_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fmaterial_out_fadd = currentForm = new ew.Form("fmaterial_out_fadd", "add");

// Validate form
fmaterial_out_fadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($material_out_f_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_f->grp->caption(), $material_out_f->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_f_add->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_f->s_grp->caption(), $material_out_f->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_f_add->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_f->product->caption(), $material_out_f->product->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out_f->product->errorMessage()) ?>");
		<?php if ($material_out_f_add->rid_1->Required) { ?>
			elm = this.getElements("x" + infix + "_rid_1");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_f->rid_1->caption(), $material_out_f->rid_1->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_f_add->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_f->rid->caption(), $material_out_f->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_f_add->lot_no->Required) { ?>
			elm = this.getElements("x" + infix + "_lot_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_f->lot_no->caption(), $material_out_f->lot_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_f_add->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_f->packing_type->caption(), $material_out_f->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_f_add->godown->Required) { ?>
			elm = this.getElements("x" + infix + "_godown");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_f->godown->caption(), $material_out_f->godown->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_f_add->quantity_avg_act->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity_avg_act");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_f->quantity_avg_act->caption(), $material_out_f->quantity_avg_act->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_f_add->packets->Required) { ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_f->packets->caption(), $material_out_f->packets->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.checkRange(elm.value, 0.001, 10000))
				return this.onError(elm, "<?php echo JsEncode($material_out_f->packets->errorMessage()) ?>");
		<?php if ($material_out_f_add->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_f->quantity->caption(), $material_out_f->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out_f->quantity->errorMessage()) ?>");
		<?php if ($material_out_f_add->max_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_max_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_f->max_qty->caption(), $material_out_f->max_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_max_qty");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out_f->max_qty->errorMessage()) ?>");
		<?php if ($material_out_f_add->avg_quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_avg_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_f->avg_quantity->caption(), $material_out_f->avg_quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_avg_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out_f->avg_quantity->errorMessage()) ?>");
		<?php if ($material_out_f_add->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_f->dated->caption(), $material_out_f->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out_f->dated->errorMessage()) ?>");
		<?php if ($material_out_f_add->process->Required) { ?>
			elm = this.getElements("x" + infix + "_process");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_f->process->caption(), $material_out_f->process->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_f_add->process_type->Required) { ?>
			elm = this.getElements("x" + infix + "_process_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_f->process_type->caption(), $material_out_f->process_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_f_add->fp_jc_no->Required) { ?>
			elm = this.getElements("x" + infix + "_fp_jc_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_f->fp_jc_no->caption(), $material_out_f->fp_jc_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_f_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_f->remarks->caption(), $material_out_f->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_f_add->issue_to_sale->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_to_sale");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_f->issue_to_sale->caption(), $material_out_f->issue_to_sale->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_f_add->issue_to_godown->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_to_godown");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_f->issue_to_godown->caption(), $material_out_f->issue_to_godown->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_f_add->tmp_lot->Required) { ?>
			elm = this.getElements("x" + infix + "_tmp_lot");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_f->tmp_lot->caption(), $material_out_f->tmp_lot->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_tmp_lot");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out_f->tmp_lot->errorMessage()) ?>");
		<?php if ($material_out_f_add->issue_to->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_f->issue_to->caption(), $material_out_f->issue_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_f_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_f->operator->caption(), $material_out_f->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_f_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_f->datetime->caption(), $material_out_f->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_f_add->jc_no->Required) { ?>
			elm = this.getElements("x" + infix + "_jc_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_f->jc_no->caption(), $material_out_f->jc_no->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fmaterial_out_fadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_out_fadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_out_fadd.lists["x_grp"] = <?php echo $material_out_f_add->grp->Lookup->toClientList() ?>;
fmaterial_out_fadd.lists["x_grp"].options = <?php echo JsonEncode($material_out_f_add->grp->options(FALSE, TRUE)) ?>;
fmaterial_out_fadd.lists["x_s_grp"] = <?php echo $material_out_f_add->s_grp->Lookup->toClientList() ?>;
fmaterial_out_fadd.lists["x_s_grp"].options = <?php echo JsonEncode($material_out_f_add->s_grp->lookupOptions()) ?>;
fmaterial_out_fadd.lists["x_rid"] = <?php echo $material_out_f_add->rid->Lookup->toClientList() ?>;
fmaterial_out_fadd.lists["x_rid"].options = <?php echo JsonEncode($material_out_f_add->rid->lookupOptions()) ?>;
fmaterial_out_fadd.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_fadd.lists["x_packing_type"] = <?php echo $material_out_f_add->packing_type->Lookup->toClientList() ?>;
fmaterial_out_fadd.lists["x_packing_type"].options = <?php echo JsonEncode($material_out_f_add->packing_type->lookupOptions()) ?>;
fmaterial_out_fadd.autoSuggests["x_packing_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_fadd.lists["x_godown"] = <?php echo $material_out_f_add->godown->Lookup->toClientList() ?>;
fmaterial_out_fadd.lists["x_godown"].options = <?php echo JsonEncode($material_out_f_add->godown->lookupOptions()) ?>;
fmaterial_out_fadd.autoSuggests["x_godown"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_fadd.lists["x_quantity_avg_act"] = <?php echo $material_out_f_add->quantity_avg_act->Lookup->toClientList() ?>;
fmaterial_out_fadd.lists["x_quantity_avg_act"].options = <?php echo JsonEncode($material_out_f_add->quantity_avg_act->options(FALSE, TRUE)) ?>;
fmaterial_out_fadd.lists["x_process"] = <?php echo $material_out_f_add->process->Lookup->toClientList() ?>;
fmaterial_out_fadd.lists["x_process"].options = <?php echo JsonEncode($material_out_f_add->process->lookupOptions()) ?>;
fmaterial_out_fadd.lists["x_process_type"] = <?php echo $material_out_f_add->process_type->Lookup->toClientList() ?>;
fmaterial_out_fadd.lists["x_process_type"].options = <?php echo JsonEncode($material_out_f_add->process_type->lookupOptions()) ?>;
fmaterial_out_fadd.lists["x_fp_jc_no"] = <?php echo $material_out_f_add->fp_jc_no->Lookup->toClientList() ?>;
fmaterial_out_fadd.lists["x_fp_jc_no"].options = <?php echo JsonEncode($material_out_f_add->fp_jc_no->lookupOptions()) ?>;
fmaterial_out_fadd.lists["x_issue_to_sale"] = <?php echo $material_out_f_add->issue_to_sale->Lookup->toClientList() ?>;
fmaterial_out_fadd.lists["x_issue_to_sale"].options = <?php echo JsonEncode($material_out_f_add->issue_to_sale->lookupOptions()) ?>;
fmaterial_out_fadd.lists["x_issue_to_godown"] = <?php echo $material_out_f_add->issue_to_godown->Lookup->toClientList() ?>;
fmaterial_out_fadd.lists["x_issue_to_godown"].options = <?php echo JsonEncode($material_out_f_add->issue_to_godown->lookupOptions()) ?>;
fmaterial_out_fadd.lists["x_issue_to"] = <?php echo $material_out_f_add->issue_to->Lookup->toClientList() ?>;
fmaterial_out_fadd.lists["x_issue_to"].options = <?php echo JsonEncode($material_out_f_add->issue_to->lookupOptions()) ?>;
fmaterial_out_fadd.lists["x_operator"] = <?php echo $material_out_f_add->operator->Lookup->toClientList() ?>;
fmaterial_out_fadd.lists["x_operator"].options = <?php echo JsonEncode($material_out_f_add->operator->lookupOptions()) ?>;
fmaterial_out_fadd.lists["x_jc_no"] = <?php echo $material_out_f_add->jc_no->Lookup->toClientList() ?>;
fmaterial_out_fadd.lists["x_jc_no"].options = <?php echo JsonEncode($material_out_f_add->jc_no->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $material_out_f_add->showPageHeader(); ?>
<?php
$material_out_f_add->showMessage();
?>
<form name="fmaterial_out_fadd" id="fmaterial_out_fadd" class="<?php echo $material_out_f_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_out_f_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_out_f_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_out_f">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$material_out_f_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($material_out_f->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_material_out_f_grp" for="x_grp" class="<?php echo $material_out_f_add->LeftColumnClass ?>"><?php echo $material_out_f->grp->caption() ?><?php echo ($material_out_f->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_f_add->RightColumnClass ?>"><div<?php echo $material_out_f->grp->cellAttributes() ?>>
<span id="el_material_out_f_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_f" data-field="x_grp" data-value-separator="<?php echo $material_out_f->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $material_out_f->grp->editAttributes() ?>>
		<?php echo $material_out_f->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
<?php echo $material_out_f->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_f->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_material_out_f_s_grp" for="x_s_grp" class="<?php echo $material_out_f_add->LeftColumnClass ?>"><?php echo $material_out_f->s_grp->caption() ?><?php echo ($material_out_f->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_f_add->RightColumnClass ?>"><div<?php echo $material_out_f->s_grp->cellAttributes() ?>>
<span id="el_material_out_f_s_grp">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($material_out_f->s_grp->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $material_out_f->s_grp->ViewValue ?></button>
		<div id="dsl_x_s_grp" data-repeatcolumn="1" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $material_out_f->s_grp->radioButtonListHtml(TRUE, "x_s_grp") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x_s_grp" class="ew-template"><input type="radio" class="form-check-input" data-table="material_out_f" data-field="x_s_grp" data-value-separator="<?php echo $material_out_f->s_grp->displayValueSeparatorAttribute() ?>" name="x_s_grp" id="x_s_grp" value="{value}"<?php echo $material_out_f->s_grp->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$material_out_f->s_grp->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
<?php echo $material_out_f->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
	<?php } ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
<?php echo $material_out_f->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_f->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_material_out_f_product" for="x_product" class="<?php echo $material_out_f_add->LeftColumnClass ?>"><?php echo $material_out_f->product->caption() ?><?php echo ($material_out_f->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_f_add->RightColumnClass ?>"><div<?php echo $material_out_f->product->cellAttributes() ?>>
<span id="el_material_out_f_product">
<input type="text" data-table="material_out_f" data-field="x_product" name="x_product" id="x_product" size="30" placeholder="<?php echo HtmlEncode($material_out_f->product->getPlaceHolder()) ?>" value="<?php echo $material_out_f->product->EditValue ?>"<?php echo $material_out_f->product->editAttributes() ?>>
</span>
<?php echo $material_out_f->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_f->rid_1->Visible) { // rid_1 ?>
	<div id="r_rid_1" class="form-group row">
		<label id="elh_material_out_f_rid_1" for="x_rid_1" class="<?php echo $material_out_f_add->LeftColumnClass ?>"><?php echo $material_out_f->rid_1->caption() ?><?php echo ($material_out_f->rid_1->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_f_add->RightColumnClass ?>"><div<?php echo $material_out_f->rid_1->cellAttributes() ?>>
<span id="el_material_out_f_rid_1">
<input type="text" data-table="material_out_f" data-field="x_rid_1" name="x_rid_1" id="x_rid_1" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($material_out_f->rid_1->getPlaceHolder()) ?>" value="<?php echo $material_out_f->rid_1->EditValue ?>"<?php echo $material_out_f->rid_1->editAttributes() ?>>
</span>
<?php echo $material_out_f->rid_1->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_f->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label id="elh_material_out_f_rid" class="<?php echo $material_out_f_add->LeftColumnClass ?>"><?php echo $material_out_f->rid->caption() ?><?php echo ($material_out_f->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_f_add->RightColumnClass ?>"><div<?php echo $material_out_f->rid->cellAttributes() ?>>
<span id="el_material_out_f_rid">
<?php
$wrkonchange = "" . trim(@$material_out_f->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_out_f->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid" class="text-nowrap" style="z-index: 8930">
	<input type="text" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?php echo RemoveHtml($material_out_f->rid->EditValue) ?>" size="40" placeholder="<?php echo HtmlEncode($material_out_f->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_out_f->rid->getPlaceHolder()) ?>"<?php echo $material_out_f->rid->editAttributes() ?>>
</span>
<input type="hidden" data-table="material_out_f" data-field="x_rid" data-value-separator="<?php echo $material_out_f->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($material_out_f->rid->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_out_fadd.createAutoSuggest({"id":"x_rid","forceSelect":false});
</script>
<?php echo $material_out_f->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
<?php echo $material_out_f->rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_f->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label id="elh_material_out_f_lot_no" for="x_lot_no" class="<?php echo $material_out_f_add->LeftColumnClass ?>"><?php echo $material_out_f->lot_no->caption() ?><?php echo ($material_out_f->lot_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_f_add->RightColumnClass ?>"><div<?php echo $material_out_f->lot_no->cellAttributes() ?>>
<span id="el_material_out_f_lot_no">
<input type="text" data-table="material_out_f" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($material_out_f->lot_no->getPlaceHolder()) ?>" value="<?php echo $material_out_f->lot_no->EditValue ?>"<?php echo $material_out_f->lot_no->editAttributes() ?>>
</span>
<?php echo $material_out_f->lot_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_f->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label id="elh_material_out_f_packing_type" class="<?php echo $material_out_f_add->LeftColumnClass ?>"><?php echo $material_out_f->packing_type->caption() ?><?php echo ($material_out_f->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_f_add->RightColumnClass ?>"><div<?php echo $material_out_f->packing_type->cellAttributes() ?>>
<span id="el_material_out_f_packing_type">
<?php
$wrkonchange = "" . trim(@$material_out_f->packing_type->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_out_f->packing_type->EditAttrs["onchange"] = "";
?>
<span id="as_x_packing_type" class="text-nowrap" style="z-index: 8910">
	<input type="text" class="form-control" name="sv_x_packing_type" id="sv_x_packing_type" value="<?php echo RemoveHtml($material_out_f->packing_type->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($material_out_f->packing_type->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_out_f->packing_type->getPlaceHolder()) ?>"<?php echo $material_out_f->packing_type->editAttributes() ?>>
</span>
<input type="hidden" data-table="material_out_f" data-field="x_packing_type" data-value-separator="<?php echo $material_out_f->packing_type->displayValueSeparatorAttribute() ?>" name="x_packing_type" id="x_packing_type" value="<?php echo HtmlEncode($material_out_f->packing_type->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_out_fadd.createAutoSuggest({"id":"x_packing_type","forceSelect":false});
</script>
<?php echo $material_out_f->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
<?php echo $material_out_f->packing_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_f->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label id="elh_material_out_f_godown" class="<?php echo $material_out_f_add->LeftColumnClass ?>"><?php echo $material_out_f->godown->caption() ?><?php echo ($material_out_f->godown->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_f_add->RightColumnClass ?>"><div<?php echo $material_out_f->godown->cellAttributes() ?>>
<span id="el_material_out_f_godown">
<?php
$wrkonchange = "" . trim(@$material_out_f->godown->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_out_f->godown->EditAttrs["onchange"] = "";
?>
<span id="as_x_godown" class="text-nowrap" style="z-index: 8900">
	<input type="text" class="form-control" name="sv_x_godown" id="sv_x_godown" value="<?php echo RemoveHtml($material_out_f->godown->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($material_out_f->godown->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_out_f->godown->getPlaceHolder()) ?>"<?php echo $material_out_f->godown->editAttributes() ?>>
</span>
<input type="hidden" data-table="material_out_f" data-field="x_godown" data-value-separator="<?php echo $material_out_f->godown->displayValueSeparatorAttribute() ?>" name="x_godown" id="x_godown" value="<?php echo HtmlEncode($material_out_f->godown->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_out_fadd.createAutoSuggest({"id":"x_godown","forceSelect":false});
</script>
<?php echo $material_out_f->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
<?php echo $material_out_f->godown->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_f->quantity_avg_act->Visible) { // quantity_avg_act ?>
	<div id="r_quantity_avg_act" class="form-group row">
		<label id="elh_material_out_f_quantity_avg_act" class="<?php echo $material_out_f_add->LeftColumnClass ?>"><?php echo $material_out_f->quantity_avg_act->caption() ?><?php echo ($material_out_f->quantity_avg_act->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_f_add->RightColumnClass ?>"><div<?php echo $material_out_f->quantity_avg_act->cellAttributes() ?>>
<span id="el_material_out_f_quantity_avg_act">
<div id="tp_x_quantity_avg_act" class="ew-template"><input type="radio" class="form-check-input" data-table="material_out_f" data-field="x_quantity_avg_act" data-value-separator="<?php echo $material_out_f->quantity_avg_act->displayValueSeparatorAttribute() ?>" name="x_quantity_avg_act" id="x_quantity_avg_act" value="{value}"<?php echo $material_out_f->quantity_avg_act->editAttributes() ?>></div>
<div id="dsl_x_quantity_avg_act" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $material_out_f->quantity_avg_act->radioButtonListHtml(FALSE, "x_quantity_avg_act") ?>
</div></div>
</span>
<?php echo $material_out_f->quantity_avg_act->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_f->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label id="elh_material_out_f_packets" for="x_packets" class="<?php echo $material_out_f_add->LeftColumnClass ?>"><?php echo $material_out_f->packets->caption() ?><?php echo ($material_out_f->packets->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_f_add->RightColumnClass ?>"><div<?php echo $material_out_f->packets->cellAttributes() ?>>
<span id="el_material_out_f_packets">
<input type="text" data-table="material_out_f" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($material_out_f->packets->getPlaceHolder()) ?>" value="<?php echo $material_out_f->packets->EditValue ?>"<?php echo $material_out_f->packets->editAttributes() ?>>
</span>
<?php echo $material_out_f->packets->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_f->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_material_out_f_quantity" for="x_quantity" class="<?php echo $material_out_f_add->LeftColumnClass ?>"><?php echo $material_out_f->quantity->caption() ?><?php echo ($material_out_f->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_f_add->RightColumnClass ?>"><div<?php echo $material_out_f->quantity->cellAttributes() ?>>
<span id="el_material_out_f_quantity">
<input type="text" data-table="material_out_f" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($material_out_f->quantity->getPlaceHolder()) ?>" value="<?php echo $material_out_f->quantity->EditValue ?>"<?php echo $material_out_f->quantity->editAttributes() ?>>
</span>
<?php echo $material_out_f->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_f->max_qty->Visible) { // max_qty ?>
	<div id="r_max_qty" class="form-group row">
		<label id="elh_material_out_f_max_qty" for="x_max_qty" class="<?php echo $material_out_f_add->LeftColumnClass ?>"><?php echo $material_out_f->max_qty->caption() ?><?php echo ($material_out_f->max_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_f_add->RightColumnClass ?>"><div<?php echo $material_out_f->max_qty->cellAttributes() ?>>
<span id="el_material_out_f_max_qty">
<input type="text" data-table="material_out_f" data-field="x_max_qty" name="x_max_qty" id="x_max_qty" size="30" placeholder="<?php echo HtmlEncode($material_out_f->max_qty->getPlaceHolder()) ?>" value="<?php echo $material_out_f->max_qty->EditValue ?>"<?php echo $material_out_f->max_qty->editAttributes() ?>>
</span>
<?php echo $material_out_f->max_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_f->avg_quantity->Visible) { // avg_quantity ?>
	<div id="r_avg_quantity" class="form-group row">
		<label id="elh_material_out_f_avg_quantity" for="x_avg_quantity" class="<?php echo $material_out_f_add->LeftColumnClass ?>"><?php echo $material_out_f->avg_quantity->caption() ?><?php echo ($material_out_f->avg_quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_f_add->RightColumnClass ?>"><div<?php echo $material_out_f->avg_quantity->cellAttributes() ?>>
<span id="el_material_out_f_avg_quantity">
<input type="text" data-table="material_out_f" data-field="x_avg_quantity" name="x_avg_quantity" id="x_avg_quantity" size="30" placeholder="<?php echo HtmlEncode($material_out_f->avg_quantity->getPlaceHolder()) ?>" value="<?php echo $material_out_f->avg_quantity->EditValue ?>"<?php echo $material_out_f->avg_quantity->editAttributes() ?>>
</span>
<?php echo $material_out_f->avg_quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_f->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_material_out_f_dated" for="x_dated" class="<?php echo $material_out_f_add->LeftColumnClass ?>"><?php echo $material_out_f->dated->caption() ?><?php echo ($material_out_f->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_f_add->RightColumnClass ?>"><div<?php echo $material_out_f->dated->cellAttributes() ?>>
<span id="el_material_out_f_dated">
<input type="text" data-table="material_out_f" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($material_out_f->dated->getPlaceHolder()) ?>" value="<?php echo $material_out_f->dated->EditValue ?>"<?php echo $material_out_f->dated->editAttributes() ?>>
<?php if (!$material_out_f->dated->ReadOnly && !$material_out_f->dated->Disabled && !isset($material_out_f->dated->EditAttrs["readonly"]) && !isset($material_out_f->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_out_fadd", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $material_out_f->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_f->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label id="elh_material_out_f_process" for="x_process" class="<?php echo $material_out_f_add->LeftColumnClass ?>"><?php echo $material_out_f->process->caption() ?><?php echo ($material_out_f->process->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_f_add->RightColumnClass ?>"><div<?php echo $material_out_f->process->cellAttributes() ?>>
<span id="el_material_out_f_process">
<?php $material_out_f->process->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_out_f->process->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_f" data-field="x_process" data-value-separator="<?php echo $material_out_f->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $material_out_f->process->editAttributes() ?>>
		<?php echo $material_out_f->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $material_out_f->process->Lookup->getParamTag("p_x_process") ?>
</span>
<?php echo $material_out_f->process->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_f->process_type->Visible) { // process_type ?>
	<div id="r_process_type" class="form-group row">
		<label id="elh_material_out_f_process_type" for="x_process_type" class="<?php echo $material_out_f_add->LeftColumnClass ?>"><?php echo $material_out_f->process_type->caption() ?><?php echo ($material_out_f->process_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_f_add->RightColumnClass ?>"><div<?php echo $material_out_f->process_type->cellAttributes() ?>>
<span id="el_material_out_f_process_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_f" data-field="x_process_type" data-value-separator="<?php echo $material_out_f->process_type->displayValueSeparatorAttribute() ?>" id="x_process_type" name="x_process_type"<?php echo $material_out_f->process_type->editAttributes() ?>>
		<?php echo $material_out_f->process_type->selectOptionListHtml("x_process_type") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "process_type_f") && !$material_out_f->process_type->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_process_type" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $material_out_f->process_type->caption() ?>" data-title="<?php echo $material_out_f->process_type->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_process_type',url:'process_type_faddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $material_out_f->process_type->Lookup->getParamTag("p_x_process_type") ?>
</span>
<?php echo $material_out_f->process_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_f->fp_jc_no->Visible) { // fp_jc_no ?>
	<div id="r_fp_jc_no" class="form-group row">
		<label id="elh_material_out_f_fp_jc_no" for="x_fp_jc_no" class="<?php echo $material_out_f_add->LeftColumnClass ?>"><?php echo $material_out_f->fp_jc_no->caption() ?><?php echo ($material_out_f->fp_jc_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_f_add->RightColumnClass ?>"><div<?php echo $material_out_f->fp_jc_no->cellAttributes() ?>>
<span id="el_material_out_f_fp_jc_no">
<?php $material_out_f->fp_jc_no->EditAttrs["onchange"] = "ew.autoFill(this);" . @$material_out_f->fp_jc_no->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_f" data-field="x_fp_jc_no" data-value-separator="<?php echo $material_out_f->fp_jc_no->displayValueSeparatorAttribute() ?>" id="x_fp_jc_no" name="x_fp_jc_no"<?php echo $material_out_f->fp_jc_no->editAttributes() ?>>
		<?php echo $material_out_f->fp_jc_no->selectOptionListHtml("x_fp_jc_no") ?>
	</select>
</div>
<?php echo $material_out_f->fp_jc_no->Lookup->getParamTag("p_x_fp_jc_no") ?>
</span>
<?php echo $material_out_f->fp_jc_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_f->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_material_out_f_remarks" for="x_remarks" class="<?php echo $material_out_f_add->LeftColumnClass ?>"><?php echo $material_out_f->remarks->caption() ?><?php echo ($material_out_f->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_f_add->RightColumnClass ?>"><div<?php echo $material_out_f->remarks->cellAttributes() ?>>
<span id="el_material_out_f_remarks">
<textarea data-table="material_out_f" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($material_out_f->remarks->getPlaceHolder()) ?>"<?php echo $material_out_f->remarks->editAttributes() ?>><?php echo $material_out_f->remarks->EditValue ?></textarea>
</span>
<?php echo $material_out_f->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_f->issue_to_sale->Visible) { // issue_to_sale ?>
	<div id="r_issue_to_sale" class="form-group row">
		<label id="elh_material_out_f_issue_to_sale" for="x_issue_to_sale" class="<?php echo $material_out_f_add->LeftColumnClass ?>"><?php echo $material_out_f->issue_to_sale->caption() ?><?php echo ($material_out_f->issue_to_sale->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_f_add->RightColumnClass ?>"><div<?php echo $material_out_f->issue_to_sale->cellAttributes() ?>>
<span id="el_material_out_f_issue_to_sale">
<?php $material_out_f->issue_to_sale->EditAttrs["onchange"] = "ew.autoFill(this);" . @$material_out_f->issue_to_sale->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_f" data-field="x_issue_to_sale" data-value-separator="<?php echo $material_out_f->issue_to_sale->displayValueSeparatorAttribute() ?>" id="x_issue_to_sale" name="x_issue_to_sale"<?php echo $material_out_f->issue_to_sale->editAttributes() ?>>
		<?php echo $material_out_f->issue_to_sale->selectOptionListHtml("x_issue_to_sale") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "buyer") && !$material_out_f->issue_to_sale->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_issue_to_sale" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $material_out_f->issue_to_sale->caption() ?>" data-title="<?php echo $material_out_f->issue_to_sale->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_issue_to_sale',url:'buyeraddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $material_out_f->issue_to_sale->Lookup->getParamTag("p_x_issue_to_sale") ?>
</span>
<?php echo $material_out_f->issue_to_sale->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_f->issue_to_godown->Visible) { // issue_to_godown ?>
	<div id="r_issue_to_godown" class="form-group row">
		<label id="elh_material_out_f_issue_to_godown" for="x_issue_to_godown" class="<?php echo $material_out_f_add->LeftColumnClass ?>"><?php echo $material_out_f->issue_to_godown->caption() ?><?php echo ($material_out_f->issue_to_godown->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_f_add->RightColumnClass ?>"><div<?php echo $material_out_f->issue_to_godown->cellAttributes() ?>>
<span id="el_material_out_f_issue_to_godown">
<?php $material_out_f->issue_to_godown->EditAttrs["onchange"] = "ew.autoFill(this);" . @$material_out_f->issue_to_godown->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_f" data-field="x_issue_to_godown" data-value-separator="<?php echo $material_out_f->issue_to_godown->displayValueSeparatorAttribute() ?>" id="x_issue_to_godown" name="x_issue_to_godown"<?php echo $material_out_f->issue_to_godown->editAttributes() ?>>
		<?php echo $material_out_f->issue_to_godown->selectOptionListHtml("x_issue_to_godown") ?>
	</select>
</div>
<?php echo $material_out_f->issue_to_godown->Lookup->getParamTag("p_x_issue_to_godown") ?>
</span>
<?php echo $material_out_f->issue_to_godown->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_f->tmp_lot->Visible) { // tmp_lot ?>
	<div id="r_tmp_lot" class="form-group row">
		<label id="elh_material_out_f_tmp_lot" for="x_tmp_lot" class="<?php echo $material_out_f_add->LeftColumnClass ?>"><?php echo $material_out_f->tmp_lot->caption() ?><?php echo ($material_out_f->tmp_lot->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_f_add->RightColumnClass ?>"><div<?php echo $material_out_f->tmp_lot->cellAttributes() ?>>
<span id="el_material_out_f_tmp_lot">
<input type="text" data-table="material_out_f" data-field="x_tmp_lot" name="x_tmp_lot" id="x_tmp_lot" size="30" placeholder="<?php echo HtmlEncode($material_out_f->tmp_lot->getPlaceHolder()) ?>" value="<?php echo $material_out_f->tmp_lot->EditValue ?>"<?php echo $material_out_f->tmp_lot->editAttributes() ?>>
</span>
<?php echo $material_out_f->tmp_lot->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_f->issue_to->Visible) { // issue_to ?>
	<div id="r_issue_to" class="form-group row">
		<label id="elh_material_out_f_issue_to" for="x_issue_to" class="<?php echo $material_out_f_add->LeftColumnClass ?>"><?php echo $material_out_f->issue_to->caption() ?><?php echo ($material_out_f->issue_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_f_add->RightColumnClass ?>"><div<?php echo $material_out_f->issue_to->cellAttributes() ?>>
<span id="el_material_out_f_issue_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_f" data-field="x_issue_to" data-value-separator="<?php echo $material_out_f->issue_to->displayValueSeparatorAttribute() ?>" id="x_issue_to" name="x_issue_to"<?php echo $material_out_f->issue_to->editAttributes() ?>>
		<?php echo $material_out_f->issue_to->selectOptionListHtml("x_issue_to") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "buyer") && !$material_out_f->issue_to->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_issue_to" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $material_out_f->issue_to->caption() ?>" data-title="<?php echo $material_out_f->issue_to->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_issue_to',url:'buyeraddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $material_out_f->issue_to->Lookup->getParamTag("p_x_issue_to") ?>
</span>
<?php echo $material_out_f->issue_to->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_f->jc_no->Visible) { // jc_no ?>
	<div id="r_jc_no" class="form-group row">
		<label id="elh_material_out_f_jc_no" for="x_jc_no" class="<?php echo $material_out_f_add->LeftColumnClass ?>"><?php echo $material_out_f->jc_no->caption() ?><?php echo ($material_out_f->jc_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_f_add->RightColumnClass ?>"><div<?php echo $material_out_f->jc_no->cellAttributes() ?>>
<span id="el_material_out_f_jc_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_f" data-field="x_jc_no" data-value-separator="<?php echo $material_out_f->jc_no->displayValueSeparatorAttribute() ?>" id="x_jc_no" name="x_jc_no"<?php echo $material_out_f->jc_no->editAttributes() ?>>
		<?php echo $material_out_f->jc_no->selectOptionListHtml("x_jc_no") ?>
	</select>
</div>
<?php echo $material_out_f->jc_no->Lookup->getParamTag("p_x_jc_no") ?>
</span>
<?php echo $material_out_f->jc_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$material_out_f_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $material_out_f_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $material_out_f_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$material_out_f_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

$("#r_issue_to_sale").addClass('hide');
$("#r_fp_jc_no").addClass('hide');
$("#r_issue_to_process").addClass('hide');
$("#r_jc_no").addClass('hide');
</script>
<?php include_once "footer.php" ?>
<?php
$material_out_f_add->terminate();
?>