<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_out_f_list = new material_out_f_list();

// Run the page
$material_out_f_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_out_f_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$material_out_f->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmaterial_out_flist = currentForm = new ew.Form("fmaterial_out_flist", "list");
fmaterial_out_flist.formKeyCountName = '<?php echo $material_out_f_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmaterial_out_flist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_out_flist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_out_flist.lists["x_grp"] = <?php echo $material_out_f_list->grp->Lookup->toClientList() ?>;
fmaterial_out_flist.lists["x_grp"].options = <?php echo JsonEncode($material_out_f_list->grp->options(FALSE, TRUE)) ?>;
fmaterial_out_flist.lists["x_s_grp"] = <?php echo $material_out_f_list->s_grp->Lookup->toClientList() ?>;
fmaterial_out_flist.lists["x_s_grp"].options = <?php echo JsonEncode($material_out_f_list->s_grp->lookupOptions()) ?>;
fmaterial_out_flist.lists["x_rid"] = <?php echo $material_out_f_list->rid->Lookup->toClientList() ?>;
fmaterial_out_flist.lists["x_rid"].options = <?php echo JsonEncode($material_out_f_list->rid->lookupOptions()) ?>;
fmaterial_out_flist.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_flist.lists["x_packing_type"] = <?php echo $material_out_f_list->packing_type->Lookup->toClientList() ?>;
fmaterial_out_flist.lists["x_packing_type"].options = <?php echo JsonEncode($material_out_f_list->packing_type->lookupOptions()) ?>;
fmaterial_out_flist.autoSuggests["x_packing_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_flist.lists["x_godown"] = <?php echo $material_out_f_list->godown->Lookup->toClientList() ?>;
fmaterial_out_flist.lists["x_godown"].options = <?php echo JsonEncode($material_out_f_list->godown->lookupOptions()) ?>;
fmaterial_out_flist.autoSuggests["x_godown"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_flist.lists["x_quantity_avg_act"] = <?php echo $material_out_f_list->quantity_avg_act->Lookup->toClientList() ?>;
fmaterial_out_flist.lists["x_quantity_avg_act"].options = <?php echo JsonEncode($material_out_f_list->quantity_avg_act->options(FALSE, TRUE)) ?>;
fmaterial_out_flist.lists["x_process"] = <?php echo $material_out_f_list->process->Lookup->toClientList() ?>;
fmaterial_out_flist.lists["x_process"].options = <?php echo JsonEncode($material_out_f_list->process->lookupOptions()) ?>;
fmaterial_out_flist.lists["x_process_type"] = <?php echo $material_out_f_list->process_type->Lookup->toClientList() ?>;
fmaterial_out_flist.lists["x_process_type"].options = <?php echo JsonEncode($material_out_f_list->process_type->lookupOptions()) ?>;
fmaterial_out_flist.lists["x_issue_to"] = <?php echo $material_out_f_list->issue_to->Lookup->toClientList() ?>;
fmaterial_out_flist.lists["x_issue_to"].options = <?php echo JsonEncode($material_out_f_list->issue_to->lookupOptions()) ?>;
fmaterial_out_flist.lists["x_status"] = <?php echo $material_out_f_list->status->Lookup->toClientList() ?>;
fmaterial_out_flist.lists["x_status"].options = <?php echo JsonEncode($material_out_f_list->status->options(FALSE, TRUE)) ?>;
fmaterial_out_flist.lists["x_operator"] = <?php echo $material_out_f_list->operator->Lookup->toClientList() ?>;
fmaterial_out_flist.lists["x_operator"].options = <?php echo JsonEncode($material_out_f_list->operator->lookupOptions()) ?>;

// Form object for search
var fmaterial_out_flistsrch = currentSearchForm = new ew.Form("fmaterial_out_flistsrch");

// Validate function for search
fmaterial_out_flistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_product");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_f->product->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fmaterial_out_flistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_out_flistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_out_flistsrch.lists["x_grp"] = <?php echo $material_out_f_list->grp->Lookup->toClientList() ?>;
fmaterial_out_flistsrch.lists["x_grp"].options = <?php echo JsonEncode($material_out_f_list->grp->options(FALSE, TRUE)) ?>;
fmaterial_out_flistsrch.lists["x_s_grp"] = <?php echo $material_out_f_list->s_grp->Lookup->toClientList() ?>;
fmaterial_out_flistsrch.lists["x_s_grp"].options = <?php echo JsonEncode($material_out_f_list->s_grp->lookupOptions()) ?>;

// Filters
fmaterial_out_flistsrch.filterList = <?php echo $material_out_f_list->getFilterList() ?>;

// Init search panel as collapsed
fmaterial_out_flistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$material_out_f->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($material_out_f_list->TotalRecs > 0 && $material_out_f_list->ExportOptions->visible()) { ?>
<?php $material_out_f_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($material_out_f_list->ImportOptions->visible()) { ?>
<?php $material_out_f_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($material_out_f_list->SearchOptions->visible()) { ?>
<?php $material_out_f_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($material_out_f_list->FilterOptions->visible()) { ?>
<?php $material_out_f_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$material_out_f_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$material_out_f->isExport() && !$material_out_f->CurrentAction) { ?>
<form name="fmaterial_out_flistsrch" id="fmaterial_out_flistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($material_out_f_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmaterial_out_flistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="material_out_f">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$material_out_f_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$material_out_f->RowType = ROWTYPE_SEARCH;

// Render row
$material_out_f->resetAttributes();
$material_out_f_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($material_out_f->grp->Visible) { // grp ?>
	<div id="xsc_grp" class="ew-cell form-group">
		<label for="x_grp" class="ew-search-caption ew-label"><?php echo $material_out_f->grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_f" data-field="x_grp" data-value-separator="<?php echo $material_out_f->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $material_out_f->grp->editAttributes() ?>>
		<?php echo $material_out_f->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
<?php if ($material_out_f->s_grp->Visible) { // s_grp ?>
	<div id="xsc_s_grp" class="ew-cell form-group">
		<label for="x_s_grp" class="ew-search-caption ew-label"><?php echo $material_out_f->s_grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="material_out_f" data-field="x_s_grp" name="x_s_grp" id="x_s_grp" size="30" placeholder="<?php echo HtmlEncode($material_out_f->s_grp->getPlaceHolder()) ?>" value="<?php echo $material_out_f->s_grp->EditValue ?>"<?php echo $material_out_f->s_grp->editAttributes() ?>>
<?php echo $material_out_f->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
	</div>
<?php } ?>
<?php if ($material_out_f->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label for="x_product" class="ew-search-caption ew-label"><?php echo $material_out_f->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product" id="z_product" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="material_out_f" data-field="x_product" name="x_product" id="x_product" size="30" placeholder="<?php echo HtmlEncode($material_out_f->product->getPlaceHolder()) ?>" value="<?php echo $material_out_f->product->EditValue ?>"<?php echo $material_out_f->product->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($material_out_f_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($material_out_f_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $material_out_f_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($material_out_f_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($material_out_f_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($material_out_f_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($material_out_f_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $material_out_f_list->showPageHeader(); ?>
<?php
$material_out_f_list->showMessage();
?>
<?php if ($material_out_f_list->TotalRecs > 0 || $material_out_f->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($material_out_f_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> material_out_f">
<?php if (!$material_out_f->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$material_out_f->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_out_f_list->Pager)) $material_out_f_list->Pager = new PrevNextPager($material_out_f_list->StartRec, $material_out_f_list->DisplayRecs, $material_out_f_list->TotalRecs, $material_out_f_list->AutoHidePager) ?>
<?php if ($material_out_f_list->Pager->RecordCount > 0 && $material_out_f_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_out_f_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_out_f_list->pageUrl() ?>start=<?php echo $material_out_f_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_out_f_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_out_f_list->pageUrl() ?>start=<?php echo $material_out_f_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_out_f_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_out_f_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_out_f_list->pageUrl() ?>start=<?php echo $material_out_f_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_out_f_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_out_f_list->pageUrl() ?>start=<?php echo $material_out_f_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_out_f_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_out_f_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_out_f_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_out_f_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_out_f_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_out_f_list->TotalRecs > 0 && (!$material_out_f_list->AutoHidePageSizeSelector || $material_out_f_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_out_f">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_out_f_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_out_f_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_out_f_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_out_f_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_out_f_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_out_f->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_out_f_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmaterial_out_flist" id="fmaterial_out_flist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_out_f_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_out_f_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_out_f">
<div id="gmp_material_out_f" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($material_out_f_list->TotalRecs > 0 || $material_out_f->isGridEdit()) { ?>
<table id="tbl_material_out_flist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$material_out_f_list->RowType = ROWTYPE_HEADER;

// Render list options
$material_out_f_list->renderListOptions();

// Render list options (header, left)
$material_out_f_list->ListOptions->render("header", "left");
?>
<?php if ($material_out_f->id->Visible) { // id ?>
	<?php if ($material_out_f->sortUrl($material_out_f->id) == "") { ?>
		<th data-name="id" class="<?php echo $material_out_f->id->headerCellClass() ?>"><div id="elh_material_out_f_id" class="material_out_f_id"><div class="ew-table-header-caption"><?php echo $material_out_f->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $material_out_f->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_f->SortUrl($material_out_f->id) ?>',2);"><div id="elh_material_out_f_id" class="material_out_f_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_f->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_f->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_f->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_f->grp->Visible) { // grp ?>
	<?php if ($material_out_f->sortUrl($material_out_f->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $material_out_f->grp->headerCellClass() ?>"><div id="elh_material_out_f_grp" class="material_out_f_grp"><div class="ew-table-header-caption"><?php echo $material_out_f->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $material_out_f->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_f->SortUrl($material_out_f->grp) ?>',2);"><div id="elh_material_out_f_grp" class="material_out_f_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_f->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_f->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_f->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_f->s_grp->Visible) { // s_grp ?>
	<?php if ($material_out_f->sortUrl($material_out_f->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $material_out_f->s_grp->headerCellClass() ?>"><div id="elh_material_out_f_s_grp" class="material_out_f_s_grp"><div class="ew-table-header-caption"><?php echo $material_out_f->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $material_out_f->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_f->SortUrl($material_out_f->s_grp) ?>',2);"><div id="elh_material_out_f_s_grp" class="material_out_f_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_f->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_f->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_f->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_f->product->Visible) { // product ?>
	<?php if ($material_out_f->sortUrl($material_out_f->product) == "") { ?>
		<th data-name="product" class="<?php echo $material_out_f->product->headerCellClass() ?>"><div id="elh_material_out_f_product" class="material_out_f_product"><div class="ew-table-header-caption"><?php echo $material_out_f->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $material_out_f->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_f->SortUrl($material_out_f->product) ?>',2);"><div id="elh_material_out_f_product" class="material_out_f_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_f->product->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out_f->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_f->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_f->rid->Visible) { // rid ?>
	<?php if ($material_out_f->sortUrl($material_out_f->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $material_out_f->rid->headerCellClass() ?>"><div id="elh_material_out_f_rid" class="material_out_f_rid"><div class="ew-table-header-caption"><?php echo $material_out_f->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $material_out_f->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_f->SortUrl($material_out_f->rid) ?>',2);"><div id="elh_material_out_f_rid" class="material_out_f_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_f->rid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out_f->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_f->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_f->lot_no->Visible) { // lot_no ?>
	<?php if ($material_out_f->sortUrl($material_out_f->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $material_out_f->lot_no->headerCellClass() ?>"><div id="elh_material_out_f_lot_no" class="material_out_f_lot_no"><div class="ew-table-header-caption"><?php echo $material_out_f->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $material_out_f->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_f->SortUrl($material_out_f->lot_no) ?>',2);"><div id="elh_material_out_f_lot_no" class="material_out_f_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_f->lot_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out_f->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_f->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_f->packing_type->Visible) { // packing_type ?>
	<?php if ($material_out_f->sortUrl($material_out_f->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $material_out_f->packing_type->headerCellClass() ?>"><div id="elh_material_out_f_packing_type" class="material_out_f_packing_type"><div class="ew-table-header-caption"><?php echo $material_out_f->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $material_out_f->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_f->SortUrl($material_out_f->packing_type) ?>',2);"><div id="elh_material_out_f_packing_type" class="material_out_f_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_f->packing_type->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out_f->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_f->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_f->godown->Visible) { // godown ?>
	<?php if ($material_out_f->sortUrl($material_out_f->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $material_out_f->godown->headerCellClass() ?>"><div id="elh_material_out_f_godown" class="material_out_f_godown"><div class="ew-table-header-caption"><?php echo $material_out_f->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $material_out_f->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_f->SortUrl($material_out_f->godown) ?>',2);"><div id="elh_material_out_f_godown" class="material_out_f_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_f->godown->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out_f->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_f->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_f->quantity_avg_act->Visible) { // quantity_avg_act ?>
	<?php if ($material_out_f->sortUrl($material_out_f->quantity_avg_act) == "") { ?>
		<th data-name="quantity_avg_act" class="<?php echo $material_out_f->quantity_avg_act->headerCellClass() ?>"><div id="elh_material_out_f_quantity_avg_act" class="material_out_f_quantity_avg_act"><div class="ew-table-header-caption"><?php echo $material_out_f->quantity_avg_act->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity_avg_act" class="<?php echo $material_out_f->quantity_avg_act->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_f->SortUrl($material_out_f->quantity_avg_act) ?>',2);"><div id="elh_material_out_f_quantity_avg_act" class="material_out_f_quantity_avg_act">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_f->quantity_avg_act->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_f->quantity_avg_act->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_f->quantity_avg_act->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_f->packets->Visible) { // packets ?>
	<?php if ($material_out_f->sortUrl($material_out_f->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $material_out_f->packets->headerCellClass() ?>"><div id="elh_material_out_f_packets" class="material_out_f_packets"><div class="ew-table-header-caption"><?php echo $material_out_f->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $material_out_f->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_f->SortUrl($material_out_f->packets) ?>',2);"><div id="elh_material_out_f_packets" class="material_out_f_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_f->packets->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out_f->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_f->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_f->quantity->Visible) { // quantity ?>
	<?php if ($material_out_f->sortUrl($material_out_f->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $material_out_f->quantity->headerCellClass() ?>"><div id="elh_material_out_f_quantity" class="material_out_f_quantity"><div class="ew-table-header-caption"><?php echo $material_out_f->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $material_out_f->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_f->SortUrl($material_out_f->quantity) ?>',2);"><div id="elh_material_out_f_quantity" class="material_out_f_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_f->quantity->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out_f->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_f->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_f->dated->Visible) { // dated ?>
	<?php if ($material_out_f->sortUrl($material_out_f->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $material_out_f->dated->headerCellClass() ?>"><div id="elh_material_out_f_dated" class="material_out_f_dated"><div class="ew-table-header-caption"><?php echo $material_out_f->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $material_out_f->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_f->SortUrl($material_out_f->dated) ?>',2);"><div id="elh_material_out_f_dated" class="material_out_f_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_f->dated->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out_f->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_f->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_f->process->Visible) { // process ?>
	<?php if ($material_out_f->sortUrl($material_out_f->process) == "") { ?>
		<th data-name="process" class="<?php echo $material_out_f->process->headerCellClass() ?>"><div id="elh_material_out_f_process" class="material_out_f_process"><div class="ew-table-header-caption"><?php echo $material_out_f->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $material_out_f->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_f->SortUrl($material_out_f->process) ?>',2);"><div id="elh_material_out_f_process" class="material_out_f_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_f->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_f->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_f->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_f->process_type->Visible) { // process_type ?>
	<?php if ($material_out_f->sortUrl($material_out_f->process_type) == "") { ?>
		<th data-name="process_type" class="<?php echo $material_out_f->process_type->headerCellClass() ?>"><div id="elh_material_out_f_process_type" class="material_out_f_process_type"><div class="ew-table-header-caption"><?php echo $material_out_f->process_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_type" class="<?php echo $material_out_f->process_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_f->SortUrl($material_out_f->process_type) ?>',2);"><div id="elh_material_out_f_process_type" class="material_out_f_process_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_f->process_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_f->process_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_f->process_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_f->remarks->Visible) { // remarks ?>
	<?php if ($material_out_f->sortUrl($material_out_f->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $material_out_f->remarks->headerCellClass() ?>"><div id="elh_material_out_f_remarks" class="material_out_f_remarks"><div class="ew-table-header-caption"><?php echo $material_out_f->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $material_out_f->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_f->SortUrl($material_out_f->remarks) ?>',2);"><div id="elh_material_out_f_remarks" class="material_out_f_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_f->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out_f->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_f->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_f->tmp_lot->Visible) { // tmp_lot ?>
	<?php if ($material_out_f->sortUrl($material_out_f->tmp_lot) == "") { ?>
		<th data-name="tmp_lot" class="<?php echo $material_out_f->tmp_lot->headerCellClass() ?>"><div id="elh_material_out_f_tmp_lot" class="material_out_f_tmp_lot"><div class="ew-table-header-caption"><?php echo $material_out_f->tmp_lot->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tmp_lot" class="<?php echo $material_out_f->tmp_lot->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_f->SortUrl($material_out_f->tmp_lot) ?>',2);"><div id="elh_material_out_f_tmp_lot" class="material_out_f_tmp_lot">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_f->tmp_lot->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out_f->tmp_lot->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_f->tmp_lot->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_f->issue_to->Visible) { // issue_to ?>
	<?php if ($material_out_f->sortUrl($material_out_f->issue_to) == "") { ?>
		<th data-name="issue_to" class="<?php echo $material_out_f->issue_to->headerCellClass() ?>"><div id="elh_material_out_f_issue_to" class="material_out_f_issue_to"><div class="ew-table-header-caption"><?php echo $material_out_f->issue_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issue_to" class="<?php echo $material_out_f->issue_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_f->SortUrl($material_out_f->issue_to) ?>',2);"><div id="elh_material_out_f_issue_to" class="material_out_f_issue_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_f->issue_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_f->issue_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_f->issue_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_f->status->Visible) { // status ?>
	<?php if ($material_out_f->sortUrl($material_out_f->status) == "") { ?>
		<th data-name="status" class="<?php echo $material_out_f->status->headerCellClass() ?>"><div id="elh_material_out_f_status" class="material_out_f_status"><div class="ew-table-header-caption"><?php echo $material_out_f->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $material_out_f->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_f->SortUrl($material_out_f->status) ?>',2);"><div id="elh_material_out_f_status" class="material_out_f_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_f->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_f->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_f->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_f->operator->Visible) { // operator ?>
	<?php if ($material_out_f->sortUrl($material_out_f->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $material_out_f->operator->headerCellClass() ?>"><div id="elh_material_out_f_operator" class="material_out_f_operator"><div class="ew-table-header-caption"><?php echo $material_out_f->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $material_out_f->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_f->SortUrl($material_out_f->operator) ?>',2);"><div id="elh_material_out_f_operator" class="material_out_f_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_f->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_f->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_f->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_f->datetime->Visible) { // datetime ?>
	<?php if ($material_out_f->sortUrl($material_out_f->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $material_out_f->datetime->headerCellClass() ?>"><div id="elh_material_out_f_datetime" class="material_out_f_datetime"><div class="ew-table-header-caption"><?php echo $material_out_f->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $material_out_f->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_f->SortUrl($material_out_f->datetime) ?>',2);"><div id="elh_material_out_f_datetime" class="material_out_f_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_f->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_f->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_f->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$material_out_f_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($material_out_f->ExportAll && $material_out_f->isExport()) {
	$material_out_f_list->StopRec = $material_out_f_list->TotalRecs;
} else {

	// Set the last record to display
	if ($material_out_f_list->TotalRecs > $material_out_f_list->StartRec + $material_out_f_list->DisplayRecs - 1)
		$material_out_f_list->StopRec = $material_out_f_list->StartRec + $material_out_f_list->DisplayRecs - 1;
	else
		$material_out_f_list->StopRec = $material_out_f_list->TotalRecs;
}
$material_out_f_list->RecCnt = $material_out_f_list->StartRec - 1;
if ($material_out_f_list->Recordset && !$material_out_f_list->Recordset->EOF) {
	$material_out_f_list->Recordset->moveFirst();
	$selectLimit = $material_out_f_list->UseSelectLimit;
	if (!$selectLimit && $material_out_f_list->StartRec > 1)
		$material_out_f_list->Recordset->move($material_out_f_list->StartRec - 1);
} elseif (!$material_out_f->AllowAddDeleteRow && $material_out_f_list->StopRec == 0) {
	$material_out_f_list->StopRec = $material_out_f->GridAddRowCount;
}

// Initialize aggregate
$material_out_f->RowType = ROWTYPE_AGGREGATEINIT;
$material_out_f->resetAttributes();
$material_out_f_list->renderRow();
while ($material_out_f_list->RecCnt < $material_out_f_list->StopRec) {
	$material_out_f_list->RecCnt++;
	if ($material_out_f_list->RecCnt >= $material_out_f_list->StartRec) {
		$material_out_f_list->RowCnt++;

		// Set up key count
		$material_out_f_list->KeyCount = $material_out_f_list->RowIndex;

		// Init row class and style
		$material_out_f->resetAttributes();
		$material_out_f->CssClass = "";
		if ($material_out_f->isGridAdd()) {
		} else {
			$material_out_f_list->loadRowValues($material_out_f_list->Recordset); // Load row values
		}
		$material_out_f->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$material_out_f->RowAttrs = array_merge($material_out_f->RowAttrs, array('data-rowindex'=>$material_out_f_list->RowCnt, 'id'=>'r' . $material_out_f_list->RowCnt . '_material_out_f', 'data-rowtype'=>$material_out_f->RowType));

		// Render row
		$material_out_f_list->renderRow();

		// Render list options
		$material_out_f_list->renderListOptions();
?>
	<tr<?php echo $material_out_f->rowAttributes() ?>>
<?php

// Render list options (body, left)
$material_out_f_list->ListOptions->render("body", "left", $material_out_f_list->RowCnt);
?>
	<?php if ($material_out_f->id->Visible) { // id ?>
		<td data-name="id"<?php echo $material_out_f->id->cellAttributes() ?>>
<span id="el<?php echo $material_out_f_list->RowCnt ?>_material_out_f_id" class="material_out_f_id">
<span<?php echo $material_out_f->id->viewAttributes() ?>>
<?php echo $material_out_f->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_f->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $material_out_f->grp->cellAttributes() ?>>
<span id="el<?php echo $material_out_f_list->RowCnt ?>_material_out_f_grp" class="material_out_f_grp">
<span<?php echo $material_out_f->grp->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_f->grp->getViewValue())) && $material_out_f->grp->linkAttributes() <> "") { ?>
<a<?php echo $material_out_f->grp->linkAttributes() ?>><?php echo $material_out_f->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_f->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_f->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $material_out_f->s_grp->cellAttributes() ?>>
<span id="el<?php echo $material_out_f_list->RowCnt ?>_material_out_f_s_grp" class="material_out_f_s_grp">
<span<?php echo $material_out_f->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_f->s_grp->getViewValue())) && $material_out_f->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $material_out_f->s_grp->linkAttributes() ?>><?php echo $material_out_f->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_f->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_f->product->Visible) { // product ?>
		<td data-name="product"<?php echo $material_out_f->product->cellAttributes() ?>>
<span id="el<?php echo $material_out_f_list->RowCnt ?>_material_out_f_product" class="material_out_f_product">
<span<?php echo $material_out_f->product->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_f->product->getViewValue())) && $material_out_f->product->linkAttributes() <> "") { ?>
<a<?php echo $material_out_f->product->linkAttributes() ?>><?php echo $material_out_f->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_f->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_f->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $material_out_f->rid->cellAttributes() ?>>
<span id="el<?php echo $material_out_f_list->RowCnt ?>_material_out_f_rid" class="material_out_f_rid">
<span<?php echo $material_out_f->rid->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_f->rid->getViewValue())) && $material_out_f->rid->linkAttributes() <> "") { ?>
<a<?php echo $material_out_f->rid->linkAttributes() ?>><?php echo $material_out_f->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_f->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_f->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $material_out_f->lot_no->cellAttributes() ?>>
<span id="el<?php echo $material_out_f_list->RowCnt ?>_material_out_f_lot_no" class="material_out_f_lot_no">
<span<?php echo $material_out_f->lot_no->viewAttributes() ?>>
<?php echo $material_out_f->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_f->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $material_out_f->packing_type->cellAttributes() ?>>
<span id="el<?php echo $material_out_f_list->RowCnt ?>_material_out_f_packing_type" class="material_out_f_packing_type">
<span<?php echo $material_out_f->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_f->packing_type->getViewValue())) && $material_out_f->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $material_out_f->packing_type->linkAttributes() ?>><?php echo $material_out_f->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_f->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_f->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $material_out_f->godown->cellAttributes() ?>>
<span id="el<?php echo $material_out_f_list->RowCnt ?>_material_out_f_godown" class="material_out_f_godown">
<span<?php echo $material_out_f->godown->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_f->godown->getViewValue())) && $material_out_f->godown->linkAttributes() <> "") { ?>
<a<?php echo $material_out_f->godown->linkAttributes() ?>><?php echo $material_out_f->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_f->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_f->quantity_avg_act->Visible) { // quantity_avg_act ?>
		<td data-name="quantity_avg_act"<?php echo $material_out_f->quantity_avg_act->cellAttributes() ?>>
<span id="el<?php echo $material_out_f_list->RowCnt ?>_material_out_f_quantity_avg_act" class="material_out_f_quantity_avg_act">
<span<?php echo $material_out_f->quantity_avg_act->viewAttributes() ?>>
<?php echo $material_out_f->quantity_avg_act->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_f->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $material_out_f->packets->cellAttributes() ?>>
<span id="el<?php echo $material_out_f_list->RowCnt ?>_material_out_f_packets" class="material_out_f_packets">
<span<?php echo $material_out_f->packets->viewAttributes() ?>>
<?php echo $material_out_f->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_f->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $material_out_f->quantity->cellAttributes() ?>>
<span id="el<?php echo $material_out_f_list->RowCnt ?>_material_out_f_quantity" class="material_out_f_quantity">
<span<?php echo $material_out_f->quantity->viewAttributes() ?>>
<?php echo $material_out_f->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_f->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $material_out_f->dated->cellAttributes() ?>>
<span id="el<?php echo $material_out_f_list->RowCnt ?>_material_out_f_dated" class="material_out_f_dated">
<span<?php echo $material_out_f->dated->viewAttributes() ?>>
<?php echo $material_out_f->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_f->process->Visible) { // process ?>
		<td data-name="process"<?php echo $material_out_f->process->cellAttributes() ?>>
<span id="el<?php echo $material_out_f_list->RowCnt ?>_material_out_f_process" class="material_out_f_process">
<span<?php echo $material_out_f->process->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_f->process->getViewValue())) && $material_out_f->process->linkAttributes() <> "") { ?>
<a<?php echo $material_out_f->process->linkAttributes() ?>><?php echo $material_out_f->process->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_f->process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_f->process_type->Visible) { // process_type ?>
		<td data-name="process_type"<?php echo $material_out_f->process_type->cellAttributes() ?>>
<span id="el<?php echo $material_out_f_list->RowCnt ?>_material_out_f_process_type" class="material_out_f_process_type">
<span<?php echo $material_out_f->process_type->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_f->process_type->getViewValue())) && $material_out_f->process_type->linkAttributes() <> "") { ?>
<a<?php echo $material_out_f->process_type->linkAttributes() ?>><?php echo $material_out_f->process_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_f->process_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_f->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $material_out_f->remarks->cellAttributes() ?>>
<span id="el<?php echo $material_out_f_list->RowCnt ?>_material_out_f_remarks" class="material_out_f_remarks">
<span<?php echo $material_out_f->remarks->viewAttributes() ?>>
<?php echo $material_out_f->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_f->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot"<?php echo $material_out_f->tmp_lot->cellAttributes() ?>>
<span id="el<?php echo $material_out_f_list->RowCnt ?>_material_out_f_tmp_lot" class="material_out_f_tmp_lot">
<span<?php echo $material_out_f->tmp_lot->viewAttributes() ?>>
<?php echo $material_out_f->tmp_lot->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_f->issue_to->Visible) { // issue_to ?>
		<td data-name="issue_to"<?php echo $material_out_f->issue_to->cellAttributes() ?>>
<span id="el<?php echo $material_out_f_list->RowCnt ?>_material_out_f_issue_to" class="material_out_f_issue_to">
<span<?php echo $material_out_f->issue_to->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_f->issue_to->getViewValue())) && $material_out_f->issue_to->linkAttributes() <> "") { ?>
<a<?php echo $material_out_f->issue_to->linkAttributes() ?>><?php echo $material_out_f->issue_to->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_f->issue_to->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_f->status->Visible) { // status ?>
		<td data-name="status"<?php echo $material_out_f->status->cellAttributes() ?>>
<span id="el<?php echo $material_out_f_list->RowCnt ?>_material_out_f_status" class="material_out_f_status">
<span<?php echo $material_out_f->status->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_f->status->getViewValue())) && $material_out_f->status->linkAttributes() <> "") { ?>
<a<?php echo $material_out_f->status->linkAttributes() ?>><?php echo $material_out_f->status->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_f->status->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_f->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $material_out_f->operator->cellAttributes() ?>>
<span id="el<?php echo $material_out_f_list->RowCnt ?>_material_out_f_operator" class="material_out_f_operator">
<span<?php echo $material_out_f->operator->viewAttributes() ?>>
<?php echo $material_out_f->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_f->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $material_out_f->datetime->cellAttributes() ?>>
<span id="el<?php echo $material_out_f_list->RowCnt ?>_material_out_f_datetime" class="material_out_f_datetime">
<span<?php echo $material_out_f->datetime->viewAttributes() ?>>
<?php echo $material_out_f->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$material_out_f_list->ListOptions->render("body", "right", $material_out_f_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$material_out_f->isGridAdd())
		$material_out_f_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$material_out_f->RowType = ROWTYPE_AGGREGATE;
$material_out_f->resetAttributes();
$material_out_f_list->renderRow();
?>
<?php if ($material_out_f_list->TotalRecs > 0 && !$material_out_f->isGridAdd() && !$material_out_f->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$material_out_f_list->renderListOptions();

// Render list options (footer, left)
$material_out_f_list->ListOptions->render("footer", "left");
?>
	<?php if ($material_out_f->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $material_out_f->id->footerCellClass() ?>"><span id="elf_material_out_f_id" class="material_out_f_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_f->grp->Visible) { // grp ?>
		<td data-name="grp" class="<?php echo $material_out_f->grp->footerCellClass() ?>"><span id="elf_material_out_f_grp" class="material_out_f_grp">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_f->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp" class="<?php echo $material_out_f->s_grp->footerCellClass() ?>"><span id="elf_material_out_f_s_grp" class="material_out_f_s_grp">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_f->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $material_out_f->product->footerCellClass() ?>"><span id="elf_material_out_f_product" class="material_out_f_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_f->rid->Visible) { // rid ?>
		<td data-name="rid" class="<?php echo $material_out_f->rid->footerCellClass() ?>"><span id="elf_material_out_f_rid" class="material_out_f_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_f->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no" class="<?php echo $material_out_f->lot_no->footerCellClass() ?>"><span id="elf_material_out_f_lot_no" class="material_out_f_lot_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_f->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $material_out_f->packing_type->footerCellClass() ?>"><span id="elf_material_out_f_packing_type" class="material_out_f_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_f->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $material_out_f->godown->footerCellClass() ?>"><span id="elf_material_out_f_godown" class="material_out_f_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_f->quantity_avg_act->Visible) { // quantity_avg_act ?>
		<td data-name="quantity_avg_act" class="<?php echo $material_out_f->quantity_avg_act->footerCellClass() ?>"><span id="elf_material_out_f_quantity_avg_act" class="material_out_f_quantity_avg_act">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_f->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $material_out_f->packets->footerCellClass() ?>"><span id="elf_material_out_f_packets" class="material_out_f_packets">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $material_out_f->packets->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($material_out_f->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $material_out_f->quantity->footerCellClass() ?>"><span id="elf_material_out_f_quantity" class="material_out_f_quantity">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $material_out_f->quantity->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($material_out_f->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $material_out_f->dated->footerCellClass() ?>"><span id="elf_material_out_f_dated" class="material_out_f_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_f->process->Visible) { // process ?>
		<td data-name="process" class="<?php echo $material_out_f->process->footerCellClass() ?>"><span id="elf_material_out_f_process" class="material_out_f_process">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_f->process_type->Visible) { // process_type ?>
		<td data-name="process_type" class="<?php echo $material_out_f->process_type->footerCellClass() ?>"><span id="elf_material_out_f_process_type" class="material_out_f_process_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_f->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $material_out_f->remarks->footerCellClass() ?>"><span id="elf_material_out_f_remarks" class="material_out_f_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_f->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot" class="<?php echo $material_out_f->tmp_lot->footerCellClass() ?>"><span id="elf_material_out_f_tmp_lot" class="material_out_f_tmp_lot">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_f->issue_to->Visible) { // issue_to ?>
		<td data-name="issue_to" class="<?php echo $material_out_f->issue_to->footerCellClass() ?>"><span id="elf_material_out_f_issue_to" class="material_out_f_issue_to">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_f->status->Visible) { // status ?>
		<td data-name="status" class="<?php echo $material_out_f->status->footerCellClass() ?>"><span id="elf_material_out_f_status" class="material_out_f_status">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_f->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $material_out_f->operator->footerCellClass() ?>"><span id="elf_material_out_f_operator" class="material_out_f_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_f->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $material_out_f->datetime->footerCellClass() ?>"><span id="elf_material_out_f_datetime" class="material_out_f_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$material_out_f_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$material_out_f->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($material_out_f_list->Recordset)
	$material_out_f_list->Recordset->Close();
?>
<?php if (!$material_out_f->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$material_out_f->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_out_f_list->Pager)) $material_out_f_list->Pager = new PrevNextPager($material_out_f_list->StartRec, $material_out_f_list->DisplayRecs, $material_out_f_list->TotalRecs, $material_out_f_list->AutoHidePager) ?>
<?php if ($material_out_f_list->Pager->RecordCount > 0 && $material_out_f_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_out_f_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_out_f_list->pageUrl() ?>start=<?php echo $material_out_f_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_out_f_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_out_f_list->pageUrl() ?>start=<?php echo $material_out_f_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_out_f_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_out_f_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_out_f_list->pageUrl() ?>start=<?php echo $material_out_f_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_out_f_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_out_f_list->pageUrl() ?>start=<?php echo $material_out_f_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_out_f_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_out_f_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_out_f_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_out_f_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_out_f_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_out_f_list->TotalRecs > 0 && (!$material_out_f_list->AutoHidePageSizeSelector || $material_out_f_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_out_f">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_out_f_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_out_f_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_out_f_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_out_f_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_out_f_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_out_f->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_out_f_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($material_out_f_list->TotalRecs == 0 && !$material_out_f->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $material_out_f_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$material_out_f_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$material_out_f->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$material_out_f->isExport()) { ?>
<script>
ew.scrollableTable("gmp_material_out_f", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$material_out_f_list->terminate();
?>