<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_out_fp_add = new material_out_fp_add();

// Run the page
$material_out_fp_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_out_fp_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fmaterial_out_fpadd = currentForm = new ew.Form("fmaterial_out_fpadd", "add");

// Validate form
fmaterial_out_fpadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($material_out_fp_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_fp->grp->caption(), $material_out_fp->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_fp_add->jc_no->Required) { ?>
			elm = this.getElements("x" + infix + "_jc_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_fp->jc_no->caption(), $material_out_fp->jc_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_fp_add->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_fp->s_grp->caption(), $material_out_fp->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_fp_add->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_fp->product->caption(), $material_out_fp->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_fp_add->rid1->Required) { ?>
			elm = this.getElements("x" + infix + "_rid1");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_fp->rid1->caption(), $material_out_fp->rid1->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_rid1");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out_fp->rid1->errorMessage()) ?>");
		<?php if ($material_out_fp_add->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_fp->rid->caption(), $material_out_fp->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out_fp->rid->errorMessage()) ?>");
		<?php if ($material_out_fp_add->lot_no->Required) { ?>
			elm = this.getElements("x" + infix + "_lot_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_fp->lot_no->caption(), $material_out_fp->lot_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_fp_add->tmp_lot->Required) { ?>
			elm = this.getElements("x" + infix + "_tmp_lot");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_fp->tmp_lot->caption(), $material_out_fp->tmp_lot->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_tmp_lot");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out_fp->tmp_lot->errorMessage()) ?>");
		<?php if ($material_out_fp_add->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_fp->packing_type->caption(), $material_out_fp->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out_fp->packing_type->errorMessage()) ?>");
		<?php if ($material_out_fp_add->godown->Required) { ?>
			elm = this.getElements("x" + infix + "_godown");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_fp->godown->caption(), $material_out_fp->godown->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_godown");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out_fp->godown->errorMessage()) ?>");
		<?php if ($material_out_fp_add->quantity_avg_act->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity_avg_act");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_fp->quantity_avg_act->caption(), $material_out_fp->quantity_avg_act->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_fp_add->max_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_max_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_fp->max_qty->caption(), $material_out_fp->max_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_max_qty");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out_fp->max_qty->errorMessage()) ?>");
		<?php if ($material_out_fp_add->packets->Required) { ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_fp->packets->caption(), $material_out_fp->packets->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.checkRange(elm.value, 0.001, 10000))
				return this.onError(elm, "<?php echo JsEncode($material_out_fp->packets->errorMessage()) ?>");
		<?php if ($material_out_fp_add->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_fp->quantity->caption(), $material_out_fp->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out_fp->quantity->errorMessage()) ?>");
		<?php if ($material_out_fp_add->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_fp->dated->caption(), $material_out_fp->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out_fp->dated->errorMessage()) ?>");
		<?php if ($material_out_fp_add->process->Required) { ?>
			elm = this.getElements("x" + infix + "_process");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_fp->process->caption(), $material_out_fp->process->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_fp_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_fp->remarks->caption(), $material_out_fp->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_fp_add->issue_to_sale->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_to_sale");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_fp->issue_to_sale->caption(), $material_out_fp->issue_to_sale->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_fp_add->issue_to_godown->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_to_godown");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_fp->issue_to_godown->caption(), $material_out_fp->issue_to_godown->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_fp_add->issue_to->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_fp->issue_to->caption(), $material_out_fp->issue_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_fp_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_fp->operator->caption(), $material_out_fp->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_fp_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_fp->datetime->caption(), $material_out_fp->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_fp_add->po->Required) { ?>
			elm = this.getElements("x" + infix + "_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_fp->po->caption(), $material_out_fp->po->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fmaterial_out_fpadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_out_fpadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_out_fpadd.lists["x_grp"] = <?php echo $material_out_fp_add->grp->Lookup->toClientList() ?>;
fmaterial_out_fpadd.lists["x_grp"].options = <?php echo JsonEncode($material_out_fp_add->grp->options(FALSE, TRUE)) ?>;
fmaterial_out_fpadd.lists["x_jc_no"] = <?php echo $material_out_fp_add->jc_no->Lookup->toClientList() ?>;
fmaterial_out_fpadd.lists["x_jc_no"].options = <?php echo JsonEncode($material_out_fp_add->jc_no->lookupOptions()) ?>;
fmaterial_out_fpadd.lists["x_s_grp"] = <?php echo $material_out_fp_add->s_grp->Lookup->toClientList() ?>;
fmaterial_out_fpadd.lists["x_s_grp"].options = <?php echo JsonEncode($material_out_fp_add->s_grp->lookupOptions()) ?>;
fmaterial_out_fpadd.lists["x_product"] = <?php echo $material_out_fp_add->product->Lookup->toClientList() ?>;
fmaterial_out_fpadd.lists["x_product"].options = <?php echo JsonEncode($material_out_fp_add->product->lookupOptions()) ?>;
fmaterial_out_fpadd.lists["x_rid"] = <?php echo $material_out_fp_add->rid->Lookup->toClientList() ?>;
fmaterial_out_fpadd.lists["x_rid"].options = <?php echo JsonEncode($material_out_fp_add->rid->lookupOptions()) ?>;
fmaterial_out_fpadd.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_fpadd.lists["x_packing_type"] = <?php echo $material_out_fp_add->packing_type->Lookup->toClientList() ?>;
fmaterial_out_fpadd.lists["x_packing_type"].options = <?php echo JsonEncode($material_out_fp_add->packing_type->lookupOptions()) ?>;
fmaterial_out_fpadd.autoSuggests["x_packing_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_fpadd.lists["x_godown"] = <?php echo $material_out_fp_add->godown->Lookup->toClientList() ?>;
fmaterial_out_fpadd.lists["x_godown"].options = <?php echo JsonEncode($material_out_fp_add->godown->lookupOptions()) ?>;
fmaterial_out_fpadd.autoSuggests["x_godown"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_fpadd.lists["x_quantity_avg_act"] = <?php echo $material_out_fp_add->quantity_avg_act->Lookup->toClientList() ?>;
fmaterial_out_fpadd.lists["x_quantity_avg_act"].options = <?php echo JsonEncode($material_out_fp_add->quantity_avg_act->options(FALSE, TRUE)) ?>;
fmaterial_out_fpadd.lists["x_process"] = <?php echo $material_out_fp_add->process->Lookup->toClientList() ?>;
fmaterial_out_fpadd.lists["x_process"].options = <?php echo JsonEncode($material_out_fp_add->process->lookupOptions()) ?>;
fmaterial_out_fpadd.lists["x_issue_to_sale"] = <?php echo $material_out_fp_add->issue_to_sale->Lookup->toClientList() ?>;
fmaterial_out_fpadd.lists["x_issue_to_sale"].options = <?php echo JsonEncode($material_out_fp_add->issue_to_sale->lookupOptions()) ?>;
fmaterial_out_fpadd.lists["x_issue_to_godown"] = <?php echo $material_out_fp_add->issue_to_godown->Lookup->toClientList() ?>;
fmaterial_out_fpadd.lists["x_issue_to_godown"].options = <?php echo JsonEncode($material_out_fp_add->issue_to_godown->lookupOptions()) ?>;
fmaterial_out_fpadd.lists["x_issue_to"] = <?php echo $material_out_fp_add->issue_to->Lookup->toClientList() ?>;
fmaterial_out_fpadd.lists["x_issue_to"].options = <?php echo JsonEncode($material_out_fp_add->issue_to->lookupOptions()) ?>;
fmaterial_out_fpadd.lists["x_operator"] = <?php echo $material_out_fp_add->operator->Lookup->toClientList() ?>;
fmaterial_out_fpadd.lists["x_operator"].options = <?php echo JsonEncode($material_out_fp_add->operator->lookupOptions()) ?>;
fmaterial_out_fpadd.lists["x_po"] = <?php echo $material_out_fp_add->po->Lookup->toClientList() ?>;
fmaterial_out_fpadd.lists["x_po"].options = <?php echo JsonEncode($material_out_fp_add->po->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $material_out_fp_add->showPageHeader(); ?>
<?php
$material_out_fp_add->showMessage();
?>
<form name="fmaterial_out_fpadd" id="fmaterial_out_fpadd" class="<?php echo $material_out_fp_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_out_fp_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_out_fp_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_out_fp">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$material_out_fp_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($material_out_fp->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_material_out_fp_grp" for="x_grp" class="<?php echo $material_out_fp_add->LeftColumnClass ?>"><?php echo $material_out_fp->grp->caption() ?><?php echo ($material_out_fp->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_fp_add->RightColumnClass ?>"><div<?php echo $material_out_fp->grp->cellAttributes() ?>>
<span id="el_material_out_fp_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_fp" data-field="x_grp" data-value-separator="<?php echo $material_out_fp->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $material_out_fp->grp->editAttributes() ?>>
		<?php echo $material_out_fp->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
<?php echo $material_out_fp->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->jc_no->Visible) { // jc_no ?>
	<div id="r_jc_no" class="form-group row">
		<label id="elh_material_out_fp_jc_no" for="x_jc_no" class="<?php echo $material_out_fp_add->LeftColumnClass ?>"><?php echo $material_out_fp->jc_no->caption() ?><?php echo ($material_out_fp->jc_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_fp_add->RightColumnClass ?>"><div<?php echo $material_out_fp->jc_no->cellAttributes() ?>>
<span id="el_material_out_fp_jc_no">
<?php $material_out_fp->jc_no->EditAttrs["onchange"] = "ew.autoFill(this);" . @$material_out_fp->jc_no->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_fp" data-field="x_jc_no" data-value-separator="<?php echo $material_out_fp->jc_no->displayValueSeparatorAttribute() ?>" id="x_jc_no" name="x_jc_no"<?php echo $material_out_fp->jc_no->editAttributes() ?>>
		<?php echo $material_out_fp->jc_no->selectOptionListHtml("x_jc_no") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "job_card") && !$material_out_fp->jc_no->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_jc_no" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $material_out_fp->jc_no->caption() ?>" data-title="<?php echo $material_out_fp->jc_no->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_jc_no',url:'job_cardaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $material_out_fp->jc_no->Lookup->getParamTag("p_x_jc_no") ?>
</span>
<?php echo $material_out_fp->jc_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_material_out_fp_s_grp" for="x_s_grp" class="<?php echo $material_out_fp_add->LeftColumnClass ?>"><?php echo $material_out_fp->s_grp->caption() ?><?php echo ($material_out_fp->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_fp_add->RightColumnClass ?>"><div<?php echo $material_out_fp->s_grp->cellAttributes() ?>>
<span id="el_material_out_fp_s_grp">
<?php $material_out_fp->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_out_fp->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_fp" data-field="x_s_grp" data-value-separator="<?php echo $material_out_fp->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $material_out_fp->s_grp->editAttributes() ?>>
		<?php echo $material_out_fp->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $material_out_fp->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
<?php echo $material_out_fp->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_material_out_fp_product" for="x_product" class="<?php echo $material_out_fp_add->LeftColumnClass ?>"><?php echo $material_out_fp->product->caption() ?><?php echo ($material_out_fp->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_fp_add->RightColumnClass ?>"><div<?php echo $material_out_fp->product->cellAttributes() ?>>
<span id="el_material_out_fp_product">
<?php $material_out_fp->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_out_fp->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_fp" data-field="x_product" data-value-separator="<?php echo $material_out_fp->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $material_out_fp->product->editAttributes() ?>>
		<?php echo $material_out_fp->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $material_out_fp->product->Lookup->getParamTag("p_x_product") ?>
</span>
<?php echo $material_out_fp->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->rid1->Visible) { // rid1 ?>
	<div id="r_rid1" class="form-group row">
		<label id="elh_material_out_fp_rid1" for="x_rid1" class="<?php echo $material_out_fp_add->LeftColumnClass ?>"><?php echo $material_out_fp->rid1->caption() ?><?php echo ($material_out_fp->rid1->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_fp_add->RightColumnClass ?>"><div<?php echo $material_out_fp->rid1->cellAttributes() ?>>
<span id="el_material_out_fp_rid1">
<input type="text" data-table="material_out_fp" data-field="x_rid1" name="x_rid1" id="x_rid1" size="30" placeholder="<?php echo HtmlEncode($material_out_fp->rid1->getPlaceHolder()) ?>" value="<?php echo $material_out_fp->rid1->EditValue ?>"<?php echo $material_out_fp->rid1->editAttributes() ?>>
</span>
<?php echo $material_out_fp->rid1->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label id="elh_material_out_fp_rid" class="<?php echo $material_out_fp_add->LeftColumnClass ?>"><?php echo $material_out_fp->rid->caption() ?><?php echo ($material_out_fp->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_fp_add->RightColumnClass ?>"><div<?php echo $material_out_fp->rid->cellAttributes() ?>>
<span id="el_material_out_fp_rid">
<?php
$wrkonchange = "" . trim(@$material_out_fp->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_out_fp->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid" class="text-nowrap" style="z-index: 8920">
	<input type="text" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?php echo RemoveHtml($material_out_fp->rid->EditValue) ?>" size="40" placeholder="<?php echo HtmlEncode($material_out_fp->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_out_fp->rid->getPlaceHolder()) ?>"<?php echo $material_out_fp->rid->editAttributes() ?>>
</span>
<input type="hidden" data-table="material_out_fp" data-field="x_rid" data-value-separator="<?php echo $material_out_fp->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($material_out_fp->rid->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_out_fpadd.createAutoSuggest({"id":"x_rid","forceSelect":false});
</script>
<?php echo $material_out_fp->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
<?php echo $material_out_fp->rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label id="elh_material_out_fp_lot_no" for="x_lot_no" class="<?php echo $material_out_fp_add->LeftColumnClass ?>"><?php echo $material_out_fp->lot_no->caption() ?><?php echo ($material_out_fp->lot_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_fp_add->RightColumnClass ?>"><div<?php echo $material_out_fp->lot_no->cellAttributes() ?>>
<span id="el_material_out_fp_lot_no">
<input type="text" data-table="material_out_fp" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($material_out_fp->lot_no->getPlaceHolder()) ?>" value="<?php echo $material_out_fp->lot_no->EditValue ?>"<?php echo $material_out_fp->lot_no->editAttributes() ?>>
</span>
<?php echo $material_out_fp->lot_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->tmp_lot->Visible) { // tmp_lot ?>
	<div id="r_tmp_lot" class="form-group row">
		<label id="elh_material_out_fp_tmp_lot" for="x_tmp_lot" class="<?php echo $material_out_fp_add->LeftColumnClass ?>"><?php echo $material_out_fp->tmp_lot->caption() ?><?php echo ($material_out_fp->tmp_lot->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_fp_add->RightColumnClass ?>"><div<?php echo $material_out_fp->tmp_lot->cellAttributes() ?>>
<span id="el_material_out_fp_tmp_lot">
<input type="text" data-table="material_out_fp" data-field="x_tmp_lot" name="x_tmp_lot" id="x_tmp_lot" size="30" placeholder="<?php echo HtmlEncode($material_out_fp->tmp_lot->getPlaceHolder()) ?>" value="<?php echo $material_out_fp->tmp_lot->EditValue ?>"<?php echo $material_out_fp->tmp_lot->editAttributes() ?>>
</span>
<?php echo $material_out_fp->tmp_lot->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label id="elh_material_out_fp_packing_type" class="<?php echo $material_out_fp_add->LeftColumnClass ?>"><?php echo $material_out_fp->packing_type->caption() ?><?php echo ($material_out_fp->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_fp_add->RightColumnClass ?>"><div<?php echo $material_out_fp->packing_type->cellAttributes() ?>>
<span id="el_material_out_fp_packing_type">
<?php
$wrkonchange = "" . trim(@$material_out_fp->packing_type->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_out_fp->packing_type->EditAttrs["onchange"] = "";
?>
<span id="as_x_packing_type" class="text-nowrap" style="z-index: 8890">
	<input type="text" class="form-control" name="sv_x_packing_type" id="sv_x_packing_type" value="<?php echo RemoveHtml($material_out_fp->packing_type->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($material_out_fp->packing_type->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_out_fp->packing_type->getPlaceHolder()) ?>"<?php echo $material_out_fp->packing_type->editAttributes() ?>>
</span>
<input type="hidden" data-table="material_out_fp" data-field="x_packing_type" data-value-separator="<?php echo $material_out_fp->packing_type->displayValueSeparatorAttribute() ?>" name="x_packing_type" id="x_packing_type" value="<?php echo HtmlEncode($material_out_fp->packing_type->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_out_fpadd.createAutoSuggest({"id":"x_packing_type","forceSelect":false});
</script>
<?php echo $material_out_fp->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
<?php echo $material_out_fp->packing_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label id="elh_material_out_fp_godown" class="<?php echo $material_out_fp_add->LeftColumnClass ?>"><?php echo $material_out_fp->godown->caption() ?><?php echo ($material_out_fp->godown->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_fp_add->RightColumnClass ?>"><div<?php echo $material_out_fp->godown->cellAttributes() ?>>
<span id="el_material_out_fp_godown">
<?php
$wrkonchange = "" . trim(@$material_out_fp->godown->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_out_fp->godown->EditAttrs["onchange"] = "";
?>
<span id="as_x_godown" class="text-nowrap" style="z-index: 8880">
	<input type="text" class="form-control" name="sv_x_godown" id="sv_x_godown" value="<?php echo RemoveHtml($material_out_fp->godown->EditValue) ?>" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($material_out_fp->godown->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_out_fp->godown->getPlaceHolder()) ?>"<?php echo $material_out_fp->godown->editAttributes() ?>>
</span>
<input type="hidden" data-table="material_out_fp" data-field="x_godown" data-value-separator="<?php echo $material_out_fp->godown->displayValueSeparatorAttribute() ?>" name="x_godown" id="x_godown" value="<?php echo HtmlEncode($material_out_fp->godown->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_out_fpadd.createAutoSuggest({"id":"x_godown","forceSelect":false});
</script>
<?php echo $material_out_fp->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
<?php echo $material_out_fp->godown->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->quantity_avg_act->Visible) { // quantity_avg_act ?>
	<div id="r_quantity_avg_act" class="form-group row">
		<label id="elh_material_out_fp_quantity_avg_act" class="<?php echo $material_out_fp_add->LeftColumnClass ?>"><?php echo $material_out_fp->quantity_avg_act->caption() ?><?php echo ($material_out_fp->quantity_avg_act->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_fp_add->RightColumnClass ?>"><div<?php echo $material_out_fp->quantity_avg_act->cellAttributes() ?>>
<span id="el_material_out_fp_quantity_avg_act">
<div id="tp_x_quantity_avg_act" class="ew-template"><input type="radio" class="form-check-input" data-table="material_out_fp" data-field="x_quantity_avg_act" data-value-separator="<?php echo $material_out_fp->quantity_avg_act->displayValueSeparatorAttribute() ?>" name="x_quantity_avg_act" id="x_quantity_avg_act" value="{value}"<?php echo $material_out_fp->quantity_avg_act->editAttributes() ?>></div>
<div id="dsl_x_quantity_avg_act" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $material_out_fp->quantity_avg_act->radioButtonListHtml(FALSE, "x_quantity_avg_act") ?>
</div></div>
</span>
<?php echo $material_out_fp->quantity_avg_act->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->max_qty->Visible) { // max_qty ?>
	<div id="r_max_qty" class="form-group row">
		<label id="elh_material_out_fp_max_qty" for="x_max_qty" class="<?php echo $material_out_fp_add->LeftColumnClass ?>"><?php echo $material_out_fp->max_qty->caption() ?><?php echo ($material_out_fp->max_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_fp_add->RightColumnClass ?>"><div<?php echo $material_out_fp->max_qty->cellAttributes() ?>>
<span id="el_material_out_fp_max_qty">
<input type="text" data-table="material_out_fp" data-field="x_max_qty" name="x_max_qty" id="x_max_qty" size="30" placeholder="<?php echo HtmlEncode($material_out_fp->max_qty->getPlaceHolder()) ?>" value="<?php echo $material_out_fp->max_qty->EditValue ?>"<?php echo $material_out_fp->max_qty->editAttributes() ?>>
</span>
<?php echo $material_out_fp->max_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label id="elh_material_out_fp_packets" for="x_packets" class="<?php echo $material_out_fp_add->LeftColumnClass ?>"><?php echo $material_out_fp->packets->caption() ?><?php echo ($material_out_fp->packets->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_fp_add->RightColumnClass ?>"><div<?php echo $material_out_fp->packets->cellAttributes() ?>>
<span id="el_material_out_fp_packets">
<input type="text" data-table="material_out_fp" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($material_out_fp->packets->getPlaceHolder()) ?>" value="<?php echo $material_out_fp->packets->EditValue ?>"<?php echo $material_out_fp->packets->editAttributes() ?>>
</span>
<?php echo $material_out_fp->packets->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_material_out_fp_quantity" for="x_quantity" class="<?php echo $material_out_fp_add->LeftColumnClass ?>"><?php echo $material_out_fp->quantity->caption() ?><?php echo ($material_out_fp->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_fp_add->RightColumnClass ?>"><div<?php echo $material_out_fp->quantity->cellAttributes() ?>>
<span id="el_material_out_fp_quantity">
<input type="text" data-table="material_out_fp" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($material_out_fp->quantity->getPlaceHolder()) ?>" value="<?php echo $material_out_fp->quantity->EditValue ?>"<?php echo $material_out_fp->quantity->editAttributes() ?>>
</span>
<?php echo $material_out_fp->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_material_out_fp_dated" for="x_dated" class="<?php echo $material_out_fp_add->LeftColumnClass ?>"><?php echo $material_out_fp->dated->caption() ?><?php echo ($material_out_fp->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_fp_add->RightColumnClass ?>"><div<?php echo $material_out_fp->dated->cellAttributes() ?>>
<span id="el_material_out_fp_dated">
<input type="text" data-table="material_out_fp" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($material_out_fp->dated->getPlaceHolder()) ?>" value="<?php echo $material_out_fp->dated->EditValue ?>"<?php echo $material_out_fp->dated->editAttributes() ?>>
<?php if (!$material_out_fp->dated->ReadOnly && !$material_out_fp->dated->Disabled && !isset($material_out_fp->dated->EditAttrs["readonly"]) && !isset($material_out_fp->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_out_fpadd", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $material_out_fp->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label id="elh_material_out_fp_process" for="x_process" class="<?php echo $material_out_fp_add->LeftColumnClass ?>"><?php echo $material_out_fp->process->caption() ?><?php echo ($material_out_fp->process->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_fp_add->RightColumnClass ?>"><div<?php echo $material_out_fp->process->cellAttributes() ?>>
<span id="el_material_out_fp_process">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_fp" data-field="x_process" data-value-separator="<?php echo $material_out_fp->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $material_out_fp->process->editAttributes() ?>>
		<?php echo $material_out_fp->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $material_out_fp->process->Lookup->getParamTag("p_x_process") ?>
</span>
<?php echo $material_out_fp->process->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_material_out_fp_remarks" for="x_remarks" class="<?php echo $material_out_fp_add->LeftColumnClass ?>"><?php echo $material_out_fp->remarks->caption() ?><?php echo ($material_out_fp->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_fp_add->RightColumnClass ?>"><div<?php echo $material_out_fp->remarks->cellAttributes() ?>>
<span id="el_material_out_fp_remarks">
<textarea data-table="material_out_fp" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($material_out_fp->remarks->getPlaceHolder()) ?>"<?php echo $material_out_fp->remarks->editAttributes() ?>><?php echo $material_out_fp->remarks->EditValue ?></textarea>
</span>
<?php echo $material_out_fp->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->issue_to_sale->Visible) { // issue_to_sale ?>
	<div id="r_issue_to_sale" class="form-group row">
		<label id="elh_material_out_fp_issue_to_sale" for="x_issue_to_sale" class="<?php echo $material_out_fp_add->LeftColumnClass ?>"><?php echo $material_out_fp->issue_to_sale->caption() ?><?php echo ($material_out_fp->issue_to_sale->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_fp_add->RightColumnClass ?>"><div<?php echo $material_out_fp->issue_to_sale->cellAttributes() ?>>
<span id="el_material_out_fp_issue_to_sale">
<?php $material_out_fp->issue_to_sale->EditAttrs["onchange"] = "ew.autoFill(this);" . @$material_out_fp->issue_to_sale->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_fp" data-field="x_issue_to_sale" data-value-separator="<?php echo $material_out_fp->issue_to_sale->displayValueSeparatorAttribute() ?>" id="x_issue_to_sale" name="x_issue_to_sale"<?php echo $material_out_fp->issue_to_sale->editAttributes() ?>>
		<?php echo $material_out_fp->issue_to_sale->selectOptionListHtml("x_issue_to_sale") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "buyer") && !$material_out_fp->issue_to_sale->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_issue_to_sale" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $material_out_fp->issue_to_sale->caption() ?>" data-title="<?php echo $material_out_fp->issue_to_sale->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_issue_to_sale',url:'buyeraddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $material_out_fp->issue_to_sale->Lookup->getParamTag("p_x_issue_to_sale") ?>
</span>
<?php echo $material_out_fp->issue_to_sale->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->issue_to_godown->Visible) { // issue_to_godown ?>
	<div id="r_issue_to_godown" class="form-group row">
		<label id="elh_material_out_fp_issue_to_godown" for="x_issue_to_godown" class="<?php echo $material_out_fp_add->LeftColumnClass ?>"><?php echo $material_out_fp->issue_to_godown->caption() ?><?php echo ($material_out_fp->issue_to_godown->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_fp_add->RightColumnClass ?>"><div<?php echo $material_out_fp->issue_to_godown->cellAttributes() ?>>
<span id="el_material_out_fp_issue_to_godown">
<?php $material_out_fp->issue_to_godown->EditAttrs["onchange"] = "ew.autoFill(this);" . @$material_out_fp->issue_to_godown->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_fp" data-field="x_issue_to_godown" data-value-separator="<?php echo $material_out_fp->issue_to_godown->displayValueSeparatorAttribute() ?>" id="x_issue_to_godown" name="x_issue_to_godown"<?php echo $material_out_fp->issue_to_godown->editAttributes() ?>>
		<?php echo $material_out_fp->issue_to_godown->selectOptionListHtml("x_issue_to_godown") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "buyer") && !$material_out_fp->issue_to_godown->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_issue_to_godown" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $material_out_fp->issue_to_godown->caption() ?>" data-title="<?php echo $material_out_fp->issue_to_godown->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_issue_to_godown',url:'buyeraddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $material_out_fp->issue_to_godown->Lookup->getParamTag("p_x_issue_to_godown") ?>
</span>
<?php echo $material_out_fp->issue_to_godown->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->issue_to->Visible) { // issue_to ?>
	<div id="r_issue_to" class="form-group row">
		<label id="elh_material_out_fp_issue_to" for="x_issue_to" class="<?php echo $material_out_fp_add->LeftColumnClass ?>"><?php echo $material_out_fp->issue_to->caption() ?><?php echo ($material_out_fp->issue_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_fp_add->RightColumnClass ?>"><div<?php echo $material_out_fp->issue_to->cellAttributes() ?>>
<span id="el_material_out_fp_issue_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_fp" data-field="x_issue_to" data-value-separator="<?php echo $material_out_fp->issue_to->displayValueSeparatorAttribute() ?>" id="x_issue_to" name="x_issue_to"<?php echo $material_out_fp->issue_to->editAttributes() ?>>
		<?php echo $material_out_fp->issue_to->selectOptionListHtml("x_issue_to") ?>
	</select>
</div>
<?php echo $material_out_fp->issue_to->Lookup->getParamTag("p_x_issue_to") ?>
</span>
<?php echo $material_out_fp->issue_to->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label id="elh_material_out_fp_po" for="x_po" class="<?php echo $material_out_fp_add->LeftColumnClass ?>"><?php echo $material_out_fp->po->caption() ?><?php echo ($material_out_fp->po->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_fp_add->RightColumnClass ?>"><div<?php echo $material_out_fp->po->cellAttributes() ?>>
<span id="el_material_out_fp_po">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_fp" data-field="x_po" data-value-separator="<?php echo $material_out_fp->po->displayValueSeparatorAttribute() ?>" id="x_po" name="x_po"<?php echo $material_out_fp->po->editAttributes() ?>>
		<?php echo $material_out_fp->po->selectOptionListHtml("x_po") ?>
	</select>
</div>
<?php echo $material_out_fp->po->Lookup->getParamTag("p_x_po") ?>
</span>
<?php echo $material_out_fp->po->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$material_out_fp_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $material_out_fp_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $material_out_fp_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$material_out_fp_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

	     $("#r_issue_to_sale").addClass('hide');
</script>
<?php include_once "footer.php" ?>
<?php
$material_out_fp_add->terminate();
?>