<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_out_fp_list = new material_out_fp_list();

// Run the page
$material_out_fp_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_out_fp_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$material_out_fp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmaterial_out_fplist = currentForm = new ew.Form("fmaterial_out_fplist", "list");
fmaterial_out_fplist.formKeyCountName = '<?php echo $material_out_fp_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmaterial_out_fplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_out_fplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_out_fplist.lists["x_grp"] = <?php echo $material_out_fp_list->grp->Lookup->toClientList() ?>;
fmaterial_out_fplist.lists["x_grp"].options = <?php echo JsonEncode($material_out_fp_list->grp->options(FALSE, TRUE)) ?>;
fmaterial_out_fplist.lists["x_s_grp"] = <?php echo $material_out_fp_list->s_grp->Lookup->toClientList() ?>;
fmaterial_out_fplist.lists["x_s_grp"].options = <?php echo JsonEncode($material_out_fp_list->s_grp->lookupOptions()) ?>;
fmaterial_out_fplist.lists["x_product"] = <?php echo $material_out_fp_list->product->Lookup->toClientList() ?>;
fmaterial_out_fplist.lists["x_product"].options = <?php echo JsonEncode($material_out_fp_list->product->lookupOptions()) ?>;
fmaterial_out_fplist.lists["x_rid"] = <?php echo $material_out_fp_list->rid->Lookup->toClientList() ?>;
fmaterial_out_fplist.lists["x_rid"].options = <?php echo JsonEncode($material_out_fp_list->rid->lookupOptions()) ?>;
fmaterial_out_fplist.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_fplist.lists["x_godown"] = <?php echo $material_out_fp_list->godown->Lookup->toClientList() ?>;
fmaterial_out_fplist.lists["x_godown"].options = <?php echo JsonEncode($material_out_fp_list->godown->lookupOptions()) ?>;
fmaterial_out_fplist.autoSuggests["x_godown"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_fplist.lists["x_quantity_avg_act"] = <?php echo $material_out_fp_list->quantity_avg_act->Lookup->toClientList() ?>;
fmaterial_out_fplist.lists["x_quantity_avg_act"].options = <?php echo JsonEncode($material_out_fp_list->quantity_avg_act->options(FALSE, TRUE)) ?>;
fmaterial_out_fplist.lists["x_process"] = <?php echo $material_out_fp_list->process->Lookup->toClientList() ?>;
fmaterial_out_fplist.lists["x_process"].options = <?php echo JsonEncode($material_out_fp_list->process->lookupOptions()) ?>;
fmaterial_out_fplist.lists["x_issue_to"] = <?php echo $material_out_fp_list->issue_to->Lookup->toClientList() ?>;
fmaterial_out_fplist.lists["x_issue_to"].options = <?php echo JsonEncode($material_out_fp_list->issue_to->lookupOptions()) ?>;
fmaterial_out_fplist.lists["x_status"] = <?php echo $material_out_fp_list->status->Lookup->toClientList() ?>;
fmaterial_out_fplist.lists["x_status"].options = <?php echo JsonEncode($material_out_fp_list->status->options(FALSE, TRUE)) ?>;
fmaterial_out_fplist.lists["x_operator"] = <?php echo $material_out_fp_list->operator->Lookup->toClientList() ?>;
fmaterial_out_fplist.lists["x_operator"].options = <?php echo JsonEncode($material_out_fp_list->operator->lookupOptions()) ?>;
fmaterial_out_fplist.lists["x_po"] = <?php echo $material_out_fp_list->po->Lookup->toClientList() ?>;
fmaterial_out_fplist.lists["x_po"].options = <?php echo JsonEncode($material_out_fp_list->po->lookupOptions()) ?>;

// Form object for search
var fmaterial_out_fplistsrch = currentSearchForm = new ew.Form("fmaterial_out_fplistsrch");

// Validate function for search
fmaterial_out_fplistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fmaterial_out_fplistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_out_fplistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_out_fplistsrch.lists["x_product"] = <?php echo $material_out_fp_list->product->Lookup->toClientList() ?>;
fmaterial_out_fplistsrch.lists["x_product"].options = <?php echo JsonEncode($material_out_fp_list->product->lookupOptions()) ?>;

// Filters
fmaterial_out_fplistsrch.filterList = <?php echo $material_out_fp_list->getFilterList() ?>;

// Init search panel as collapsed
fmaterial_out_fplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$material_out_fp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($material_out_fp_list->TotalRecs > 0 && $material_out_fp_list->ExportOptions->visible()) { ?>
<?php $material_out_fp_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($material_out_fp_list->ImportOptions->visible()) { ?>
<?php $material_out_fp_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($material_out_fp_list->SearchOptions->visible()) { ?>
<?php $material_out_fp_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($material_out_fp_list->FilterOptions->visible()) { ?>
<?php $material_out_fp_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$material_out_fp_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$material_out_fp->isExport() && !$material_out_fp->CurrentAction) { ?>
<form name="fmaterial_out_fplistsrch" id="fmaterial_out_fplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($material_out_fp_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmaterial_out_fplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="material_out_fp">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$material_out_fp_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$material_out_fp->RowType = ROWTYPE_SEARCH;

// Render row
$material_out_fp->resetAttributes();
$material_out_fp_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($material_out_fp->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label for="x_product" class="ew-search-caption ew-label"><?php echo $material_out_fp->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_fp" data-field="x_product" data-value-separator="<?php echo $material_out_fp->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $material_out_fp->product->editAttributes() ?>>
		<?php echo $material_out_fp->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $material_out_fp->product->Lookup->getParamTag("p_x_product") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($material_out_fp_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($material_out_fp_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $material_out_fp_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($material_out_fp_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($material_out_fp_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($material_out_fp_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($material_out_fp_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $material_out_fp_list->showPageHeader(); ?>
<?php
$material_out_fp_list->showMessage();
?>
<?php if ($material_out_fp_list->TotalRecs > 0 || $material_out_fp->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($material_out_fp_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> material_out_fp">
<?php if (!$material_out_fp->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$material_out_fp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_out_fp_list->Pager)) $material_out_fp_list->Pager = new PrevNextPager($material_out_fp_list->StartRec, $material_out_fp_list->DisplayRecs, $material_out_fp_list->TotalRecs, $material_out_fp_list->AutoHidePager) ?>
<?php if ($material_out_fp_list->Pager->RecordCount > 0 && $material_out_fp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_out_fp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_out_fp_list->pageUrl() ?>start=<?php echo $material_out_fp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_out_fp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_out_fp_list->pageUrl() ?>start=<?php echo $material_out_fp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_out_fp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_out_fp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_out_fp_list->pageUrl() ?>start=<?php echo $material_out_fp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_out_fp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_out_fp_list->pageUrl() ?>start=<?php echo $material_out_fp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_out_fp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_out_fp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_out_fp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_out_fp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_out_fp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_out_fp_list->TotalRecs > 0 && (!$material_out_fp_list->AutoHidePageSizeSelector || $material_out_fp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_out_fp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_out_fp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_out_fp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_out_fp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_out_fp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_out_fp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_out_fp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_out_fp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmaterial_out_fplist" id="fmaterial_out_fplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_out_fp_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_out_fp_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_out_fp">
<div id="gmp_material_out_fp" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($material_out_fp_list->TotalRecs > 0 || $material_out_fp->isGridEdit()) { ?>
<table id="tbl_material_out_fplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$material_out_fp_list->RowType = ROWTYPE_HEADER;

// Render list options
$material_out_fp_list->renderListOptions();

// Render list options (header, left)
$material_out_fp_list->ListOptions->render("header", "left");
?>
<?php if ($material_out_fp->id->Visible) { // id ?>
	<?php if ($material_out_fp->sortUrl($material_out_fp->id) == "") { ?>
		<th data-name="id" class="<?php echo $material_out_fp->id->headerCellClass() ?>"><div id="elh_material_out_fp_id" class="material_out_fp_id"><div class="ew-table-header-caption"><?php echo $material_out_fp->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $material_out_fp->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_fp->SortUrl($material_out_fp->id) ?>',2);"><div id="elh_material_out_fp_id" class="material_out_fp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_fp->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_fp->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_fp->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_fp->grp->Visible) { // grp ?>
	<?php if ($material_out_fp->sortUrl($material_out_fp->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $material_out_fp->grp->headerCellClass() ?>"><div id="elh_material_out_fp_grp" class="material_out_fp_grp"><div class="ew-table-header-caption"><?php echo $material_out_fp->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $material_out_fp->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_fp->SortUrl($material_out_fp->grp) ?>',2);"><div id="elh_material_out_fp_grp" class="material_out_fp_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_fp->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_fp->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_fp->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_fp->s_grp->Visible) { // s_grp ?>
	<?php if ($material_out_fp->sortUrl($material_out_fp->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $material_out_fp->s_grp->headerCellClass() ?>"><div id="elh_material_out_fp_s_grp" class="material_out_fp_s_grp"><div class="ew-table-header-caption"><?php echo $material_out_fp->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $material_out_fp->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_fp->SortUrl($material_out_fp->s_grp) ?>',2);"><div id="elh_material_out_fp_s_grp" class="material_out_fp_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_fp->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_fp->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_fp->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_fp->product->Visible) { // product ?>
	<?php if ($material_out_fp->sortUrl($material_out_fp->product) == "") { ?>
		<th data-name="product" class="<?php echo $material_out_fp->product->headerCellClass() ?>"><div id="elh_material_out_fp_product" class="material_out_fp_product"><div class="ew-table-header-caption"><?php echo $material_out_fp->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $material_out_fp->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_fp->SortUrl($material_out_fp->product) ?>',2);"><div id="elh_material_out_fp_product" class="material_out_fp_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_fp->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_fp->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_fp->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_fp->rid->Visible) { // rid ?>
	<?php if ($material_out_fp->sortUrl($material_out_fp->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $material_out_fp->rid->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_material_out_fp_rid" class="material_out_fp_rid"><div class="ew-table-header-caption"><?php echo $material_out_fp->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $material_out_fp->rid->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_fp->SortUrl($material_out_fp->rid) ?>',2);"><div id="elh_material_out_fp_rid" class="material_out_fp_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_fp->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_fp->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_fp->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_fp->lot_no->Visible) { // lot_no ?>
	<?php if ($material_out_fp->sortUrl($material_out_fp->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $material_out_fp->lot_no->headerCellClass() ?>"><div id="elh_material_out_fp_lot_no" class="material_out_fp_lot_no"><div class="ew-table-header-caption"><?php echo $material_out_fp->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $material_out_fp->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_fp->SortUrl($material_out_fp->lot_no) ?>',2);"><div id="elh_material_out_fp_lot_no" class="material_out_fp_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_fp->lot_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out_fp->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_fp->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_fp->tmp_lot->Visible) { // tmp_lot ?>
	<?php if ($material_out_fp->sortUrl($material_out_fp->tmp_lot) == "") { ?>
		<th data-name="tmp_lot" class="<?php echo $material_out_fp->tmp_lot->headerCellClass() ?>"><div id="elh_material_out_fp_tmp_lot" class="material_out_fp_tmp_lot"><div class="ew-table-header-caption"><?php echo $material_out_fp->tmp_lot->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tmp_lot" class="<?php echo $material_out_fp->tmp_lot->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_fp->SortUrl($material_out_fp->tmp_lot) ?>',2);"><div id="elh_material_out_fp_tmp_lot" class="material_out_fp_tmp_lot">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_fp->tmp_lot->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_fp->tmp_lot->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_fp->tmp_lot->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_fp->godown->Visible) { // godown ?>
	<?php if ($material_out_fp->sortUrl($material_out_fp->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $material_out_fp->godown->headerCellClass() ?>"><div id="elh_material_out_fp_godown" class="material_out_fp_godown"><div class="ew-table-header-caption"><?php echo $material_out_fp->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $material_out_fp->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_fp->SortUrl($material_out_fp->godown) ?>',2);"><div id="elh_material_out_fp_godown" class="material_out_fp_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_fp->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_fp->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_fp->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_fp->quantity_avg_act->Visible) { // quantity_avg_act ?>
	<?php if ($material_out_fp->sortUrl($material_out_fp->quantity_avg_act) == "") { ?>
		<th data-name="quantity_avg_act" class="<?php echo $material_out_fp->quantity_avg_act->headerCellClass() ?>"><div id="elh_material_out_fp_quantity_avg_act" class="material_out_fp_quantity_avg_act"><div class="ew-table-header-caption"><?php echo $material_out_fp->quantity_avg_act->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity_avg_act" class="<?php echo $material_out_fp->quantity_avg_act->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_fp->SortUrl($material_out_fp->quantity_avg_act) ?>',2);"><div id="elh_material_out_fp_quantity_avg_act" class="material_out_fp_quantity_avg_act">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_fp->quantity_avg_act->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_fp->quantity_avg_act->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_fp->quantity_avg_act->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_fp->max_qty->Visible) { // max_qty ?>
	<?php if ($material_out_fp->sortUrl($material_out_fp->max_qty) == "") { ?>
		<th data-name="max_qty" class="<?php echo $material_out_fp->max_qty->headerCellClass() ?>"><div id="elh_material_out_fp_max_qty" class="material_out_fp_max_qty"><div class="ew-table-header-caption"><?php echo $material_out_fp->max_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="max_qty" class="<?php echo $material_out_fp->max_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_fp->SortUrl($material_out_fp->max_qty) ?>',2);"><div id="elh_material_out_fp_max_qty" class="material_out_fp_max_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_fp->max_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_fp->max_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_fp->max_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_fp->packets->Visible) { // packets ?>
	<?php if ($material_out_fp->sortUrl($material_out_fp->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $material_out_fp->packets->headerCellClass() ?>"><div id="elh_material_out_fp_packets" class="material_out_fp_packets"><div class="ew-table-header-caption"><?php echo $material_out_fp->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $material_out_fp->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_fp->SortUrl($material_out_fp->packets) ?>',2);"><div id="elh_material_out_fp_packets" class="material_out_fp_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_fp->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_fp->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_fp->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_fp->quantity->Visible) { // quantity ?>
	<?php if ($material_out_fp->sortUrl($material_out_fp->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $material_out_fp->quantity->headerCellClass() ?>"><div id="elh_material_out_fp_quantity" class="material_out_fp_quantity"><div class="ew-table-header-caption"><?php echo $material_out_fp->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $material_out_fp->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_fp->SortUrl($material_out_fp->quantity) ?>',2);"><div id="elh_material_out_fp_quantity" class="material_out_fp_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_fp->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_fp->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_fp->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_fp->dated->Visible) { // dated ?>
	<?php if ($material_out_fp->sortUrl($material_out_fp->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $material_out_fp->dated->headerCellClass() ?>"><div id="elh_material_out_fp_dated" class="material_out_fp_dated"><div class="ew-table-header-caption"><?php echo $material_out_fp->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $material_out_fp->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_fp->SortUrl($material_out_fp->dated) ?>',2);"><div id="elh_material_out_fp_dated" class="material_out_fp_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_fp->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_fp->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_fp->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_fp->process->Visible) { // process ?>
	<?php if ($material_out_fp->sortUrl($material_out_fp->process) == "") { ?>
		<th data-name="process" class="<?php echo $material_out_fp->process->headerCellClass() ?>"><div id="elh_material_out_fp_process" class="material_out_fp_process"><div class="ew-table-header-caption"><?php echo $material_out_fp->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $material_out_fp->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_fp->SortUrl($material_out_fp->process) ?>',2);"><div id="elh_material_out_fp_process" class="material_out_fp_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_fp->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_fp->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_fp->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_fp->remarks->Visible) { // remarks ?>
	<?php if ($material_out_fp->sortUrl($material_out_fp->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $material_out_fp->remarks->headerCellClass() ?>"><div id="elh_material_out_fp_remarks" class="material_out_fp_remarks"><div class="ew-table-header-caption"><?php echo $material_out_fp->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $material_out_fp->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_fp->SortUrl($material_out_fp->remarks) ?>',2);"><div id="elh_material_out_fp_remarks" class="material_out_fp_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_fp->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out_fp->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_fp->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_fp->issue_to->Visible) { // issue_to ?>
	<?php if ($material_out_fp->sortUrl($material_out_fp->issue_to) == "") { ?>
		<th data-name="issue_to" class="<?php echo $material_out_fp->issue_to->headerCellClass() ?>"><div id="elh_material_out_fp_issue_to" class="material_out_fp_issue_to"><div class="ew-table-header-caption"><?php echo $material_out_fp->issue_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issue_to" class="<?php echo $material_out_fp->issue_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_fp->SortUrl($material_out_fp->issue_to) ?>',2);"><div id="elh_material_out_fp_issue_to" class="material_out_fp_issue_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_fp->issue_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_fp->issue_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_fp->issue_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_fp->status->Visible) { // status ?>
	<?php if ($material_out_fp->sortUrl($material_out_fp->status) == "") { ?>
		<th data-name="status" class="<?php echo $material_out_fp->status->headerCellClass() ?>"><div id="elh_material_out_fp_status" class="material_out_fp_status"><div class="ew-table-header-caption"><?php echo $material_out_fp->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $material_out_fp->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_fp->SortUrl($material_out_fp->status) ?>',2);"><div id="elh_material_out_fp_status" class="material_out_fp_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_fp->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_fp->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_fp->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_fp->operator->Visible) { // operator ?>
	<?php if ($material_out_fp->sortUrl($material_out_fp->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $material_out_fp->operator->headerCellClass() ?>"><div id="elh_material_out_fp_operator" class="material_out_fp_operator"><div class="ew-table-header-caption"><?php echo $material_out_fp->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $material_out_fp->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_fp->SortUrl($material_out_fp->operator) ?>',2);"><div id="elh_material_out_fp_operator" class="material_out_fp_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_fp->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_fp->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_fp->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_fp->datetime->Visible) { // datetime ?>
	<?php if ($material_out_fp->sortUrl($material_out_fp->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $material_out_fp->datetime->headerCellClass() ?>"><div id="elh_material_out_fp_datetime" class="material_out_fp_datetime"><div class="ew-table-header-caption"><?php echo $material_out_fp->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $material_out_fp->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_fp->SortUrl($material_out_fp->datetime) ?>',2);"><div id="elh_material_out_fp_datetime" class="material_out_fp_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_fp->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_fp->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_fp->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_fp->po->Visible) { // po ?>
	<?php if ($material_out_fp->sortUrl($material_out_fp->po) == "") { ?>
		<th data-name="po" class="<?php echo $material_out_fp->po->headerCellClass() ?>"><div id="elh_material_out_fp_po" class="material_out_fp_po"><div class="ew-table-header-caption"><?php echo $material_out_fp->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $material_out_fp->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_fp->SortUrl($material_out_fp->po) ?>',2);"><div id="elh_material_out_fp_po" class="material_out_fp_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_fp->po->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_fp->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_fp->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$material_out_fp_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($material_out_fp->ExportAll && $material_out_fp->isExport()) {
	$material_out_fp_list->StopRec = $material_out_fp_list->TotalRecs;
} else {

	// Set the last record to display
	if ($material_out_fp_list->TotalRecs > $material_out_fp_list->StartRec + $material_out_fp_list->DisplayRecs - 1)
		$material_out_fp_list->StopRec = $material_out_fp_list->StartRec + $material_out_fp_list->DisplayRecs - 1;
	else
		$material_out_fp_list->StopRec = $material_out_fp_list->TotalRecs;
}
$material_out_fp_list->RecCnt = $material_out_fp_list->StartRec - 1;
if ($material_out_fp_list->Recordset && !$material_out_fp_list->Recordset->EOF) {
	$material_out_fp_list->Recordset->moveFirst();
	$selectLimit = $material_out_fp_list->UseSelectLimit;
	if (!$selectLimit && $material_out_fp_list->StartRec > 1)
		$material_out_fp_list->Recordset->move($material_out_fp_list->StartRec - 1);
} elseif (!$material_out_fp->AllowAddDeleteRow && $material_out_fp_list->StopRec == 0) {
	$material_out_fp_list->StopRec = $material_out_fp->GridAddRowCount;
}

// Initialize aggregate
$material_out_fp->RowType = ROWTYPE_AGGREGATEINIT;
$material_out_fp->resetAttributes();
$material_out_fp_list->renderRow();
while ($material_out_fp_list->RecCnt < $material_out_fp_list->StopRec) {
	$material_out_fp_list->RecCnt++;
	if ($material_out_fp_list->RecCnt >= $material_out_fp_list->StartRec) {
		$material_out_fp_list->RowCnt++;

		// Set up key count
		$material_out_fp_list->KeyCount = $material_out_fp_list->RowIndex;

		// Init row class and style
		$material_out_fp->resetAttributes();
		$material_out_fp->CssClass = "";
		if ($material_out_fp->isGridAdd()) {
		} else {
			$material_out_fp_list->loadRowValues($material_out_fp_list->Recordset); // Load row values
		}
		$material_out_fp->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$material_out_fp->RowAttrs = array_merge($material_out_fp->RowAttrs, array('data-rowindex'=>$material_out_fp_list->RowCnt, 'id'=>'r' . $material_out_fp_list->RowCnt . '_material_out_fp', 'data-rowtype'=>$material_out_fp->RowType));

		// Render row
		$material_out_fp_list->renderRow();

		// Render list options
		$material_out_fp_list->renderListOptions();
?>
	<tr<?php echo $material_out_fp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$material_out_fp_list->ListOptions->render("body", "left", $material_out_fp_list->RowCnt);
?>
	<?php if ($material_out_fp->id->Visible) { // id ?>
		<td data-name="id"<?php echo $material_out_fp->id->cellAttributes() ?>>
<span id="el<?php echo $material_out_fp_list->RowCnt ?>_material_out_fp_id" class="material_out_fp_id">
<span<?php echo $material_out_fp->id->viewAttributes() ?>>
<?php echo $material_out_fp->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_fp->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $material_out_fp->grp->cellAttributes() ?>>
<span id="el<?php echo $material_out_fp_list->RowCnt ?>_material_out_fp_grp" class="material_out_fp_grp">
<span<?php echo $material_out_fp->grp->viewAttributes() ?>>
<?php echo $material_out_fp->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_fp->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $material_out_fp->s_grp->cellAttributes() ?>>
<span id="el<?php echo $material_out_fp_list->RowCnt ?>_material_out_fp_s_grp" class="material_out_fp_s_grp">
<span<?php echo $material_out_fp->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_fp->s_grp->getViewValue())) && $material_out_fp->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $material_out_fp->s_grp->linkAttributes() ?>><?php echo $material_out_fp->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_fp->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_fp->product->Visible) { // product ?>
		<td data-name="product"<?php echo $material_out_fp->product->cellAttributes() ?>>
<span id="el<?php echo $material_out_fp_list->RowCnt ?>_material_out_fp_product" class="material_out_fp_product">
<span<?php echo $material_out_fp->product->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_fp->product->getViewValue())) && $material_out_fp->product->linkAttributes() <> "") { ?>
<a<?php echo $material_out_fp->product->linkAttributes() ?>><?php echo $material_out_fp->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_fp->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_fp->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $material_out_fp->rid->cellAttributes() ?>>
<span id="el<?php echo $material_out_fp_list->RowCnt ?>_material_out_fp_rid" class="material_out_fp_rid">
<span<?php echo $material_out_fp->rid->viewAttributes() ?>>
<?php echo $material_out_fp->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_fp->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $material_out_fp->lot_no->cellAttributes() ?>>
<span id="el<?php echo $material_out_fp_list->RowCnt ?>_material_out_fp_lot_no" class="material_out_fp_lot_no">
<span<?php echo $material_out_fp->lot_no->viewAttributes() ?>>
<?php echo $material_out_fp->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_fp->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot"<?php echo $material_out_fp->tmp_lot->cellAttributes() ?>>
<span id="el<?php echo $material_out_fp_list->RowCnt ?>_material_out_fp_tmp_lot" class="material_out_fp_tmp_lot">
<span<?php echo $material_out_fp->tmp_lot->viewAttributes() ?>>
<?php echo $material_out_fp->tmp_lot->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_fp->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $material_out_fp->godown->cellAttributes() ?>>
<span id="el<?php echo $material_out_fp_list->RowCnt ?>_material_out_fp_godown" class="material_out_fp_godown">
<span<?php echo $material_out_fp->godown->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_fp->godown->getViewValue())) && $material_out_fp->godown->linkAttributes() <> "") { ?>
<a<?php echo $material_out_fp->godown->linkAttributes() ?>><?php echo $material_out_fp->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_fp->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_fp->quantity_avg_act->Visible) { // quantity_avg_act ?>
		<td data-name="quantity_avg_act"<?php echo $material_out_fp->quantity_avg_act->cellAttributes() ?>>
<span id="el<?php echo $material_out_fp_list->RowCnt ?>_material_out_fp_quantity_avg_act" class="material_out_fp_quantity_avg_act">
<span<?php echo $material_out_fp->quantity_avg_act->viewAttributes() ?>>
<?php echo $material_out_fp->quantity_avg_act->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_fp->max_qty->Visible) { // max_qty ?>
		<td data-name="max_qty"<?php echo $material_out_fp->max_qty->cellAttributes() ?>>
<span id="el<?php echo $material_out_fp_list->RowCnt ?>_material_out_fp_max_qty" class="material_out_fp_max_qty">
<span<?php echo $material_out_fp->max_qty->viewAttributes() ?>>
<?php echo $material_out_fp->max_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_fp->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $material_out_fp->packets->cellAttributes() ?>>
<span id="el<?php echo $material_out_fp_list->RowCnt ?>_material_out_fp_packets" class="material_out_fp_packets">
<span<?php echo $material_out_fp->packets->viewAttributes() ?>>
<?php echo $material_out_fp->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_fp->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $material_out_fp->quantity->cellAttributes() ?>>
<span id="el<?php echo $material_out_fp_list->RowCnt ?>_material_out_fp_quantity" class="material_out_fp_quantity">
<span<?php echo $material_out_fp->quantity->viewAttributes() ?>>
<?php echo $material_out_fp->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_fp->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $material_out_fp->dated->cellAttributes() ?>>
<span id="el<?php echo $material_out_fp_list->RowCnt ?>_material_out_fp_dated" class="material_out_fp_dated">
<span<?php echo $material_out_fp->dated->viewAttributes() ?>>
<?php echo $material_out_fp->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_fp->process->Visible) { // process ?>
		<td data-name="process"<?php echo $material_out_fp->process->cellAttributes() ?>>
<span id="el<?php echo $material_out_fp_list->RowCnt ?>_material_out_fp_process" class="material_out_fp_process">
<span<?php echo $material_out_fp->process->viewAttributes() ?>>
<?php echo $material_out_fp->process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_fp->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $material_out_fp->remarks->cellAttributes() ?>>
<span id="el<?php echo $material_out_fp_list->RowCnt ?>_material_out_fp_remarks" class="material_out_fp_remarks">
<span<?php echo $material_out_fp->remarks->viewAttributes() ?>>
<?php echo $material_out_fp->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_fp->issue_to->Visible) { // issue_to ?>
		<td data-name="issue_to"<?php echo $material_out_fp->issue_to->cellAttributes() ?>>
<span id="el<?php echo $material_out_fp_list->RowCnt ?>_material_out_fp_issue_to" class="material_out_fp_issue_to">
<span<?php echo $material_out_fp->issue_to->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_fp->issue_to->getViewValue())) && $material_out_fp->issue_to->linkAttributes() <> "") { ?>
<a<?php echo $material_out_fp->issue_to->linkAttributes() ?>><?php echo $material_out_fp->issue_to->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_fp->issue_to->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_fp->status->Visible) { // status ?>
		<td data-name="status"<?php echo $material_out_fp->status->cellAttributes() ?>>
<span id="el<?php echo $material_out_fp_list->RowCnt ?>_material_out_fp_status" class="material_out_fp_status">
<span<?php echo $material_out_fp->status->viewAttributes() ?>>
<?php echo $material_out_fp->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_fp->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $material_out_fp->operator->cellAttributes() ?>>
<span id="el<?php echo $material_out_fp_list->RowCnt ?>_material_out_fp_operator" class="material_out_fp_operator">
<span<?php echo $material_out_fp->operator->viewAttributes() ?>>
<?php echo $material_out_fp->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_fp->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $material_out_fp->datetime->cellAttributes() ?>>
<span id="el<?php echo $material_out_fp_list->RowCnt ?>_material_out_fp_datetime" class="material_out_fp_datetime">
<span<?php echo $material_out_fp->datetime->viewAttributes() ?>>
<?php echo $material_out_fp->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_fp->po->Visible) { // po ?>
		<td data-name="po"<?php echo $material_out_fp->po->cellAttributes() ?>>
<span id="el<?php echo $material_out_fp_list->RowCnt ?>_material_out_fp_po" class="material_out_fp_po">
<span<?php echo $material_out_fp->po->viewAttributes() ?>>
<?php echo $material_out_fp->po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$material_out_fp_list->ListOptions->render("body", "right", $material_out_fp_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$material_out_fp->isGridAdd())
		$material_out_fp_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$material_out_fp->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($material_out_fp_list->Recordset)
	$material_out_fp_list->Recordset->Close();
?>
<?php if (!$material_out_fp->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$material_out_fp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_out_fp_list->Pager)) $material_out_fp_list->Pager = new PrevNextPager($material_out_fp_list->StartRec, $material_out_fp_list->DisplayRecs, $material_out_fp_list->TotalRecs, $material_out_fp_list->AutoHidePager) ?>
<?php if ($material_out_fp_list->Pager->RecordCount > 0 && $material_out_fp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_out_fp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_out_fp_list->pageUrl() ?>start=<?php echo $material_out_fp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_out_fp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_out_fp_list->pageUrl() ?>start=<?php echo $material_out_fp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_out_fp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_out_fp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_out_fp_list->pageUrl() ?>start=<?php echo $material_out_fp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_out_fp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_out_fp_list->pageUrl() ?>start=<?php echo $material_out_fp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_out_fp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_out_fp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_out_fp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_out_fp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_out_fp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_out_fp_list->TotalRecs > 0 && (!$material_out_fp_list->AutoHidePageSizeSelector || $material_out_fp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_out_fp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_out_fp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_out_fp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_out_fp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_out_fp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_out_fp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_out_fp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_out_fp_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($material_out_fp_list->TotalRecs == 0 && !$material_out_fp->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $material_out_fp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$material_out_fp_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$material_out_fp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$material_out_fp->isExport()) { ?>
<script>
ew.scrollableTable("gmp_material_out_fp", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$material_out_fp_list->terminate();
?>