<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_out_fp_search = new material_out_fp_search();

// Run the page
$material_out_fp_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_out_fp_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($material_out_fp_search->IsModal) { ?>
var fmaterial_out_fpsearch = currentAdvancedSearchForm = new ew.Form("fmaterial_out_fpsearch", "search");
<?php } else { ?>
var fmaterial_out_fpsearch = currentForm = new ew.Form("fmaterial_out_fpsearch", "search");
<?php } ?>

// Form_CustomValidate event
fmaterial_out_fpsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_out_fpsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_out_fpsearch.lists["x_grp"] = <?php echo $material_out_fp_search->grp->Lookup->toClientList() ?>;
fmaterial_out_fpsearch.lists["x_grp"].options = <?php echo JsonEncode($material_out_fp_search->grp->options(FALSE, TRUE)) ?>;
fmaterial_out_fpsearch.lists["x_s_grp"] = <?php echo $material_out_fp_search->s_grp->Lookup->toClientList() ?>;
fmaterial_out_fpsearch.lists["x_s_grp"].options = <?php echo JsonEncode($material_out_fp_search->s_grp->lookupOptions()) ?>;
fmaterial_out_fpsearch.lists["x_product"] = <?php echo $material_out_fp_search->product->Lookup->toClientList() ?>;
fmaterial_out_fpsearch.lists["x_product"].options = <?php echo JsonEncode($material_out_fp_search->product->lookupOptions()) ?>;
fmaterial_out_fpsearch.lists["x_rid"] = <?php echo $material_out_fp_search->rid->Lookup->toClientList() ?>;
fmaterial_out_fpsearch.lists["x_rid"].options = <?php echo JsonEncode($material_out_fp_search->rid->lookupOptions()) ?>;
fmaterial_out_fpsearch.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_fpsearch.lists["x_packing_type"] = <?php echo $material_out_fp_search->packing_type->Lookup->toClientList() ?>;
fmaterial_out_fpsearch.lists["x_packing_type"].options = <?php echo JsonEncode($material_out_fp_search->packing_type->lookupOptions()) ?>;
fmaterial_out_fpsearch.autoSuggests["x_packing_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_fpsearch.lists["x_godown"] = <?php echo $material_out_fp_search->godown->Lookup->toClientList() ?>;
fmaterial_out_fpsearch.lists["x_godown"].options = <?php echo JsonEncode($material_out_fp_search->godown->lookupOptions()) ?>;
fmaterial_out_fpsearch.autoSuggests["x_godown"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_fpsearch.lists["x_quantity_avg_act"] = <?php echo $material_out_fp_search->quantity_avg_act->Lookup->toClientList() ?>;
fmaterial_out_fpsearch.lists["x_quantity_avg_act"].options = <?php echo JsonEncode($material_out_fp_search->quantity_avg_act->options(FALSE, TRUE)) ?>;
fmaterial_out_fpsearch.lists["x_process"] = <?php echo $material_out_fp_search->process->Lookup->toClientList() ?>;
fmaterial_out_fpsearch.lists["x_process"].options = <?php echo JsonEncode($material_out_fp_search->process->lookupOptions()) ?>;
fmaterial_out_fpsearch.lists["x_issue_to_sale"] = <?php echo $material_out_fp_search->issue_to_sale->Lookup->toClientList() ?>;
fmaterial_out_fpsearch.lists["x_issue_to_sale"].options = <?php echo JsonEncode($material_out_fp_search->issue_to_sale->lookupOptions()) ?>;
fmaterial_out_fpsearch.lists["x_issue_to_godown"] = <?php echo $material_out_fp_search->issue_to_godown->Lookup->toClientList() ?>;
fmaterial_out_fpsearch.lists["x_issue_to_godown"].options = <?php echo JsonEncode($material_out_fp_search->issue_to_godown->lookupOptions()) ?>;
fmaterial_out_fpsearch.lists["x_issue_to"] = <?php echo $material_out_fp_search->issue_to->Lookup->toClientList() ?>;
fmaterial_out_fpsearch.lists["x_issue_to"].options = <?php echo JsonEncode($material_out_fp_search->issue_to->lookupOptions()) ?>;
fmaterial_out_fpsearch.lists["x_status"] = <?php echo $material_out_fp_search->status->Lookup->toClientList() ?>;
fmaterial_out_fpsearch.lists["x_status"].options = <?php echo JsonEncode($material_out_fp_search->status->options(FALSE, TRUE)) ?>;
fmaterial_out_fpsearch.lists["x_operator"] = <?php echo $material_out_fp_search->operator->Lookup->toClientList() ?>;
fmaterial_out_fpsearch.lists["x_operator"].options = <?php echo JsonEncode($material_out_fp_search->operator->lookupOptions()) ?>;
fmaterial_out_fpsearch.lists["x_po"] = <?php echo $material_out_fp_search->po->Lookup->toClientList() ?>;
fmaterial_out_fpsearch.lists["x_po"].options = <?php echo JsonEncode($material_out_fp_search->po->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fmaterial_out_fpsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_fp->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_gp_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_fp->gp_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_rid1");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_fp->rid1->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_rid");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_fp->rid->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_tmp_lot");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_fp->tmp_lot->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packing_type");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_fp->packing_type->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_godown");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_fp->godown->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_max_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_fp->max_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packets");
	if (elm && !ew.checkRange(elm.value, 0.001, 10000))
		return this.onError(elm, "<?php echo JsEncode($material_out_fp->packets->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_fp->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_fp->dated->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $material_out_fp_search->showPageHeader(); ?>
<?php
$material_out_fp_search->showMessage();
?>
<form name="fmaterial_out_fpsearch" id="fmaterial_out_fpsearch" class="<?php echo $material_out_fp_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_out_fp_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_out_fp_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_out_fp">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$material_out_fp_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($material_out_fp->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $material_out_fp_search->LeftColumnClass ?>"><span id="elh_material_out_fp_id"><?php echo $material_out_fp->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $material_out_fp_search->RightColumnClass ?>"><div<?php echo $material_out_fp->id->cellAttributes() ?>>
			<span id="el_material_out_fp_id">
<input type="text" data-table="material_out_fp" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($material_out_fp->id->getPlaceHolder()) ?>" value="<?php echo $material_out_fp->id->EditValue ?>"<?php echo $material_out_fp->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->gp_no->Visible) { // gp_no ?>
	<div id="r_gp_no" class="form-group row">
		<label for="x_gp_no" class="<?php echo $material_out_fp_search->LeftColumnClass ?>"><span id="elh_material_out_fp_gp_no"><?php echo $material_out_fp->gp_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_gp_no" id="z_gp_no" value="="></span>
		</label>
		<div class="<?php echo $material_out_fp_search->RightColumnClass ?>"><div<?php echo $material_out_fp->gp_no->cellAttributes() ?>>
			<span id="el_material_out_fp_gp_no">
<input type="text" data-table="material_out_fp" data-field="x_gp_no" name="x_gp_no" id="x_gp_no" size="30" placeholder="<?php echo HtmlEncode($material_out_fp->gp_no->getPlaceHolder()) ?>" value="<?php echo $material_out_fp->gp_no->EditValue ?>"<?php echo $material_out_fp->gp_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $material_out_fp_search->LeftColumnClass ?>"><span id="elh_material_out_fp_grp"><?php echo $material_out_fp->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $material_out_fp_search->RightColumnClass ?>"><div<?php echo $material_out_fp->grp->cellAttributes() ?>>
			<span id="el_material_out_fp_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_fp" data-field="x_grp" data-value-separator="<?php echo $material_out_fp->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $material_out_fp->grp->editAttributes() ?>>
		<?php echo $material_out_fp->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $material_out_fp_search->LeftColumnClass ?>"><span id="elh_material_out_fp_s_grp"><?php echo $material_out_fp->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $material_out_fp_search->RightColumnClass ?>"><div<?php echo $material_out_fp->s_grp->cellAttributes() ?>>
			<span id="el_material_out_fp_s_grp">
<?php $material_out_fp->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_out_fp->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_fp" data-field="x_s_grp" data-value-separator="<?php echo $material_out_fp->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $material_out_fp->s_grp->editAttributes() ?>>
		<?php echo $material_out_fp->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $material_out_fp->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $material_out_fp_search->LeftColumnClass ?>"><span id="elh_material_out_fp_product"><?php echo $material_out_fp->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $material_out_fp_search->RightColumnClass ?>"><div<?php echo $material_out_fp->product->cellAttributes() ?>>
			<span id="el_material_out_fp_product">
<?php $material_out_fp->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_out_fp->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_fp" data-field="x_product" data-value-separator="<?php echo $material_out_fp->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $material_out_fp->product->editAttributes() ?>>
		<?php echo $material_out_fp->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $material_out_fp->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->rid1->Visible) { // rid1 ?>
	<div id="r_rid1" class="form-group row">
		<label for="x_rid1" class="<?php echo $material_out_fp_search->LeftColumnClass ?>"><span id="elh_material_out_fp_rid1"><?php echo $material_out_fp->rid1->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid1" id="z_rid1" value="="></span>
		</label>
		<div class="<?php echo $material_out_fp_search->RightColumnClass ?>"><div<?php echo $material_out_fp->rid1->cellAttributes() ?>>
			<span id="el_material_out_fp_rid1">
<input type="text" data-table="material_out_fp" data-field="x_rid1" name="x_rid1" id="x_rid1" size="30" placeholder="<?php echo HtmlEncode($material_out_fp->rid1->getPlaceHolder()) ?>" value="<?php echo $material_out_fp->rid1->EditValue ?>"<?php echo $material_out_fp->rid1->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label class="<?php echo $material_out_fp_search->LeftColumnClass ?>"><span id="elh_material_out_fp_rid"><?php echo $material_out_fp->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $material_out_fp_search->RightColumnClass ?>"><div<?php echo $material_out_fp->rid->cellAttributes() ?>>
			<span id="el_material_out_fp_rid">
<?php
$wrkonchange = "" . trim(@$material_out_fp->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_out_fp->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid" class="text-nowrap" style="z-index: 8920">
	<input type="text" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?php echo RemoveHtml($material_out_fp->rid->EditValue) ?>" size="40" placeholder="<?php echo HtmlEncode($material_out_fp->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_out_fp->rid->getPlaceHolder()) ?>"<?php echo $material_out_fp->rid->editAttributes() ?>>
</span>
<input type="hidden" data-table="material_out_fp" data-field="x_rid" data-value-separator="<?php echo $material_out_fp->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($material_out_fp->rid->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_out_fpsearch.createAutoSuggest({"id":"x_rid","forceSelect":false});
</script>
<?php echo $material_out_fp->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label for="x_lot_no" class="<?php echo $material_out_fp_search->LeftColumnClass ?>"><span id="elh_material_out_fp_lot_no"><?php echo $material_out_fp->lot_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_lot_no" id="z_lot_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $material_out_fp_search->RightColumnClass ?>"><div<?php echo $material_out_fp->lot_no->cellAttributes() ?>>
			<span id="el_material_out_fp_lot_no">
<input type="text" data-table="material_out_fp" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($material_out_fp->lot_no->getPlaceHolder()) ?>" value="<?php echo $material_out_fp->lot_no->EditValue ?>"<?php echo $material_out_fp->lot_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->tmp_lot->Visible) { // tmp_lot ?>
	<div id="r_tmp_lot" class="form-group row">
		<label for="x_tmp_lot" class="<?php echo $material_out_fp_search->LeftColumnClass ?>"><span id="elh_material_out_fp_tmp_lot"><?php echo $material_out_fp->tmp_lot->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_tmp_lot" id="z_tmp_lot" value="="></span>
		</label>
		<div class="<?php echo $material_out_fp_search->RightColumnClass ?>"><div<?php echo $material_out_fp->tmp_lot->cellAttributes() ?>>
			<span id="el_material_out_fp_tmp_lot">
<input type="text" data-table="material_out_fp" data-field="x_tmp_lot" name="x_tmp_lot" id="x_tmp_lot" size="30" placeholder="<?php echo HtmlEncode($material_out_fp->tmp_lot->getPlaceHolder()) ?>" value="<?php echo $material_out_fp->tmp_lot->EditValue ?>"<?php echo $material_out_fp->tmp_lot->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label class="<?php echo $material_out_fp_search->LeftColumnClass ?>"><span id="elh_material_out_fp_packing_type"><?php echo $material_out_fp->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $material_out_fp_search->RightColumnClass ?>"><div<?php echo $material_out_fp->packing_type->cellAttributes() ?>>
			<span id="el_material_out_fp_packing_type">
<?php
$wrkonchange = "" . trim(@$material_out_fp->packing_type->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_out_fp->packing_type->EditAttrs["onchange"] = "";
?>
<span id="as_x_packing_type" class="text-nowrap" style="z-index: 8890">
	<input type="text" class="form-control" name="sv_x_packing_type" id="sv_x_packing_type" value="<?php echo RemoveHtml($material_out_fp->packing_type->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($material_out_fp->packing_type->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_out_fp->packing_type->getPlaceHolder()) ?>"<?php echo $material_out_fp->packing_type->editAttributes() ?>>
</span>
<input type="hidden" data-table="material_out_fp" data-field="x_packing_type" data-value-separator="<?php echo $material_out_fp->packing_type->displayValueSeparatorAttribute() ?>" name="x_packing_type" id="x_packing_type" value="<?php echo HtmlEncode($material_out_fp->packing_type->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_out_fpsearch.createAutoSuggest({"id":"x_packing_type","forceSelect":false});
</script>
<?php echo $material_out_fp->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label class="<?php echo $material_out_fp_search->LeftColumnClass ?>"><span id="elh_material_out_fp_godown"><?php echo $material_out_fp->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $material_out_fp_search->RightColumnClass ?>"><div<?php echo $material_out_fp->godown->cellAttributes() ?>>
			<span id="el_material_out_fp_godown">
<?php
$wrkonchange = "" . trim(@$material_out_fp->godown->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_out_fp->godown->EditAttrs["onchange"] = "";
?>
<span id="as_x_godown" class="text-nowrap" style="z-index: 8880">
	<input type="text" class="form-control" name="sv_x_godown" id="sv_x_godown" value="<?php echo RemoveHtml($material_out_fp->godown->EditValue) ?>" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($material_out_fp->godown->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_out_fp->godown->getPlaceHolder()) ?>"<?php echo $material_out_fp->godown->editAttributes() ?>>
</span>
<input type="hidden" data-table="material_out_fp" data-field="x_godown" data-value-separator="<?php echo $material_out_fp->godown->displayValueSeparatorAttribute() ?>" name="x_godown" id="x_godown" value="<?php echo HtmlEncode($material_out_fp->godown->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_out_fpsearch.createAutoSuggest({"id":"x_godown","forceSelect":false});
</script>
<?php echo $material_out_fp->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->quantity_avg_act->Visible) { // quantity_avg_act ?>
	<div id="r_quantity_avg_act" class="form-group row">
		<label class="<?php echo $material_out_fp_search->LeftColumnClass ?>"><span id="elh_material_out_fp_quantity_avg_act"><?php echo $material_out_fp->quantity_avg_act->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity_avg_act" id="z_quantity_avg_act" value="="></span>
		</label>
		<div class="<?php echo $material_out_fp_search->RightColumnClass ?>"><div<?php echo $material_out_fp->quantity_avg_act->cellAttributes() ?>>
			<span id="el_material_out_fp_quantity_avg_act">
<div id="tp_x_quantity_avg_act" class="ew-template"><input type="radio" class="form-check-input" data-table="material_out_fp" data-field="x_quantity_avg_act" data-value-separator="<?php echo $material_out_fp->quantity_avg_act->displayValueSeparatorAttribute() ?>" name="x_quantity_avg_act" id="x_quantity_avg_act" value="{value}"<?php echo $material_out_fp->quantity_avg_act->editAttributes() ?>></div>
<div id="dsl_x_quantity_avg_act" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $material_out_fp->quantity_avg_act->radioButtonListHtml(FALSE, "x_quantity_avg_act") ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->max_qty->Visible) { // max_qty ?>
	<div id="r_max_qty" class="form-group row">
		<label for="x_max_qty" class="<?php echo $material_out_fp_search->LeftColumnClass ?>"><span id="elh_material_out_fp_max_qty"><?php echo $material_out_fp->max_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_max_qty" id="z_max_qty" value="="></span>
		</label>
		<div class="<?php echo $material_out_fp_search->RightColumnClass ?>"><div<?php echo $material_out_fp->max_qty->cellAttributes() ?>>
			<span id="el_material_out_fp_max_qty">
<input type="text" data-table="material_out_fp" data-field="x_max_qty" name="x_max_qty" id="x_max_qty" size="30" placeholder="<?php echo HtmlEncode($material_out_fp->max_qty->getPlaceHolder()) ?>" value="<?php echo $material_out_fp->max_qty->EditValue ?>"<?php echo $material_out_fp->max_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label for="x_packets" class="<?php echo $material_out_fp_search->LeftColumnClass ?>"><span id="elh_material_out_fp_packets"><?php echo $material_out_fp->packets->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packets" id="z_packets" value="="></span>
		</label>
		<div class="<?php echo $material_out_fp_search->RightColumnClass ?>"><div<?php echo $material_out_fp->packets->cellAttributes() ?>>
			<span id="el_material_out_fp_packets">
<input type="text" data-table="material_out_fp" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($material_out_fp->packets->getPlaceHolder()) ?>" value="<?php echo $material_out_fp->packets->EditValue ?>"<?php echo $material_out_fp->packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $material_out_fp_search->LeftColumnClass ?>"><span id="elh_material_out_fp_quantity"><?php echo $material_out_fp->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $material_out_fp_search->RightColumnClass ?>"><div<?php echo $material_out_fp->quantity->cellAttributes() ?>>
			<span id="el_material_out_fp_quantity">
<input type="text" data-table="material_out_fp" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($material_out_fp->quantity->getPlaceHolder()) ?>" value="<?php echo $material_out_fp->quantity->EditValue ?>"<?php echo $material_out_fp->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $material_out_fp_search->LeftColumnClass ?>"><span id="elh_material_out_fp_dated"><?php echo $material_out_fp->dated->caption() ?></span>
		</label>
		<div class="<?php echo $material_out_fp_search->RightColumnClass ?>"><div<?php echo $material_out_fp->dated->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($material_out_fp->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($material_out_fp->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($material_out_fp->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($material_out_fp->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($material_out_fp->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($material_out_fp->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($material_out_fp->dated->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($material_out_fp->dated->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($material_out_fp->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_material_out_fp_dated">
<input type="text" data-table="material_out_fp" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($material_out_fp->dated->getPlaceHolder()) ?>" value="<?php echo $material_out_fp->dated->EditValue ?>"<?php echo $material_out_fp->dated->editAttributes() ?>>
<?php if (!$material_out_fp->dated->ReadOnly && !$material_out_fp->dated->Disabled && !isset($material_out_fp->dated->EditAttrs["readonly"]) && !isset($material_out_fp->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_out_fpsearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_dated d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_material_out_fp_dated" class="btw1_dated d-none">
<input type="text" data-table="material_out_fp" data-field="x_dated" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($material_out_fp->dated->getPlaceHolder()) ?>" value="<?php echo $material_out_fp->dated->EditValue2 ?>"<?php echo $material_out_fp->dated->editAttributes() ?>>
<?php if (!$material_out_fp->dated->ReadOnly && !$material_out_fp->dated->Disabled && !isset($material_out_fp->dated->EditAttrs["readonly"]) && !isset($material_out_fp->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_out_fpsearch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label for="x_process" class="<?php echo $material_out_fp_search->LeftColumnClass ?>"><span id="elh_material_out_fp_process"><?php echo $material_out_fp->process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		</label>
		<div class="<?php echo $material_out_fp_search->RightColumnClass ?>"><div<?php echo $material_out_fp->process->cellAttributes() ?>>
			<span id="el_material_out_fp_process">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_fp" data-field="x_process" data-value-separator="<?php echo $material_out_fp->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $material_out_fp->process->editAttributes() ?>>
		<?php echo $material_out_fp->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $material_out_fp->process->Lookup->getParamTag("p_x_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $material_out_fp_search->LeftColumnClass ?>"><span id="elh_material_out_fp_remarks"><?php echo $material_out_fp->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $material_out_fp_search->RightColumnClass ?>"><div<?php echo $material_out_fp->remarks->cellAttributes() ?>>
			<span id="el_material_out_fp_remarks">
<input type="text" data-table="material_out_fp" data-field="x_remarks" name="x_remarks" id="x_remarks" maxlength="255" placeholder="<?php echo HtmlEncode($material_out_fp->remarks->getPlaceHolder()) ?>" value="<?php echo $material_out_fp->remarks->EditValue ?>"<?php echo $material_out_fp->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->issue_to_sale->Visible) { // issue_to_sale ?>
	<div id="r_issue_to_sale" class="form-group row">
		<label for="x_issue_to_sale" class="<?php echo $material_out_fp_search->LeftColumnClass ?>"><span id="elh_material_out_fp_issue_to_sale"><?php echo $material_out_fp->issue_to_sale->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_to_sale" id="z_issue_to_sale" value="="></span>
		</label>
		<div class="<?php echo $material_out_fp_search->RightColumnClass ?>"><div<?php echo $material_out_fp->issue_to_sale->cellAttributes() ?>>
			<span id="el_material_out_fp_issue_to_sale">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_fp" data-field="x_issue_to_sale" data-value-separator="<?php echo $material_out_fp->issue_to_sale->displayValueSeparatorAttribute() ?>" id="x_issue_to_sale" name="x_issue_to_sale"<?php echo $material_out_fp->issue_to_sale->editAttributes() ?>>
		<?php echo $material_out_fp->issue_to_sale->selectOptionListHtml("x_issue_to_sale") ?>
	</select>
</div>
<?php echo $material_out_fp->issue_to_sale->Lookup->getParamTag("p_x_issue_to_sale") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->issue_to_godown->Visible) { // issue_to_godown ?>
	<div id="r_issue_to_godown" class="form-group row">
		<label for="x_issue_to_godown" class="<?php echo $material_out_fp_search->LeftColumnClass ?>"><span id="elh_material_out_fp_issue_to_godown"><?php echo $material_out_fp->issue_to_godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_to_godown" id="z_issue_to_godown" value="="></span>
		</label>
		<div class="<?php echo $material_out_fp_search->RightColumnClass ?>"><div<?php echo $material_out_fp->issue_to_godown->cellAttributes() ?>>
			<span id="el_material_out_fp_issue_to_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_fp" data-field="x_issue_to_godown" data-value-separator="<?php echo $material_out_fp->issue_to_godown->displayValueSeparatorAttribute() ?>" id="x_issue_to_godown" name="x_issue_to_godown"<?php echo $material_out_fp->issue_to_godown->editAttributes() ?>>
		<?php echo $material_out_fp->issue_to_godown->selectOptionListHtml("x_issue_to_godown") ?>
	</select>
</div>
<?php echo $material_out_fp->issue_to_godown->Lookup->getParamTag("p_x_issue_to_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->issue_to->Visible) { // issue_to ?>
	<div id="r_issue_to" class="form-group row">
		<label for="x_issue_to" class="<?php echo $material_out_fp_search->LeftColumnClass ?>"><span id="elh_material_out_fp_issue_to"><?php echo $material_out_fp->issue_to->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_to" id="z_issue_to" value="="></span>
		</label>
		<div class="<?php echo $material_out_fp_search->RightColumnClass ?>"><div<?php echo $material_out_fp->issue_to->cellAttributes() ?>>
			<span id="el_material_out_fp_issue_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_fp" data-field="x_issue_to" data-value-separator="<?php echo $material_out_fp->issue_to->displayValueSeparatorAttribute() ?>" id="x_issue_to" name="x_issue_to"<?php echo $material_out_fp->issue_to->editAttributes() ?>>
		<?php echo $material_out_fp->issue_to->selectOptionListHtml("x_issue_to") ?>
	</select>
</div>
<?php echo $material_out_fp->issue_to->Lookup->getParamTag("p_x_issue_to") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $material_out_fp_search->LeftColumnClass ?>"><span id="elh_material_out_fp_status"><?php echo $material_out_fp->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $material_out_fp_search->RightColumnClass ?>"><div<?php echo $material_out_fp->status->cellAttributes() ?>>
			<span id="el_material_out_fp_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_fp" data-field="x_status" data-value-separator="<?php echo $material_out_fp->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $material_out_fp->status->editAttributes() ?>>
		<?php echo $material_out_fp->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $material_out_fp_search->LeftColumnClass ?>"><span id="elh_material_out_fp_operator"><?php echo $material_out_fp->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $material_out_fp_search->RightColumnClass ?>"><div<?php echo $material_out_fp->operator->cellAttributes() ?>>
			<span id="el_material_out_fp_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_fp" data-field="x_operator" data-value-separator="<?php echo $material_out_fp->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $material_out_fp->operator->editAttributes() ?>>
		<?php echo $material_out_fp->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $material_out_fp->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $material_out_fp_search->LeftColumnClass ?>"><span id="elh_material_out_fp_datetime"><?php echo $material_out_fp->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $material_out_fp_search->RightColumnClass ?>"><div<?php echo $material_out_fp->datetime->cellAttributes() ?>>
			<span id="el_material_out_fp_datetime">
<input type="text" data-table="material_out_fp" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($material_out_fp->datetime->getPlaceHolder()) ?>" value="<?php echo $material_out_fp->datetime->EditValue ?>"<?php echo $material_out_fp->datetime->editAttributes() ?>>
<?php if (!$material_out_fp->datetime->ReadOnly && !$material_out_fp->datetime->Disabled && !isset($material_out_fp->datetime->EditAttrs["readonly"]) && !isset($material_out_fp->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_out_fpsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_fp->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label for="x_po" class="<?php echo $material_out_fp_search->LeftColumnClass ?>"><span id="elh_material_out_fp_po"><?php echo $material_out_fp->po->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po" id="z_po" value="="></span>
		</label>
		<div class="<?php echo $material_out_fp_search->RightColumnClass ?>"><div<?php echo $material_out_fp->po->cellAttributes() ?>>
			<span id="el_material_out_fp_po">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_fp" data-field="x_po" data-value-separator="<?php echo $material_out_fp->po->displayValueSeparatorAttribute() ?>" id="x_po" name="x_po"<?php echo $material_out_fp->po->editAttributes() ?>>
		<?php echo $material_out_fp->po->selectOptionListHtml("x_po") ?>
	</select>
</div>
<?php echo $material_out_fp->po->Lookup->getParamTag("p_x_po") ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$material_out_fp_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $material_out_fp_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$material_out_fp_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$material_out_fp_search->terminate();
?>